/* Written from scratch by Martin C. <flipflop@swipnet.se>
 * 
 * found any bugs?
 * want any improvement?
 * or just want to tell me you are running my program? :)
 * 
 * mail me..
 * i probably wont be too fast at adding improvements..
 * as i am almost always busy with something else..
 * and i like this thingy the way it is :-)
 * 
 * COMMING:
 * Multihost support.
 * detect portscans everywhere on the LAN.
 * requires some rewriting, so this will probably take
 * a while before you see.. :)
 * (and would eat memory like a hungry whore)
 * 
 * Trusted hosts
 * that we dont report at all if they scan
 * 
 * Any more ideas? :-)
 * 
 * except for such silly ideas as making this BUGFREE of course ;-)
 * 
 * fanmail is ALWAYS welcome..
 * 
 * okay.. now i mentioned my email all over this...
 * so just maybe i will actually get bug reports if there are any :-)
 *
 */

/*
  added a pid file and SIGHUP handler so that it is easy
  to rotate the log files from a crontab script
  Dec 1998      Skip Carter <skip@taygeta.com>
*/


#include <stdio.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <stdarg.h>
#include <limits.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <errno.h>

/* max number of hosts to check in the same time */
#define MAXATONCE 10

/* max number of connects to allow in CHK_INTERVAL seconds */
#define MAX_CONNECTS 50

/* set interval check in seconds */
#define CHK_SECONDS 15
#define CHK_INTERVAL CHK_SECONDS
/* the default settings allow 3 connects / seconds for 15 seconds
 * which is probably more than will be generated by just webreaders
 * and ftpclients and such.. BUT.. there are hosts that has
 * MANY users.. and since we only check IP addresses they could
 * trigger this if many users from that hosts visits yours
 * until I implement the trusted hosts option */


/* max number of ignores to keep */
#define MAX_IGNORE 100

/* number of seconds to ignore hosts
 * if we run out of entries we will exit and notify
 * sysadmin by mail   */
#define EXPIRE_IGNORE 600

/* how often to check for expired ignores */
#define EXPIRE_IGNORE_INTERVAL 30

/* path to mailer */
#define MAILER "/usr/sbin/sendmail"

/* this is where mail will be sent if I die for some reason 
 * this doesnt work on exactly everything yet, I will make it mail
 * on coredumps too sometime later on */
#define SYSADMIN "root"

/* Define this to the maximum --mail args you will need */
#define MAX_MAILCMD 100

/* PID File */
#define PIDFILE "/var/run/detectscan.pid"

/* do we want those configs to be in a config.h or even better,
 * in the Makefile ? .. nah.. not yet ;-) */


/* dont touch below this line :-) */
#define SUCCESS 0
#define FULL -2
#define EXIST -1
#define ADDED 10
#define REMOVED 20
#define FUCKALOT -4
#define NONE -5
#define FAILED -6
#define EXPIRED -7
#define IGNORED 1
#define NOT_IGNORED 0

#define SIG_RET void

#ifdef DEBUG
/* this generate too much output for having "just running" */
# define DEBUGNAME "detect.debug"
# undef EXPIRE_IGNORE
# define EXPIRE_IGNORE 20
# undef EXPIRE_IGNORE_INTERVAL
# define EXPIRE_IGNORE_INTERVAL 5
#endif

struct packet
{
   struct iphdr ip;
   struct tcphdr tcp;
   char buffer[8192];
}pkt;

struct exhost
{
   time_t start;
   unsigned long host;
   unsigned short connects;
   time_t connects_t[MAX_CONNECTS];
   unsigned short rports[MAX_CONNECTS];
   unsigned short ports[MAX_CONNECTS];
};

struct ignorehost
{
   time_t expire;
   unsigned long host;
};

/* Functions */
int add_exhost(unsigned long host);
int del_exhost(unsigned long host);
int add_exhostport(unsigned long host, unsigned short port, unsigned short rport);
int open_socket(void);
char *lookup(unsigned long host);
int do_ignore(unsigned long host);
int is_ignore(unsigned long host);
int init_ignore(void);
int expire_ignore(void);
void once_per_minute(void);
int show_ports(unsigned long host);
int exhost_triggertime(unsigned long host);
void usage(void);
void go_backgroundf(void);
void notify_exit_do_ignore(void);
void do_exit(char *msg);
int ts_fprintf(FILE *output, char *fmt, ...);
char *getmailto(void);
static SIG_RET restart_sig_handler(int s);
static SIG_RET exit_sig_handler(int s);
void exit_handler(void);
void kill_running_process(short mode);
void report_pid(void);
int check_pid(pid_t pid);
char *basename(char *path);
pid_t get_running_pid(void);
void write_pidfile(void);

/* Global thingys */
int dolookup=1; // do we want to lookup addr into names
int have=0; // Nr of hosts we have mallocd
struct exhost *hosts[MAXATONCE];
struct ignorehost ihosts[MAX_IGNORE];
FILE *lameout; // output thingy
char *logfile;
int go_background=0; /* this is set to 1 by --background option */
int hora=0;
unsigned long lasthostaddr=0;
char *lasthostres;
int timestamp=0;
char *mailto[MAX_MAILCMD]; /* Multiple --mail suport */
unsigned int mailto_len=0;
char *av0;

int main(int ac, char **av)
{
   int sock;
      
   lameout = stdout;
   logfile = NULL;
   av0=av[0];

   if (ac > 1)
     {
	int options;
	int curmail=0;
	
	mailto[0]  = NULL; // just to make sure
	
	/* Used options:
	   -h, --help
	   -k, --kill
	   -n, --no-resolve
	   -t, --timestamp
	   -f, --file
	   -m, --mail
	   -b, --background
	   -r, --report
	*/

	for (options=1; options < ac; options++)
	  {
	     if (!strcmp(av[options], "-h") || !strcmp(av[options], "--help"))
	       usage();
	     
	     if (!strcmp(av[options], "-k") || !strcmp(av[options], "--kill"))
	       {
		 kill_running_process(SIGTERM);
		 exit(0);
	       }
	     
	     if (!strcmp(av[options], "-r") || !strcmp(av[options], "--report"))
	       {
		 report_pid();
		 exit(0);
	       }

	     if (!strcmp(av[options], "-n") || !strcmp(av[options], "--no-resolve"))
	       dolookup=0;
	     
	     if (!strcmp(av[options], "-t") || !strcmp(av[options], "--timestamp"))
	       timestamp=1;
	     	     
	     if (!strcmp(av[options], "-f") || !strcmp(av[options], "--file"))
	       {
		  if (ac-options == 1)
		    {
		       printf("Option %s requires a filename\n", av[options]);
		       exit(1);
		    }
		  
		  printf("Output will go to %s\n", av[++options]);
		  lameout = fopen(logfile = av[options], "a");
		  go_background=1;
	       }
	     	     
	     if (!strcmp(av[options], "-m") || !strcmp(av[options], "--mail"))
	       {
		  if (ac-options == 1)
		    {
		       printf("Options %s requires an address\n", av[options]);
		       exit(1);
		    }
		  
		  printf("I will mail all detected scans to %s\n", av[++options]);
		  mailto[curmail] = (char *)malloc(sizeof(char *) * strlen(av[options]) + 1);
		  strcpy(mailto[curmail++], av[options]);
		  mailto_len += strlen(av[options]) + 1;
	       }
	     
	     if (!strcmp(av[options], "-b") || !strcmp(av[options], "--background"))
	       go_background=1;
	  }
     }
   
   /* Check if we're already running */
   if (check_pid(get_running_pid()))
     {
       printf("It seems we already have a process running... exiting\n");
       exit(0);
     }
   
   ts_fprintf(lameout, "Launching Scan-detector %s, by Martin C. <flipflop@swipnet.se>\n", VERSION);
   fprintf(lameout, "I will %sresolve hostnames.\n", dolookup == 0 ? "NOT " : "");
   fflush(lameout);


   /* install the restart signal handler */
   signal(SIGHUP, restart_sig_handler);
   
   /* and for exit signals */
   signal(SIGINT, exit_sig_handler);
   signal(SIGTERM, exit_sig_handler);
   
   
#ifdef DEBUG
   if (fileno(lameout) > 2)
     fclose(lameout);
   
   printf("Im in DEBUG mode\n");
   
   if (fileno(lameout) != fileno(stdout))
     fclose(lameout);

   /* overwrite last one */
   lameout = fopen(logname = DEBUGNAME, "w");
   if (lameout == NULL)
     {
	printf("Failed opening %s for Debugwriting\n", DEBUGNAME);
	exit(1);
     }
#else
   if (go_background == 1)
     go_backgroundf();
#endif

   atexit(exit_handler);   /* MUST be after going background !!! */
   write_pidfile();

   sock = open_socket();
   if (sock == FAILED)
     {
	perror("open_socket()");
	exit(1);
     }
      
   /* Set all ignore entries to 0 */
   init_ignore();
   
   while (1)
     {
	int status;
	
	bzero(&pkt, sizeof(struct packet));
	
	status = read(sock, (struct packet *)&pkt, sizeof(struct packet));
	if (status < 0)
	  {
	    if (errno != EINTR) ts_fprintf(lameout, "read():%s\n", strerror(errno));
	    continue;
	  }
	
	/* not a OPENING connection? then we dont want it */
	if (!pkt.tcp.syn || pkt.tcp.ack)
	  continue;
	
	/* expire is run whenever we receive a packet that has SYN && !ACK flag */
	status = expire_ignore();
	if (status > 0)
	  ts_fprintf(lameout, "---------------------------------------\nTotal Expired Ignores : %i\n\n", status);
	
	/* are we ignoring this host? */
	if (is_ignore(pkt.ip.saddr) == IGNORED)
	  continue;
	
	/* here starts some of the messy part :-) */
	switch (add_exhost(pkt.ip.saddr))
	  {
#ifdef DEBUG
	   case FULL:
	     ts_fprintf(lameout, "ERROR : add_exhost() - FULL\n");
	     break;
	     
	   case NONE:
	     ts_fprintf(lameout, "ERROR : add_exhost() - NONE (this should never happen!)\n");
	     break;
#endif
	     
	   case EXIST:
	     switch (add_exhostport(pkt.ip.saddr, pkt.tcp.dest, pkt.tcp.source))
	       {
#ifdef DEBUG
		case ADDED:
		  ts_fprintf(lameout, "Added %s:Local:%i-Remote:%i\n", lookup(pkt.ip.saddr), ntohs(pkt.tcp.dest), ntohs(pkt.tcp.source));
		  break;
		  
		case NONE:
		  ts_fprintf(lameout, "ERROR : No such host (%s) in exhost\n", lookup(pkt.ip.saddr));
		  break;
#endif
		  
		case FUCKALOT:
/* %u seconds used to be %lu seconds, but not supported by ts_fprintf */
		  ts_fprintf(lameout, "Warning : %s has connected over %i times in %u seconds (interval is %i)\n", lookup(pkt.ip.saddr), MAX_CONNECTS, time(0) - exhost_triggertime(pkt.ip.saddr), CHK_SECONDS);
		  show_ports(pkt.ip.saddr);
		  switch(do_ignore(pkt.ip.saddr))
		    {
#ifdef DEBUG
		     case EXIST:
		       ts_fprintf(lameout, "Oh no.. %s was already ignored, this is not working :(\n", lookup(pkt.ip.saddr));
		       break;

		     case NONE:
		       ts_fprintf(lameout, "No ignore entries free.\n");
		       break;
#endif
		       
		     case IGNORED:
		       ts_fprintf(lameout, "IGNORE : %s for %i seconds\n", lookup(pkt.ip.saddr), EXPIRE_IGNORE);
		       // no break here.. have to move on to them underneath
		    }
		  del_exhost(pkt.ip.saddr);
	       }
	     break;
	     
	   case ADDED:
	     ts_fprintf(lameout, "Added %s to memory\n", lookup(pkt.ip.saddr));
	     break;
	  
	   case REMOVED:
	     ts_fprintf(lameout, "Removed %s from memory\n", lookup(pkt.ip.saddr));
	     break;
	  }
	
	fflush(lameout);
     }
   
   return 0;
}

void exit_handler(void)
{
  unlink(PIDFILE);
}

static SIG_RET exit_sig_handler(int s)
{
  ts_fprintf(lameout, "Got an exit signal, %d\n", s);
  fclose(lameout);
  unlink(PIDFILE);
  exit(0);
}

/* handles a SIGHUP by closing the log file,
   opening it again, and sending message to it that
   a restart has occured.  This allows the log file to
   be periodically rotated.
*/
static SIG_RET restart_sig_handler(int s)
{
  if (fclose(lameout) == -1)
    return; /* in case we don't use a logfile - MC */
  lameout = fopen(logfile, "a");
  
  ts_fprintf(lameout, "Restarting Scan-detector %s, by Martin C. <flipflop@swipnet.se>\n", VERSION);
  fprintf(lameout, "I will %sresolve hostnames.\n", dolookup == 0 ? "NOT " : "");
  
  fflush(lameout);
  
  /* need to reinstall the handler */
  signal(SIGHUP, restart_sig_handler);
}

int open_socket(void)
{
   int sock;
      
   sock = socket(AF_INET, SOCK_RAW, 6);
   
   if (geteuid() != 0)
     printf("This program reuires root privilegies to work\n");
      
   if (sock < 0)
     return FAILED;
   else
     return sock;
}

/* 1 host only Cached lookup */
char *lookup(unsigned long host)
{
   struct in_addr addr;
   struct hostent *he;
   short failed=0;
   
   addr.s_addr = host;
      
   if (host == lasthostaddr)
     {
	if (dolookup)
	  return lasthostres;
	else
	  return inet_ntoa(addr);
     }
      
   he = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
   if (he == NULL)
     failed=1;
      
   /* if we dont want hostnames */
   if (dolookup && failed == 0)
     {
	char temp[strlen(he->h_name)+1];

	sprintf(temp, "%s", he->h_name);
	lasthostaddr=host;
	if (lasthostres)
	  free(lasthostres);
	lasthostres = (char *)malloc(strlen(temp)+1);
	memcpy(lasthostres, temp, strlen(temp)+1);
	return he->h_name;
     }
   else
     {
	char temp[50];
	if (lasthostres != NULL)
	  free(lasthostres);
	sprintf(temp, "%s", inet_ntoa(addr));
	lasthostaddr=host;
	lasthostres = (char *)malloc(sizeof(char *) * strlen(temp) + 1);
	memcpy(lasthostres, temp, strlen(temp)+1);
     return inet_ntoa(addr);
     }
}

int add_exhostport(unsigned long host, unsigned short port, unsigned short rport)
{
   int i;
      
   for (i=0; i <= MAXATONCE; i++)
     if (hosts[i] != NULL)
       if (hosts[i]->host == host)
     {
	if (time(0) - hosts[i]->start > CHK_SECONDS)
	  {
	     del_exhost(host);
	     return EXPIRED;
	  }
	
	if (hosts[i]->connects == MAX_CONNECTS)
	  return FUCKALOT;
	
	hosts[i]->connects_t[hosts[i]->connects] = time(0);
	hosts[i]->ports[hosts[i]->connects] = htons(port);
	hosts[i]->rports[hosts[i]->connects] = htons(rport);
	
	hosts[i]->connects++;
	
	return ADDED;
     }
   
   return NONE;
}

int add_exhost(unsigned long host)
{
   int i,ii;
   
   if (have == MAXATONCE)
     return FULL;
   
   for (i=0; i < have; i++)
     {
	if (hosts[i] == NULL)
	  continue;
	
	if (time(0) - hosts[i]->start > CHK_INTERVAL)
	  {
	     del_exhost(hosts[i]->host);
	     continue;
	  }
	
	if (host == hosts[i]->host)
	  return EXIST;
     }
   
   for (i=0; i <= have; i++)
     if (hosts[i] == NULL)
     {
	hosts[i] = (struct exhost *)malloc(sizeof(struct exhost));
		
	for (ii=0; ii <= MAX_CONNECTS; ii++)
	  {
	     hosts[i]->ports[ii] = 0;
	     hosts[i]->rports[ii] = 0;
	     hosts[i]->connects_t[ii] = 0;
	  }
	
	hosts[i]->host = host;
	hosts[i]->start = time(0);
	hosts[i]->connects = 0;
	
	/* add this connections port too .. or we would miss it */
	add_exhostport(host, pkt.tcp.dest, pkt.tcp.source);
	have++;
	
	return ADDED;
     }
   
   return NONE;
}

int del_exhost(unsigned long host)
{
   int i;
   
   for (i=0; i < have; i++)
     if (hosts[i] != NULL)
       if (hosts[i]->host == host)
	 {
	   free(hosts[i]);
	   hosts[i]=NULL;
	   have--;
	   
	   ts_fprintf(lameout, "Removed %s from memory\n", lookup(host));
	   return REMOVED;
	 }
   
   ts_fprintf(lameout, "Oh oh.. i fucked up.. failed to remove %s from memory\n", lookup(host));
   return NONE;
}

/* returns time when FIRST packet came from this host */
int exhost_triggertime(unsigned long host)
{
   int i;
   
   for (i=0; i < have; i++)
     if (hosts[i] != NULL)
       if (hosts[i]->host == host)
	 return hosts[i]->start;

   return NONE;
}

int do_ignore(unsigned long host)
{
   int i;
   
   if (is_ignore(host) == IGNORED)
     return EXIST; // Should probably never happen
   
   
   for (i=0; i < MAX_IGNORE; i++)
     if (ihosts[i].host == 0) /* this is static */
     {
	ihosts[i].host = host;
	ihosts[i].expire = time(0) + EXPIRE_IGNORE;
	return IGNORED;
     }
   
   notify_exit_do_ignore();
   return NONE; /* not reached */
}

int is_ignore(unsigned long host)
{
   int i;
   
   for (i=0; i < MAX_IGNORE; i++)
     if (ihosts[i].host == host)
       return IGNORED;
   
   return NOT_IGNORED;
}

int init_ignore(void)
{
   int i;
   
   for (i=0; i < MAX_IGNORE; i++)
     {
	ihosts[i].expire = 0;
	ihosts[i].host = 0;
     }
      
   return SUCCESS;
}

int expire_ignore(void)
{
   time_t chk_time;
   int i;
   int count=0;
   
   chk_time = time(0);
   
   for (i=0; i < MAX_IGNORE; i++)
     if (ihosts[i].expire < chk_time && ihosts[i].expire != 0)
     {
	ts_fprintf(lameout, "Expiring : %s\n", lookup(ihosts[i].host));
		
	ihosts[i].expire = 0;
	ihosts[i].host = 0;
	count++;
     }
   
   return count;
}

int show_ports(unsigned long host)
{
   int i,ii;
   char temp[1024];
   int nr=1;
   
   for (i=0; i < have; i++)
     if (hosts[i] != NULL)
       if (hosts[i]->host == host)
     {
	ts_fprintf(lameout, "FROM    : %s\n", lookup(host));
	fprintf(lameout, "NR\tDATE\t\t\t\tLOCAL\tREMOTE\n");
	
	for (ii=0; ii < MAX_CONNECTS; ii++)
	  if (hosts[i]->ports[ii] > 0)
	  {
	     bzero(temp, 1024);
	     sprintf(temp, "%s", ctime(&hosts[i]->connects_t[ii]));
	     temp[strlen(temp)-1]='\0';
	     fprintf(lameout, "%i\t:%s\t%i\t%i\n", nr++, temp, hosts[i]->ports[ii], hosts[i]->rports[ii]);
	  }
	
	fprintf(lameout, "\n[CUT]\n");
	fflush(lameout);
	if (mailto == NULL)
	  return SUCCESS;
     }
   
   /* set it to 1 again so it wont look stupid in the mail */
   nr = 1;
   if (mailto != NULL)
     {
	FILE *mail;
	char callname[strlen(MAILER)+mailto_len];
	time_t tmp_time;
	char *hora;
	
	tmp_time = time(0);
	
	hora = getmailto();
	sprintf(callname, "%s %s", MAILER, hora);
	free(hora);
	mail = popen(callname, "w");
	
	fprintf(mail, "From: <scandetect@localhost>\n");
	fprintf(mail, "To: <sysadmin>\n");
	fprintf(mail, "Date: %s", ctime(&tmp_time));
	fprintf(mail, "Subject: Portscan from %s\n", lookup(host));
	
	fprintf(mail, "\n\r\n\r");
	
	for (i=0; i < have; i++)
	  if (hosts[i]->host == host)
	  {
	     fprintf(mail, "FROM    : %s\n", lookup(host));
	     fprintf(mail, "NR\tDATE\t\t\t\tLOCAL\tREMOTE\n");
	     
	     for (ii=0; ii < MAX_CONNECTS; ii++)
	       if (hosts[i]->ports[ii] > 0)
	       {
		  bzero(temp, 1024);
		  sprintf(temp, "%s", ctime(&hosts[i]->connects_t[ii]));
		  temp[strlen(temp)-1]='\0';
		  fprintf(mail, "%i\t:%s\t%i\t%i\n", nr++, temp, hosts[i]->ports[ii], hosts[i]->rports[ii]);
	       }
	     
	     fprintf(mail, "\n[CUT]\n");
	     pclose(mail);
	     
	     return SUCCESS;
	  }
     }
      
   return FAILED;
}

void usage(void)
{
   printf("Scan-detector %s by Martin C. <flipflop@swipnet.se>\n\n", VERSION);
   printf("--help                 see this screen\n");
   printf("-n, --no-resolve       don't resolve addresses into hostnames\n");
   printf("-k, --kill             kill a running detectscan process\n");
   printf("-r, --report           report running process pid\n");
   printf("-f FILE, --file FILE   output to FILE\n");
   printf("-m ADDR, --mail ADDR   send \"critical\" stuff to mailaddr\n");
   printf("-b, --background       fall into background\n");
   printf("-t, --timestamp        timestamp MOST events.\n");
   
   exit(1);
}

void go_backgroundf(void)
{
   int pid;
   
   pid = fork();
   if (pid != 0)
     {
       ts_fprintf(stdout, "Falling into background as pid %i\n", pid);
       exit(1);
     }

   /* We now close stdout/stderr from write_pidfile() function */
}

void notify_exit_do_ignore(void)
{
   FILE *mail;
   char callname[strlen(MAILER)+mailto_len];
   time_t tmp_time;
   tmp_time = time(0);
   
   if(mailto == NULL)
     {
	mailto[0] = (char *)malloc(sizeof(char *) * strlen(SYSADMIN) + 1);
	strcpy(mailto[0], SYSADMIN);
     }
   
   /* need not free this one, since we exit() anyway */
   sprintf(callname, "%s %s", MAILER, getmailto());
   mail = popen(callname, "w");
   fprintf(mail, "From: <scandetect@localhost>\n");
   fprintf(mail, "To: <sysadmin>\n"); /* just looks nicer with headers */
   fprintf(mail, "Date: %s", ctime(&tmp_time));
   fprintf(mail, "Subject: PORTSCAN DAEMON DYING\n");
   fprintf(mail, "\n\r\n\r");
   fprintf(mail, "I have died due to lack of ignore entries\n");
   fprintf(mail, "This because i would have flooded you with\n");
   fprintf(mail, "emails otherwise. Consider recompiling with\n");
   fprintf(mail, "a higher MAX_IGNORE value, and/or lower EXPIRE_IGNORE.\n");
   pclose(mail);
   
   exit(1);
}

void do_exit(char *msg)
{
   if (msg != NULL)
     ts_fprintf(lameout, "%s\n", msg);
   
   exit(0);
}

/* timestamped fprintf */
int ts_fprintf(FILE *output, char *fmt, ...)
{
  va_list ap;
  char temp[1024];

  if (fileno(output) < 0)
    return 0;
  
  if (timestamp)
    {
      time_t tp;
      
      tp = time(0);
      sprintf(temp, "%s", ctime(&tp));
      temp[strlen(temp)-1]='\0';
      
      fprintf(output, "%s : ", temp);
    }
  
  va_start(ap, fmt);
  
  while(*fmt)
    switch(*fmt)
      {
      case '%':
	*fmt++;
	switch(*fmt)
	  {
	  case 's':
	    fprintf(output, "%s", va_arg(ap, char *));
	    *fmt++;
	    break;
	    
	  case 'c':
	    fprintf(output, "%c", va_arg(ap, char));
	    *fmt++;
	    break;
	    
	    /* %u added by KJS */
	  case 'u':
	    fprintf(output, "%u", va_arg(ap, char));
	    *fmt++;
	    break;
	    
	  case 'i':
	    fprintf(output, "%i", va_arg(ap, int));
	    *fmt++;
	    break;
	    
	  case 'd':
	    fprintf(output, "%d", va_arg(ap, int));
	    *fmt++;
	    break;
	  }
	break;
	
      default:
	fprintf(output, "%c", *fmt);
	*fmt++;
      }
  va_end(ap);
  
  return 0;
}

char *getmailto(void)
{
  int i,ii;
  char *temp;
  int p=0;

  temp = (char *)calloc(mailto_len+1, sizeof(char *));

  for (i = 0; mailto[i] != NULL; i++)
    {
      for (ii = 0; mailto[i][ii] != '\0'; ii++)
	memcpy(temp+(p++), (char *)&mailto[i][ii], 1);
      memcpy(temp+(p++), " ", 1);
    }

  return temp;
}

void kill_running_process(short mode)
{
  pid_t pid = get_running_pid();
  
  if (pid == 0)
    {
      fprintf(stderr, "Seems no process are currently being run.\n"); /* To not confuse bash scripts that use stdout */
      return;
    }

  if (!check_pid(pid))
    {
      unlink(PIDFILE);
      exit(0);
    }
  
  if (mode == 0)
    printf("%i\n", pid);
  else
    kill(pid, mode);
}

void report_pid(void)
{
  kill_running_process(0);
}

int check_pid(pid_t pid)
{
  FILE *file;
  char buffer[2048];
  char path[1024];
  int status=1;

  if(pid == 0)
    return 0;

  snprintf(path, sizeof(path)-1, "/proc/%i/cmdline", pid);
  
  file = fopen(path, "r");
  if (!file)
    status=0;

  if (status)
    {
      fgets(buffer, sizeof(buffer)-1, file);
      fclose(file);
      status=!strcmp(basename(buffer), basename(av0));
    }

  if (status == 0)
    ts_fprintf(lameout, "%s is stale, removing.\n", PIDFILE);

  return status;
}

char *basename(char *path)
{
  char *temp;

  temp = rindex(path, '/');
  
  if (temp)
    return temp+1;
  else
    return path;
}

pid_t get_running_pid(void)
{
  FILE *file;
  pid_t pid;
  
  file = fopen(PIDFILE, "r");
  if (!file)
    return 0;
      
  if (fscanf(file, "%d", &pid) != 1)
    {
      printf("Bad data in %s\n", PIDFILE);
      return 0;
    }
  
  fclose(file);

  return pid;
}

void write_pidfile(void)
{
  FILE *fp;
  int pid=getpid();
  
  fp = fopen(PIDFILE, "w");
  if (fp == NULL)
    ts_fprintf(stdout, "Could not open PID file %s\n", PIDFILE);
  else
    {
      fprintf(fp, "%d\n", pid);
      fclose(fp);
    }

  if (go_background) /* If we dont use a logfile, dont show any messages at all */
    {
      fclose(stdout);
      fclose(stderr);
    }
}
