/*
 * this code is Copyright Colten Edwards (c) 96
 */
 
#include "irc.h"
#include "struct.h"
#include "commands.h"
#include "list.h"
#include "hook.h"
#include "ignore.h"
#include "ircaux.h"
#include "output.h"
#include "screen.h"
#include "server.h"
#include "window.h"
#include "who.h"
#include "whowas.h"
#include "vars.h"
#include "userlist.h"
#include "misc.h"
#include "hash2.h"
#include "cset.h"

int defban = 2;

static char *mode_buf = NULL;
static int mode_len = 0;

static char *mode_str = NULL;
static char *user = NULL;
static int mode_str_len = 0;
static int push_len = 0;
static char plus_mode[20] = "\0";

void add_mode_buffer( char *buffer, int mode_str_len)
{
	
	malloc_strcat(&mode_buf, buffer);
	mode_len += push_len;
}

void flush_mode(ChannelList *chan)
{
	
	if (mode_buf)
		my_send_to_server(chan?chan->server:from_server, "%s", mode_buf);
	new_free(&mode_buf);
	mode_len = 0;
}

int delay_flush_all (void *arg)
{
char buffer[BIG_BUFFER_SIZE+1];
char * old_arg=(char *)arg;
char * args = NULL;
char * serv_num = NULL;
char * channel = NULL;
int this_server = from_server;

	
	channel = next_arg(args, &args);
	if ((serv_num = next_arg(args, &args)))
		from_server = atoi(serv_num);
        if (channel && *channel && mode_str && user)
        {
                sprintf(buffer, "MODE %s %s%s %s\r\n", channel, plus_mode, mode_str, user);
                push_len = strlen(buffer);
                add_mode_buffer(buffer, push_len);
                mode_str_len = 0;
                new_free(&mode_str);
                new_free(&user);
                memset(plus_mode, 0, sizeof(plus_mode));
                push_len = 0;
        }
        flush_mode(NULL);
	new_free(&old_arg);
	from_server = this_server;
	return 0;
}

void flush_mode_all(ChannelList *chan)
{
char buffer[BIG_BUFFER_SIZE+1];

	
	if (mode_str && user)
	{
		sprintf(buffer, "MODE %s %s%s %s\r\n", chan->channel, plus_mode, mode_str, user);
		push_len = strlen(buffer);
		add_mode_buffer(buffer, push_len);
		mode_str_len = 0;
		new_free(&mode_str);
		new_free(&user);
		memset(plus_mode, 0, sizeof(plus_mode));
		push_len = 0;
	}
	flush_mode(chan);
}


void add_mode(ChannelList *chan, char *mode, int plus, char *nick, char *reason, int max_modes)
{
char buffer[BIG_BUFFER_SIZE+1];
/*
KICK $C nick :reason
MODE $C +/-o nick
MODE $C +/-b userhost
*/

	
	if (mode_len >= (IRCD_BUFFER_SIZE-100))
	{
		flush_mode(chan);
		push_len = 0;
	}

	if (reason)
	{
		sprintf(buffer, "KICK %s %s :%s\r\n", chan->channel, nick, reason);
		push_len = strlen(buffer);
		add_mode_buffer(buffer, push_len);
	}
	else
	{
		mode_str_len++;
		malloc_strcat(&mode_str,plus?"+":"-");	
		malloc_strcat(&mode_str, mode);
		malloc_strcat(&user, nick);
		malloc_strcat(&user, " ");
		if (mode_str_len >= max_modes)
		{
			sprintf(buffer, "MODE %s %s %s\r\n", chan->channel, mode_str, user);
			push_len = strlen(buffer);
			add_mode_buffer(buffer, push_len);
			new_free(&mode_str);
			new_free(&user);
			memset(plus_mode, 0, sizeof(plus_mode));
			mode_str_len = push_len = 0;
		}
	}
}


BUILT_IN_COMMAND(fuckem)
{
char c;
ChannelList *chan;
int server;
char buffer[BIG_BUFFER_SIZE];
BanList *Bans;
	if (!(chan = prepare_command(&server, NULL, NEED_OP)))
		return;
	for (Bans = chan->bans; Bans; Bans = Bans->next)
		add_mode(chan, "b", 0, Bans->ban, NULL, get_int_var(NUM_BANMODES_VAR));
	for (c = 'a'; c <= 'z'; c++)
	{
		sprintf(buffer, "*!*@*%c*", c);
		add_mode(chan, "b", 1, buffer, NULL, get_int_var(NUM_BANMODES_VAR));
	}         
	flush_mode_all(chan);
}


/*
 * Lamer Kick!   Kicks All UnOpped People from Current Channel        
 */
BUILT_IN_COMMAND(LameKick)
{
	char *channel = NULL;
	ChannelList *chan;
	NickList *tmp;
	char	*buffer = NULL;
	char	*buf2 = NULL;
	int	old_server = from_server;

	
	if (args && *args && is_channel(args))
		channel = next_arg(args, &args);	
	if ((chan = prepare_command(&from_server, channel, NEED_OP)))
	{
		int len_buffer =  0;
		malloc_sprintf(&buffer, "KICK %s %%s :<\002BX\002-LK> %s", chan->channel, args && *args? args:"");
		len_buffer = strlen(buffer) + 2;
		for (tmp = next_nicklist(chan, NULL); tmp; tmp = next_nicklist(chan, tmp))
		{
			int level= 0;
			if (tmp->userlist)
				level = ((tmp->userlist->flags | 0xff) & PROT_ALL);
			if (!tmp->chanop && !tmp->voice && ((tmp->userlist && !level) || !tmp->userlist))
			{
				if (buf2)
					buf2 = m_3cat(&buf2, ",", tmp->nick);
				else
					malloc_strcat(&buf2, tmp->nick);
				if ((strlen(buf2) + len_buffer) >= (IRCD_BUFFER_SIZE - (NICKNAME_LEN + 5)))
				{
					send_to_server(buffer, buf2);
					new_free(&buf2);
				}
			}
		}
		if (buf2)
			send_to_server(buffer, buf2);
		new_free(&buffer);
		new_free(&buf2);
		say("Sent the Server all the Lamer Kicks, Sit back and Watch!");
	}
	from_server = old_server;
}

static void shitlist_erase(ShitList **clientlist)
{
	ShitList	*Client, *tmp;
	
	for (Client = *clientlist; Client;)
	{
		new_free(&Client->filter);
		new_free(&Client->reason);
		tmp = Client->next;
		new_free((char **)&Client);
		Client = tmp;
	}
	*clientlist = NULL;
}

static char *screw(char *user)
{
char *p;
	for (p = user; p && *p;)
	{
		switch(*p)
		{
			case '.':
			case '*':
			case '@':
			case '!':
				p+=1;
				break;
			default:
				*p = '?';
				if (*(p+1) && *(p+2))
					p+=2;
				else
					p++;
		}
	}
	return user;
}

char * ban_it(char *nick, char *user, char *host, char *ip)
{
static char banstr[BIG_BUFFER_SIZE/4+1];
char *tmpstr = NULL;
char *t = user;
char *t1 = user;
	
	*banstr = 0;
	while (strlen(t1)>9)
		t1++;
	t1 = clear_server_flags(t1);
	switch (defban) 
	{
		case 7:
			if (ip)
			{
				sprintf(banstr, "*!*@%s", cluster(ip));
				break;
			}
		case 2: /* Better 	*/
			sprintf(banstr, "*!*%s@%s", t1, cluster(host));
			break;
		case 3: /* Host 	*/
			sprintf(banstr, "*!*@%s", host);
			break;
		case 4: /* Domain	*/
			sprintf(banstr, "*!*@*%s", strrchr(host, '.'));
			break;
		case 5: /* User		*/
			sprintf(banstr, "*!%s@%s", t, cluster(host));
			break;
		case 6: /* Screw 	*/
			malloc_sprintf(&tmpstr, "*!*%s@%s", t1, host);
			strcpy(banstr, screw(tmpstr));
			new_free(&tmpstr);
			break;
		case 1:	/* Normal 	*/
		default:
			sprintf(banstr, "%s!*%s@%s", nick, t1, host);
			break;
	}
	return banstr;
}

void userhost_unban(UserhostItem *stuff, char *nick1, char *args)
{
char *tmp;
ChannelList *chan;
char *channel = NULL;
BanList *bans;

char *host = NULL;
char *ip_str = NULL;
WhowasList *whowas = NULL;
NickList *n = NULL;
int count = 0;
int old_server = from_server;

	
	if (!stuff || !stuff->nick || !nick1 || 
		!strcmp(stuff->user, "<UNKNOWN>") || 
		my_stricmp(stuff->nick, nick1))
	{
		if (nick1 && (whowas = check_whowas_nick_buffer(nick1, args, 0)))
		{
			malloc_sprintf(&host, "%s!%s", whowas->nicklist->nick, whowas->nicklist->host);
			bitchsay("Using WhoWas info for unban of %s ", nick1);
			n = whowas->nicklist;
		}
		else if (nick1)
		{
			bitchsay("No match for the unban of %s on %s", nick1, args);
			return;
		}
		if (!nick1)
			return;
	}
	else
	{
		tmp = clear_server_flags(stuff->user);
		malloc_sprintf(&host, "%s!%s@%s",stuff->nick, tmp, stuff->host); 
	}

	channel = next_arg(args, &args);
	if (args && *args)
		from_server = atoi(args);
	if (!(chan = prepare_command(&from_server, channel, NEED_OP)))
	{
		new_free(&host);
		return;
	}
	if (!n)
		n = find_nicklist_in_channellist(stuff->nick, chan, 0);

	if (n && n->ip)
	{
		size_t len = strlen(n->nick)+strlen(n->host)+strlen(n->ip)+10;
		ip_str = alloca(len); 
		*ip_str = 0;
		strmopencat(ip_str, len, stuff->nick, "!", stuff->user, "@", n->ip, NULL);
	}
	for (bans = chan->bans; bans; bans = bans->next)
	{
		if (!bans->sent_unban && (wild_match(bans->ban, host) || (ip_str && wild_match(bans->ban, ip_str))) )
		{
			add_mode(chan, "b", 0, bans->ban, NULL, get_int_var(NUM_BANMODES_VAR));
			bans->sent_unban++;
			count++;
		}			
	}	

	flush_mode_all(chan);
	if (!count)
		bitchsay("No match for Unban of %s on %s", nick1, args);
	new_free(&host);
	from_server = old_server;
}


void userhost_ban(UserhostItem *stuff, char *nick1, char *args)
{
	char *temp;
	char *str= NULL;
	char *channel;
	ChannelList *c = NULL;
	NickList *n = NULL;

	char *ob = "-o+b";
	char *b = "+b";

	char *host = NULL, *nick = NULL, *user = NULL, *chan = NULL;
	WhowasList *whowas = NULL;
		
	int fuck = 0;
	int set_ignore = 0;
	
	
	channel = next_arg(args, &args);
	temp = next_arg(args, &args);

	fuck = !my_stricmp("FUCK", args);
	set_ignore = !my_stricmp("BKI", args);
	
	if (!stuff || !stuff->nick || !nick1 || !strcmp(stuff->user, "<UNKNOWN>") || my_stricmp(stuff->nick, nick1))
	{
		if (nick1 && channel && (whowas = check_whowas_nick_buffer(nick1, channel, 0)))
		{
			nick = whowas->nicklist->nick;
			user = m_strdup(clear_server_flags(whowas->nicklist->host));
			host = strchr(user, '@');
			*host++ = 0;
			bitchsay("Using WhoWas info for ban of %s ", nick1);
			n = whowas->nicklist;
		}
		else if (nick1)
		{
			bitchsay("No match for the %s of %s on %s", fuck ? "Fuck":"Ban", nick1, channel);
			return;
		}
	} 
	else
	{
		nick = stuff->nick;
		user = m_strdup(clear_server_flags(stuff->user));
		host = stuff->host;
	}

	if (!(my_stricmp(nick, get_server_nickname(from_server))))
	{
		bitchsay("Try to kick yourself again!!");
		new_free(&user);
		return;
	}

	if (is_on_channel(channel, from_server, nick))
		chan = channel;
	c = lookup_channel(channel, from_server, 0);
	if (c && !n)
		n = find_nicklist_in_channellist(nick, c, 0);
	send_to_server("MODE %s %s %s", channel, chan ? ob : b, ban_it(nick, user, host, (n && n->ip)?n->ip:NULL));
	if (fuck)
	{
		malloc_sprintf(&str, "%s!*%s@%s %s 3 Auto-Shit", nick, user, host, channel);
		add_shit(NULL, str, NULL, NULL);
		new_free(&str);
	} else if (set_ignore)
		ignore_nickname(ban_it("*", user, host, NULL)	, IGNORE_ALL, 0);
	new_free(&user);
}

BUILT_IN_COMMAND(multkick)
{
	char *to = NULL, *temp = NULL, *reason = NULL;
	ChannelList *chan;
	int server = from_server;
	int	filter = 0;
	

	if (command && *command)
		filter = 1;
		
	if (!(to = next_arg(args, &args)))
		to = NULL;
	
	if (to && !is_channel(to))
	{
		temp = to;
		if (args && *args)
			*(temp + strlen(temp)) = ' ';
		to = NULL;
	}
	else
		temp = args;
		
	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (!temp || !*temp)
	{
		userage(command?command:"multikick", helparg);
		return;
	}
	reason = strchr(temp, ':');

	if (reason)
		*reason++ = 0;

	if (!reason || !*reason)
		reason = get_reason(NULL, NULL);

	while (temp && *temp)
	{
		my_send_to_server(server, "KICK %s %s :\002%s\002", chan->channel,
			       next_arg(temp, &temp), reason);
	}
}

BUILT_IN_COMMAND(massdeop)
{
	ChannelList *chan;

register NickList *nicks;

	char *spec, *rest, *to;
	int maxmodes, count, all = 0;
	char	buffer[BIG_BUFFER_SIZE + 1];
	int isvoice = 0;
	int old_server = from_server;
			
	
	maxmodes = get_int_var(NUM_OPMODES_VAR);

	if (command && !my_stricmp(command, "mdvoice"))
		isvoice = 1;
	
	rest = NULL;
	spec = NULL;

	if (!(to = next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}
	if (!(chan = prepare_command(&from_server, to, NEED_OP)))
		return;


	if (!spec && !(spec = next_arg(args, &args)))
		spec = "*!*@*";
	if (*spec == '-')
	{
		rest = spec;
		spec = "*!*@*";
	}
	else
		rest = args;
	if (rest && !my_stricmp(rest, "-all"))
		all = 1;

	count = 0;
	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		sprintf(buffer, "%s!%s", nicks->nick, nicks->host);
		if ((all || (!isvoice && nicks->chanop) || (isvoice && nicks->voice)) &&
		    my_stricmp(nicks->nick, get_server_nickname(from_server)) &&
		    wild_match(spec, buffer))
		{
			add_mode(chan, isvoice? "v":"o", 0, nicks->nick, NULL, maxmodes);
			count++;
		}

	}
	flush_mode_all(chan);
	from_server = old_server;
	if (!count)
		say("No matches for %s of %s on %s", command?command:"massdeop", spec, chan->channel);
}

BUILT_IN_COMMAND(doop)
{
	char	*to = NULL, 
		*temp = NULL;
ChannelList	*chan = NULL;
	int	count,
		max = get_int_var(NUM_OPMODES_VAR);
	char	buffer[BIG_BUFFER_SIZE + 1];
	int	old_server = from_server;
	int	voice = 0;
	
	
	if (command)
		voice = 1;
	count = 0;
	*buffer = 0;

	if (!(to = next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to))
	{
		temp = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&from_server, to, NEED_OP)))
		return;

	if (!temp)
		temp = next_arg(args, &args);

	while (temp && *temp)
	{
		count++;
		add_mode(chan, voice?"v":"o", 1, temp, NULL, max);
		temp = next_arg(args, &args);
	}
	flush_mode_all(chan);
	from_server = old_server;
}

BUILT_IN_COMMAND(dodeop)
{
	char *to = NULL, *temp;
	int count, max;
	ChannelList *chan;
	char	buffer[BIG_BUFFER_SIZE + 1];
	int isvoice = 0;
	int server = from_server;
		
	
	count = 0;
	temp = NULL;
	max = get_int_var(NUM_OPMODES_VAR);

	*buffer = 0;

	if (command && (!my_stricmp(command, "unvoice") || !my_stricmp(command, "devoice")))
		isvoice = 1;
	
	if (!(to = next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to))
	{
		temp = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (!temp)
		temp = next_arg(args, &args);

	while (temp && *temp)
	{
		count++;
		add_mode(chan, isvoice?"v":"o", 0, temp, NULL, max);
		temp = next_arg(args, &args);
	}
	flush_mode_all(chan);
}

BUILT_IN_COMMAND(massop)
{
	ChannelList *chan;
	
	register NickList *nicks;

	char	*to = NULL, 
		*spec, 
		*rest;
	char	buffer[BIG_BUFFER_SIZE + 1];
	
	int	maxmodes = get_int_var(NUM_OPMODES_VAR), 
		count, 
		i, 
		all = 0,
		massvoice =0;
	int	server = 0;
		
	
	if (command)
		massvoice = 1;

	rest = NULL;
	spec = NULL;

	if (!(to = next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to) )
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (!spec && !(spec = next_arg(args, &args)))
		spec = "*!*@*";
	if (*spec == '-')
	{
		rest = spec;
		spec = "*!*@*";
	}
	else
		rest = args;

	if (rest && !my_stricmp(rest, "-all"))
		all = 1;

	count = 0;
	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		i = 0;
		sprintf(buffer, "%s!%s", nicks->nick, nicks->host);
		if ((my_stricmp(nicks->nick, get_server_nickname(from_server)) && wild_match(spec, buffer)))
		{
			if ((massvoice && !nicks->voice && !nicks->chanop) || !nicks->chanop)
			{
				add_mode(chan, massvoice?"v":"o", 1, nicks->nick, NULL, maxmodes);
				count++;
			}
		}
	}
	flush_mode_all(chan);
	if (!count)
		say("No matches for %s of %s on %s", command? command : "massop", spec, chan->channel);
}

BUILT_IN_COMMAND(masskick)
{
	ChannelList *chan;
register NickList *nicks;
	ShitList *masskick_list = NULL, *new = NULL;
	char *to, *spec, *rest, *buffer = NULL, *q;
	int server = from_server;

	int all = 0;
	int ops = 0;
	
	
	rest = NULL;
	spec = NULL;

	if (!(to = next_arg(args, &args)))
		to = NULL;

	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (spec && !strncmp(spec, "-all", 4))
	{
		all = 1;
		spec =  next_arg(args, &args);
	}

	if (spec && !strncmp(spec, "-ops", 4))
	{
		ops = 1;
		spec = next_arg(args, &args);
	}
	if (!spec)
	{
/*		userage();*/
		return;
	}
	rest = args;
	if (rest && !*rest)
		rest = NULL;

	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		int doit = 0;
		q = clear_server_flags(nicks->host);
		malloc_sprintf(&buffer, "%s!*%s", nicks->nick, q);		
		if (all)
			doit = 1;
		else if (ops && nicks->chanop)
			doit = 1;
		else if (!nicks->chanop)
			doit = 1;
		else if (get_cset_int_var(chan->csets, KICK_OPS_CSET))
			doit = 1;
		if (doit && !isme(nicks->nick) && (wild_match(spec, buffer) || wild_match(nicks->nick, spec)))
#if 0
		if ((all || (ops && nicks->chanop) || !nicks->chanop || get_cset_int_var(chan->csets, KICK_OPS_CSET)) &&
		    my_stricmp(nicks->nick, get_server_nickname(from_server)) &&
		    (wild_match(spec, buffer) || wild_match(nicks->nick, spec)))
#endif
		{
			new = (ShitList *)new_malloc(sizeof(ShitList));
			malloc_sprintf(&new->filter, "%s", nicks->nick);
			add_to_list((List **)&masskick_list, (List *)new);
		}
		new_free(&buffer);
	}

	if (masskick_list)
	{
		int len = 0, num = 0;
		char *send_buf = NULL;
		char buf[BIG_BUFFER_SIZE + 1];
						
		bitchsay("Performing (%s) Mass Kick on %s", all? "opz/non-opz" : ops ? "ops":"non-opz", chan->channel);
		sprintf(buf, "KICK %s %%s :\002%s\002", chan->channel, rest? rest : "MassKick");
		len = strlen(buf);
		for (new = masskick_list; new; new = new->next)
		{
			if (send_buf)
				send_buf = m_3cat(&send_buf, ",", new->filter);
			else 
				malloc_strcpy(&send_buf, new->filter);
			num++;
			if ((get_int_var(NUM_KICKS_VAR) && (num == get_int_var(NUM_KICKS_VAR))) || (strlen(send_buf)+len) >= (IRCD_BUFFER_SIZE - (NICKNAME_LEN + 5)))
			{
				num = 0;
				send_to_server(buf, send_buf);
				new_free(&send_buf);
			}
		}
		if (send_buf)
			send_to_server(buf, send_buf);
		new_free(&send_buf);
		shitlist_erase(&masskick_list);
	}
	else
		bitchsay("No matches for mass kick of %s on %s", spec, chan->channel);
}

BUILT_IN_COMMAND(mknu)
{
	ChannelList *chan;
register NickList *nicks;
	char *to = NULL, *rest;
	int count;
	int server = from_server;
	
	
	if (!args || !*args)
		to = NULL;
	else if (*args == '#' || *args == '&' || !strncmp(args, "* ", 2) ||
		 !strcmp(args, "*"))
		to = next_arg(args, &args);
	else
		to = NULL;

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	rest = args;
	if (rest && !*rest)
		rest = NULL;

	count = 0;
	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		if (!nicks->chanop && !isme(nicks->nick))
		{
			count++;
			send_to_server("KICK %s %s :(non-users) \002%cX002", chan->channel, nicks->nick, rest ? rest : get_reason(nicks->nick, NULL));
		}
	}
	if (!count)
		say("No matches for masskick of non-users on %s", chan->channel);
}

BUILT_IN_COMMAND(masskickban)
{
	ChannelList *chan;
register NickList *nicks;
	char *to = NULL, *spec, *rest;
	int count, all = 0;
	int server = from_server;
	char	buffer[BIG_BUFFER_SIZE + 1];
	char tempbuf[BIG_BUFFER_SIZE+1];
	
	
	rest = NULL;
	spec = NULL;

	if (!(to = next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server,to, NEED_OP)))
		return;

	if (!spec && !(spec = next_arg(args, &args)))
	{
		userage(command, helparg);
		return;
	}
	if (args && !strncmp(args, "-all", 4))
	{
		all = 1;
		next_arg(args, &args);
	}
	rest = args;
	if (rest && !*rest)
		rest = NULL;

	count = 0;
	if (!strchr(spec, '!'))
	{
		strcpy(tempbuf, "*!");
		if (!strchr(spec, '@'))
			strcat(tempbuf, "*@");
		strcat(tempbuf, spec);
	}
	else
		strcpy(tempbuf, spec);

	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		*buffer = '\0';
		strcat(buffer, nicks->nick);
		strcat(buffer, "!");
		strcat(buffer, nicks->host);
		if ((all || !nicks->chanop || get_cset_int_var(chan->csets, KICK_OPS_CSET)) &&
		   !isme(nicks->nick) && wild_match(tempbuf, buffer))
		{
			count++;
			send_to_server("KICK %s %s :(%s) \002%s\002", chan->channel, nicks->nick, spec, rest ? rest : get_reason(nicks->nick, NULL));
		}
	}
	send_to_server("MODE %s +b %s", chan->channel, tempbuf);
	if (!count)
		say("No matches for masskickban of %s on %s", spec, chan->channel);
}

BUILT_IN_COMMAND(massban)
{
	ChannelList *chan;
register NickList *nicks;
	ShitList *massban_list = NULL, *tmp;
	char *to = NULL, *spec, *rest;
	char *buffer = NULL;
	int server = from_server;

	int maxmodes, all = 0;

	
	maxmodes = get_int_var(NUM_BANMODES_VAR);

	rest = NULL;
	spec = NULL;

	if (!(to = next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (!spec && !(spec = next_arg(args, &args)))
		spec = "*!*@*";
	if (*spec == '-')
	{
		rest = spec;
		spec = "*!*@*";
	}
	else
		rest = args;

	if (rest && !my_stricmp(rest, "-all"))
		all = 1;

	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		new_free(&buffer);
		malloc_sprintf(&buffer, "%s!%s", nicks->nick, nicks->host);

		if ((all || !nicks->chanop || get_cset_int_var(chan->csets, KICK_OPS_CSET)) &&
		    !isme(nicks->nick) && wild_match(spec, buffer))
		{
			char *temp = NULL;
			char *p, *q;
			ShitList *new;
			malloc_strcpy(&temp, nicks->host);

			q = clear_server_flags(temp);
			p = strchr(temp, '@');
			*p++ = 0;
		
			new = (ShitList *)new_malloc(sizeof(ShitList));
			malloc_sprintf(&new->filter, "*!*%s@%s ", q, cluster(p));
			add_to_list((List **)&massban_list, (List *)new);
			new_free(&temp);
		}
	}
	new_free(&buffer);
	if (massban_list)
	{
		char modestr[100];
		int i = 0;
		
		bitchsay("Performing Mass Bans on %s", chan->channel);
		for (tmp = massban_list; tmp; tmp = tmp->next)
		{
			malloc_strcat(&buffer, tmp->filter);
			modestr[i] = 'b';
			i++;
			if (i > maxmodes)
			{
				modestr[i] = '\0';
				send_to_server("MODE %s +%s %s", chan->channel, modestr, buffer);
				i = 0;
				new_free(&buffer);
			}
		}
		modestr[i] = '\0';
		if (buffer && *buffer)
		{
			send_to_server("MODE %s +%s %s", chan->channel, modestr, buffer);
			new_free(&buffer);
		}
		shitlist_erase(&massban_list);
	} else
		say("No matches for massban of %s on %s", spec, chan->channel);
}

BUILT_IN_COMMAND(unban)
{
	char *to, *spec, *host;
	ChannelList *chan;
	BanList *bans;
	int count = 0;
	int server = from_server;
			
	
	to = spec = host = NULL;

	if (!(to = new_next_arg(args, &args)))
		to = NULL;
	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (!spec && !(spec = next_arg(args, &args)))
	{
		spec = "*";
		host = "*@*";
	}

	if (spec && *spec == '#')
	{
		count = atoi(spec);	
	}
	if (!strchr(spec, '*'))
	{
		userhostbase(spec, userhost_unban, 1, "%s %d", chan->channel, current_window->refnum);
		return;
	}

	if (count)
	{
		int tmp = 1;
		for (bans = chan->bans; bans; bans = bans->next)
		{
			if (tmp == count)
			{
				if (bans->sent_unban == 0)
				{
					send_to_server("MODE %s -b %s", chan->channel, bans->ban);
					bans->sent_unban++;
					tmp = 0;
					break;
				}
			} else
				tmp++;
		}
		if (tmp != 0)
			count = 0;
	} 
	else 
	{
		char *banstring = NULL;
		int num = 0;
		count = 0;	
		for (bans = chan->bans; bans; bans = bans->next)
		{
			if (wild_match(bans->ban, spec) || wild_match(spec, bans->ban))
			{
				if (bans->sent_unban == 0)
				{
					malloc_strcat(&banstring, bans->ban);
					malloc_strcat(&banstring, " ");
					bans->sent_unban++;
					count++;
					num++;
				}
			}
			if (count && (count % get_int_var(NUM_BANMODES_VAR) == 0))
			{
				send_to_server("MODE %s -%s %s", chan->channel, strfill('b', num), banstring);
				new_free(&banstring);
				num = 0;
			}
		}
		if (banstring && num)
			send_to_server("MODE %s -%s %s", chan->channel, strfill('b', num), banstring);
		new_free(&banstring);
	}
	if (!count)
		bitchsay("No ban matching %s found", spec);

}

BUILT_IN_COMMAND(dokick)
{
	char	*to = NULL, 
		*spec = NULL,
		*reason = NULL;
	ChannelList *chan;
	int server = from_server;

	
	if (!(to = next_arg(args, &args)))
		to = NULL;

	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, (to && !strcmp(to, "*"))? NULL : to, NEED_OP)))
		return;

	if (!spec && !(spec = next_arg(args, &args)))
	{
		userage("kick", helparg);
		return;
	}
	if (args && *args)
		reason = args;
	else
		reason = get_reason(spec, NULL);

	send_to_server("KICK %s %s :%s", chan->channel, spec, reason);
}

BUILT_IN_COMMAND(kickban)
{
	char	*to = NULL, 
		*tspec = NULL,
		*spec = NULL, 
		*tnick = NULL,
		*rest = NULL;

	ChannelList *chan;
	NickList *nicks;
	int count = 0;
	int server = from_server;
	int set_ignore = 0;
	int kick_first = 0;		
	
	
	if (!(to = next_arg(args, &args)))
		to = NULL;

	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;
	if (command)
	{
		if (!my_stricmp(command, "KB"))
			kick_first = 1;
		set_ignore = (command[strlen(command)-1] == 'I') ? 1 : 0;
	}
	if (!spec && !(spec = new_next_arg(args, &args)))
	{
		userage(command?command:"KickBan", helparg);
		return;
	}
	rest = args;
	if (rest && !*rest)
		rest = NULL;
	tspec = alloca(strlen(spec)+1);
	strcpy(tspec, spec);
	while ((tnick = next_in_comma_list(tspec, &tspec)))
	{
		if (!tnick || !*tnick) break;

		for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
		{
			char *user, *host;
			char *t = NULL;
			if (!wild_match(tnick, nicks->nick) || isme(nicks->nick))
				continue;
			t = alloca(strlen(nicks->host)+1);
			strcpy(t, nicks->host);
			user = clear_server_flags(t);
			host = strchr(user, '@');
			*host++ = 0;
#if 0
			if (kick_first)
				send_to_server("KICK %s %s :%s", chan->channel, nicks->nick,
					       rest ? rest : get_reason(nicks->nick, NULL));
			send_to_server("MODE %s -o+b %s %s", chan->channel, nicks->nick, ban_it(nicks->nick, user, host, nicks->ip));
			if (!kick_first)
				send_to_server("KICK %s %s :%s", chan->channel, nicks->nick,
					       rest ? rest : get_reason(nicks->nick, NULL));
#else
			if (kick_first)
				send_to_server("KICK %s %s :%s\r\nMODE %s -o+b %s %s", 
					chan->channel,nicks->nick, rest ? rest : get_reason(nicks->nick, NULL),
					chan->channel, nicks->nick, ban_it(nicks->nick, user, host, nicks->ip));
			else
				send_to_server("MODE %s -o+b %s %s\r\nKICK %s %s :%s", 
					chan->channel, nicks->nick, ban_it(nicks->nick, user, host, nicks->ip),
					chan->channel,nicks->nick, rest ? rest : get_reason(nicks->nick, NULL));
#endif
			count++;
			if (command && !my_stricmp(command, "FUCK"))
			{
				char *temp = NULL;
				malloc_sprintf(&temp, "%s!*%s@%s %s 3 Auto-Shit", nicks->nick, user, host, chan->channel);
				add_shit(NULL, temp, NULL, NULL);
				new_free(&temp);
			} else if (set_ignore)
				ignore_nickname(ban_it("*", user, host, NULL), IGNORE_ALL, 0);
		}
	}
	if (!count)
		userhostbase(spec, userhost_ban, 1, "%s %s %s", chan->channel, spec, command ? (!strcmp(command, "FUCK") ? "FUCK": set_ignore ? "BKI":""):"");
}

BUILT_IN_COMMAND(ban)
{
	char	*to = NULL, 
		*spec = NULL, 
		*rest = NULL;
	ChannelList *chan;
	NickList *nicks;
	int server = from_server;
	int found = 0;
	
	
	if (!(to = next_arg(args, &args)))
		to = NULL;

	if (to && !is_channel(to))
	{
		spec = to;
		to = NULL;
	}

	if (!(chan = prepare_command(&server, to, NEED_OP)))
		return;

	if (!spec && !(spec = new_next_arg(args, &args)))
	{
		userage("ban", helparg);
		return;
	}
	rest = args;

	if (rest && !*rest)
		rest = NULL;

	for (nicks = next_nicklist(chan, NULL); nicks; nicks = next_nicklist(chan, nicks))
	{
		if (!my_stricmp(spec, nicks->nick))
		{
			char *t = NULL, *host, *user;
			
			malloc_strcpy(&t, nicks->host);
			user = clear_server_flags(t);
			host = strchr(user, '@');
			*host++ = 0;

			send_to_server("MODE %s -o+b %s %s", chan->channel, nicks->nick, ban_it(nicks->nick, user, host, nicks->ip));
			new_free(&t);
			found++;
			
		}
	}
	if (!found)
	{
		if (strchr(spec, '!') && strchr(spec, '@'))
			send_to_server("MODE %s +b %s", chan->channel, spec);
		else
			userhostbase(spec, userhost_ban, 1, "%s %s", chan->channel, spec);
	}
}

BUILT_IN_COMMAND(banstat)
{
char *channel = NULL, *tmp = NULL, *check = NULL;
ChannelList *chan;
BanList *tmpc;
int count = 1;
int server;

	
	if (args && *args)
	{
		tmp = next_arg(args, &args);
		if (*tmp == '#' && is_channel(tmp))
			malloc_strcpy(&channel, tmp);
		else
			malloc_strcpy(&check, tmp);
		if (args && *args && channel)
		{
			tmp = next_arg(args, &args);			
			malloc_strcpy(&check, tmp);
		}		
	}

	if ((chan = prepare_command(&server, channel, NO_OP)))
	{
		if (!chan->bans)
		{
			bitchsay("No bans on %s", chan->channel);
			return;
		}
		if ((do_hook(BANS_HEADER_LIST, "%s %s %s %s %s", "#", "Channel", "Ban", "SetBy", "Seconds")))
			put_it("%s", convert_output_format(fget_string_var(FORMAT_BANS_HEADER_FSET), NULL));
		for (tmpc = chan->bans; tmpc; tmpc = tmpc->next, count++)
		{
			if (check && (!wild_match(check, tmpc->ban) || !wild_match(tmpc->ban, check)))
				continue;
			if (do_hook(BANS_LIST, "%d %s %s %s %lu", count, chan->channel, tmpc->ban, tmpc->setby?tmpc->setby:get_server_name(from_server), (unsigned long)tmpc->time))
				put_it("%s", convert_output_format(fget_string_var(FORMAT_BANS_FSET), "%d %s %s %s %l", count, chan->channel, tmpc->ban, tmpc->setby?tmpc->setby:get_server_name(from_server), (unsigned long)tmpc->time));
		}
		new_free(&check);
		new_free(&channel);
	} 
	else if (channel)
		send_to_server("MODE %s b", channel);
}

void remove_bans (char *stuff, char *line)
{
ChannelList *chan;
int count = 1;
BanList *tmpc, *next;
char *banstring = NULL;
int num = 0;
int server = from_server;

	
	if (stuff && (chan = prepare_command(&server, stuff, NEED_OP)))
	{
	
		if (!chan->bans)
		{
			bitchsay("No bans on %s", stuff);
			return;
		}

		for (tmpc = chan->bans; tmpc; tmpc = tmpc->next, count++)
			if (!tmpc->sent_unban && (matchmcommand(line, count)))
			{
				malloc_strcat(&banstring, tmpc->ban);
				malloc_strcat(&banstring, " ");
				num++;
				tmpc->sent_unban++;
				if (num % get_int_var(NUM_BANMODES_VAR) == 0)
				{
					send_to_server("MODE %s -%s %s", stuff, strfill('b', num), banstring);
					new_free(&banstring);
					num = 0;
				}
			}
		if (banstring && num)
			send_to_server("MODE %s -%s %s", stuff, strfill('b', num), banstring);
		for (tmpc = chan->bans; tmpc; tmpc = next)
		{
			next = tmpc->next;
			if (tmpc->sent_unban)
			{
				if ((tmpc = (BanList *)remove_from_list((List**)&chan->bans, tmpc->ban)))
				{
					new_free(&tmpc->ban);
					new_free(&tmpc->setby);
					new_free((char **)&tmpc);
					tmpc = NULL;
				}
			}
		}
		new_free(&banstring);
	}	
}

BUILT_IN_COMMAND(tban)
{
ChannelList *chan;
int count = 1;
BanList *tmpc;
int server;

	
	if ((chan = prepare_command(&server, NULL, NEED_OP)))
	{
	
		if (!chan->bans)
		{
			bitchsay("No bans on %s", chan->channel);
			return;
		}
		if ((do_hook(BANS_HEADER_LIST, "%s %s %s %s %s", "#", "Channel", "Ban", "SetBy", "Seconds")))
			put_it("%s", convert_output_format(fget_string_var(FORMAT_BANS_HEADER_FSET), NULL));
		for (tmpc = chan->bans; tmpc; tmpc = tmpc->next, count++)
			if (do_hook(BANS_LIST, "%d %s %s %s %lu", count, chan->channel, tmpc->ban, tmpc->setby?tmpc->setby:get_server_name(from_server), (unsigned long)tmpc->time))
				put_it("%s", convert_output_format(fget_string_var(FORMAT_BANS_FSET), "%d %s %s %s %l", count, chan->channel, tmpc->ban, tmpc->setby?tmpc->setby:get_server_name(from_server), (unsigned long)tmpc->time));
		add_wait_prompt("Which ban to delete (-2, 2-5, ...) ? ", remove_bans, chan->channel, WAIT_PROMPT_LINE, 1);
	} 
}

static void set_default_bantype(char value, char *helparg)
{
int oldbantype = defban;
	
	switch(toupper(value))
	{
		case 'B':
			defban = 2;
			break;
		case 'H':
			defban = 3;
			break;
		case 'D':
			defban = 4;
			break;
		case 'I':
			defban = 7;
			break;
		case 'S':
			defban = 6;
			break;
		case 'U':
			defban = 5;
			break;
		case 'N':
			defban = 1;
			break;
		default :
			userage("BanType", helparg);
			defban = oldbantype;
			return;
			break;
	}
	bitchsay("BanType set to %s", (defban == 1) ? "\002N\002ormal":(defban ==2)?"\002B\002etter":(defban==3)?"\002H\002ost":(defban==4)?"\002D\002oMain":(defban==5)?"\002U\002ser":(defban ==6)?"\002S\002crew":"\002I\002p");
}

BUILT_IN_COMMAND(bantype)
{
	
	if (args && *args)
		set_default_bantype(*args, helparg);
	else
		userage("BanType", helparg);
}
