# portscan.tcl
#
# This is an example script of the $tcl command. Syntax is:
# on_word :?pscan* 1 $tcl portscan.tcl dummy
# See README for more info
#
set tempfd [open ".tcl_tmp.file" w]
if {[lindex $argv 1] == "" || [lindex $argv 2] == "" || [lindex $argv 3] == ""} {
 puts $tempfd "PRIVMSG [lindex $argv 0] :Syntax: !pscan <host> <begining port> <ending port>"
 close $tempfd
 exit
}
set begin [lindex $argv 2]
set end [lindex $argv 3]

if {[expr $end - $begin] > 1000} {
 puts $tempfd "PRIVMSG [lindex $argv 0] :Restrict your search"
 close $tempfd
 exit
}

puts $tempfd "PRIVMSG [lindex $argv 0] :Scanning [lindex $argv 1] from $begin to $end"

for {set temp $begin} {$temp < $end} {incr temp} {
 if [catch {set sid [socket [lindex $argv 1] $temp]} res] { 
 } else {
  puts $tempfd "PRIVMSG [lindex $argv 0] :Port $temp is open"
 } 
}
close $tempfd
