#! /bin/sh
# MVM Project (C) Marc SCHAEFER <schaefer@alphanet.ch>
# notify.sh -- Notify user of new mail
# Creation: 08/03/98
# Update:   08/03/98
# V2.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This shell script implements immediate e-mail notifications.
#    We send notifications, or we forward voicemail message itself, or
#    we copy it through mail.
# BUGS
# TODO
# NOTES
#    - We trust the information in the .email-address file.
#    - Arguments are:
#         to_user from_user mail_file (complete path)
# BASED-ON
# MODIFICATION-HISTORY
#    08/03/98  schaefer  Created this file.
#    29/12/98  schaefer  Splitsize 900k
# $Id: notify.sh,v 1.5 1998/12/29 11:10:42 schaefer Exp $

. /etc/mvm_definitions.sh
. $SCRIPTS_DIR/mvm_low_level_library.sh

if [ $# != 3 ]; then
   echo "$0 to from mail_file"
   echo "$0: bad args."
   exit 1
fi

if [ -f $MAILBOX_DIR/$1/.e-mail-address ]; then
   if [ -f $MAILBOX_DIR/$1/.notify-each-message ]; then
      (echo "Subject: New voice mail from user $2"
       echo ""
       echo "You have new voicemail dated `date` from user $2.") | /usr/lib/sendmail -oi -f vmadm@alphanet.ch "`cat $MAILBOX_DIR/$1/.e-mail-address`"
   else
      if [ -f $MAILBOX_DIR/$1/.copy-each-message ]; then
         $PVF_TOOLS_DIR/rmdtopvf < $3 | $PVF_TOOLS_DIR/pvfspeed -s 8000 | $PVF_TOOLS_DIR/pvftobasic | metasend -S 900000 -b -D "Copy of voice mail from user $2" -e base64 -f /dev/stdin -F vmadm@alphanet.ch -m audio/basic -s "Copy of voice mail from user $2" -t "`cat $MAILBOX_DIR/$1/.e-mail-address`" -z 
      else
         if [ -f $MAILBOX_DIR/$1/.forward-each-message ]; then
	    $PVF_TOOLS_DIR/rmdtopvf < $3 | $PVF_TOOLS_DIR/pvfspeed -s 8000 | $PVF_TOOLS_DIR/pvftobasic | metasend -S 900000 -b -D "Voice mail from user $2 (original deleted)" -e base64 -f /dev/stdin -F vmadm@alphanet.ch -m audio/basic -s "Voice mail from user $2 (original deleted)" -t "`cat $MAILBOX_DIR/$1/.e-mail-address`" -z
            if [ $? = 0 ]; then
               rm $3
            fi
         fi
      fi
   fi
fi


exit 0
