#! /bin/sh
# count_them -- Counts elements
# Marc SCHAEFER <schaefer@alphanet.ch>
# Creation: 08/05/97
# Update:   08/05/97
# V1.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    Shows on stdout the number of each term appearing on stdin on the
#    first column. Input has to be sorted first.
# BASED-ON
#    ~admin/faqs/count.sh of 03/04/96 from same author.
# NOTES
# BUGS
# TODO

if [ $# != 0 ]; then
   echo "$0: bad args."
   exit 2
fi

awk                   'BEGIN { last = 0; count = 0 }
                             { if (last == $1)
                                  count ++;
                               else {
                                  if (last) {
                                     printf "%d %s\n", count,
                                                       last; 
                                  }
                                  last = $1;
                                  count = 0;
                               }
                              }
                       END   { if (last)
                                  printf "%d %s\n", count, last;
                             }' 
