/* randomize.c -- Randomly outputs its arguments
 * Marc SCHAEFER <schaefer@alphanet.ch>
 * Creation: 08/05/97
 * Update:   08/05/97
 * V1.0 PV001
 * DISCLAIMER
 *    No warranty, either expressed or implied.
 * COPYRIGHT
 *    Fully protected under Berne Convention, use authorized except
 *    if you make money from this use (contact me before).
 * DESCRIPTION
 *    This software outputs on stdout its arguments separated by a space.
 *    However, the order which is choosen for the outputting is more
 *    or less random
 * NOTES
 *    - A very fastly hacked randomize; I don't know where the original
 *    source is.
 *    - Use that only for fun.
 *    - Linux-tested only.
 * BUGS
 *    - Setting argv[x] to NULL.
 * TODO
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <assert.h>
#include <unistd.h>

int main(int argc, char **argv) {
   if (argc > 1) {
      unsigned long count = argc - 1;
      struct timeval tv;
      struct timezone tz;

      gettimeofday(&tv, &tz); /* result ignored */

      srandom(tv.tv_usec ^ tv.tv_sec ^ getpid()); /* Very good seed, indeed */

      while (count) {
         unsigned long int which; /* 1 .. (argc - 1) */

         which = (random() % (argc - 1)) + 1;

         assert(which < argc);

         if (argv[which]) {
            printf("%s%s", argv[which], (count > 1) ? " " : "");
            argv[which] = NULL;
            count--;
         }
      }

      printf("\n");
   
      return 0;
   }
   else {
      fprintf(stderr, "%s: arg1 ... argn\n%s: bad args.\n",
                      argv[0], argv[0]);
      return 2;
   }
   /* NOT REACHED */
}
