#! /bin/sh
# generate_messages.sh -- Generate messages from textual representation
# Marc SCHAEFER <schaefer@alphanet.ch>
# Creation: 14/02/98 
# Update:   14/02/98
# V2.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This script creates message files from the text file MESSAGES.
#    The generated files are modem-type specific files.
# NOTES
#    - Runs from a pre-installed environment where the scripts
#      directory and the link in /etc are setup.
# BUGS
# TODO
# BASED-ON
#    generate_messages.sh V1.0 PV005 of 23/08/97
# MODIFICATION-HISTORY
#    14/02/98  schaefer  Created this file.
# $Id: generate_messages.sh,v 1.1 1998/02/14 16:38:59 schaefer Exp $

. /etc/mvm_definitions.sh
. $SCRIPTS_DIR/mvm_low_level_library.sh

if [ $# != 0 ]; then
   echo "$0"
   echo "$0: bad args."
   exit 2
fi

# Don't change anything from here.
export MESSAGES=MESSAGES

echo "$0"
echo ""
echo -n "Generating messages ..."

cat $MESSAGES | ( while :
                  do
                     read Line
                     if [ $? != 0 ]; then
                        break
                     fi
                     set - $Line
                     WHERE=$1
                     shift
                     Line="$*"
                     echo "$WHERE "
                     if [ -f $WHERE ]; then
                        mv $WHERE $WHERE.DIS
                     fi
                     english_text_to_audio_file "$Line" `pwd`/$WHERE
                  done
                )
echo ""
