#! /bin/sh
# MVM Project (C) Marc SCHAEFER <schaefer@alphanet.ch>
# setup.sh -- Setups the minimal voicemail system
# Marc SCHAEFER <schaefer@alphanet.ch>
# Creation: 14/02/98
# Update:   07/03/99
# V2.0 PV004
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This shell scripts interactively installs the mvm subsystem.
# NOTES
#    - This is the only part of mvm not depending on the
#      mvm_definitions.sh.
# BUGS
# TODO
# BASED-ON
#    setup.sh V1.2 PV002 of 23/08/97
# MODIFICATION-HISTORY
#    14/02/98  schaefer  Created this file.
#    22/03/98  schaefer  Notify support
#    01/03/99  schaefer  French number initialization/conversion to RMD.
#    07/03/99  schaefer  Cosmetic changes. Version of rsynth. Special
#                        arguments to rsynth. SOX. 
# $Id: setup.sh,v 1.10 1999/03/07 11:00:45 schaefer Exp $

INSTALL_DIR=/usr/lib/mgetty
SPOOL_DIR=/usr/spool/voice

#INSTALL_DIR=/tmp/abcd/mgetty
#SPOOL_DIR=/tmp/abcd/voice

if [ ! -f setup.sh ]; then
   echo "Please execute setup.sh from the install subdirectory"
   exit 1
fi

cat << FINTRUC
Welcome to the Minimal Voicemail System version 2.0
Author: Marc SCHAEFER <schaefer@alphanet.ch>

# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).

FINTRUC

echo ""
echo -n "Did you read the README ?: "

read Answer
case $Answer in
   y|Y|YES|yes|Yes) ;;
   *)               echo "It is time to do so."
                    exit 1;;
esac

echo ""
echo "I will install files in ${INSTALL_DIR} and in"
echo "${SPOOL_DIR}. I suggest you make a backup copy of"
echo "your old ${INSTALL_DIR} directory. You by the"
echo "way need approximately one megabyte in ${SPOOL_DIR},"
echo "much less in ${INSTALL_DIR}."
echo ""
echo -n "Ok to proceed ?: "

read Answer
case $Answer in
   y|Y|yes|YES|Yes) ;;
   *)               echo "Installation aborted."
                    exit 1;;
esac

echo ""
echo "I need to know which device you use for your getty."
echo "Possible answers are e.g. ttyS0 or ttyS1."
echo -n "mgetty device [/dev/ttyS0] ?: "
read MGETTY_DEVICE

if [ "$MGETTY_DEVICE" = "" ]; then
   MGETTY_DEVICE=/dev/ttyS0
fi

case $MGETTY_DEVICE in
   /dev/tty*) ;;
   tty*) MGETTY_DEVICE="/dev/${MGETTY_DEVICE}";;
   *) echo "Please read mgetty's README about tty naming."
      exit 1;;
esac

echo ""
echo "Where is your vgetty pvf tools directory ?"
echo -n "vgetty pvf tools directory [/usr/lib/mgetty/pvftools] ?: "
read MGETTY_PVF_DIRECTORY
if [ "$MGETTY_PVF_DIRECTORY" = "" ]; then
   MGETTY_PVF_DIRECTORY=/usr/lib/mgetty/pvftools
fi

echo ""
echo "I need to know what are the arguments to pvftormd"
echo "Possible answers are e.g. 'ZyXEL_2864 4' or"
echo "                          'ZyXEL_1496 2' (no quotes)."
echo "Do a $MGETTY_PVF_DIRECTORY/pvftormd -L to get the list"
echo -n "Executable for pvftomodem conversion [ZyXEL_1496 2] ?: "
read MGETTY_PVFUTIL
if [ "$MGETTY_PVFUTIL" = "" ]; then
   MGETTY_PVFUTIL='ZyXEL_1496 2'
fi

echo ""
echo "I need to know what the frequency of the messages should be."
echo "Possible answers are e.g. 8000, 9600, 11025. US Robotics only"
echo "supports 8000. ZyXEL 1496 supports 9600. The 2864 supports also"
echo "11025."
echo -n "Modem sample frequency [9600] ?: "
read MGETTY_FREQUENCY
if [ "$MGETTY_FREQUENCY" = "" ]; then
   MGETTY_FREQUENCY='9600'
fi

while :
do
   cat <<EOF

What version of rsynth did you install (voice generation) ?

    1                     The patched version or binary (add_ons/rsynth)
    2                     Standard rsynth-2.0 from the Internet (default).

EOF
   echo -n "Version of rsynth [2] ?: "
   read MGETTY_RSYNTH_VERSION
   if [ "$MGETTY_RSYNTH_VERSION" = "" ]; then
      MGETTY_RSYNTH_VERSION=2
      break
   else
      case $MGETTY_RSYNTH_VERSION in
	 1|2) 
	    break;;
      esac
   fi
done

if [ "$MGETTY_RSYNTH_VERSION" = "1" ]; then
   MGETTY_RSYNTH_ARGUMENTS_DEFAULT=
else
   MGETTY_RSYNTH_ARGUMENTS_DEFAULT="-d a"
fi

echo ""
echo "Any special argument to be given to rsynth ?"
echo "Please look in rsynth's manual for details."
echo -n "rsynth's arguments will be [$MGETTY_RSYNTH_ARGUMENTS_DEFAULT] ?: "
read MGETTY_RSYNTH_ARGUMENTS
if [ "$MGETTY_RSYNTH_ARGUMENTS" = "" ]; then
   MGETTY_RSYNTH_ARGUMENTS="$MGETTY_RSYNTH_ARGUMENTS_DEFAULT"
fi

echo ""
echo "Where is your say command (from rsynth) ?"
echo "If not specified, there will be missing functionnality."
echo -n "rsynth's say is in [/usr/local/bin/say] ?: "
read MGETTY_RSYNTH_SAY
if [ "$MGETTY_RSYNTH_SAY" = "" ]; then
   MGETTY_RSYNTH_SAY=/usr/local/bin/say
fi

if [ ! -x $MGETTY_RSYNTH_SAY ]; then
   cat <<EOF

   #######################################################
   # WITHOUT A VALID SAY, THE GENERATION OF THE MESSAGES #
   # WILL NOT WORK. This means nothing will work.        #
   #######################################################

   PLEASE *READ* THE README NOW.

EOF
   exit 1
fi

echo ""
echo "Where is your sox command (from SOX package) ?"
echo "If not specified, there might be missing functionnality in"
echo "mvm add_ons, but not in mvm main."
echo -n "sox is in [/usr/local/bin/sox] ?: "
read MGETTY_SOX_EXECUTABLE
if [ "$MGETTY_SOX_EXECUTABLE" = "" ]; then
   MGETTY_SOX_EXECUTABLE=/usr/local/bin/sox
fi

echo ""
echo "Where is your randomize command ?"
echo "If not specified, there will be (small) missing functionnality."
echo -n "randomize is in [OLD_BINS/randomize] ?: "
read MGETTY_RANDOMIZE
if [ "$MGETTY_RANDOMIZE" = "" ]; then
   MGETTY_RANDOMIZE=OLD_BINS/randomize
fi

echo ""
echo "Default function 5 of the main menu allows to randomly play a"
echo "sample from a sample directory (au format)."
echo -n "Random file library path [/share/archives/sounds/diverse] ?: "
read MGETTY_LIBRARY_PATH
if [ "$MGETTY_LIBRARY_PATH" = "" ]; then
   MGETTY_LIBRARY_PATH=/share/archives/sounds/diverse
fi

while :
do
   cat <<EOF

How should mvm answer calls ?

    unconditional         Always goes to voice mode
    normal                Goes to voice mode if a DTMF is pressed within
                          2 seconds and no data calling tone is detected
    special               Goes to voice mode if after 2 seconds no calling
                          tone nor DTMF are detected (UNIMPLEMENTED)

You can answer with the smaller uniquely matching string.
EOF
   echo -n "Answering type [unconditional] ?: "
   read MGETTY_VOICE_MODE
   if [ "$MGETTY_VOICE_MODE" = "" ]; then
      MGETTY_VOICE_MODE=unconditional
      break
   else
      case $MGETTY_VOICE_MODE in
	 u*) MGETTY_VOICE_MODE=unconditional
	     break;;
	 n*) MGETTY_VOICE_MODE=normal
	     break;;
#         s*) MGETTY_VOICE_MODE=special
#             break;;
      esac
   fi

done

echo ""
echo "Do you want to enable french language number generation ?"
echo "Dsirez-vous la gnration des nombres en franais (si la langue"
echo "courante est le franais) ?"
echo -n "Install french number generation [NO] ?: "
read FRENCH_NUMBERS_INSTALL
case $FRENCH_NUMBERS_INSTALL in
   y*|o*|Y*|O*) FRENCH_NUMBERS_INSTALL=YES
                MVM_FRENCH_GENERATE_ENABLE=1;;
   *) FRENCH_NUMBERS_INSTALL=NO
      MVM_FRENCH_GENERATE_ENABLE=9999;;
esac

echo ""
echo "Do you want the message notification system ?"
echo -n "Install notify [no] ?: "
read NOTIFY_ENABLE
case $NOTIFY_ENABLE in
   y*|o*|Y*|O*) NOTIFY_ENABLE=yes;;
   *) NOTIFY_ENABLE=no;;
esac

echo ""
echo "Making directories ..."

mkdir -p ${INSTALL_DIR} ${SPOOL_DIR}

echo ""
echo -n "Installing files in ${INSTALL_DIR} ..."

for i in $MGETTY_RSYNTH_SAY $MGETTY_RANDOMIZE
do
   case $i in
      OLD_BINS/*) cp $i ${INSTALL_DIR};;
   esac
done

case $MGETTY_RSYNTH_SAY in
   OLD_BINS/*) MGETTY_RSYNTH_SAY=${INSTALL_DIR}/say;;
esac

case $MGETTY_RANDOMIZE in
   OLD_BINS/*) MGETTY_RANDOMIZE=${INSTALL_DIR}/randomize;;
esac

cat ../scripts/mvm_definitions.sh | sed "s%^PVF_TOOLS_DIR=.*%PVF_TOOLS_DIR=$MGETTY_PVF_DIRECTORY/%
                           s%^SPEED_FREQUENCY_VALUE=.*%SPEED_FREQUENCY_VALUE=$MGETTY_FREQUENCY%
                           s%^SCRIPTS_DIR=.*%SCRIPTS_DIR=$INSTALL_DIR%
                           s%^VOICEMAIL=.*%VOICEMAIL=$SPOOL_DIR%
                           s%^NOTIFY_ENABLE=.*%NOTIFY_ENABLE=$NOTIFY_ENABLE%
                           s%^FRENCH_GENERATE_ENABLE=.*%FRENCH_GENERATE_ENABLE=$MVM_FRENCH_GENERATE_ENABLE%
                           s%^VOICE_MODE=.*%VOICE_MODE=$MGETTY_VOICE_MODE%
                           s%^SOX_EXECUTABLE=.*%SOX_EXECUTABLE=$MGETTY_SOX_EXECUTABLE%
                           s%^SAY_RSYNTH_EXECUTABLE=.*%SAY_RSYNTH_EXECUTABLE=$MGETTY_RSYNTH_SAY%
                           s%^SAY_RSYNTH_EXECUTABLE_VERSION=.*%SAY_RSYNTH_EXECUTABLE_VERSION=$MGETTY_RSYNTH_VERSION%
                           s%^SAY_RSYNTH_EXECUTABLE_ARGUMENTS=.*%SAY_RSYNTH_EXECUTABLE_ARGUMENTS=\'$MGETTY_RSYNTH_ARGUMENTS_DEFAULT\'%
                           s%^PVF_MODEM_FILTER=.*%PVF_MODEM_FILTER=\'pvftormd $MGETTY_PVFUTIL\'%
                           s%^SELECT_RANDOM_FILE=.*%SELECT_RANDOM_FILE=$MGETTY_RANDOMIZE%
                           s%^LIBRARY_DIR=.*%LIBRARY_DIR=$MGETTY_LIBRARY_PATH%" > ${INSTALL_DIR}/mvm_definitions.sh

cat mgetty.config | sed "s%^port ttyS0.*%port `basename $MGETTY_DEVICE`%" > ${INSTALL_DIR}/mgetty.config

cat voice.conf | sed "s%^port ttyS0.*%port `basename $MGETTY_DEVICE`%
                      s%call_program /usr/lib/mgetty/mvm_vgetty_script.sh.*%call_program ${INSTALL_DIR}/mvm_vgetty_script.sh%
                      s%^voice_devices ttyS0.*%voice_devices `basename $MGETTY_DEVICE`%" > ${INSTALL_DIR}/voice.conf

cp ../scripts/mvm_vgetty_script.sh ../scripts/mvm_low_level_library.sh $INSTALL_DIR

echo "ok"
echo -n "Installing files in ${SPOOL_DIR} ..."
cp menu_items_types ${SPOOL_DIR}
# There is a symlink to copy, thus the -a
cp -ra voice/* ${SPOOL_DIR}
(cd ${SPOOL_DIR}/main/; ln -s ../messages/welcome .
 chmod 700 ../mailboxes)
echo "ok"

echo "Adding soft-link for definition file in /etc"
rm -f /etc/mvm_definitions.sh
ln -s $INSTALL_DIR/mvm_definitions.sh /etc/mvm_definitions.sh
if [ $? != 0 ]; then
   echo "softlink failed!"
   echo "command was:"
   echo "   ln -s $INSTALL_DIR/mvm_definitions.sh /etc/mvm_definitions.sh"
   echo "System not functionnal."
   exit 1
fi

echo "Generating prompts in ${SPOOL_DIR}/messages ..."
mkdir -p ${SPOOL_DIR}/messages
cp MESSAGES ${SPOOL_DIR}/messages

cp generate_messages.sh ${SPOOL_DIR}/messages/generate.sh
(cd ${SPOOL_DIR}/messages
 chmod 700 generate.sh
 ./generate.sh)

if [ "$FRENCH_NUMBERS_INSTALL" = "YES" ]; then
   echo "Installing french numbers generation"
   mkdir ${INSTALL_DIR}/add_ons
   cp -ra ../add_ons/french_numbers/ ${INSTALL_DIR}/add_ons
fi

if [ "$NOTIFY_ENABLE" = "yes" ]; then
   echo "Installing notify"
   mkdir ${INSTALL_DIR}/add_ons
   cp -ra ../add_ons/notify/ ${INSTALL_DIR}/add_ons
fi



echo ""
echo "Updating permissions"
chown -R root.root ${INSTALL_DIR}
chown -R root.root ${SPOOL_DIR}

if [ "$FRENCH_NUMBERS_INSTALL" = "YES" ]; then
   echo "Converting french numbers"
   ${INSTALL_DIR}/add_ons/convert.sh
fi

echo ""
echo "Installation complete."



