#! /bin/sh
# MVM Project (C) Marc SCHAEFER <schaefer@alphanet.ch>
# mvm_definitions.sh -- System definitions
# Creation: 14/02/98
# Update:   07/03/99
# V2.0 PV004
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This shell script (to be included through sourcing via '.' in sh)
#    is to be used by all the mvm software components. It contains
#    vital definitions. It is the only file modified by the
#    setup.sh script when installing the software and should not
#    be edited directly.
# BUGS
# TODO
#    - Split operational definitions (modem controls) of
#      instances of mvm systems. 
# NOTES
#    - A soft link from /etc/mvm_definitions.sh to this must exist.
# BASED-ON
#    voice_script.sh V1.3 PV004 of 08/02/98.
# MODIFICATION-HISTORY
#    14/02/98  schaefer  Created this file.
#    22/03/98  schaefer  Added notify support.
#    29/12/98  schaefer  MVM_INSTANCE implementation. NO_ASK for language.
#    07/03/99  schaefer  Support for new or old rsynth and sox executable
#                        location.
# $Id: mvm_definitions.sh,v 1.11 1999/03/07 10:54:05 schaefer Exp $

# Select the following between
#    unconditional         Always goes to voice mode
#    normal                Goes to voice mode if a DTMF is pressed within
#                          2 seconds and no data calling tone is detected
#    special               Goes to voice mode if after 2 seconds no calling
#                          tone nor DTMF are detected (UNIMPLEMENTED)
VOICE_MODE=unconditional

# Sets the default to English
# Setting to NO_ASK will disable asking and default will be the
# default language. Presetting it works.
if [ "$SELECTED_LANGUAGE" = "" ]; then
   SELECTED_LANGUAGE=
fi

# Set to for 1496 bug-fix, do not set otherwise.
#ENABLE_1496_RECORD_BUG_FIX='pvfcut -T 0.5'

# Next five lines are installation-specific and are corrected
# by setup.sh
PVF_TOOLS_DIR=/usr/lib/mgetty/pvftools/
SOX_EXECUTABLE=/users/schaefer/ported/sox10p11/sox
SAY_RSYNTH_EXECUTABLE=/users/schaefer/ported/rsynth/say
SAY_RSYNTH_EXECUTABLE_VERSION=1
SAY_RSYNTH_EXECUTABLE_ARGUMENTS=
SPEED_FREQUENCY_VALUE=9600
PVF_MODEM_FILTER='pvftormd ZyXEL_2864 4'
SELECT_RANDOM_FILE=/users/schaefer/bin/randomize
PVF_CUT="$PVF_TOOLS_DIR/pvfcut -H -0.5 -T -0.5"
#PVF_CUT="cat"
PVF_SPEED="$PVF_TOOLS_DIR/pvfspeed -s 9600"
PVF_AMP="$PVF_TOOLS_DIR/pvfamp -A 3.5"

# Should be small enough to ensure the variable does not
# wrap around. Anyway this should not happen.
MVM_MAX_ACCOUNT_NUMBER=5000

# Do not change anything from here. Well, basically because setup.sh does it.

if [ "$MVM_INSTANCE" != "" ]; then
   VOICEMAIL=/usr/spool/voice/instances/$MVM_INSTANCE
else
   VOICEMAIL=/usr/spool/voice
fi

MAILBOX_DIR=$VOICEMAIL/mailboxes
MAIN_MENU_DIR=$VOICEMAIL/main
AREAS_DIR=$VOICEMAIL/areas
SCRIPTS_DIR=/usr/lib/mgetty

# By default, notification active
NOTIFY_ENABLE=yes
NOTIFY_SCRIPT=$SCRIPTS_DIR/add_ons/notify/notify.sh

FRENCH_GENERATE_MESSAGE=$SCRIPTS_DIR/add_ons/french_numbers/speaches.sh
# Set the following to an unexistant language number to disable. Set
# to the number of the french language (1) to enable.
FRENCH_GENERATE_ENABLE=1

# NOTES
# - Format of the next file is
#      area_number owner access_level read_level write_level del_level
# - In an area (in $AREAS_DIR/number/) you have the file welcome, which
#   is played when you first enter the area. There is also the file
#   name which contains a spoken name for the area (spoken name must
#   be e.g. ``555 Generic discussions''
#   Access levels are clear, except del_level: this is the level which
#   allows to kill messages. The messages themselves are in the
#   subdirectory messages
#   Only the owner and the operator can change the area attributes.
# - With that scheme, only ONE menu is needed, with something like
#   1   read a public message
#   2   write a public message
#   4   change current area
#   7   edit current area
#   8   message to area owner
#   9   edit menu
#   #   message to menu owner
#   +   back_menu
AREA_MASTER_FILE=$AREAS_DIR/area_list
AREA_WELCOME_FILE=welcome
AREA_NAME_FILE=name
AREA_MESSAGES_DIRECTORY=messages

# The following directory will be used by random_sample, we will recursively
# list all files and take one at random, possibly decompressing it first
# if it is .gz, and converting it to modem format.
LIBRARY_DIR=/share/archives/sounds/diverse

TMPFILE=/tmp/fle_$$

CRASH_FILE=$VOICEMAIL/messages/crashed

INTRODUCTION_FILE=$VOICEMAIL/messages/welcome_here
NUMBER_FILE=$VOICEMAIL/messages/test
GOODBYE_FILE=$VOICEMAIL/messages/goodbye
LEAVE_MESSAGE_FILE=$VOICEMAIL/messages/leave_message
CONFIRM_FILE=$VOICEMAIL/messages/confirm

MAKE_ACCOUNT_FILE=$VOICEMAIL/messages/make_account
CHOOSE_PASSWORD_FILE=$VOICEMAIL/messages/choose_password
VERIFY_PASSWORD_FILE=$VOICEMAIL/messages/verify_password
PASSWORDS_DO_NOT_MATCH_FILE=$VOICEMAIL/messages/passwords_do_not_match
USER_NAME_FILE=$VOICEMAIL/messages/user_name
PERSONAL_INFO_FILE=$VOICEMAIL/messages/personal_info
FINDING_ID_FILE=$VOICEMAIL/messages/finding_id
ACCOUNT_MADE_FILE=$VOICEMAIL/messages/account_made

PASSWORD_ERROR_FILE=$VOICEMAIL/messages/password_error
PASSWORD_OK_FILE=$VOICEMAIL/messages/password_ok
ALREADY_LOGGED_FILE=$VOICEMAIL/messages/already_logged

ASK_CODE_FILE=$VOICEMAIL/messages/ask_code
ASK_PASSWORD_FILE=$VOICEMAIL/messages/ask_password

NO_MESSAGES_FILE=$VOICEMAIL/messages/no_messages
ONE_MESSAGE_FILE=$VOICEMAIL/messages/one_message
END_OF_MESSAGES_FILE=$VOICEMAIL/messages/end_of_messages
CONTROL_MESSAGE_FILE=$VOICEMAIL/messages/message_control

WHICH_RECIPIENT_FILE=$VOICEMAIL/messages/which_recipient
NO_SUCH_RECIPIENT_FILE=$VOICEMAIL/messages/no_such_recipient

SELECT_LANGUAGE_FILE=$VOICEMAIL/messages/select_language

EDIT_MENU_FILE=$VOICEMAIL/messages/edit_menu
EDIT_MENU_ITEM=$VOICEMAIL/messages/edit_menu_which_item
EDIT_MENU_ITEM_EXISTS=$VOICEMAIL/messages/edit_menu_item_exists
EDIT_MENU_NO_SUCH_ITEM=$VOICEMAIL/messages/edit_menu_no_such_item
EDIT_MENU_ITEM_TYPE=$VOICEMAIL/messages/edit_menu_item_type
EDIT_MENU_FILE_TYPE=$VOICEMAIL/menu_items_types # ASCII file
EDIT_MENU_ITEM_LEVEL=$VOICEMAIL/messages/edit_menu_item_level

EDIT_USER_FILE=$VOICEMAIL/messages/edit_user # tocreate

RECORD_TO_FILE=$VOICEMAIL/messages/record_to_file

YOUR_ACCOUNT_NUMBER_IS=$VOICEMAIL/messages/your_account_number
YOU_HAVE_SOUND=$VOICEMAIL/messages/you_have_sound
YOU_HAVE_MESSAGES=$VOICEMAIL/messages/you_have_messages
NEXT_MESSAGE_FROM=$VOICEMAIL/messages/next_message_from
WAS_RECORDED_ON=$VOICEMAIL/messages/was_recorded_on













