/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DirFilePane
extends JSplitPane {
    static boolean DEBUG = ltoolgui.DEBUG;
    String currentDrive;
    boolean avoidSelectionRetrigger = false;
    String fileSelectionRetrigger = "";
    boolean avoidExpansionRetrigger = false;
    String fileExpansionRetrigger = "";
    boolean avoidDragRetrigger = false;
    static final int BUFSIZE = 32768;
    static final int stLINfn = 56;
    String cache;
    String cachedDirectory;
    boolean cacheValid = false;
    JScrollPane lScrollPane = new JScrollPane();
    JScrollPane rScrollPane = new JScrollPane();
    Tree lTree;
    Tree rTree;
    boolean isLinux;

    public DirFilePane(boolean bl, String string, String string2) {
        DirFilePane.debugOutput("Creating DirFilePane isLinux=" + bl + " drive=" + string + " directory=" + string2);
        this.currentDrive = string;
        this.isLinux = bl;
        this.setFont(new Font("SansSerif", 1, 12));
        this.setSize(0, 0);
        this.lScrollPane.setOpaque(true);
        this.lScrollPane.setBounds(0, 0, 0, 0);
        this.rScrollPane.setOpaque(true);
        this.rScrollPane.setBounds(0, 0, 0, 0);
        this.lScrollPane.setMinimumSize(new Dimension(0, 0));
        this.rScrollPane.setMinimumSize(new Dimension(0, 0));
        this.setLeftComponent(this.lScrollPane);
        this.setRightComponent(this.rScrollPane);
        this.setDividerLocation(200);
        this.lTree = new Tree(true);
        this.rTree = new Tree(false);
        this.lTree.setNewRoot(string2);
        this.rTree.setNewRoot(string2);
        this.lTree.installListeners();
        this.rTree.installListeners();
        this.lTree.setBounds(0, 0, 0, 0);
        this.rTree.setBounds(0, 0, 0, 0);
        this.lScrollPane.setViewportView(this.lTree);
        this.rScrollPane.setViewportView(this.rTree);
        this.lTree.getSelectionModel().setSelectionMode(1);
        this.rTree.getSelectionModel().setSelectionMode(4);
    }

    static void debugOutput(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public void driveChanged(String string, String string2) {
        this.currentDrive = string;
        this.cacheValid = false;
        this.lTree.setNewRoot(string2);
        this.rTree.setNewRoot(string2);
    }

    class Tree
    extends JTree
    implements TreeWillExpandListener,
    TreeSelectionListener,
    MouseListener,
    DropTargetListener,
    DragSourceListener,
    DragGestureListener,
    KeyListener,
    Runnable {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode node;
        DefaultTreeModel treeModel;
        boolean isLeftTree;
        DragSource dragSource;
        DropTarget dropTarget;

        public Tree(boolean bl) {
            this.isLeftTree = bl;
        }

        boolean buildNewDosTree(String string) {
            DirFilePane.debugOutput("buildNewDosTree " + string);
            File file = new File(String.valueOf(DirFilePane.this.currentDrive) + string);
            if (!file.exists()) {
                return false;
            }
            if (!file.isDirectory()) {
                return false;
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(String.valueOf(DirFilePane.this.currentDrive) + string + File.separator + stringArray[n]);
                if (file2.isDirectory()) {
                    this.node = new DefaultMutableTreeNode(stringArray[n]);
                    this.root.add(this.node);
                    this.node.add(new DefaultMutableTreeNode(".."));
                } else if (!this.isLeftTree) {
                    this.root.add(new DefaultMutableTreeNode(stringArray[n]));
                }
                ++n;
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        boolean buildNewLinuxTree(String var1_1) {
            DirFilePane.debugOutput("buildNewLinuxTree " + var1_1);
            var5_2 = false;
            if (DirFilePane.this.cacheValid && var1_1.equals(DirFilePane.this.cachedDirectory)) {
                var3_3 = DirFilePane.this.cache;
            } else {
                var2_4 = "ldir -x -s" + DirFilePane.this.currentDrive + " " + var1_1;
                var3_3 = this.execOperatingSystemCommand(var2_4, false);
                DirFilePane.this.cacheValid = true;
                DirFilePane.this.cachedDirectory = var1_1;
                DirFilePane.this.cache = var3_3;
            }
            var6_5 = new StringTokenizer(var3_3, "\n\r");
            var2_4 = var6_5.nextToken();
            if (var2_4.length() < 56 || !var2_4.substring(56).equals(".")) {
                return false;
            }
            var2_4 = var6_5.nextToken();
            if (var2_4.length() >= 56 && var2_4.substring(56).equals("..")) ** GOTO lbl27
            return false;
lbl-1000:
            // 1 sources

            {
                var4_6 = var6_5.nextToken();
                if (var4_6.substring(0, 1).equals("d")) {
                    this.node = new DefaultMutableTreeNode(var4_6.substring(56));
                    this.root.add(this.node);
                    this.node.add(new DefaultMutableTreeNode(".."));
                    continue;
                }
                if (this.isLeftTree) continue;
                this.node = new DefaultMutableTreeNode(var4_6.substring(56));
                this.root.add(this.node);
lbl27:
                // 4 sources

                ** while (var6_5.hasMoreTokens())
            }
lbl28:
            // 1 sources

            return true;
        }

        public void deleteDosFile(TreePath treePath) {
            String string = this.getName(treePath, false);
            DirFilePane.debugOutput("deleteDosFile " + string);
            if (ltoolgui.myProg.ConfirmDelCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, "Do you really want to delete " + string, "LTOOLS", 0, 3) == 1) {
                return;
            }
            File file = new File(string);
            if (!file.delete()) {
                JOptionPane.showMessageDialog(this, "Could not delete file or directory " + string, "LTOOLS", 0);
                return;
            }
            TreePath treePath2 = this.getParentPath(treePath);
            DirFilePane.this.rTree.expandDosTree(treePath2);
            this.updateOtherTree(treePath2);
        }

        public void deleteLinuxFile(TreePath treePath) {
            String string = this.getName(treePath, true);
            DirFilePane.debugOutput("deleteLinuxFile " + string);
            if (ltoolgui.isLinuxReadOnly) {
                JOptionPane.showMessageDialog(this, "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first", "LTOOLS", 0);
                return;
            }
            if (ltoolgui.myProg.ConfirmDelCheckBox.isSelected() && JOptionPane.showConfirmDialog(this, "Do you really want to delete file " + string, "LTOOLS", 0, 3) == 1) {
                return;
            }
            String string2 = "ldir -WRITE -x -del -s" + DirFilePane.this.currentDrive + " " + string;
            if ((string2 = this.execOperatingSystemCommand(string2, false)).length() > 0) {
                JOptionPane.showMessageDialog(this, string2.trim(), "LTOOLS", 0);
                return;
            }
            DirFilePane.this.cacheValid = false;
            TreePath treePath2 = this.getParentPath(treePath);
            DirFilePane.this.rTree.expandLinuxTree(treePath2);
            this.updateOtherTree(treePath2);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DirFilePane.debugOutput("dragDropEnd---DragSource  " + dragSourceDropEvent.getDropSuccess());
            if (!dragSourceDropEvent.getDropSuccess()) {
                new Thread(this).start();
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DirFilePane.debugOutput("dragEnter---DropTarget");
            if (this.isLeftTree) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.getSelectionCount() > 1) {
                JOptionPane.showMessageDialog(this, "Sorry, only one item may be selected here", "LTOOLS", 0);
                return;
            }
            ltoolgui.copyFilePath = this.getSelectionPaths();
            ltoolgui.copyFileCount = this.getSelectionCount();
            if (ltoolgui.copyFilePath[0] == null) {
                return;
            }
            if (DirFilePane.this.avoidDragRetrigger) {
                return;
            }
            if (!((DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent()).isLeaf()) {
                DirFilePane.debugOutput("Drag failed - cannot drag directories");
                DirFilePane.this.avoidDragRetrigger = true;
                JOptionPane.showMessageDialog(this, "Sorry, cannot drag directories!", "LTOOLS", 0);
                DirFilePane.this.avoidDragRetrigger = false;
                return;
            }
            ltoolgui.copyFileDrive = DirFilePane.this.currentDrive;
            ltoolgui.copyFileIsLinux = DirFilePane.this.isLinux;
            ltoolgui.copyFileIsValid = true;
            DirFilePane.debugOutput("dragGestureRecognized " + ltoolgui.copyFilePath[0] + "   isLinux=" + DirFilePane.this.isLinux + "  isLeftTree=" + this.isLeftTree);
            try {
                this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, new StringSelection("dummy"), this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                DirFilePane.debugOutput("dragGestureRecognized.startDrag failed");
            }
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) throws InvalidDnDOperationException {
            DirFilePane.debugOutput("drop---DropTarget");
            if (!this.isLeftTree) {
                DirFilePane.debugOutput("Drag and drop failed");
                dropTargetDropEvent.rejectDrop();
                return;
            }
            TreePath treePath = this.getPathForLocation(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
            if (treePath == null) {
                DirFilePane.debugOutput("Drag and drop failed");
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            DirFilePane.debugOutput("drop target=" + treePath + "   isLinux=" + DirFilePane.this.isLinux + "  isLeftTree=" + this.isLeftTree);
            boolean bl = DirFilePane.this.isLinux ? DirFilePane.this.rTree.pasteToLinux(this.getTreePathFromTree(treePath, DirFilePane.this.lTree), false) : DirFilePane.this.rTree.pasteToDos(this.getTreePathFromTree(treePath, DirFilePane.this.lTree), false);
            DirFilePane.debugOutput("Copy did " + (bl ? "" : "NOT") + " succeed");
            dropTargetDropEvent.dropComplete(bl);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        String execOperatingSystemCommand(String string, boolean bl) {
            String string2 = "";
            Runtime runtime = Runtime.getRuntime();
            int n = 0;
            byte[] byArray = new byte[32768];
            if (ltoolgui.Connected && !bl) {
                return this.remoteOperatingSystemCommand(string);
            }
            DirFilePane.debugOutput("Executing operating system command: \n   " + string);
            try {
                Process process = runtime.exec(string);
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Failed Process waitFor " + interruptedException);
                }
                FileInputStream fileInputStream = new FileInputStream("zzz.zwz");
                while ((n = fileInputStream.read(byArray, 0, 32768)) >= 0) {
                    string2 = String.valueOf(string2) + new String(byArray, 0, n);
                    if (n > 0) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed I/O " + iOException);
                return "Executing operating system command failed:\n   " + string;
            }
            return string2;
        }

        boolean expandDosTree(TreePath treePath) {
            DirFilePane.debugOutput("expandDosTree   " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treePath);
            String string = File.separator;
            int n = 1;
            while (n < treePath.getPathCount()) {
                string = String.valueOf(string) + treePath.getPathComponent(n) + File.separator;
                ++n;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            while (defaultMutableTreeNode.getChildCount() > 0) {
                this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0));
            }
            File file = new File(String.valueOf(DirFilePane.this.currentDrive) + string);
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                File file2 = new File(String.valueOf(DirFilePane.this.currentDrive) + string + stringArray[n2]);
                if (file2.isDirectory()) {
                    this.node = new DefaultMutableTreeNode(stringArray[n2]);
                    this.treeModel.insertNodeInto(this.node, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.node.add(new DefaultMutableTreeNode(".."));
                } else if (!this.isLeftTree) {
                    this.node = new DefaultMutableTreeNode(stringArray[n2]);
                    this.treeModel.insertNodeInto(this.node, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                }
                ++n2;
            }
            if (defaultMutableTreeNode.getChildCount() == 0) {
                this.treeModel.insertNodeInto(new DefaultMutableTreeNode(".."), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return true;
            }
            return false;
        }

        boolean expandLinuxTree(TreePath treePath) {
            String string;
            String string2;
            DirFilePane.debugOutput("expandLinuxTree   " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treePath);
            String string3 = "/";
            int n = 1;
            while (n < treePath.getPathCount()) {
                string3 = String.valueOf(string3) + treePath.getPathComponent(n) + "/";
                ++n;
            }
            if (DirFilePane.this.cacheValid && string3.equals(DirFilePane.this.cachedDirectory)) {
                string2 = DirFilePane.this.cache;
            } else {
                string = "ldir -x -s" + DirFilePane.this.currentDrive + " " + string3;
                DirFilePane.this.cache = string2 = this.execOperatingSystemCommand(string, false);
                DirFilePane.this.cachedDirectory = string3;
                DirFilePane.this.cacheValid = true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
            string = stringTokenizer.nextToken();
            if (string.length() < 56 || !string.substring(56).equals(".")) {
                return true;
            }
            string = stringTokenizer.nextToken();
            if (string.length() < 56 || !string.substring(56).equals("..")) {
                return true;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            while (defaultMutableTreeNode.getChildCount() > 0) {
                this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0));
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.substring(0, 1).equals("d")) {
                    this.node = new DefaultMutableTreeNode(string4.substring(56));
                    this.treeModel.insertNodeInto(this.node, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.node.add(new DefaultMutableTreeNode(".."));
                    continue;
                }
                if (this.isLeftTree) continue;
                this.node = new DefaultMutableTreeNode(string4.substring(56));
                this.treeModel.insertNodeInto(this.node, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            if (defaultMutableTreeNode.getChildCount() == 0) {
                this.treeModel.insertNodeInto(new DefaultMutableTreeNode(".."), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return true;
            }
            return false;
        }

        void getFileFromHost(String string) {
            String string2 = "";
            int n = 0;
            byte[] byArray = new byte[32768];
            try {
                string2 = "SENDFILE\n";
                ltoolgui.qSend.write(string2, 0, string2.length());
                ltoolgui.qSend.flush();
                int n2 = ltoolgui.bReceive.read(byArray, 0, 32768);
                string2 = new String(byArray, 0, 32);
                int n3 = Integer.parseInt(string2.substring(0, string2.indexOf(10)));
                int n4 = 0;
                while (n4 < n2) {
                    if (byArray[n4] == 13) {
                        if (byArray[n4] == 10) {
                            n4 += 2;
                            break;
                        }
                        ++n4;
                        break;
                    }
                    if (byArray[n4] == 10) {
                        if (byArray[n4] == 13) {
                            n4 += 2;
                            break;
                        }
                        ++n4;
                        break;
                    }
                    ++n4;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                n = n2 - n4;
                fileOutputStream.write(byArray, n4, n);
                while (n < n3) {
                    n2 = ltoolgui.bReceive.read(byArray, 0, 32768);
                    n += n2;
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Failed I/O " + iOException);
                return;
            }
        }

        String getName(TreePath treePath, boolean bl) {
            String string = bl ? "/" : File.separator;
            String string2 = treePath.getPathCount() >= 2 ? String.valueOf(treePath.getPathComponent(0).toString()) + treePath.getPathComponent(1).toString() : treePath.getPathComponent(0).toString();
            int n = 2;
            while (n < treePath.getPathCount()) {
                string2 = String.valueOf(string2) + string + treePath.getPathComponent(n);
                ++n;
            }
            return string2;
        }

        TreePath getParentPath(TreePath treePath) {
            Object[] objectArray = new Object[treePath.getPathCount() - 1];
            int n = 0;
            while (n < treePath.getPathCount() - 1) {
                objectArray[n] = treePath.getPathComponent(n);
                ++n;
            }
            return new TreePath(objectArray);
        }

        TreePath getTreePathFromTree(TreePath treePath, Tree tree) {
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Object[] objectArray = new Object[treePath.getPathCount()];
            objectArray[0] = defaultMutableTreeNode;
            int n = 1;
            while (n < treePath.getPathCount()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(n);
                if (defaultMutableTreeNode2 == null) {
                    return null;
                }
                int n2 = 0;
                while (n2 < defaultMutableTreeNode.getChildCount()) {
                    if (defaultMutableTreeNode.getChildAt(n2).toString().equals(defaultMutableTreeNode2.toString())) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return null;
                }
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                objectArray[n] = defaultMutableTreeNode;
                ++n;
            }
            return new TreePath(objectArray);
        }

        public void installListeners() {
            this.addTreeWillExpandListener(this);
            this.addTreeSelectionListener(this);
            this.addMouseListener(this);
            if (!this.isLeftTree) {
                this.addKeyListener(this);
            }
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.dropTarget = new DropTarget(this, this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            TreePath[] treePathArray = this.getSelectionPaths();
            int n = this.getSelectionCount();
            if (keyEvent.getKeyCode() == 127) {
                if (DirFilePane.this.isLinux) {
                    int n2 = 0;
                    while (n2 < n) {
                        this.deleteLinuxFile(treePathArray[n2]);
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        this.deleteDosFile(treePathArray[n3]);
                        ++n3;
                    }
                }
                ltoolgui.myProg.ConfirmDelCheckBox.setSelected(true);
            } else if (keyEvent.getKeyCode() == 155) {
                if (n > 1) {
                    JOptionPane.showMessageDialog(this, "Sorry, only one item may be selected here", "LTOOLS", 0);
                    return;
                }
                if (!this.getModel().isLeaf(this.getSelectionPath().getLastPathComponent())) {
                    if (DirFilePane.this.isLinux) {
                        this.newLinuxDirectory(this.getSelectionPath());
                    } else {
                        this.newDosDirectory(this.getSelectionPath());
                    }
                }
            } else if (keyEvent.getKeyCode() == 10) {
                if (n > 1) {
                    JOptionPane.showMessageDialog(this, "Sorry, only one item may be selected here", "LTOOLS", 0);
                    return;
                }
                if (DirFilePane.this.isLinux) {
                    this.startLinuxApplication(this.getSelectionPath());
                } else {
                    this.startDosApplication(this.getSelectionPath());
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void modifyDosFile(TreePath treePath) {
            String string = this.getName(treePath, false);
            String string2 = treePath.getLastPathComponent().toString();
            DirFilePane.debugOutput("modifyDosFile " + string);
            File file = new File(string);
            String string3 = new Date(file.lastModified()).toString();
            String string4 = new Long(file.length()).toString();
            ModifyDosDialog modifyDosDialog = new ModifyDosDialog(ltoolgui.myProg, false, string2, string3, string4, file.isDirectory(), file.canWrite() ^ true);
            modifyDosDialog.setVisible(true);
            if (modifyDosDialog.getStatus() != 1) {
                return;
            }
            if (!modifyDosDialog.getFileName().equals(string2)) {
                file.renameTo(new File(String.valueOf(file.getParent()) + File.separator + modifyDosDialog.getFileName()));
                TreePath treePath2 = this.getParentPath(treePath);
                DirFilePane.this.rTree.expandDosTree(treePath2);
                this.updateOtherTree(treePath2);
            }
        }

        public void modifyLinuxFile(TreePath treePath) {
            String string = this.getName(treePath, true);
            String string2 = treePath.getLastPathComponent().toString();
            DirFilePane.debugOutput("modifyLinuxfile " + string);
            String string3 = "";
            String string4 = "      ";
            String string5 = "      ";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "ldir -x -s" + DirFilePane.this.currentDrive + " " + string;
            string9 = this.execOperatingSystemCommand(string9, false);
            StringTokenizer stringTokenizer = new StringTokenizer(string9, " ");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string9 = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        string3 = string9;
                        break;
                    }
                    case 1: {
                        string4 = String.valueOf(string4) + string9;
                        break;
                    }
                    case 2: {
                        string5 = String.valueOf(string5) + string9;
                        break;
                    }
                    case 3: {
                        string6 = string9;
                        break;
                    }
                    case 5: {
                        string7 = string9;
                        break;
                    }
                    case 6: {
                        string7 = String.valueOf(string7) + " " + string9;
                        break;
                    }
                    case 7: {
                        string8 = string9;
                        break;
                    }
                    case 8: {
                        string7 = String.valueOf(string7) + " " + string9;
                        break;
                    }
                }
                ++n;
            }
            ModifyLinuxDialog modifyLinuxDialog = new ModifyLinuxDialog(ltoolgui.myProg, false, string2, String.valueOf(string7) + " " + string8, string6, string4, string5, string3);
            modifyLinuxDialog.setVisible(true);
            if (modifyLinuxDialog.getStatus() != 1) {
                return;
            }
            if (ltoolgui.isLinuxReadOnly) {
                JOptionPane.showMessageDialog(this, "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first", "LTOOLS", 0);
                return;
            }
            string9 = "ldir -WRITE ";
            if (!modifyLinuxDialog.getFileName().equals(string2)) {
                string9 = String.valueOf(string9) + "-ren ";
            }
            string9 = String.valueOf(string9) + "-x -s" + DirFilePane.this.currentDrive + " -f" + modifyLinuxDialog.getAccess() + " ";
            if (!modifyLinuxDialog.getGid().equals(string5)) {
                string9 = String.valueOf(string9) + "-g" + modifyLinuxDialog.getGid() + " ";
            }
            if (!modifyLinuxDialog.getUid().equals(string4)) {
                string9 = String.valueOf(string9) + "-u" + modifyLinuxDialog.getUid() + " ";
            }
            string9 = String.valueOf(string9) + string + " ";
            if (!modifyLinuxDialog.getFileName().equals(string2)) {
                string9 = String.valueOf(string9) + modifyLinuxDialog.getFileName();
            }
            if ((string9 = this.execOperatingSystemCommand(string9, false)).length() > 0) {
                JOptionPane.showMessageDialog(this, string9.trim(), "LTOOLS", 0);
                return;
            }
            DirFilePane.this.cacheValid = false;
            TreePath treePath2 = this.getParentPath(treePath);
            DirFilePane.this.rTree.expandLinuxTree(treePath2);
            this.updateOtherTree(treePath2);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (mouseEvent.getClickCount() >= 2) {
                if (this.isLeftTree) {
                    return;
                }
                if (((DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    if (DirFilePane.this.isLinux) {
                        this.startLinuxApplication(treePath);
                    } else {
                        this.startDosApplication(treePath);
                    }
                } else if (this.isCollapsed(treePath)) {
                    this.expandPath(treePath);
                } else {
                    this.collapsePath(treePath);
                }
            } else if (mouseEvent.paramString().toLowerCase().indexOf("mods=4") > 0) {
                if (DirFilePane.this.isLinux) {
                    this.modifyLinuxFile(treePath);
                } else {
                    this.modifyDosFile(treePath);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        void newDosDirectory(TreePath treePath) {
            DirFilePane.debugOutput("newDosDirectory");
            String string = this.getName(treePath, false);
            ModifyDosDialog modifyDosDialog = new ModifyDosDialog(ltoolgui.myProg, true, "", "", "", true, false);
            modifyDosDialog.setVisible(true);
            if (modifyDosDialog.getStatus() != 1) {
                return;
            }
            if (!modifyDosDialog.getFileName().equals("")) {
                File file = new File(String.valueOf(string) + File.separator + modifyDosDialog.getFileName());
                if (!file.mkdir()) {
                    JOptionPane.showMessageDialog(this, "Could not create directory " + string + File.separator + modifyDosDialog.getFileName(), "LTOOLS", 0);
                }
                DirFilePane.this.rTree.expandDosTree(treePath);
                this.updateOtherTree(treePath);
            }
        }

        void newLinuxDirectory(TreePath treePath) {
            DirFilePane.debugOutput("newLinuxDirectory");
            String string = this.getName(treePath, true);
            if (ltoolgui.isLinuxReadOnly) {
                JOptionPane.showMessageDialog(this, "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first", "LTOOLS", 0);
                return;
            }
            ModifyLinuxDialog modifyLinuxDialog = new ModifyLinuxDialog(ltoolgui.myProg, true, "", "", "", "          0", "          0", "-rwxr-xr-x");
            modifyLinuxDialog.setVisible(true);
            if (modifyLinuxDialog.getStatus() != 1) {
                return;
            }
            if (ltoolgui.Connected) {
                this.putFileToHost("ldirtmpl");
            }
            String string2 = "ldir -WRITE ";
            string2 = modifyLinuxDialog.isLink() ? String.valueOf(string2) + "-link " : String.valueOf(string2) + "-mkdir ";
            string2 = String.valueOf(string2) + "-x -s" + DirFilePane.this.currentDrive + " -f" + modifyLinuxDialog.getAccess() + " -g" + modifyLinuxDialog.getGid().trim() + " -u" + modifyLinuxDialog.getUid().trim() + " ";
            string2 = modifyLinuxDialog.isLink() ? String.valueOf(string2) + modifyLinuxDialog.getTargetName() + " " : (ltoolgui.Connected ? String.valueOf(string2) + "zzz.xxx  " : String.valueOf(string2) + "ldirtmpl ");
            string2 = String.valueOf(string2) + string + "/" + modifyLinuxDialog.getFileName();
            if ((string2 = this.execOperatingSystemCommand(string2, false)).length() > 0) {
                JOptionPane.showMessageDialog(this, string2.trim(), "LTOOLS", 0);
                return;
            }
            DirFilePane.this.cacheValid = false;
            DirFilePane.this.rTree.expandLinuxTree(treePath);
            this.updateOtherTree(treePath);
        }

        public boolean pasteToDos(TreePath treePath, boolean bl) {
            String string = this.getName(treePath, false);
            int n = 0;
            while (n < ltoolgui.copyFileCount) {
                String string2;
                Object object;
                String string3 = this.getName(ltoolgui.copyFilePath[n], ltoolgui.copyFileIsLinux);
                String string4 = ltoolgui.copyFilePath[n].getLastPathComponent().toString();
                DirFilePane.debugOutput("pasteToDos " + string3 + " --> " + string + " as " + string4);
                if (ltoolgui.copyFileCount == 1) {
                    object = new FileDialog((Frame)ltoolgui.myProg, "LTOOLS Copy file " + string3, 1);
                    ((FileDialog)object).setDirectory(string);
                    ((FileDialog)object).setFile(string4);
                    ((Component)object).setVisible(true);
                    string4 = ((FileDialog)object).getFile();
                    if (string4 == null) {
                        DirFilePane.debugOutput("Empty file name, file not copied");
                        return true;
                    }
                    string2 = String.valueOf(((FileDialog)object).getDirectory()) + ((FileDialog)object).getFile();
                } else {
                    string2 = String.valueOf(string) + "\\" + string4;
                }
                if (ltoolgui.copyFileIsLinux) {
                    object = !ltoolgui.Connected ? "ldir -READ -x -s" + ltoolgui.copyFileDrive + " " + string3 + " " + string2 : "ldir -READ -x -s" + ltoolgui.copyFileDrive + " " + string3 + " " + "zzz.xxx";
                    if (((String)(object = this.execOperatingSystemCommand((String)object, false))).length() > 0) {
                        if (bl) {
                            JOptionPane.showMessageDialog(this, ((String)object).trim(), "LTOOLS", 0);
                        }
                        return false;
                    }
                    if (ltoolgui.Connected) {
                        this.getFileFromHost(string2);
                    }
                } else {
                    try {
                        int n2;
                        object = new FileInputStream(string3);
                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                        byte[] byArray = new byte[32768];
                        while ((n2 = ((FileInputStream)object).read(byArray, 0, 32768)) >= 0) {
                            fileOutputStream.write(byArray, 0, n2);
                            if (n2 > 0) continue;
                        }
                        ((FileInputStream)object).close();
                        fileOutputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (bl) {
                            JOptionPane.showMessageDialog(this, "Sorry, could not open file " + string3, "LTOOLS", 0);
                        }
                        return false;
                    }
                    catch (IOException iOException) {
                        if (bl) {
                            JOptionPane.showMessageDialog(this, "Sorry, could not write to " + string2, "LTOOLS", 0);
                        }
                        return false;
                    }
                }
                ++n;
            }
            ltoolgui.copyFileIsValid = false;
            ltoolgui.copyFileCount = 0;
            DirFilePane.this.rTree.expandDosTree(treePath);
            this.updateOtherTree(treePath);
            return true;
        }

        public boolean pasteToLinux(TreePath treePath, boolean bl) {
            String string = this.getName(treePath, true);
            int n = 0;
            while (n < ltoolgui.copyFileCount) {
                String string2;
                String string3 = this.getName(ltoolgui.copyFilePath[n], ltoolgui.copyFileIsLinux);
                String string4 = ltoolgui.copyFilePath[n].getLastPathComponent().toString();
                DirFilePane.debugOutput("pasteToLinux " + string3 + " --> " + string + " as " + string4);
                if (ltoolgui.isLinuxReadOnly) {
                    JOptionPane.showMessageDialog(this, "Your Linux filesystem is set to read only - change in menu 'File - Linux read only' first", "LTOOLS", 0);
                    return false;
                }
                if (ltoolgui.copyFileIsLinux) {
                    string2 = "ldir -READ -x -s" + ltoolgui.copyFileDrive + " " + string3 + " " + "zzz.tmp";
                    if ((string2 = this.execOperatingSystemCommand(string2, false)).length() > 0) {
                        if (bl) {
                            JOptionPane.showMessageDialog(this, string2.trim(), "LTOOLS", 0);
                        }
                        return false;
                    }
                    string2 = "ldir -WRITE -x -s" + DirFilePane.this.currentDrive + " -copy " + "zzz.tmp" + " " + string + "/" + string4;
                    if ((string2 = this.execOperatingSystemCommand(string2, false)).length() > 0) {
                        if (bl) {
                            JOptionPane.showMessageDialog(this, string2.trim(), "LTOOLS", 0);
                        }
                        return false;
                    }
                } else {
                    if (!ltoolgui.Connected) {
                        string2 = "ldir -WRITE -x -s" + DirFilePane.this.currentDrive + " -copy " + string3 + " " + string + "/" + string4;
                    } else {
                        this.putFileToHost(string3);
                        string2 = "ldir -WRITE -x -s" + DirFilePane.this.currentDrive + " -copy " + "zzz.xxx" + " " + string + "/" + string4;
                    }
                    string2 = this.execOperatingSystemCommand(string2, false);
                    if (string2.length() > 0) {
                        if (bl) {
                            JOptionPane.showMessageDialog(this, string2.trim(), "LTOOLS", 0);
                        }
                        return false;
                    }
                }
                ++n;
            }
            ltoolgui.copyFileIsValid = false;
            ltoolgui.copyFileCount = 0;
            DirFilePane.this.cacheValid = false;
            DirFilePane.this.rTree.expandLinuxTree(treePath);
            this.updateOtherTree(treePath);
            return true;
        }

        void putFileToHost(String string) {
            String string2 = "";
            int n = 0;
            byte[] byArray = new byte[32768];
            try {
                int n2;
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(string);
                string2 = "RECEIVEFILE\n" + file.length() + "\n";
                ltoolgui.qSend.write(string2, 0, string2.length());
                ltoolgui.qSend.flush();
                while ((n2 = fileInputStream.read(byArray, 0, 32768)) >= 0) {
                    ltoolgui.bSend.write(byArray, 0, n2);
                    n += n2;
                    if (n2 > 0) continue;
                }
                ltoolgui.bSend.flush();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Failed I/O " + iOException);
                return;
            }
        }

        String remoteOperatingSystemCommand(String string) {
            DirFilePane.debugOutput("Executing command on remote server: \n   " + string);
            String string2 = "";
            char[] cArray = new char[32768];
            try {
                String string3 = "EXECUTE\n" + string + "\n";
                ltoolgui.qSend.write(string3, 0, string3.length());
                ltoolgui.qSend.flush();
                string3 = ltoolgui.qReceive.readLine();
                int n = Integer.parseInt(string3);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = ltoolgui.qReceive.read(cArray, 0, n);
                    string3 = new String(cArray, 0, n3);
                    n2 += n3;
                    string2 = String.valueOf(string2) + string3;
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed I/O to " + iOException);
            }
            return string2;
        }

        public void run() {
            JOptionPane.showMessageDialog(this, "Sorry, copying did not succeed due to one of the following reasons:\n* You must drop your file in a left tree, not in a right one.\n* When dropping on a LINUX directory, it must not contain a file with the same name.", "LTOOLS", 0);
        }

        public void scrollPath(TreePath treePath) {
            DirFilePane.debugOutput("scrollPath      " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treePath);
            TreePath treePath2 = treePath;
            int n = this.getRowForPath(treePath2);
            int n2 = this.getVisibleRowCount() / 2;
            int n3 = this.getRowCount() - 1;
            int n4 = n + n2 - 1;
            if (n4 > n3) {
                n4 = n3;
            }
            this.scrollRowToVisible(0);
            this.scrollRowToVisible(n4);
        }

        void selectOtherTree(TreePath treePath) {
            Tree tree;
            DirFilePane.debugOutput("selectOtherTree " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treePath);
            if (this.isLeftTree) {
                tree = DirFilePane.this.rTree;
            } else {
                tree = DirFilePane.this.lTree;
                if (((DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    tree.clearSelection();
                    return;
                }
            }
            TreePath treePath2 = this.getTreePathFromTree(treePath, tree);
            if (treePath2 == null) {
                tree.clearSelection();
                return;
            }
            tree.scrollPath(treePath2);
            tree.setSelectionPath(treePath2);
        }

        public void setNewRoot(String string) {
            DirFilePane.debugOutput("setNewRoot " + string);
            if (DirFilePane.this.isLinux) {
                this.root = new DefaultMutableTreeNode(string);
                if (!this.buildNewLinuxTree(string)) {
                    this.root = new DefaultMutableTreeNode("DOES NOT EXIST - set another LINUX  drive");
                }
            } else {
                this.root = new DefaultMutableTreeNode(String.valueOf(DirFilePane.this.currentDrive) + string);
                if (!this.buildNewDosTree(string)) {
                    this.root = new DefaultMutableTreeNode("DOES NOT EXIST - set another DOS drive");
                }
            }
            this.treeModel = new DefaultTreeModel(this.root);
            this.setModel(this.treeModel);
        }

        public String showPartitions() {
            String string = this.execOperatingSystemCommand("ldir -x -part", true);
            String string2 = "Partition table info:\n";
            String string3 = "";
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while ((n = string.indexOf("#", n)) >= 0) {
                String string4;
                n2 = string.indexOf("\n", n);
                n3 = string.substring(n, n2).indexOf("Disk ");
                if (n3 > 0) {
                    string4 = string.substring(n, n2).substring(n3 + 5, n3 + 8);
                    string3 = string4.equals("128") ? "/dev/hda" : (string4.equals("129") ? "/dev/hdb" : (string4.equals("130") ? "/dev/hdc" : (string4.equals("131") ? "/dev/hdd" : (string4.equals("132") ? "/dev/hde" : (string4.equals("133") ? "/dev/hdf" : (string4.equals("134") ? "/dev/hdg" : (string4.equals("135") ? "/dev/hdh" : string4)))))));
                    string2 = String.valueOf(string2) + "------------------------------------------------\n";
                } else {
                    n3 = string.substring(n, n2).indexOf("Type:");
                    if (n3 > 0) {
                        String string5 = string.substring(n, n2).substring(1, 3);
                        string4 = string.substring(n, n2).substring(n3 + 5, n3 + 25);
                        string2 = String.valueOf(string2) + " " + string3 + string5 + " :   " + string4 + "\n";
                    }
                }
                n = n2;
            }
            return string2;
        }

        void startDosApplication(TreePath treePath) {
            DirFilePane.debugOutput("startDosApplication");
            if (!File.separator.equals("\\")) {
                JOptionPane.showMessageDialog(this, "Sorry, starting applications only supported under Dos", "LTOOLS", 0);
                return;
            }
            String string = this.getName(treePath, false);
            String string2 = "runit.bat " + string;
            string2 = this.execOperatingSystemCommand(string2, true);
        }

        void startLinuxApplication(TreePath treePath) {
            DirFilePane.debugOutput("startLinuxApplication");
            if (!File.separator.equals("\\")) {
                JOptionPane.showMessageDialog(this, "Sorry, starting applications only supported under Dos", "LTOOLS", 0);
                return;
            }
            String string = this.getName(treePath, true);
            String string2 = treePath.getLastPathComponent().toString();
            int n = string2.indexOf("->");
            if (n != -1) {
                string2 = string2.substring(n + 3);
            }
            String string3 = ltoolgui.Connected ? "ldir -READ -x -s" + DirFilePane.this.currentDrive + " " + string + " " + "zzz.xxx" : "ldir -READ -x -s" + DirFilePane.this.currentDrive + " " + string + " " + string2;
            if ((string3 = this.execOperatingSystemCommand(string3, false)).length() > 0) {
                JOptionPane.showMessageDialog(this, string3.trim(), "LTOOLS", 0);
                return;
            }
            if (ltoolgui.Connected) {
                this.getFileFromHost(string2);
            }
            string3 = "runit.bat /wait " + string2;
            this.execOperatingSystemCommand(string3, true);
            File file = new File(string2);
            if (file != null) {
                file.delete();
            }
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            DirFilePane.debugOutput("Tree collapse   " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treeExpansionEvent.getPath());
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            DirFilePane.debugOutput("Tree expanded   " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treePath + " " + DirFilePane.this.avoidExpansionRetrigger);
            if (DirFilePane.this.avoidExpansionRetrigger && this.getName(treePath, DirFilePane.this.isLinux).equals(DirFilePane.this.fileExpansionRetrigger)) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                DirFilePane.this.avoidExpansionRetrigger = false;
                if (this.isLeftTree && ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getChildCount() == 1 && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getChildAt(0).toString().equals("..")) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
                return;
            }
            DirFilePane.this.avoidExpansionRetrigger = true;
            DirFilePane.this.fileExpansionRetrigger = this.getName(treePath, DirFilePane.this.isLinux);
            boolean bl = DirFilePane.this.isLinux ? this.expandLinuxTree(treePath) : this.expandDosTree(treePath);
            if (bl) {
                if (this.isLeftTree) {
                    this.updateOtherTree(treePath);
                    throw new ExpandVetoException(treeExpansionEvent);
                }
            } else {
                this.updateOtherTree(treePath);
            }
        }

        void updateOtherTree(TreePath treePath) {
            DirFilePane.debugOutput("updateOtherTree " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treePath);
            Tree tree = this.isLeftTree ? DirFilePane.this.rTree : DirFilePane.this.lTree;
            TreePath treePath2 = this.getTreePathFromTree(treePath, tree);
            if (treePath2 == null) {
                return;
            }
            if (DirFilePane.this.isLinux) {
                tree.expandLinuxTree(treePath2);
            } else {
                tree.expandDosTree(treePath2);
            }
            tree.expandPath(treePath2);
            tree.scrollPath(treePath2);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DirFilePane.debugOutput("Tree selection  " + (this.isLeftTree ? "lTree" : "rTree") + (DirFilePane.this.isLinux ? " Linux " : " Dos   ") + treeSelectionEvent.getPath() + " " + DirFilePane.this.avoidSelectionRetrigger);
            if (this.getSelectionPath() == null) {
                return;
            }
            if (DirFilePane.this.avoidSelectionRetrigger && this.getName(this.getSelectionPath(), DirFilePane.this.isLinux).equals(DirFilePane.this.fileSelectionRetrigger)) {
                DirFilePane.this.avoidSelectionRetrigger = false;
                return;
            }
            DirFilePane.this.avoidSelectionRetrigger = true;
            DirFilePane.this.fileSelectionRetrigger = this.getName(this.getSelectionPath(), DirFilePane.this.isLinux);
            if (DirFilePane.this.isLinux) {
                ltoolgui.myProg.DosPane.lTree.clearSelection();
                ltoolgui.myProg.DosPane.rTree.clearSelection();
            } else {
                ltoolgui.myProg.LinuxPane.lTree.clearSelection();
                ltoolgui.myProg.LinuxPane.rTree.clearSelection();
            }
            this.selectOtherTree(treeSelectionEvent.getPath());
        }
    }
}

