import java.awt. *;
import java.awt.event.*;
import javax.swing. *;

public class RemoteBoxDialog extends JDialog
{   static final int CANCEL = 0;
    static final int OK = 1;

    int status = CANCEL;


    public RemoteBoxDialog(Frame parentFrame, String hostName, String portNumber)
    {   super(parentFrame);
	// This code is automatically generated by Visual Cafe when you add
	// components to the visual environment. It instantiates and initializes
	// the components. To modify the code, only use code syntax that matches
	// what Visual Cafe can generate, or Visual Cafe may be unable to back
	// parse your Java file into its visual environment.
	//{{INIT_CONTROLS
		setModal(true);
		setTitle("LTOOL Connect to remote host");
		getContentPane().setLayout(new GridLayout(3,2,0,0));
		setSize(366,110);
		setVisible(false);
		Text1Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text1Label.setText("Remote host");
		getContentPane().add(Text1Label);
		Text1Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text1Label.setBounds(0,0,183,36);
		getContentPane().add(hostNameField);
		hostNameField.setFont(new Font("SansSerif", Font.BOLD, 12));
		hostNameField.setBounds(183,0,183,36);
		Text2Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text2Label.setText("Port number:");
		getContentPane().add(Text2Label);
		Text2Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text2Label.setBounds(0,36,183,36);
		getContentPane().add(portNumberField);
		portNumberField.setFont(new Font("SansSerif", Font.BOLD, 12));
		portNumberField.setBounds(183,36,183,36);
		okButton.setText("OK");
		okButton.setOpaque(false);
		okButton.setActionCommand("OK");
		okButton.setMnemonic((int)'O');
		getContentPane().add(okButton);
		okButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		okButton.setBounds(0,72,183,36);
		cancelButton.setText("Cancel");
		cancelButton.setActionCommand("Cancel");
		getContentPane().add(cancelButton);
		cancelButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		cancelButton.setBounds(183,72,183,36);
		//}}
	hostNameField.setText(hostName);
	portNumberField.setText(portNumber);
	
	//{{REGISTER_LISTENERS
	SymWindow aSymWindow = new SymWindow();
	 this.addWindowListener(aSymWindow);
	SymAction lSymAction = new SymAction();
	 okButton.addActionListener(lSymAction);
	 cancelButton.addActionListener(lSymAction);
	//}}
    }


    public int getStatus()
    {   return status;
    }

    public String getHostName()
    {   return hostNameField.getText();
    }

    public int getPortNumber()
    {   return ( new Integer(portNumberField.getText())).intValue();
    }

    public void setVisible(boolean b)
    {   if (b)
        {   Rectangle bounds = (getParent()).getBounds();
	    Dimension size = getSize();
	     setLocation(bounds.x + (bounds.width - size.width) / 2,
			 bounds.y + (bounds.height - size.height) / 2);
	}
	super.setVisible(b);
    }

    public void addNotify()
    {								// Record the size of the window prior to calling parents addNotify.
	Dimension d = getSize();

	 super.addNotify();

	if (fComponentsAdjusted)
	     return;
	// Adjust components according to the insets
	Insets insets = getInsets();
	 setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
	Component components[] = getContentPane().getComponents();
	for (int i = 0; i < components.length; i++)
        {   Point p = components[i].getLocation();
	     p.translate(insets.left, insets.top);
	     components[i].setLocation(p);
	}
	fComponentsAdjusted = true;
    }

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
	javax.swing.JLabel Text1Label = new javax.swing.JLabel();
	javax.swing.JTextField hostNameField = new javax.swing.JTextField();
	javax.swing.JLabel Text2Label = new javax.swing.JLabel();
	javax.swing.JTextField portNumberField = new javax.swing.JTextField();
	javax.swing.JButton okButton = new javax.swing.JButton();
	javax.swing.JButton cancelButton = new javax.swing.JButton();
	//}}

    class SymWindow extends java.awt.event.WindowAdapter
    {   public void windowClosing(java.awt.event.WindowEvent event)
        {   Object object = event.getSource();
	    if (object == RemoteBoxDialog.this)
		 jAboutDialog_windowClosing(event);
	}
    }

    void jAboutDialog_windowClosing(java.awt.event.WindowEvent event)
    {								// to do: code goes here.

	jAboutDialog_windowClosing_Interaction1(event);
    }

    void jAboutDialog_windowClosing_Interaction1(java.awt.event.WindowEvent event)
    {   try
	{							// JAboutDialog Hide the JAboutDialog
	    this.setVisible(false);
	}
	catch(Exception e)
        {
        }
    }

    class SymAction implements java.awt.event.ActionListener
    {   public void actionPerformed(java.awt.event.ActionEvent event)
        {   Object object = event.getSource();
	    if (object == okButton)
		 okButton_actionPerformed(event);
	    else if (object == cancelButton)
		 cancelButton_actionPerformed(event);
	}
    }

    void okButton_actionPerformed(java.awt.event.ActionEvent event)
    {   status = OK;
	try
	{							// JAboutDialog Hide the JAboutDialog
	    this.setVisible(false);
	}
	catch(Exception e)
        {
        }
    }

    void cancelButton_actionPerformed(java.awt.event.ActionEvent event)
    {   status = CANCEL;
	try
	{							// JAboutDialog Hide the JAboutDialog
	    this.setVisible(false);
	}
	catch(Exception e)
        {
        }
    }

    //This is only used for debugging purposes to run as stand alone program
    static public void main(String args[])
    {	JFrame myFrame = new JFrame("RemoteBoxDialog Test");
        myFrame.setSize(600,400);
        myFrame.setVisible(true);
    	RemoteBoxDialog myDialog = new RemoteBoxDialog(myFrame,"localhost","1605");
    	myDialog.setVisible(true);
    	myFrame.addWindowListener(new WindowAdapter()
        {   public void windowClosing(WindowEvent e)
            {   System.exit(0);
	    }
	});
    }
}

