/* LTOOLgui.java

   Java based graphical user interface for the LTOOLS toolkit.

   Requires Java 1.1 or newer. Does run as a standalone application, not as an applet.

   Copyright (C) 1999-2000 Werner Zimmermann(Werner.Zimmermann@fht-esslingen.de)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For further information please see file README.TXT.

   ---History, Changes:-----------------------------------------------------------
   V2.0: First release of a Swing based version. Versions before V2.0 were based on AWT
   and released under the name LREADgui. The conversion to Swing is based on pre-
   works by Sebastian Schmar. Many thanks!
   This program requires JDK 1.2 or newer
   W. Zimmermann, 15 March 2000

   V2.1: Include a dialog box showing partition table of all harddisks.
   Add menu item to toggle the Linux filesystem between read only (default) and read write.
   W. Zimmermann, 3. Nov. 2000

   V2.2: Allow multiple selection of files for copy and delete
   W. Zimmermann, 24. Nov. 2000

 */
import java.awt. *;
import java.awt.event. *;
import java.io. *;
import java.net. *;

import javax.swing. *;
import javax.swing.event. *;
import javax.swing.tree. *;


public class ltoolgui extends javax.swing.JFrame
{   static final String VERSION = "V2.2";
    static boolean DEBUG = false;				//set to 'true', if you want to get all these debug messages

    static ltoolgui myProg;
    static String lreadguiDirectory;
    static String defaultDosDrive = "c:";
    static String defaultDosDirectory = "\\";
    static String defaultLinuxDrive = "/dev/hda";
    static String defaultLinuxDirectory = "/";

    static TreePath[] copyFilePath;
    static int copyFileCount;
    static String copyFileDrive;
    static boolean copyFileIsLinux;
    static boolean copyFileIsValid = false;

    static Socket qSocket = null;				//Socket for remote connection
    static BufferedInputStream bReceive = null;			//Receive stream
    static BufferedOutputStream bSend = null;			//Transmit stream
    static BufferedReader qReceive = null;			//Receive stream
    static BufferedWriter qSend = null;				//Transmit stream
    static String hostname = "localhost";
    static int port = 1605;					//Server port number
    static boolean Connected = false;
    static boolean isLinuxReadOnly;

    public ltoolgui()
    {								// This code is automatically generated by Visual Cafe when you add
	// components to the visual environment. It instantiates and initializes
	// the components. To modify the code, only use code syntax that matches
	// what Visual Cafe can generate, or Visual Cafe may be unable to back
	// parse your Java file into its visual environment.
	//{{INIT_CONTROLS
	setDefaultCloseOperation(javax.swing.JFrame.DO_NOTHING_ON_CLOSE);
	setJMenuBar(JMenuBar1);
	getContentPane().setLayout(new BorderLayout(0, 0));
	getContentPane().setFont(new Font("SansSerif", Font.BOLD, 12));
	setSize(800, 600);
	setVisible(false);
	ToolbarPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	getContentPane().add(BorderLayout.NORTH, ToolbarPanel);
	ToolbarPanel.setBounds(0, 0, 640, 36);
	JToolBar1.setAlignmentY(0.222222F);
	ToolbarPanel.add(JToolBar1);
	JToolBar1.setBounds(0, 0, 520, 36);
	newButton.setDefaultCapable(false);
	newButton.setToolTipText("Create a new directory");
	newButton.setText(" New  ");
	newButton.setActionCommand(" New  ");
	newButton.setMnemonic((int) 'N');
	JToolBar1.add(newButton);
	newButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	newButton.setBounds(16, 9, 69, 25);
	modifyButton.setDefaultCapable(false);
	modifyButton.setToolTipText("Change file names and attributes");
	modifyButton.setText("Modify");
	modifyButton.setActionCommand("Modify");
	modifyButton.setMnemonic((int) 'M');
	JToolBar1.add(modifyButton);
	modifyButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	modifyButton.setBounds(85, 9, 69, 25);
	delButton.setDefaultCapable(false);
	delButton.setToolTipText("Delete a file or directory");
	delButton.setText(" Del   ");
	delButton.setActionCommand(" Del   ");
	delButton.setMnemonic((int) 'D');
	JToolBar1.add(delButton);
	delButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	delButton.setBounds(154, 9, 65, 25);
	copyButton.setDefaultCapable(false);
	copyButton.setToolTipText("Copy a file");
	copyButton.setText("Copy");
	copyButton.setActionCommand("Copy");
	copyButton.setMnemonic((int) 'C');
	JToolBar1.add(copyButton);
	copyButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	copyButton.setBounds(219, 9, 63, 25);
	pasteButton.setDefaultCapable(false);
	pasteButton.setToolTipText("Insert a file");
	pasteButton.setText("Paste");
	pasteButton.setActionCommand("Paste");
	pasteButton.setMnemonic((int) 'P');
	JToolBar1.add(pasteButton);
	pasteButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	pasteButton.setBounds(282, 9, 67, 25);
	JLabel6.setText("     ");
	JToolBar1.add(JLabel6);
	JLabel6.setFont(new Font("Dialog", Font.PLAIN, 12));
	JLabel6.setBounds(349, 2, 15, 15);

	infoButton.setDefaultCapable(false);
	infoButton.setToolTipText("Show Harddisk Partitions");
	infoButton.setText("Partitions");
	infoButton.setActionCommand("Partitions");
	infoButton.setMnemonic((int) 'I');
	JToolBar1.add(infoButton);
	infoButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	infoButton.setBounds(364, 9, 87, 25);

	helpButton.setDefaultCapable(false);
	helpButton.setToolTipText("Help");
	helpButton.setText(" Help ");
	helpButton.setActionCommand("Help ");
	helpButton.setMnemonic((int) 'H');
	JToolBar1.add(helpButton);
	helpButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	helpButton.setBounds(451, 9, 67, 25);

	CenterPanel.setLayout(new BorderLayout(0, 0));
	getContentPane().add(BorderLayout.CENTER, CenterPanel);
	CenterPanel.setBounds(0, 36, 640, 564);
	DosDrivePanel.setLayout(new GridLayout(1, 5, 0, 0));
	CenterPanel.add(BorderLayout.NORTH, DosDrivePanel);
	DosDrivePanel.setBackground(java.awt.Color.lightGray);
	DosDrivePanel.setBounds(0, 0, 640, 25);
	JLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
	JLabel1.setText("DOS drive:");
	DosDrivePanel.add(JLabel1);
	JLabel1.setForeground(java.awt.Color.blue);
	JLabel1.setFont(new Font("SansSerif", Font.BOLD, 12));
	JLabel1.setBounds(0, 0, 128, 25);
	DosDrivePanel.add(DosDriveName);
	DosDriveName.setBounds(128, 0, 128, 25);
	DosSetDriveButton.setToolTipText("Set DOS drive");
	DosSetDriveButton.setText("Set drive");
	DosSetDriveButton.setActionCommand("Set drive");
	DosDrivePanel.add(DosSetDriveButton);
	DosSetDriveButton.setFont(new Font("SansSerif", Font.PLAIN, 12));
	DosSetDriveButton.setBounds(256, 0, 128, 25);
	DosDrivePanel.add(JLabel2);
	JLabel2.setBounds(384, 0, 128, 25);
		ConfirmDelCheckBox.setSelected(true);
		ConfirmDelCheckBox.setText("Confirm Delete");
		ConfirmDelCheckBox.setActionCommand("Confirm Delete");
		DosDrivePanel.add(ConfirmDelCheckBox);
		ConfirmDelCheckBox.setFont(new Font("SansSerif", Font.PLAIN, 12));
		ConfirmDelCheckBox.setBounds(512,0,128,25);
	LinuxDrivePanel.setLayout(new GridLayout(1, 5, 0, 0));
	CenterPanel.add(BorderLayout.SOUTH, LinuxDrivePanel);
	LinuxDrivePanel.setBackground(java.awt.Color.lightGray);
	LinuxDrivePanel.setBounds(0, 539, 640, 25);
	JLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
	JLabel4.setText("LINUX drive:");
	LinuxDrivePanel.add(JLabel4);
	JLabel4.setForeground(java.awt.Color.blue);
	JLabel4.setFont(new Font("SansSerif", Font.BOLD, 12));
	JLabel4.setBounds(0, 0, 128, 25);
	LinuxDrivePanel.add(LinuxDriveName);
	LinuxDriveName.setBounds(128, 0, 128, 25);
	LinuxSetDriveButton.setToolTipText("Set LINUX drive");
	LinuxSetDriveButton.setText("Set drive");
	LinuxSetDriveButton.setActionCommand("Set drive");
	LinuxDrivePanel.add(LinuxSetDriveButton);
	LinuxSetDriveButton.setFont(new Font("SansSerif", Font.BOLD, 12));
	LinuxSetDriveButton.setBounds(256, 0, 128, 25);
	RemoteButton.setToolTipText("Connect to a remote host (host must be running LREADjav)");
	RemoteButton.setText("Connect");
	RemoteButton.setActionCommand("Connect");
	LinuxDrivePanel.add(RemoteButton);
	RemoteButton.setFont(new Font("SansSerif", Font.BOLD, 12));
	RemoteButton.setBounds(384, 0, 128, 25);
	ExitButton.setToolTipText("Press to close ltoolsgui");
	ExitButton.setText("Exit");
	ExitButton.setActionCommand("Exit");
	ExitButton.setMnemonic((int) 'X');
	LinuxDrivePanel.add(ExitButton);
	ExitButton.setFont(new Font("SansSerif", Font.BOLD, 12));
	ExitButton.setBounds(512, 0, 128, 25);
	ExplorerSplitPane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
	CenterPanel.add(BorderLayout.CENTER, ExplorerSplitPane);
	ExplorerSplitPane.setBounds(0, 25, 640, 514);
	//$$ JMenuBar1.move(0,0);
	fileMenu.setText("File");
	fileMenu.setActionCommand("File");
	fileMenu.setFont(new java.awt.Font("SansSerif", java.awt.Font.BOLD, 12));
	fileMenu.setMnemonic((int) 'F');
	JMenuBar1.add(fileMenu);
	RemoteMenuItem.setText("Remote connect");
	RemoteMenuItem.setActionCommand("Exit");
	RemoteMenuItem.setMnemonic((int) 'R');
	fileMenu.add(RemoteMenuItem);
	ReadOnlyMenuItem.setToolTipText("Set Linux Filesystem to read only");
	ReadOnlyMenuItem.setText("Linux read only");
	ReadOnlyMenuItem.setActionCommand("Linux read only");
	ReadOnlyMenuItem.setSelected(true);
	fileMenu.add(ReadOnlyMenuItem);
	exitItem.setText("Exit");
	exitItem.setActionCommand("Exit");
	exitItem.setMnemonic((int) 'X');
	fileMenu.add(exitItem);
	editMenu.setText("Edit");
	editMenu.setActionCommand("Edit");
	editMenu.setFont(new java.awt.Font("SansSerif", java.awt.Font.BOLD, 12));
	editMenu.setMnemonic((int) 'E');
	JMenuBar1.add(editMenu);
	newItem.setText("New");
	newItem.setActionCommand("New");
	newItem.setMnemonic((int) 'N');
	editMenu.add(newItem);
	modifyItem.setText("Modify");
	modifyItem.setActionCommand("Modify");
	modifyItem.setMnemonic((int) 'M');
	editMenu.add(modifyItem);
	delItem.setText("Delete");
	delItem.setActionCommand("Delete");
	delItem.setMnemonic((int) 'D');
	editMenu.add(delItem);
	copyItem.setText("Copy");
	copyItem.setActionCommand("Copy");
	copyItem.setMnemonic((int) 'C');
	editMenu.add(copyItem);
	pasteItem.setText("Paste");
	pasteItem.setActionCommand("Paste");
	pasteItem.setMnemonic((int) 'P');
	editMenu.add(pasteItem);
	helpMenu.setText("Help");
	helpMenu.setActionCommand("Help");
	helpMenu.setFont(new java.awt.Font("SansSerif", java.awt.Font.BOLD, 12));
	helpMenu.setMnemonic((int) 'H');
	JMenuBar1.add(helpMenu);
	partitionItem.setText("Show Harddisk Partitions");
	partitionItem.setActionCommand("Show Harddisk Partions...");
	partitionItem.setMnemonic((int) 'I');
	helpMenu.add(partitionItem);
	helpMenu.add(JSeparator2);
	helpItem.setText("Help...");
	helpItem.setActionCommand("Help...");
	helpItem.setMnemonic((int) 'H');
	helpMenu.add(helpItem);
	helpMenu.add(JSeparator1);
	aboutItem.setText("About...");
	aboutItem.setActionCommand("About...");
	aboutItem.setMnemonic((int) 'A');
	helpMenu.add(aboutItem);
	//}}

	setTitle("LTOOLgui " + myProg.VERSION + " Werner.Zimmermann@fht-esslingen.de");
	newButton.setIcon(new ImageIcon("images/new.gif"));
	modifyButton.setIcon(new ImageIcon("images/modify.gif"));
	delButton.setIcon(new ImageIcon("images/cut.gif"));
	copyButton.setIcon(new ImageIcon("images/copy.gif"));
	pasteButton.setIcon(new ImageIcon("images/paste.gif"));
	helpButton.setIcon(new ImageIcon("images/help.gif"));
	infoButton.setIcon(new ImageIcon("images/about.gif"));
	DosPane = new DirFilePane(false, defaultDosDrive, defaultDosDirectory);
	LinuxPane = new DirFilePane(true, defaultLinuxDrive, defaultLinuxDirectory);
	ExplorerSplitPane.setTopComponent(DosPane);
	ExplorerSplitPane.setBottomComponent(LinuxPane);
	ExplorerSplitPane.setDividerLocation(0.5);
	DosDriveName.setText(defaultDosDrive);
	LinuxDriveName.setText(defaultLinuxDrive);

	//{{INIT_MENUS
	//}}

	//{{REGISTER_LISTENERS
	SymWindow aSymWindow = new SymWindow();
	 this.addWindowListener(aSymWindow);
	SymAction lSymAction = new SymAction();
	 exitItem.addActionListener(lSymAction);
	 aboutItem.addActionListener(lSymAction);
	 helpButton.addActionListener(lSymAction);
	 ExitButton.addActionListener(lSymAction);
	 helpItem.addActionListener(lSymAction);
	 newButton.addActionListener(lSymAction);
	 delButton.addActionListener(lSymAction);
	 copyButton.addActionListener(lSymAction);
	 pasteButton.addActionListener(lSymAction);
	 newItem.addActionListener(lSymAction);
	 delItem.addActionListener(lSymAction);
	 copyItem.addActionListener(lSymAction);
	 pasteItem.addActionListener(lSymAction);
	 DosSetDriveButton.addActionListener(lSymAction);
	 LinuxSetDriveButton.addActionListener(lSymAction);
	 infoButton.addActionListener(lSymAction);
	 DosDriveName.addActionListener(lSymAction);
	 LinuxDriveName.addActionListener(lSymAction);
	 modifyButton.addActionListener(lSymAction);
	 modifyItem.addActionListener(lSymAction);
	 RemoteButton.addActionListener(lSymAction);
	 RemoteMenuItem.addActionListener(lSymAction);
	 partitionItem.addActionListener(lSymAction);
	 ReadOnlyMenuItem.addActionListener(lSymAction);
	//}}

	 isLinuxReadOnly = ReadOnlyMenuItem.isSelected();
    }

    /**
     * Creates a new instance of ltoolgui with the given title.
     * @param sTitle the title for the new frame.
     * @see #ltoolgui()
     */
    public ltoolgui(String sTitle)
    {   this();
	setTitle(sTitle);
    }

	/**
	 * The entry point for this application.
	 * Sets the Look and Feel to the System Look and Feel.
	 * Creates a new ltoolgui and makes it visible.
	 */
    static public void main(String args[])
    {   int i = 0;
	 try
        {   if (args.length > 0)
            {   if ((args[0].startsWith("-h")) || (args[0].startsWith("-?")))
                {   System.out.println("LTOOLS Graphical User Interface " + myProg.VERSION + "\n(C) 1999-2000 Werner.Zimmermann@fht-esslingen.de\n\n"
				       + "Usage:  LTOOLgui [-d] [Linux_drive [DOS_drive]]\n"
				       + "Note:   Java 1.2 or newer needed\n"
				       + "        set DOS_drive to \"\" if running LTOOLgui on a UNIX host\n\n");
		    System.exit(0);				// close the application
		}
		if (args[0].startsWith("-d"))
                {   DEBUG = true;
		    i = 1;
		}
	    }
	    if (args.length > i)
		 defaultLinuxDrive = args[i];
	    if (args.length > i + 1)
		defaultDosDrive = args[i + 1];

	    lreadguiDirectory = System.getProperty("user.dir");
	    if (File.separator.equals("/"))			//Unix-like systems do not use disk drive names
            {   defaultDosDrive = "";				//in their pathnames
		defaultDosDirectory = "/";
	    }
	    try							//Change the look and feel to platform specific
            {   UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    }
	    catch(Exception e)
            {
            }

	    //Create a new instance of our application's frame, and make it visible.
	    myProg = new ltoolgui();
	    myProg.setVisible(true);

	    System.out.println("LTOOLS GUI " + VERSION + " (C) 1999-2000 Werner.Zimmermann@fht-esslingen.de\n"
		    + "Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " "
			       + System.getProperty("os.version") + "\n"
			       + "Java VM         : " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n");
	}
	catch(Throwable t)
        {   t.printStackTrace();
	    //Ensure the application exits with an error condition.
	    System.exit(1);
	}
    }

    /**
     * Notifies this component that it has been added to a container
     * This method should be called by <code>Container.add</code>, and
     * not by user code directly.
     * Overridden here to adjust the size of the frame if needed.
     * @see java.awt.Container#removeNotify
     */
    public void addNotify()
    {								// Record the size of the window prior to calling parents addNotify.
	Dimension size = getSize();

	 super.addNotify();

	if (frameSizeAdjusted)
	     return;
	 frameSizeAdjusted = true;

	// Adjust size of frame according to the insets and menu bar
	 javax.swing.JMenuBar menuBar = getRootPane().getJMenuBar();
	int menuBarHeight = 0;
	if (menuBar != null)
	     menuBarHeight = menuBar.getPreferredSize().height;
	Insets insets = getInsets();
	 setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    // Used by addNotify
    boolean frameSizeAdjusted = false;

    //{{DECLARE_CONTROLS
	javax.swing.JPanel ToolbarPanel = new javax.swing.JPanel();
	javax.swing.JToolBar JToolBar1 = new javax.swing.JToolBar();
	javax.swing.JButton newButton = new javax.swing.JButton();
	javax.swing.JButton modifyButton = new javax.swing.JButton();
	javax.swing.JButton delButton = new javax.swing.JButton();
	javax.swing.JButton copyButton = new javax.swing.JButton();
	javax.swing.JButton pasteButton = new javax.swing.JButton();
	javax.swing.JLabel JLabel6 = new javax.swing.JLabel();
	javax.swing.JButton infoButton = new javax.swing.JButton();
	javax.swing.JButton helpButton = new javax.swing.JButton();
	javax.swing.JPanel CenterPanel = new javax.swing.JPanel();
	javax.swing.JPanel DosDrivePanel = new javax.swing.JPanel();
	javax.swing.JLabel JLabel1 = new javax.swing.JLabel();
	javax.swing.JTextField DosDriveName = new javax.swing.JTextField();
	javax.swing.JButton DosSetDriveButton = new javax.swing.JButton();
	javax.swing.JLabel JLabel2 = new javax.swing.JLabel();
	javax.swing.JCheckBox ConfirmDelCheckBox = new javax.swing.JCheckBox();
	javax.swing.JPanel LinuxDrivePanel = new javax.swing.JPanel();
	javax.swing.JLabel JLabel4 = new javax.swing.JLabel();
	javax.swing.JTextField LinuxDriveName = new javax.swing.JTextField();
	javax.swing.JButton LinuxSetDriveButton = new javax.swing.JButton();
	javax.swing.JButton RemoteButton = new javax.swing.JButton();
	javax.swing.JButton ExitButton = new javax.swing.JButton();
	javax.swing.JSplitPane ExplorerSplitPane = new javax.swing.JSplitPane();
	javax.swing.JMenuBar JMenuBar1 = new javax.swing.JMenuBar();
	javax.swing.JMenu fileMenu = new javax.swing.JMenu();
	javax.swing.JMenuItem RemoteMenuItem = new javax.swing.JMenuItem();
	javax.swing.JCheckBoxMenuItem ReadOnlyMenuItem = new javax.swing.JCheckBoxMenuItem();
	javax.swing.JMenuItem exitItem = new javax.swing.JMenuItem();
	javax.swing.JMenu editMenu = new javax.swing.JMenu();
	javax.swing.JMenuItem newItem = new javax.swing.JMenuItem();
	javax.swing.JMenuItem modifyItem = new javax.swing.JMenuItem();
	javax.swing.JMenuItem delItem = new javax.swing.JMenuItem();
	javax.swing.JMenuItem copyItem = new javax.swing.JMenuItem();
	javax.swing.JMenuItem pasteItem = new javax.swing.JMenuItem();
	javax.swing.JMenu helpMenu = new javax.swing.JMenu();
	javax.swing.JMenuItem partitionItem = new javax.swing.JMenuItem();
	javax.swing.JSeparator JSeparator2 = new javax.swing.JSeparator();
	javax.swing.JMenuItem helpItem = new javax.swing.JMenuItem();
	javax.swing.JSeparator JSeparator1 = new javax.swing.JSeparator();
	javax.swing.JMenuItem aboutItem = new javax.swing.JMenuItem();
	//}}
    DirFilePane DosPane;
    DirFilePane LinuxPane;

    //{{DECLARE_MENUS
	//}}

    void exitApplication()
    {   try
	{							//Toolkit.getDefaultToolkit().beep();               // Beep
	    // Show a confirmation dialog
	    int reply = JOptionPane.showConfirmDialog(this,
						      "Do you really want to exit?",
						      "LTOOLgui - Exit",
						      JOptionPane.YES_NO_OPTION,
						      JOptionPane.QUESTION_MESSAGE);
	    // If the confirmation was affirmative, handle exiting.
	    if (reply == JOptionPane.YES_OPTION)
            {   File file1 = new File("ZZZ.ZWZ");		//Delete the Dos file again
		if (file1.exists())
		     file1.delete();
		File file2 = new File("zzz.tmp");		//Delete the Dos file again
		if (file1.exists())
		     file2.delete();

		if (Connected)
		     closeConnection();

		 this.setVisible(false);			// hide the Frame
		 this.dispose();				// free the system resources
		 System.exit(0);				// close the application
	    }
	}
	catch(Exception e)
        {
        }
    }


//######Debugging#################################################################################
//
    static void debugOutput(String text)                        //Debug output to console
    {   if (DEBUG == true)
	    System.out.println(text);
    }


//######Event Adapters and Event Listeners########################################################
//
    class SymWindow extends java.awt.event.WindowAdapter
    {   public void windowClosing(java.awt.event.WindowEvent event)
        {   Object object = event.getSource();
	    if (object == ltoolgui.this)
		 JFrame1_windowClosing(event);
	}
    }

    class SymAction implements java.awt.event.ActionListener
    {   public void actionPerformed(java.awt.event.ActionEvent event)
        {   Object object = event.getSource();
	    if (object == exitItem)
		 exitItem_actionPerformed(event);
	    else if (object == aboutItem)
		 aboutItem_actionPerformed(event);
	    if (object == helpButton)
		 helpButton_actionPerformed(event);
	    else if (object == ExitButton)
		 ExitButton_actionPerformed(event);
	    else if (object == helpItem)
		 helpItem_actionPerformed(event);
	    else if (object == newButton)
		 newButton_actionPerformed(event);
	    else if (object == delButton)
		 delButton_actionPerformed(event);
	    else if (object == copyButton)
		 copyButton_actionPerformed(event);
	    else if (object == pasteButton)
		 pasteButton_actionPerformed(event);
	    else if (object == newItem)
		 newItem_actionPerformed(event);
	    else if (object == delItem)
		 delItem_actionPerformed(event);
	    else if (object == copyItem)
		 copyItem_actionPerformed(event);
	    else if (object == pasteItem)
		 pasteItem_actionPerformed(event);
	    else if (object == DosSetDriveButton)
		 DosSetDriveButton_actionPerformed(event);
	    else if (object == LinuxSetDriveButton)
		 LinuxSetDriveButton_actionPerformed(event);
	    else if (object == infoButton)
		 aboutButton_actionPerformed(event);
	    else if (object == DosDriveName)
		DosDriveName_actionPerformed(event);
	    else if (object == LinuxDriveName)
		LinuxDriveName_actionPerformed(event);
			else if (object == modifyButton)
				modifyButton_actionPerformed(event);
			else if (object == modifyItem)
				modifyItem_actionPerformed(event);
			else if (object == RemoteButton)
				RemoteButton_actionPerformed(event);
			else if (object == RemoteMenuItem)
				RemoteMenuItem_actionPerformed(event);
			else if (object == partitionItem)
				partitionItem_actionPerformed(event);
			else if (object == ReadOnlyMenuItem)
				ReadOnlyMenuItem_actionPerformed(event);
	}
    }


//######Button and Textfield Action Handlers######################################################
//
    void JFrame1_windowClosing(java.awt.event.WindowEvent event)//Window Closing
    {   this.exitApplication();
    }

    void exitItem_actionPerformed(java.awt.event.ActionEvent event)//Exit Menu Item
    {   this.exitApplication();
    }
    void ExitButton_actionPerformed(java.awt.event.ActionEvent event)//Exit Button
    {	this.exitApplication();
    }

    void aboutItem_actionPerformed(java.awt.event.ActionEvent event)//About Menu Item
    {   JOptionPane.showMessageDialog(this, "LTOOLS GUI  " + ltoolgui.myProg.VERSION
    			+ " 1999-2000 Werner.Zimmermann@fht-esslingen.de\nOperating System: "
    			+ System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version")+"\n"
    			+ "Java VM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n\n"
    			+ "Using\n"
    			+ LinuxPane.lTree.execOperatingSystemCommand("ldir -x -v",false).replace('\r',' ').substring(2),
    			"LTOOLS", JOptionPane.INFORMATION_MESSAGE);
    }
    void aboutButton_actionPerformed(java.awt.event.ActionEvent event)  //About Button
    {   partitionItem_actionPerformed(event);
    }

    void helpItem_actionPerformed(java.awt.event.ActionEvent event)	//Help Menu Item
    {   new HelpBox(this, false, "file:" + lreadguiDirectory + "/").setVisible(true);
    }
    void helpButton_actionPerformed(java.awt.event.ActionEvent event)	//Help Button
    {   helpItem_actionPerformed(event);
    }

    void newItem_actionPerformed(java.awt.event.ActionEvent event)	//New Menu Item
    {   debugOutput("newItemAction");
	if (DosPane.rTree.getSelectionPath() != null)
        {   if (DosPane.rTree.getModel().isLeaf(DosPane.rTree.getSelectionPath().getLastPathComponent()) == false)
		DosPane.rTree.newDosDirectory(DosPane.rTree.getSelectionPath());
	    else
		JOptionPane.showMessageDialog(this, "Select directory where to add the new item", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	} else if (LinuxPane.rTree.getSelectionPath() != null)
        {   if (LinuxPane.rTree.getModel().isLeaf(LinuxPane.rTree.getSelectionPath().getLastPathComponent()) == false)
		LinuxPane.rTree.newLinuxDirectory(LinuxPane.rTree.getSelectionPath());
	    else
		JOptionPane.showMessageDialog(this, "Select directory where to add the new item", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	} else
        {   JOptionPane.showMessageDialog(this, "Select directory where to add the new item", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	}
    }
    void newButton_actionPerformed(java.awt.event.ActionEvent event)	//New Button
    {   debugOutput("newButtonAction");
	newItem_actionPerformed(event);
    }

    void modifyItem_actionPerformed(java.awt.event.ActionEvent event)	//Modify Menu Item
    {   debugOutput("ModifyItemAction");

	if (DosPane.rTree.getSelectionPath() != null)
        {   if (DosPane.rTree.getSelectionCount() > 1)
            {   JOptionPane.showMessageDialog(this, "Sorry, only one item may be selected here", "LTOOLS", JOptionPane.ERROR_MESSAGE);
		return;
	    }
	    DosPane.rTree.modifyDosFile(DosPane.rTree.getSelectionPath());
	} else if (LinuxPane.rTree.getSelectionPath() != null)
        {   if (LinuxPane.rTree.getSelectionCount() > 1)
            {   JOptionPane.showMessageDialog(this, "Sorry, only one item may be selected here", "LTOOLS", JOptionPane.ERROR_MESSAGE);
		return;
	    }
	    LinuxPane.rTree.modifyLinuxFile(LinuxPane.rTree.getSelectionPath());
	} else
	    JOptionPane.showMessageDialog(this, "Select directory or file to modify", "LTOOLS", JOptionPane.ERROR_MESSAGE);
    }
    void modifyButton_actionPerformed(java.awt.event.ActionEvent event)		//Modify Button
    {   debugOutput("ModifyButtonAction");
	modifyItem_actionPerformed(event);
    }

    void delItem_actionPerformed(java.awt.event.ActionEvent event)	//Del Menu Item
    {   debugOutput("delItemAction");
	if (DosPane.rTree.getSelectionPath() != null)
        {   TreePath[]delPaths = DosPane.rTree.getSelectionPaths();
	    int nSel = DosPane.rTree.getSelectionCount();
	    for (int i = 0; i < nSel; i++)
		 DosPane.rTree.deleteDosFile(delPaths[i]);
	} else if (LinuxPane.rTree.getSelectionPath() != null)
        {   TreePath[]delPaths = LinuxPane.rTree.getSelectionPaths();
	    int nSel = LinuxPane.rTree.getSelectionCount();
	    for (int i = 0; i < nSel; i++)
		LinuxPane.rTree.deleteLinuxFile(delPaths[i]);
	} else
	    JOptionPane.showMessageDialog(this, "Select file or directory to delete", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	ConfirmDelCheckBox.setSelected(true);
    }
    void delButton_actionPerformed(java.awt.event.ActionEvent event)	//Del Button
    {   debugOutput("delButtonAction");
	delItem_actionPerformed(event);
    }

    void copyItem_actionPerformed(java.awt.event.ActionEvent event)	//Copy Menu Item
    {   debugOutput("copyItemAction");
	if (DosPane.rTree.getSelectionPath() != null)
        {   copyFilePath = DosPane.rTree.getSelectionPaths();	//+++get the full path name of the selected files
	    copyFileCount = DosPane.rTree.getSelectionCount();

//          copyFilePath = DosPane.rTree.getSelectionPath();
	    copyFileIsLinux = false;				//+++it's a Dos file
	    copyFileDrive = DosPane.currentDrive;
	    if (DosPane.rTree.getModel().isLeaf(copyFilePath[0].getLastPathComponent()))
		copyFileIsValid = true;				//+++if it is not a directory but a file, it is valid
	    else
            {   copyFileIsValid = false;
		JOptionPane.showMessageDialog(this, "Sorry, directories cannot be copied", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	    }
	} else if (LinuxPane.rTree.getSelectionPath() != null)
        {   copyFilePath = LinuxPane.rTree.getSelectionPaths();	//+++get the full pathname of the selected file
	    copyFileCount = LinuxPane.rTree.getSelectionCount();
	    copyFileIsLinux = true;				//+++it is a Linux file
	    copyFileDrive = LinuxPane.currentDrive;
	    if (LinuxPane.rTree.getModel().isLeaf(copyFilePath[0].getLastPathComponent()))
		copyFileIsValid = true;				//+++if it is not a directory but a file, it is valid
	    else
            {   copyFileIsValid = false;
		JOptionPane.showMessageDialog(this, "Sorry, directories cannot be copied", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	    }
	} else
	    JOptionPane.showMessageDialog(this, "Select file to copy", "LTOOLS", JOptionPane.ERROR_MESSAGE);
    }
    void copyButton_actionPerformed(java.awt.event.ActionEvent event)	//Copy Button
    {   debugOutput("copyButtonAction");
	copyItem_actionPerformed(event);
    }

    void pasteItem_actionPerformed(java.awt.event.ActionEvent event)	//Paste Menu Item
    {   debugOutput("pasteItemAction");

	TreePath targetFilePath;

	if (copyFileIsValid == false)
        {   JOptionPane.showMessageDialog(this, "You must copy a file before you can paste it", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	    return;
	}
	if (DosPane.rTree.getSelectionPath() != null)
        {   targetFilePath = DosPane.rTree.getSelectionPath();
	    if (DosPane.rTree.getModel().isLeaf(targetFilePath.getLastPathComponent()))		//target must be a directory
            {   JOptionPane.showMessageDialog(this, "Select directory to paste in (in right directory tree only)", "LTOOLS", JOptionPane.ERROR_MESSAGE);
		return;
	    }
	    DosPane.rTree.pasteToDos(targetFilePath, true);
	} else if (LinuxPane.rTree.getSelectionPath() != null)
        {   targetFilePath = LinuxPane.rTree.getSelectionPath();
	    if (LinuxPane.rTree.getModel().isLeaf(targetFilePath.getLastPathComponent()))	//target must be a directory
            {   JOptionPane.showMessageDialog(this, "Select directory to paste in (in right directory tree only)", "LTOOLS", JOptionPane.ERROR_MESSAGE);
		return;
	    }
	    LinuxPane.rTree.pasteToLinux(targetFilePath, true);
	} else
        {   JOptionPane.showMessageDialog(this, "Select directory to paste in (in right directory tree only)", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	}
    }
    void pasteButton_actionPerformed(java.awt.event.ActionEvent event)	//Paste Button
    {   debugOutput("pasteButtonAction");
	pasteItem_actionPerformed(event);
    }

    void DosSetDriveButton_actionPerformed(java.awt.event.ActionEvent event)	//Dos Set Drive Button
    {   debugOutput("DosSetDriveButtonAction");
	DosPane.driveChanged(DosDriveName.getText(), defaultDosDirectory);
    }
    void DosDriveName_actionPerformed(java.awt.event.ActionEvent event)		//Dos Drive Name Text Field
    {   debugOutput("DosDriveName_TextField_Action");
	DosSetDriveButton_actionPerformed(event);
    }

    void LinuxSetDriveButton_actionPerformed(java.awt.event.ActionEvent event)	//Linux Set Drive Button
    {   debugOutput("LinuxSetDriveButtonAction");
	LinuxPane.driveChanged(LinuxDriveName.getText(), defaultLinuxDirectory);
    }
    void LinuxDriveName_actionPerformed(java.awt.event.ActionEvent event)	//Linux Drive Name Text Field
    {   debugOutput("DosDriveName_TextField_Action");
	LinuxSetDriveButton_actionPerformed(event);
    }

    void RemoteMenuItem_actionPerformed(java.awt.event.ActionEvent event)
    {   debugOutput("RemoteMenuItem_Action");

	if (Connected)
        {   closeConnection();
	    if (Connected == false)
            {   RemoteButton.setText("Connect");
		RemoteMenuItem.setText("Remote connect");
	    }
	    LinuxPane.driveChanged(LinuxDriveName.getText(), defaultLinuxDirectory);
	} else
        {   RemoteBoxDialog myRemote = new RemoteBoxDialog(this, hostname, "" + port);
	    myRemote.setVisible(true);
	    if (myRemote.getStatus() == RemoteBoxDialog.CANCEL)
		return;
	    hostname = myRemote.getHostName();
	    port = myRemote.getPortNumber();
	    openConnection();
	    if (Connected == true)
            {   RemoteButton.setText("Disconnect");
		RemoteMenuItem.setText("Remote disconnect");
	    }
	    LinuxPane.driveChanged(LinuxDriveName.getText(), defaultLinuxDirectory);
	}
    }
    void RemoteButton_actionPerformed(java.awt.event.ActionEvent event)
    {   debugOutput("RemoteButton_Action");
	RemoteMenuItem_actionPerformed(event);
    }


//-----Open connection to remote server-----------------------------------------
    static void openConnection()
    {   debugOutput("Started openConnection()");

	try
        {   qSocket = new Socket(hostname, port);		// Open a socket to the server.
	    qReceive = new BufferedReader(new InputStreamReader(qSocket.getInputStream()));
	    bReceive = new BufferedInputStream(qSocket.getInputStream());
	    qSend = new BufferedWriter(new OutputStreamWriter(qSocket.getOutputStream()));
	    bSend = new BufferedOutputStream(qSocket.getOutputStream());

	    if ((qSocket != null) && (qReceive != null) && (qSend != null))
            {   Connected = true;
		debugOutput("Client connected to server");
	    } else
            {   debugOutput("Client connect to server failed");
		Connected = false;
		JOptionPane.showMessageDialog(myProg, "Client connect to server failed", "LTOOLS", JOptionPane.ERROR_MESSAGE);
	    }
	}
	catch(UnknownHostException excpt)
        {   System.err.println("Unknown host " + excpt);
	    JOptionPane.showMessageDialog(myProg, "Unknown hostname \"" + hostname, "LTOOLS", JOptionPane.ERROR_MESSAGE);
	}
	catch(IOException excpt)
        {   System.err.println("Failed I/O to " + excpt);
	    JOptionPane.showMessageDialog(myProg, "Client connect to server failed: " + excpt, "LTOOLS", JOptionPane.ERROR_MESSAGE);
	}
    }

//----Close connection to remote server----------------------------------------
    static void closeConnection()
    {   debugOutput("Started closeConnection()");

	if (Connected == false)
	    return;

	try
        {   if (qSend != null)
            {   qSend.write("ESC", 0, 3);			//Send close command (ESC) to server
		qSend.close();
		bSend.close();
		qSend = null;					//Close transmit stream
	    }
	    if (qReceive != null)
            {   qReceive.close();
		bReceive.close();
		qReceive = null;				//Close receive stream
	    }
	    if (qSocket != null)
            {   qSocket.close();
		qSocket = null;					//Close socket
	    }
	    Connected = false;
	    debugOutput("Connection closed");
	}
	catch(IOException excpt)
        {   System.err.println("Failed I/O to " + excpt);
	}
    }



    void partitionItem_actionPerformed(java.awt.event.ActionEvent event)
    {   String info = LinuxPane.lTree.showPartitions();
	 JOptionPane.showMessageDialog(this, info, "LTOOLS", JOptionPane.INFORMATION_MESSAGE);
    }

    void ReadOnlyMenuItem_actionPerformed(java.awt.event.ActionEvent event)
    {   isLinuxReadOnly = ReadOnlyMenuItem.isSelected();
    }
}

