/*ldir/lread
   Program to read Linux extended 2 filesystems under DOS

   Module UNIXdisk.c
   Low level harddisk partition table and harddisk data read

   This is the operating system specific file for UNIX systems,
   hacked by Richard Zidlicky.

   Copyright information and copying policy see file README.TXT

   History see file MAIN.C
 */

/* ignore LBA/CHS for now - assume "partition special file" */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "ldir.h"
#include "ext2.h"
#include "proto.h"

extern char *disk_name;
extern int disk_fd;

#define  PRINT_PARTITION_TABLE    for (k=0;k<4;k++)     				\
					 { printf("Entry %i: ",k);          	      	\
					   printf("%X %X %X %X %X %X %X %X %lX %lX\n",	\
                                            		pTEntry[k]->bootIndicator,  	\
                                                        pTEntry[k]->startHead,       	\
                                                        pTEntry[k]->startSector,      	\
                                                        pTEntry[k]->startCylinder,     	\
                                                        pTEntry[k]->system,          	\
                                                        pTEntry[k]->endHead,          	\
                                                        pTEntry[k]->endSector,         	\
                                                        pTEntry[k]->endCylinder,      	\
                                                        pTEntry[k]->leadSectors,      	\
                                                        pTEntry[k]->numSectors); }	\
				  printf("Partition Code %x%x\n",buf[510],buf[511]);

/* globals */
unsigned int HEADS;						/*your harddisk's # of heads               ) drive's */
unsigned int SECTORS;						/*                # of sectors per cylinder) geometry */
unsigned int CYLINDERS;						/*                # of cylinders           )         */
unsigned long start;						/*logical block address(LBA) of your Linux partition */
unsigned long num_sect;						/*total # of sectors of your Linux partition */
extern unsigned int disk_no;					/*DOS' disk #, eg. 0x80=first harddisk */
extern unsigned int part_no;					/*# of your Linux partition */
extern char ext2_disk[32];					/*your linux partition name, eg. /dev/hda5 */
extern enum
{
    LDIR, LREAD, LWRITE, LTEST
}
modus;

extern void *MALLOC(size_t size);
extern void FREE(void *block);


/*########################################################################## */

/*This procedure looks for your Linux partition.
   You have to specify the disk to search in ldir.h or via the -s command
   line switch, specification is done in Linux 'style', your specification is
   converted into a DOS 'style' specification in global variables disk_no and
   part_no, eg.:

   /dev/hdaX           first harddisk        disk_no=0x80
   /dev/hdbX           second harddisk               0x81
   /dev/fd0            first floppy disk             0x00
   /dev/fd1            second floppy disk            0x01

   If you do not specify a partition number, i.e. if X is a space, the procedure
   will search the four entrys of the partition table for a primary Linux Ext2
   partition, if it finds one, it will use it. If it does not find a primary
   Linux Ext2 partition, it searches for a DOS extended partition, read's the
   DOS extended partition's table and searches it for a Linux Ext2 partition.
   As DOS extended partitions may contain an unlimited number of 'logical drives',
   this search is recursively until we find a Linux Ext2 partition or until we
   reach the end of the tables.

   If you additionally specify a partition number, i.e. set X to 5, for each
   Linux partition we find we also check, if it is the specified partition num-
   ber. If not, we continue the search of the partition table. The partition
   number is transfered to the procedure via global variable part_no.
 */

int examine_drive(void)
{
    struct stat sbuf;

    /* fake version, don't bother with partitions now */
    DebugOut(2,"--------Executing 'examine drive'----------------\n");

    disk_fd = open(disk_name, O_RDWR);				/* !!! */
    if (disk_fd < 0)
    {
	perror("could not open partition special file:");
	fprintf(STDERR,"tried %s\n", disk_name);
	exit(1);
    }
    fstat(disk_fd, &sbuf);
    SECTORS = sbuf.st_size / DISK_BLOCK_SIZE;

    start = (long) 0;						/* start at 0 */
    num_sect = SECTORS;

    DebugOut(2,"Found drive with %d sectors\n",num_sect);
    return 0;

}

unsigned long readdisk(unsigned char *buf, unsigned long lba, unsigned short offset, unsigned long size)
{
    unsigned int no_sect = size / DISK_BLOCK_SIZE;
    int err, rc;
    char *temp;

    DebugOut(2,"--------Executing 'readdisk'---lba=%lu  offset=%u   size=%d\n",lba,offset,size);

    if ((offset > 0) || (size % DISK_BLOCK_SIZE))
	no_sect++;

    if ((temp = (unsigned char *) MALLOC(no_sect * DISK_BLOCK_SIZE)) == NULL)
    {
	fprintf(STDERR, "Memory allocation failed in readdisk\n");
	exit(1);
    }
    rc = lseek(disk_fd, lba * DISK_BLOCK_SIZE, SEEK_SET);
    if (rc < 0)
    {
	perror("readdisk: seek failed");
	exit(1);
    }
    rc = read(disk_fd, temp, no_sect * DISK_BLOCK_SIZE);

/* should do byteswapping here?!? */

    if (rc == no_sect * DISK_BLOCK_SIZE)
    {
	memcpy(buf, &temp[offset], size);			/* no ending NULL */
	FREE(temp);
	return size;
    } else
    {
	FREE(temp);
	return 0;
    }
}

unsigned long writedisk(unsigned char *buf, unsigned long lba, unsigned short offset, unsigned long size)
{
    unsigned int no_sect = size / DISK_BLOCK_SIZE;
    int err, rc;
    char *temp;

    DebugOut(2,"--------Executing 'writedisk'---lba=%lu  offset=%u   size=%d\n",lba,offset,size);

    if ((offset > 0) || (size % DISK_BLOCK_SIZE))
	no_sect++;

    if ((temp = (unsigned char *) MALLOC(no_sect * DISK_BLOCK_SIZE)) == NULL)
    {
	fprintf(STDERR, "Memory allocation failed in writedisk\n");
	exit(1);
    }
    rc = lseek(disk_fd, lba * DISK_BLOCK_SIZE, SEEK_SET);
    if (rc < 0)
    {
	perror("writedisk: seek failed");
	exit(1);
    }
    if (read(disk_fd, temp, no_sect * DISK_BLOCK_SIZE) != no_sect * DISK_BLOCK_SIZE)
    {
	fprintf(STDERR, "Read Error %xh in Write Disk\n", rc);
	exit(1);
    }
    memcpy(&temp[offset], buf, size);
    rc = lseek(disk_fd, lba * DISK_BLOCK_SIZE, SEEK_SET);
    if (rc < 0)
    {
	perror("writedisk: seek failed");
	exit(1);
    }
    rc = write(disk_fd, temp, no_sect * DISK_BLOCK_SIZE);

/* should do byteswapping here?!? */

    if (rc != no_sect * DISK_BLOCK_SIZE)
    {
	perror("writedisk: write failed:");
	FREE(temp);
	return 0;
    }
    FREE(temp);
    return size;
}
