/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2007-2011 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/

#ifndef MEM_H
#define MEM_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define USE_PTH_THREADS	1
#ifdef MEM_DEBUG
#define xfree free
#define xmalloc malloc
#define xrealloc realloc
#define xcalloc calloc
#define xstrdup strdup
#else
struct memlist_s {
    void *ptr;
    size_t size;
    struct memlist_s *next;
};

void xmem_init(void);
void xfree(void *ptr) __attribute__ ((visibility ("hidden")));
void *xmalloc(size_t size) __attribute__ ((visibility ("hidden")));
void *xrealloc(void *ptr, size_t size) __attribute__ ((visibility ("hidden")));
char *xstrdup(const char *str) __attribute__ ((visibility ("hidden")));
void *xcalloc(size_t nmemb, size_t size) __attribute__ ((visibility ("hidden")));
void xpanic(void) __attribute__ ((visibility ("hidden")));
#ifdef DEBUG
void xdump(void) __attribute__ ((visibility ("hidden")));
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif
