/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2007-2008 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef PINENTRY_H
#define PINENTRY_H

#include <pth.h>

pth_mutex_t pin_mutex;

gpg_error_t pinentry_fork(assuan_context_t ctx);
void cleanup_pinentry(struct pinentry_s *pin);
gpg_error_t pinentry_getpin(struct pinentry_s *pin, gchar **result);
void unlock_pin_mutex(struct pinentry_s *pin);
gpg_error_t lock_pin_mutex(struct client_s *client);
void *pinentry_timeout_thread(void *arg);
int pinentry_iterate(struct client_s *cl, gboolean read_ready);
struct pinentry_s *pinentry_init();
void set_pinentry_defaults(struct pinentry_s *pin);
void reset_pin_defaults(struct pinentry_s *pin);

#endif
