/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2011 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef STATUS_H
#define STATUS_H

#include <gpg-error.h>
#include <assuan.h>

#define DEFAULT_KEEPALIVE_TO	0

typedef enum {
    STATUS_CACHE,
    STATUS_CONFIG,
    STATUS_KEEPALIVE,
    STATUS_CLIENTS,
    STATUS_LOCKED,
    STATUS_ENCRYPT,
    STATUS_DECRYPT,
    STATUS_COMPRESS,
    STATUS_DECOMPRESS,
    STATUS_XFER
} status_msg_t;

gpg_error_t send_status(assuan_context_t ctx, status_msg_t which,
	const gchar *fmt, ...);
void send_status_all(status_msg_t which);
void *client_msg_thread(void *arg);
void *client_msg_sender_thread(void *arg);

#endif
