 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                   E      NN  N  C      O   O  D   D  E                      % O %                   EEE    N N N  C      O   O  D   D  EEE                    % O %                   E      N  NN  C      O   O  D   D  E                      % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Write Image Formats                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "version.h" #include "Colorlist.h" #include "XWDFile.h" #include "plug-ins.h"    /*   Define declarations. */, #define SaveImageText  "  Saving image...  "& #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    return(False); \ }    /*   Function prototypes. */ static unsigned int ,   WriteMIFFImage(const ImageInfo *,Image *),+   WritePNMImage(const ImageInfo *,Image *), +   WriteYUVImage(const ImageInfo *,Image *);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e A V S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteAVSImage writes an image to a file in AVS X image format. % . %  The format of the WriteAVSImage routine is: % - %      status=WriteAVSImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteAVSImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteAVSImage(const ImageInfo *image_info,Image *image)  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*"     Initialize raster file header.   */"   avs_header.width=image->columns;    avs_header.height=image->rows;F   (void) fwrite((char *) &avs_header,sizeof(AVSHeader),1,image->file);   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     { L       (void) fputc(image->matte ? DownScale(p->index) : Opaque,image->file);2       (void) fputc(DownScale(p->red),image->file);4       (void) fputc(DownScale(p->green),image->file);3       (void) fputc(DownScale(p->blue),image->file);      }      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % . %  The format of the WriteBMPImage routine is: % - %      status=WriteBMPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteBMPImage(const ImageInfo *image_info,Image *image)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Initialize BMP raster file header.     */     bmp_header.file_size=14+40; !     bmp_header.offset_bits=14+40; 5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*            Full color BMP raster.
         */#         bmp_header.number_colors=0;           bmp_header.bit_count=24;G         bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4;        }      else       { 
         /*!           Colormapped BMP raster. 
         */         bmp_header.bit_count=8; G         bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; 3         image->compression=image_info->compression;          CompressImage(image); >         if (image->compression == RunlengthEncodedCompression)(           bytes_per_line=image->columns;%         if (IsMonochromeImage(image))            { #             bmp_header.bit_count=1; K             bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4;            } <         bmp_header.file_size+=4*(1 << bmp_header.bit_count);>         bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);;         bmp_header.number_colors=1 << bmp_header.bit_count;        }      bmp_header.reserved[0]=0;      bmp_header.reserved[1]=0;      bmp_header.size=40; $     bmp_header.width=image->columns;"     bmp_header.height=image->rows;     bmp_header.planes=1;     bmp_header.compression=0; 5     bmp_header.image_size=bytes_per_line*image->rows; 0     bmp_header.file_size+=bmp_header.image_size;     bmp_header.x_pixels=75*39;     bmp_header.y_pixels=75*39;0     if (image->units == PixelsPerInchResolution)       { M         bmp_header.x_pixels=(unsigned long) (100.0*image->x_resolution/2.54); M         bmp_header.y_pixels=(unsigned long) (100.0*image->y_resolution/2.54);        } 6     if (image->units == PixelsPerCentimeterResolution)       { H         bmp_header.x_pixels=(unsigned long) (100.0*image->x_resolution);H         bmp_header.y_pixels=(unsigned long) (100.0*image->y_resolution);       } 9     bmp_header.colors_important=bmp_header.number_colors;      /*(       Convert MIFF to BMP raster pixels.     */      bmp_pixels=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));-     if (bmp_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      x=0;     y=image->rows-1;!     switch (bmp_header.bit_count)      { 
       case 1:        {          register unsigned char           bit,           byte,            polarity;   
         /*>           Convert PseudoClass image to a BMP monochrome image.
         */         p=image->pixels;         polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[1]) > Intensity(image->colormap[0]);         bit=0;         byte=0; &         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              byte<<=1; %             if (p->index == polarity)                byte|=0x01;              bit++;             if (bit == 8)                {                  *q++=byte;                 bit=0;                 byte=0;                }              x++;$             if (x == image->columns)               {                  /*/                   Advance to the next scanline.                  */                 if (bit != 0) '                   *q++=byte << (8-bit);                  bit=0;                 byte=0;                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;              }           }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       } 
       case 8:        { 
         /*2           Convert PseudoClass packet to BMP pixel.
         */         p=image->pixels;&         q=bmp_pixels+y*bytes_per_line;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              *q++=p->index;             x++;$             if (x == image->columns)               {                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }        case 24:       { 
         /*6           Convert DirectClass packet to BMP RGB pixel.
         */         p=image->pixels;(         q=bmp_pixels+y*bytes_per_line-1;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { $             *q++=DownScale(p->blue);%             *q++=DownScale(p->green); #             *q++=DownScale(p->red);              x++;$             if (x == image->columns)               {                  x=0;                 y--;.                 q=bmp_pixels+y*bytes_per_line;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }      } "     if (bmp_header.bit_count == 8)<       if (image->compression == RunlengthEncodedCompression)	         {            unsigned int             packets;             /*5             Convert run-length encoded raster pixels.            */            packets=(unsigned int)<             ((bytes_per_line*(bmp_header.height+2)+1) << 1);K           bmp_data=(unsigned char *) malloc(packets*sizeof(unsigned char)); 3           if (bmp_pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL); (               free((char *) bmp_pixels);               return(False);
             }             bmp_header.image_size=K             BMPEncodeImage(bmp_pixels,bmp_data,image->columns,image->rows); $           free((char *) bmp_pixels);           bmp_pixels=bmp_data;#           bmp_header.compression=1; 	         }      /*       Write BMP header.      */(     (void) fwrite("BM",1,2,image->file);8     LSBFirstWriteLong(bmp_header.file_size,image->file);;     LSBFirstWriteShort(bmp_header.reserved[0],image->file); ;     LSBFirstWriteShort(bmp_header.reserved[1],image->file); :     LSBFirstWriteLong(bmp_header.offset_bits,image->file);3     LSBFirstWriteLong(bmp_header.size,image->file); 4     LSBFirstWriteLong(bmp_header.width,image->file);5     LSBFirstWriteLong(bmp_header.height,image->file); 6     LSBFirstWriteShort(bmp_header.planes,image->file);9     LSBFirstWriteShort(bmp_header.bit_count,image->file); :     LSBFirstWriteLong(bmp_header.compression,image->file);9     LSBFirstWriteLong(bmp_header.image_size,image->file); 7     LSBFirstWriteLong(bmp_header.x_pixels,image->file); 7     LSBFirstWriteLong(bmp_header.y_pixels,image->file); <     LSBFirstWriteLong(bmp_header.number_colors,image->file);?     LSBFirstWriteLong(bmp_header.colors_important,image->file); $     if (image->class == PseudoClass)       {          unsigned char            *bmp_colormap;  
         /*            Dump colormap to file.
         */&         bmp_colormap=(unsigned char *)F           malloc(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));3         if (bmp_colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          q=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 2           *q++=DownScale(image->colormap[i].blue);3           *q++=DownScale(image->colormap[i].green); 1           *q++=DownScale(image->colormap[i].red);            q++;	         } ;         for ( ; i < (int) (1 << bmp_header.bit_count); i++) 	         {            *q++=0;            *q++=0;            *q++=0;            q++;	         } H         (void) fwrite((char *) bmp_colormap,4,1 << bmp_header.bit_count,           image->file); $         free((char *) bmp_colormap);       } D     (void) fwrite((char *) bmp_pixels,1,(int) bmp_header.image_size,       image->file);      free((char *) bmp_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C G M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteCGMImage writes an image in the CGM encoded image format. % . %  The format of the WriteCGMImage routine is: % - %      status=WriteCGMImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteCGMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */> static unsigned int WriteCGMImage(const ImageInfo *image_info,   Image *image)  {    unsigned int     status;   5   Warning("Cannot write CGM images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C M Y K I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteCMYKImage writes an image to a file in cyan, magenta,' %  yellow, and black rasterfile format.  % / %  The format of the WriteCMYKImage routine is:  % . %      status=WriteCMYKImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteCMYKImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteCMYKImage(const ImageInfo *image_info,Image *image) {    float      black_generation,      undercolor;      int 
     black,	     cyan,      magenta,     yellow;      register int     i,     j;     register RunlengthPacket     *p;      image->depth=QuantumDepth;2   if (image_info->interlace != PartitionInterlace)     {        /*         Open output image file.        */2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);      }    /*'     Convert MIFF to CMYK raster pixels.    */   undercolor=1.0;    black_generation=1.0; .   if (image_info->undercolor != (char *) NULL)     { ?       (void) sscanf(image_info->undercolor,"%fx%f",&undercolor,          &black_generation); "       if (black_generation == 1.0)$         black_generation=undercolor;     }    do   { "     switch (image_info->interlace)     {        case NoneInterlace:        default:       { 
         /*6           No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...
         */         p=image->pixels;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; E             WriteQuantumFile((unsigned int) (cyan-undercolor*black)); H             WriteQuantumFile((unsigned int) (magenta-undercolor*black));G             WriteQuantumFile((unsigned int) (yellow-undercolor*black)); F             WriteQuantumFile((unsigned int) (black_generation*black));           }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }          break;       }        case LineInterlace:        {          register int           x,           y;  
         /*A           Line interlacing:  CCC...MMM...YYY...CCC...MMM...YYY... 
         */$         if (!UncompressImage(image))           return(False);'         for (y=0; y < image->rows; y++) 	         { -           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; E             WriteQuantumFile((unsigned int) (cyan-undercolor*black));              p++;           } -           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; H             WriteQuantumFile((unsigned int) (magenta-undercolor*black));             p++;           } -           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; G             WriteQuantumFile((unsigned int) (yellow-undercolor*black));              p++;           } -           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; F             WriteQuantumFile((unsigned int) (black_generation*black));             p++;           } 7           ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case PlaneInterlace:       case PartitionInterlace:       { 
         /*B           Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...
         */8         if (image_info->interlace == PartitionInterlace)           { 3             AppendImageFormat("C",image->filename); 8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            }          p=image->pixels;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; E             WriteQuantumFile((unsigned int) (cyan-undercolor*black));            }            p++;	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("M",image->filename); 8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            } /         ProgressMonitor(SaveImageText,100,400);          p=image->pixels;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; H             WriteQuantumFile((unsigned int) (magenta-undercolor*black));           }            p++;	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("Y",image->filename); 8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            } /         ProgressMonitor(SaveImageText,200,400);          p=image->pixels;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {                cyan=MaxRGB-p->red;%              magenta=MaxRGB-p->green; #              yellow=MaxRGB-p->blue;               black=cyan;!              if (magenta < black)                 black=magenta;                if (yellow < black)                black=yellow;G             WriteQuantumFile((unsigned int) (yellow-undercolor*black));            }            p++;	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("K",image->filename); 8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            } /         ProgressMonitor(SaveImageText,300,400);          p=image->pixels;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              cyan=MaxRGB-p->red; $             magenta=MaxRGB-p->green;"             yellow=MaxRGB-p->blue;             black=cyan;               if (magenta < black)               black=magenta;             if (yellow < black)                black=yellow; F             WriteQuantumFile((unsigned int) (black_generation*black));           }            p++;	         } 8         if (image_info->interlace == PartitionInterlace)>           (void) strcpy(image->filename,image_info->filename);/         ProgressMonitor(SaveImageText,400,400);          break;       }      } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F A X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteFAXImage writes an image to a file in 1 dimensional Huffman  %  encoded format. % . %  The format of the WriteFAXImage routine is: % - %      status=WriteFAXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteFAXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteFAXImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*!       Convert MIFF to monochrome.      */"     if (!IsMonochromeImage(image))       {          QuantizeInfo           quantize_info;  (         GetQuantizeInfo(&quantize_info);&         quantize_info.number_colors=2;0         quantize_info.dither=image_info->dither;0         quantize_info.colorspace=GRAYColorspace;,         QuantizeImage(&quantize_info,image);         SyncImage(image);        } 0     status=HuffmanEncodeImage(image_info,image);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F I T S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteFITSImage writes a Flexible Image Transport System image to a+ %  file as gray scale intensities [0..255].  % / %  The format of the WriteFITSImage routine is:  % . %      status=WriteFITSImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteFITSImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteFITSImage(const ImageInfo *image_info,Image *image) {    char     buffer[81],      *fits_header;      register int     i,     j;     register RunlengthPacket     *p;        /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate image header.   */:   fits_header=(char *) malloc(2880*sizeof(unsigned char));#   if (fits_header == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image header.   */   for (i=0; i < 2880; i++)     fits_header[i]=' '; 9   (void) strcpy(buffer,"SIMPLE  =                    T"); 6   (void) strncpy(fits_header+0,buffer,Extent(buffer));9   (void) strcpy(buffer,"BITPIX  =                    8"); 7   (void) strncpy(fits_header+80,buffer,Extent(buffer)); 9   (void) strcpy(buffer,"NAXIS   =                    2"); 8   (void) strncpy(fits_header+160,buffer,Extent(buffer));C   (void) sprintf(buffer,"NAXIS1  =           %10u",image->columns); 8   (void) strncpy(fits_header+240,buffer,Extent(buffer));@   (void) sprintf(buffer,"NAXIS2  =           %10u",image->rows);8   (void) strncpy(fits_header+320,buffer,Extent(buffer));:   (void) strcpy(buffer,"HISTORY Created by ImageMagick.");8   (void) strncpy(fits_header+400,buffer,Extent(buffer));   (void) strcpy(buffer,"END");8   (void) strncpy(fits_header+480,buffer,Extent(buffer));9   (void) fwrite((char *) fits_header,1,2880,image->file);    free((char *) fits_header);    /*2     Convert image to fits scale PseudoColor class.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)9       (void) fputc(DownScale(Intensity(*p)),image->file);      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % . %  The format of the WriteGIFImage routine is: % - %      status=WriteGIFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteGIFImage(const ImageInfo *image_info,Image *image)  { 
   ColorPacket      transparent_pixel;     Image      *next_image;     RectangleInfo      page_info;     register int     i,     x;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      bits_per_pixel,      c,     *colormap;     unsigned int     colors,      global_colormap,     height,      interlace,
     scene,     status, 
     width;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate colormap.   */A   colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); )   if (colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Write GIF header.    */B   if ((image->comments == (char *) NULL) && !image_info->adjoin &&       !image->matte),     (void) fwrite("GIF87a",1,6,image->file);   else0     if (strcmp(image_info->magick,"GIF87") == 0).       (void) fwrite("GIF87a",1,6,image->file);     else.       (void) fwrite("GIF89a",1,6,image->file);   /*<     Determine image bounding box and global colormap status.   */   page_info.x=0;   page_info.y=0;!   page_info.width=image->columns;    page_info.height=image->rows; .   global_colormap=image->class == PseudoClass;   next_image=image; D   for ( ; next_image != (Image *) NULL; next_image=next_image->next)   {      width=next_image->columns;     height=next_image->rows;*     if (next_image->page != (char *) NULL)N       (void) XParseGeometry(next_image->page,&page_info.x,&page_info.y,&width,         &height); /     if ((width+page_info.x) > page_info.width); (       page_info.width=width+page_info.y;1     if ((height+page_info.y) > page_info.height); *       page_info.height=height+page_info.y;     if (!global_colormap)        continue; -     if ((next_image->class == DirectClass) || .         (next_image->colors != image->colors))       {          global_colormap=False;         continue;        } %     for (i=0; i < image->colors; i++) D       if (!ColorMatch(next_image->colormap[i],image->colormap[i],0))	         {             global_colormap=False;           break;	         }    } (   if (image_info->page != (char *) NULL)E     (void) XParseGeometry(image_info->page,&page_info.x,&page_info.y, *       &page_info.width,&page_info.height);2   LSBFirstWriteShort(page_info.width,image->file);3   LSBFirstWriteShort(page_info.height,image->file);    /*     Write images to file.    */"   interlace=image_info->interlace;<   if (image_info->adjoin && (image->next != (Image *) NULL))     interlace=NoneInterlace;
   scene=0;   do   { "     transparent_pixel.flags=False;     if (IsPseudoClass(image))        colors=image->colors;      else       {          QuantizeInfo           quantize_info;           unsigned char            *matte_image;   +         matte_image=(unsigned char *) NULL;          if (image->matte)            {              /*/               Track all the transparent pixels.              */(             if (!UncompressImage(image))               return(False);)             matte_image=(unsigned char *) ;               malloc(image->packets*sizeof(unsigned char)); 6             if (matte_image == (unsigned char *) NULL)               { C                 Warning("Memory allocation error",image->filename);                  return(False);               }              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 5               matte_image[i]=p->index == Transparent; *               if (p->index == Transparent)                 { /                   transparent_pixel.red=p->red; 3                   transparent_pixel.green=p->green; 1                   transparent_pixel.blue=p->blue; /                   transparent_pixel.flags=True;                  }                p++;
             }            } 3         colors=transparent_pixel.flags ? 255 : 256; (         GetQuantizeInfo(&quantize_info);+         quantize_info.number_colors=colors; 0         quantize_info.dither=image_info->dither;,         QuantizeImage(&quantize_info,image);         SyncImage(image);           CompressColormap(image);         colors=image->colors; $         if (transparent_pixel.flags)           {              /*.               Set the transparent pixel index.             */(             if (!UncompressImage(image))               return(False);             p=image->pixels;.             for (i=0; i < image->packets; i++)
             { !               if (matte_image[i]) '                 p->index=image->colors;                p++;
             }              colors++;            } 2         if (matte_image != (unsigned char *) NULL)%           free((char *) matte_image);        } @     for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)*       if ((1 << bits_per_pixel) >= colors)         break;     q=colormap; %     for (i=0; i < image->colors; i++)      { -       *q++=DownScale(image->colormap[i].red); /       *q++=DownScale(image->colormap[i].green); .       *q++=DownScale(image->colormap[i].blue);     }       if (transparent_pixel.flags)       { .         *q++=DownScale(transparent_pixel.red);0         *q++=DownScale(transparent_pixel.green);/         *q++=DownScale(transparent_pixel.blue);          i++;       } 1     for ( ; i < (int) (1 << bits_per_pixel); i++)      {        *q++=0x0;        *q++=0x0;        *q++=0x0;      } C     if (!image_info->adjoin || (image->previous == (Image *) NULL))        {          register int           j;  
         /*            Write global colormap.
         */         c=0x80; .         c|=(8-1) << 4;  /* color resolution */>         c|=(bits_per_pixel-1);   /* size of global colormap */+         (void) fputc((char) c,image->file); )         for (j=0; j < image->colors; j++) G           if (ColorMatch(image->background_color,image->colormap[j],0))              break;<         (void) fputc(j,image->file);  /* background color */6         (void) fputc(0x0,image->file);  /* reserved */F         (void) fwrite(colormap,1,3*(1 << bits_per_pixel),image->file);       } 0     if (strcmp(image_info->magick,"GIF87") != 0)       { 
         /*+           Write Graphics Control extension. 
         */'         (void) fputc(0x21,image->file); '         (void) fputc(0xf9,image->file); '         (void) fputc(0x04,image->file);          c=image->dispose << 2;$         if (transparent_pixel.flags)           c|=0x01;$         (void) fputc(c,image->file);5         LSBFirstWriteShort(image->delay,image->file); 7         (void) fputc((char) image->colors,image->file); '         (void) fputc(0x00,image->file); -         if (image->comments != (char *) NULL)            {              register char                *p;   !             register unsigned int                count;               /*&               Write Comment extension.             */+             (void) fputc(0x21,image->file); +             (void) fputc(0xfe,image->file);              p=image->comments;!             while (Extent(p) > 0) 
             { '               count=Min(Extent(p),255); .               (void) fputc(count,image->file);'               for (i=0; i < count; i++) /                 (void) fputc(*p++,image->file); 
             } *             (void) fputc(0x0,image->file);           } 2         if ((image->previous == (Image *) NULL) &&H             (image->next != (Image *) NULL) && (image->iterations != 1))           {              /*,               Write Netscape Loop extension.             */+             (void) fputc(0x21,image->file); +             (void) fputc(0xff,image->file); +             (void) fputc(0x0b,image->file); :             (void) fwrite("NETSCAPE2.0",1,11,image->file);+             (void) fputc(0x03,image->file); +             (void) fputc(0x01,image->file); >             LSBFirstWriteShort(image->iterations,image->file);+             (void) fputc(0x00,image->file);            }        } 9     (void) fputc(',',image->file);  /* image separator */      /*       Write the image header.      */%     if (image->page != (char *) NULL) B       (void) XParseGeometry(image->page,&page_info.x,&page_info.y,,         &page_info.width,&page_info.height);0     LSBFirstWriteShort(page_info.x,image->file);0     LSBFirstWriteShort(page_info.y,image->file);3     LSBFirstWriteShort(image->columns,image->file); 0     LSBFirstWriteShort(image->rows,image->file);     c=0x00; #     if (interlace != NoneInterlace) .       c|=0x40;  /* pixel data is interlaced */     if (global_colormap))       (void) fputc((char) c,image->file);      else       {          c|=0x80;=         c|=(bits_per_pixel-1);   /* size of local colormap */ +         (void) fputc((char) c,image->file); F         (void) fwrite(colormap,1,3*(1 << bits_per_pixel),image->file);       }      /*       Write the image data.      */     c=Max(bits_per_pixel,2);'     (void) fputc((char) c,image->file); #     if (interlace == NoneInterlace) ;       status=GIFEncodeImage(image,Max(bits_per_pixel,2)+1);      else       { 
         Image            *interlaced_image;           int            pass,            y;            register RunlengthPacket
           *q;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */$         if (!UncompressImage(image))           return(False);         image->orphan=True; K         interlaced_image=CopyImage(image,image->columns,image->rows,False);          image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image);          p=image->pixels;#         q=interlaced_image->pixels; &         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             p=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } +         interlaced_image->file=image->file; H         status=GIFEncodeImage(interlaced_image,Max(bits_per_pixel,2)+1);-         interlaced_image->file=(FILE *) NULL; '         DestroyImage(interlaced_image);        }      if (status == False)7       PrematureExit("Unable to allocate memory",image); "     (void) fputc(0x0,image->file);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;     scene++;   } while (image_info->adjoin); 1   (void) fputc(';',image->file); /* terminator */    free((char *) colormap);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A D A T I O N I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGRADATIONImage writes an image in the gradation image format. % 4 %  The format of the WriteGRADATIONImage routine is: % 3 %      status=WriteGRADATIONImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteGRADATIONImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */D static unsigned int WriteGRADATIONImage(const ImageInfo *image_info,   Image *image)  {    unsigned int     status;   ;   Warning("Cannot write GRADATION images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteGRAYImage writes an image to a file as gray scale intensity
 %  values. % / %  The format of the WriteGRAYImage routine is:  % . %      status=WriteGRAYImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteGRAYImage(const ImageInfo *image_info,Image *image) {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*2     Convert image to gray scale PseudoColor class.   */   image->depth=QuantumDepth;   do   {      p=image->pixels;&     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)(         WriteQuantumFile(Intensity(*p));
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHDFImage writes an image in the Hierarchial Data Format image
 %  format. % . %  The format of the WriteHDFImage routine is: % - %      status=WriteHDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteHDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */
 #ifdef HasHDF K static unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  {  #include "hdf.h"
 #undef BSD #undef LOCAL     int      status;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int     compression,     packet_size,
     scene;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);
   scene=0;   do   {      /*$       Initialize raster file header.     */     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)K       malloc(packet_size*image->columns*image->rows*sizeof(unsigned char)); -     if (hdf_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*3           Convert DirectClass packet to HDF pixels. 
         */         q=hdf_pixels; &         switch (image_info->interlace)	         {            case NoneInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */"             DF24setil(DFIL_PIXEL);.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }              break;           }            case LineInterlace:            {              register int               x,               y;               /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */(             if (!UncompressImage(image))               return(False);!             DF24setil(DFIL_LINE); +             for (y=0; y < image->rows; y++) 
             { 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { '                 *q++=DownScale(p->red);                  p++;               } 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { )                 *q++=DownScale(p->green);                  p++;               } 1               p=image->pixels+(y*image->columns); 0               for (x=0; x < image->columns; x++)               { (                 *q++=DownScale(p->blue);                 p++;               } ;               ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:"           case PartitionInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */"             DF24setil(DFIL_PLANE);.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)'                 *q++=DownScale(p->red);                p++;
             } 3             ProgressMonitor(SaveImageText,100,400);              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++))                 *q++=DownScale(p->green);                p++;
             } 3             ProgressMonitor(SaveImageText,250,400);              p=image->pixels;.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)(                 *q++=DownScale(p->blue);               p++;
             } 3             ProgressMonitor(SaveImageText,400,400);              break;           } 	         }          if (scene == 0) B           status=DF24putimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);         elseB           status=DF24addimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);          reference=DF24lastref();       }      else       { 
         /*3           Convert PseudoClass packet to HDF pixels. 
         */         q=hdf_pixels;          if (IsGrayImage(image)) ,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)%               *q++=DownScale(p->red);              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }          else           {              unsigned char                *hdf_palette;   L             hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));6             if (hdf_palette == (unsigned char *) NULL)?               PrematureExit("Unable to allocate memory",image);              q=hdf_palette;-             for (i=0; i < image->colors; i++) 
             { 5               *q++=DownScale(image->colormap[i].red); 7               *q++=DownScale(image->colormap[i].green); 6               *q++=DownScale(image->colormap[i].blue);
             } /             (void) DFR8setpalette(hdf_palette);              free(hdf_palette);             q=hdf_pixels; .             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)                 *q++=p->index;               p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }            } M         compression=image_info->compression == NoCompression ? 0 : DFTAG_RLE;          if (scene == 0) B           status=DFR8putimage(image->filename,(void *) hdf_pixels,4             image->columns,image->rows,compression);         elseB           status=DFR8addimage(image->filename,(void *) hdf_pixels,4             image->columns,image->rows,compression);          reference=DFR8lastref();       } &     if (image->label != (char *) NULL)L       (void) DFANputlabel(image->filename,DFTAG_RIG,reference,image->label);)     if (image->comments != (char *) NULL) M       (void) DFANputdesc(image->filename,DFTAG_RIG,reference,image->comments, #         Extent(image->comments)+1);      free(hdf_pixels);      scene++;&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    return(status != -1);  }  #else K static unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;   :   Warning("HDF library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H I S T O G R A M I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHISTOGRAMImage writes an image to a file in HISTOGRAM format.O %  The image shows a histogram of the color (or gray) values in the image.  The O %  image consists of three overlaid histograms:  a red one for the red channel, O %  a green one for the green channel, and a blue one for the blue channel.  The O %  image comment contains a list of unique pixel values and the number of times  %  each occurs in the image. % > %  This routine is strongly based on a similiar one written byI %  muquit@warm.semcor.com which in turn is based on ppmhistmap of netpbm.  % 4 %  The format of the WriteHISTOGRAMImage routine is: % 3 %      status=WriteHISTOGRAMImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteHISTOGRAMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */D static unsigned int WriteHISTOGRAMImage(const ImageInfo *image_info,   Image *image)  { # #define HistogramDensity  "256x200"      char     filename[MaxTextExtent];     double
     scale;     FILE
     *file;     Image      *histogram_image;      int 
     *blue,     *green,      maximum,	     *red,      sans_offset;     register RunlengthPacket     *p,      *q;      register int     i,     j;     unsigned int     height,      status, 
     width;     /*     Allocate histogram image.    */C   (void) XParseGeometry(HistogramDensity,&sans_offset,&sans_offset,      &width,&height);+   if (image_info->density != (char *) NULL) H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,       &width,&height);   image->orphan=True; 6   histogram_image=CopyImage(image,width,height,False);   image->orphan=False;(   if (histogram_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); %   histogram_image->class=DirectClass;    /*$     Allocate histogram count arrays.   */<   red=(int *) malloc (histogram_image->columns*sizeof(int));>   green=(int *) malloc (histogram_image->columns*sizeof(int));=   blue=(int *) malloc (histogram_image->columns*sizeof(int)); 9   if ((red == (int *) NULL) || (green == (int *) NULL) ||        (blue == (int *) NULL))      { $       DestroyImage(histogram_image);7       PrematureExit("Unable to allocate memory",image);      }    /*&     Initialize histogram count arrays.   */.   for (i=0; i < histogram_image->columns; i++)   { 
     red[i]=0;      green[i]=0;      blue[i]=0;   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     red[DownScale(p->red)]+=(p->length+1);.     green[DownScale(p->green)]+=(p->length+1);,     blue[DownScale(p->blue)]+=(p->length+1);     p++;   }    maximum=0;.   for (i=0; i < histogram_image->columns; i++)   {      if (maximum < red[i])        maximum=red[i];      if (maximum < green[i])        maximum=green[i];      if (maximum < blue[i])       maximum=blue[i];   } .   for (i=0; i < histogram_image->columns; i++)   {      if (red[i] > maximum)        red[i]=maximum;      if (green[i] > maximum)        green[i]=maximum;      if (blue[i] > maximum)       blue[i]=maximum;   }    /*     Initialize histogram image.    */   q=histogram_image->pixels;.   for (i=0; i < histogram_image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   } /   scale=(double) histogram_image->rows/maximum;    q=histogram_image->pixels;.   for (i=0; i < histogram_image->columns; i++)   { 1     j=histogram_image->rows-(int) (scale*red[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->red=MaxRGB;
       j++;     } 3     j=histogram_image->rows-(int) (scale*green[i]); %     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->green=MaxRGB;
       j++;     } 2     j=histogram_image->rows-(int) (scale*blue[i]);%     while (j < histogram_image->rows)      { ?       q=histogram_image->pixels+(j*histogram_image->columns+i);        q->blue=MaxRGB; 
       j++;     } >     ProgressMonitor(SaveImageText,i,histogram_image->columns);   }    free ((char *) blue);    free ((char *) green);   free ((char *) red);   TemporaryFilename(filename);'   file=fopen(filename,WriteBinaryType);    if (file != (FILE *) NULL)     { 
       char         command[MaxTextExtent];          /*,         Add a histogram as an image comment.       */2       (void) fprintf(file,"%s\n",image->comments);       NumberColors(image,file);        (void) fclose(file);-       (void) sprintf(command,"@%s",filename); ,       CommentImage(histogram_image,command);       (void) remove(filename);     }    /*"     Write HISTOGRAM image as MIFF.   */4   status=WriteMIFFImage(image_info,histogram_image);    DestroyImage(histogram_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H T M L I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteHTMLImage writes an image in the HTML encoded image format. % / %  The format of the WriteHTMLImage routine is:  % . %      status=WriteHTMLImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteHTMLImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteHTMLImage(const ImageInfo *image_info,Image *image) {    char     filename[MaxTextExtent],     mapname[MaxTextExtent],      url[MaxTextExtent];      int      x,     y;     register char      *p;      unsigned int     height,      status, 
     width;     *url='\0';0   if ((strcmp(image_info->magick,"FTP") == 0) ||/       (strcmp(image_info->magick,"HTTP") == 0))      {        /*'         Extract URL base from filename.        */%       p=strrchr(image->filename,'/');        if (p)	         {            p++;0           (void) strcpy(url,image_info->magick);!           (void) strcat(url,":"); 2           url[Extent(url)+p-image->filename]='\0';@           (void) strncat(url,image->filename,p-image->filename);+           (void) strcpy(image->filename,p); 	         }      }    /*     Refer to image map file.   */*   (void) strcpy(filename,image->filename);$   AppendImageFormat("map",filename);    p=filename+Extent(filename)-1;:   while ((p > filename) && (*(p-1) != *BasenameSeparator))     p--;   (void) strcpy(mapname,p); 5   for (p=mapname+Extent(mapname)-1; p > mapname; p--)      if (*p == '.')       {          *p='\0';         break;       } *   (void) strcpy(filename,image->filename);   status=True;.   if (strcmp(image_info->magick,"SHTML") != 0)     {        /*         Open output image file.        */2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);        /*"         Write the HTML image file.       */*       if (*image->magick_filename != '\0')>         (void) strcpy(image->filename,image->magick_filename);=       (void) fprintf(image->file,"<html version=\"2.0\">\n"); -       (void) fprintf(image->file,"<head>\n"); H       (void) fprintf(image->file,"<title>%s</title>\n",image->filename);.       (void) fprintf(image->file,"</head>\n");-       (void) fprintf(image->file,"<body>\n"); /       (void) fprintf(image->file,"<center>\n"); B       (void) fprintf(image->file,"<h1>%s</h1>\n",image->filename);/       (void) fprintf(image->file,"<br><br>\n"); .       (void) strcpy(filename,image->filename);(       AppendImageFormat("gif",filename);P       (void) fprintf(image->file,"<img ismap usemap=#%s src=\"%s\" border=0>\n",         mapname,filename);       /*;         Determine the size and location of each image tile.        */
       x=0;
       y=0;       width=image->columns;        height=image->rows; *       if (image->montage != (char *) NULL)C         (void) XParseGeometry(image->montage,&x,&y,&width,&height);        /*         Write an image map.        */<       (void) fprintf(image->file,"<map name=%s>\n",mapname);<       (void) fprintf(image->file,"  <area href=""%s""",url);,       if (image->directory == (char *) NULL)G         (void) fprintf(image->file,"%s shape=rect coords=0,0,%u,%u>\n", ,           image->filename,width-1,height-1);
       else1         for (p=image->directory; *p != '\0'; p++)            if (*p != '\n') )             (void) fputc(*p,image->file);            else
             { M               (void) fprintf(image->file," shape=rect coords=%d,%d,%d,%d>\n", 6                 x,y,x+(int) width-1,y+(int) height-1);!               if (*(p+1) != '\0') F                 (void) fprintf(image->file,"  <area href=""%s""",url);               x+=width; &               if (x >= image->columns)                 {                    x=0;                   y+=height;                 } 
             } -       (void) fprintf(image->file,"</map>\n"); *       if (image->montage != (char *) NULL)	         {            char!             color[MaxTextExtent];              /*0             Back montage background transparent.           *//           (void) sprintf(color,"#%02x%02x%02x", 0             (unsigned int) image->pixels[0].red,2             (unsigned int) image->pixels[0].green,2             (unsigned int) image->pixels[0].blue);(           TransparentImage(image,color);	         } .       (void) strcpy(filename,image->filename);0       (void) fprintf(image->file,"</center>\n");.       (void) fprintf(image->file,"</body>\n");.       status=fprintf(image->file,"</html>\n");       CloseImage(image);0       if (strcmp(image_info->magick,"GIF") != 0)	         {            /*/             Write the image as transparent GIF.            */2           (void) strcpy(image->filename,filename);3           AppendImageFormat("gif",image->filename); 2           status|=WriteGIFImage(image_info,image);	         }        /*%         Determine image map filename.        */.       (void) strcpy(image->filename,filename);<       for (p=filename+Extent(filename)-1; p > filename; p--)         if (*p == '.')           { @             (void) strncpy(image->filename,filename,p-filename);-             image->filename[p-filename]='\0';              break;           } 2       (void) strcat(image->filename,"_map.shtml");     }    /*     Open image map.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*7     Determine the size and location of each image tile.    */   x=0;   y=0;   width=image->columns;    height=image->rows; &   if (image->montage != (char *) NULL)?     (void) XParseGeometry(image->montage,&x,&y,&width,&height);    /*     Write an image map.    */8   (void) fprintf(image->file,"<map name=%s>\n",mapname);8   (void) fprintf(image->file,"  <area href=""%s""",url);(   if (image->directory == (char *) NULL)C     (void) fprintf(image->file,"%s shape=rect coords=0,0,%u,%u>\n", (       image->filename,width-1,height-1);   else-     for (p=image->directory; *p != '\0'; p++)        if (*p != '\n') %         (void) fputc(*p,image->file); 
       else	         { M           (void) fprintf(image->file," shape=rect coords=%d,%d,%d,%d>\n",x,y, .             x+(int) width-1,y+(int) height-1);           if (*(p+1) != '\0') B             (void) fprintf(image->file,"  <area href=""%s""",url);           x+=width; "           if (x >= image->columns)
             {                x=0;               y+=height;
             } 	         } )   (void) fprintf(image->file,"</map>\n");    CloseImage(image);*   (void) strcpy(image->filename,filename);   return(status);  }    #ifdef HasJBIG /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e J B I G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteJBIGImage writes an image in the JBIG encoded image format. % / %  The format of the WriteJBIGImage routine is:  % . %      status=WriteJBIGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteJBIGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  G static void JBIGEncode(unsigned char  *start,size_t length,void  *file)  { .   (void) fwrite(start,length,1,(FILE *) file);	   return;  }   L static unsigned int WriteJBIGImage(const ImageInfo *image_info,Image *image) {    int      sans_offset;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     bit,     *q;      struct jbg_enc_state     jbig_info;     unsigned char      *pixels,
     polarity;      unsigned int	     byte,      number_packets,      x,     x_resolution,      y_resolution;      /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*       Allocate pixel data.     */9     number_packets=((image->columns+7) >> 3)*image->rows; J     pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));)     if (pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*3       Convert Runlength encoded pixels to a bitmap.      */"     if (!IsMonochromeImage(image))       {          QuantizeInfo           quantize_info;  (         GetQuantizeInfo(&quantize_info);&         quantize_info.number_colors=2;0         quantize_info.dither=image_info->dither;0         quantize_info.colorspace=GRAYColorspace;,         QuantizeImage(&quantize_info,image);         SyncImage(image);        }      polarity=0;      if (image->colors == 2) M       polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]); 
     bit=0;     byte=0;      x=0;     p=image->pixels;
     q=pixels; &     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)       {          byte<<=1; !         if (p->index == polarity)            byte|=0x01;          bit++;         if (bit == 8)            {              *q++=byte;             bit=0;             byte=0;            }          x++;          if (x == image->columns)           {              /*+               Advance to the next scanline.              */             if (bit != 0) #               *q++=byte << (8-bit);              bit=0;             byte=0;              x=0;
          }       } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     }      /*%       Initialize JBIG info structure.      */A     jbg_enc_init(&jbig_info,image->columns,image->rows,1,&pixels, ;       (void (*)(unsigned char *,size_t,void *)) JBIGEncode,        image->file);      x_resolution=640;      y_resolution=480; H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,#       &x_resolution,&y_resolution); "     if (image_info->subimage != 0)6       jbg_enc_layers(&jbig_info,image_info->subimage);     else;       jbg_enc_lrlmax(&jbig_info,x_resolution,y_resolution); %     jbg_enc_lrange(&jbig_info,-1,-1); L     jbg_enc_options(&jbig_info,JBG_ILEAVE | JBG_SMID,JBG_TPDON | JBG_TPBON |       JBG_DPON,-1,-1,-1);      /*       Write JBIG image.      */     jbg_enc_out(&jbig_info);     jbg_enc_free(&jbig_info);      free((char *) pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }  #else L static unsigned int WriteJBIGImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   ;   Warning("JBIG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   #ifdef HasJPEG static Image	   *image;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the WriteJPEGImage routine is:  % . %      status=WriteJPEGImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  9 static void EmitMessage(j_common_ptr jpeg_info,int level)  {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { H       if (jpeg_error->num_warnings == 0 || jpeg_error->trace_level >= 3)2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   L static unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) { 	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];     register int     i,     j,     x;     register JSAMPLE     *q;      register RunlengthPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;#   jpeg_create_compress(&jpeg_info); *   jpeg_stdio_dest(&jpeg_info,image->file);'   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB;    if (IsGrayImage(image))      { #       jpeg_info.input_components=1; -       jpeg_info.in_color_space=JCS_GRAYSCALE;      }     jpeg_set_defaults(&jpeg_info);   jpeg_info.density_unit=0; 2   jpeg_info.X_density=(short) image->x_resolution;2   jpeg_info.Y_density=(short) image->y_resolution;.   if (image->units == PixelsPerInchResolution)     jpeg_info.density_unit=1; 4   if (image->units == PixelsPerCentimeterResolution)     jpeg_info.density_unit=2; $   for (i=0; i < MAX_COMPONENTS; i++)   { +     jpeg_info.comp_info[i].h_samp_factor=1; +     jpeg_info.comp_info[i].v_samp_factor=1;    } 8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True;  #if (JPEG_LIB_VERSION >= 61)"   jpeg_info.dct_method=JDCT_FLOAT;-   if (image_info->interlace != NoneInterlace) (     jpeg_simple_progression(&jpeg_info); #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) 4     for (i=0; i < Extent(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,=         (unsigned int) Min(Extent(image->comments+i),65533));    /*'     Convert MIFF to JPEG raster pixels.    */4   packets=jpeg_info.input_components*image->columns;:   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));&   if (jpeg_pixels == (JSAMPLE *) NULL)5     PrematureExit("Unable to allocate memory",image);    p=image->pixels;   q=jpeg_pixels;   x=0;%   scanline[0]=(JSAMPROW) jpeg_pixels; ;   if ((jpeg_info.data_precision > 8) && (QuantumDepth > 8))      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { 0             *q++=(JSAMPLE) (Intensity(*p) >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         } 
       else*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { )             *q++=(JSAMPLE) (p->red >> 4); +             *q++=(JSAMPLE) (p->green >> 4); *             *q++=(JSAMPLE) (p->blue >> 4);             x++;$             if (x == image->columns)               { C                 (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                  q=jpeg_pixels;                 x=0;               }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         { 2           *q++=(JSAMPLE) DownScale(Intensity(*p));           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }      else(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         { +           *q++=(JSAMPLE) DownScale(p->red); -           *q++=(JSAMPLE) DownScale(p->green); ,           *q++=(JSAMPLE) DownScale(p->blue);           x++;"           if (x == image->columns)
             { A               (void) jpeg_write_scanlines(&jpeg_info,scanline,1);                q=jpeg_pixels;               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */$   jpeg_destroy_compress(&jpeg_info);   free((char *) jpeg_pixels);    CloseImage(image);   return(True);  }  #else L static unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   ;   Warning("JPEG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e L O G O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteLOGOImage writes an image in the LOGO encoded image format.F %  We use GIF because it is the only format that is compressed without9 %  requiring addition optional plug-ins (TIFF, ZIP, etc).  % / %  The format of the WriteLOGOImage routine is:  % . %      status=WriteLOGOImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteLOGOImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteLOGOImage(const ImageInfo *image_info,Image *image) {    char     filename[MaxTextExtent];     FILE
     *file;     int      c;     register int     i;     unsigned int     status;      unsigned long 
     filesize;      /*=     Write logo as PseudoColor MIFF image to a temporary file.    */*   (void) strcpy(filename,image->filename);%   TemporaryFilename(image->filename); )   status=WriteGIFImage(image_info,image);    if (status == False)     return(status); -   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); !   (void) remove(image->filename);    filesize=image->filesize;    file=image->file;    /*     Write logo image.    */*   (void) strcpy(image->filename,filename);.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); %   (void) fprintf(image->file,"/*\n"); <   (void) fprintf(image->file,"  Logo image declaration.\n");%   (void) fprintf(image->file,"*/\n"); J   (void) fprintf(image->file,"#define LogoImageExtent  %lu\n\n",filesize);7   (void) fprintf(image->file,"static unsigned char\n"); 1   (void) fprintf(image->file,"  LogoImage[]=\n"); &   (void) fprintf(image->file,"  {\n");%   (void) fprintf(image->file,"    ");    for (i=0; ; i++)   {      c=fgetc(file);     if (c < 0)       break;-     (void) fprintf(image->file,"0x%02x, ",c);      if (((i+1) % 12) == 0)+       (void) fprintf(image->file,"\n    ");    } )   (void) fprintf(image->file,"\n  };\n");    (void) fclose(file);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMAPImage writes an image to a file as red, green, and blue 3 %  colormap bytes followed by the colormap indexes.  % . %  The format of the WriteMAPImage routine is: % - %      status=WriteMAPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMAPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteMAPImage(const ImageInfo *image_info,Image *image)  {    register int     i;     register unsigned char     *q;      unsigned char      *colormap;     unsigned int     packets,     packet_size;     unsigned short
     value;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate colormap.   */"   if (image->class == DirectClass)     {        QuantizeInfo         quantize_info;         /**         Demote DirectClass to PseudoClass.       */&       GetQuantizeInfo(&quantize_info);2       quantize_info.number_colors=MaxColormapSize;.       quantize_info.dither=image_info->dither;*       QuantizeImage(&quantize_info,image);       SyncImage(image);      } $   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));)   if (colormap == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);    /*     Write colormap to file.    */
   q=colormap; #   for (i=0; i < image->colors; i++)    { +     WriteQuantum(image->colormap[i].red,q); -     WriteQuantum(image->colormap[i].green,q); ,     WriteQuantum(image->colormap[i].blue,q);   } D   (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,     image->file);    free((char *) colormap);   /*     Write image pixels to file.    */#   image->compression=NoCompression; &   packets=RunlengthEncodeImage(image);G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size,      (int) packets,image->file);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function WriteMATTEImage writes an image of matte bytes to a file.  It C %  consists of data from the matte component of the image [0..255].  % 0 %  The format of the WriteMATTEImage routine is: % / %      status=WriteMATTEImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */M static unsigned int WriteMATTEImage(const ImageInfo *image_info,Image *image)  {    Image      *matte_image;      register int     i;     unsigned int     status;      if (!image->matte)?     PrematureExit("Image does not have a matte channel",image);    image->orphan=True; ?   matte_image=CopyImage(image,image->columns,image->rows,True);    image->orphan=False;$   if (matte_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); !   matte_image->class=PseudoClass; -   matte_image->colors=(Opaque-Transparent)+1; '   matte_image->colormap=(ColorPacket *) 4     malloc(matte_image->colors*sizeof(ColorPacket));4   if (matte_image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image); '   for (i=Transparent; i <= Opaque; i++)    { #     matte_image->colormap[i].red=i; %     matte_image->colormap[i].green=i; $     matte_image->colormap[i].blue=i;   }    SyncImage(matte_image); 0   status=WriteMIFFImage(image_info,matte_image);   DestroyImage(matte_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Function WriteMIFFImage writes an image to a file.  % / %  The format of the WriteMIFFImage routine is:  % . %      status=WriteMIFFImage(image_info,image) % + %  A description of each parameter follows:  % K %    o status: Function WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */L static unsigned int WriteMIFFImage(const ImageInfo *image_info,Image *image) {    register int     i;     unsigned long      packets;  E   if ((image->class != DirectClass) && (image->class != PseudoClass)) /     PrematureExit("Unknown image class",image);    /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); 4   (void) strcpy((char *) image_info->magick,"MIFF");   do   {      /*       Pack image pixels.     *//     image->compression=image_info->compression; (     packets=RunlengthEncodeImage(image);2     if (image_info->compression == ZipCompression)       {          int            status;            unsigned char            *compressed_pixels;            unsigned long            compressed_packets;   
         /*2           Compress image pixels with Zip encoding.
         */D         compressed_packets=((packets*image->packet_size*110)/100)+8;+         compressed_pixels=(unsigned char *) ;           malloc(compressed_packets*sizeof(unsigned char)); 8         if (compressed_pixels == (unsigned char *) NULL);           PrematureExit("Unable to allocate memory",image);          status=True;
 #ifdef HasPNG >         status=compress(compressed_pixels,&compressed_packets,;           image->packed_pixels,packets*image->packet_size);  #endif         if (status)            { D             Warning("Unable to Zip compress image",image->filename);-             free((char *) compressed_pixels);            }          else           { 0             free((char *) image->packed_pixels);3             image->packed_pixels=compressed_pixels; !             image->packet_size=1; '             packets=compressed_packets;            }        }      /*       Write header to file.      */3     (void) fprintf(image->file,"id=ImageMagick\n"); $     if (image->class == PseudoClass)B       (void) fprintf(image->file,"class=PseudoClass  colors=%u\n",         image->colors);      else       if (image->matte) F         (void) fprintf(image->file,"class=DirectClass  matte=True\n");
       else:         (void) fprintf(image->file,"class=DirectClass\n");:     if (image->compression == RunlengthEncodedCompression)O       (void) fprintf(image->file,"compression=RunlengthEncoded  packets=%lu\n",          packets);      else/       if (image->compression == ZipCompression) M         (void) fprintf(image->file,"compression=Zip  packets=%lu\n",packets); P     (void) fprintf(image->file,"columns=%u  rows=%u  depth=%u\n",image->columns,        image->rows,image->depth);     SignatureImage(image);*     if (image->signature != (char *) NULL)D       (void) fprintf(image->file,"signature=%s\n",image->signature);     if (image->scene != 0)<       (void) fprintf(image->file,"scene=%u\n",image->scene);     if (image->gamma != 0.0)<       (void) fprintf(image->file,"gamma=%f\n",image->gamma);     if (image->delay != 0)<       (void) fprintf(image->file,"delay=%u\n",image->delay);(     if (image->montage != (char *) NULL)@       (void) fprintf(image->file,"montage=%s\n",image->montage);&     if (image->label != (char *) NULL)@       (void) fprintf(image->file,"label=\"%s\"\n",image->label);)     if (image->comments != (char *) NULL) ?       (void) fprintf(image->file,"{\n%s\n}\n",image->comments); *     (void) fprintf(image->file,"\f\n:\n");(     if (image->montage != (char *) NULL)       { 
         /*'           Write montage tile directory. 
         */.         if (image->directory != (char *) NULL)<           (void) fprintf(image->file,"%s",image->directory);'         (void) fputc('\0',image->file);        } $     if (image->class == PseudoClass)       {          register unsigned char
           *q;            unsigned char            *colormap;           unsigned int           packet_size;           unsigned short           value;  
         /*           Allocate colormap.
         */*         packet_size=3*(image->depth >> 3);"         colormap=(unsigned char *)B           malloc(packet_size*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);          q=colormap; )         for (i=0; i < image->colors; i++) 	         { 1           WriteQuantum(image->colormap[i].red,q); 3           WriteQuantum(image->colormap[i].green,q); 2           WriteQuantum(image->colormap[i].blue,q);	         } 
         /*!           Write colormap to file. 
         */J         (void) fwrite((char *) colormap,1,(int) image->colors*packet_size,           image->file);           free((char *) colormap);       }      /*!       Write image pixels to file.      */I     (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, !       (int) packets,image->file); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M O N O I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteMONOImage writes an image of raw bits in LSB order to a file. % / %  The format of the WriteMONOImage routine is:  % . %      status=WriteMONOImage(image_info,image) % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteMONOImage(const ImageInfo *image_info,Image *image) {    int      x;     register unsigned char     bit,	     byte, 
     polarity;      register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*&     Convert image to a bi-level image.   */    if (!IsMonochromeImage(image))     {        QuantizeInfo         quantize_info;  &       GetQuantizeInfo(&quantize_info);$       quantize_info.number_colors=2;.       quantize_info.dither=image_info->dither;.       quantize_info.colorspace=GRAYColorspace;*       QuantizeImage(&quantize_info,image);       SyncImage(image);      } 
   polarity=0;    if (image->colors == 2) K     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);    bit=0;	   byte=0;    x=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        byte>>=1;        if (p->index == polarity)          byte|=0x80;        bit++;       if (bit == 8) 	         { )           (void) fputc(byte,image->file);            bit=0;           byte=0; 	         } 
       x++;       if (x == image->columns)	         {            /*)             Advance to the next scanline.            */           if (bit != 0) 6             (void) fputc(byte >> (8-bit),image->file);           bit=0;           byte=0;            x=0;        }     }      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M P E G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteMPEGImage writes an image in the MPEG encoded image format. % / %  The format of the WriteMPEGImage routine is:  % . %      status=WriteMPEGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteMPEGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteMPEGImage(const ImageInfo *image_info,Image *image) {    char     basename[MaxTextExtent],     command[MaxTextExtent],      filename[MaxTextExtent];     Image      component_image;     ImageInfo      local_info;      MonitorHandler     handler;     register int     i;     unsigned int     number_images,
     scene,     status;   $   if (image->next == (Image *) NULL);     PrematureExit("MPEG requires multi-frame image",image);    /*     Write component images.    */   scene=image->scene; G   for (number_images=0; image->next != (Image *) NULL; number_images++)      image=image->next;   number_images++;+   while (image->previous != (Image *) NULL)      image=image->previous;   TemporaryFilename(basename);#   (void) strcpy(filename,basename);    (void) strcat(filename,"%d");    local_info=(*image_info); *   local_info.interlace=PartitionInterlace;#   for (i=0; i < number_images; i++)    { 5     handler=SetMonitorHandler((MonitorHandler) NULL);      component_image=(*image); ,     component_image.previous=(Image *) NULL;(     component_image.next=(Image *) NULL;8     (void) sprintf(component_image.filename,filename,i);7     (void) WriteYUVImage(&local_info,&component_image); &     if (image->next != (Image *) NULL)       image=image->next;&     (void) SetMonitorHandler(handler);3     ProgressMonitor(SaveImageText,i,number_images);    }    /*     Write MPEG image.    */K   (void) sprintf(command,"mpeg -a %u -b %u -h %u -v %u -PF %s -s %s",scene, F     image->scene,image->columns,image->rows,basename,image->filename);    status=SystemCommand(command);   /*     Remove component files.    */#   for (i=0; i < number_images; i++)    { 8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".Y"); ,     (void) remove(component_image.filename);8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".U"); ,     (void) remove(component_image.filename);8     (void) sprintf(component_image.filename,filename,i);1     (void) strcat(component_image.filename,".V"); ,     (void) remove(component_image.filename);   }    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % . %  The format of the WriteMTVImage routine is: % - %      status=WriteMTVImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteMTVImage(const ImageInfo *image_info,Image *image)  {    register int     i,     j;     register RunlengthPacket     *p;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Convert MIFF to MTV raster pixels.     */E     (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);      p=image->pixels;&     for (i=0; i < image->packets; i++)     { ,       for (j=0; j <= ((int) p->length); j++)       { 4         (void) fputc(DownScale(p->red),image->file);6         (void) fputc(DownScale(p->green),image->file);5         (void) fputc(DownScale(p->blue),image->file);        } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePCDImage writes an image in the Photo CD encoded image 
 %  format. % . %  The format of the WritePCDImage routine is: % - %      status=WritePCDImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  = static unsigned int WritePCDTile(Image *image,char *geometry,    char *tile_geometry) {    Image      *downsampled_image,      *tile_image;     int      x,     y;     register int     i;     register RunlengthPacket     *p,      *q;      unsigned int     height, 
     width;     /*     Scale image to tile size.    */   width=image->columns;    height=image->rows; ;   (void) ParseImageGeometry(geometry,&x,&y,&width,&height);    if ((width % 2) != 0)      width--;   if ((height % 2) != 0)
     height--;    image->orphan=True; :   tile_image=ZoomImage(image,width,height,MitchellFilter);   image->orphan=False;#   if (tile_image == (Image *) NULL) 1     PrematureExit("Unable to scale image",image); 1   (void) sscanf(geometry,"%ux%u",&width,&height); E   if ((tile_image->columns != width) || (tile_image->rows != height))      {        Image          *bordered_image;         RectangleInfo          border_info;         /*&         Put a border around the image.       */;       border_info.width=(width-tile_image->columns+1) >> 1; :       border_info.height=(height-tile_image->rows+1) >> 1;:       bordered_image=BorderImage(tile_image,&border_info);+       if (bordered_image == (Image *) NULL) 6         PrematureExit("Unable to border image",image);       DestroyImage(tile_image);         tile_image=bordered_image;     } :   TransformImage(&tile_image,(char *) NULL,tile_geometry);.   RGBTransformImage(tile_image,YCCColorspace);,   downsampled_image=MinifyImage(tile_image);*   if (downsampled_image == (Image *) NULL)1     PrematureExit("Unable to scale image",image); #   if (!UncompressImage(tile_image))      return(False);*   if (!UncompressImage(downsampled_image))     return(False);   /*     Write tile to PCD file.    */   p=tile_image->pixels; '   for (y=0; y < tile_image->rows; y+=2)    { 2     for (x=0; x < (tile_image->columns << 1); x++)     { 2       (void) fputc(DownScale(p->red),image->file);
       p++;     } D     q=downsampled_image->pixels+(y >> 1)*downsampled_image->columns;2     for (x=0; x < downsampled_image->columns; x++)     { 4       (void) fputc(DownScale(q->green),image->file);
       q++;     } D     q=downsampled_image->pixels+(y >> 1)*downsampled_image->columns;2     for (x=0; x < downsampled_image->columns; x++)     { 3       (void) fputc(DownScale(q->blue),image->file); 
       q++;     }    }    for (i=0; i < 0x800; i++) #     (void) fputc('\0',image->file); "   DestroyImage(downsampled_image);   DestroyImage(tile_image);    return(True);  }   K static unsigned int WritePCDImage(const ImageInfo *image_info,Image *image)  {    Image      *pcd_image;      register int     i;     unsigned int     status;      pcd_image=image;#   if (image->columns < image->rows)      {        Image          *rotated_image;          /*%         Rotate portrait to landscape.        */       image->orphan=True; 7       rotated_image=RotateImage(image,90.0,False,True);        image->orphan=False;*       if (rotated_image == (Image *) NULL)6         PrematureExit("Unable to rotate image",image);       pcd_image=rotated_image;     }    /*     Open output image file.    */2   OpenImage(image_info,pcd_image,WriteBinaryType);'   if (pcd_image->file == (FILE *) NULL) 3     PrematureExit("Unable to open file",pcd_image);    /*     Write PCD image header.    */   for (i=0; i < 0x800; i++) '     (void) fputc('\0',pcd_image->file); /   (void) fwrite("PCD_IPI",1,7,pcd_image->file);    for (i=0; i < 1531; i++)'     (void) fputc('\0',pcd_image->file); #   if (image->columns < image->rows) '     (void) fputc('\1',pcd_image->file);    else'     (void) fputc('\0',pcd_image->file); "   for (i=0; i < 3*0x800-1539; i++)'     (void) fputc('\0',pcd_image->file);    /*     Write PCD tiles.   */6   status=WritePCDTile(pcd_image,"768x512>","192x128");7   status|=WritePCDTile(pcd_image,"768x512>","384x256"); 7   status|=WritePCDTile(pcd_image,"768x512>","768x512");    CloseImage(pcd_image);#   if (image->columns < image->rows)      DestroyImage(pcd_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C L I m a g e                                                 % O %                                                                             % O %                                                                             %  %                                                                             % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WritePCLImage writes an image in the Page Control Language encoded %  image format. % . %  The format of the WritePCLImage routine is: % - %      status=WritePCLImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCLImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  %  */K static unsigned int WritePCLImage(const ImageInfo *image_info,Image *image)  {    int      delta_x,     delta_y,
     flags,     sans_offset,     x,     y;     register int     i,     j;     register RunlengthPacket     *p;      unsigned int     density,     height,      page_height,     page_size,     page_width,      text_size,
     width;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize the printer.    */3   (void) fprintf(image->file,"\033E");  /* reset */ E   (void) fprintf(image->file,"\033&l0O");  /* portrait orientation */ =   (void) fprintf(image->file,"\033&l0E");  /* top margin 0 */    /*     Center image on PCL page.    */   text_size=0;$   if (image->label != (char *) NULL)E     text_size=MultilineCensus(image->label)*image_info->pointsize+12;    x=0;   y=0;   width=image->columns;    height=image->rows; H   (void) XParseGeometry(PCLPageGeometry,&x,&y,&page_width,&page_height);   flags=NoValue;(   if (image_info->page != (char *) NULL)J     flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);#   if (image->page != (char *) NULL) E     flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); (   if (((page_width-(x << 1)) < width) ||2       ((page_height-(y << 1)-text_size) < height))     {        unsigned long          scale_factor;          /*)         Scale image relative to PCL page.        */6       scale_factor=UpShift(page_width-(x << 1))/width;J       if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))D         scale_factor=UpShift(page_height-(y << 1)-text_size)/height;*       width=DownShift(width*scale_factor);,       height=DownShift(height*scale_factor);     }    if ((flags & XValue) == 0)     {        /*(         Center image in the X direction.       */*       delta_x=page_width-(width+(x << 1));       if (delta_x >= 0)          x=(delta_x >> 1)+x;      }    if ((flags & YValue) == 0)     {        /*(         Center image in the X direction.       */6       delta_y=page_height-(height+(y << 1))-text_size;       if (delta_y >= 0)          y=(delta_y >> 1)+y;      }    page_size=2;2   if ((page_width == 540) && (page_height == 720))!     page_size=1;  /* executive */ 2   if ((page_width == 612) && (page_height == 792))     page_size=2;  /* letter */3   if ((page_width == 612) && (page_height == 1008))      page_size=3;  /* legal */ 3   if ((page_width == 1224) && (page_height == 792))      page_size=6;  /* ledger */2   if ((page_width == 595) && (page_height == 842))     page_size=26;  /* A4 */ 3   if ((page_width == 842) && (page_height == 1191))      page_size=27;  /* A3 */ 3   if ((page_width == 729) && (page_height == 1032))      page_size=45;  /* B5 */ 2   if ((page_width == 516) && (page_height == 729))     page_size=46;  /* B4 */ E   (void) fprintf(image->file,"\033&l%uA",page_size);  /* papersize */ E   (void) XParseGeometry(PCLDensityGeometry,&sans_offset,&sans_offset,      &density,&density); +   if (image_info->density != (char *) NULL) H     (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,       &density,&density); 1   (void) fprintf(image->file,"\033*p%dx%dY",x,y); $   if (image->label != (char *) NULL)     {        /*         Print label.       */-       (void) fprintf(image->file,"\033&k2G"); J       (void) fprintf(image->file,"\033(s1p%uv5t3b",image_info->pointsize);8       (void) fprintf(image->file,"\n%s\n",image->label);-       (void) fprintf(image->file,"\033(s0B");      } L   (void) fprintf(image->file,"\033*t%uR",density);  /* graphic resolution */   width=(density*width)/75;    height=(density*height)/75;    if (!IsGrayImage(image))     {        /*         Write PCL color image.       */L       (void) fprintf(image->file,"\033*r%us%uT",image->columns,image->rows);>       (void) fprintf(image->file,"\033*t%uh%uV",width,height);-       (void) fprintf(image->file,"\033*v6W"); :       (void) fputc('\000',image->file);  /* color model */D       (void) fputc('\003',image->file);  /* direct pixel encoding */=       (void) fputc('\000',image->file);  /* bits per index */ 6       (void) fputc('\010',image->file);  /* bits red*/8       (void) fputc('\010',image->file);  /* bits green*/8       (void) fputc('\010',image->file);  /* bits blue */C       (void) fprintf(image->file,"\033*r2A");  /* start graphics */ C       (void) fprintf(image->file,"\033*b0M");  /* no compression */ ?       (void) fprintf(image->file,"\033*b%uW",3*image->columns); 
       x=0;       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)F           (void) fprintf(image->file,"%c%c%c",(int) DownScale(p->red),@             (int) DownScale(p->green),(int) DownScale(p->blue));         x++;          if (x == image->columns)           { E             (void) fprintf(image->file,"\033*b%uW",3*image->columns);              x=0;           }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } @       (void) fprintf(image->file,"\033*rC");  /* end graphics */     }    else     { 
       char          geometry[MaxTextExtent];         register unsigned char         bit,
         byte,          polarity;          /*#         Write PCL monochrome image.        */?       if ((width != image->columns) || (height != image->rows)) 	         {            FILE             *file;             /*             Scale image.           */           file=image->file; <           image->file=(FILE *) NULL;  /* prevents closing */8           (void) sprintf(geometry,"%ux%u",width,height);8           TransformImage(&image,(char *) NULL,geometry);           image->file=file; 	         }        if (image->colors > 2)	         {            QuantizeInfo             quantize_info;  *           GetQuantizeInfo(&quantize_info);(           quantize_info.number_colors=2;2           quantize_info.dither=image_info->dither;2           quantize_info.colorspace=GRAYColorspace;.           QuantizeImage(&quantize_info,image);           SyncImage(image); 	         }        p=image->pixels;       polarity=0;        if (image->colors == 2)          polarity= H           Intensity(image->colormap[0]) > Intensity(image->colormap[1]);       bit=0;
       byte=0; 
       x=0;
       y=0;L       (void) fprintf(image->file,"\033*r%us%uT",image->columns,image->rows);C       (void) fprintf(image->file,"\033*r1A");  /* start graphics */ C       (void) fprintf(image->file,"\033*b0M");  /* no compression */ C       (void) fprintf(image->file,"\033*b%uW",(image->columns+7)/8); (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             { -               (void) fputc(byte,image->file);                bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) ;                 (void) fputc(byte  << (8-bit),image->file);                bit=0;               byte=0;                x=0;               y++;"               if (y < image->rows)M                 (void) fprintf(image->file,"\033*b%uW",(image->columns+7)/8);             }	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       } @       (void) fprintf(image->file,"\033*rB");  /* end graphics */     } )   (void) fprintf(image->file,"\033&l0H"); 3   (void) fprintf(image->file,"\033E");  /* reset */    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WritePCXImage writes an image in the ZSoft IBM PC Paintbrush file 
 %  format. % . %  The format of the WritePCXImage routine is: % - %      status=WritePCXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WritePCXImage(const ImageInfo *image_info,Image *image)  {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     int      id;      PCXHeader      pcx_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     count,     packet,      *pcx_colormap,     *pcx_pixels,
     previous;      unsigned int     packets;     unsigned long      *page_table;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image); $   page_table=(unsigned long *) NULL;,   if (strcmp(image_info->magick,"DCX") == 0)     {        /*!         Write the DCX page table.        */0       LSBFirstWriteLong(0x3ade68b1,image->file);F       page_table=(unsigned long *) malloc(1024*sizeof(unsigned long));/       if (page_table == (unsigned long *) NULL) 9         PrematureExit("Unable to allocate memory",image); !       for (id=0; id < 1024; id++) +         LSBFirstWriteLong(0x0,image->file);      }    for (id=0; id < 1024; id++)    { -     if (page_table != (unsigned long *) NULL) (       page_table[id]=ftell(image->file);     /*(       Initialize PCX raster file header.     */     pcx_header.identifier=0x0a;      pcx_header.version=5;      pcx_header.encoding=1;      pcx_header.bits_per_pixel=8;!     if (IsMonochromeImage(image)) "       pcx_header.bits_per_pixel=1;     pcx_header.left=0;     pcx_header.top=0; &     pcx_header.right=image->columns-1;$     pcx_header.bottom=image->rows-1;<     pcx_header.horizontal_resolution=(short) image->columns;7     pcx_header.vertical_resolution=(short) image->rows; 0     if (image->units == PixelsPerInchResolution)       { E         pcx_header.horizontal_resolution=(short) image->x_resolution; C         pcx_header.vertical_resolution=(short) image->y_resolution;        } 6     if (image->units == PixelsPerCentimeterResolution)       { L         pcx_header.horizontal_resolution=(short) (2.54*image->x_resolution);J         pcx_header.vertical_resolution=(short) (2.54*image->y_resolution);       }      pcx_header.reserved=0;     pcx_header.planes=1;     if (!IsPseudoClass(image))       {          pcx_header.planes=3;         if (image->matte)            pcx_header.planes++;       } M     pcx_header.bytes_per_line=(image->columns*pcx_header.bits_per_pixel+7)/8;      pcx_header.palette_info=1;'     pcx_header.colormap_signature=0x0c;      /*       Write PCX header.      */:     (void) fwrite(&pcx_header.identifier,1,1,image->file);7     (void) fwrite(&pcx_header.version,1,1,image->file); 8     (void) fwrite(&pcx_header.encoding,1,1,image->file);>     (void) fwrite(&pcx_header.bits_per_pixel,1,1,image->file);C     LSBFirstWriteShort((unsigned int) pcx_header.left,image->file); B     LSBFirstWriteShort((unsigned int) pcx_header.top,image->file);D     LSBFirstWriteShort((unsigned int) pcx_header.right,image->file);E     LSBFirstWriteShort((unsigned int) pcx_header.bottom,image->file); G     LSBFirstWriteShort((unsigned int) pcx_header.horizontal_resolution,        image->file); E     LSBFirstWriteShort((unsigned int) pcx_header.vertical_resolution,        image->file);      /*       Dump colormap to file.     */G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); /     if (pcx_colormap == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      for (i=0; i < (3*256); i++)        pcx_colormap[i]=0;     q=pcx_colormap; $     if (image->class == PseudoClass)'       for (i=0; i < image->colors; i++)        { /         *q++=DownScale(image->colormap[i].red); 1         *q++=DownScale(image->colormap[i].green); 0         *q++=DownScale(image->colormap[i].blue);       } :     (void) fwrite((char *) pcx_colormap,3,16,image->file);8     (void) fwrite(&pcx_header.reserved,1,1,image->file);6     (void) fwrite(&pcx_header.planes,1,1,image->file);M     LSBFirstWriteShort((unsigned int) pcx_header.bytes_per_line,image->file); K     LSBFirstWriteShort((unsigned int) pcx_header.palette_info,image->file);      for (i=0; i < 58; i++)*       (void) fwrite("\0",1,1,image->file);D     packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;G     pcx_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); -     if (pcx_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      x=0;     y=0;     p=image->pixels;     q=pcx_pixels; $     if (image->class == DirectClass)       { 
         /*9           Convert DirectClass image to PCX raster pixels. 
         */$         if (!UncompressImage(image))           return(False);'         for (y=0; y < image->rows; y++) 	         { G           q=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes); 5           for (i=0; i < (int) pcx_header.planes; i++)            { -             p=image->pixels+y*image->columns; 9             for (x=0; x < pcx_header.bytes_per_line; x++) 
             {                switch (i)               {                  case 0:                  { )                   *q++=DownScale(p->red);                    break;                 }                  case 1:                  { +                   *q++=DownScale(p->green);                    break;                 }                  case 2:                  { *                   *q++=DownScale(p->blue);                   break;                 }                  case 3:                  default:                 { +                   *q++=DownScale(p->index);                    break;                 }                }                p++;
             }            } 7           ProgressMonitor(SaveImageText,y,image->rows); 	         }        }      else(       if (pcx_header.bits_per_pixel > 1)*         for (i=0; i < image->packets; i++)	         {            /*;             Convert PseudoClass image to PCX raster pixels.            */0           for (j=0; j <= ((int) p->length); j++)           {              *q++=p->index;             x++;$             if (x == image->columns)               {                  x=0;                 y++;9                 q=pcx_pixels+y*pcx_header.bytes_per_line;                }            }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         } 
       else	         {             register unsigned char             bit,             byte,%             polarity;%             /*@             Convert PseudoClass image to a PCX monochrome image.           */           polarity=0; !           if (image->colors == 2) 4             polarity=Intensity(image->colormap[0]) <,               Intensity(image->colormap[1]);           bit=0;           byte=0; ,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                byte<<=1; '               if (p->index == polarity)                  byte|=0x01;                bit++;               if (bit == 8)                  {                    *q++=byte;                   bit=0;                   byte=0;                  }                x++;&               if (x == image->columns)                 {i                   /*1                     Advance to the next scanline.                    */                   if (bit != 0) )                     *q++=byte << (8-bit);                    bit=0;                   byte=0;                    x=0;                   y++;;                   q=pcx_pixels+y*pcx_header.bytes_per_line;a                 } 
             }              p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           } 	         }      /*#       Runlength-encoded PCX pixels.      */#     for (y=0; y < image->rows; y++)      { C       q=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes); 1       for (i=0; i < (int) pcx_header.planes; i++)        {s         previous=(*q++);         count=1;9         for (x=0; x < (pcx_header.bytes_per_line-1); x++) 	         {            packet=(*q++);3           if ((packet == previous) && (count < 63))d
             {d               count++;               continue;t
             } 9           if ((count > 1) || ((previous & 0xc0) == 0xc0))i
             {d               count|=0xc0;4               (void) fwrite(&count,1,1,image->file);
             } 3           (void) fwrite(&previous,1,1,image->file);            previous=packet;           count=1;	         }e7         if ((count > 1) || ((previous & 0xc0) == 0xc0))b           {s             count|=0xc0;2             (void) fwrite(&count,1,1,image->file);           }N1         (void) fwrite(&previous,1,1,image->file);a5         ProgressMonitor(SaveImageText,y,image->rows);        }v     }      if (image->colors > 16)s       {eF         (void) fwrite(&pcx_header.colormap_signature,1,1,image->file);?         (void) fwrite((char *) pcx_colormap,3,256,image->file);d       }      free((char *) pcx_pixels);      free((char *) pcx_colormap);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   }u+   if (page_table != (unsigned long *) NULL)a     {        /*!         Write the DCX page table.s       */       page_table[id+1]=0;s%       (void) fseek(image->file,0L,0);o0       LSBFirstWriteLong(0x3ade68b1,image->file);       for (i=0; i <= id; i++)u5         LSBFirstWriteLong(page_table[i],image->file);t        free((char *) page_table);     }.   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             %tO %                                                                             % O %                                                                             %cO %   W r i t e P D F I m a g e                                                 %eO %                                                                             %rO %                                                                             %lO %                                                                             %IO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %tH %  Function WritePDFImage writes an image in the Portable Document image
 %  format. %%. %  The format of the WritePDFImage routine is: % - %      status=WritePDFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WritePDFImage(const ImageInfo *image_info,Image *image)  { + #define DefaultThumbnailGeometry  "106x106"  #define ObjectsPerImage  12%     char     date[MaxTextExtent],     density[MaxTextExtent],%
     **labels;t     floatS     dx_resolution,     dy_resolution,     x_resolution,      y_resolution;e     intI
     count,     delta_x,     delta_y,
     flags,     x,     y;     Imaged     encode_image,p     *tile_image;     register RunlengthPacket     *p;m     register unsigned char     *q;e     register int     i,     j;     time_t
     timer;     unsigned charl     *pixels;     unsigned int     height,i     info_id,     number_packets,e     object,e
     pages_id,i     page_height,     page_width,r     root_id,     text_size,
     width;     unsigned longI     length,f
     *xref;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)d/     PrematureExit("Unable to open file",image);t-   if ((image->file == stdout) || image->pipe)o     {m       /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);        image->temporary=True;2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL)v3         PrematureExit("Unable to open file",image);i     }i   /*     Allocate X ref memory.   */<   xref=(unsigned long *) malloc(2048*sizeof(unsigned long));%   if (xref == (unsigned long *) NULL)i     {a9       Warning("Memory allocation error",image->filename);i       return(False);     }a   /*     Write Info object.   */   object=0;)-   (void) fprintf(image->file,"%%PDF-1.1 \n");>$   xref[object++]=ftell(image->file);   info_id=object;c2   (void) fprintf(image->file,"%u 0 obj\n",object);%   (void) fprintf(image->file,"<<\n");a   timer=time((time_t *) NULL);   (void) localtime(&timer);%$   (void) strcpy(date,ctime(&timer));   date[Extent(date)-1]='\0';:   (void) fprintf(image->file,"/CreationDate (%s)\n",date);8   (void) fprintf(image->file,"/Producer ImageMagick\n");%   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");    /*     Write Catalog object.    */$   xref[object++]=ftell(image->file);   root_id=object; 2   (void) fprintf(image->file,"%u 0 obj\n",object);%   (void) fprintf(image->file,"<<\n"); 1   (void) fprintf(image->file,"/Type /Catalog\n"); 9   (void) fprintf(image->file,"/Pages %u 0 R\n",object+1); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");%   /*     Write Pages object.%   */$   xref[object++]=ftell(image->file);   pages_id=object;2   (void) fprintf(image->file,"%u 0 obj\n",object);%   (void) fprintf(image->file,"<<\n");e/   (void) fprintf(image->file,"/Type /Pages\n");m9   (void) fprintf(image->file,"/Kids [ %u 0 R ",object+1);t#   count=pages_id+ObjectsPerImage+1;t   if (image_info->adjoin)u     {e       Imaget         *kid_image;          /*!         Predict page object id's.e       */       kid_image=image;H       for ( ; kid_image->next != (Image *) NULL; count+=ObjectsPerImage)       { 4         (void) fprintf(image->file,"%d 0 R ",count);"         kid_image=kid_image->next;       }g       xref=(unsigned long *)B         realloc((char *) xref,(count+2048)*sizeof(unsigned long));)       if (xref == (unsigned long *) NULL)e	         { =           Warning("Memory allocation error",image->filename);i           return(False);	         }s     } $   (void) fprintf(image->file,"]\n");M   (void) fprintf(image->file,"/Count %u\n",(count-pages_id)/ObjectsPerImage); %   (void) fprintf(image->file,">>\n"); )   (void) fprintf(image->file,"endobj\n");H   do   {      /*4       Scale image to size of Portable Document page.     */     text_size=0;&     if (image->label != (char *) NULL)G       text_size=MultilineCensus(image->label)*image_info->pointsize+12;n     x=0;     y=0;     width=image->columns;p     height=image->rows;      /*-       Center image on Portable Document page.f     */I     (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);      flags=NoValue;*     if (image_info->page != (char *) NULL)L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);%     if (image->page != (char *) NULL)mG       flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); *     if (((page_width-(x << 1)) < width) ||4         ((page_height-(y << 1)-text_size) < height))       {a         unsigned longb           scale_factor;   
         /*9           Scale image relative to Portable Document page. 
         */8         scale_factor=UpShift(page_width-(x << 1))/width;L         if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))F           scale_factor=UpShift(page_height-(y << 1)-text_size)/height;,         width=DownShift(width*scale_factor);.         height=DownShift(height*scale_factor);       }(     if ((flags & XValue) == 0)       { 
         /**           Center image in the X direction.
         */,         delta_x=page_width-(width+(x << 1));         if (delta_x >= 0)_           x=(delta_x >> 1)+x;e       }c     if ((flags & YValue) == 0)       {*
         /**           Center image in the X direction.
         */8         delta_y=page_height-(height+(y << 1))-text_size;         if (delta_y >= 0)r           y=(delta_y >> 1)+y;=       }      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;d     dy_resolution=72.0;d     x_resolution=72.0;-     (void) strcpy(density,PSDensityGeometry);s>     count=sscanf(density,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL)5L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)g        y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     /*       Write Page object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); 0     (void) fprintf(image->file,"/Type /Page\n");<     (void) fprintf(image->file,"/Parent %u 0 R\n",pages_id);2     (void) fprintf(image->file,"/Resources <<\n");H     (void) fprintf(image->file,"/Font << /F%u %u 0 R >>\n",image->scene,       object+4);L     (void) fprintf(image->file,"/XObject << /Im%u %u 0 R >>\n",image->scene,       object+5);@     (void) fprintf(image->file,"/ProcSet %u 0 R >>\n",object+3);;     (void) fprintf(image->file,"/MediaBox [ 0 0 %u %u ]\n",        page_width,page_height);>     (void) fprintf(image->file,"/Contents %u 0 R\n",object+1);"     if (!IsMonochromeImage(image))=       (void) fprintf(image->file,"/Thumb %u 0 R\n",object+8);r'     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"endobj\n");m     /*       Write Contents object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); <     (void) fprintf(image->file,"/Length %u 0 R\n",object+1);'     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"stream\n");      length=ftell(image->file);&     (void) fprintf(image->file,"q\n");&     labels=StringToList(image->label);!     if (labels != (char **) NULL)        { 2         for (i=0; labels[i] != (char *) NULL; i++)	         { -           (void) fprintf(image->file,"BT\n");cA           (void) fprintf(image->file,"/F%u %u Tf\n",image->scene, #             image_info->pointsize); =           (void) fprintf(image->file,"%d %u Td\n",x,y+height+ (             i*image_info->pointsize+12);<           (void) fprintf(image->file,"(%s) Tj\n",labels[i]);-           (void) fprintf(image->file,"ET\n");m           free(labels[i]);	         }e         free((char *) labels);       } H     (void) fprintf(image->file,"%u 0 0 %u %d %d cm\n",width,height,x,y);:     (void) fprintf(image->file,"/Im%u Do\n",image->scene);&     (void) fprintf(image->file,"Q\n");%     length=ftell(image->file)-length; .     (void) fprintf(image->file,"endstream\n");+     (void) fprintf(image->file,"endobj\n");      /*       Write Length object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);/     (void) fprintf(image->file,"%lu\n",length);s+     (void) fprintf(image->file,"endobj\n");      /*       Write Procset object.c     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);5     if (!IsPseudoClass(image) && !IsGrayImage(image)) 9       (void) fprintf(image->file,"[ /PDF /Text /ImageC");/     else#       if (IsMonochromeImage(image))s;         (void) fprintf(image->file,"[ /PDF /Text /ImageB");+
       else;         (void) fprintf(image->file,"[ /PDF /Text /ImageI"); '     (void) fprintf(image->file," ]\n");;+     (void) fprintf(image->file,"endobj\n");      /*       Write Font object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n");e0     (void) fprintf(image->file,"/Type /Font\n");4     (void) fprintf(image->file,"/Subtype /Type1\n");<     (void) fprintf(image->file,"/Name /F%u\n",image->scene);9     (void) fprintf(image->file,"/BaseFont /Helvetica\n");m@     (void) fprintf(image->file,"/Encoding /MacRomanEncoding\n");'     (void) fprintf(image->file,">>\n"); +     (void) fprintf(image->file,"endobj\n");      /*       Write XObject object.h     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);'     (void) fprintf(image->file,"<<\n"); 3     (void) fprintf(image->file,"/Type /XObject\n");s4     (void) fprintf(image->file,"/Subtype /Image\n");=     (void) fprintf(image->file,"/Name /Im%u\n",image->scene);l/     image->compression=image_info->compression;r,     if (image->compression == NoCompression)=       (void) fprintf(image->file,"/Filter /ASCII85Decode\n");      else$       if (!IsMonochromeImage(image))#         (void) fprintf(image->file,r5           "/Filter [ /ASCII85Decode /LZWDecode ]\n");;
       else	         {c%           (void) fprintf(image->file, <             "/Filter [ /ASCII85Decode /CCITTFaxDecode ]\n");%           (void) fprintf(image->file,dB             "/DecodeParms [ << >> << /Columns %d /Rows %d >> ]\n",(             image->columns,image->rows);	         }e=     (void) fprintf(image->file,"/Width %u\n",image->columns);o;     (void) fprintf(image->file,"/Height %u\n",image->rows);z@     (void) fprintf(image->file,"/ColorSpace %u 0 R\n",object+2);8     (void) fprintf(image->file,"/BitsPerComponent %d\n",(       IsMonochromeImage(image) ? 1 : 8);<     (void) fprintf(image->file,"/Length %u 0 R\n",object+1);'     (void) fprintf(image->file,">>\n");_+     (void) fprintf(image->file,"stream\n");t     length=ftell(image->file);     p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image)) !       switch (image->compression)l       {f)         case RunlengthEncodedCompression:m         default:	         {            /*!             Allocate pixel array.g           */6           number_packets=3*image->columns*image->rows;"           pixels=(unsigned char *)9             malloc(number_packets*sizeof(unsigned char)); /           if (pixels == (unsigned char *) NULL) =             PrematureExit("Unable to allocate memory",image);;           /**             Dump runlength encoded pixels.           */           q=pixels;l,           for (i=0; i < image->packets; i++)           {o2             for (j=0; j <= ((int) p->length); j++)
             {a<               if (image->matte && (p->index == Transparent))                 { )                   *q++=DownScale(MaxRGB);i)                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);u                 }                else                 {0)                   *q++=DownScale(p->red); +                   *q++=DownScale(p->green);l*                   *q++=DownScale(p->blue);                 } 
             }r             p++;%             if (QuantumTick(i,image))b>               ProgressMonitor(SaveImageText,i,image->packets);           }rC           (void) LZWEncodeImage(image->file,pixels,number_packets);;            free((char *) pixels);           break;	         }          case NoCompression: 	         {a           /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             { <               if (image->matte && (p->index == Transparent))                 { ?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file);                  }                else                 { ?                   Ascii85Encode(DownScale(p->red),image->file); A                   Ascii85Encode(DownScale(p->green),image->file);%@                   Ascii85Encode(DownScale(p->blue),image->file);                 }t
             }s             p++;%             if (QuantumTick(i,image))r>               ProgressMonitor(SaveImageText,i,image->packets);           }n$           Ascii85Flush(image->file);           break;	         }        }u     else#       if (IsMonochromeImage(image))a	         {e            register unsigned char             bit,             byte,a             polarity;t             polarity=aJ             Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;            x=0;%           switch (image->compression)f           {,-             case RunlengthEncodedCompression:t             default:
             {m:               (void) HuffmanEncodeImage(image_info,image);               break;
             }              case NoCompression:%
             {%               /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)                 {                    byte<<=1; +                   if (p->index == polarity)                      byte|=0x01;                    bit++;                   if (bit == 8)                      { 6                       Ascii85Encode(byte,image->file);                       bit=0;                       byte=0;                      }                    x++;*                   if (x == image->columns)                     {F                       /*5                         Advance to the next scanline.d                       */#                       if (bit != 0)mC                         Ascii85Encode(byte << (8-bit),image->file);                        bit=0;                       byte=0;s                       x=0;                       y++;                    }                 }                  p++;)                 if (QuantumTick(i,image)) B                   ProgressMonitor(SaveImageText,i,image->packets);               } (               Ascii85Flush(image->file);               break;
             }r           }c	         }n
       else	         {m           /*/             Dump number of colors and colormap.            */%           switch (image->compression)l           {i-             case RunlengthEncodedCompression:h             default:
             {a               /*%                 Allocate pixel array.l               */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char));E3               if (pixels == (unsigned char *) NULL) A                 PrematureExit("Unable to allocate memory",image);l               /*.                 Dump Runlength encoded pixels.               */               q=pixels;>0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)0                   *q++=(unsigned char) p->index;                 p++;)                 if (QuantumTick(i,image))aB                   ProgressMonitor(SaveImageText,i,image->packets);               } G               (void) LZWEncodeImage(image->file,pixels,number_packets); $               free((char *) pixels);               break;
             }              case NoCompression:r
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)F                   Ascii85Encode((unsigned char) p->index,image->file);                 p++;)                 if (QuantumTick(i,image))iB                   ProgressMonitor(SaveImageText,i,image->packets);               }d(               Ascii85Flush(image->file);               break;
             }u           }m	         } %     length=ftell(image->file)-length;,0     (void) fprintf(image->file,"\nendstream\n");+     (void) fprintf(image->file,"endobj\n");      /*       Write Length object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);/     (void) fprintf(image->file,"%lu\n",length); +     (void) fprintf(image->file,"endobj\n");-     /*       Write Colorspace object.     */&     xref[object++]=ftell(image->file);4     (void) fprintf(image->file,"%u 0 obj\n",object);5     if (!IsPseudoClass(image) && !IsGrayImage(image))>1       (void) fprintf(image->file,"/DeviceRGB\n");      else#       if (IsMonochromeImage(image))c4         (void) fprintf(image->file,"/DeviceGray\n");
       elseI         (void) fprintf(image->file,"[ /Indexed /DeviceRGB %u %u 0 R ]\n", $           image->colors-1,object+3);+     (void) fprintf(image->file,"endobj\n");l!     if (IsMonochromeImage(image))o       {          xref[object++]=0;          xref[object++]=0;M       }r     else       {a
         /*           Write Thumb object.M
         */         image->orphan=True; H         (void) ParseImageGeometry(DefaultThumbnailGeometry,&x,&y,&width,           &height); (         if (image->class == PseudoClass)5           tile_image=SampleImage(image,width,height);l         elseB           tile_image=ZoomImage(image,width,height,MitchellFilter);         image->orphan=False;)         if (tile_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image);;*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);+         (void) fprintf(image->file,"<<\n");l0         if (image->compression == NoCompression)A           (void) fprintf(image->file,"/Filter /ASCII85Decode\n");          else(           if (!IsMonochromeImage(image))'             (void) fprintf(image->file,09               "/Filter [ /ASCII85Decode /LZWDecode ]\n");M           else
             {e)               (void) fprintf(image->file,x@                 "/Filter [ /ASCII85Decode /CCITTFaxDecode ]\n");)               (void) fprintf(image->file, F                 "/DecodeParms [ << >> << /Columns %d /Rows %d >> ]\n",6                 tile_image->columns,tile_image->rows);
             }+F         (void) fprintf(image->file,"/Width %u\n",tile_image->columns);D         (void) fprintf(image->file,"/Height %u\n",tile_image->rows);D         (void) fprintf(image->file,"/ColorSpace %u 0 R\n",object-1);<         (void) fprintf(image->file,"/BitsPerComponent %d\n",,           IsMonochromeImage(image) ? 1 : 8);@         (void) fprintf(image->file,"/Length %u 0 R\n",object+1);+         (void) fprintf(image->file,">>\n");n/         (void) fprintf(image->file,"stream\n");-"         length=ftell(image->file);         p=tile_image->pixels;e9         if (!IsPseudoClass(image) && !IsGrayImage(image)) %           switch (image->compression))           { -             case RunlengthEncodedCompression:)             default:
             {G               /*%                 Allocate pixel array.                */D               number_packets=3*tile_image->columns*tile_image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL)a                 { +                   DestroyImage(tile_image);gC                   PrematureExit("Unable to allocate memory",image);l                 }                /*.                 Dump runlength encoded pixels.               */               q=pixels; 5               for (i=0; i < tile_image->packets; i++)                {i6                 for (j=0; j <= ((int) p->length); j++)                 {eE                   if (tile_image->matte && (p->index == Transparent))m                     { -                       *q++=DownScale(MaxRGB);t-                       *q++=DownScale(MaxRGB);--                       *q++=DownScale(MaxRGB);                      }G                   else                     { -                       *q++=DownScale(p->red);e/                       *q++=DownScale(p->green); .                       *q++=DownScale(p->blue);                     }a                 };                 p++;               } G               (void) LZWEncodeImage(image->file,pixels,number_packets); $               free((char *) pixels);               break;
             }f             case NoCompression:(
             {e               /*6                 Dump uncompressed DirectColor packets.               */"               Ascii85Initialize();5               for (i=0; i < tile_image->packets; i++),               {=6                 for (j=0; j <= ((int) p->length); j++)                 { E                   if (tile_image->matte && (p->index == Transparent))                      { C                       Ascii85Encode(DownScale(MaxRGB),image->file);lC                       Ascii85Encode(DownScale(MaxRGB),image->file); C                       Ascii85Encode(DownScale(MaxRGB),image->file);                      }                    else                     {lC                       Ascii85Encode(DownScale(p->red),image->file); E                       Ascii85Encode(DownScale(p->green),image->file); D                       Ascii85Encode(DownScale(p->blue),image->file);                     }                  }n                 p++;               } (               Ascii85Flush(image->file);               break;
             }            }          else'           if (IsMonochromeImage(image))0
             { $               register unsigned char                 bit,                 byte,                  polarity;l  ;               polarity=Intensity(tile_image->colormap[0]) < 3                 Intensity(tile_image->colormap[1]);w               bit=0;               byte=0;                x=0;)               switch (image->compression)                {l1                 case RunlengthEncodedCompression:                  default:                 {n                   /*)                     Allocate pixel array.                    */!                   number_packets= D                     ((tile_image->columns+7) >> 3)*tile_image->rows;*                   pixels=(unsigned char *)A                     malloc(number_packets*sizeof(unsigned char)); 7                   if (pixels == (unsigned char *) NULL)g                     {l/                       DestroyImage(tile_image); G                       PrematureExit("Unable to allocate memory",image);%                     }%                   /*2                     Dump Runlength encoded pixels.                   */                   q=pixels; 9                   for (i=0; i < tile_image->packets; i++)                    { :                     for (j=0; j <= ((int) p->length); j++)                     {                        byte<<=1; /                       if (p->index == polarity) #                         byte|=0x01;                        bit++;#                       if (bit == 8)                          { $                           *q++=byte;                            bit=0;!                           byte=0;%                         }%                       x++;3                       if (x == tile_image->columns)                          {e                           /*9                             Advance to the next scanline.t                           */'                           if (bit != 0)l1                             *q++=byte << (8-bit);e                            bit=0;!                           byte=0;                            x=0;                           y++;                        }                     }                      p++;                   }pK                   (void) LZWEncodeImage(image->file,pixels,number_packets);o(                   free((char *) pixels);                   break;                 } #                 case NoCompression:n                 {a                   /*:                     Dump uncompressed PseudoColor packets.                   */&                   Ascii85Initialize();9                   for (i=0; i < tile_image->packets; i++)a                   { :                     for (j=0; j <= ((int) p->length); j++)                     {;                       byte<<=1;l/                       if (p->index == polarity)d#                         byte|=0x01;a                       bit++;#                       if (bit == 8)                          { :                           Ascii85Encode(byte,image->file);                            bit=0;!                           byte=0;f                         }=                       x++;3                       if (x == tile_image->columns)a                         {%                           /*9                             Advance to the next scanline.                            */'                           if (bit != 0) G                             Ascii85Encode(byte << (8-bit),image->file);                             bit=0;!                           byte=0;                            x=0;                           y++;                        }                     }                      p++;                   } ,                   Ascii85Flush(image->file);                   break;                 }                } 
             }            else
             {                /*3                 Dump number of colors and colormap.%               */)               switch (image->compression)e               {e1                 case RunlengthEncodedCompression:                  default:                 {a                   /*)                     Allocate pixel array.I                   */F                   number_packets=tile_image->columns*tile_image->rows;*                   pixels=(unsigned char *)A                     malloc(number_packets*sizeof(unsigned char));r7                   if (pixels == (unsigned char *) NULL)                      {i/                       DestroyImage(tile_image); G                       PrematureExit("Unable to allocate memory",image);n                     }I                   /*2                     Dump Runlength encoded pixels.                   */                   q=pixels;e9                   for (i=0; i < tile_image->packets; i++)                    { :                     for (j=0; j <= ((int) p->length); j++)4                       *q++=(unsigned char) p->index;                     p++;                   }aK                   (void) LZWEncodeImage(image->file,pixels,number_packets);((                   free((char *) pixels);                   break;                 } #                 case NoCompression:                  {                    /*:                     Dump uncompressed PseudoColor packets.                   */&                   Ascii85Initialize();9                   for (i=0; i < tile_image->packets; i++)                    {r:                     for (j=0; j <= ((int) p->length); j++)J                       Ascii85Encode((unsigned char) p->index,image->file);                     p++;                   }f,                   Ascii85Flush(image->file);                   break;                 }x               } 
             }b!         DestroyImage(tile_image);a)         length=ftell(image->file)-length;04         (void) fprintf(image->file,"\nendstream\n");/         (void) fprintf(image->file,"endobj\n");f
         /*           Write Length object.
         */*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);3         (void) fprintf(image->file,"%lu\n",length);h/         (void) fprintf(image->file,"endobj\n");s       } B     if ((image->class == DirectClass) || IsMonochromeImage(image))       {          xref[object++]=0;-         xref[object++]=0;)       }w     else       {)
         /*            Write Colormap object.
         */*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);+         (void) fprintf(image->file,"<<\n");%@         (void) fprintf(image->file,"/Filter /ASCII85Decode \n");@         (void) fprintf(image->file,"/Length %u 0 R\n",object+1);+         (void) fprintf(image->file,">>\n"); /         (void) fprintf(image->file,"stream\n"); "         length=ftell(image->file);         Ascii85Initialize();)         for (i=0; i < image->colors; i++) 	         { G           Ascii85Encode(DownScale(image->colormap[i].red),image->file); I           Ascii85Encode(DownScale(image->colormap[i].green),image->file); H           Ascii85Encode(DownScale(image->colormap[i].blue),image->file);	         } "         Ascii85Flush(image->file);)         length=ftell(image->file)-length;%4         (void) fprintf(image->file,"\nendstream\n");/         (void) fprintf(image->file,"endobj\n");C
         /*           Write Length object.
         */*         xref[object++]=ftell(image->file);8         (void) fprintf(image->file,"%u 0 obj\n",object);3         (void) fprintf(image->file,"%lu\n",length);F/         (void) fprintf(image->file,"endobj\n");        } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    /*     Write Xref object.   */'   length=ftell(image->file)-xref[0]+10; '   (void) fprintf(image->file,"xref\n");m0   (void) fprintf(image->file,"0 %u\n",object+1);6   (void) fprintf(image->file,"0000000000 65535 f \n");   for (i=0; i < object; i++)<     (void) fprintf(image->file,"%010lu 00000 n \n",xref[i]);*   (void) fprintf(image->file,"trailer\n");%   (void) fprintf(image->file,"<<\n");d4   (void) fprintf(image->file,"/Size %u\n",object+1);7   (void) fprintf(image->file,"/Info %u 0 R\n",info_id); 7   (void) fprintf(image->file,"/Root %u 0 R\n",root_id);i%   (void) fprintf(image->file,">>\n");e,   (void) fprintf(image->file,"startxref\n");-   (void) fprintf(image->file,"%lu\n",length); *   (void) fprintf(image->file,"%%%%EOF\n");   free((char *) xref);   CloseImage(image);   if (image->temporary))     {(
       FILE         *file;  	       into
         c;         /*7         Copy temporary file to standard output or pipe.m       */1       file=fopen(image->filename,ReadBinaryType);m        if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);t       c=fgetc(file);       while (c != EOF)       {a)         (void) putc(c,encode_image.file);)         c=fgetc(file);       };       (void) fclose(file);%       (void) remove(image->filename);         CloseImage(&encode_image);     }    return(True);  }/   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %aO %                                                                             % O %                                                                             %>O %   W r i t e P I C T I m a g e                                               %,O %                                                                             %.O %                                                                             %>O %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WritePICTImage writes an image to a file in the Apple Macintoshs %  QuickDraw/PICT image format.  % / %  The format of the WritePICTImage routine is:l %a. %      status=WritePICTImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WritePICTImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image fileg %      fails to write. %gA %    o image_info: Specifies a pointer to an ImageInfo structure.t %t. %    o image:  A pointer to a Image structure. %r %  */L static unsigned int WritePICTImage(const ImageInfo *image_info,Image *image) {& #define MaxCount  128e #define PictCropRegionOp  0x01  #define PictEndOfPictureOp  0xff #define PictHeaderOp  0x0C00 #define PictHeaderSize  512m #define PictPixmapOp  0x9A #define PictPICTOp  0x98 #define PictVersion  0x11      typedef struct _PICTRectanglen   {d     unsigned short
       top,       left,a
       bottom,g       right;   } PICTRectangle;     typedef struct _PICTPixmap   {      unsigned short       base_address,r       row_bytes;       PICTRectangle 
       bounds;s       unsigned short       version,       pack_type;       unsigned longe       pack_size,       horizontal_resolution,       vertical_resolution;       unsigned short       pixel_type,a       pixel_size,        component_count,       component_size;a       unsigned short       plane_bytes,       table,       reserved;    } PICTPixmap;      int-
     count;     PICTPixmap     pixmap;-     PICTRectangle      crop_rectangle,      destination_rectangle,     frame_rectangle,     size_rectangle,x     source_rectangle;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned charr     *buffer,     *packed_scanline,n     *scanline;     unsigned int     bytes_per_line;r     unsigned short     transfer_mode;     unsigned long+     horizontal_resolution,     vertical_resolution;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate memory.   */    bytes_per_line=image->columns;"   if (image->class == DirectClass)     bytes_per_line*=3;H   buffer=(unsigned char *) malloc(PictHeaderSize*sizeof(unsigned char));#   packed_scanline=(unsigned char *) M     malloc((bytes_per_line+bytes_per_line/MaxCount+1)*sizeof(unsigned char)); J   scanline=(unsigned char *) malloc(bytes_per_line*sizeof(unsigned char));+   if ((buffer == (unsigned char *) NULL) || 4       (packed_scanline == (unsigned char *) NULL) ||+       (scanline == (unsigned char *) NULL)) 5     PrematureExit("Unable to allocate memory",image);t   /*     Initialize image info.   */   size_rectangle.top=0;_   size_rectangle.left=0;#   size_rectangle.right=image->rows; '   size_rectangle.bottom=image->columns;s!   frame_rectangle=size_rectangle;a    crop_rectangle=size_rectangle;"   source_rectangle=size_rectangle;'   destination_rectangle=size_rectangle;e#   horizontal_resolution=0x00480000;o!   vertical_resolution=0x00480000;a   pixmap.base_address=0xff;    pixmap.row_bytes=pD     ((image->class == DirectClass ? 4 : 1)*image->columns) | 0x8000;   pixmap.version=0;D   pixmap.bounds.top=0;   pixmap.bounds.left=0;D"   pixmap.bounds.right=image->rows;&   pixmap.bounds.bottom=image->columns;=   pixmap.pack_type=(image->class == DirectClass ? 0x4 : 0x0);    pixmap.pack_size=0;q5   pixmap.horizontal_resolution=horizontal_resolution;-1   pixmap.vertical_resolution=vertical_resolution;e;   pixmap.pixel_type=(image->class == DirectClass ? 16 : 0);l;   pixmap.pixel_size=(image->class == DirectClass ? 32 : 8); ?   pixmap.component_count=(image->class == DirectClass ? 3 : 1);i   pixmap.component_size=8;   pixmap.plane_bytes=0;    pixmap.table=0;    pixmap.reserved=0;9   transfer_mode=(image->class == DirectClass ? 0x40 : 0);u   /*H     Write header, header size, size bounding box, version, and reserved.   */$   for (i=0; i < PictHeaderSize; i++)     buffer[i]=0;>   (void) fwrite((char *) buffer,1,PictHeaderSize,image->file);$   MSBFirstWriteShort(0,image->file);5   MSBFirstWriteShort(size_rectangle.top,image->file); 6   MSBFirstWriteShort(size_rectangle.left,image->file);7   MSBFirstWriteShort(size_rectangle.right,image->file);g8   MSBFirstWriteShort(size_rectangle.bottom,image->file);.   MSBFirstWriteShort(PictVersion,image->file);)   MSBFirstWriteShort(0x02ff,image->file);n/   MSBFirstWriteShort(PictHeaderOp,image->file);)   /*N     Write full size of the file, resolution, frame bounding box, and reserved.   */,   MSBFirstWriteLong(0xfffe0000,image->file);7   MSBFirstWriteLong(horizontal_resolution,image->file);g5   MSBFirstWriteLong(vertical_resolution,image->file); 6   MSBFirstWriteShort(frame_rectangle.top,image->file);7   MSBFirstWriteShort(frame_rectangle.left,image->file);*8   MSBFirstWriteShort(frame_rectangle.right,image->file);9   MSBFirstWriteShort(frame_rectangle.bottom,image->file);v$   MSBFirstWriteLong(0L,image->file);   /*3     Write crop region opcode and crop bounding box.    */3   MSBFirstWriteShort(PictCropRegionOp,image->file); &   MSBFirstWriteShort(0xa,image->file);5   MSBFirstWriteShort(crop_rectangle.top,image->file); 6   MSBFirstWriteShort(crop_rectangle.left,image->file);7   MSBFirstWriteShort(crop_rectangle.right,image->file); 8   MSBFirstWriteShort(crop_rectangle.bottom,image->file);   /*K     Write picture opcode, row bytes, and picture bounding box, and version.    */"   if (image->class == PseudoClass)/     MSBFirstWriteShort(PictPICTOp,image->file);    else     {23       MSBFirstWriteShort(PictPixmapOp,image->file);-I       MSBFirstWriteLong((unsigned long) pixmap.base_address,image->file);f     }N<   MSBFirstWriteShort(pixmap.row_bytes | 0x8000,image->file);4   MSBFirstWriteShort(pixmap.bounds.top,image->file);5   MSBFirstWriteShort(pixmap.bounds.left,image->file);s6   MSBFirstWriteShort(pixmap.bounds.right,image->file);7   MSBFirstWriteShort(pixmap.bounds.bottom,image->file);>1   MSBFirstWriteShort(pixmap.version,image->file);    /*G     Write pack type, pack size, resolution, pixel type, and pixel size.)   */3   MSBFirstWriteShort(pixmap.pack_type,image->file); 2   MSBFirstWriteLong(pixmap.pack_size,image->file);>   MSBFirstWriteLong(pixmap.horizontal_resolution,image->file);<   MSBFirstWriteLong(pixmap.vertical_resolution,image->file);4   MSBFirstWriteShort(pixmap.pixel_type,image->file);4   MSBFirstWriteShort(pixmap.pixel_size,image->file);   /*G     Write component count, size, plane bytes, table size, and reserved.r   */9   MSBFirstWriteShort(pixmap.component_count,image->file); 8   MSBFirstWriteShort(pixmap.component_size,image->file);D   MSBFirstWriteLong((unsigned long) pixmap.plane_bytes,image->file);>   MSBFirstWriteLong((unsigned long) pixmap.table,image->file);A   MSBFirstWriteLong((unsigned long) pixmap.reserved,image->file); "   if (image->class == PseudoClass)     {u       unsigned short         red,         green,
         blue;          /*         Write image colormap.r       */:       MSBFirstWriteLong(0L,image->file);  /* color seed */<       MSBFirstWriteShort(0L,image->file);  /* color flags */I       MSBFirstWriteShort((unsigned short) (image->colors-1),image->file); '       for (i=0; i < image->colors; i++)        { B         red=(unsigned int) (image->colormap[i].red*65535L)/MaxRGB;F         green=(unsigned int) (image->colormap[i].green*65535L)/MaxRGB;D         blue=(unsigned int) (image->colormap[i].blue*65535L)/MaxRGB;9         MSBFirstWriteShort((unsigned int) i,image->file); ,         MSBFirstWriteShort(red,image->file);.         MSBFirstWriteShort(green,image->file);-         MSBFirstWriteShort(blue,image->file);        }g     }l   /*+     Write source and destination rectangle.o   */7   MSBFirstWriteShort(source_rectangle.top,image->file);_8   MSBFirstWriteShort(source_rectangle.left,image->file);9   MSBFirstWriteShort(source_rectangle.right,image->file); :   MSBFirstWriteShort(source_rectangle.bottom,image->file);<   MSBFirstWriteShort(destination_rectangle.top,image->file);=   MSBFirstWriteShort(destination_rectangle.left,image->file); >   MSBFirstWriteShort(destination_rectangle.right,image->file);?   MSBFirstWriteShort(destination_rectangle.bottom,image->file);,0   MSBFirstWriteShort(transfer_mode,image->file);   /*     Write picture data.r   */
   count=0;   x=0;   p=image->pixels;"   if (image->class == PseudoClass)     {t       register unsigned char         *index;>         index=scanline;x(       for (i=0; i < image->packets; i++)       {-.         for (j=0; j <= ((int) p->length); j++)	         { ,           *index++=(unsigned char) p->index;           x++;"           if (x == image->columns)
             { E               count+=PICTEncodeImage(image,scanline,packed_scanline);%               index=scanline;%               x=0;
             } 	         }          p++;!         if (QuantumTick(i,image)) :           ProgressMonitor(SaveImageText,i,image->packets);       }      }    else     {        register unsigned char         *blue,
         *red,          *green;          red=scanline; $       green=scanline+image->columns;*       blue=scanline+(image->columns << 1);(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         { #           *red++=DownScale(p->red); '           *green++=DownScale(p->green); %           *blue++=DownScale(p->blue);%           x++;"           if (x == image->columns)
             {%               red=scanline;A,               green=scanline+image->columns;2               blue=scanline+(image->columns << 1);@               count+=PICTEncodeImage(image,red,packed_scanline);               x=0;
             } 	         }t         p++;!         if (QuantumTick(i,image))A:           ProgressMonitor(SaveImageText,i,image->packets);       }u     }    if (count & 0x1)#     (void) fputc('\0',image->file);f5   MSBFirstWriteShort(PictEndOfPictureOp,image->file);t   free((char *) scanline);!   free((char *) packed_scanline);    free((char *) buffer);   CloseImage(image);   return(True);N }g o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %(O %                                                                             %%O %                                                                             % O %   W r i t e P L A S M A I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePLASMAImage writes an image in the plasma image format. % 1 %  The format of the WritePLASMAImage routine is:  %%0 %      status=WritePLASMAImage(image_info,image) %%+ %  A description of each parameter follows.G %IM %    o status: Function WritePLASMAImage return True if the image is written.fK %      False is returned is there is a memory shortage or if the image filea %      fails to write. %sA %    o image_info: Specifies a pointer to an ImageInfo structure.r %G. %    o image:  A pointer to a Image structure. %  %F */A static unsigned int WritePLASMAImage(const ImageInfo *image_info,    Image *image)t {    unsigned int     status;i  8   Warning("Cannot write PLASMA images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);n }r G
 #ifdef HasPNGI /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%RO %                                                                             %(O %                                                                             %mO %                                                                             %sO %   W r i t e P N G I m a g e                                                 %xO %                                                                             % O %                                                                             %(O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %mJ %  Function WritePNGImage writes an image in the Portable Network Graphics %  encoded image format. %). %  The format of the WritePNGImage routine is: %%- %      status=WritePNGImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePNGImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  > static void PNGError(png_struct *ping,png_const_charp message) { !   Warning(message,(char *) NULL);    longjmp(ping->jmpbuf,1); }   @ static void PNGWarning(png_struct *ping,png_const_charp message) {%!   Warning(message,(char *) NULL);% }%  K static unsigned int WritePNGImage(const ImageInfo *image_info,Image *image)g {n' #define PNGTextChunk(i,keyword,value) \r { \ #   ping_info->text[i].key=keyword; \e"   ping_info->text[i].text=value; \1   ping_info->text[i].text_length=Extent(value); \oA   ping_info->text[i].compression=Extent(value) > 1024 ? 0 : -1; \g   i++; \ }      register int     i,     j;     register RunlengthPacket     *p;h     register unsigned char     *q;f  
   png_info     *ping_info;e     png_struct
     *ping;     unsigned charc     *png_pixels,     **scanlines;     unsigned int     x,     y;     unsigned short
     value;     /*     Open image file.   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Allocate the PNG structures    */L   ping=png_create_write_struct(PNG_LIBPNG_VER_STRING,(void *) NULL,PNGError,     PNGWarning);"   if (ping == (png_struct *) NULL)5     PrematureExit("Unable to allocate memory",image);m)   ping_info=png_create_info_struct(ping);a%   if (ping_info == (png_info *) NULL)      {E9       png_destroy_write_struct(&ping,(png_info **) NULL); 7       PrematureExit("Unable to allocate memory",image);      }t$   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))t    {       /*         PNG write failed.        */1       png_destroy_write_struct(&ping,&ping_info);s/       if (scanlines != (unsigned char **) NULL)h!         free((char *) scanlines);U/       if (png_pixels != (unsigned char *) NULL)p"         free((char *) png_pixels);       CloseImage(image);       return(False);     }    /*     Prepare PNG for writing.   */    png_init_io(ping,image->file);5   png_set_compression_level(ping,Z_BEST_COMPRESSION); "   ping_info->width=image->columns;    ping_info->height=image->rows;$   ping_info->bit_depth=image->depth;+   ping_info->color_type=PNG_COLOR_TYPE_RGB;/"   ping_info->valid|=PNG_INFO_pHYs;3   ping_info->phys_unit_type=PNG_RESOLUTION_UNKNOWN; B   ping_info->x_pixels_per_unit= (png_uint_32) image->x_resolution;A   ping_info->y_pixels_per_unit=(png_uint_32) image->y_resolution; .   if (image->units == PixelsPerInchResolution)     {D5       ping_info->phys_unit_type=PNG_RESOLUTION_METER;;0       ping_info->x_pixels_per_unit=(png_uint_32))         (100.0*image->x_resolution/2.54);m0       ping_info->y_pixels_per_unit=(png_uint_32))         (100.0*image->y_resolution/2.54);e     } 4   if (image->units == PixelsPerCentimeterResolution)     { 5       ping_info->phys_unit_type=PNG_RESOLUTION_METER;iM       ping_info->x_pixels_per_unit=(png_uint_32) (100.0*image->x_resolution);cM       ping_info->y_pixels_per_unit=(png_uint_32) (100.0*image->y_resolution);L     } "   ping_info->valid|=PNG_INFO_bKGD;C   ping_info->background.red=DownScale(image->background_color.red);uG   ping_info->background.green=DownScale(image->background_color.green); E   ping_info->background.blue=DownScale(image->background_color.blue); K   ping_info->background.gray=DownScale(Intensity(image->background_color)); 9   ping_info->background.index=ping_info->background.gray;    if (image->matte)a     {r       /*A         Determine if there is one and only one transparent color.+       */6       ping_info->color_type=PNG_COLOR_TYPE_GRAY_ALPHA;       p=image->pixels;F       for (i=0; (p->index == Opaque) && (i < (image->packets-1)); i++)       {          if (!IsGray(*p))9           ping_info->color_type=PNG_COLOR_TYPE_RGB_ALPHA;          p++;       }        if (p->index != Opaque):(         ping_info->valid|=PNG_INFO_tRNS;)       ping_info->trans_values.red=p->red;n-       ping_info->trans_values.green=p->green; +       ping_info->trans_values.blue=p->blue;E1       ping_info->trans_values.gray=Intensity(*p); 8       ping_info->trans_values.index=DownScale(p->index);&       for ( ; i < image->packets; i++)       {)         if (!IsGray(*p))9           ping_info->color_type=PNG_COLOR_TYPE_RGB_ALPHA;,6         if (p->index != ping_info->trans_values.index)7           if (ColorMatch(ping_info->trans_values,*p,0)) /             ping_info->valid&=(~PNG_INFO_tRNS);          p++;       }p+       if (ping_info->valid & PNG_INFO_tRNS) 	         {            image->matte=False;,3           ping_info->color_type=PNG_COLOR_TYPE_RGB; 	         }      }-   if (IsGrayImage(image)) .     ping_info->color_type=PNG_COLOR_TYPE_GRAY;   else     if (IsPseudoClass(image))e       {;
         /*           Set image palette.
         */5         ping_info->color_type=PNG_COLOR_TYPE_PALETTE;;-         ping_info->num_palette=image->colors;=(         ping_info->valid|=PNG_INFO_PLTE;(         ping_info->palette=(png_color *)2           malloc(image->colors*sizeof(png_color));5         if (ping_info->palette == (png_color *) NULL)x;           PrematureExit("Unable to allocate memory",image);e)         for (i=0; i < image->colors; i++) 	         { F           ping_info->palette[i].red=DownScale(image->colormap[i].red);J           ping_info->palette[i].green=DownScale(image->colormap[i].green);H           ping_info->palette[i].blue=DownScale(image->colormap[i].blue);	         })         ping_info->bit_depth=1;a;         while ((1 << ping_info->bit_depth) < image->colors),#           ping_info->bit_depth<<=1;o-         if (ping_info->valid & PNG_INFO_tRNS)            {e             /*;               Identify which colormap entry is transparent.              */.             ping_info->trans=(unsigned char *):               malloc(image->colors*sizeof(unsigned char));;             if (ping_info->trans == (unsigned char *) NULL)y?               PrematureExit("Unable to allocate memory",image); -             for (i=0; i < image->colors; i++) 
             {a4               ping_info->trans[i]=DownScale(Opaque);K               if (ColorMatch(ping_info->trans_values,image->colormap[i],0))p                 { D                   ping_info->trans[i]=ping_info->trans_values.index;                   break;                 } 
             }o%             ping_info->num_trans=i+1;            } 
         /*@           Identify which colormap entry is the background color.
         */-         for (i=0; i < (image->colors-1); i++)gE           if (ColorMatch(ping_info->background,image->colormap[i],0))              break;&         ping_info->background.index=i;       }s   if (image->gamma != 0.0)     {E       /*         Note image gamma.        */&       ping_info->valid|=PNG_INFO_gAMA;$       ping_info->gamma=image->gamma;     }oC   ping_info->interlace_type=image_info->interlace != NoneInterlace;f!   png_write_info(ping,ping_info);    png_set_packing(ping);   /*     Allocate memory.   */%   ping_info->rowbytes=image->columns;(   if (!IsPseudoClass(image))D     ping_info->rowbytes*=(image->matte ? 4 : 3)*(image->depth >> 3);   png_pixels=(unsigned char *)<     malloc(ping_info->rowbytes*image->rows*sizeof(Quantum));K   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *)); /   if ((png_pixels == (unsigned char *) NULL) ||g-       (scanlines == (unsigned char **) NULL))m5     PrematureExit("Unable to allocate memory",image);    /*     Initialize image scanlines.n   */!   for (i=0; i < image->rows; i++)g4     scanlines[i]=png_pixels+(ping_info->rowbytes*i);   x=0;   y=0;   p=image->pixels;   q=scanlines[y];n   if (IsGrayImage(image))a&     for (i=0; i < image->packets; i++)     {(,       for (j=0; j <= ((int) p->length); j++)       { &         WriteQuantum(Intensity(*p),q);         x++;          if (x == image->columns)           {              x=0;             y++;             q=scanlines[y];            }        } 
       p++;       if (QuantumTick(i,image)) 8         ProgressMonitor(SaveImageText,i,image->packets);     }    else     if (!IsPseudoClass(image))(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         { !           WriteQuantum(p->red,q); A           if (ping_info->color_type != PNG_COLOR_TYPE_GRAY_ALPHA) 
             { '               WriteQuantum(p->green,q); &               WriteQuantum(p->blue,q);
             }%           if (image->matte)%%             WriteQuantum(p->index,q);            x++;"           if (x == image->columns)
             {O               x=0;               y++;               q=scanlines[y];u
             }.	         }i         p++;!         if (QuantumTick(i,image))d:           ProgressMonitor(SaveImageText,i,image->packets);       }      else(       for (i=0; i < image->packets; i++)       {a.         for (j=0; j <= ((int) p->length); j++)	         {            *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y++;               q=scanlines[y];e
             }T	         }f         p++;!         if (QuantumTick(i,image))s:           ProgressMonitor(SaveImageText,i,image->packets);       } "   png_write_image(ping,scanlines);   /*     Generate text chunks.m   */   ping_info->num_text=0;<   ping_info->text=(png_text *) malloc(256*sizeof(png_text));+   if (ping_info->text == (png_text *) NULL)t5     PrematureExit("Unable to allocate memory",image);a7   PNGTextChunk(ping_info->num_text,"Software",Version);g   SignatureImage(image);(   if (image->signature != (char *) NULL)C     PNGTextChunk(ping_info->num_text,"Signature",image->signature);n   if (image->scene != 0)     {i
       char         scene[MaxTextExtent];l  .       (void) sprintf(scene,"%u",image->scene);6       PNGTextChunk(ping_info->num_text,"Scene",scene);     }    if (image->delay != 0)     {e
       char         delay[MaxTextExtent];   .       (void) sprintf(delay,"%u",image->delay);6       PNGTextChunk(ping_info->num_text,"Delay",delay);     }h$   if (image->label != (char *) NULL);     PNGTextChunk(ping_info->num_text,"Label",image->label);w&   if (image->montage != (char *) NULL)?     PNGTextChunk(ping_info->num_text,"Montage",image->montage);t(   if (image->directory != (char *) NULL)C     PNGTextChunk(ping_info->num_text,"Directory",image->directory);,'   if (image->comments != (char *) NULL)s@     PNGTextChunk(ping_info->num_text,"Comment",image->comments);    png_write_end(ping,ping_info);   /*     Free memory.   */-   png_destroy_write_struct(&ping,&ping_info);a   CloseImage(image);   return(True);t }a #else-K static unsigned int WritePNGImage(const ImageInfo *image_info,Image *image)o {n   unsigned int     status;h  :   Warning("PNG library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);L }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             %eO %                                                                             % O %   W r i t e P N M I m a g e                                                 %hO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_ %gJ %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. %]. %  The format of the WritePNMImage routine is: %e- %      status=WritePNMImage(image_info,image)  % + %  A description of each parameter follows.i %gJ %    o status: Function WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filet %      fails to write. %lA %    o image_info: Specifies a pointer to an ImageInfo structure.x %;. %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WritePNMImage(const ImageInfo *image_info,Image *image)e {o #define MaxRawValue  255     register int     i,     j;     register RunlengthPacket     *p;;     unsigned char      format;g     unsigned int     x;     /*     Open output image file.r   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);=   do   {m     /*/       Promote/Demote image based on image type.m     */.     if (strcmp(image_info->magick,"PPM") == 0)       image->class=DirectClass;      else0       if (strcmp(image_info->magick,"PGM") == 0)0         RGBTransformImage(image,GRAYColorspace);
       else2         if (strcmp(image_info->magick,"PBM") == 0)(           if (!IsMonochromeImage(image))
             {p               QuantizeInfo                 quantize_info;  .               GetQuantizeInfo(&quantize_info);,               quantize_info.number_colors=2;6               quantize_info.dither=image_info->dither;6               quantize_info.colorspace=GRAYColorspace;2               QuantizeImage(&quantize_info,image);               SyncImage(image);o
             }o     /*       Write PNM file header.     *//     image->compression=image_info->compression;s5     if (!IsPseudoClass(image) && !IsGrayImage(image))r       {;
         /*           Full color PNM image.s
         */         format='6';%L         if ((image->compression == NoCompression) || (MaxRGB > MaxRawValue))           format='3';        }      else       { 
         /*            Colormapped PNM image.
         */         format='6'; L         if ((image->compression == NoCompression) || (MaxRGB > MaxRawValue))           format='3'; J         if ((strcmp(image_info->magick,"PPM") != 0) && IsGrayImage(image))           {              /*"               Grayscale PNM image.             */             format='5'; P             if ((image->compression == NoCompression) || (MaxRGB > MaxRawValue))               format='2'; 6             if (strcmp(image_info->magick,"PGM") != 0)%               if (image->colors == 2)%                 {                    format='4';e:                   if (image->compression == NoCompression)                     format='1';o                 }            }t       }e/     (void) fprintf(image->file,"P%c\n",format);p)     if (image->comments != (char *) NULL)t       {H         register char 
           *p;i  
         /*!           Write comments to file.m
         */)         (void) fprintf(image->file,"# ");t0         for (p=image->comments; *p != '\0'; p++)	         {o'           (void) fputc(*p,image->file);r           if (*p == '\n') -             (void) fprintf(image->file,"# ");t	         }*'         (void) fputc('\n',image->file);        }ME     (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);      /*5       Convert runlength encoded to PNM raster pixels.i     */     x=0;     p=image->pixels;     switch (format)0     {f       case '1':n       {k         register unsigned char           polarity;T  
         /*'           Convert image to a PBM image.e
         */         polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);*         for (i=0; i < image->packets; i++)	         {+0           for (j=0; j <= ((int) p->length); j++)           {iC             (void) fprintf(image->file,"%d ",p->index == polarity);)             x++;             if (x == 36)               { 1                 (void) fprintf(image->file,"\n");p                 x=0;               }i           }(           p++;#           if (QuantumTick(i,image))B<             ProgressMonitor(SaveImageText,i,image->packets);	         }a         break;       }        case '2':        {=
         /*'           Convert image to a PGM image. 
         */2         (void) fprintf(image->file,"%d\n",MaxRGB);*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { 5             (void) fprintf(image->file,"%d ",p->red);(             x++;             if (x == 12)               { 1                 (void) fprintf(image->file,"\n");                  x=0;               }i           }f           p++;#           if (QuantumTick(i,image))m<             ProgressMonitor(SaveImageText,i,image->packets);	         }o         break;       }v       case '3':e       {h
         /*'           Convert image to a PNM image.%
         */2         (void) fprintf(image->file,"%d\n",MaxRGB);*         for (i=0; i < image->packets; i++)	         {>0           for (j=0; j <= ((int) p->length); j++)           { L             (void) fprintf(image->file,"%d %d %d ",p->red,p->green,p->blue);             x++;             if (x == 4)i               {e1                 (void) fprintf(image->file,"\n");i                 x=0;               }i           }p           p++;#           if (QuantumTick(i,image)),<             ProgressMonitor(SaveImageText,i,image->packets);	         }g         break;       }        case '4':        {t         register unsigned char           bit,           byte,m           polarity;L  
         /*'           Convert image to a PBM image.&
         */         polarity=0;          if (image->colors == 2)            polarity=iJ             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);         bit=0;         byte=0;f         x=0;*         for (i=0; i < image->packets; i++)	         {i0           for (j=0; j <= ((int) p->length); j++)           {n             byte<<=1; %             if (p->index == polarity)t               byte|=0x01;              bit++;             if (bit == 8)c               { /                 (void) fputc(byte,image->file);v                 bit=0;                 byte=0;d               }              x++;$             if (x == image->columns)               {+                 /*/                   Advance to the next scanline.f                 */                 if (bit != 0) <                   (void) fputc(byte << (8-bit),image->file);                 bit=0;                 byte=0;                  x=0;              }           }a           p++;#           if (QuantumTick(i,image))c<             ProgressMonitor(SaveImageText,i,image->packets);	         }]         break;       }        case '5':e       {n
         /*'           Convert image to a PGM image.f
         */=         (void) fprintf(image->file,"%u\n",DownScale(MaxRGB)); *         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)8             (void) fputc(DownScale(p->red),image->file);           p++;#           if (QuantumTick(i,image)))<             ProgressMonitor(SaveImageText,i,image->packets);	         }/         break;       }f       case '6':e       {\
         /*'           Convert image to a PNM image.e
         */=         (void) fprintf(image->file,"%u\n",DownScale(MaxRGB)); *         for (i=0; i < image->packets; i++)	         {i0           for (j=0; j <= ((int) p->length); j++)           {a8             (void) fputc(DownScale(p->red),image->file);:             (void) fputc(DownScale(p->green),image->file);9             (void) fputc(DownScale(p->blue),image->file);-           }e           p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }s         break;       }l     }-&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);  }p m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %oO %                                                                             %iO %                                                                             %mO %   W r i t e P R E V I E W I m a g e                                         %iO %                                                                             %"O %                                                                             %fO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %pG %  Function WritePREVIEWImage creates several tiles each with a varying O %  stength of an image enhancement function (e.g. gamma).  The image is written  %  in the MIFF format. %,2 %  The format of the WritePREVIEWImage routine is: % 1 %      status=WritePREVIEWImage(image_info,image)% %"+ %  A description of each parameter follows.  %iN %    o status: Function WritePREVIEWImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image fileI %      fails to write. %pA %    o image_info: Specifies a pointer to an ImageInfo structure.s %G. %    o image:  A pointer to a Image structure. %% %% */B static unsigned int WritePREVIEWImage(const ImageInfo *image_info,   Image *image)  {  #define NumberTiles  99 #define PreviewImageText  "  Creating image preview...  "      char     *commands[NumberTiles+6],      factor[MaxTextExtent],     label[MaxTextExtent],      *resource_value;  	   Display 
     *display;      float      degrees,
     gamma,     percentage,      threshold;     Image      *images[NumberTiles],      *montage_image,      *preview_image;      ImageInfo      local_info;      int 	     argc,      x,     y;     MonitorHandler     handler;     register int     i;     unsigned int     colors,%     height,%     status,%
     width;     XMontageInfo     montage_info;      XResourceInfoG     resource_info;  
   XrmDatabaser     resource_database;     /*!     Scale the image to tile size.I   */   image->orphan=True;    width=image->columns;r   height=image->rows; I   (void) ParseImageGeometry(DefaultPreviewGeometry,&x,&y,&width,&height); "   if (image->class == PseudoClass)2     preview_image=SampleImage(image,width,height);   else?     preview_image=ZoomImage(image,width,height,MitchellFilter);s   image->orphan=False;&   if (preview_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);a-   LabelImage(preview_image,DefaultTileLabel);r   /*+     Apply enhancement at varying strengths.    */   local_info=(*image_info);e   degrees=0;   gamma=(-0.1);a   colors=2;    x=0;   y=0;   percentage=0.0;i   threshold=0.0;   commands[0]=client_name;!   for (i=0; i < NumberTiles; i++)s   {      images[i]=O       CopyImage(preview_image,preview_image->columns,preview_image->rows,True);l$     if (images[i] == (Image *) NULL)       {          for (x=0;  x < i; x++)"           DestroyImage(images[x]);9         PrematureExit("Unable to allocate memory",image);n       }W     argc=1;e      if (i == (NumberTiles >> 1))       { '         commands[argc++]="-mattecolor";g-         commands[argc++]=DefaultPreviewMatte;d;         MogrifyImage(&local_info,argc,commands,&images[i]);a         continue;e       }n5     handler=SetMonitorHandler((MonitorHandler) NULL);;%     switch (image_info->preview_type)U     {        case RotatePreview:o       { 4         (void) sprintf(factor,"%.1f",degrees+=45.0);1         (void) sprintf(label,"rotate %s",factor);r#         commands[argc++]="-rotate";u          commands[argc++]=factor;!         commands[argc++]="-crop";t         commands[argc++]="0x0";.         break;       }        case ShearPreview:       {t         degrees+=10.0;?         (void) sprintf(factor,"%.1fx%.1f",degrees,2.0*degrees);n0         (void) sprintf(label,"shear %s",factor);"         commands[argc++]="-shear";          commands[argc++]=factor;!         commands[argc++]="-crop";i         commands[argc++]="0x0";          break;       }        case RollPreview:=       { .         x+=preview_image->columns/NumberTiles;+         y+=preview_image->rows/NumberTiles; ,         (void) sprintf(factor,"%+d%+d",x,y);/         (void) sprintf(label,"roll %s",factor); !         commands[argc++]="-roll";           commands[argc++]=factor;         break;       }        case HuePreview:       { ;         (void) sprintf(factor,"0,0,%.1f",percentage+=12.5); 3         (void) sprintf(label,"modulate %s",factor);i%         commands[argc++]="-modulate";i          commands[argc++]=factor;         break;       }        case SaturationPreview:        { 9         (void) sprintf(factor,"0,%.1f",percentage+=12.5);c3         (void) sprintf(label,"modulate %s",factor);,%         commands[argc++]="-modulate";           commands[argc++]=factor;         break;       }&       case BrightnessPreview:>       {i7         (void) sprintf(factor,"%.1f",percentage+=12.5);B3         (void) sprintf(label,"modulate %s",factor);0%         commands[argc++]="-modulate";X          commands[argc++]=factor;         break;       },       case GammaPreview:       default:       {g1         (void) sprintf(factor,"%.1f",gamma+=0.4);i0         (void) sprintf(label,"gamma %s",factor);"         commands[argc++]="-gamma";          commands[argc++]=factor;         break;       }b       case SpiffPreview:       {          for (x=0; x < i; x++)N'           commands[argc++]="-contrast"; 0         (void) sprintf(label,"-contast %d",i+1);         break;       }r       case DullPreview:e       {          for (x=0; x < i; x++)='           commands[argc++]="+contrast";-0         (void) sprintf(label,"+contast %d",i+1);         break;       }j       case GrayscalePreview:       {T+         (void) sprintf(factor,"%u",colors);J         colors<<=1;n1         (void) sprintf(label,"colors %s",factor); '         commands[argc++]="-colorspace";n          commands[argc++]="gray";#         commands[argc++]="-colors";a          commands[argc++]=factor;         break;       }t       case QuantizePreview:        {%/         (void) sprintf(factor,"%u",colors<<=1);%1         (void) sprintf(label,"colors %s",factor); #         commands[argc++]="-colors";           commands[argc++]=factor;         break;       }        case DespecklePreview:       {          for (x=0; x < i; x++) (           commands[argc++]="-despeckle";1         (void) sprintf(label,"despeckle %d",i+1);          break;       }        case ReduceNoisePreview:       {          for (x=0; x < i; x++) $           commands[argc++]="-noise";-         (void) sprintf(label,"noise %d",i+1);          break;       }        case AddNoisePreview:        {          switch (x)	         {%9           case 0: (void) strcpy(factor,"uniform"); break;%:           case 1: (void) strcpy(factor,"gaussian"); break;@           case 2: (void) strcpy(factor,"multiplicative"); break;9           case 3: (void) strcpy(factor,"impulse"); break;t;           case 4: (void) strcpy(factor,"laplacian"); break;t9           case 5: (void) strcpy(factor,"poisson"); break;)B           default: (void) strcpy(images[i]->magick,"NULL"); break;	         }n         x++;1         (void) sprintf(label,"+noise %s",factor);e"         commands[argc++]="+noise";          commands[argc++]=factor;         break;       }r       case SharpenPreview:       {e7         (void) sprintf(factor,"%.1f",percentage+=12.5);j2         (void) sprintf(label,"sharpen %s",factor);$         commands[argc++]="-sharpen";          commands[argc++]=factor;         break;       }L       case BlurPreview:j       {_7         (void) sprintf(factor,"%.1f",percentage+=12.5); 3         (void) sprintf(label,"+sharpen %s",factor); $         commands[argc++]="+sharpen";          commands[argc++]=factor;         break;       }        case ThresholdPreview:       {>H         (void) sprintf(factor,"%d",(int) ((percentage*(MaxRGB+1))/100));4         (void) sprintf(label,"threshold %s",factor);&         commands[argc++]="-threshold";          commands[argc++]=factor;         percentage+=12.5;a         break;       }        case EdgeDetectPreview:R       {c7         (void) sprintf(factor,"%.1f",percentage+=12.5); /         (void) sprintf(label,"edge %s",factor);h!         commands[argc++]="-edge";o          commands[argc++]=factor;         break;       }        case SpreadPreview:n       { (         (void) sprintf(factor,"%d",i+1);1         (void) sprintf(label,"spread %s",factor);;#         commands[argc++]="-spread";           commands[argc++]=factor;         break;       }        case SolarizePreview:        { 7         (void) sprintf(factor,"%.1f",percentage+=12.5);r3         (void) sprintf(label,"solarize %s",factor);&%         commands[argc++]="-solarize";n          commands[argc++]=factor;         break;       }        case ShadePreview:       {s         if (i == 0)_           { *             (void) strcpy(label,"+shade");&             commands[argc++]="+shade";             break;           }          degrees+=10.0;;         (void) sprintf(factor,"%.1fx%.1f",degrees,degrees); 0         (void) sprintf(label,"shade %s",factor);"         commands[argc++]="-shade";          commands[argc++]=factor;         break;       }-       case RaisePreview:       { (         (void) sprintf(factor,"%d",i+1);0         (void) sprintf(label,"raise %s",factor);"         commands[argc++]="-raise";          commands[argc++]=factor;         break;       }]       case SegmentPreview:       {p9         (void) sprintf(factor,"1.5x%.1f",threshold+=0.4);i2         (void) sprintf(label,"segment %s",factor);#         commands[argc++]="-colors";           commands[argc++]=factor;         break;       }o       case SwirlPreview:       { 4         (void) sprintf(factor,"%.1f",degrees+=45.0);0         (void) sprintf(label,"swirl %s",factor);"         commands[argc++]="-swirl";          commands[argc++]=factor;         break;       }e       case ImplodePreview:       { 7         (void) sprintf(factor,"%.1f",percentage+=12.5);t2         (void) sprintf(label,"implode %s",factor);$         commands[argc++]="-implode";          commands[argc++]=factor;         break;       }p       case OilPaintPreview:e       {((         (void) sprintf(factor,"%i",i+1);0         (void) sprintf(label,"paint %s",factor);"         commands[argc++]="-paint";          commands[argc++]=factor;         break;       }e"       case CharcoalDrawingPreview:       { 7         (void) sprintf(factor,"%.1f",percentage+=12.5);r3         (void) sprintf(label,"charcoal %s",factor);-%         commands[argc++]="-charcoal";o          commands[argc++]=factor;         break;       }      }+     commands[argc++]="-label";     commands[argc++]=label; 7     MogrifyImage(&local_info,argc,commands,&images[i]); &     (void) SetMonitorHandler(handler);4     ProgressMonitor(PreviewImageText,i,NumberTiles);   }    DestroyImage(preview_image);   /*2     Initialize X resource to their default values.   */7   resource_info.background_color=DefaultTileBackground;e)   resource_info.border_color=BorderColor;i:   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground; &   resource_info.gravity=CenterGravity;6   resource_info.image_geometry=DefaultPreviewGeometry;-   resource_info.matte_color=DefaultTileMatte; $   resource_info.title=(char *) NULL;   /*     Open X server connection.j   */0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {        /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);        /*3         Get user defaults from X resource database.        */B       resource_database=XGetResourceDatabase(display,client_name);E       XGetResourceInfo(resource_database,client_name,&resource_info); L       resource_info.background_color=XGetResourceInstance(resource_database,8         client_name,"background",DefaultTileBackground);E       resource_value=XGetResourceClass(resource_database,client_name,l.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,8         client_name,"foreground",DefaultTileForeground);J       resource_info.image_geometry=XGetResourceInstance(resource_database,<         client_name,"imageGeometry",DefaultPreviewGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 3         client_name,"mattecolor",DefaultTileMatte);        XCloseDisplay(display);j     }o   /*"     Create the PCD Overview image.   */!   for (i=1; i < NumberTiles; i++)    { $     images[i]->previous=images[i-1];      images[i-1]->next=images[i];   }o!   XGetMontageInfo(&montage_info); "   montage_info.texture="granite:";/   montage_info.tile=DefaultPreviewPageGeometry;d<   (void) strcpy(montage_info.filename,image_info->filename);E   montage_image=XMontageImages(&resource_info,&montage_info,*images);    for (i=0;  i < i; i++)     DestroyImage(images[i]);&   if (montage_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);).   if (montage_image->montage != (char *) NULL)     {n       /*         Free image directory.%       */#       free(montage_image->montage);%+       montage_image->montage=(char *) NULL; ,       if (image->directory != (char *) NULL)	         { )           free(montage_image->directory); 1           montage_image->directory=(char *) NULL; 	         }      } 2   status=WriteMIFFImage(image_info,montage_image);   DestroyImage(montage_image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   W r i t e P S I m a g e                                                   %dO %                                                                             %tO %                                                                             %aO %                                                                             %,O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t % G %  Function WritePSImage translates an image to encapsulated PostscriptuH %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.r % - %  The format of the WritePSImage routine is:  % , %      status=WritePSImage(image_info,image) %*+ %  A description of each parameter follows:t % I %    o status: Function WritePSImage return True if the image is printed.nI %      False is returned if the image file cannot be opened for printing.  %oA %    o image_info: Specifies a pointer to an ImageInfo structure.r %(F %    o image: The address of a structure of type Image;  returned from %      ReadImage.i %e %f */J static unsigned int WritePSImage(const ImageInfo *image_info,Image *image) {a
   static charp     *Postscript[]=     {(       "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",eG       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",i       "/byte 1 string def", #       "/color_packet 3 string def",(       "/pixels 768 string def", 	       "",n       "/DirectClassPacket",v
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters:",       "  %   red.","       "  %   green.",        "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",a       "  %",9       "  currentfile color_packet readhexstring pop pop",        "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",e       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",u       "  } for",-       "  pixels 0 number_pixels getinterval",%       "} bind def",%	       "",%       "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",        "    %",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",        "} bind def",t	       "",r       "/GrayDirectClassPacket",r
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",f       "  %",       "  % Parameters:",       "  %   red",       "  %   green",       "  %   blue",nK       "  %   length: number of pixels minus one of this color (optional).",n       "  %",9       "  currentfile color_packet readhexstring pop pop",m'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add",i+       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",n       "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",i*       "    /number_pixels exch 1 add def",       "  } ifelse",a"       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",(       "} bind def",r	       "",(       "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",i       "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",c       "  %",3       "  currentfile byte readhexstring pop 0 get",e!       "  /offset exch 3 mul def",n:       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul",n+       "  color_packet 1 get 0.587 mul add",o+       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",o       "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get",m*       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",o       "} bind def",r	       "",i       "/PseudoClassPacket",-
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters:",.       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",%       "  %",3       "  currentfile byte readhexstring pop 0 get",%!       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",%       "  %",       "  % Parameters:",3       "  %   class: 0-PseudoClass or 1-Grayscale.",b       "  %",*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",       "  class 0 gt",A       "  {",,       "    currentfile buffer readline pop",*       "    token pop /depth exch def pop",G       "    /grays columns 8 add depth sub depth mul 8 idiv string def",T       "    columns rows depth",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",:       "    { currentfile grays readhexstring pop } image",       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colors: number of colors in the colormap.",:       "    %   colormap: red, green, blue color packets.",       "    %",,       "    currentfile buffer readline pop",+       "    token pop /colors exch def pop",a%       "    /colors colors 3 mul def",)(       "    /colormap colors string def",7       "    currentfile colormap readhexstring pop pop",g)       "    systemdict /colorimage known",g       "    {",       "      columns rows 8",t       "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",7       "      { PseudoClassPacket } false 3 colorimage",m       "    }",       "    {",       "      %",?       "      % No colorimage operator;  convert to grayscale.",U       "      %",       "      columns rows 8",s       "      [",       "        columns 0 0",        "        rows neg 0 rows",       "      ]",.       "      { GrayPseudoClassPacket } image",       "    } ifelse",t       "  } ifelse",W       "} bind def",n	       "",a       "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",        "  %   x & y scale.",        "  %   label pointsize.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",*       "  currentfile buffer readline pop",,       "  token pop /pointsize exch def pop",G       "  /NewCenturySchlbk-Roman findfont pointsize scalefont setfont",t
       "^",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",a       (char *) NULLm     };     char     date[MaxTextExtent],     density[MaxTextExtent], 
     **labels,      **q;     floatD     dx_resolution,     dy_resolution,     x_resolution,r     y_resolution;e     intm     length,      x,     y;     register RunlengthPacket     *p;n     register int     i,     j;     time_t
     timer;     unsigned int     bit,	     byte,e
     count,     height,)	     page,a
     polarity,-     text_size,
     width;  
   XSegment     bounding_box;.     /*     Open output image file.e   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)s/     PrematureExit("Unable to open file",image); 	   page=1;t   do   {      /*-       Scale image to size of Postscript page.      */     text_size=0;&     if (image->label != (char *) NULL)G       text_size=MultilineCensus(image->label)*image_info->pointsize+12;      x=0;     y=0;     width=image->columns;*     height=image->rows;p-     if (strcmp(image_info->magick,"PS") == 0)l       {s         inti           delta_x,           delta_y,           flags;           unsigned int           page_height,           page_width;o  
         /**           Center image on Postscript page.
         */M         (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);c         flags=NoValue;.         if (image_info->page != (char *) NULL)P           flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);)         if (image->page != (char *) NULL) K           flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height);e.         if (((page_width-(x << 1)) < width) ||8             ((page_height-(y << 1)-text_size) < height))           {p             unsigned long                scale_factor;r               /*6               Scale image relative to Postscript page.             */<             scale_factor=UpShift(page_width-(x << 1))/width;P             if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))J               scale_factor=UpShift(page_height-(y << 1)-text_size)/height;0             width=DownShift(width*scale_factor);2             height=DownShift(height*scale_factor);           } "         if ((flags & XValue) == 0)           {f             /*.               Center image in the X direction.             */0             delta_x=page_width-(width+(x << 1));             if (delta_x >= 0)n!               x=(delta_x >> 1)+x;c           }a"         if ((flags & YValue) == 0)           {=             /*.               Center image in the X direction.             */<             delta_y=page_height-(height+(y << 1))-text_size;             if (delta_y >= 0)e!               y=(delta_y >> 1)+y;a           }f       }s     /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;(     dy_resolution=72.0;      x_resolution=72.0;-     (void) strcpy(density,PSDensityGeometry);->     count=sscanf(density,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL)NL       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)a        y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     if (page == 1)       {f
         /*#           Output Postscript header.!
         */1         if (strcmp(image_info->magick,"PS") == 0) :           (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");         elseC           (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); C         (void) fprintf(image->file,"%%%%Creator: (ImageMagick)\n");=H         (void) fprintf(image->file,"%%%%Title: (%s)\n",image->filename);$         timer=time((time_t *) NULL);!         (void) localtime(&timer); *         (void) strcpy(date,ctime(&timer));"         date[Extent(date)-1]='\0';D         (void) fprintf(image->file,"%%%%CreationDate: (%s)\n",date);         bounding_box.x1=x;         bounding_box.y1=y;(         bounding_box.x2=x+(int) width-1;5         bounding_box.y2=y+(int) (height+text_size)-1; B         if (image_info->adjoin && (image->next != (Image *) NULL))C           (void) fprintf(image->file,"%%%%BoundingBox: (atend)\n");i         elseF           (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",M             bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2);.*         if (image->label != (char *) NULL)%           (void) fprintf(image->file, J             "%%%%DocumentNeededResources: font NewCenturySchlbk-Roman\n");D         (void) fprintf(image->file,"%%%%DocumentData: Clean7Bit\n");=         (void) fprintf(image->file,"%%%%LanguageLevel: 1\n");r1         if (strcmp(image_info->magick,"PS") != 0)e7           (void) fprintf(image->file,"%%%%Pages: 0\n");g         else           {              Imagem              *next_image;;               unsigned int               pages;               /**               Compute the number of pages.             */F             (void) fprintf(image->file,"%%%%Orientation: Portrait\n");B             (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");             pages=1;#             if (image_info->adjoin) J               for (next_image=image->next; next_image != (Image *) NULL; )               { ,                 next_image=next_image->next;                 pages++;               } @             (void) fprintf(image->file,"%%%%Pages: %u\n",pages);           } 8         (void) fprintf(image->file,"%%%%EndComments\n");<         (void) fprintf(image->file,"\n%%%%BeginDefaults\n");F         (void) fprintf(image->file,"%%%%PageOrientation: Portrait\n");:         (void) fprintf(image->file,"%%%%EndDefaults\n\n");3         if (strcmp(image_info->magick,"EPSI") == 0)o           {              Image.               *preview_image;e               /*#               Create preview image.e             */             image->orphan=True;pK             preview_image=CopyImage(image,image->columns,image->rows,True);f              image->orphan=False;0             if (preview_image == (Image *) NULL)?               PrematureExit("Unable to allocate memory",image);S             /*#               Dump image as bitmap.              */2             if (!IsMonochromeImage(preview_image))               {N                 QuantizeInfo                    quantize_info;  0                 GetQuantizeInfo(&quantize_info);.                 quantize_info.number_colors=2;8                 quantize_info.dither=image_info->dither;8                 quantize_info.colorspace=GRAYColorspace;<                 QuantizeImage(&quantize_info,preview_image);)                 SyncImage(preview_image);)               }v             polarity=0;m#             if (image->colors == 2)i               polarity=nN                 Intensity(image->colormap[0]) > Intensity(image->colormap[1]);             bit=0;             byte=0;u             count=0;             x=0;$             p=preview_image->pixels;M             (void) fprintf(image->file,"%%%%BeginPreview: %u %u %u %u\n%%  ", J               preview_image->columns,preview_image->rows,(unsigned int) 1,M               (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36);=6             for (i=0; i < preview_image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               {                  byte<<=1; )                 if (p->index == polarity)f                   byte|=0x01;                  bit++;                 if (bit == 8)                    { C                     (void) fprintf(image->file,"%02x",byte & 0xff);                      count++;$                     if (count == 36)                       { =                         (void) fprintf(image->file,"\n%%  ");                           count=0;                       };                     bit=0;                     byte=0;e                   }x                 x++;0                 if (x == preview_image->columns)                   {%!                     if (bit != 0)%                       {%'                         byte<<=(8-bit); G                         (void) fprintf(image->file,"%02x",byte & 0xff);                           count++;(                         if (count == 36)                           { A                             (void) fprintf(image->file,"\n%%  "); $                             count=0;                           };                         bit=0;                         byte=0;                        };                     x=0;                   }                  }                  p++;               } ?               (void) fprintf(image->file,"\n%%%%EndPreview\n");%*               DestroyImage(preview_image);
             }M
         /*%           Output Postscript commands.f
         */#         for (q=Postscript; *q; q++)o	         {            if (*(*q) != '^')a
             {m4               (void) fprintf(image->file,"%s\n",*q);               continue;t
             }a>           for (i=MultilineCensus(image->label)-1; i >= 0; i--)           {sD             (void) fprintf(image->file,"  /label 512 string def\n");M             (void) fprintf(image->file,"  currentfile label readline pop\n");iN             (void) fprintf(image->file,"  0 y %d add moveto label show pop\n",*               i*image_info->pointsize+12);           }h	         }e1         if (strcmp(image_info->magick,"PS") == 0) 5           (void) fprintf(image->file,"  showpage\n");_3         (void) fprintf(image->file,"} bind def\n");H6         (void) fprintf(image->file,"%%%%EndProlog\n");       } ;     (void) fprintf(image->file,"%%%%Page:  1 %u\n",page++);nH     (void) fprintf(image->file,"%%%%PageBoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);     if (x < bounding_box.x1)       bounding_box.x1=x;     if (y < bounding_box.y1)       bounding_box.y1=y;,     if ((x+(int) width-1) > bounding_box.x2)&       bounding_box.x2=x+(int) width-1;9     if ((y+(int) (height+text_size)-1) > bounding_box.y2)s3       bounding_box.y2=y+(int) (height+text_size)-1;"&     if (image->label != (char *) NULL)!       (void) fprintf(image->file,l<         "%%%%PageResources: font NewCenturySchlbk-Roman\n");-     if (strcmp(image_info->magick,"PS") != 0) 5       (void) fprintf(image->file,"userdict begin\n");s3     (void) fprintf(image->file,"%%%%BeginData:\n");N1     (void) fprintf(image->file,"DisplayImage\n");i     /*       Output image data.     */&     labels=StringToList(image->label);/     image->compression=image_info->compression;x     CompressImage(image);nE     (void) fprintf(image->file,"%d %d\n%u %u\n%u\n",x,y,width,height,        image_info->pointsize); !     if (labels != (char **) NULL)p       {-2         for (i=0; labels[i] != (char *) NULL; i++)	         {>8           (void) fprintf(image->file,"%s \n",labels[i]);           free(labels[i]);	         }e         free(labels);/       }i     x=0;     p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))e       { 
         /*!           Dump DirectClass image. 
         */P         (void) fprintf(image->file,"%u %u\n%d\n%d\n",image->columns,image->rows,K           image->class == PseudoClass,image->compression == NoCompression);v#         switch (image->compression)i	         {c+           case RunlengthEncodedCompression:i           default:           {e             /*9               Dump runlength-encoded DirectColor packets.u             */.             for (i=0; i < image->packets; i++)
             {%>               for (length=p->length; length >= 0; length-=256)               { >                 if (image->matte && (p->index == Transparent))H                   (void) fprintf(image->file,"ffffff%02x",(unsigned int)&                     Min(length,0xff));                 else@                   (void) fprintf(image->file,"%02x%02x%02x%02x",M                     DownScale(p->red),DownScale(p->green),DownScale(p->blue), 5                     (unsigned int) Min(length,0xff));                  x++;                 if (x == 9)                    {                      x=0;5                     (void) fprintf(image->file,"\n");%                   }%               }                p++;'               if (QuantumTick(i,image))r@                 ProgressMonitor(SaveImageText,i,image->packets);
             }e             break;           }r           case NoCompression:            {r             /*4               Dump uncompressed DirectColor packets.             */.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               { >                 if (image->matte && (p->index == Transparent))7                   (void) fprintf(image->file,"ffffff");                  elseN                   (void) fprintf(image->file,"%02x%02x%02x",DownScale(p->red),<                     DownScale(p->green),DownScale(p->blue));                 x++;                 if (x == 12)                   {W                     x=0;5                     (void) fprintf(image->file,"\n");                    }                }                p++;'               if (QuantumTick(i,image))i@                 ProgressMonitor(SaveImageText,i,image->packets);
             }l             break;           }e	         } )         (void) fprintf(image->file,"\n");)       }      else       if (IsGrayImage(image))>	         {><           (void) fprintf(image->file,"%u %u\n1\n1\n1\n%d\n",I             image->columns,image->rows,IsMonochromeImage(image) ? 1 : 8);+(           if (!IsMonochromeImage(image))
             {i               /*(                 Dump image as grayscale.               */0               for (i=0; i < image->packets; i++)               {=6                 for (j=0; j <= ((int) p->length); j++)                 {uG                   (void) fprintf(image->file,"%02x",DownScale(p->red));%                   x++;                   if (x == 36)                     {                        x=0;7                       (void) fprintf(image->file,"\n");                      }                  }                  p++;)                 if (QuantumTick(i,image)) B                   ProgressMonitor(SaveImageText,i,image->packets);               } 
             }            else
             {                /*%                 Dump image as bitmap.                */               polarity= N                 Intensity(image->colormap[1]) > Intensity(image->colormap[0]);               bit=0;               byte=0;%               count=0;0               for (i=0; i < image->packets; i++)               {m6                 for (j=0; j <= ((int) p->length); j++)                 {i                   byte<<=1; +                   if (p->index == polarity)                      byte|=0x01;m                   bit++;                   if (bit == 8)e                     {iE                       (void) fprintf(image->file,"%02x",byte & 0xff);f                       count++;&                       if (count == 36)                         {o;                           (void) fprintf(image->file,"\n");r"                           count=0;                         };                       bit=0;                       byte=0;d                     }                    x++;*                   if (x == image->columns)                     {k                       /*5                         Advance to the next scanline.c                       */#                       if (bit != 0)g                         {P)                           byte<<=(8-bit);iI                           (void) fprintf(image->file,"%02x",byte & 0xff); "                           count++;*                           if (count == 36)                             {a?                               (void) fprintf(image->file,"\n");(&                               count=0;                             };                         };                       bit=0;                       byte=0;                        x=0;                     }                    }                  p++;)                 if (QuantumTick(i,image)).B                   ProgressMonitor(SaveImageText,i,image->packets);               }r
             }e           if (count != 0) -             (void) fprintf(image->file,"\n");,	         }o
       else	         {i           /*#             Dump PseudoClass image.a           */:           (void) fprintf(image->file,"%u %u\n%d\n%d\n0\n",C             image->columns,image->rows,image->class == PseudoClass, 1             image->compression == NoCompression);e           /*/             Dump number of colors and colormap.            */;           (void) fprintf(image->file,"%u\n",image->colors);a+           for (i=0; i < image->colors; i++)l8             (void) fprintf(image->file,"%02x%02x%02x\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));%           switch (image->compression)<           { -             case RunlengthEncodedCompression:e             default:
             {o               /*;                 Dump runlength-encoded PseudoColor packets.                */0               for (i=0; i < image->packets; i++)               {e@                 for (length=p->length; length >= 0; length-=256)                 {aP                   (void) fprintf(image->file,"%02x%02x",(unsigned int) p->index,5                     (unsigned int) Min(length,0xff));;                   x++;                   if (x == 18)                     {)                       x=0;7                       (void) fprintf(image->file,"\n");                      }                  }o                 p++;)                 if (QuantumTick(i,image))iB                   ProgressMonitor(SaveImageText,i,image->packets);               };               break;
             }              case NoCompression:r
             {                /*6                 Dump uncompressed PseudoColor packets.               */0               for (i=0; i < image->packets; i++)               {-6                 for (j=0; j <= ((int) p->length); j++)                 {rM                   (void) fprintf(image->file,"%02x",(unsigned int) p->index);                    x++;                   if (x == 36)                     {e                       x=0;7                       (void) fprintf(image->file,"\n");o                     }                  }                  p++;)                 if (QuantumTick(i,image))uB                   ProgressMonitor(SaveImageText,i,image->packets);               }i               break;
             }'           }-+           (void) fprintf(image->file,"\n"); 	         })0     (void) fprintf(image->file,"%%%%EndData\n");-     if (strcmp(image_info->magick,"PS") != 0) *       (void) fprintf(image->file,"end\n");4     (void) fprintf(image->file,"%%%%PageTrailer\n");&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);6.   (void) fprintf(image->file,"%%%%Trailer\n");   if (page > 1)m@     (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",G       bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2);%*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S 2 I m a g e                                                 % O %                                                                             % O %                                                                             %%O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image is J %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  %f. %  The format of the WritePS2Image routine is: %p- %      status=WritePS2Image(image_info,image)i %e+ %  A description of each parameter follows:  %/J %    o status: Function WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.  %,A %    o image_info: Specifies a pointer to an ImageInfo structure.a %tF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %e */K static unsigned int WritePS2Image(const ImageInfo *image_info,Image *image)  {p
   static charn     *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on",eG       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",n<       "/pixel_stream currentfile /ASCII85Decode filter def",	       "",o       "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",C       "  %",#       "  /DeviceRGB setcolorspace",=
       "  <<",i       "    /ImageType 1",g       "    /Interpolate true",       "    /Width columns",&       "    /Height rows",;        "    /BitsPerComponent 8","       "    /Decode [0 1 0 1 0 1]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",_       "    compression 0 gt",()       "    { /DataSource pixel_stream }",aB       "    { /DataSource pixel_stream /LZWDecode filter } ifelse",       "  >> image",        "} bind def", 	       "",e       "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",g       "  %",       "  % Parameters:",8       "  %   colors: number of colors in the colormap.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop",g       "  colors 0 eq",       "  {",       "    %","       "    % Image is grayscale.",       "    %",&       "    /DeviceGray setcolorspace",       "    <<",)       "      /ImageType 1",e        "      /Interpolate true",       "      /Width columns",h       "      /Height rows",("       "      /BitsPerComponent 1",       "      /Decode [0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt", +       "      { /DataSource pixel_stream }",z       "      {",)       "        /DataSource pixel_stream",        "        <<", $       "           /Columns columns",       "           /Rows rows",*       "        >> /CCITTFaxDecode filter",       "      } ifelse",        "    >> image",t       "  }",       "  {",       "    %",       "    % Parameters:",:       "    %   colormap: red, green, blue color packets.",       "    %",.       "    /colormap colors 3 mul string def",7       "    currentfile colormap readhexstring pop pop", H       "    [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",       "    <<",        "      /ImageType 1",(        "      /Interpolate true",       "      /Width columns",_       "      /Height rows", "       "      /BitsPerComponent 8",       "      /Decode [0 255]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",G       "      compression 0 gt",o+       "      { /DataSource pixel_stream }", D       "      { /DataSource pixel_stream /LZWDecode filter } ifelse",       "    >> image",,       "  } ifelse",f       "} bind def",&	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters:",!       "  %   x & y translation.",)       "  %   x & y scale.",e       "  %   label pointsize.",f       "  %   image label.",f$       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",*       "  currentfile buffer readline pop",,       "  token pop /pointsize exch def pop",G       "  /NewCenturySchlbk-Roman findfont pointsize scalefont setfont",u
       "^",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop",/*       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",!       "  pixel_stream flushfile",=       "  grestore",        (char *) NULLp     };     char     date[MaxTextExtent],     density[MaxTextExtent], 
     **labels,f     **q;     floatc     dx_resolution,     dy_resolution,     x_resolution,(     y_resolution;n     intb
     count,     delta_x,     delta_y,
     flags,     x,     y;     register RunlengthPacket     *p;e     register int     i,     j;     time_t
     timer;     unsigned char;     *pixels;     unsigned int     height,      number_packets,e	     page,,     page_height,     page_width,v     text_size,
     width;  
   XSegment     bounding_box;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);o	   page=1;a   do   {      /*-       Scale image to size of Postscript page.m     */     text_size=0;&     if (image->label != (char *) NULL)G       text_size=MultilineCensus(image->label)*image_info->pointsize+12;>     x=0;     y=0;     width=image->columns;*     height=image->rows;      /*&       Center image on Postscript page.     */I     (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height);l     flags=NoValue;*     if (image_info->page != (char *) NULL)L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);%     if (image->page != (char *) NULL)iG       flags=XParseGeometry(image->page,&x,&y,&page_width,&page_height); *     if (((page_width-(x << 1)) < width) ||4         ((page_height-(y << 1)-text_size) < height))       {          unsigned long            scale_factor;p  
         /*2           Scale image relative to Postscript page.
         */8         scale_factor=UpShift(page_width-(x << 1))/width;L         if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))F           scale_factor=UpShift(page_height-(y << 1)-text_size)/height;,         width=DownShift(width*scale_factor);.         height=DownShift(height*scale_factor);       }"     if ((flags & XValue) == 0)       { 
         /**           Center image in the X direction.
         */,         delta_x=page_width-(width+(x << 1));         if (delta_x >= 0)i           x=(delta_x >> 1)+x;        }      if ((flags & YValue) == 0)       {o
         /**           Center image in the X direction.
         */8         delta_y=page_height-(height+(y << 1))-text_size;         if (delta_y >= 0)            y=(delta_y >> 1)+y;0       }      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;      x_resolution=72.0;-     (void) strcpy(density,PSDensityGeometry);(>     count=sscanf(density,"%fx%f",&x_resolution,&y_resolution);-     if (image_info->density != (char *) NULL)yL       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);     if (count != 2)         y_resolution=x_resolution;D     width=(unsigned int) (((width*dx_resolution)/x_resolution)+0.5);F     height=(unsigned int) (((height*dy_resolution)/y_resolution)+0.5);     if (page == 1)       { 
         /*#           Output Postscript header. 
         */2         if (strcmp(image_info->magick,"PS2") == 0):           (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");         elseC           (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n");%C         (void) fprintf(image->file,"%%%%Creator: (ImageMagick)\n"); H         (void) fprintf(image->file,"%%%%Title: (%s)\n",image->filename);$         timer=time((time_t *) NULL);!         (void) localtime(&timer); *         (void) strcpy(date,ctime(&timer));"         date[Extent(date)-1]='\0';D         (void) fprintf(image->file,"%%%%CreationDate: (%s)\n",date);         bounding_box.x1=x;         bounding_box.y1=y;(         bounding_box.x2=x+(int) width-1;5         bounding_box.y2=y+(int) (height+text_size)-1; B         if (image_info->adjoin && (image->next != (Image *) NULL))C           (void) fprintf(image->file,"%%%%BoundingBox: (atend)\n");%         elseF           (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",M             bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2);t*         if (image->label != (char *) NULL)%           (void) fprintf(image->file, J             "%%%%DocumentNeededResources: font NewCenturySchlbk-Roman\n");=         (void) fprintf(image->file,"%%%%LanguageLevel: 2\n");e2         if (strcmp(image_info->magick,"PS2") != 0)7           (void) fprintf(image->file,"%%%%Pages: 0\n");f         else           {n             Imagee              *next_image;i               unsigned int               pages;               /**               Compute the number of pages.             */F             (void) fprintf(image->file,"%%%%Orientation: Portrait\n");B             (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");             pages=1;#             if (image_info->adjoin) J               for (next_image=image->next; next_image != (Image *) NULL; )               {v,                 next_image=next_image->next;                 pages++;               } @             (void) fprintf(image->file,"%%%%Pages: %u\n",pages);           } 8         (void) fprintf(image->file,"%%%%EndComments\n");<         (void) fprintf(image->file,"\n%%%%BeginDefaults\n");F         (void) fprintf(image->file,"%%%%PageOrientation: Portrait\n");:         (void) fprintf(image->file,"%%%%EndDefaults\n\n");
         /*%           Output Postscript commands.i
         */#         for (q=Postscript; *q; q++)t	         {i           if (*(*q) != '^')_
             {e4               (void) fprintf(image->file,"%s\n",*q);               continue;o
             }g>           for (i=MultilineCensus(image->label)-1; i >= 0; i--)           {DD             (void) fprintf(image->file,"  /label 512 string def\n");M             (void) fprintf(image->file,"  currentfile label readline pop\n");nN             (void) fprintf(image->file,"  0 y %d add moveto label show pop\n",*               i*image_info->pointsize+12);           }t	         }m2         if (strcmp(image_info->magick,"PS2") == 0)5           (void) fprintf(image->file,"  showpage\n");=3         (void) fprintf(image->file,"} bind def\n");s6         (void) fprintf(image->file,"%%%%EndProlog\n");       } ;     (void) fprintf(image->file,"%%%%Page:  1 %u\n",page++);cH     (void) fprintf(image->file,"%%%%PageBoundingBox: %d %d %d %d\n",x,y,4       x+(int) width-1,y+(int) (height+text_size)-1);     if (x < bounding_box.x1)       bounding_box.x1=x;     if (y < bounding_box.y1)       bounding_box.y1=y;,     if ((x+(int) width-1) > bounding_box.x2)&       bounding_box.x2=x+(int) width-1;9     if ((y+(int) (height+text_size)-1) > bounding_box.y2)_3       bounding_box.y2=y+(int) (height+text_size)-1; &     if (image->label != (char *) NULL)!       (void) fprintf(image->file,h<         "%%%%PageResources: font NewCenturySchlbk-Roman\n");.     if (strcmp(image_info->magick,"PS2") != 0)5       (void) fprintf(image->file,"userdict begin\n");C3     (void) fprintf(image->file,"%%%%BeginData:\n");r1     (void) fprintf(image->file,"DisplayImage\n");n     /*       Output image data.     */&     labels=StringToList(image->label);/     image->compression=image_info->compression;r     CompressImage(image);dE     (void) fprintf(image->file,"%d %d\n%u %u\n%u\n",x,y,width,height,g       image_info->pointsize);r!     if (labels != (char **) NULL)r       {r2         for (i=0; labels[i] != (char *) NULL; i++)	         {_8           (void) fprintf(image->file,"%s \n",labels[i]);           free(labels[i]);	         }          free(labels);r       }hL     (void) fprintf(image->file,"%u %u\n%u\n%d\n",image->columns,image->rows,@       IsPseudoClass(image),image->compression == NoCompression);     p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))S!       switch (image->compression)_       {f)         case RunlengthEncodedCompression:n         default:	         {a            register unsigned char             *q;c             /*!             Allocate pixel array.t           */6           number_packets=3*image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL)a=             PrematureExit("Unable to allocate memory",image);a           /*(             Dump Packbit encoded pixels.           */           q=pixels; ,           for (i=0; i < image->packets; i++)           {r2             for (j=0; j <= ((int) p->length); j++)
             { <               if (image->matte && (p->index == Transparent))                 {a)                   *q++=DownScale(MaxRGB);g)                   *q++=DownScale(MaxRGB);w)                   *q++=DownScale(MaxRGB);q                 }>               else                 {S)                   *q++=DownScale(p->red); +                   *q++=DownScale(p->green);a*                   *q++=DownScale(p->blue);                 }i
             })             p++;%             if (QuantumTick(i,image))t>               ProgressMonitor(SaveImageText,i,image->packets);           }rC           (void) LZWEncodeImage(image->file,pixels,number_packets);             free((char *) pixels);           break;	         }i         case NoCompression:*	         {b           /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();,           for (i=0; i < image->packets; i++)           {E2             for (j=0; j <= ((int) p->length); j++)
             {=<               if (image->matte && (p->index == Transparent))                 { ?                   Ascii85Encode(DownScale(MaxRGB),image->file);i?                   Ascii85Encode(DownScale(MaxRGB),image->file); ?                   Ascii85Encode(DownScale(MaxRGB),image->file);                  }c               else                 {c?                   Ascii85Encode(DownScale(p->red),image->file);eA                   Ascii85Encode(DownScale(p->green),image->file);s@                   Ascii85Encode(DownScale(p->blue),image->file);                 } 
             }(             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           };$           Ascii85Flush(image->file);           break;	         }        }      else#       if (IsMonochromeImage(image)) 	         {;            register unsigned char             bit,             byte,              polarity;S             polarity= J             Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;            x=0;,           (void) fprintf(image->file,"0\n");%           switch (image->compression)            { -             case RunlengthEncodedCompression:              default:
             {g:               (void) HuffmanEncodeImage(image_info,image);               break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)                 {                    byte<<=1; +                   if (p->index == polarity)i                     byte|=0x01;                    bit++;                   if (bit == 8)                      {o6                       Ascii85Encode(byte,image->file);                       bit=0;                       byte=0;                      }%                   x++;*                   if (x == image->columns)                     {n                       /*5                         Advance to the next scanline.                        */#                       if (bit != 0) C                         Ascii85Encode(byte << (8-bit),image->file);                        bit=0;                       byte=0;                        x=0;                    }                 }                  p++;)                 if (QuantumTick(i,image))oB                   ProgressMonitor(SaveImageText,i,image->packets);               }=(               Ascii85Flush(image->file);               break;
             };           } 	         }0
       else	         {            /*/             Dump number of colors and colormap.            */;           (void) fprintf(image->file,"%u\n",image->colors);x+           for (i=0; i < image->colors; i++) 8             (void) fprintf(image->file,"%02x%02x%02x\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));%           switch (image->compression)            { -             case RunlengthEncodedCompression:(             default:
             {i$               register unsigned char                 *q;                  /*%                 Allocate pixel array.                */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)=                 malloc(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL)xA                 PrematureExit("Unable to allocate memory",image);                /*.                 Dump Runlength encoded pixels.               */               q=pixels; 0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)0                   *q++=(unsigned char) p->index;                 p++;)                 if (QuantumTick(i,image))(B                   ProgressMonitor(SaveImageText,i,image->packets);               } G               (void) LZWEncodeImage(image->file,pixels,number_packets);s$               free((char *) pixels);               break;
             }e             case NoCompression:f
             {,               /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();0               for (i=0; i < image->packets; i++)               {e6                 for (j=0; j <= ((int) p->length); j++)F                   Ascii85Encode((unsigned char) p->index,image->file);                 p++;)                 if (QuantumTick(i,image)) B                   ProgressMonitor(SaveImageText,i,image->packets);               }a(               Ascii85Flush(image->file);               break;
             }a           } 	         } %     (void) fprintf(image->file,"\n");e0     (void) fprintf(image->file,"%%%%EndData\n");.     if (strcmp(image_info->magick,"PS2") != 0)*       (void) fprintf(image->file,"end\n");4     (void) fprintf(image->file,"%%%%PageTrailer\n");&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin); .   (void) fprintf(image->file,"%%%%Trailer\n");   if (page > 1) @     (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",G       bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); *   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   W r i t e R A D I A N C E I m a g e                                       % O %                                                                             % O %                                                                             %rO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eL %  Function WriteRADIANCEImage writes an image in the RADIANCE encoded image
 %  format. %r3 %  The format of the WriteRADIANCEImage routine is:u %r2 %      status=WriteRADIANCEImage(image_info,image) % + %  A description of each parameter follows.f % O %    o status: Function WriteRADIANCEImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image fileS %      fails to write. %yA %    o image_info: Specifies a pointer to an ImageInfo structure.  %n. %    o image:  A pointer to a Image structure. %  %  */C static unsigned int WriteRADIANCEImage(const ImageInfo *image_info,g   Image *image)m {    unsigned int     status;   :   Warning("Cannot write RADIANCE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);t }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %gO %                                                                             %nO %                                                                             %iO %   W r i t e R G B I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %gF %  Function WriteRGBImage writes an image to a file in red, green, and %  blue rasterfile format. %n. %  The format of the WriteRGBImage routine is: % - %      status=WriteRGBImage(image_info,image), %g+ %  A description of each parameter follows.  %*J %    o status: Function WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %"A %    o image_info: Specifies a pointer to an ImageInfo structure.e %i. %    o image:  A pointer to a Image structure. %  %v */K static unsigned int WriteRGBImage(const ImageInfo *image_info,Image *image)i {e   register int     i,     j;     register RunlengthPacket     *p;o     image->depth=QuantumDepth;2   if (image_info->interlace != PartitionInterlace)     {e       /*         Open output image file.e       */2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL)03         PrematureExit("Unable to open file",image);)     }v   do   {f     /*(       Convert MIFF to RGB raster pixels.     */.     if (strcmp(image_info->magick,"RGB") == 0)       image->matte=False; "     switch (image_info->interlace)     {%       case NoneInterlace:e       default:       {+
         /*0           No interlacing:  RGBRGBRGBRGBRGBRGB...
         */         p=image->pixels;*         for (i=0; i < image->packets; i++)	         {a0           for (j=0; j <= ((int) p->length); j++)           {d%             WriteQuantumFile(p->red);_'             WriteQuantumFile(p->green);>&             WriteQuantumFile(p->blue);             if (image->matte) )               WriteQuantumFile(p->index);            }m           p++;#           if (QuantumTick(i,image));<             ProgressMonitor(SaveImageText,i,image->packets);	         }d         break;       }i       case LineInterlace:        {          register int           x,           y;  
         /*A           Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB... 
         */$         if (!UncompressImage(image))           return(False);'         for (y=0; y < image->rows; y++) 	         { -           p=image->pixels+(y*image->columns);f,           for (x=0; x < image->columns; x++)           {r%             WriteQuantumFile(p->red);"             p++;           }e-           p=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { '             WriteQuantumFile(p->green);a             p++;           }t-           p=image->pixels+(y*image->columns);+,           for (x=0; x < image->columns; x++)           {e&             WriteQuantumFile(p->blue);             p++;           }e-           p=image->pixels+(y*image->columns);m           if (image->matte)h.             for (x=0; x < image->columns; x++)
             { )               WriteQuantumFile(p->index);i               p++;
             }e7           ProgressMonitor(SaveImageText,y,image->rows);g	         }m         break;       }a       case PlaneInterlace:       case PartitionInterlace:       { 
         /*9           Plane interlacing:  RRRRRR...GGGGGG...BBBBBB... 
         */8         if (image_info->interlace == PartitionInterlace)           {i3             AppendImageFormat("R",image->filename);c8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL)t9               PrematureExit("Unable to open file",image);g           }e         p=image->pixels;*         for (i=0; i < image->packets; i++)	         {w0           for (j=0; j <= ((int) p->length); j++)%             WriteQuantumFile(p->red);            p++;	         }i8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("G",image->filename);f8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            }=/         ProgressMonitor(SaveImageText,100,400);          p=image->pixels;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)'             WriteQuantumFile(p->green);)           p++;	         }y8         if (image_info->interlace == PartitionInterlace)           {(             CloseImage(image);3             AppendImageFormat("B",image->filename);u8             OpenImage(image_info,image,WriteBinaryType);-             if (image->file == (FILE *) NULL)l9               PrematureExit("Unable to open file",image);i           }t/         ProgressMonitor(SaveImageText,200,400);e         p=image->pixels;*         for (i=0; i < image->packets; i++)	         {e0           for (j=0; j <= ((int) p->length); j++)&             WriteQuantumFile(p->blue);           p++;	         }"         if (image->matte)e           {n3             ProgressMonitor(SaveImageText,300,400);e             p=image->pixels;<             if (image_info->interlace == PartitionInterlace)               {4"                 CloseImage(image);7                 AppendImageFormat("A",image->filename);t<                 OpenImage(image_info,image,WriteBinaryType);1                 if (image->file == (FILE *) NULL) =                   PrematureExit("Unable to open file",image);f               }e.             for (i=0; i < image->packets; i++)
             {a4               for (j=0; j <= ((int) p->length); j++)+                 WriteQuantumFile(p->index);e               p++;
             }e           }j8         if (image_info->interlace == PartitionInterlace)>           (void) strcpy(image->filename,image_info->filename);/         ProgressMonitor(SaveImageText,400,400);e         break;       }i     }n&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);e   CloseImage(image);   return(True);a }> e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %uO %                                                                             %fO %   W r i t e R L A I m a g e                                                 %+O %                                                                             %iO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % N %  Function WriteRLAImage writes an image in the Alias/Wavefront encoded image
 %  format. %n. %  The format of the WriteRLAImage routine is: %i- %      status=WriteRLAImage(image_info,image)e %h+ %  A description of each parameter follows.a %>J %    o status: Function WriteRLAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file) %      fails to write. %cA %    o image_info: Specifies a pointer to an ImageInfo structure.v %). %    o image:  A pointer to a Image structure. %( %P */K static unsigned int WriteRLAImage(const ImageInfo *image_info,Image *image)P {/   unsigned int     status;   5   Warning("Cannot write RLA images",image->filename);f*   status=WriteMIFFImage(image_info,image);   return(status);i }f n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %oO %                                                                             %eO %   W r i t e R L E I m a g e                                                 % O %                                                                             %aO %                                                                             %MO %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %jN %  Function WriteRLEImage writes an image in the Utah Run length encoded image
 %  format. %r. %  The format of the WriteRLEImage routine is: %e- %      status=WriteRLEImage(image_info,image)f %a+ %  A description of each parameter follows.r %fJ %    o status: Function WriteRLEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file) %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.e % . %    o image:  A pointer to a Image structure. %i %r */K static unsigned int WriteRLEImage(const ImageInfo *image_info,Image *image)r {f   char     command[MaxTextExtent];[     Imagec     *flipped_image;\     ImageInfo 
     rle_info;i     unsigned int     packet_size,     status;<     /*     Flip image.]   */   image->orphan=True;m!   flipped_image=FlipImage(image);v   image->orphan=False;&   if (flipped_image == (Image *) NULL)0     PrematureExit("Unable to flip image",image);   rle_info=(*image_info);a#   rle_info.interlace=NoneInterlace;t-   TemporaryFilename(flipped_image->filename);o0   status=WriteRGBImage(&rle_info,flipped_image);
   if (status)i     {n       packet_size=3;       if (image->matte)          packet_size=4;E       (void) sprintf(command,"rawtorle -w %u -h %u -n %u -o %s %s\n",hD         image->columns,image->rows,packet_size,image_info->filename,!         flipped_image->filename); $       status=SystemCommand(command);-       (void) remove(flipped_image->filename); .       if (!IsAccessible(image_info->filename))2         Warning("RLE translation failed",command);     }r   DestroyImage(flipped_image);   return(status);i }s n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %cO %                                                                             % O %                                                                             % O %   W r i t e S G I I m a g e                                                 % O %                                                                             % O %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteSGIImage writes an image in SGI RGB encoded image format. % . %  The format of the WriteSGIImage routine is: % - %      status=WriteSGIImage(image_info,image)  %r+ %  A description of each parameter follows.; % J %    o status: Function WriteSGIImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.t % . %    o image:  A pointer to a Image structure. %  %  */  5 static int SGIEncode(unsigned char *pixels,int count,    unsigned char *packets)n {)   short      runlength;     unsigned charg     *limit,p
     *mark,     *p,t     *q;      p=pixels;    limit=p+count*4;   q=packets;   while (p < limit)f   {      mark=p; 	     p+=8;8A     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))E       p+=4;l	     p-=8;m      count=(int) ((p-mark) >> 2);     while (count)      { *       runlength=count > 126 ? 126 : count;       count-=runlength;f       *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)%       {          *q++=(*mark);(         mark+=4;       }i     }      mark=p; 	     p+=4; (     while ((p < limit) && (*p == *mark))       p+=4;,      count=(int) ((p-mark) >> 2);     while (count),     {-*       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=runlength;        *q++=(*mark);      }(   }o	   *q++=0;(   return((int) (q-packets)); }e  K static unsigned int WriteSGIImage(const ImageInfo *image_info,Image *image)y {    typedef struct _SGIHeader    {      unsigned short       magic;       unsigned chara       storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned longo       minimum_value,       maximum_value;       unsigned char        filler[492];   } SGIHeader;     SGIHeader      iris_header;     register int     i,     j,     x,     y,     z;     register RunlengthPacket     *p;      register unsigned char     *q;k     unsigned char      *iris_pixels,s
     *packets;(     /*     Open output image file.-   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    do   {      /*(       Initialize SGI raster file header.     */     iris_header.magic=0x01DA;;/     image->compression=image_info->compression; ,     if (image->compression == NoCompression)       iris_header.storage=0x00;      else       iris_header.storage=0x01;0<     iris_header.bytes_per_pixel=1;  /* one byte per pixel */     iris_header.dimension=3;'     iris_header.columns=image->columns; !     iris_header.rows=image->rows; +     iris_header.depth=image->matte ? 4 : 3;      if (IsGrayImage(image))        {i          iris_header.dimension=2;         iris_header.depth=1;       }l      iris_header.minimum_value=0;%     iris_header.maximum_value=MaxRGB; 2     for (i=0; i < sizeof(iris_header.filler); i++)       iris_header.filler[i]=0;     /*       Write SGI header.      */6     MSBFirstWriteShort(iris_header.magic,image->file);2     (void) fputc(iris_header.storage,image->file);:     (void) fputc(iris_header.bytes_per_pixel,image->file);:     MSBFirstWriteShort(iris_header.dimension,image->file);8     MSBFirstWriteShort(iris_header.columns,image->file);5     MSBFirstWriteShort(iris_header.rows,image->file);h6     MSBFirstWriteShort(iris_header.depth,image->file);=     MSBFirstWriteLong(iris_header.minimum_value,image->file); =     MSBFirstWriteLong(iris_header.maximum_value,image->file); O     (void) fwrite(iris_header.filler,1,sizeof(iris_header.filler),image->file);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *)sA       malloc(4*image->columns*image->rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);u     /*C       Convert runlength-encoded packets to uncompressed SGI pixels.      */     x=0;     y=0;     p=image->pixels;?     q=iris_pixels+(iris_header.rows-1)*(iris_header.columns*4);+&     for (i=0; i < image->packets; i++)     {n,       for (j=0; j <= ((int) p->length); j++)       {T         *q++=DownScale(p->red); !         *q++=DownScale(p->green);g          *q++=DownScale(p->blue);&         *q++=(unsigned char) p->index;         x++;          if (x == image->columns)           {i             y++;K             q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4);              x=0;           }        }c
       p++;     }o,     if (image->compression == NoCompression)       {i         unsigned char            *scanline;  
         /*(           Write uncompressed SGI pixels.
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL),;           PrematureExit("Unable to allocate memory",image);m3         for (z=0; z < (int) iris_header.depth; z++)8	         {e           q=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {e9             for (x=0; x < (int) iris_header.columns; x++)a
             {i               scanline[x]=(*q);)               q+=4;t
             }.M             (void) fwrite(scanline,sizeof(unsigned char),iris_header.columns,e               image->file);v           }i=           ProgressMonitor(SaveImageText,z,iris_header.depth);n	         }          free(scanline);s       }c     else       {f         unsigned long>           length,f           number_packets,j           offset,f           *offsets,e           *runlength;)  
         /*F           Convert SGI uncompressed pixels to runlength-encoded pixels.
         */!         offsets=(unsigned long *)>K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));dK         packets=(unsigned char *) malloc(4*((iris_header.columns << 1)+10)*v-           image->rows*sizeof(unsigned char));(#         runlength=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image); A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);l         number_packets=0;i         q=iris_pixels;2         for (y=0; y < (int) iris_header.rows; y++)	         { 5           for (z=0; z < (int) iris_header.depth; z++)m           {a             length=yN               SGIEncode(q+z,(int) iris_header.columns,packets+number_packets);#             number_packets+=length; 1             offsets[y+z*iris_header.rows]=offset;f3             runlength[y+z*iris_header.rows]=length;i             offset+=length;e           }o%           q+=(iris_header.columns*4);I<           ProgressMonitor(SaveImageText,y,iris_header.rows);	         } 
         /*N           Write out line start and length tables and runlength-encoded pixels.
         */F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)4           MSBFirstWriteLong(offsets[i],image->file);F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)6           MSBFirstWriteLong(runlength[i],image->file);P         (void) fwrite(packets,sizeof(unsigned char),number_packets,image->file);
         /*           Free memory.
         */         free(runlength);         free(packets);         free(offsets);       }c     free(iris_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);n   CloseImage(image);   return(True);) }r f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %sO %                                                                             % O %                                                                             % O %   W r i t e S U N I m a g e                                                 % O %                                                                             % O %                                                                             %gO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %UG %  Function WriteSUNImage writes an image in the SUN rasterfile format.  % . %  The format of the WriteSUNImage routine is: % - %      status=WriteSUNImage(image_info,image)  %o+ %  A description of each parameter follows.  % J %    o status: Function WriteSUNImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filem %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %+. %    o image:  A pointer to a Image structure. %w %a */K static unsigned int WriteSUNImage(const ImageInfo *image_info,Image *image)  {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_FORMAT_RGB  3     typedef struct _SUNHeader    {      unsigned long        magic,       width,
       height,        depth,
       length,)       type,g       maptype,       maplength;   } SUNHeader;     register int     i,     j,     x;     register RunlengthPacket     *p;e     SUNHeader(     sun_header;      /*     Open output image file.p   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);+   do   {      /*(       Initialize SUN raster file header.     */      sun_header.magic=0x59a66a95;$     sun_header.width=image->columns;"     sun_header.height=image->rows;P     sun_header.type=(image->class == DirectClass ? RT_FORMAT_RGB : RT_STANDARD);      sun_header.maptype=RMT_NONE;     sun_header.maplength=0;-5     if (!IsPseudoClass(image) && !IsGrayImage(image))(       {m
         /*            Full color SUN raster.
         */2         sun_header.depth=(image->matte ? 32 : 24);L         sun_header.length=image->columns*image->rows*(image->matte ? 4 : 3);@         sun_header.length+=image->columns % 2 ? image->rows : 0;       }(     else#       if (IsMonochromeImage(image)) 	         {            /*"             Monochrome SUN raster.           */           sun_header.depth=1;eB           sun_header.length=((image->columns+7) >> 3)*image->rows;P           sun_header.length+=((image->columns/8)+(image->columns % 8 ? 1 : 0)) %              2 ? image->rows : 0;	         } 
       else	         {            /*#             Colormapped SUN raster.i           */           sun_header.depth=8; 7           sun_header.length=image->columns*image->rows;=B           sun_header.length+=image->columns % 2 ? image->rows : 0;+           sun_header.maptype=RMT_EQUAL_RGB; /           sun_header.maplength=image->colors*3; 	         }      /*       Write SUN header.      */4     MSBFirstWriteLong(sun_header.magic,image->file);4     MSBFirstWriteLong(sun_header.width,image->file);5     MSBFirstWriteLong(sun_header.height,image->file);)4     MSBFirstWriteLong(sun_header.depth,image->file);5     MSBFirstWriteLong(sun_header.length,image->file);e3     MSBFirstWriteLong(sun_header.type,image->file); 6     MSBFirstWriteLong(sun_header.maptype,image->file);8     MSBFirstWriteLong(sun_header.maplength,image->file);     /*(       Convert MIFF to SUN raster pixels.     */     p=image->pixels;     x=0;5     if (!IsPseudoClass(image) && !IsGrayImage(image))d       {.
         /*6           Convert DirectClass packet to SUN RGB pixel.
         */*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           {              if (image->matte) <               (void) fputc(DownScale(p->index),image->file);8             (void) fputc(DownScale(p->red),image->file);:             (void) fputc(DownScale(p->green),image->file);9             (void) fputc(DownScale(p->blue),image->file);t             x++;$             if (x == image->columns)               { .                 if ((image->columns % 2) != 0)A                   (void) fputc(0,image->file); /* pad scanline */                  x=0;               }            }            p++;#           if (QuantumTick(i,image))e<             ProgressMonitor(SaveImageText,i,image->packets);	         }l       }      else#       if (IsMonochromeImage(image)) 	         {             register unsigned char             bit,             byte,              polarity;              /*@             Convert PseudoClass image to a SUN monochrome image.           */           polarity=pJ             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);           bit=0;           byte=0;i,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                byte<<=1; '               if (p->index == polarity)                  byte|=0x01;                bit++;               if (bit == 8)                  {e1                   (void) fputc(byte,image->file);                    bit=0;                   byte=0;                  }                x++;&               if (x == image->columns)                 {d                   /*1                     Advance to the next scanline.                    */                   if (bit != 0) >                     (void) fputc(byte << (8-bit),image->file);+                   if ((((image->columns/8)+ >                       (image->columns % 8 ? 1 : 0)) % 2) != 0)D                     (void) fputc(0,image->file);  /* pad scanline */                   bit=0;                   byte=0;                    x=0;                }
             }n             p++;%             if (QuantumTick(i,image)) >               ProgressMonitor(SaveImageText,i,image->packets);           }t	         }l
       else	         {            /*"             Dump colormap to file.           */+           for (i=0; i < image->colors; i++) H             (void) fputc(DownScale(image->colormap[i].red),image->file);+           for (i=0; i < image->colors; i++) J             (void) fputc(DownScale(image->colormap[i].green),image->file);+           for (i=0; i < image->colors; i++)lI             (void) fputc(DownScale(image->colormap[i].blue),image->file);            /*@             Convert PseudoClass packet to SUN colormapped pixel.           */,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             { 1               (void) fputc(p->index,image->file);                x++;&               if (x == image->columns)                 { 0                   if ((image->columns % 2) != 0)D                     (void) fputc(0,image->file);  /* pad scanline */                   x=0;                 }U
             }              p++;%             if (QuantumTick(i,image))g>               ProgressMonitor(SaveImageText,i,image->packets);           }n	         } &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);k }; + /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %mO %                                                                             %;O %   W r i t e T A R G A I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %hM %  Function WriteTARGAImage writes a image in the Truevision Targa rasterfile 
 %  format. %s0 %  The format of the WriteTARGAImage routine is: % / %      status=WriteTARGAImage(image_info,image)b % + %  A description of each parameter follows.g %fL %    o status: Function WriteTARGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filer %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.n %i. %    o image:  A pointer to a Image structure. %r %f */M static unsigned int WriteTARGAImage(const ImageInfo *image_info,Image *image)  {  #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3  #define TargaRLEColormap  9] #define TargaRLERGB  10+ #define TargaRLEMonochrome  11     typedef struct _TargaHeader    {m     unsigned char        id_length,       colormap_type,       image_type;i       unsigned short       colormap_index,        colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,"       y_origin,)       width,
       height;        unsigned char        pixel_size,n       attributes;n   } TargaHeader;     Imagei     *flopped_image;)     int 
     count,     runlength;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q,(     *r;(  
   TargaHeader]     targa_header;      unsigned charE     *targa_pixels;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);l   do   {e     /*       Flop image.f     */     image->orphan=True;"#     flopped_image=FlopImage(image);e     image->orphan=False;(     if (flopped_image == (Image *) NULL)2       PrematureExit("Unable to flop image",image);7     flopped_image->compression=image_info->compression; !     CompressImage(flopped_image);\     /**       Initialize TARGA raster file header.     */     targa_header.id_length=0;x1     if (flopped_image->comments != (char *) NULL)-F       targa_header.id_length=Min(Extent(flopped_image->comments),255);!     targa_header.colormap_type=0; "     targa_header.colormap_index=0;#     targa_header.colormap_length=0;i!     targa_header.colormap_size=0;a     targa_header.x_origin=0;     targa_header.y_origin=0;.     targa_header.width=flopped_image->columns;,     targa_header.height=flopped_image->rows;     targa_header.pixel_size=8;     targa_header.attributes=0;&     if (!IsPseudoClass(flopped_image))       {i
         /*"           Full color TARGA raster.
         */)         targa_header.image_type=TargaRGB; F         if (flopped_image->compression == RunlengthEncodedCompression).           targa_header.image_type=TargaRLERGB;?         targa_header.pixel_size=flopped_image->matte ? 32 : 24;n       }      else       {e
         /*#           Colormapped TARGA raster.l
         */.         targa_header.image_type=TargaColormap;F         if (flopped_image->compression == RunlengthEncodedCompression)3           targa_header.image_type=TargaRLEColormap; .         if (!IsMonochromeImage(flopped_image))           {()             targa_header.colormap_type=1;i*             targa_header.colormap_index=0;?             targa_header.colormap_length=flopped_image->colors;(*             targa_header.colormap_size=24;           }          else           {              /*&               Monochrome TARGA raster.             */4             targa_header.image_type=TargaMonochrome;J             if (flopped_image->compression == RunlengthEncodedCompression)9               targa_header.image_type=TargaRLEMonochrome;            }        }      /*       Write TARGA header.      */<     (void) fputc((char) targa_header.id_length,image->file);@     (void) fputc((char) targa_header.colormap_type,image->file);=     (void) fputc((char) targa_header.image_type,image->file); @     LSBFirstWriteShort(targa_header.colormap_index,image->file);A     LSBFirstWriteShort(targa_header.colormap_length,image->file); @     (void) fputc((char) targa_header.colormap_size,image->file);:     LSBFirstWriteShort(targa_header.x_origin,image->file);:     LSBFirstWriteShort(targa_header.y_origin,image->file);7     LSBFirstWriteShort(targa_header.width,image->file); 8     LSBFirstWriteShort(targa_header.height,image->file);=     (void) fputc((char) targa_header.pixel_size,image->file);a=     (void) fputc((char) targa_header.attributes,image->file);r$     if (targa_header.id_length != 0)N       (void) fwrite((char *) flopped_image->comments,1,targa_header.id_length,         image->file);d     /**       Convert MIFF to TARGA raster pixels.     */     count=(unsigned int)L       (targa_header.pixel_size*targa_header.width*targa_header.height) >> 3;B     if (flopped_image->compression == RunlengthEncodedCompression)       count+=(count/128)+1;nG     targa_pixels=(unsigned char *) malloc(count*sizeof(unsigned char));p/     if (targa_pixels == (unsigned char *) NULL) ?       PrematureExit("Unable to allocate memory",flopped_image);n7     p=flopped_image->pixels+(flopped_image->packets-1);i     q=targa_pixels; &     if (!IsPseudoClass(flopped_image))       {d
         /*8           Convert DirectClass packet to TARGA RGB pixel.
         */F         if (flopped_image->compression != RunlengthEncodedCompression)4           for (i=0; i < flopped_image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {d&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green);;%               *q++=DownScale(p->red);e'               if (flopped_image->matte)o)                 *q++=DownScale(p->index);d
             }l             p--;-             if (QuantumTick(i,flopped_image)) F               ProgressMonitor(SaveImageText,i,flopped_image->packets);           }e         else4           for (i=0; i < flopped_image->packets; i++)           {oH             for (runlength=p->length+1; runlength > 128; runlength-=128)
             {                *q++=0xff;&               *q++=DownScale(p->blue);'               *q++=DownScale(p->green);y%               *q++=DownScale(p->red); '               if (flopped_image->matte)o)                 *q++=DownScale(p->index);o
             }              r=q;$             *q++=0x80+(runlength-1);$             *q++=DownScale(p->blue);%             *q++=DownScale(p->green);i#             *q++=DownScale(p->red);*%             if (flopped_image->matte)e'               *q++=DownScale(p->index);s             if (runlength != 1)i               p--;             else               {e8                 for ( ; i < flopped_image->packets; i++)                 {y                   p--;=                   if ((p->length != 0) || (runlength == 128))c                     break;*                   *q++=DownScale(p->blue);+                   *q++=DownScale(p->green);n)                   *q++=DownScale(p->red);s+                   if (flopped_image->matte)m-                     *q++=DownScale(p->index);                    runlength++;                 }a                 *r=runlength-1;f               }a-             if (QuantumTick(i,flopped_image))oF               ProgressMonitor(SaveImageText,i,flopped_image->packets);           }l       }r     else,       if (!IsMonochromeImage(flopped_image))	         {e           unsigned charo             *targa_colormap;             /*@             Dump colormap to file (blue, green, red byte order).           */*           if (flopped_image->colors > 256)
             {r               QuantizeInfo                 quantize_info;  .               GetQuantizeInfo(&quantize_info);.               quantize_info.number_colors=256;6               quantize_info.dither=image_info->dither;:               QuantizeImage(&quantize_info,flopped_image);
             }v*           targa_colormap=(unsigned char *)I             malloc(3*targa_header.colormap_length*sizeof(unsigned char));s7           if (targa_colormap == (unsigned char *) NULL)mE             PrematureExit("Unable to allocate memory",flopped_image);t           q=targa_colormap;s3           for (i=0; i < flopped_image->colors; i++)n           {a<             *q++=DownScale(flopped_image->colormap[i].blue);=             *q++=DownScale(flopped_image->colormap[i].green); ;             *q++=DownScale(flopped_image->colormap[i].red);i           }a2           (void) fwrite((char *) targa_colormap,1,>             (int) 3*targa_header.colormap_length,image->file);(           free((char *) targa_colormap);           /*B             Convert PseudoClass packet to TARGA colormapped pixel.           */           q=targa_pixels;tH           if (flopped_image->compression != RunlengthEncodedCompression)6             for (i=0; i < flopped_image->packets; i++)
             {H4               for (j=0; j <= ((int) p->length); j++)                 *q++=p->index;               p--;/               if (QuantumTick(i,flopped_image))iH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }c           else6             for (i=0; i < flopped_image->packets; i++)
             { J               for (runlength=p->length+1; runlength > 128; runlength-=128)               {r                 *q++=0xff;                 *q++=p->index;               }v               r=q;&               *q++=0x80+(runlength-1);               *q++=p->index;!               if (runlength != 1)t                 p--;               else                 {a:                   for ( ; i < flopped_image->packets; i++)                   {t                     p--;?                     if ((p->length != 0) || (runlength == 128))f                       break;"                     *q++=p->index;                      runlength++;                   }b!                   *r=runlength-1;                  } /               if (QuantumTick(i,flopped_image))mH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             } 	         }t
       else	         {i           unsigned int             polarity;F             /*B             Convert PseudoClass image to a TARGA monochrome image.           */           polarity=0;r)           if (flopped_image->colors == 2) <             polarity=Intensity(flopped_image->colormap[0]) >4               Intensity(flopped_image->colormap[1]);H           if (flopped_image->compression != RunlengthEncodedCompression)6             for (i=0; i < flopped_image->packets; i++)
             {t4               for (j=0; j <= ((int) p->length); j++)B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);               p--;/               if (QuantumTick(i,flopped_image))iH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }F           else6             for (i=0; i < flopped_image->packets; i++)
             {pJ               for (runlength=p->length+1; runlength > 128; runlength-=128)               {g                 *q++=0xff;B                 *q++=p->index == polarity ? 0 : DownScale(MaxRGB);               }p               r=q;&               *q++=0x80+(runlength-1);@               *q++=p->index == polarity ? 0 : DownScale(MaxRGB);!               if (runlength != 1)f                 p--;               else                 { :                   for ( ; i < flopped_image->packets; i++)                   {o                     p--;?                     if ((p->length != 0) || (runlength == 128))t                       break;F                     *q++=p->index == polarity ? 0 : DownScale(MaxRGB);                      runlength++;                   };!                   *r=runlength-1;g                 }l/               if (QuantumTick(i,flopped_image))gH                 ProgressMonitor(SaveImageText,i,flopped_image->packets);
             }o	         }lN     (void) fwrite((char *) targa_pixels,1,(int) (q-targa_pixels),image->file);      DestroyImage(flopped_image);      free((char *) targa_pixels);&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);/   CloseImage(image);   return(True);. }, g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SO %                                                                             %.O %                                                                             %;O %                                                                             %SO %   W r i t e T E X T I m a g e                                               %rO %                                                                             % O %                                                                             %fO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- % C %  Function WriteTEXTImage writes an image in the TEXT image forma.i %x/ %  The format of the WriteTEXTImage routine is:  % . %      status=WriteTEXTImage(image_info,image) % + %  A description of each parameter follows.a %dK %    o status: Function WriteTEXTImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image filer %      fails to write. %,A %    o image_info: Specifies a pointer to an ImageInfo structure.r %s. %    o image:  A pointer to a Image structure. %  %e */L static unsigned int WriteTEXTImage(const ImageInfo *image_info,Image *image) {n   unsigned int     status;   6   Warning("Cannot write TEXT images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);d }D S #ifdef HasTIFF /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %=O %                                                                             %lO %                                                                             %_O %   W r i t e T I F F I m a g e                                               % O %                                                                             %eO %                                                                             % O %                                                                             %;O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % K %  Function WriteTIFFImage writes an image in the Tagged image file format.% %%/ %  The format of the WriteTIFFImage routine is:  % . %      status=WriteTIFFImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L static unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) {  #ifndef TIFFDefaultStripSizeM #define TIFFDefaultStripSize(tiff,request)  ((8*1024)/TIFFScanlineSize(tiff))% #endif     Image      encode_image,i     *next_image;     inti
     flags,     sans_offset;     register RunlengthPacket     *p;      register int     i,     j,     x,     y;     register unsigned char     *q;m     TIFF
     *tiff;     uint16     compression,
     pages,     photometric;     unsigned char      *scanline;     unsigned int     x_resolution,o     y_resolution;a     unsigned short
     units,
     value;     /*     Open TIFF file.n   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);*.   if ((image->file != stdout) && !image->pipe)#     (void) remove(image->filename);    else     {a       /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);%       image->temporary=True;     }%   CloseImage(image);1   tiff=TIFFOpen(image->filename,WriteBinaryType);    if (tiff == (TIFF *) NULL)     return(False);   next_image=image; 6   for (pages=0; next_image != (Image *) NULL; pages++)      next_image=next_image->next;   do   {      /*       Initialize TIFF fields.      */@     TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,(uint32) image->rows);B     TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,(uint32) image->columns);/     TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);      if (image->depth == 16) 2       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);      compression=COMPRESSION_LZW;     if (!image->matte)#       if (IsMonochromeImage(image))%	         { ,           compression=COMPRESSION_CCITTFAX4;5           TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);)	         }r/     image->compression=image_info->compression;s,     if (image->compression == NoCompression)#       compression=COMPRESSION_NONE;o7     TIFFSetField(tiff,TIFFTAG_COMPRESSION,compression);u5     if (!IsPseudoClass(image) && !IsGrayImage(image))        {a
         /*!           Full color TIFF raster.f
         */$         photometric=PHOTOMETRIC_RGB;J         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));         if (image->matte)            {N             uint16               extra_samples,               sample_info[1];N               /*'               TIFF has a matte channel.r             */             extra_samples=1;2             sample_info[0]=EXTRASAMPLE_ASSOCALPHA;O             TIFFSetField(tiff,TIFFTAG_EXTRASAMPLES,extra_samples,&sample_info);f           }u       }o     else       { 
         /*"           Colormapped TIFF raster.
         */(         photometric=PHOTOMETRIC_PALETTE;5         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1);n         if (IsGrayImage(image))g           {              /*$               Grayscale TIFF raster.             *//             photometric=PHOTOMETRIC_MINISBLACK;n)             if (IsMonochromeImage(image))                {i3                 photometric=PHOTOMETRIC_MINISWHITE;n;                 TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);                }a           }/       }m7     TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric); ;     TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB);m?     TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT);c@     TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);8     TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,image->rows);'     if (photometric == PHOTOMETRIC_RGB),6       if ((image_info->interlace == PlaneInterlace) ||8           (image_info->interlace == PartitionInterlace))F         TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_SEPARATE);     flags=NoValue;-     if (image_info->density != (char *) NULL)aI       flags=XParseGeometry(image_info->density,&sans_offset,&sans_offset,)%         &x_resolution,&y_resolution);a     if (flags & WidthValue)e'       image->x_resolution=x_resolution;      if (flags & HeightValue)'       image->y_resolution=y_resolution;c     units=RESUNIT_NONE;_0     if (image->units == PixelsPerInchResolution)       units=RESUNIT_INCH; 6     if (image->units == PixelsPerCentimeterResolution)       units=RESUNIT_CENTIMETER;/E     if ((image->x_resolution == 0.0) || (image->y_resolution == 0.0))B       {E         units=RESUNIT_NONE;i+         image->x_resolution=image->columns;w(         image->y_resolution=image->rows;       }f=     TIFFSetField(tiff,TIFFTAG_RESOLUTIONUNIT,(uint16) units);O?     TIFFSetField(tiff,TIFFTAG_XRESOLUTION,image->x_resolution);i?     TIFFSetField(tiff,TIFFTAG_YRESOLUTION,image->y_resolution); <     TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);0     TIFFSetField(tiff,TIFFTAG_SOFTWARE,Version);     if (pages > 1)P       TIFFSetField(tiff,TIFFTAG_PAGENUMBER,(unsigned short) image->scene,pages);&     if (image->label != (char *) NULL)7       TIFFSetField(tiff,TIFFTAG_PAGENAME,image->label);_)     if (image->comments != (char *) NULL)nB       TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);     /*       Write image scanlines.     */>     scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));+     if (scanline == (unsigned char *) NULL)i7       PrematureExit("Unable to allocate memory",image);r     p=image->pixels;     q=scanline;d     x=0;     y=0;'     if (photometric == PHOTOMETRIC_RGB)-$       switch (image_info->interlace)       {n         case NoneInterlace:g         default:	         {i,           for (i=0; i < image->packets; i++)           {)2             for (j=0; j <= ((int) p->length); j++)
             {u               /*H                 Convert DirectClass packets to contiguous RGB scanlines.               */%               WriteQuantum(p->red,q);n'               WriteQuantum(p->green,q); &               WriteQuantum(p->blue,q);               if (image->matte)x)                 WriteQuantum(p->index,q);&               x++;&               if (x == image->columns)                 { H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;N                   x=0;                   y++;                 }g
             }l             p++;%             if (QuantumTick(i,image))p>               ProgressMonitor(SaveImageText,i,image->packets);           }-           break;	         }(         case PlaneInterlace:          case PartitionInterlace:	         {I           /*;             Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...            */           p=image->pixels;,           for (i=0; i < image->packets; i++)           {*2             for (j=0; j <= ((int) p->length); j++)
             {+%               WriteQuantum(p->red,q);d               x++;&               if (x == image->columns)                 {iH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 } 
             }a             p++;           }g1           ProgressMonitor(SaveImageText,100,400);            p=image->pixels;           y=0;,           for (i=0; i < image->packets; i++)           {l2             for (j=0; j <= ((int) p->length); j++)
             {)'               WriteQuantum(p->green,q);g               x++;&               if (x == image->columns)                 { H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,1) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 };
             }g             p++;           }e1           ProgressMonitor(SaveImageText,200,400);g           p=image->pixels;           y=0;,           for (i=0; i < image->packets; i++)           {-2             for (j=0; j <= ((int) p->length); j++)
             { &               WriteQuantum(p->blue,q);               x++;&               if (x == image->columns)                 {iH                   if (TIFFWriteScanline(tiff,(char *) scanline,y,2) < 0)                     break;                   q=scanline;s                   x=0;                   y++;                 }t
             })             p++;           }m1           ProgressMonitor(SaveImageText,300,400);i           p=image->pixels;           y=0;           if (image->matte)n.             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               { )                 WriteQuantum(p->index,q);                  x++;(                 if (x == image->columns)                   { J                     if (TIFFWriteScanline(tiff,(char *) scanline,y,3) < 0)                       break;                     q=scanline;M                     x=0;                     y++;                   }                }b               p++;
             }(1           ProgressMonitor(SaveImageText,400,400);e           break;	         }        }f     else-       if (photometric == PHOTOMETRIC_PALETTE)a	         {o           unsigned short             *blue,             *green,e             *red;o             /*#             Allocate TIFF colormap.            */O           blue=(unsigned short *) malloc(image->colors*sizeof(unsigned short)); P           green=(unsigned short *) malloc(image->colors*sizeof(unsigned short));N           red=(unsigned short *) malloc(image->colors*sizeof(unsigned short));2           if ((blue == (unsigned short *) NULL) ||3               (green == (unsigned short *) NULL) ||i/               (red == (unsigned short *) NULL))g=             PrematureExit("Unable to allocate memory",image);o           /*%             Initialize TIFF colormap.            */+           for (i=0; i < image->colors; i++)p           {nI             red[i]=(unsigned int) (image->colormap[i].red*65535L)/MaxRGB;nM             green[i]=(unsigned int) (image->colormap[i].green*65535L)/MaxRGB; K             blue[i]=(unsigned int) (image->colormap[i].blue*65535L)/MaxRGB;t           };=           TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);            /*H             Convert PseudoClass packets to contiguous indexed scanlines.           */,           for (i=0; i < image->packets; i++)           {a2             for (j=0; j <= ((int) p->length); j++)
             {a'               WriteQuantum(p->index,q);c               x++;&               if (x == image->columns)                 { H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 };
             }%             p++;%             if (QuantumTick(i,image))p>               ProgressMonitor(SaveImageText,i,image->packets);           }            free((char *) red);            free((char *) green);i           free((char *) blue);	         } 
       else         if (image->colors > 2),           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                /*N                 Convert PseudoClass packets to contiguous grayscale scanlines.               */,               WriteQuantum(Intensity(*p),q);               x++;&               if (x == image->columns)                 { H                   if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                     break;                   q=scanline;                    x=0;                   y++;                 }s
             }g             p++;%             if (QuantumTick(i,image))(>               ProgressMonitor(SaveImageText,i,image->packets);           }m         else           {t"             register unsigned char               bit,               byte,                polarity;                /*M               Convert PseudoClass packets to contiguous monochrome scanlines.>             */             polarity=0; #             if (image->colors == 2)x8               if (photometric == PHOTOMETRIC_MINISBLACK)                 polarity=_P                   Intensity(image->colormap[0]) < Intensity(image->colormap[1]);               else                 polarity=iP                   Intensity(image->colormap[0]) > Intensity(image->colormap[1]);             bit=0;             byte=0;              x=0;.             for (i=0; i < image->packets; i++)
             {f4               for (j=0; j <= ((int) p->length); j++)               {t                 byte<<=1;t)                 if (p->index == polarity)                    byte|=0x01;_                 bit++;                 if (bit == 8)e                   {s                     *q++=byte;                     bit=0;                     byte=0;p                   }                  x++;(                 if (x == image->columns)                   {e                     /*3                       Advance to the next scanline.g                     */!                     if (bit != 0)t+                       *q++=byte << (8-bit);aJ                     if (TIFFWriteScanline(tiff,(char *) scanline,y,0) < 0)                       break;                     q=scanline;%                     bit=0;                     byte=0;                      x=0;                     y++;                  }               }                p++;'               if (QuantumTick(i,image)) @                 ProgressMonitor(SaveImageText,i,image->packets);
             }            }      free((char *) scanline);$     if (image_info->verbose == True),       TIFFPrintDirectory(tiff,stderr,False);     TIFFWriteDirectory(tiff); &     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    (void) TIFFClose(tiff);%   if (image->temporary)%     {%
       FILE         *file;  	       int_
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);:        if (file == (FILE *) NULL)3         PrematureExit("Unable to open file",image);m       c=fgetc(file);       while (c != EOF)       {g)         (void) putc(c,encode_image.file);          c=fgetc(file);       }a       (void) fclose(file);%       (void) remove(image->filename);         CloseImage(&encode_image);     }    return(True);c }e #else L static unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) {r   unsigned int     status;i  ;   Warning("TIFF library is not available",image->filename);i*   status=WriteMIFFImage(image_info,image);   return(status);; }  #endif c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %mO %   W r i t e T I L E I m a g e                                               %iO %                                                                             % O %                                                                             %MO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nL %  Function WriteTILEImage writes an image in the TILE encoded image format. %;/ %  The format of the WriteTILEImage routine is:r %c. %      status=WriteTILEImage(image_info,image) %e+ %  A description of each parameter follows.  % K %    o status: Function WriteTILEImage return True if the image is written.eK %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %f. %    o image:  A pointer to a Image structure. %> %x */L static unsigned int WriteTILEImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   6   Warning("Cannot write TILE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);m }'   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %BO %                                                                             %mO %   W r i t e U Y V Y I m a g e                                               % O %                                                                             %eO %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteUYVYImage writes an image to a file in the digital UYVYL %  (16bit/pixel) format.  This format, used by AccomWSD, is not dramaticallyK %  higher quality than the 12bit/pixel YUV format, but has better locality.  %i/ %  The format of the WriteUYVYImage routine is:  %v. %      status=WriteUYVYImage(image_info,image) %)+ %  A description of each parameter follows., %gK %    o status: Function WriteUYVYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image filee %      fails to write. %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %v. %    o image:  A pointer to a Image structure.6 %      Implicit assumption: number of columns is even. %o */L static unsigned int WriteUYVYImage(const ImageInfo *image_info,Image *image) {    register int     i,     j;     register RunlengthPacket     *p;j     unsigned int	     full,+     y,     u,     v;     /*     Open output image file."   */   if (!UncompressImage(image))     return(False);.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*'     Convert to YUV, at full resolution.g   */+   RGBTransformImage(image,YCbCrColorspace);m   /*'     Accumulate two pixels, then output.    */
   full=False;    u=0;   v=0;   y=0;
   full=False;r
   full=False;M   p=image->pixels;$   for (i=0; i < image->packets; i++)   {,*     for (j=0; j <= ((int) p->length); j++)     {)       if (full) 	         {jA           (void) fputc(DownScale((u+p->green) >> 1),image->file);f1           (void) fputc(DownScale(y),image->file);;@           (void) fputc(DownScale((v+p->blue) >> 1),image->file);6           (void) fputc(DownScale(p->red),image->file);           full=False; 	         } 
       else	         {(           y=p->red;m           u=p->green;o           v=p->blue;           full=True;	         }      }a     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   } +   TransformRGBImage(image,YCbCrColorspace);,   CloseImage(image);   return(True);p }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %nO %                                                                             % O %   W r i t e V I C A R I m a g e                                             %eO %                                                                             %'O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i % K %  Function WriteVICARImage writes an image in the VICAR rasterfile format. N %  Vicar files contain a text header, followed by one or more planes of binaryM %  grayscale image data.  Vicar files are designed to allow many planes to be K %  stacked together to form image cubes.  This routine only writes a single  %  grayscale plane.  % 6 %  Function WriteVICARImage was written contributed by %  gorelick@esther.la.asu.edu. %,0 %  The format of the WriteVICARImage routine is: % / %      status=WriteVICARImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filet %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.= % . %    o image:  A pointer to a Image structure. %  %  */M static unsigned int WriteVICARImage(const ImageInfo *image_info,Image *image)e {;   char     header[MaxTextExtent],     label[16];     int      label_size;      register int     i,     j;     register RunlengthPacket     *p;n     /*     Open output image file.B   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)t/     PrematureExit("Unable to open file",image);S   /*     Make a header.   */K   (void) sprintf(header,"LBLSIZE=            FORMAT='BYTE'  TYPE='IMAGE'");(H   (void) sprintf(header+Extent(header),"  BUFSIZE=20000  DIM=2  EOL=0");'   (void) sprintf(header+Extent(header), M     "  RECSIZE=%u  ORG='BSQ'  NL=%u  NS=%u  NB=1",image->columns,image->rows,>     image->columns);'   (void) sprintf(header+Extent(header),p.     "  N1=0  N2=0  N3=0  N4=0  NBB=0  NLB=0");?   (void) sprintf(header+Extent(header),"  TASK='ImageMagick'");c   /*"     Compute the size of the label.   */M   label_size=(Extent(header)+image->columns-1)/image->columns*image->columns;e(   (void) sprintf(label,"%d",label_size);$   for (i=0 ; i < Extent(label); i++)     header[i+8]=label[i];r   /*<     Print the header and enough spaces to pad to label size.   */8   (void) fprintf(image->file, "%-*s",label_size,header);   /*(     Convert MIFF to VICAR raster pixels.   */*   RGBTransformImage(image,GRAYColorspace);   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)'       (void) fputc(p->red,image->file);      p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e V I F F I m a g e                                               % O %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteVIFFImage writes an image to a file in the VIFF image format. %m/ %  The format of the WriteVIFFImage routine is:P %I. %      status=WriteVIFFImage(image_info,image) % + %  A description of each parameter follows.a %oK %    o status: Function WriteVIFFImage return True if the image is written.sK %      False is returned is there is a memory shortage or if the image fileg %      fails to write. %tA %    o image_info: Specifies a pointer to an ImageInfo structure.  %g. %    o image:  A pointer to a Image structure. %v %I */L static unsigned int WriteVIFFImage(const ImageInfo *image_info,Image *image) {  #define VFF_CM_genericRGB  15  #define VFF_CM_NONE  0 #define VFF_DEP_IEEEORDER  0x2 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1m #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1      typedef struct _ViffHeader   {i     char       identifier,        file_type,       release,       version,       machine_dependency,s       reserve[3],        comment[512];t       unsigned longu       rows,        columns,       subrows;       long       x_offset,        y_offset;        unsigned int       x_pixel_size,a       y_pixel_size;g       unsigned longt       location_type,       location_dimension,l       number_of_images,i       number_data_bands,       data_storage_type,       data_encode_scheme,g       map_scheme,t       map_storage_type,m       map_rows,g       map_columns,       map_subrows,       map_enable,        maps_per_cycle,m       color_space_model;   } ViffHeader;a     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;g     unsigned char      buffer[8],     *viff_pixels;r     unsigned long.     packets;     ViffHeader     viff_header;     /*     Open output image file.0   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)r/     PrematureExit("Unable to open file",image);>   do   {l     /*&       Initialize VIFF image structure.     */'     viff_header.identifier=(char) 0xab;o     viff_header.file_type=1;     viff_header.release=1;     viff_header.version=3;O     viff_header.machine_dependency=VFF_DEP_IEEEORDER;  /* IEEE byte ordering */g     *viff_header.comment='\0';)     if (image->comments != (char *) NULL)        {I;         (void) strncpy(viff_header.comment,image->comments,e,           Min(Extent(image->comments),511));C         viff_header.comment[Min(Extent(image->comments),511)]='\0';        }a$     viff_header.rows=image->columns;$     viff_header.columns=image->rows;     viff_header.subrows=0;     viff_header.x_offset=(~0);     viff_header.y_offset=(~0);     viff_header.x_pixel_size=0;c     viff_header.y_pixel_size=0;c/     viff_header.location_type=VFF_LOC_IMPLICIT; %     viff_header.location_dimension=0;e#     viff_header.number_of_images=1; /     viff_header.data_encode_scheme=VFF_DES_RAW;,'     viff_header.map_scheme=VFF_MS_NONE;b1     viff_header.map_storage_type=VFF_MAPTYP_NONE;s     viff_header.map_rows=0;+     viff_header.map_columns=0;     viff_header.map_subrows=0;0     viff_header.map_enable=1;  /* no colormap */!     viff_header.maps_per_cycle=0; 5     if (!IsPseudoClass(image) && !IsGrayImage(image))e       {e
         /*!           Full color VIFF raster.c
         */;         viff_header.number_data_bands=image->matte ? 4 : 3; 8         viff_header.color_space_model=VFF_CM_genericRGB;5         viff_header.data_storage_type=VFF_TYP_1_BYTE;:I         packets=image->columns*image->rows*viff_header.number_data_bands;        }i     else       {o(         viff_header.number_data_bands=1;2         viff_header.color_space_model=VFF_CM_NONE;5         viff_header.data_storage_type=VFF_TYP_1_BYTE;w+         packets=image->columns*image->rows;0          if (!IsGrayImage(image))           {n             /*&               Colormapped VIFF raster.             */5             viff_header.map_scheme=VFF_MS_ONEPERBAND; ;             viff_header.map_storage_type=VFF_MAPTYP_1_BYTE;)#             viff_header.map_rows=3;.2             viff_header.map_columns=image->colors;           }          else!           if (image->colors == 2)s
             {;               /*'                 Monochrome VIFF raster.                */8               viff_header.data_storage_type=VFF_TYP_BIT;<               packets=((image->columns+7) >> 3)*image->rows;
             }a       }      /*2       Write VIFF image header (pad to 1024 bytes).     */%     buffer[0]=viff_header.identifier; $     buffer[1]=viff_header.file_type;"     buffer[2]=viff_header.release;"     buffer[3]=viff_header.version;-     buffer[4]=viff_header.machine_dependency; %     buffer[5]=viff_header.reserve[0];=%     buffer[6]=viff_header.reserve[1];"%     buffer[7]=viff_header.reserve[2];a3     (void) fwrite((char *) buffer,1,8,image->file);aB     (void) fwrite((char *) viff_header.comment,1,512,image->file);4     MSBFirstWriteLong(viff_header.rows,image->file);7     MSBFirstWriteLong(viff_header.columns,image->file);p7     MSBFirstWriteLong(viff_header.subrows,image->file);sH     MSBFirstWriteLong((unsigned long) viff_header.x_offset,image->file);H     MSBFirstWriteLong((unsigned long) viff_header.y_offset,image->file);L     MSBFirstWriteLong((unsigned long) viff_header.x_pixel_size,image->file);L     MSBFirstWriteLong((unsigned long) viff_header.y_pixel_size,image->file);=     MSBFirstWriteLong(viff_header.location_type,image->file); B     MSBFirstWriteLong(viff_header.location_dimension,image->file);@     MSBFirstWriteLong(viff_header.number_of_images,image->file);A     MSBFirstWriteLong(viff_header.number_data_bands,image->file);xA     MSBFirstWriteLong(viff_header.data_storage_type,image->file);iB     MSBFirstWriteLong(viff_header.data_encode_scheme,image->file);:     MSBFirstWriteLong(viff_header.map_scheme,image->file);@     MSBFirstWriteLong(viff_header.map_storage_type,image->file);8     MSBFirstWriteLong(viff_header.map_rows,image->file);;     MSBFirstWriteLong(viff_header.map_columns,image->file);r;     MSBFirstWriteLong(viff_header.map_subrows,image->file);k:     MSBFirstWriteLong(viff_header.map_enable,image->file);>     MSBFirstWriteLong(viff_header.maps_per_cycle,image->file);A     MSBFirstWriteLong(viff_header.color_space_model,image->file);;     for (i=0; i < 420; i++) %       (void) fputc('\0',image->file);f     /*)       Convert MIFF to VIFF raster pixels.      */H     viff_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);      p=image->pixels;     q=viff_pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))a       {          unsigned longi           offset;   
         /*7           Convert DirectClass packet to VIFF RGB pixel.r
         */*         offset=image->columns*image->rows;*         for (i=0; i < image->packets; i++)	         { 0           for (j=0; j <= ((int) p->length); j++)           { !             *q=DownScale(p->red);n,             *(q+offset)=DownScale(p->green);-             *(q+offset*2)=DownScale(p->blue);              if (image->matte)d0               *(q+offset*3)=DownScale(p->index);             q++;           }            p++;#           if (QuantumTick(i,image)) <             ProgressMonitor(SaveImageText,i,image->packets);	         }r       }l     else       if (!IsGrayImage(image))	         {"           unsigned char+             *viff_colormap;              /*"             Dump colormap to file.           */)           viff_colormap=(unsigned char *)f:             malloc(image->colors*3*sizeof(unsigned char));6           if (viff_colormap == (unsigned char *) NULL)=             PrematureExit("Unable to allocate memory",image);i           q=viff_colormap;+           for (i=0; i < image->colors; i++)l3             *q++=DownScale(image->colormap[i].red);s+           for (i=0; i < image->colors; i++) 5             *q++=DownScale(image->colormap[i].green); +           for (i=0; i < image->colors; i++) 4             *q++=DownScale(image->colormap[i].blue);G           (void) fwrite((char *) viff_colormap,1,(int) image->colors*3,e             image->file);r'           free((char *) viff_colormap);            /*B             Convert PseudoClass packet to VIFF colormapped pixels.           */           q=viff_pixels;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)               *q++=p->index;             p++;%             if (QuantumTick(i,image))o>               ProgressMonitor(SaveImageText,i,image->packets);           } 	         } 
       else         if (image->colors == 2)o           { "             register unsigned char               bit,               byte,c               polarity;s               register int               x;               /*C               Convert PseudoClass image to a VIFF monochrome image.              */             polarity=,L               Intensity(image->colormap[0]) > Intensity(image->colormap[1]);             x=0;             bit=0;             byte=0; .             for (i=0; i < image->packets; i++)
             { 4               for (j=0; j <= ((int) p->length); j++)               {g                 byte>>=1;o)                 if (p->index == polarity)                    byte|=0x80;w                 bit++;                 if (bit == 8)                    {f                     *q++=byte;                     bit=0;                     byte=0;f                   };                 x++;(                 if (x == image->columns)                   {o                     /*3                       Advance to the next scanline.o                     */!                     if (bit != 0)n+                       *q++=byte >> (8-bit);                      bit=0;                     byte=0;+                     x=0;                  }               }i               p++;'               if (QuantumTick(i,image))i@                 ProgressMonitor(SaveImageText,i,image->packets);
             }            }e         else           {t             /*A               Convert PseudoClass packet to VIFF grayscale pixel.e             */.             for (i=0; i < image->packets; i++)
             {B4               for (j=0; j <= ((int) p->length); j++)                 *q++=p->red;               p++;'               if (QuantumTick(i,image))f@                 ProgressMonitor(SaveImageText,i,image->packets);
             }i           }aD     (void) fwrite((char *) viff_pixels,1,(int) packets,image->file);     free((char *) viff_pixels);;&     if (image->next == (Image *) NULL)       break;"     image->next->file=image->file;     image=image->next;   } while (image_info->adjoin);    CloseImage(image);   return(True);s }c a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %eO %                                                                             %eO %                                                                             %aO %   W r i t e X I m a g e                                                     %;O %                                                                             %tO %                                                                             %oO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %m7 %  Function WriteXImage writes an image to an X server.e %f, %  The format of the WriteXImage routine is: %a+ %      status=WriteXImage(image_info,image)t %e+ %  A description of each parameter follows.  % L %    o status: Function WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or ifs% %      the image file fails to write.i %)A %    o image_info: Specifies a pointer to an ImageInfo structure.P %i. %    o image:  A pointer to a Image structure. %n %, */I static unsigned int WriteXImage(const ImageInfo *image_info,Image *image)i {,   Atom     wm_delete_window,      wm_protocols;a     char     name[MaxTextExtent];  	   DisplayN
     *display;t     register chara     *p;e     unsigned int     status;m     Window     root_window;     XGCValues      context_values;e     XResourceInfo      resource_info;  
   XrmDatabase)     resource_database;     XEvent
     event;     XPixelInfo     pixel_info;c     XStandardColormap      *map_info;  
   XVisualInfoi     *visual_info;   
   XWindowInfod     window_info;     /*     Open X server connection.i   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return(False);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    /*     Initialize visual info.    */?   visual_info=XBestVisualInfo(display,map_info,&resource_info);%*   if (visual_info == (XVisualInfo *) NULL)>     Warning("Unable to get visual",resource_info.visual_type);%   map_info->colormap=(Colormap) NULL;y+   pixel_info.pixels=(unsigned long *) NULL;s'   pixel_info.gamma_map=(XColor *) NULL;s1   if ((map_info == (XStandardColormap *) NULL) ||T,       (visual_info == (XVisualInfo *) NULL))     { >       XFreeResources(display,visual_info,map_info,&pixel_info,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }u   /*!     Initialize Standard Colormap.o   */)   ProgressMonitor(SaveImageText,100,400);pJ   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);    /*%     Initialize window info structure./   */   window_info.id=(Window) NULL;tO   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);%   window_info.name=name;.   p=image->filename+Extent(image->filename)-1;A   while ((p > image->filename) && (*(p-1) != *BasenameSeparator))w     p--;;   (void) sprintf(window_info.name,"%s[%u]",p,image->scene);u   if (image->scene == 0),     (void) sprintf(window_info.name,"%s",p);#   window_info.width=image->columns;8!   window_info.height=image->rows;/C   window_info.attributes.event_mask=ButtonPressMask | ExposureMask;cP   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);;   root_window=XRootWindow(display,XDefaultScreen(display));a;   XSetTransientForHint(display,window_info.id,root_window);n   window_info.x=0;   window_info.y=0;"   window_info.shared_memory=False;   /*     Graphic context.   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)e<     Error("Unable to create graphic context",(char *) NULL);;   window_info.annotate_context=pixel_info.annotate_context;D>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;N   pixel_info.highlight_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL){<     Error("Unable to create graphic context",(char *) NULL);=   window_info.highlight_context=pixel_info.highlight_context;"&   pixel_info.widget_context=(GC) NULL;'   window_info.widget_context=(GC) NULL;    /*     Initialize X image.D   */)   ProgressMonitor(SaveImageText,250,400); M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,      image->rows);    if (status == False)     { >       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);4       PrematureExit("Unable to make X image",image);     } !   free(window_info.ximage->data); )   window_info.ximage->data=(char *) NULL;r   /*4     Display image and wait for button press to exit.   */)   ProgressMonitor(SaveImageText,400,400); 9   wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False); A   wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False); %   XMapWindow(display,window_info.id); 
   for ( ; ; )    {      XNextEvent(display,&event);t"     if (event.type == ButtonPress)       break;$     if (event.type == ClientMessage)5       if (event.xclient.message_type == wm_protocols),6         if (*event.xclient.data.l == wm_delete_window)5           if (event.xclient.window == window_info.id)              break;     if (event.type == Expose)l2       XRefreshWindow(display,&window_info,&event);   }P=   XWithdrawWindow(display,window_info.id,window_info.screen);    /*     Free X resources.    */O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);    return(True);c }e i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %uO %                                                                             %.O %                                                                             %sO %   W r i t e X B M I m a g e                                                 % O %                                                                             %bO %                                                                             %bO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %/L %  Procedure WriteXBMImage writes an image to a file in the X bitmap format. %e. %  The format of the WriteXBMImage routine is: % - %      status=WriteXBMImage(image_info,image)  %%+ %  A description of each parameter follows.  %oJ %    o status: Function WriteXBMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.l % . %    o image:  A pointer to a Image structure. %e %i */K static unsigned int WriteXBMImage(const ImageInfo *image_info,Image *image)f {    char     name[MaxTextExtent];     register int     i,     j,     x;     register charc     *q;e     register RunlengthPacket     *p;      register unsigned char     bit,	     byte, 
     polarity;      unsigned int
     count;     /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)%/     PrematureExit("Unable to open file",image);    /*     Write X bitmap header.   */&   (void) strcpy(name,image->filename);	   q=name;,%   while ((*q != '.') && (*q != '\0'))      q++;   if (*q == '.')     *q='\0';J   (void) fprintf(image->file,"#define %s_width %u\n",name,image->columns);H   (void) fprintf(image->file,"#define %s_height %u\n",name,image->rows);A   (void) fprintf(image->file,"static char %s_bits[] = {\n",name); "   (void) fprintf(image->file," ");   /*$     Convert MIFF to X bitmap pixels.   */    if (!IsMonochromeImage(image))     {        QuantizeInfo         quantize_info;  &       GetQuantizeInfo(&quantize_info);$       quantize_info.number_colors=2;.       quantize_info.dither=image_info->dither;.       quantize_info.colorspace=GRAYColorspace;*       QuantizeImage(&quantize_info,image);       SyncImage(image);      }"
   polarity=0;/   if (image->colors == 2),K     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);d   bit=0;	   byte=0;"
   count=0;   x=0;   p=image->pixels;"   (void) fprintf(image->file," ");$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {d       byte>>=1;l       if (p->index == polarity),         byte|=0x80;        bit++;       if (bit == 8)o	         {a           /*2             Write a bitmap byte to the image file.           */N           (void) fprintf(image->file,"0x%02x, ",(unsigned int) (byte & 0xff));           count++;           if (count == 12)
             {a1               (void) fprintf(image->file,"\n  ");                count=0;             };           bit=0;           byte=0; 	         } 
       x++;       if (x == image->columns)	         {            if (bit != 0)m
             {                /*6                 Write a bitmap byte to the image file.               */               byte>>=(8-bit); B               (void) fprintf(image->file,"0x%02x, ",(unsigned int)                 (byte & 0xff));                count++;               if (count == 12)                 { 5                   (void) fprintf(image->file,"\n  ");g                   count=0;                 };               bit=0;               byte=0;              };           x=0;	         }t     }e     p++;     if (QuantumTick(i,image))p6       ProgressMonitor(SaveImageText,i,image->packets);   } %   (void) fprintf(image->file,"};\n");f   CloseImage(image);   return(True);/ }n z /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %,O %                                                                             % O %                                                                             %pO %   W r i t e X C I m a g e                                                   % O %                                                                             %lO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %mH %  Function WriteXCImage writes an image in the X constant image format. %e- %  The format of the WriteXCImage routine is:e % , %      status=WriteXCImage(image_info,image) %,+ %  A description of each parameter follows.  %eI %    o status: Function WriteXCImage return True if the image is written.tK %      False is returned is there is a memory shortage or if the image file( %      fails to write. %LA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %p %a */J static unsigned int WriteXCImage(const ImageInfo *image_info,Image *image) {s   unsigned int     status;b  4   Warning("Cannot write XC images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);p }a i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %aO %                                                                             % O %                                                                             % O %   W r i t e X P M I m a g e                                                 %lO %                                                                             %(O %                                                                             %&O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %dL %  Procedure WriteXPMImage writes an image to a file in the X pixmap format. % . %  The format of the WriteXPMImage routine is: % - %      status=WriteXPMImage(image_info,image)/ %t+ %  A description of each parameter follows.a %hJ %    o status: Function WriteXPMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filea %      fails to write. %DA %    o image_info: Specifies a pointer to an ImageInfo structure.X %u. %    o image:  A pointer to a Image structure. %  %e */K static unsigned int WriteXPMImage(const ImageInfo *image_info,Image *image)i {+ #define MaxCixels  92   
   static charnI     Cixel[MaxCixels+1] = " .XoO+@#$%&*=-;:>,<1234567890qwertyuipasdfghjk"aJ                          "lzxcvbnmMNBVCZASDFGHJKLPIUYTREWQ!~^/()_`'][{}|";     char     name[MaxTextExtent],     symbol[MaxTextExtent];     double     distance_squared,      min_distance;0     int 
     distance,a     j,     k,     y;     register int     i,     x;     register RunlengthPacket     *p;      register XColorlist      *q;t     unsigned int     characters_per_pixel,)     colors,t     transparent;     /*     Open output image file."   */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL)=/     PrematureExit("Unable to open file",image);&   transparent=False;"   if (image->class == PseudoClass)     {t       CompressColormap(image);       colors=image->colors;l     }0   else     {t       QuantizeInfo         quantize_info;         unsigned charf         *matte_image;          /*1         Convert DirectClass to PseudoClass image.        */)       matte_image=(unsigned char *) NULL;        if (image->matte)e	         {P           /*+             Map all the transparent pixels.a           */&           if (!UncompressImage(image))             return(False);'           matte_image=(unsigned char *)i9             malloc(image->packets*sizeof(unsigned char));;4           if (matte_image == (unsigned char *) NULL)
             {eA               Warning("Memory allocation error",image->filename);n               return(False);
             }e           p=image->pixels;,           for (i=0; i < image->packets; i++)           {b3             matte_image[i]=p->index == Transparent;              if (matte_image[i])i               transparent=True;m             p++;           }t	         }*&       GetQuantizeInfo(&quantize_info);.       quantize_info.dither=image_info->dither;*       QuantizeImage(&quantize_info,image);       SyncImage(image);        CompressColormap(image);       colors=image->colors;b       if (transparent)	         {f&           if (!UncompressImage(image))             return(False);           colors++;%           p=image->pixels;,           for (i=0; i < image->packets; i++)           {e             if (matte_image[i])i%               p->index=image->colors;i             p++;           } 	         }(0       if (matte_image != (unsigned char *) NULL)#         free((char *) matte_image);:     }g   /*$     Compute the character per pixel.   */   characters_per_pixel=1; -   for (k=MaxCixels; colors > k; k*=MaxCixels);     characters_per_pixel++;    /*     XPM header.o   */,   (void) fprintf(image->file,"/* XPM */\n");<   (void) fprintf(image->file,"static char *magick[] = {\n");L   (void) fprintf(image->file,"/* columns rows colors chars-per-pixel */\n");A   (void) fprintf(image->file,"\"%u %u %u %d\",\n",image->columns,g-     image->rows,colors,characters_per_pixel);    for (i=0; i < colors; i++)   {a     ColorPacketx	       *p;        /*       Define XPM color.      */     p=image->colormap+i;@     (void) sprintf(name,"#%02x%02x%02x%c",(unsigned int) p->red,;       (unsigned int) p->green,(unsigned int) p->blue,'\0');i     if (QuantumDepth > 8)uB       (void) sprintf(name,"#%04x%04x%04x%c",(unsigned int) p->red,=         (unsigned int) p->green,(unsigned int) p->blue,'\0');t%     min_distance=3.0*65536.0*65536.0;-7     for (q=XPMColorlist; q->name != (char *) NULL; q++)      { 4       distance=(int) DownScale(p->red)-(int) q->red;:       distance_squared=(unsigned int) (distance*distance);8       distance=(int) DownScale(p->green)-(int) q->green;;       distance_squared+=(unsigned int) (distance*distance);=6       distance=(int) DownScale(p->blue)-(int) q->blue;;       distance_squared+=(unsigned int) (distance*distance);g*       if (distance_squared < min_distance)	         {p(           min_distance=distance_squared;"           if (min_distance == 0.0)(             (void) strcpy(name,q->name);	         }      }u     if (transparent)       if (i == (colors-1))#         (void) strcpy(name,"None");i     /*       Write XPM color.     */     k=i % MaxCixels;     symbol[0]=Cixel[k]; ,     for (j=1; j < characters_per_pixel; j++)     { &       k=((i-k)/MaxCixels) % MaxCixels;       symbol[j]=Cixel[k];      }      symbol[j]='\0';m=     (void) fprintf(image->file,"\"%s c %s\",\n",symbol,name);    }m   /*     Define XPM pixels.   *//   (void) fprintf(image->file,"/* pixels */\n");a   p=image->pixels;   image->runlength=p->length+1;i!   for (y=0; y < image->rows; y++)    {o%     (void) fprintf(image->file,"\"");=&     for (x=0; x < image->columns; x++)     {n        if (image->runlength != 0)         image->runlength--; 
       else	         {l           p++;%           image->runlength=p->length; 	         }w       k=p->index % MaxCixels;w       symbol[0]=Cixel[k]; .       for (j=1; j < characters_per_pixel; j++)       { 5         k=(((int) p->index-k)/MaxCixels) % MaxCixels;)         symbol[j]=Cixel[k];        }        symbol[j]='\0'; .       (void) fprintf(image->file,"%s",symbol);     }eK     (void) fprintf(image->file,"\"%s\n",(y == (image->rows-1) ? "" : ",")); 1     ProgressMonitor(SaveImageText,y,image->rows);>   }"%   (void) fprintf(image->file,"};\n");    CloseImage(image);   return(True);n }= ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %+O %                                                                             % O %   W r i t e Y U V I m a g e                                                 %yO %                                                                             %0O %                                                                             %)O %                                                                             %>O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.  % . %  The format of the WriteYUVImage routine is: % - %      status=WriteYUVImage(image_info,image)  % + %  A description of each parameter follows.i %nJ %    o status: Function WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filep %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.r %f. %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteYUVImage(const ImageInfo *image_info,Image *image)  {    Image      *downsampled_image;e     register int     i,     j;     register RunlengthPacket     *p;i  2   if (image_info->interlace != PartitionInterlace)     {)       /*         Open output image file.a       */2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL)c3         PrematureExit("Unable to open file",image);f     }i   /*     Initialize Y channel.    */2   if (image_info->interlace == PartitionInterlace)     {f-       AppendImageFormat("Y",image->filename); 2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL)e3         PrematureExit("Unable to open file",image);i     }t+   RGBTransformImage(image,YCbCrColorspace);    p=image->pixels;$   for (i=0; i < image->packets; i++)   {i*     for (j=0; j <= ((int) p->length); j++)2       (void) fputc(DownScale(p->red),image->file);     p++;   }t   /*     Scale image.   */)   ProgressMonitor(SaveImageText,100,400);    image->orphan=True;i'   downsampled_image=MinifyImage(image);-   image->orphan=False;*   if (downsampled_image == (Image *) NULL)1     PrematureExit("Unable to scale image",image);"   /*     Initialize U channel.g   */2   if (image_info->interlace == PartitionInterlace)     {n       CloseImage(image);-       AppendImageFormat("U",image->filename);f2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL)S3         PrematureExit("Unable to open file",image);a     }-)   ProgressMonitor(SaveImageText,200,400);    p=downsampled_image->pixels;0   for (i=0; i < downsampled_image->packets; i++)   {o*     for (j=0; j <= ((int) p->length); j++)4       (void) fputc(DownScale(p->green),image->file);     p++;   }    /*     Initialize V channel.n   */2   if (image_info->interlace == PartitionInterlace)     {        CloseImage(image);-       AppendImageFormat("V",image->filename);;2       OpenImage(image_info,image,WriteBinaryType);'       if (image->file == (FILE *) NULL)p3         PrematureExit("Unable to open file",image);n     }e)   ProgressMonitor(SaveImageText,300,400);g   p=downsampled_image->pixels;0   for (i=0; i < downsampled_image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)3       (void) fputc(DownScale(p->blue),image->file);      p++;   }:"   DestroyImage(downsampled_image);+   TransformRGBImage(image,YCbCrColorspace);p2   if (image_info->interlace == PartitionInterlace)8     (void) strcpy(image->filename,image_info->filename);)   ProgressMonitor(SaveImageText,400,400);    CloseImage(image);   return(True);m }- t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %eO %                                                                             % O %                                                                             % O %   W r i t e X W D I m a g e                                                 %(O %                                                                             %iO %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function WriteXWDImage writes an image to a file in X window dump %  rasterfile format.  %e. %  The format of the WriteXWDImage routine is: %i- %      status=WriteXWDImage(image_info,image)  % + %  A description of each parameter follows.) % J %    o status: Function WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %iA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K static unsigned int WriteXWDImage(const ImageInfo *image_info,Image *image)  {    int      x;     register int     i,     j,     k;     register RunlengthPacket     *p;      unsigned int     bits_per_pixel,f     bytes_per_line,)     scanline_pad;      unsigned longe     lsb_first;     XWDFileHeader      xwd_header;      /*     Open output image file.    */.   OpenImage(image_info,image,WriteBinaryType);#   if (image->file == (FILE *) NULL))/     PrematureExit("Unable to open file",image);i   /*     Initialize XWD file header.    */@   xwd_header.header_size=sz_XWDheader+Extent(image->filename)+1;4   xwd_header.file_version=(CARD32) XWD_FILE_VERSION;,   xwd_header.pixmap_format=(CARD32) ZPixmap;J   xwd_header.pixmap_depth=(CARD32) (image->class == DirectClass ? 24 : 8);2   xwd_header.pixmap_width=(CARD32) image->columns;0   xwd_header.pixmap_height=(CARD32) image->rows;    xwd_header.xoffset=(CARD32) 0;*   xwd_header.byte_order=(CARD32) MSBFirst;I   xwd_header.bitmap_unit=(CARD32) (image->class == DirectClass ? 32 : 8); 0   xwd_header.bitmap_bit_order=(CARD32) MSBFirst;H   xwd_header.bitmap_pad=(CARD32) (image->class == DirectClass ? 32 : 8);8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);4   xwd_header.bits_per_pixel=(CARD32) bits_per_pixel;8   bytes_per_line=(CARD32) ((((xwd_header.bits_per_pixel*:     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3));a4   xwd_header.bytes_per_line=(CARD32) bytes_per_line;"   xwd_header.visual_class=(CARD32)>     (image->class == DirectClass ? DirectColor : PseudoColor);L   xwd_header.red_mask=(CARD32) (image->class == DirectClass ? 0xff0000 : 0);L   xwd_header.green_mask=(CARD32) (image->class == DirectClass ? 0xff00 : 0);I   xwd_header.blue_mask=(CARD32) (image->class == DirectClass ? 0xff : 0); J   xwd_header.bits_per_rgb=(CARD32) (image->class == DirectClass ? 24 : 8);&   xwd_header.colormap_entries=(CARD32)8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors);=2   xwd_header.window_width=(CARD32) image->columns;0   xwd_header.window_height=(CARD32) image->rows;   xwd_header.window_x=0;   xwd_header.window_y=0;(   xwd_header.window_bdrwidth=(CARD32) 0;   /*     Write XWD header.    */   lsb_first=1;   if (*(char *) &lsb_first) ?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header)); A   (void) fwrite((char *) &xwd_header,sz_XWDheader,1,image->file);nE   (void) fwrite((char *) image->filename,1,Extent(image->filename)+1,      image->file); "   if (image->class == PseudoClass)     {-       XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */=       colors=(XColor *) malloc(image->colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        {          colors[i].pixel=i;7         colors[i].red=XUpScale(image->colormap[i].red);0;         colors[i].green=XUpScale(image->colormap[i].green); 9         colors[i].blue=XUpScale(image->colormap[i].blue);u1         colors[i].flags=DoRed | DoGreen | DoBlue;i         colors[i].pad=0;!         if (*(char *) &lsb_first)            { F             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }        } '       for (i=0; i < image->colors; i++)"       {\3         color.pixel=(unsigned int) colors[i].pixel;a          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;A         (void) fwrite((char *) &color,sz_XWDColor,1,image->file);r       }        free((char *) colors);     }+   /*&     Convert MIFF to XWD raster pixels.   */   scanline_pad=(unsigned int)l<     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));   x=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     { &       if (image->class == PseudoClass)+         (void) fputc(p->index,image->file); 
       else	         { 6           (void) fputc(DownScale(p->red),image->file);8           (void) fputc(DownScale(p->green),image->file);7           (void) fputc(DownScale(p->blue),image->file);-	         }n
       x++;       if (x == image->columns)	         { *           for (k=0; k < scanline_pad; k++)(             (void) fputc(0,image->file);           x=0;	         }t     })     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(SaveImageText,i,image->packets);   }    CloseImage(image);   return(True);r }f a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %mO %                                                                             % O %                                                                             % O %   W r i t e I m a g e                                                       %iO %                                                                             %iO %                                                                             %>O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function WriteImage writes an image to a file.  You can specify aJ %  particular image format by prefixing the file with the image type and aI %  colon (i.e. ps:image) or specify the image type as the filename suffix  %  (i.e. image.ps).  % + %  The format of the WriteImage routine is:  %v* %      status=WriteImage(image_info,image) % + %  A description of each parameter follows:; % G %    o status: Function WriteImage return True if the image is written.>K %      False is returned is there is a memory shortage or if the image file( %      fails to write. %LA %    o image_info: Specifies a pointer to an ImageInfo structure.g %n- %    o image: A pointer to a Image structure.) %r %f */B Export unsigned int WriteImage(ImageInfo *image_info,Image *image) {>   unsigned int     status;%     /*6     Call appropriate image writer based on image type.   */+   assert(image_info != (ImageInfo *) NULL);%0   assert(image_info->filename != (char *) NULL);"   assert(image != (Image *) NULL);   status=False;%6   (void) strcpy(image_info->filename,image->filename);2   (void) strcpy(image_info->magick,image->magick);    SetImageInfo(image_info,True);6   (void) strcpy(image->filename,image_info->filename);   switch (*image_info->magick)   { 
     case 'A':      { -       status=WriteAVSImage(image_info,image);        break;     } 
     case 'B':      { 0       if (strcmp(image_info->magick,"BIE") == 0)	         { 2           status=WriteJBIGImage(image_info,image);           break;	         } -       status=WriteBMPImage(image_info,image);        break;     } 
     case 'C':      { 0       if (strcmp(image_info->magick,"CGM") == 0)	         {%1           status=WriteCGMImage(image_info,image);F           break;	         }t.       status=WriteCMYKImage(image_info,image);       break;     } 
     case 'D':o     {s0       if (strcmp(image_info->magick,"DCX") == 0)	         {h1           status=WritePCXImage(image_info,image);            break;	         }r-       status=WriteBMPImage(image_info,image);        break;     }(
     case 'E':e     { 1       if (strcmp(image_info->magick,"EPS2") == 0) 	         {:1           status=WritePS2Image(image_info,image);            break;	         }u,       status=WritePSImage(image_info,image);       break;     }i
     case 'F':i     {p0       if (strcmp(image_info->magick,"FAX") == 0)	         {r1           status=WriteFAXImage(image_info,image);            break;	         } 1       if (strcmp(image_info->magick,"FITS") == 0)i	         {m2           status=WriteFITSImage(image_info,image);           break;	         }g.       status=WriteHTMLImage(image_info,image);       break;     }e
     case 'G':e     { 3       if (strncmp(image_info->magick,"GIF",3) == 0) 	         { 1           status=WriteGIFImage(image_info,image);%           break;	         } 6       if (strcmp(image_info->magick,"GRADATION") == 0)	         {,7           status=WriteGRADATIONImage(image_info,image);            break;	         }a4       if (strcmp(image_info->magick,"GRANITE") == 0)	         {r2           status=WriteLOGOImage(image_info,image);           break;	         }e1       if (strcmp(image_info->magick,"GRAY") == 0)t	         { 2           status=WriteGRAYImage(image_info,image);           break;	         }m-       status=WriteFAXImage(image_info,image);        break;     }g
     case 'H':      {a.       if (strcmp(image_info->magick,"H") == 0)	         {r2           status=WriteLOGOImage(image_info,image);           break;	         } 0       if (strcmp(image_info->magick,"HDF") == 0)	         { 1           status=WriteHDFImage(image_info,image);            break;	         },6       if (strcmp(image_info->magick,"HISTOGRAM") == 0)	         { 7           status=WriteHISTOGRAMImage(image_info,image);            break;	         }o.       status=WriteHTMLImage(image_info,image);       break;     } 
     case 'J':y     {,1       if (strcmp(image_info->magick,"JBIG") == 0)a	         { 2           status=WriteJBIGImage(image_info,image);           break;	         } .       status=WriteJPEGImage(image_info,image);       break;     }/
     case 'L':t     { .       status=WriteLOGOImage(image_info,image);       break;     }w
     case 'M':      { 0       if (strcmp(image_info->magick,"MAP") == 0)	         {s1           status=WriteMAPImage(image_info,image);o           break;	         } 2       if (strcmp(image_info->magick,"MATTE") == 0)	         { 3           status=WriteMATTEImage(image_info,image);            break;	         }s1       if (strcmp(image_info->magick,"MIFF") == 0) 	         { 2           status=WriteMIFFImage(image_info,image);           break;	         }o1       if (strcmp(image_info->magick,"MONO") == 0)p	         {u2           status=WriteMONOImage(image_info,image);           break;	         } 5       if ((strcmp(image_info->magick,"MPEG") == 0) ||o2           (strcmp(image_info->magick,"MPG") == 0))	         { 2           status=WriteMPEGImage(image_info,image);           break;	         }r-       status=WriteMTVImage(image_info,image);        break;     }5
     case 'N':      {g5       if (strcmp(image_info->magick,"NETSCAPE") == 0)c	         {02           status=WriteLOGOImage(image_info,image);           break;	         }p       break;     }e
     case 'P':e     { 0       if (strcmp(image_info->magick,"PCD") == 0)	         {&1           status=WritePCDImage(image_info,image);            break;	         }y0       if (strcmp(image_info->magick,"PCL") == 0)	         { 1           status=WritePCLImage(image_info,image);)           break;	         }e0       if (strcmp(image_info->magick,"PCX") == 0)	         {"1           status=WritePCXImage(image_info,image);%           break;	         }P0       if (strcmp(image_info->magick,"PDF") == 0)	         {o1           status=WritePDFImage(image_info,image);c           break;	         },1       if (strcmp(image_info->magick,"PICT") == 0)d	         { 2           status=WritePICTImage(image_info,image);           break;	         }x3       if (strcmp(image_info->magick,"PLASMA") == 0)p	         { 4           status=WritePLASMAImage(image_info,image);           break;	         }i/       if (strcmp(image_info->magick,"PM") == 0)n	         {d1           status=WriteXPMImage(image_info,image);            break;	         }u0       if (strcmp(image_info->magick,"PNG") == 0)	         {e1           status=WritePNGImage(image_info,image);d           break;	         }s4       if (strcmp(image_info->magick,"PREVIEW") == 0)	         { 5           status=WritePREVIEWImage(image_info,image);i           break;	         } /       if (strcmp(image_info->magick,"PS") == 0) 	         {g0           status=WritePSImage(image_info,image);           break;	         }s0       if (strcmp(image_info->magick,"PS2") == 0)	         { 1           status=WritePS2Image(image_info,image);T           break;	         } -       status=WritePNMImage(image_info,image);y       break;     }e
     case 'R':      {u0       if (strcmp(image_info->magick,"RAD") == 0)	         { 6           status=WriteRADIANCEImage(image_info,image);           break;	         } 0       if (strcmp(image_info->magick,"RAS") == 0)	         {p1           status=WriteSUNImage(image_info,image);p           break;	         }e3       if (strncmp(image_info->magick,"RGB",3) == 0);	         {e1           status=WriteRGBImage(image_info,image);g           break;	         }m3       if (strncmp(image_info->magick,"RLA",3) == 0)=	         {U1           status=WriteRLAImage(image_info,image);)           break;	         } -       status=WriteRLEImage(image_info,image);a       break;     }t
     case 'S':f     {-0       if (strcmp(image_info->magick,"SGI") == 0)	         {g1           status=WriteSGIImage(image_info,image);            break;	         }s2       if (strcmp(image_info->magick,"SHTML") == 0)	         {t2           status=WriteHTMLImage(image_info,image);           break;	         }&-       status=WriteSUNImage(image_info,image);g       break;     } 
     case 'T':      {P1       if (strcmp(image_info->magick,"TEXT") == 0)g	         { 2           status=WriteTEXTImage(image_info,image);           break;	         },0       if (strcmp(image_info->magick,"TGA") == 0)	         {)3           status=WriteTARGAImage(image_info,image);e           break;	         } 3       if (strncmp(image_info->magick,"TIF",3) == 0) 	         { 2           status=WriteTIFFImage(image_info,image);           break;	         }i.       status=WriteTILEImage(image_info,image);       break;     }a
     case 'U':      {_.       status=WriteUYVYImage(image_info,image);       break;     }e
     case 'V':;     { 2       if (strcmp(image_info->magick,"VICAR") == 0)	         {t3           status=WriteVICARImage(image_info,image);a           break;	         } 0       if (strcmp(image_info->magick,"VID") == 0)	         { 2           status=WriteMIFFImage(image_info,image);           break;	         } .       status=WriteVIFFImage(image_info,image);       break;     } 
     case 'X':      { .       if (strcmp(image_info->magick,"X") == 0)	         {t/           status=WriteXImage(image_info,image);            break;	         } 0       if (strcmp(image_info->magick,"XBM") == 0)	         {i1           status=WriteXBMImage(image_info,image);0           break;	         } /       if (strcmp(image_info->magick,"XC") == 0),	         {o0           status=WriteXCImage(image_info,image);           break;	         }f0       if (strcmp(image_info->magick,"XPM") == 0)	         {i1           status=WriteXPMImage(image_info,image);i           break;	         } /       if (strcmp(image_info->magick,"XV") == 0)e	         {i2           status=WriteVIFFImage(image_info,image);           break;	         }s-       status=WriteXWDImage(image_info,image);)       break;     }*
     case 'Y':p     {s-       status=WriteYUVImage(image_info,image);i       break;     }2     default:.       status=WriteMIFFImage(image_info,image);   };   if (image->status)     {iG       Warning("An error has occurred writing to file",image->filename);r       return(False);     }:2   (void) strcpy(image->magick,image_info->magick);   return(status);s }"