 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                      EEEEE  RRRR   RRRR   OOO   RRRR                        % O %                      E      R   R  R   R O   O  R   R                       % O %                      EEE    RRRR   RRRR  O   O  RRRR                        % O %                      E      R R    R R   O   O  R R                         % O %                      EEEEE  R  R   R  R   OOO   R  R                        % O %                                                                             % O %                                                                             % O %                         ImageMagick Error Routines                          % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include <errno.h>   /*   Define declarations. */" #if defined(sun) && !defined(SVR4) #ifndef strerror #define strerror(n) \ C   (((n) >= 0 && (n) < sys_nerr) ? sys_errlist[n] : "unknown error")    extern char    *sys_errlist[];   
 extern int   sys_nerr;  #endif #endif   /*   Forward declaraations. */ static void 1   DefaultErrorHandler(const char *,const char *), 3   DefaultWarningHandler(const char *,const char *);    /*   Global declarations. */ static ErrorHandler &   error_handler = DefaultErrorHandler,*   warning_handler = DefaultWarningHandler;   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e f a u l t E r r o r H a n d l e r                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function DefaultErrorHandler displays an error message and then terminates  %  the program.  % 4 %  The format of the DefaultErrorHandler routine is: % - %      DefaultErrorHandler(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */J static void DefaultErrorHandler(const char *message,const char *qualifier) {    if (message == (char *) NULL)      exit(1);6   (void) fprintf(stderr,"%s: %s",client_name,message);!   if (qualifier != (char *) NULL) -     (void) fprintf(stderr," (%s)",qualifier);    if (errno)3     (void) fprintf(stderr," [%s]",strerror(errno)); 
   errno=0;   (void) fprintf(stderr,".\n"); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e f a u l t W a r n i n g H a n d l e r                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function DefaultWarningHandler displays a warning message.  % 6 %  The format of the DefaultWarningHandler routine is: % / %      DefaultWarningHandler(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */L static void DefaultWarningHandler(const char *message,const char *qualifier) {    if (message == (char *) NULL)      return; 6   (void) fprintf(stderr,"%s: %s",client_name,message);!   if (qualifier != (char *) NULL) -     (void) fprintf(stderr," (%s)",qualifier);    if (errno)3     (void) fprintf(stderr," [%s]",strerror(errno)); 
   errno=0;   (void) fprintf(stderr,".\n");  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E r r o r                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function Error calls the error handler routines with an error message.  % & %  The format of the Error routine is: %  %      Error(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */< Export void Error(const char *message,const char *qualifier) { +   if (error_handler != (ErrorHandler) NULL) (     (*error_handler)(message,qualifier); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t E r r o r H a n d l e r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function SetErrorHandler sets the error handler to the specified routine * %  and returns the previous error handler. % 0 %  The format of the SetErrorHandler routine is: % 0 %      previous_handler=SetErrorHandler(handler) % + %  A description of each parameter follows:  % B %    o handler: Specifies a pointer to a routine to handle errors. %  %  */9 Export ErrorHandler SetErrorHandler(ErrorHandler handler)  {    ErrorHandler     previous_handler;   !   previous_handler=error_handler;    error_handler=handler;   return(previous_handler);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t W a r n i n g H a n d l e r                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function SetWarningHandler sets the warning handler to the specified routine , %  and returns the previous warning handler. % 2 %  The format of the SetWarningHandler routine is: % 2 %      previous_handler=SetWarningHandler(handler) % + %  A description of each parameter follows:  % D %    o handler: Specifies a pointer to a routine to handle warnings. %  %  */; Export ErrorHandler SetWarningHandler(ErrorHandler handler)  {    ErrorHandler     previous_handler;   !   previous_handler=error_handler;    warning_handler=handler;   return(previous_handler);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W a r n i n g                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function Warning calls the warning handler routines with an warning message.  % ( %  The format of the Warning routine is: % ! %      Warning(message,qualifier)  % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */> Export void Warning(const char *message,const char *qualifier) { -   if (warning_handler != (ErrorHandler) NULL) *     (*warning_handler)(message,qualifier); } 