 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                       IIIII  M   M   AAA   GGGG  EEEEE                      % O %                         I    MM MM  A   A G      E                          % O %                         I    M M M  AAAAA G  GG  EEE                        % O %                         I    M   M  A   A G   G  E                          % O %                       IIIII  M   M  A   A  GGGG  EEEEE                      % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Routines                         % O %                                                                             % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "formats.h" #include "Colorlist.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function AllocateImage allocates an Image structure and initializes each  %  field to a default value. % . %  The format of the AllocateImage routine is: % 0 %      allocated_image=AllocateImage(image_info) % + %  A description of each parameter follows:  % L %    o allocated_image: Function AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % @ %    o image_info: Specifies a pointer to a ImageInfo structure. %  %  */8 Export Image *AllocateImage(const ImageInfo *image_info) {    Image      *allocated_image;      XColor
     color;     /*     Allocate image structure.    */2   allocated_image=(Image *) malloc(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { E       Warning("Unable to allocate image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize Image structure.    */&   allocated_image->file=(FILE *) NULL;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; &   allocated_image->text=(char *) NULL;"   allocated_image->id=UndefinedId;%   allocated_image->class=DirectClass;    allocated_image->matte=False; ;   allocated_image->compression=RunlengthEncodedCompression;    allocated_image->columns=0;    allocated_image->rows=0;&   allocated_image->depth=QuantumDepth;.   allocated_image->interlace=DefaultInterlace;   allocated_image->scene=0; -   allocated_image->units=UndefinedResolution; $   allocated_image->x_resolution=0.0;$   allocated_image->y_resolution=0.0;)   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(ColorPacket *) NULL; ,   allocated_image->colorspace=RGBColorspace;   allocated_image->colors=0;   allocated_image->gamma=0.0; 0   allocated_image->normalized_maximum_error=0.0;-   allocated_image->normalized_mean_error=0.0; *   allocated_image->mean_error_per_pixel=0;"   allocated_image->total_colors=0;+   allocated_image->signature=(char *) NULL; 3   allocated_image->pixels=(RunlengthPacket *) NULL; 3   allocated_image->packet=(RunlengthPacket *) NULL;    allocated_image->packets=0; !   allocated_image->packet_size=0; 8   allocated_image->packed_pixels=(unsigned char *) NULL;)   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; 5   allocated_image->magick_time=time((time_t *) NULL); *   allocated_image->geometry=(char *) NULL;&   allocated_image->page=(char *) NULL;   allocated_image->dispose=0;    allocated_image->delay=0;     allocated_image->iterations=1;5   (void) XQueryColorDatabase(BackgroundColor,&color); >   allocated_image->background_color.red=XDownScale(color.red);B   allocated_image->background_color.green=XDownScale(color.green);@   allocated_image->background_color.blue=XDownScale(color.blue);,   allocated_image->background_color.index=0;1   (void) XQueryColorDatabase(BorderColor,&color); :   allocated_image->border_color.red=XDownScale(color.red);>   allocated_image->border_color.green=XDownScale(color.green);<   allocated_image->border_color.blue=XDownScale(color.blue);(   allocated_image->border_color.index=0;0   (void) XQueryColorDatabase(MatteColor,&color);9   allocated_image->matte_color.red=XDownScale(color.red); =   allocated_image->matte_color.green=XDownScale(color.green); ;   allocated_image->matte_color.blue=XDownScale(color.blue); '   allocated_image->matte_color.index=0; '   if (image_info != (ImageInfo *) NULL)      { D       (void) strcpy(allocated_image->filename,image_info->filename);@       (void) strcpy(allocated_image->magick,image_info->magick);     }     allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->list=(Image *) NULL; '   allocated_image->next=(Image *) NULL;    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function AnnotateImage annotates an image with test.  Optionally the K %  annotation can include the image filename, type, width, height, or scene I %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  % " %  produces an image annotation of %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % . %  The format of the AnnotateImage routine is: % ) %      AnnotateImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % > %    o annotate_info: The address of a AnnotateInfo structure. %  %  */< void AnnotateImage(Image *image,AnnotateInfo *annotate_info) {    char
     *text,     **textlist;      FILE
     *file;     int 
     flags,     status,      x,     y;     register char      *p,      *q;      register int     i,     j;     static AnnotateInfo      cache_info;      static Display      *display = (Display *) NULL;     static unsigned int      font_type = 0;     static XAnnotateInfo     xannotate_info;      static XFontStruct     *font_info;      static XPixelInfo      pixel_info;      static XResourceInfo     resource_info;     static XrmDatabase     resource_database;     static XStandardColormap     *map_info;     static XVisualInfo     *visual_info;      unsigned int     height,      indirection,     length, 
     width;     /*(     Ensure the annotation info is valid.   */"   assert(image != (Image *) NULL);1   assert(annotate_info != (AnnotateInfo *) NULL); +   if (annotate_info->text == (char *) NULL)      return; #   if (*annotate_info->text == '\0')      return; ,   indirection=(*annotate_info->text == '@');   if (indirection)     { 	       int 
         c;         /*         Read text from a file.       */5       file=(FILE *) fopen(annotate_info->text+1,"r");         if (file == (FILE *) NULL)	         { D           Warning("Unable to read text file",annotate_info->text+1);           return; 	         }        length=MaxTextExtent; 2       annotate_info->text=(char *) malloc(length);L       for (q=annotate_info->text; annotate_info->text != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;0         if ((q-annotate_info->text+1) >= length)           {              *q='\0';             length<<=1; M             annotate_info->text=(char *) realloc(annotate_info->text,length); 5             if (annotate_info->text == (char *) NULL)                break;>             q=annotate_info->text+Extent(annotate_info->text);           }          *q=(unsigned char) c;        }        (void) fclose(file);/       if (annotate_info->text == (char *) NULL) 	         { I           Warning("Unable to annotate image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*'     Allocate and initialize image text.    */   p=annotate_info->text;3   length=Extent(annotate_info->text)+MaxTextExtent; &   image->text=(char *) malloc(length);8   for (q=image->text; image->text != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;0     if ((q-image->text+MaxTextExtent) >= length)       {          length<<=1; B         image->text=(char *) realloc((char *) image->text,length);)         if (image->text == (char *) NULL)            break;*         q=image->text+Extent(image->text);       }      /*,       Process formatting characters in text.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'b':        { 5         (void) sprintf(q,"%ld",image->filesize/1000); *         q=image->text+Extent(image->text);         break;       }        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */0         if (Extent(image->magick_filename) == 0)           break;B         p=image->magick_filename+Extent(image->magick_filename)-1;?         while ((p > image->magick_filename) && (*(p-1) != '/'))            p--;         (void) strcpy(q,p);          q+=Extent(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);*         q=image->text+Extent(image->text);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=Extent(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);*         q=image->text+Extent(image->text);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); *         q=image->text+Extent(image->text);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } #   if (image->text == (char *) NULL)      { E       Warning("Unable to annotate image","Memory allocation failed"); 
       return;      }    *q++='\0';   *q++='\0';   if (indirection)'     free((char *) annotate_info->text); %   textlist=StringToList(image->text);    free(image->text);   image->text=(char *) NULL;!   if (textlist == (char **) NULL)      return;    length=Extent(textlist[0]); .   for (i=0; textlist[i] != (char *) NULL; i++)%     if (Extent(textlist[i]) > length) !       length=Extent(textlist[i]); !   text=(char *) malloc(length+4);    if (text == (char *) NULL)     { D       Warning("Unable to annotate image","Memory allocation error");
       return;      }    /*     Get annotate geometry.   */   x=0;   y=0;   width=image->columns; "   height=annotate_info->pointsize;   flags=NoValue;/   if (annotate_info->geometry != (char *) NULL)      { I       flags=XParseGeometry(annotate_info->geometry,&x,&y,&width,&height); #       if ((flags & XNegative) != 0)          x+=image->columns;#       if ((flags & YNegative) != 0)          y+=image->rows;      }    switch (font_type)   {      case 0:      default:     {        /*!         Open X server connection.        */&       if (display != (Display *) NULL)         break;7       display=XOpenDisplay(annotate_info->server_name); &       if (display != (Display *) NULL)	         {            /*,             Set our forgiving error handler.           */#           XSetErrorHandler(XError);            /*7             Get user defaults from X resource database.            */F           resource_database=XGetResourceDatabase(display,client_name);I           XGetResourceInfo(resource_database,client_name,&resource_info); +           resource_info.close_server=False; 1           resource_info.colormap=PrivateColormap; 3           if (annotate_info->font != (char *) NULL) 3             resource_info.font=annotate_info->font; 2           if (annotate_info->box != (char *) NULL)>             resource_info.background_color=annotate_info->box;2           if (annotate_info->pen != (char *) NULL)>             resource_info.foreground_color=annotate_info->pen;,           map_info=XAllocStandardColormap();5           if (map_info == (XStandardColormap *) NULL) 9             Warning("Unable to create standard colormap", *               "Memory allocation failed");           /*#             Initialize visual info.            */G           visual_info=XBestVisualInfo(display,map_info,&resource_info); 2           if (visual_info == (XVisualInfo *) NULL)F             Warning("Unable to get visual",resource_info.visual_type);-           map_info->colormap=(Colormap) NULL; 3           pixel_info.pixels=(unsigned long *) NULL; /           pixel_info.gamma_map=(XColor *) NULL;            /*.             Initialize Standard Colormap info.           */P           XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),             map_info);D           XGetPixelInfo(display,visual_info,map_info,&resource_info,(             (Image *) NULL,&pixel_info);N           pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);           /*!             Initialize font info.            */<           font_info=XBestFont(display,&resource_info,False);0           if (font_info == (XFontStruct *) NULL)>             Warning("Unable to load font",resource_info.font);9           if ((map_info == (XStandardColormap *) NULL) || 6               (visual_info == (XVisualInfo *) NULL) ||2               (font_info == (XFontStruct *) NULL))
             { F               XFreeResources(display,visual_info,map_info,&pixel_info,?                 font_info,&resource_info,(XWindowInfo *) NULL); '               display=(Display *) NULL; 
             } &           cache_info=(*annotate_info);           break;	         } O       Warning("Unable to load X server fonts","substituting Postscript fonts");        font_type++;     }      case 1:      { 
       char          filename[MaxTextExtent],         page[MaxTextExtent];         Image          *annotate_image;         ImageInfo          image_info;          register RunlengthPacket         *q;          unsigned int         matte,         polarity;          XColor         box_color,         pen_color;         /*E         X server fonts are not available, use Postscript to annotate.        */@       (void) XQueryColorDatabase(annotate_info->box,&box_color);@       (void) XQueryColorDatabase(annotate_info->pen,&pen_color);        GetImageInfo(&image_info);"       TemporaryFilename(filename);!       image_info.monochrome=True; =       (void) sprintf(page,"%ux%u",height*length,height << 1);        image_info.page=page; /       if (annotate_info->font == (char *) NULL) (         annotate_info->font=DefaultFont;2       for (i=0; textlist[i] != (char *) NULL; i++)       { 8         if ((x >= image->columns) || (y >= image->rows))           break;!         if (*textlist[i] == '\0')            {              free(textlist[i]);(             y+=annotate_info->pointsize;             continue;            } (         (void) strcpy(text,textlist[i]);9         for (j=(Extent(textlist[i])-1) >> 1; j >= 0; j--) 	         { 6           (void) strcpy(image_info.filename,filename);/           file=fopen(filename,WriteBinaryType); $           if (file == (FILE *) NULL)             break;3           (void) fprintf(file,"%%!PS-Adobe-3.0\n"); D           (void) fprintf(file,"/%s findfont %u scalefont setfont\n",(             annotate_info->font,height);E           (void) fprintf(file,"0 %u moveto (%s) show\n",height,text); ,           (void) fprintf(file,"showpage\n");           (void) fclose(file);0           annotate_image=ReadImage(&image_info);/           if (annotate_image == (Image *) NULL)              break;>           TransformImage(&annotate_image,"0x0",(char *) NULL);.           if (annotate_image->columns < width)             break;'           DestroyImage(annotate_image); *           (void) strcpy(text,textlist[i]);&           (void) strcpy(text+j,"...");B           (void) strcat(text,textlist[i]+Extent(textlist[i])-j-1);	         }           (void) remove(filename);         free(textlist[i]);-         if (annotate_image == (Image *) NULL)            { >             Warning("Unable to annotate image",(char *) NULL);             break;           } 
         /*(           Composite text onto the image.
         */         polarity=0; 1         if (annotate_image->class == PseudoClass) J           polarity=Intensity(annotate_image->colormap[0]) < (MaxRGB >> 1);*         annotate_image->class=DirectClass;#         annotate_image->matte=True; !         q=annotate_image->pixels; 3         for (j=0; j < annotate_image->packets; j++) 	         { #           if (q->index == polarity) 
             { /               q->red=XDownScale(box_color.red); 3               q->green=XDownScale(box_color.green); 1               q->blue=XDownScale(box_color.blue);                q->index= K                 annotate_info->box == (char *) NULL ? Transparent : Opaque; 
             }            else
             { /               q->red=XDownScale(pen_color.red); 3               q->green=XDownScale(pen_color.green); 1               q->blue=XDownScale(pen_color.blue);                q->index= K                 annotate_info->pen == (char *) NULL ? Transparent : Opaque; 
             }            q++;	         }          matte=image->matte; >         CompositeImage(image,OverCompositeOp,annotate_image,x+P           (annotate_info->center ? (width >> 1)-(annotate_image->columns >> 1) :           0),y);         image->matte=matte; $         y+=annotate_info->pointsize;%         DestroyImage(annotate_image);        }        free(text); 0       for ( ; textlist[i] != (char *) NULL; i++)         free(textlist[i]);       free((char *) textlist);
       return;      }    }    /*     Initialize annotate info.    */$   XGetAnnotateInfo(&xannotate_info);-   if (cache_info.font != annotate_info->font)      {        /*         Font name has changed.       */#       XFreeFont(display,font_info); /       if (annotate_info->font != (char *) NULL) /         resource_info.font=annotate_info->font; 8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);     } !   if ((flags & HeightValue) == 0) 0     height=font_info->ascent+font_info->descent;%   xannotate_info.font_info=font_info;    xannotate_info.text=text;    xannotate_info.x=x;    xannotate_info.y=y;    xannotate_info.width=width; =   xannotate_info.height=font_info->ascent+font_info->descent; @   annotate_info->pointsize=font_info->ascent+font_info->descent;.   if ((annotate_info->pen != (char *) NULL) &&,       (annotate_info->box != (char *) NULL)))     xannotate_info.stencil=OpaqueStencil;    else,     if (annotate_info->pen != (char *) NULL)/       xannotate_info.stencil=ForegroundStencil;      else/       xannotate_info.stencil=BackgroundStencil; /   if ((cache_info.box != annotate_info->box) || -       (cache_info.pen != annotate_info->pen))      {        /*         Pen color has changed.       */.       if (annotate_info->box != (char *) NULL):         resource_info.background_color=annotate_info->box;.       if (annotate_info->pen != (char *) NULL):         resource_info.foreground_color=annotate_info->pen;O       XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,          &pixel_info);      }    /*     Annotate the text image.   */.   for (i=0; textlist[i] != (char *) NULL; i++)   { 4     if ((x >= image->columns) || (y >= image->rows))       break;     if (*textlist[i] == '\0')        {          free(textlist[i]);!         xannotate_info.y+=height;          y+=height;         continue;        } $     (void) strcpy(text,textlist[i]);5     for (j=(Extent(textlist[i])-1) >> 1; j >= 0; j--)      { L       xannotate_info.width=(height*XTextWidth(font_info,text,Extent(text)))/         xannotate_info.height;'       if (xannotate_info.width < width)          break;&       (void) strcpy(text,textlist[i]);"       (void) strcpy(text+j,"...");>       (void) strcat(text,textlist[i]+Extent(textlist[i])-j-1);     }      free(textlist[i]);N     (void) sprintf(xannotate_info.geometry,"%ux%u%+d%+d",xannotate_info.width,K       height,(int) (xannotate_info.x+(annotate_info->center ? (width >> 1)- :       (xannotate_info.width >> 1) : 0)),xannotate_info.y);A     xannotate_info.width=XTextWidth(font_info,text,Extent(text)); E     status=XAnnotateImage(display,&pixel_info,&xannotate_info,image);      if (status == 0)       { G         Warning("Unable to xannotate image","Memory allocation error");          break;       }      xannotate_info.y+=height;      y+=height;   }    /*     Free resources.    */   cache_info=(*annotate_info);
   free(text); ,   for ( ; textlist[i] != (char *) NULL; i++)     free(textlist[i]);   free((char *) textlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     A v e r a g e I m a g e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function AverageImages averages a set of images.  All the input images must %  be the same size in pixels. % - %  The format of the AverageImage routine is:  %  %      AverageImages(images) % + %  A description of each parameter follows:  % G %    o images: The address of a structure of type Image;  returned from  %      ReadImage.  %  %  */* Export Image *AverageImages(Image *images) {    Image      *averaged_image,     *next_image;     long	     blue, 
     green,     red;     unsigned short
     index;     register int     i;     register RunlengthPacket     *q;      /*'     Ensure the images are uncompressed.    */#   assert(images != (Image *) NULL);    next_image=images;&   while (next_image != (Image *) NULL)   { 3     if ((next_image->columns != images->columns) || +         (next_image->rows != images->rows))        { J         Warning("Unable to average image","images are not the same size");         return((Image *) NULL);        } %     if (!UncompressImage(next_image))        return((Image *) NULL);       next_image=next_image->next;   }    /*(     Initialize average image attributes.   */   images->orphan=True;F   averaged_image=CopyImage(images,images->columns,images->rows,False);   images->orphan=False; '   if (averaged_image == (Image *) NULL)      { D       Warning("Unable to average image","Memory allocation failed");       return((Image *) NULL);      } $   averaged_image->class=DirectClass;   q=averaged_image->pixels; -   for (i=0; i < averaged_image->packets; i++)    { 
     red=0;     green=0;     blue=0;      index=0;     next_image=images;(     while (next_image != (Image *) NULL)     { "       if (i < next_image->packets)	         { )           red+=next_image->pixels[i].red; -           green+=next_image->pixels[i].green; +           blue+=next_image->pixels[i].blue;            index++;	         } "       next_image=next_image->next;     } >     q->red=(Quantum) ((red+(long) (index >> 1))/(long) index);B     q->green=(Quantum) ((green+(long) (index >> 1))/(long) index);@     q->blue=(Quantum) ((blue+(long) (index >> 1))/(long) index);     q->index=0;      q->length=0;     q++;   }    return(averaged_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % , %  The format of the BorderImage routine is: % 4 %      bordered_image=BorderImage(image,border_info) % + %  A description of each parameter follows:  % M %    o bordered_image: Function BorderImage returns a pointer to the bordered H %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % I %    o border_info: Specifies a pointer to a XRectangle which defines the  %      border region.  %  */; Image *BorderImage(Image *image,RectangleInfo *border_info)  { 8 #define BorderImageText  "  Adding border to image...  "     Image      *bordered_image;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      border;      /*)     Initialize bordered image attributes.    */"   assert(image != (Image *) NULL);0   assert(border_info != (RectangleInfo *) NULL);J   bordered_image=CopyImage(image,image->columns+(border_info->width << 1),2     image->rows+(border_info->height << 1),False);'   if (bordered_image == (Image *) NULL)      { C       Warning("Unable to border image","Memory allocation failed");        return((Image *) NULL);      }    /*     Initialize border color.   */%   border.red=image->border_color.red; )   border.green=image->border_color.green; '   border.blue=image->border_color.blue; )   border.index=image->border_color.index;    border.length=0;   /*(     Copy image and put border around it.   */   q=bordered_image->pixels; )   for (y=0; y < border_info->height; y++) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     */*     for (x=0; x < border_info->width; x++)       *q++=border;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);4       if (image->matte && (p->index == Transparent))         *q=border;       q->length=0;
       q++;     }      x=0;K     while (x < (bordered_image->columns-image->columns-border_info->width))      {        *q++=border;
       x++;     } 3     ProgressMonitor(BorderImageText,y,image->rows);    } O   for (y=(bordered_image->rows-image->rows-border_info->height-1); y >= 0; y--) /     for (x=0; x < bordered_image->columns; x++)        *q++=border;   return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C h o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ChopImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure and& %  returns a pointer to the new image. % * %  The format of the ChopImage routine is: % , %      chop_image=ChopImage(image,chop_info) % + %  A description of each parameter follows:  % C %    o chop_image: Function ChopImage returns a pointer to the chop J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o chop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */> Export Image *ChopImage(Image *image,RectangleInfo *chop_info) { . #define ChopImageText  "  Chopping image...  "     Image      *chopped_image;      register int     x,     y;     register RunlengthPacket     *p,      *q;      unsigned int     height;      /*     Check chop geometry.   */"   assert(image != (Image *) NULL);.   assert(chop_info != (RectangleInfo *) NULL);4   if (((chop_info->x+(int) chop_info->width) < 0) ||5       ((chop_info->y+(int) chop_info->height) < 0) || .       (chop_info->x > (int) image->columns) ||)       (chop_info->y > (int) image->rows))      { H       Warning("Unable to chop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((chop_info->x+(int) chop_info->width) > (int) image->columns) H     chop_info->width=(unsigned int) ((int) image->columns-chop_info->x);A   if ((chop_info->y+(int) chop_info->height) > (int) image->rows) F     chop_info->height=(unsigned int) ((int) image->rows-chop_info->y);   if (chop_info->x < 0)      { 7       chop_info->width-=(unsigned int) (-chop_info->x);        chop_info->x=0;      }    if (chop_info->y < 0)      { 8       chop_info->height-=(unsigned int) (-chop_info->y);       chop_info->y=0;      }    /*%     Initialize chop image attributes.    */@   chopped_image=CopyImage(image,image->columns-chop_info->width,)     image->rows-chop_info->height,False); &   if (chopped_image == (Image *) NULL)     { A       Warning("Unable to chop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Extract chop image.    */   p=image->pixels;   image->runlength=p->length+1;    q=chopped_image->pixels;"   for (y=0; y < chop_info->y; y++)&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      }    /*%     Skip pixels up to the chop image.    */8   for (x=0; x < (chop_info->height*image->columns); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract chop image.    */6   height=image->rows-(chop_info->y+chop_info->height);   for (y=0; y < height; y++)   { &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } G       if ((x < chop_info->x) || (x >= (chop_info->x+chop_info->width))) 	         {            *q=(*p);           q->length=0;           q++;	         }      } ,     ProgressMonitor(ChopImageText,y,height);   }    return(chopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CloseImage closes a file associated with the image.  If the K %  filename prefix is '|', the file is a pipe and is closed with PipeClose.  % + %  The format of the CloseImage routine is:  %  %      CloseImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */ void CloseImage(Image *image)  {    /*     Close image file.    */"   assert(image != (Image *) NULL);#   if (image->file == (FILE *) NULL)      return; $   image->status=ferror(image->file);; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)    if (image->pipe)     (void) pclose(image->file);    else #endif:     if ((image->file != stdin) && (image->file != stdout))!       (void) fclose(image->file);    image->file=(FILE *) NULL;   if (!image->orphan)      do     {         image->file=(FILE *) NULL;       image=image->next;     } $     while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o l o r F l o o d f i l l I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ColorFloodfillImage floodfills the designated area with a color.G %  The floodfill algorithm is strongly based on a similiar algorithm in $ %  "Graphics Gems" by Paul Heckbert. % 4 %  The format of the ColorFloodfillImage routine is: % 2 %      ColorFloodfillImage(image,x,y,xcolor,delta) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % K %    o x,y: Unsigned integers representing the current location of the pen.  % N %    o xcolor: A XColor structure.  This is the RGB value of the target color. % B %    o delta: This is the allowed variance in color (fuzzy color). %  %  */9 Export void ColorFloodfillImage(Image *image,int x,int y, +   const ColorPacket *color,const int delta)  {    int      offset, 	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket      target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */"   assert(image != (Image *) NULL);(   assert(color != (ColorPacket *) NULL);$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; &   if (ColorMatch(*color,target,delta))     return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      offset=p->y2;      y=p->y1+offset;      /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); +       if (!ColorMatch(*pixel,target,delta))          break;       pixel->red=color->red;        pixel->green=color->green;       pixel->blue=color->blue;     }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); 1             if (!ColorMatch(*pixel,target,delta))                break;"             pixel->red=color->red;&             pixel->green=color->green;$             pixel->blue=color->blue;           } #           Push(y,start,x-1,offset);            if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); ,         if (ColorMatch(*pixel,target,delta))           break;       }        start=x;     } while (x <= x2);   }    free((char *) segment_stack);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o l o r i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ColorizeImage colorizes an image with the pen color.  The amount8 %  of the coloring is controled with the opacity levels. % . %  The format of the ColorizeImage routine is: % 2 %      ColorizeImage(image,opaque_color,pen_color) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %    o opaque_color,F %      pen_color: A character string that contain an X11 color string. %  %  */> void ColorizeImage(Image *image,char *opacity,char *pen_color) { 8 #define ColorizeImageText  "  Colorizing the image...  "  
   ColorPacket      target;      int      blue_opacity, 
     count,     green_opacity,     red_opacity;     long
     value;     register int     i;     register RunlengthPacket     *p;      unsigned int     status;      XColor     target_color;      /**     Determine RGB values of the pen color.   */"   assert(image != (Image *) NULL);   if (opacity == (char *) NULL)      return; 6   status=XQueryColorDatabase(pen_color,&target_color);   if (status == False)     return; *   target.red=XDownScale(target_color.red);.   target.green=XDownScale(target_color.green);,   target.blue=XDownScale(target_color.blue);6   status=XQueryColorDatabase(pen_color,&target_color);   if (status == False)     return;    red_opacity=100;   green_opacity=100;   blue_opacity=100; M   count=sscanf(opacity,"%d/%d/%d",&red_opacity,&green_opacity,&blue_opacity);    if (count == 1)      {        if (red_opacity == 0)          return;         green_opacity=red_opacity;       blue_opacity=red_opacity;      }    switch (image->class)    {      case DirectClass:      default:     {        /*#         Colorize DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { K         value=(long) (p->red*(100-red_opacity)+target.red*red_opacity)/100;          if (value > MaxRGB)            p->red=MaxRGB;         else           if (value < 0)             p->red=0;            else#             p->red=(Quantum) value;          value=(long)H           (p->green*(100-green_opacity)+target.green*green_opacity)/100;         if (value > MaxRGB)            p->green=MaxRGB;         else           if (value < 0)             p->green=0;            else%             p->green=(Quantum) value; O         value=(long) (p->blue*(100-blue_opacity)+target.blue*blue_opacity)/100;          if (value > MaxRGB)            p->blue=MaxRGB;          else           if (value < 0)             p->blue=0;           else$             p->blue=(Quantum) value;         p++;!         if (QuantumTick(i,image)) >           ProgressMonitor(ColorizeImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*#         Colorize PseudoClass image.        */'       for (i=0; i < image->colors; i++)        {          value=(long)P           (image->colormap[i].red*(100-red_opacity)+target.red*red_opacity)/100;         if (value > MaxRGB) (           image->colormap[i].red=MaxRGB;         else           if (value < 0)%             image->colormap[i].red=0;            else3             image->colormap[i].red=(Quantum) value; C         value=(long) (image->colormap[i].green*(100-green_opacity)+ *           target.green*green_opacity)/100;         if (value > MaxRGB) *           image->colormap[i].green=MaxRGB;         else           if (value < 0)'             image->colormap[i].green=0;            else5             image->colormap[i].green=(Quantum) value; A         value=(long) (image->colormap[i].blue*(100-blue_opacity)+ (           target.blue*blue_opacity)/100;         if (value > MaxRGB) )           image->colormap[i].blue=MaxRGB;          else           if (value < 0)&             image->colormap[i].blue=0;           else4             image->colormap[i].blue=(Quantum) value;       }        SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or sceneI %  number by embedding special format characters.  Embed %f for filename, I %  %m for magick, %w for width, %h for height, %s for scene number, or \n  %  for newline.  For example,  %  %     %f  %wx%h  %  %  produces an image comment of  %  %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % - %  The format of the CommentImage routine is:  % # %      CommentImage(image,comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */5 Export void CommentImage(Image *image,char *comments)  {    register char      *p,      *q;      unsigned int     indirection,     length;   "   assert(image != (Image *) NULL);'   if (image->comments != (char *) NULL) #     free((char *) image->comments);     image->comments=(char *) NULL;    if (comments == (char *) NULL)     return;    if (*comments == '\0')     return; !   indirection=(*comments == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         /*"         Read comments from a file.       */*       file=(FILE *) fopen(comments+1,"r");        if (file == (FILE *) NULL)	         { =           Warning("Unable to read comments file",comments+1);            return; 	         }        length=MaxTextExtent; '       comments=(char *) malloc(length); 6       for (q=comments; comments != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)            break;%         if ((q-comments+1) >= length)            {              *q='\0';             length<<=1; @             comments=(char *) realloc((char *) comments,length);*             if (comments == (char *) NULL)               break;(             q=comments+Extent(comments);           }          *q=(unsigned char) c;        }        (void) fclose(file);$       if (comments == (char *) NULL)	         { I           Warning("Unable to comments image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*+     Allocate and initialize image comments.    */
   p=comments; (   length=Extent(comments)+MaxTextExtent;*   image->comments=(char *) malloc(length);@   for (q=image->comments; image->comments != (char *) NULL; p++)   {      *q='\0';     if (*p == '\0')        break;4     if ((q-image->comments+MaxTextExtent) >= length)       {          length<<=1; J         image->comments=(char *) realloc((char *) image->comments,length);-         if (image->comments == (char *) NULL)            break;2         q=image->comments+Extent(image->comments);       }      /*0       Process formatting characters in comments.     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {          *q++='\n';         p++;         continue;        }      if (*p != '%')       {          *q++=(*p);         continue;        }      p++;     switch (*p)      {        case 'b':        { 5         (void) sprintf(q,"%ld",image->filesize/1000); 2         q=image->comments+Extent(image->comments);         break;       }        case 'f':        {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */0         if (Extent(image->magick_filename) == 0)           break;B         p=image->magick_filename+Extent(image->magick_filename)-1;?         while ((p > image->magick_filename) && (*(p-1) != '/'))            p--;         (void) strcpy(q,p);          q+=Extent(p);          break;       }        case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);2         q=image->comments+Extent(image->comments);         break;       }        case 'm':        { '         (void) strcpy(q,image->magick); !         q+=Extent(image->magick);          break;       }        case 's':        { ,         (void) sprintf(q,"%u",image->scene);2         q=image->comments+Extent(image->comments);         break;       }        case 'w':        { 5         (void) sprintf(q,"%u",image->magick_columns); 2         q=image->comments+Extent(image->comments);         break;       }        default:       {          *q++='%';          *q++=(*p);         break;       }      }    } '   if (image->comments == (char *) NULL)      { D       Warning("Unable to comment image","Memory allocation failed");
       return;      } 
   *q='\0';   if (indirection)     free((char *) comments); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s C o l o r m a p                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressColormap compresses an image colormap removing any %  unused color entries. % 1 %  The format of the CompressColormap routine is:  %  %      CompressColormap(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */# void CompressColormap(Image *image)  { 
   ColorPacket      *colormap;     int      number_colors;     register int     i;     register RunlengthPacket     *p;      register unsigned short 
     index;     /*,     Determine if colormap can be compressed.   */"   assert(image != (Image *) NULL);"   if (image->class != PseudoClass)     return;    number_colors=image->colors;#   for (i=0; i < image->colors; i++) #     image->colormap[i].flags=False;    image->colors=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { )     if (!image->colormap[p->index].flags)        { 6         image->colormap[p->index].index=image->colors;-         image->colormap[p->index].flags=True;          image->colors++;       }      p++;   } %   if (image->colors == number_colors) $     return;  /* no unused entries */   /*     Compress colormap.   */E   colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { H       Warning("Unable to compress colormap","Memory allocation failed");"       image->colors=number_colors;
       return;      } #   for (i=0; i < number_colors; i++) !     if (image->colormap[i].flags)        { '         index=image->colormap[i].index; 3         colormap[index].red=image->colormap[i].red; 7         colormap[index].green=image->colormap[i].green; 5         colormap[index].blue=image->colormap[i].blue;        }    /*     Remap pixels.    */   p=image->pixels;$   for (i=0; i < image->packets; i++)   { -     p->index=image->colormap[p->index].index;      p++;   } !   free((char *) image->colormap);    image->colormap=colormap;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p r e s s I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function CompressImage compresses an image to the minimum number of %  runlength-encoded packets.  % . %  The format of the CompressImage routine is: %  %      CompressImage(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */' Export void CompressImage(Image *image)  {    register int     i;     register RunlengthPacket     *p,      *q;      /*     Compress image.    */"   assert(image != (Image *) NULL);   if (image == (Image *) NULL)     return;    p=image->pixels;   image->runlength=p->length+1;    image->packets=0;    q=image->pixels;   q->length=MaxRunlength;    if (image->matte) 4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      }    else4     for (i=0; i < (image->columns*image->rows); i++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && C           (p->blue == q->blue) && ((int) q->length < MaxRunlength))          q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++;            *q=(*p);           q->length=0;	         }      } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    /*H     Runlength-encode only if it takes up less space than no compression.   */"   if (image->class == DirectClass)     { B       if (image->packets >= ((image->columns*image->rows*3) >> 2)))         image->compression=NoCompression; 
       return;      } <   if (image->packets >= ((image->columns*image->rows) >> 1))%     image->compression=NoCompression;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CompositeImage returns the second image composited onto the " %  first at the specified offsets. % / %  The format of the CompositeImage routine is:  % F %      CompositeImage(image,compose,composite_image,x_offset,y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */H Export void CompositeImage(Image *image,const CompositeOperator compose,?   Image *composite_image,const int x_offset,const int y_offset)  { 6 #define CompositeImageText  "  Compositing image...  "     long	     blue, 
     green,
     index,     red;  	   Quantum 
     shade;     register int     i,     x,     y;     register RunlengthPacket     *p,      *q;      /*     Check composite geometry.    */"   assert(image != (Image *) NULL);,   assert(composite_image != (Image *) NULL);.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { M       Warning("Unable to composite image","geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return;    switch (compose)   {      case XorCompositeOp:     case PlusCompositeOp:      case MinusCompositeOp:     case AddCompositeOp:     case SubtractCompositeOp:      case DifferenceCompositeOp:      case BumpmapCompositeOp:!     case MatteReplaceCompositeOp:      case AddMaskCompositeOp:     case BlendCompositeOp:       break;     case DisplaceCompositeOp:      {        double         x_displace,          y_displace;          float          horizontal_scale,          vertical_scale;          Image          *displaced_image;          register RunlengthPacket         *r;          /*%         Allocate the displaced image.        */#       composite_image->orphan=True; I       displaced_image=CopyImage(composite_image,composite_image->columns, %         composite_image->rows,False); $       composite_image->orphan=False;,       if (displaced_image == (Image *) NULL)	         { H           Warning("Unable to display image","Memory allocation failed");           return; 	         }        horizontal_scale=20.0;       vertical_scale=20.0;5       if (composite_image->geometry != (char *) NULL) 	         { 
           int              count;             /*E             Determine the horizontal and vertical displacement scale.            */;           count=sscanf(composite_image->geometry,"%fx%f\n", /             &horizontal_scale,&vertical_scale);            if (count == 1) ,             vertical_scale=horizontal_scale;	         }        /*<         Shift image pixels as defined by a displacement map.       */        p=composite_image->pixels;-       composite_image->runlength=p->length+1;         r=displaced_image->pixels;/       for (y=0; y < composite_image->rows; y++)        { @         if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))           continue; =         q=image->pixels+(y_offset+y)*image->columns+x_offset; 4         for (x=0; x < composite_image->columns; x++)	         { .           if (composite_image->runlength != 0))             composite_image->runlength--;            else
             {                p++;3               composite_image->runlength=p->length; 
             } E           if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 
             {                q++;               continue; 
             } >           x_displace=(horizontal_scale*((float) Intensity(*p)-2             ((MaxRGB+1) >> 1)))/((MaxRGB+1) >> 1);            y_displace=x_displace;%           if (composite_image->matte) 9             y_displace=(vertical_scale*((float) p->index- 4               ((MaxRGB+1) >> 1)))/((MaxRGB+1) >> 1);N           *r=Interpolate(image,q,x_offset+x+x_displace,y_offset+y+y_displace);           r->length=0;           q++;           r++;	         }        } &       composite_image=displaced_image;       break;     }      case ReplaceCompositeOp:     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)6         if ((composite_image->class == DirectClass) ||7             (composite_image->colors != image->colors)) #           image->class=DirectClass;          else           {              int                status;   =             status=memcmp((char *) composite_image->colormap, ?               (char *) image->colormap,composite_image->colors* #               sizeof(ColorPacket));              if (status != 0)'               image->class=DirectClass;            } 2       if (image->matte && !composite_image->matte)	         { $           p=composite_image->pixels;6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;             p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }        break;     }      default:     {        /*$         Initialize image matte data.       */       if (!image->matte)	         {            q=image->pixels;,           for (i=0; i < image->packets; i++)           {              q->index=Opaque;             q++;           } #           image->class=DirectClass;            image->matte=True;	         } "       if (!composite_image->matte)	         { $           p=composite_image->pixels;           red=p->red;            green=p->green;            blue=p->blue; 1           if (IsMonochromeImage(composite_image)) 
             { 8               red=composite_image->background_color.red;<               green=composite_image->background_color.green;:               blue=composite_image->background_color.blue;
             } 6           for (i=0; i < composite_image->packets; i++)           {              p->index=Opaque;9             if ((p->red == red) && (p->green == green) && "                 (p->blue == blue))#               p->index=Transparent;              p++;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }        break;     }    }    /*      Initialize composited image.   */   p=composite_image->pixels;)   composite_image->runlength=p->length+1; +   for (y=0; y < composite_image->rows; y++)    { <     if (((y_offset+y) < 0) || ((y_offset+y) >= image->rows))       continue; 9     q=image->pixels+(y_offset+y)*image->columns+x_offset; 0     for (x=0; x < composite_image->columns; x++)     { *       if (composite_image->runlength != 0)%         composite_image->runlength--; 
       else	         {            p++;/           composite_image->runlength=p->length; 	         } A       if (((x_offset+x) < 0) || ((x_offset+x) >= image->columns)) 	         {            q++;           continue; 	         }        switch (compose)       {          case OverCompositeOp:          default:	         { &           if (p->index == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue;                index=q->index; 
             }            else#             if (p->index == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue;                  index=p->index;                }              else               { K                 red=(long) (p->red*Opaque+q->red*(Opaque-p->index))/Opaque;                  green=(long)F                   (p->green*Opaque+q->green*(Opaque-p->index))/Opaque;N                 blue=(long) (p->blue*Opaque+q->blue*(Opaque-p->index))/Opaque;                 index=(long)F                   (p->index*Opaque+q->index*(Opaque-p->index))/Opaque;               }            break;	         }          case InCompositeOp: 	         { .           red=(long) (p->red*q->index)/Opaque;2           green=(long) (p->green*q->index)/Opaque;0           blue=(long) (p->blue*q->index)/Opaque;2           index=(long) (p->index*q->index)/Opaque;           break;	         }          case OutCompositeOp:	         { 7           red=(long) (p->red*(Opaque-q->index))/Opaque; ;           green=(long) (p->green*(Opaque-q->index))/Opaque; 9           blue=(long) (p->blue*(Opaque-q->index))/Opaque; ;           index=(long) (p->index*(Opaque-q->index))/Opaque;            break;	         }          case AtopCompositeOp: 	         { G           red=(long) (p->red*q->index+q->red*(Opaque-p->index))/Opaque; M           green=(long) (p->green*q->index+q->green*(Opaque-p->index))/Opaque; J           blue=(long) (p->blue*q->index+q->blue*(Opaque-p->index))/Opaque;M           index=(long) (p->index*q->index+q->index*(Opaque-p->index))/Opaque;            break;	         }          case XorCompositeOp:	         { P           red=(long) (p->red*(Opaque-q->index)+q->red*(Opaque-p->index))/Opaque;           green=(long)K             (p->green*(Opaque-q->index)+q->green*(Opaque-p->index))/Opaque;            blue=(long) I             (p->blue*(Opaque-q->index)+q->blue*(Opaque-p->index))/Opaque;            index=(long)K             (p->index*(Opaque-q->index)+q->index*(Opaque-p->index))/Opaque;            break;	         }          case PlusCompositeOp: 	         { *           red=(long) p->red+(long) q->red;0           green=(long) p->green+(long) q->green;-           blue=(long) p->blue+(long) q->blue; 0           index=(long) p->index+(long) q->index;           break;	         }          case MinusCompositeOp:	         { *           red=(long) p->red-(long) q->red;0           green=(long) p->green-(long) q->green;-           blue=(long) p->blue-(long) q->blue;            index=Opaque;            break;	         }          case AddCompositeOp:	         { *           red=(long) p->red+(long) q->red;           if (red > Opaque)              red-=(Opaque+1);0           green=(long) p->green+(long) q->green;           if (green > Opaque)              green-=(Opaque+1);-           blue=(long) p->blue+(long) q->blue;            if (blue > Opaque)             blue-=(Opaque+1); 0           index=(long) p->index+(long) q->index;           if (index > Opaque)              index-=(Opaque+1);           break;	         } !         case SubtractCompositeOp: 	         { *           red=(long) p->red-(long) q->red;           if (red < 0)             red+=(Opaque+1);0           green=(long) p->green-(long) q->green;           if (green < 0)             green+=(Opaque+1);-           blue=(long) p->blue-(long) q->blue;            if (blue < 0)              blue+=(Opaque+1); 0           index=(long) p->index-(long) q->index;           if (index < 0)             index+=(Opaque+1);           break;	         } #         case DifferenceCompositeOp: 	         { 9           red=AbsoluteValue((long) p->red-(long) q->red); ?           green=AbsoluteValue((long) p->green-(long) q->green); <           blue=AbsoluteValue((long) p->blue-(long) q->blue);?           index=AbsoluteValue((long) p->index-(long) q->index);            break;	         }           case BumpmapCompositeOp:	         {            shade=Intensity(*p);+           red=(long) (q->red*shade)/Opaque; /           green=(long) (q->green*shade)/Opaque; -           blue=(long) (q->blue*shade)/Opaque; /           index=(long) (q->index*shade)/Opaque;            break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         } %         case MatteReplaceCompositeOp: 	         {            red=q->red;            green=q->green;            blue=q->blue;            index=p->index;            break;	         }           case AddMaskCompositeOp:	         {            red=q->red;            green=q->green;            blue=q->blue; )           index=DownScale(Intensity(*p));            break;	         }          case BlendCompositeOp:	         { >           red=(long) (p->red*p->index+q->red*q->index)/Opaque;D           green=(long) (p->green*p->index+q->green*q->index)/Opaque;A           blue=(long) (p->blue*p->index+q->blue*q->index)/Opaque;            index=Opaque;            break;	         } !         case DisplaceCompositeOp: 	         {            red=p->red;            green=p->green;            blue=p->blue;            index=p->index;            break;	         }        }        if (red > MaxRGB)          q->red=MaxRGB;
       else         if (red < 0)           q->red=0;          else           q->red=(Quantum) red;        if (green > MaxRGB)          q->green=MaxRGB;
       else         if (green < 0)           q->green=0;          else#           q->green=(Quantum) green;        if (blue > MaxRGB)         q->blue=MaxRGB; 
       else         if (blue < 0)            q->blue=0;         else!           q->blue=(Quantum) blue;        if (index > Opaque)          q->index=Opaque;
       else          if (index < Transparent)           q->index=Transparent;          else*           q->index=(unsigned short) index;       q->length=0;
       q++;     } @     ProgressMonitor(CompositeImageText,y,composite_image->rows);   } "   if (compose == BlendCompositeOp)     image->matte=False; %   if (compose == DisplaceCompositeOp)      {        image->matte=False; $       DestroyImage(composite_image);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C o n t r a s t I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ContrastImage enhances the intensity differences between the, %  lighter and darker elements of the image. % . %  The format of the ContrastImage routine is: % # %      ContrastImage(image,sharpen)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % C %    o sharpen: If True, the intensity is increased otherwise it is  %      decreased.  %  %  */; void ContrastImage(Image *image,const unsigned int sharpen)  { > #define DullContrastImageText  "  Dulling image contrast...  "D #define SharpenContrastImageText  "  Sharpening image contrast...  "     int 	     sign;      register int     i;     register RunlengthPacket     *p;   "   assert(image != (Image *) NULL);   sign=sharpen ? 1 : -1;   switch (image->class)    {      case DirectClass:      default:     {        /*+         Contrast enhance DirectClass image.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { 2         Contrast(sign,&p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))            if (sharpen)G             ProgressMonitor(SharpenContrastImageText,i,image->packets);            elseD             ProgressMonitor(DullContrastImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*+         Contrast enhance PseudoClass image.        */'       for (i=0; i < image->colors; i++) H         Contrast(sign,&image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o p y I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function CopyImage returns a copy of all fields of the input image.  The B %  the pixel memory is allocated but the pixel data is not copied. % * %  The format of the CopyImage routine is: % ; %      copy_image=CopyImage(image,columns,rows,copy_pixels)  % + %  A description of each parameter follows:  % J %    o copy_image: Function CopyImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % H %    o copy_pixels: Specifies whether the pixel data is copied.  Must be %      either True or False; %  %  */@ Export Image *CopyImage(Image *image,const unsigned int columns,9   const unsigned int rows,const unsigned int copy_pixels)  {    Image      *copy_image;     register int     i;     /*     Allocate image structure.    */"   assert(image != (Image *) NULL);-   copy_image=(Image *) malloc(sizeof(Image)); #   if (copy_image == (Image *) NULL)      return((Image *) NULL);    *copy_image=(*image); '   if (image->comments != (char *) NULL)      {        /*-         Allocate and copy the image comments.        */#       copy_image->comments=(char *) 9         malloc((unsigned int) Extent(image->comments)+1); 0       if (copy_image->comments == (char *) NULL)         return((Image *) NULL); :       (void) strcpy(copy_image->comments,image->comments);     } $   if (image->label != (char *) NULL)     {        /**         Allocate and copy the image label.       */O       copy_image->label=(char *) malloc((unsigned int) Extent(image->label)+1); -       if (copy_image->label == (char *) NULL)          return((Image *) NULL); 4       (void) strcpy(copy_image->label,image->label);     }    copy_image->columns=columns;   copy_image->rows=rows;$   copy_image->montage=(char *) NULL;&   copy_image->directory=(char *) NULL;.   if (image->colormap != (ColorPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        */*       copy_image->colormap=(ColorPacket *)2         malloc(image->colors*sizeof(ColorPacket));7       if (copy_image->colormap == (ColorPacket *) NULL)          return((Image *) NULL); '       for (i=0; i < image->colors; i++) 3         copy_image->colormap[i]=image->colormap[i];      } (   if (image->signature != (char *) NULL)     {        /*.         Allocate and copy the image signature.       */$       copy_image->signature=(char *):         malloc((unsigned int) Extent(image->signature)+1);1       if (copy_image->signature == (char *) NULL)          return((Image *) NULL); <       (void) strcpy(copy_image->signature,image->signature);     }    /*     Allocate the image pixels.   */   if (copy_pixels)*     copy_image->pixels=(RunlengthPacket *)D       malloc((unsigned int) image->packets*sizeof(RunlengthPacket));   else     { ?       copy_image->packets=copy_image->columns*copy_image->rows; ,       copy_image->pixels=(RunlengthPacket *)K         malloc((unsigned int) copy_image->packets*sizeof(RunlengthPacket));      } 5   if (copy_image->pixels == (RunlengthPacket *) NULL)      return((Image *) NULL);    if (copy_pixels)     {        register RunlengthPacket         *p,          *q;          /*         Copy image pixels.       */       p=image->pixels;       q=copy_image->pixels; (       for (i=0; i < image->packets; i++)       {          *q=(*p);         p++;         q++;       }      } 3   copy_image->packed_pixels=(unsigned char *) NULL; #   if (image->page != (char *) NULL)      {        /*)         Allocate and copy the image page.        */M       copy_image->page=(char *) malloc((unsigned int) Extent(image->page)+1); ,       if (copy_image->page == (char *) NULL)         return((Image *) NULL); 2       (void) strcpy(copy_image->page,image->page);     }    if (image->orphan)     { %       copy_image->file=(FILE *) NULL; *       copy_image->previous=(Image *) NULL;&       copy_image->next=(Image *) NULL;     }    else     {        /*#         Link image into image list.        */1       if (copy_image->previous != (Image *) NULL) .         copy_image->previous->next=copy_image;-       if (copy_image->next != (Image *) NULL) .         copy_image->next->previous=copy_image;     }    copy_image->orphan=False;    return(copy_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function CropImage creates a new image that is a subregion of an existingJ %  one.  It allocates the memory necessary for the new Image structure andM %  returns a pointer to the new image.  This routine is optimized to perserve K %  the runlength encoding.  That is, the cropped image will always use less  %  memory than the original. % * %  The format of the CropImage routine is: % / %      cropped_image=CropImage(image,crop_info)  % + %  A description of each parameter follows:  % I %    o cropped_image: Function CropImage returns a pointer to the cropped J %      image.  A null image is returned if there is a a memory shortage or, %      if the image width or height is zero. % 7 %    o image: The address of a structure of type Image.  % J %    o crop_info: Specifies a pointer to a RectangleInfo which defines the# %      region of the image to crop.  %  %  */> Export Image *CropImage(Image *image,RectangleInfo *crop_info) { . #define CropImageText  "  Cropping image...  " #define DeltaX  16     char     geometry[MaxTextExtent];     Image      *cropped_image;      int      x,     y;     register RunlengthPacket     *p,      *q;      unsigned int     height, 
     width;     /*     Check crop geometry.   */"   assert(image != (Image *) NULL);.   assert(crop_info != (RectangleInfo *) NULL);4   if (((crop_info->x+(int) crop_info->width) < 0) ||5       ((crop_info->y+(int) crop_info->height) < 0) || .       (crop_info->x > (int) image->columns) ||)       (crop_info->y > (int) image->rows))      { H       Warning("Unable to crop image","geometry does not contain image");       return((Image *) NULL);      } C   if ((crop_info->x+(int) crop_info->width) > (int) image->columns) H     crop_info->width=(unsigned int) ((int) image->columns-crop_info->x);A   if ((crop_info->y+(int) crop_info->height) > (int) image->rows) F     crop_info->height=(unsigned int) ((int) image->rows-crop_info->y);   if (crop_info->x < 0)      { 7       crop_info->width-=(unsigned int) (-crop_info->x);        crop_info->x=0;      }    if (crop_info->y < 0)      { 8       crop_info->height-=(unsigned int) (-crop_info->y);       crop_info->y=0;      } :   if ((crop_info->width == 0) && (crop_info->height == 0))     {        register int
         i;         RunlengthPacket          corners[4];          /*1         Set bounding box to the image dimensions.        */       crop_info->width=0;        crop_info->height=0;"       crop_info->x=image->columns;       crop_info->y=image->rows;        p=image->pixels;#       image->runlength=p->length+1;        corners[0]=(*p);7       for (i=1; i <= (image->rows*image->columns); i++)        { "         if (image->runlength != 0)           image->runlength--;          else           {              p++;'             image->runlength=p->length;            }           if (i == image->columns)           corners[1]=(*p);?         if (i == (image->rows*image->columns-image->columns+1))            corners[2]=(*p);.         if (i == (image->rows*image->columns))           corners[3]=(*p);       }        p=image->pixels;#       image->runlength=p->length+1; %       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {                p++;)               image->runlength=p->length; 
             } 0           if (!ColorMatch(*p,corners[0],DeltaX))!             if (x < crop_info->x)                crop_info->x=x; 0           if (!ColorMatch(*p,corners[1],DeltaX))%             if (x > crop_info->width) !               crop_info->width=x; 0           if (!ColorMatch(*p,corners[0],DeltaX))!             if (y < crop_info->y)                crop_info->y=y; 0           if (!ColorMatch(*p,corners[2],DeltaX))&             if (y > crop_info->height)"               crop_info->height=y;	         }        } >       if ((crop_info->width != 0) || (crop_info->height != 0))	         { +           crop_info->width-=crop_info->x-1; ,           crop_info->height-=crop_info->y-1;	         }      } :   if ((crop_info->width == 0) || (crop_info->height == 0))     { E       Warning("Unable to crop image","geometry dimensions are zero");        return((Image *) NULL);      } -   if ((crop_info->width == image->columns) && B       (crop_info->height == image->rows) && (crop_info->x == 0) &&       (crop_info->y == 0))     return((Image *) NULL);    /*(     Initialize cropped image attributes.   */I   cropped_image=CopyImage(image,crop_info->width,crop_info->height,True); &   if (cropped_image == (Image *) NULL)     { A       Warning("Unable to crop image","Memory allocation failed");        return((Image *) NULL);      }    /*     Set cropped page geometry.   */   x=0;   y=0;   width=crop_info->width;    height=crop_info->height; +   if (cropped_image->page != (char *) NULL) D     (void) XParseGeometry(cropped_image->page,&x,&y,&width,&height);D   (void) sprintf(geometry,"%ux%u%+d%+d",width,height,x+crop_info->x,     y+crop_info->y);3   cropped_image->page=PostscriptGeometry(geometry);    /*(     Skip pixels up to the cropped image.   */   p=image->pixels;   image->runlength=p->length+1; @   for (x=0; x < (crop_info->y*image->columns+crop_info->x); x++)     if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }    /*     Extract cropped image.   */   cropped_image->packets=0;    q=cropped_image->pixels;   q->red=0; 
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength; -   for (y=0; y < (cropped_image->rows-1); y++)    {      /*       Transfer scanline.     */.     for (x=0; x < cropped_image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } 9       if ((p->red == q->red) && (p->green == q->green) && ;           (p->blue == q->blue) && (p->index == q->index) && +           ((int) q->length < MaxRunlength))          q->length++;
       else	         { *           if (cropped_image->packets != 0)             q++;#           cropped_image->packets++;            *q=(*p);           q->length=0;	         }      }      /*       Skip to next scanline.     */E     for (x=0; x < (int) (image->columns-cropped_image->columns); x++)         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         } ;     ProgressMonitor(CropImageText,y,cropped_image->rows-1);    }    /*     Transfer last scanline.    */,   for (x=0; x < cropped_image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        } 7     if ((p->red == q->red) && (p->green == q->green) && 9         (p->blue == q->blue) && (p->index == q->index) && )         ((int) q->length < MaxRunlength))        q->length++;     else       { (         if (cropped_image->packets != 0)           q++;!         cropped_image->packets++;          *q=(*p);         q->length=0;       }    } <   cropped_image->pixels=(RunlengthPacket *) realloc((char *)J     cropped_image->pixels,cropped_image->packets*sizeof(RunlengthPacket));   return(cropped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C y c l e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function CycleColormapImage cycles the image colormap by a specified 
 %  amount. % 3 %  The format of the CycleColormapImage routine is:  % ' %      CycleColormapImage(image,amount)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o amount:  An unsigned value that specifies the offset of the colormap. %  %  */0 void CycleColormapImage(Image *image,int amount) { 6 #define CycleColormapImageText  "  Cycling image...  "     int 
     index;     register RunlengthPacket     *q;      register unsigned int      i;  "   assert(image != (Image *) NULL);"   if (image->class == DirectClass)     {        QuantizeInfo         quantize_info;  &       GetQuantizeInfo(&quantize_info);2       quantize_info.number_colors=MaxColormapSize;*       QuantizeImage(&quantize_info,image);     }    q=image->pixels;$   for (i=0; i < image->packets; i++)   { 2     index=((int) q->index+amount) % image->colors;     if (index < 0)       index+=image->colors; $     q->index=(unsigned short) index;     q++;   }    SyncImage(image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DescribeImage describes an image by printing its attributes to
 %  stderr. % . %  The format of the DescribeImage routine is: % ( %      DescribeImage(image,file,verbose) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 4 %    o file: send the image attributes to this file. % M %    o verbose: an unsigned value other than zero prints detailed information  %      about the image.  %  %  */M Export void DescribeImage(Image *image,FILE *file,const unsigned int verbose)  {    char     **textlist;      Image      *p;      register int     i;     unsigned int
     count;  "   assert(image != (Image *) NULL);    assert(file != (FILE *) NULL);   if (!verbose)      {        /*.         Display detailed info about the image.       */*       if (*image->magick_filename != '\0')@         if (strcmp(image->magick_filename,image->filename) != 0)=           (void) fprintf(file,"%s=>",image->magick_filename); 1        if ((image->previous == (Image *) NULL) && B            (image->next == (Image *) NULL) && (image->scene == 0))3         (void) fprintf(file,"%s ",image->filename); 
       elseD         (void) fprintf(file,"%s[%u] ",image->filename,image->scene);D       if ((image->magick_columns != 0) || (image->magick_rows != 0))8         if ((image->magick_columns != image->columns) ||0             (image->magick_rows != image->rows))>           (void) fprintf(file,"%ux%u=>",image->magick_columns,              image->magick_rows);'       if (image->page == (char *) NULL) A         (void) fprintf(file,"%ux%u ",image->columns,image->rows); 
       else	         { 
           int              x,             y;             unsigned int             sans;   ?           (void) XParseGeometry(image->page,&x,&y,&sans,&sans); M           (void) fprintf(file,"%ux%u%+d%+d ",image->columns,image->rows,x,y); 	         } &       if (image->class == DirectClass)	         { .           (void) fprintf(file,"DirectClass ");'           if (image->total_colors != 0) =             (void) fprintf(file,"%luc ",image->total_colors); 	         } 
       else1         if (image->total_colors <= image->colors) @           (void) fprintf(file,"PseudoClass %uc ",image->colors);         else           { L             (void) fprintf(file,"PseudoClass %lu=>%uc ",image->total_colors,               image->colors); M             (void) fprintf(file,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, L               image->normalized_mean_error,image->normalized_maximum_error);           }        if (image->filesize != 0) 5         (void) fprintf(file,"%ldb ",image->filesize); J       (void) fprintf(file,"%s %lds\n",image->magick,time((time_t *) NULL)-         image->magick_time+1);
       return;      }    /*)     Display verbose info about the image.    */5   (void) fprintf(file,"Image: %s\n",image->filename); "   if (image->class == DirectClass)2     (void) fprintf(file,"  class: DirectClass\n");   else2     (void) fprintf(file,"  class: PseudoClass\n");"   if (image->class == DirectClass)     { "       if (image->total_colors > 0)C         (void) fprintf(file,"  colors: %lu\n",image->total_colors);      }    else-     if (image->total_colors <= image->colors) :       (void) fprintf(file,"  colors: %u\n",image->colors);     elseD       (void) fprintf(file,"  colors: %lu=>%u\n",image->total_colors,         image->colors); "   if (image->class == DirectClass)     { %       if (image->total_colors < 1024) !         NumberColors(image,file);      }    else     { 
       char         name[MaxTextExtent];         ColorPacket          *p;          double         distance_squared,          min_distance;   	       int          distance;          register int
         i;         register XColorlist          *q;          /*         Display image colormap.        */       p=image->colormap;'       for (i=0; i < image->colors; i++)        { C         (void) fprintf(file,"    %d: (%3d,%3d,%3d)  #%02x%02x%02x", :           i,p->red,p->green,p->blue,(unsigned int) p->red,:           (unsigned int) p->green,(unsigned int) p->blue);)         min_distance=3.0*65536.0*65536.0; 8         for (q=Colorlist; q->name != (char *) NULL; q++)	         { 8           distance=(int) DownScale(p->red)-(int) q->red;>           distance_squared=(unsigned int) (distance*distance);<           distance=(int) DownScale(p->green)-(int) q->green;?           distance_squared+=(unsigned int) (distance*distance); :           distance=(int) DownScale(p->blue)-(int) q->blue;?           distance_squared+=(unsigned int) (distance*distance); .           if (distance_squared < min_distance)
             { ,               min_distance=distance_squared;*               (void) strcpy(name,q->name);
             } 	         } "         (void) fprintf(file,"  ");         if (min_distance < 16)           { !             if (min_distance > 0) '               (void) fprintf(file,"~"); +             (void) fprintf(file,"%s",name);            } "         (void) fprintf(file,"\n");         p++;       }      } (   if (image->signature != (char *) NULL)>     (void) fprintf(file,"  signature: %s\n",image->signature);   if (image->matte) +     (void) fprintf(file,"  matte: True\n");    else,     (void) fprintf(file,"  matte: False\n");   if (image->gamma != 0.0)6     (void) fprintf(file,"  gamma: %f\n",image->gamma);4   if (image->packets < (image->columns*image->rows))I     (void) fprintf(file,"  runlength packets: %u of %u\n",image->packets, "       image->columns*image->rows);H   (void) fprintf(file,"  geometry: %ux%u\n",image->columns,image->rows);C   if ((image->x_resolution != 0.0) && (image->y_resolution != 0.0))      {        /*!         Display image resolution.        */D       (void) fprintf(file,"  resolution: %gx%g",image->x_resolution,         image->y_resolution); .       if (image->units == UndefinedResolution))         (void) fprintf(file," pixels\n"); 
       else4         if (image->units == PixelsPerInchResolution)0           (void) fprintf(file," pixels/inch\n");         else<           if (image->units == PixelsPerCentimeterResolution)8             (void) fprintf(file," pixels/centimeter\n");           else&             (void) fprintf(file,"\n");     } 4   (void) fprintf(file,"  depth: %u\n",image->depth);   if (image->filesize != 0) :     (void) fprintf(file,"  bytes: %ld\n",image->filesize);   if (image->interlace) 0     (void) fprintf(file,"  interlaced: True\n");   else1     (void) fprintf(file,"  interlaced: False\n"); #   if (image->page != (char *) NULL) =     (void) fprintf(file,"  page geometry: %s\n",image->page);    if (image->dispose) A     (void) fprintf(file,"  dispose method: %d\n",image->dispose);    if (image->delay) 6     (void) fprintf(file,"  delay: %d\n",image->delay);   if (image->iterations != 1) @     (void) fprintf(file,"  iterations: %d\n",image->iterations);6   (void) fprintf(file,"  format: %s\n",image->magick);
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)B     (void) fprintf(file,"  scene: %u of %u\n",image->scene,count);   else     if (image->scene != 0)8       (void) fprintf(file,"  scene: %u\n",image->scene);$   if (image->label != (char *) NULL)6     (void) fprintf(file,"  label: %s\n",image->label);'   if (image->comments != (char *) NULL)      {        /*         Display image comment.       */+       (void) fprintf(file,"  comments:\n"); -       textlist=StringToList(image->comments); %       if (textlist != (char **) NULL) 	         { 6           for (i=0; textlist[i] != (char *) NULL; i++)           { 6             (void) fprintf(file,"  %s\n",textlist[i]);             free(textlist[i]);           } "           free((char *) textlist);	         }      } &   if (image->montage != (char *) NULL):     (void) fprintf(file,"  montage: %s\n",image->montage);(   if (image->directory != (char *) NULL)     { 
       char          filename[MaxTextExtent];         Image          *tile;         ImageInfo          image_info;          register char          *p,          *q;          /*'         Display visual image directory.        */        GetImageInfo(&image_info);#       image_info.filename=filename;        image_info.size="64x64";,       (void) fprintf(file,"  directory:\n");/       for (p=image->directory; *p != '\0'; p++)        {          q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;2         (void) strncpy(image_info.filename,p,q-p);&         image_info.filename[q-p]='\0';         p=q;:         (void) fprintf(file,"    %s",image_info.filename);$         tile=ReadImage(&image_info);#         if (tile == (Image *) NULL)            { &             (void) fprintf(file,"\n");             continue;            } ?         (void) fprintf(file," %ux%u %s\n",tile->magick_columns, *           tile->magick_rows,tile->magick);,         if (tile->comments != (char *) NULL)           {              /*#               Display tile comment.              */2             textlist=StringToList(tile->comments);+             if (textlist != (char **) NULL)                { <                 for (i=0; textlist[i] != (char *) NULL; i++)                 { >                   (void) fprintf(file,"    %s\n",textlist[i]);$                   free(textlist[i]);                 } (                 free((char *) textlist);               }            }          DestroyImage(tile);        }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function DestroyImage deallocates memory associated with an image.  % - %  The format of the DestroyImage routine is:  %  %      DestroyImage(image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */& Export void DestroyImage(Image *image) {    /*     Close image.   */"   assert(image != (Image *) NULL);#   if (image->file != (FILE *) NULL)      CloseImage(image);   /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL) #     free((char *) image->comments);    /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)      free((char *) image->label);   /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)"     free((char *) image->montage);(   if (image->directory != (char *) NULL)$     free((char *) image->directory);   /*"     Deallocate the image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)$     free((char *) image->signature);   /*      Deallocate the image pixels.   */0   if (image->pixels != (RunlengthPacket *) NULL)!     free((char *) image->pixels); 5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);   /*'     Deallocate the image page geometry.    */#   if (image->page != (char *) NULL)      free((char *) image->page);    if (!image->orphan)      {        /*          Unlink from linked list.       */,       if (image->previous != (Image *) NULL)*         if (image->next != (Image *) NULL),           image->previous->next=image->next;         else/           image->previous->next=(Image *) NULL; (       if (image->next != (Image *) NULL).         if (image->previous != (Image *) NULL)0           image->next->previous=image->previous;         else/           image->next->previous=(Image *) NULL;      }    /*#     Deallocate the image structure.    */   free((char *) image);    image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function DestroyImages deallocates memory associated with a linked list
 %  of images.  % . %  The format of the DestroyImages routine is: %  %      DestroyImages(image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */' Export void DestroyImages(Image *image)  {    Image      *next_image;     /*)     Proceed to the top of the image list.    */"   assert(image != (Image *) NULL);+   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next; $     if (next_image != (Image *)NULL))       next_image->previous=(Image *)NULL;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D r a w I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function DrawImage draws a primitive (line, rectangle, ellipse) on the 	 %  image.  % * %  The format of the DrawImage routine is: % % %      DrawImage(image,annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % : %    o annotate_info: The address of a DrawInfo structure. %  %  */8 void DrawImage(Image *image,AnnotateInfo *annotate_info) { 0 #define DrawImageText  "  Drawing on image...  "     char     keyword[MaxTextExtent];      int      n,     y;     PrimitiveInfo      *primitive_info;     PrimitiveType      primitive;     register char      *p;      register int     i,     j,     x;     register RunlengthPacket     *q;      unsigned int     indirection,     length,      number_coordinates;      XColor     pen_color;     /*(     Ensure the annotation info is valid.   */"   assert(image != (Image *) NULL);1   assert(annotate_info != (AnnotateInfo *) NULL); 0   if (annotate_info->primitive == (char *) NULL)     return;    if (!UncompressImage(image))     return; 1   indirection=(*annotate_info->primitive == '@');    if (indirection)     { 
       FILE         *file;  	       int 
         c;         register char          *q;          /*         Read text from a file.       */:       file=(FILE *) fopen(annotate_info->primitive+1,"r");        if (file == (FILE *) NULL)	         { N           Warning("Unable to read primitive file",annotate_info->primitive+1);           return; 	         }        length=MaxTextExtent; 7       annotate_info->primitive=(char *) malloc(length); !       q=annotate_info->primitive; 7       while (annotate_info->primitive != (char *) NULL)        {          c=fgetc(file);         if (c == EOF)            break;5         if ((q-annotate_info->primitive+1) >= length)            {              *q='\0';             length<<=1; -             annotate_info->primitive=(char *) 7               realloc(annotate_info->primitive,length); :             if (annotate_info->primitive == (char *) NULL)               break;H             q=annotate_info->primitive+Extent(annotate_info->primitive);           }          *q++=(unsigned char) c;        }        (void) fclose(file);4       if (annotate_info->primitive == (char *) NULL)	         { E           Warning("Unable to draw image","Memory allocation failed");            return; 	         }        *q='\0';     }    /*#     Allocate primitive info memory.    */   number_coordinates=2048;"   primitive_info=(PrimitiveInfo *)5     malloc(number_coordinates*sizeof(PrimitiveInfo)); F   annotate_info->geometry=(char *) malloc(MaxTextExtent*sizeof(char));   annotate_info->text=(char *):     malloc(Extent(annotate_info->primitive)*sizeof(char));3   if ((primitive_info == (PrimitiveInfo *) NULL) || 3       (annotate_info->geometry == (char *) NULL) || -       (annotate_info->text == (char *) NULL))      {        if (indirection)0         free((char *) annotate_info->primitive);A       Warning("Unable to draw image","Memory allocation failed"); 
       return;      }    /*#     Parse the primitive attributes.    */<   (void) XQueryColorDatabase(annotate_info->pen,&pen_color);   image->class=DirectClass;    primitive=UndefinedPrimitive;    p=annotate_info->primitive;    for (i=0; *p != '\0'; )    {      /*       Define primitive.      */     while (isspace(*p)) 
       p++;     for (x=0; isalpha(*p); x++)      {        keyword[x]=(*p);
       p++;     } !     primitive=UndefinedPrimitive; ,     if (Latin1Compare("Point",keyword) == 0)       primitive=PointPrimitive; +     if (Latin1Compare("Line",keyword) == 0)        primitive=LinePrimitive;0     if (Latin1Compare("Rectangle",keyword) == 0)#       primitive=RectanglePrimitive; 4     if (Latin1Compare("FillRectangle",keyword) == 0)'       primitive=FillRectanglePrimitive; -     if (Latin1Compare("Circle",keyword) == 0) !       primitive=EllipsePrimitive; 1     if (Latin1Compare("FillCircle",keyword) == 0) %       primitive=FillEllipsePrimitive; .     if (Latin1Compare("Polygon",keyword) == 0)!       primitive=PolygonPrimitive; 2     if (Latin1Compare("FillPolygon",keyword) == 0)%       primitive=FillPolygonPrimitive; ,     if (Latin1Compare("Color",keyword) == 0)       primitive=ColorPrimitive; ,     if (Latin1Compare("Matte",keyword) == 0)       primitive=MattePrimitive; +     if (Latin1Compare("Text",keyword) == 0)        primitive=TextPrimitive;,     if (Latin1Compare("Image",keyword) == 0)       primitive=ImagePrimitive; (     if (primitive == UndefinedPrimitive)       break;     j=i;     for (x=0; *p != '\0'; x++)     {        /*         Define points.       */       while (isspace(*p))          p++;       if (!IsGeometry(p))          break;,       primitive_info[i].primitive=primitive;&       primitive_info[i].coordinates=0;M       (void) sscanf(p,"%d%d%n",&primitive_info[i].x,&primitive_info[i].y,&n); N       (void) sscanf(p,"%d,%d%n",&primitive_info[i].x,&primitive_info[i].y,&n);O       (void) sscanf(p,"%d, %d%n",&primitive_info[i].x,&primitive_info[i].y,&n); N       (void) sscanf(p,"%d %d%n",&primitive_info[i].x,&primitive_info[i].y,&n);       p+=n; 
       i++;%       if (i < (number_coordinates-1))          continue;        number_coordinates<<=1; &       primitive_info=(PrimitiveInfo *)I         realloc(primitive_info,number_coordinates*sizeof(PrimitiveInfo)); 3       if (primitive_info != (PrimitiveInfo *) NULL)          continue;        if (indirection)0         free((char *) annotate_info->primitive);-       free((char *) annotate_info->geometry); )       free((char *) annotate_info->text); A       Warning("Unable to draw image","Memory allocation failed"); 
       return;      } $     primitive_info[j].coordinates=x;-     primitive_info[j].method=FloodfillMethod; G     if ((primitive == ColorPrimitive) || (primitive == MattePrimitive))        { 
         /*           Define method.
         */         while (isspace(*p))            p++;#         for (x=0; isalpha(*p); x++) 	         {            keyword[x]=(*p);           p++;	         } 0         if (Latin1Compare("point",keyword) == 0)/           primitive_info[j].method=PointMethod;          else4           if (Latin1Compare("replace",keyword) == 0)3             primitive_info[j].method=ReplaceMethod;            else8             if (Latin1Compare("floodfill",keyword) == 0)7               primitive_info[j].method=FloodfillMethod;              else6               if (Latin1Compare("reset",keyword) == 0)5                 primitive_info[j].method=ResetMethod;                else-                 primitive=UndefinedPrimitive;          while (*p != '\0')           p++;       } )     primitive_info[j].text=(char *) NULL; F     if ((primitive == TextPrimitive) || (primitive == ImagePrimitive))       { !         primitive_info[j].text=p;          if (*p == '"')6           for (p++; (*p != '"') && (*p != '\0'); p++);         else6           for (p++; (*p != ' ') && (*p != '\0'); p++);         if (*p != '\0')            p++;       }    } 1   primitive_info[i].primitive=UndefinedPrimitive; &   if (primitive == UndefinedPrimitive)     { ?       Warning("Non-conforming drawing primitive definition",p); $       free((char *) primitive_info);       if (indirection)0         free((char *) annotate_info->primitive);-       free((char *) annotate_info->geometry); )       free((char *) annotate_info->text); 
       return;      }    /*$     Draw the primitive on the image.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { B       if (InsidePrimitive(primitive_info,annotate_info,x,y,image))	         { +           q->red=XDownScale(pen_color.red); /           q->green=XDownScale(pen_color.green); -           q->blue=XDownScale(pen_color.blue); 	         } 
       q++;     } 1     ProgressMonitor(DrawImageText,y,image->rows);    }     free((char *) primitive_info);   if (indirection),     free((char *) annotate_info->primitive);)   free((char *) annotate_info->geometry); %   free((char *) annotate_info->text);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     E q u a l i z e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function EqualizeImage performs histogram equalization on the reference	 %  image.  % . %  The format of the EqualizeImage routine is: %  %      EqualizeImage(image)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */  void EqualizeImage(Image *image) { 4 #define EqualizeImageText  "  Equalizing image...  "  	   Quantum      *equalize_map;     register int     i,     j;     register RunlengthPacket     *p;      unsigned int	     high,      *histogram,      low,	     *map;      /*-     Allocate and initialize histogram arrays.    */"   assert(image != (Image *) NULL);E   histogram=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); ?   map=(unsigned int *) malloc((MaxRGB+1)*sizeof(unsigned int)); >   equalize_map=(Quantum *) malloc((MaxRGB+1)*sizeof(Quantum));O   if ((histogram == (unsigned int *) NULL) || (map == (unsigned int *) NULL) || )       (equalize_map == (Quantum *) NULL))      { E       Warning("Unable to equalize image","Memory allocation failed"); 
       return;      }    /*     Form histogram.    */   for (i=0; i <= MaxRGB; i++)      histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   { ,     histogram[Intensity(*p)]+=(p->length+1);     p++;   }    /*8     Integrate the histogram to get the equalization map.   */   j=0;   for (i=0; i <= MaxRGB; i++)    {      j+=histogram[i];
     map[i]=j;    }    free((char *) histogram);    if (map[MaxRGB] == 0)      { "       free((char *) equalize_map);       free((char *) map); 
       return;      }    /*
     Equalize.    */
   low=map[0];    high=map[MaxRGB];    for (i=0; i <= MaxRGB; i++)      equalize_map[i]=(Quantum) 9       ((((double) (map[i]-low))*MaxRGB)/Max(high-low,1));    free((char *) map);    /*     Stretch the histogram.   */   switch (image->class)    {      case DirectClass:      default:     {        /*%         Equalize DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { $         p->red=equalize_map[p->red];(         p->green=equalize_map[p->green];&         p->blue=equalize_map[p->blue];         p++;!         if (QuantumTick(i,image)) >           ProgressMonitor(EqualizeImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*%         Equalize PseudoClass packets.        */'       for (i=0; i < image->colors; i++)        { D         image->colormap[i].red=equalize_map[image->colormap[i].red];H         image->colormap[i].green=equalize_map[image->colormap[i].green];F         image->colormap[i].blue=equalize_map[image->colormap[i].blue];       }        SyncImage(image);        break;     }    }    free((char *) equalize_map); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l i p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlipImage creates a new image that reflects each scanline in theI %  vertical direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlipImage routine is: % % %      flipped_image=FlipImage(image)  % + %  A description of each parameter follows:  % G %    o flipped_image: Function FlipImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlipImage(Image *image) { . #define FlipImageText  "  Flipping image...  "     Image      *flipped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flipped image attributes.   */"   assert(image != (Image *) NULL);B   flipped_image=CopyImage(image,image->columns,image->rows,False);&   if (flipped_image == (Image *) NULL)     { A       Warning("Unable to flip image","Memory allocation failed");        return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flipped_image);       return((Image *) NULL);      }    /*     Flip each row.   */   p=image->pixels;   image->runlength=p->length+1; 3   q=flipped_image->pixels+flipped_image->packets-1; )   for (y=0; y < flipped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flip each column.      */     s=scanline+image->columns;.     for (x=0; x < flipped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q--;     } 9     ProgressMonitor(FlipImageText,y,flipped_image->rows);    }    free((char *) scanline);   return(flipped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F l o p I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function FlopImage creates a new image that reflects each scanline in theK %  horizontal direction It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FlopImage routine is: % % %      flopped_image=FlopImage(image)  % + %  A description of each parameter follows:  % G %    o flopped_image: Function FlopImage returns a pointer to the image G %      after reflecting.  A null image is returned if there is a memory  %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */ Image *FlopImage(Image *image) { . #define FlopImageText  "  Flopping image...  "     Image      *flopped_image;      register RunlengthPacket     *p,      *q,      *s;      register unsigned int      x,     y;     RunlengthPacket      *scanline;     /*(     Initialize flopped image attributes.   */"   assert(image != (Image *) NULL);B   flopped_image=CopyImage(image,image->columns,image->rows,False);&   if (flopped_image == (Image *) NULL)     { D       Warning("Unable to reflect image","Memory allocation failed");       return((Image *) NULL);      }    /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));+   if (scanline == (RunlengthPacket *) NULL)      { D       Warning("Unable to reflect image","Memory allocation failed");"       DestroyImage(flopped_image);       return((Image *) NULL);      }    /*     Flop each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=flopped_image->pixels;)   for (y=0; y < flopped_image->rows; y++)    {      /*       Read a scan line.      */     s=scanline; &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *s=(*p);
       s++;     }      /*       Flop each column.      */     s=scanline+image->columns;.     for (x=0; x < flopped_image->columns; x++)     { 
       s--;       *q=(*s);       q->length=0;
       q++;     } 9     ProgressMonitor(FlopImageText,y,flopped_image->rows);    }    free((char *) scanline);   return(flopped_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F r a m e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function FrameImage takes an image and puts a frame around it of a I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % + %  The format of the FrameImage routine is:  % 0 %      framed_image=FrameImage(image,frame_info) % + %  A description of each parameter follows:  % H %    o framed_image: Function FrameImage returns a pointer to the framedH %      image.  A null image is returned if there is a a memory shortage. % 7 %    o image: The address of a structure of type Image.  % E %    o frame_info: Specifies a pointer to a FrameInfo structure which ! %      defines the framed region.  %  %  */5 Image *FrameImage(Image *image,FrameInfo *frame_info)  { 6 #define FrameImageText  "  Adding frame to image...  "     Image      *framed_image;     int      height, 
     width;     register int     x,     y;     register RunlengthPacket     *p,      *q;      RunlengthPacket      accentuate,      highlight,
     matte,     shadow,      trough;      unsigned int     bevel_width;     /*     Check frame geometry.    */"   assert(image != (Image *) NULL);+   assert(frame_info != (FrameInfo *) NULL); E   if ((frame_info->outer_bevel < 0) || (frame_info->inner_bevel < 0))      { A       Warning("Unable to frame image","bevel width is negative");        return((Image *) NULL);      } >   bevel_width=frame_info->outer_bevel+frame_info->inner_bevel;:   width=(int) frame_info->width-frame_info->x-bevel_width;<   height=(int) frame_info->height-frame_info->y-bevel_width;9   if ((width < image->columns) || (height < image->rows))      { G       Warning("Unable to frame image","frame is less than image size");        return((Image *) NULL);      }    /*'     Initialize framed image attributes.    */K   framed_image=CopyImage(image,frame_info->width,frame_info->height,False); %   if (framed_image == (Image *) NULL)      { B       Warning("Unable to frame image","Memory allocation failed");       return((Image *) NULL);      }    image->class=DirectClass;    /*      Initialize 3D effects color.   */#   matte.red=image->matte_color.red; '   matte.green=image->matte_color.green; %   matte.blue=image->matte_color.blue;    matte.index=Opaque;    matte.length=0; >   accentuate.red=(unsigned int) (matte.red*AccentuateModulate+/     (MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB; B   accentuate.green=(unsigned int) (matte.green*AccentuateModulate+/     (MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB; @   accentuate.blue=(unsigned int) (matte.blue*AccentuateModulate+/     (MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB;    accentuate.index=Opaque;   accentuate.length=0;<   highlight.red=(unsigned int) (matte.red*HighlightModulate+.     (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;@   highlight.green=(unsigned int) (matte.green*HighlightModulate+.     (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;>   highlight.blue=(unsigned int) (matte.blue*HighlightModulate+.     (MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB;   highlight.index=Opaque;    highlight.length=0; >   shadow.red=(unsigned int) (matte.red*ShadowModulate)/MaxRGB;B   shadow.green=(unsigned int) (matte.green*ShadowModulate)/MaxRGB;@   shadow.blue=(unsigned int) (matte.blue*ShadowModulate)/MaxRGB;   shadow.index=Opaque;   shadow.length=0;>   trough.red=(unsigned int) (matte.red*TroughModulate)/MaxRGB;B   trough.green=(unsigned int) (matte.green*TroughModulate)/MaxRGB;@   trough.blue=(unsigned int) (matte.blue*TroughModulate)/MaxRGB;   trough.index=Opaque;   trough.length=0;   /*.     Put an ornamental border around the image.   */   q=framed_image->pixels; -   for (y=0; y < frame_info->outer_bevel; y++)    { 7     for (x=0; x < (int) (framed_image->columns-y); x++)        if (x < y)         *q++=highlight; 
       else         *q++=accentuate;+     for ( ; x < framed_image->columns; x++)        *q++=shadow;   } 7   for (y=0; y < (int) (frame_info->y-bevel_width); y++)    { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; T     for (x=0; x < (int) (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } -   for (y=0; y < frame_info->inner_bevel; y++)    { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 9     for (x=0; x < (int) (frame_info->x-bevel_width); x++)        *q++=matte; O     for (x=0; x < (int) (image->columns+(frame_info->inner_bevel << 1)-y); x++)        if (x < y)         *q++=shadow;
       else         *q++=trough;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   }    p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)    {      /*,       Initialize scanline with border color.     *//     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 9     for (x=0; x < (int) (frame_info->x-bevel_width); x++)        *q++=matte; /     for (x=0; x < frame_info->inner_bevel; x++)        *q++=shadow;     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length; 	         }        *q=(*p);       q->length=0;
       q++;     } /     for (x=0; x < frame_info->inner_bevel; x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;2     ProgressMonitor(FrameImageText,y,image->rows);   } 0   for (y=frame_info->inner_bevel-1; y >= 0; y--)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 9     for (x=0; x < (int) (frame_info->x-bevel_width); x++)        *q++=matte;      for (x=0; x < y; x++)        *q++=shadow;E     for ( ; x < (image->columns+(frame_info->inner_bevel << 1)); x++) A       if (x >= (image->columns+(frame_info->inner_bevel << 1)-y))          *q++=highlight; 
       else         *q++=accentuate;E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } B   height=frame_info->height-frame_info->y-image->rows-bevel_width;   for (y=0; y < height; y++)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; T     for (x=0; x < (int) (framed_image->columns-(frame_info->outer_bevel << 1)); x++)       *q++=matte;%/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } 0   for (y=frame_info->outer_bevel-1; y >= 0; y--)   {      for (x=0; x < y; x++)        *q++=highlight; +     for ( ; x < framed_image->columns; x++) )       if (x >= (framed_image->columns-y))          *q++=shadow;
       else         *q++=trough;   }A   return(framed_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     G a m m a I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function GammaImage converts the reference image to gamma corrected colors. % + %  The format of the GammaImage routine is:  %  %      GammaImage(image,gamma) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % J %    o gamma: A character string indicating the level of gamma correction. %  %  */) void GammaImage(Image *image,char *gamma)  { ; #define GammaImageText  "  Gamma correcting the image...  "   
   ColorPacket      *gamma_map;      double     blue_gamma,p     green_gamma,     red_gamma;     intm
     count;     register int     i;     register RunlengthPacket     *p;   "   assert(image != (Image *) NULL);   if (gamma == (char *) NULL)y     return;    red_gamma=1.0;   green_gamma=1.0;   blue_gamma=1.0;rH   count=sscanf(gamma,"%lf,%lf,%lf",&red_gamma,&green_gamma,&blue_gamma);H   count=sscanf(gamma,"%lf/%lf/%lf",&red_gamma,&green_gamma,&blue_gamma);   if (count == 1)c     {h       if (red_gamma == 1.0)n         return;        green_gamma=red_gamma;       blue_gamma=red_gamma;n     }m   /*'     Allocate and initialize gamma maps.t   */C   gamma_map=(ColorPacket *) malloc((MaxRGB+1)*sizeof(ColorPacket));r(   if (gamma_map == (ColorPacket *) NULL)     { B       Warning("Unable to gamma image","Memory allocation failed");
       return;      }t   for (i=0; i <= MaxRGB; i++)r   {      gamma_map[i].red=0;d     gamma_map[i].green=0;t     gamma_map[i].blue=0;   }    /*     Initialize gamma table.    */   for (i=0; i <= MaxRGB; i++)    {      if (red_gamma != 0.0)         gamma_map[i].red=(Quantum)<         ((pow((double) i/MaxRGB,1.0/red_gamma)*MaxRGB)+0.5);     if (green_gamma != 0.0)p"       gamma_map[i].green=(Quantum)>         ((pow((double) i/MaxRGB,1.0/green_gamma)*MaxRGB)+0.5);     if (blue_gamma != 0.0)!       gamma_map[i].blue=(Quantum)r=         ((pow((double) i/MaxRGB,1.0/blue_gamma)*MaxRGB)+0.5);e   }u   switch (image->class)a   {      case DirectClass:      default:     {n       /*(         Gamma-correct DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=gamma_map[p->red].red; +         p->green=gamma_map[p->green].green; (         p->blue=gamma_map[p->blue].blue;         p++;!         if (QuantumTick(i,image)) ;           ProgressMonitor(GammaImageText,i,image->packets);h       }u       break;     }u     case PseudoClass:*     {%       /*(         Gamma-correct PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=gamma_map[image->colormap[i].red].red; K         image->colormap[i].green=gamma_map[image->colormap[i].green].green; H         image->colormap[i].blue=gamma_map[image->colormap[i].blue].blue;       }        SyncImage(image);        break;     }    }    if (image->gamma != 0.0)9     image->gamma*=(red_gamma+green_gamma+blue_gamma)/3.0;    free((char *) gamma_map);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             %aO %                                                                             %aO %   G e t A n n o t a t e I n f o                                             %eO %                                                                             %aO %                                                                             %lO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function GetAnnotateInfo initializes the AnnotateInfo structure.m % 0 %  The format of the GetAnnotateInfo routine is: % % %      GetAnnotateInfo(annotate_info)/ % + %  A description of each parameter follows:) % F %    o annotate_info: Specifies a pointer to a AnnotateInfo structure. %a %c */1 void GetAnnotateInfo(AnnotateInfo *annotate_info)( {g1   assert(annotate_info != (AnnotateInfo *) NULL);r+   annotate_info->server_name=(char *) NULL; $   annotate_info->font=(char *) NULL;2   annotate_info->pointsize=atoi(DefaultPointSize);#   annotate_info->box=(char *) NULL;e#   annotate_info->pen=(char *) NULL;g(   annotate_info->geometry=(char *) NULL;$   annotate_info->text=(char *) NULL;)   annotate_info->primitive=(char *) NULL;m   annotate_info->linewidth=1;l   annotate_info->center=False; }  l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             %pO %                                                                             %gO %   G e t I m a g e I n f o                                                   %xO %                                                                             %eO %                                                                             %-O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %i= %  Function GetImageInfo initializes the ImageInfo structure.r %0- %  The format of the GetImageInfo routine is:  %l %      GetImageInfo(image_info)  %o+ %  A description of each parameter follows:o %e@ %    o image_info: Specifies a pointer to a ImageInfo structure. %= %n *// Export void GetImageInfo(ImageInfo *image_info)  { +   assert(image_info != (ImageInfo *) NULL);_   *image_info->magick='\0';d6   image_info->filename=(char *) malloc(MaxTextExtent);,   if (image_info->filename == (char *) NULL)A     Error("Unable to get image info","Memory allocation failed");(   *image_info->filename='\0';_   image_info->affirm=False;;   image_info->subimage=0;c   image_info->subrange=0;m(   image_info->server_name=(char *) NULL;!   image_info->font=(char *) NULL;=!   image_info->size=(char *) NULL;c!   image_info->tile=(char *) NULL;_$   image_info->density=(char *) NULL;!   image_info->page=(char *) NULL;c$   image_info->dispose=(char *) NULL;"   image_info->delay=(char *) NULL;'   image_info->iterations=(char *) NULL;l$   image_info->texture=(char *) NULL;   image_info->adjoin=True;6   image_info->compression=RunlengthEncodedCompression;
 #ifdef HasPNGa)   image_info->compression=ZipCompression;o #endif   image_info->dither=True;)   image_info->interlace=DefaultInterlace;c   image_info->monochrome=False;g/   image_info->pointsize=atoi(DefaultPointSize);a0   image_info->quality=atoi(DefaultImageQuality);   image_info->verbose=False;(   image_info->preview_type=GammaPreview;'   image_info->undercolor=(char *) NULL;m }- t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%fO %                                                                             %-O %                                                                             %gO %     I s G e o m e t r y                                                     %eO %                                                                             %gO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function IsGeometry returns True if the geometry specification is valid# %  as determined by XParseGeometry.  % + %  The format of the IsGeometry routine is:  % " %      status=IsGeometry(geometry) % + %  A description of each parameter follows:  % J %    o status: Function IsGeometry returns True if the image is gray_scale# %      otherwise False is returned.  % ; %    o geometry: This string is the geometry specification.  %  %  */. Export unsigned int IsGeometry(char *geometry) {%   float%
     value;     int%     x,     y;     unsigned int
     flags,     height, 
     width;      if (geometry == (char *) NULL)     return(NoValue);6   flags=XParseGeometry(geometry,&x,&y,&width,&height);0   return(flags || sscanf(geometry,"%f",&value)); }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %wO %     I s G r a y I m a g e                                                   %iO %                                                                             %aO %                                                                             %eO %                                                                             %/O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %,I %  Function IsGrayImage returns True if the image is gray_scale otherwise P %  False is returned.  If the image is DirectClass and gray_scale, it is demoted %  to PseudoClass. %n, %  The format of the IsGrayImage routine is: %   %      status=IsGrayImage(image) % + %  A description of each parameter follows:  %tK %    o status: Function IsGrayImage returns True if the image is gray_scaleo# %      otherwise False is returned._ %oF %    o image: The address of a structure of type Image;  returned from %      ReadImage.b %; %  */& unsigned int IsGrayImage(Image *image) {    register int     i;     unsigned int     gray_scale;      /*%     Determine if image is gray_scale.    */"   assert(image != (Image *) NULL);   gray_scale=True;   switch (image->class)e   {U     case DirectClass:_     default:     {        register RunlengthPacket         *p;r         if (image->matte)          return(False);       p=image->pixels;(       for (i=0; i < image->packets; i++)       {f         if (!IsGray(*p))           {              gray_scale=False;d             break;           }          p++;       }n       if (gray_scale))	         {f           QuantizeInfo             quantize_info;  *           GetQuantizeInfo(&quantize_info);2           quantize_info.colorspace=GRAYColorspace;.           QuantizeImage(&quantize_info,image);           SyncImage(image); 	         }t       break;     }a     case PseudoClass:*     { '       for (i=0; i < image->colors; i++) (         if (!IsGray(image->colormap[i]))           {a             gray_scale=False;)             break;           }0       break;     }h   }    return(gray_scale);i }- x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             % O %                                                                             % O %   L a b e l I m a g e                                                       % O %                                                                             %iO %                                                                             %fO %                                                                             %>O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number byF %  embedding special format characters.  Embed %f for filename, %m forD %  magick, %w for width, %h for height, or %s for scene number.  For %  example,t %g %     %f  %wx%hx %  %  produces an image label of  %p %     bird.miff  512x480 % J %  for an image titled bird.miff and whose width is 512 and height is 480. % + %  The format of the LabelImage routine is:  %  %      LabelImage(image,label) % + %  A description of each parameter follows:v %)7 %    o image: The address of a structure of type Image.- %xL %    o label: The address of a character string containing the label format. %  %  */) void LabelImage(Image *image,char *label)  {    register char      *p,s     *q;f     unsigned int     indirection,     length;a  "   assert(image != (Image *) NULL);$   if (image->label != (char *) NULL)      free((char *) image->label);   image->label=(char *) NULL;_   if (label == (char *) NULL)      return;;   if (*label == '\0')(     return;    indirection=(*label == '@');   if (indirection)     { 
       FILE         *file;  	       int,
         c;         /*         Read label from a file.>       */'       file=(FILE *) fopen(label+1,"r");         if (file == (FILE *) NULL)	         {c7           Warning("Unable to read label file",label+1);            return;e	         }        length=MaxTextExtent;q$       label=(char *) malloc(length);0       for (q=label; label != (char *) NULL; q++)       {          c=fgetc(file);         if (c == EOF)"           break;"         if ((q-label+1) >= length)           {e             *q='\0';             length<<=1; :             label=(char *) realloc((char *) label,length);'             if (label == (char *) NULL)-               break;"             q=label+Extent(label);           }g         *q=(unsigned char) c;        }e       (void) fclose(file);!       if (label == (char *) NULL) 	         {hF           Warning("Unable to label image","Memory allocation failed");           return; 	         }x       *q='\0';     }(   /*(     Allocate and initialize image label.   */
   p=label;%   length=Extent(label)+MaxTextExtent;h'   image->label=(char *) malloc(length);[:   for (q=image->label; image->label != (char *) NULL; p++)   {*     *q='\0';     if (*p == '\0')        break;1     if ((q-image->label+MaxTextExtent) >= length)"       {l         length<<=1; D         image->label=(char *) realloc((char *) image->label,length);*         if (image->label == (char *) NULL)           break;,         q=image->label+Extent(image->label);       }=     /*-       Process formatting characters in label.n     */(     if ((*p == '\\') && (*(p+1) == 'n'))       {a         *q++='\n';         p++;         continue;        }f     if (*p != '%')       {          *q++=(*p);         continue;(       })     p++;     switch (*p)e     {        case 'b':        {p5         (void) sprintf(q,"%ld",image->filesize/1000);=,         q=image->label+Extent(image->label);         break;       }_       case 'f':)       {          register char 
           *p;   
         /*4           Label segment is the base of the filename.
         */0         if (Extent(image->magick_filename) == 0)           break;B         p=image->magick_filename+Extent(image->magick_filename)-1;?         while ((p > image->magick_filename) && (*(p-1) != '/'))            p--;         (void) strcpy(q,p);_         q+=Extent(p);          break;       }l       case 'h':        { 2         (void) sprintf(q,"%u",image->magick_rows);,         q=image->label+Extent(image->label);         break;       }.       case 'm':o       { '         (void) strcpy(q,image->magick); !         q+=Extent(image->magick);.         break;       }_       case 's':        {n,         (void) sprintf(q,"%u",image->scene);,         q=image->label+Extent(image->label);         break;       }o       case 'w':l       { 5         (void) sprintf(q,"%u",image->magick_columns); ,         q=image->label+Extent(image->label);         break;       }        default:       {e         *q++='%';          *q++=(*p);         break;       }      }    } $   if (image->label == (char *) NULL)     {oB       Warning("Unable to label image","Memory allocation failed");
       return;      }(
   *q='\0';   if (indirection)     free((char *) label);  }a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%LO %                                                                             %nO %                                                                             %,O %     L i s t T o G r o u p I m a g e                                         % O %                                                                             % O %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i % M %  Function ListToGroupImage converts a linked list of images to a sequentialf	 %  array.  % 1 %  The format of the ListToGroupImage routine is:  % 4 %      images=ListToGroupImage(images,number_images) % + %  A description of each parameter follows:) % L %    o images: Function ListToGroupImage converts a linked list of images to1 %      a sequential array and returns the array..W %oG %    o images: The address of a structure of type Image;  returned from  %      ReadImage.n %(N %    o number_images:  A pointer to an unsigned integer.  The number of images+ %      in the image array is returned here.) %  %  */I Export Image **ListToGroupImage(Image *image,unsigned int *number_images)e {x   Image 
     **images,e     *next_image;     register int     i;     /*/     Determine the number of images in the list.    */"   assert(image != (Image *) NULL);1   assert(number_images != (unsigned int *) NULL);i   next_image=image; .   for (i=0; next_image != (Image *) NULL; i++)      next_image=next_image->next;.   images=(Image **) malloc(i*sizeof(Image *));    if (images == (Image **) NULL)     {tI       Warning("Unable to convert image list","Memory allocation failed");>       return((Image **) NULL);     }m   *number_images=i;p   /*3     Add each image in the linked list to the group.    */   next_image=image;,.   for (i=0; next_image != (Image *) NULL; i++)   {o     images[i]=next_image;o      next_image=next_image->next;   }    return(images);f }= a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             %sO %                                                                             %tO %                                                                             %(O %   M a g n i f y I m a g e                                                   % O %                                                                             %fO %                                                                             % O %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %eL %  Function MagnifyImage creates a new image that is a integral size greaterM %  than an existing one.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % H %  MagnifyImage scans the reference image to create a magnified image byH %  bilinear interpolation.  The magnified image columns and rows become: %a %    number_columns << 1 %    number_rows << 1  %e- %  The format of the MagnifyImage routine is:s %p* %      magnified_image=MagnifyImage(image) %e+ %  A description of each parameter follows:x %sL %    o magnified_image: Function MagnifyImage returns a pointer to the imageL %      after magnification.  A null image is returned if there is a a memory %      shortage. % 7 %    o image: The address of a structure of type Image.  %  %  */! Image *MagnifyImage(Image *image)  { 7 #define MagnifyImageText  "  Magnifying the image...  "i     Image      *magnified_image;>     intP     y;     register int     x;     register RunlengthPacket     *p,      *q,>     *r;      /**     Initialize magnified image attributes.   */"   assert(image != (Image *) NULL);N   magnified_image=CopyImage(image,image->columns << 1,image->rows << 1,False);(   if (magnified_image == (Image *) NULL)     { A       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);o     }e%   magnified_image->class=DirectClass;b   /*!     Initialize zoom image pixels.    */   p=image->pixels;   image->runlength=p->length+1;n   q=magnified_image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {n           p++;%           image->runlength=p->length; 	         }i       *q=(*p);       q->length=0;
       q++;     }      q+=image->columns;   }    /*     Magnify each row.-   */!   for (y=0; y < image->rows; y++)e   {oI     p=magnified_image->pixels+(image->rows-1-y)*magnified_image->columns+a       (image->columns-1);)P     q=magnified_image->pixels+((image->rows-1-y) << 1)*magnified_image->columns+        ((image->columns-1) << 1);     *q=(*p);     *(q+1)=(*(p));&     for (x=1; x < image->columns; x++)     { 
       p--;       q-=2;t       *q=(*p);<       (q+1)->red=(((int) p->red)+((int) (p+1)->red)+1) >> 1;B       (q+1)->green=(((int) p->green)+((int) (p+1)->green)+1) >> 1;?       (q+1)->blue=(((int) p->blue)+((int) (p+1)->blue)+1) >> 1; B       (q+1)->index=(((int) p->index)+((int) (p+1)->index)+1) >> 1;       (q+1)->length=0;     }f   }o%   for (y=0; y < (image->rows-1); y++)    {e@     p=magnified_image->pixels+(y << 1)*magnified_image->columns;!     q=p+magnified_image->columns; !     r=q+magnified_image->columns;N*     for (x=0; x < (image->columns-1); x++)     {e4       q->red=(((int) p->red)+((int) r->red)+1) >> 1;:       q->green=(((int) p->green)+((int) r->green)+1) >> 1;7       q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;e:       q->index=(((int) p->index)+((int) r->index)+1) >> 1;       q->length=0;C       (q+1)->red=(((int) p->red)+((int) (p+2)->red)+((int) r->red)+ #         ((int) (r+2)->red)+2) >> 2;>K       (q+1)->green=(((int) p->green)+((int) (p+2)->green)+((int) r->green)+ %         ((int) (r+2)->green)+2) >> 2;LG       (q+1)->blue=(((int) p->blue)+((int) (p+2)->blue)+((int) r->blue)+i$         ((int) (r+2)->blue)+2) >> 2;K       (q+1)->index=(((int) p->index)+((int) (p+2)->index)+((int) r->index)+l%         ((int) (r+2)->index)+2) >> 2;.       (q+1)->length=0;       q+=2;        p+=2;e       r+=2;_     }e2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1;o8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;2     q->red=(((int) p->red)+((int) r->red)+1) >> 1;8     q->green=(((int) p->green)+((int) r->green)+1) >> 1;5     q->blue=(((int) p->blue)+((int) r->blue)+1) >> 1; 8     q->index=(((int) p->index)+((int) r->index)+1) >> 1;     q->length=0;     p++;     q++;     r++;4     ProgressMonitor(MagnifyImageText,y,image->rows);   } G   p=magnified_image->pixels+(2*image->rows-2)*magnified_image->columns;hG   q=magnified_image->pixels+(2*image->rows-1)*magnified_image->columns;;$   for (x=0; x < image->columns; x++)   {j     *q++=(*p++);     *q++=(*p++);   }o   return(magnified_image); }i , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%<O %                                                                             %rO %                                                                             %;O %                                                                             %%O %   M a t t e F l o o d f i l l I m a g e                                     %fO %                                                                             %oO %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r % K %  Function MatteFloodfillImage floodfills the designated area with a matte O %  value.  The floodfill algorithm is strongly based on a similiar algorithm in)$ %  "Graphics Gems" by Paul Heckbert. %L4 %  The format of the MatteFloodfillImage routine is: %;1 %      MatteFloodfillImage(image,x,y,matte,delta)% %%+ %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % K %    o x,y: Unsigned integers representing the current location of the pen.  % F %    o matte: A integer value representing the amount of transparency. % B %    o delta: This is the allowed variance in color (fuzzy color). %  %  */9 Export void MatteFloodfillImage(Image *image,int x,int y, +   const unsigned int matte,const int delta)  {    int      offset, 	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;%     register XSegment%     *p;%     RunlengthPackett     target;a  
   XSegment     *segment_stack;t     /*     Check boundary conditions.   */"   assert(image != (Image *) NULL);$   if ((y < 0) || (y >= image->rows))     return;a'   if ((x < 0) || (x >= image->columns))t     return; +   target=image->pixels[y*image->columns+x]; -   if (target.index == (unsigned short) matte)e     return;/   /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)d     { @       Warning("Unable to floodfill","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */
   start=0;   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);m   while (p > segment_stack)    {f     /*       Pop segment off stack.     */     p--;
     x1=p->x1;w
     x2=p->x2;w     offset=p->y2;      y=p->y1+offset;o     /*5       Update matte information in neighboring pixels.n     */     for (x=x1; x >= 0 ; x--)     {r/       pixel=image->pixels+(y*image->columns+x);L+       if (!MatteMatch(*pixel,target,delta))          break;*       pixel->index=(unsigned short) matte;     }h     skip=x >= x1;d     if (!skip)       {m         start=x+1;         if (start < x1)>%           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {a       if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x);i1             if (!MatteMatch(*pixel,target,delta))k               break;0             pixel->index=(unsigned short) matte;           }e#           Push(y,start,x-1,offset);m           if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False;x       for (x++; x <= x2 ; x++)       {-1         pixel=image->pixels+(y*image->columns+x);e,         if (MatteMatch(*pixel,target,delta))           break;       }-       start=x;     } while (x <= x2);   }o   free((char *) segment_stack);  }  g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %+O %                                                                             %%O %                                                                             % O %   M i n i f y I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function MinifyImage creates a new image that is a integral size less than H %  an existing one.  It allocates the memory necessary for the new Image4 %  structure and returns a pointer to the new image. % P %  MinifyImage scans the reference image to create a minified image by computingL %  the weighted average of a 4x4 cell centered at each reference pixel.  TheJ %  target pixel requires two columns and two rows of the reference pixels.8 %  Therefore the minified image columns and rows become: %g %    number_columns/2A %    number_rows/2 %rG %  Weights assume that the importance of neighboring pixels is negately F %  proportional to the square of their distance from the target pixel. %eL %  The scan only processes pixels that have a full set of neighbors.  PixelsL %  in the top, bottom, left, and right pairs of rows and columns are omitted %  from the scan.b %e, %  The format of the MinifyImage routine is: %g( %      minified_image=MinifyImage(image) %o+ %  A description of each parameter follows:" % J %    o minified_image: Function MinifyImage returns a pointer to the imageG %      after reducing.  A null image is returned if there is a a memory = %      shortage or if the image size is less than IconSize*2.s %t7 %    o image: The address of a structure of type Image.a %e %o */  Image *MinifyImage(Image *image) {a #define Minify(weight) \!   total_red+=(weight)*(s->red); \+%   total_green+=(weight)*(s->green); \f#   total_blue+=(weight)*(s->blue); \ %   total_matte+=(weight)*(s->index); \    s++;1 #define MinifyImageText  "  Minifying image...  ")     Image      *minified_image;     register RunlengthPacket     *p,i     *q,d     *s,r     *s0,     *s1,     *s2,     *s3;     register unsigned intg     x;     RunlengthPacketd     *scanline;     unsigned int     y;     unsigned int	     blue,y
     green,     packets,     red;     unsigned longa     total_matte,     total_blue,r     total_green,     total_red;     unsigned short
     index;  "   assert(image != (Image *) NULL);0   if ((image->columns < 4) || (image->rows < 4))     { E       Warning("Unable to reduce image","image size must exceed 3x3");        return((Image *) NULL);      }r   /*)     Initialize minified image attributes.    */%   packets=Max(image->packets >> 2,1); 2   minified_image=CopyImage(image,packets,1,False);'   if (minified_image == (Image *) NULL)-     { C       Warning("Unable to reduce image","Memory allocation failed");g       return((Image *) NULL);;     } $   minified_image->class=DirectClass;.   minified_image->columns=image->columns >> 1;(   minified_image->rows=image->rows >> 1;   minified_image->packets=0;   /*F     Allocate image buffer and scanline buffer for 4 rows of the image.   */   scanline=(RunlengthPacket *)9     malloc(4*(image->columns+1)*sizeof(RunlengthPacket));s+   if (scanline == (RunlengthPacket *) NULL)y     { C       Warning("Unable to reduce image","Memory allocation failed"); #       DestroyImage(minified_image);        return((Image *) NULL);%     }%   /**     Preload the first 2 rows of the image.   */   p=image->pixels;   image->runlength=p->length+1; ,   for (x=0; x < (4*(image->columns+1)); x++)     scanline[x]=(*p); 
   s=scanline; +   for (x=0; x < (image->columns << 1); x++)    {      if (image->runlength != 0)       image->runlength--;      else       {          p++;#         image->runlength=p->length;        }      *s=(*p);     s++;   }    /*     Reduce each row.   */   p=image->pixels;   image->runlength=p->length+1;    q=minified_image->pixels;    q->red=0; 
   q->green=0;    q->blue=0;
   q->index=0;    q->length=MaxRunlength;%&   for (y=0; y < (image->rows-1); y+=2)   {%     /*)       Initialize sliding window pointers.      */+     s0=scanline+image->columns*((y+0) % 4);g+     s1=scanline+image->columns*((y+1) % 4);f+     s2=scanline+image->columns*((y+2) % 4);p+     s3=scanline+image->columns*((y+3) % 4);f     /*       Read another scan line.c     */	     s=s2;(&     for (x=0; x < image->columns; x++)     {p        if (image->runlength != 0)         image->runlength--;e
       else	         {c           p++;%           image->runlength=p->length;i	         }y       *s=(*p);
       s++;     }i     /*       Read another scan line.e     */	     s=s3;s&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {            p++;%           image->runlength=p->length;e	         }n       *s=(*p);
       s++;     }g+     for (x=0; x < (image->columns-1); x+=2)      {p       /*B         Compute weighted average of target pixel color components.  I         These particular coefficients total to 128.  Use 128/2-1 or 63 toe!         insure correct round off.e       */       total_red=0;       total_green=0;       total_blue=0;i       total_matte=0;       s=s0; 3       Minify(3); Minify(7);  Minify(7);  Minify(3);)       s=s1;c3       Minify(7); Minify(15); Minify(15); Minify(7);n       s=s2; 3       Minify(7); Minify(15); Minify(15); Minify(7);        s=s3;t3       Minify(3); Minify(7);  Minify(7);  Minify(3);N       s0+=2;       s1+=2;       s2+=2;       s3+=2;*       red=(Quantum) ((total_red+63) >> 7);.       green=(Quantum) ((total_green+63) >> 7);,       blue=(Quantum) ((total_blue+63) >> 7);5       index=(unsigned short) ((total_matte+63) >> 7);=H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         {f+           if (minified_image->packets != 0)(             q++;$           minified_image->packets++;1           if (minified_image->packets == packets) 
             {e               packets<<=1;I               minified_image->pixels=(RunlengthPacket *) realloc((char *) H                 minified_image->pixels,packets*sizeof(RunlengthPacket));E               if (minified_image->pixels == (RunlengthPacket *) NULL)                  {xO                   Warning("Unable to reduce image","Memory allocation failed"); /                   DestroyImage(minified_image);f)                   return((Image *) NULL);s                 } A               q=minified_image->pixels+minified_image->packets-1;l
             }            q->red=red;            q->green=green;h           q->blue=blue;(           q->index=index;            q->length=0;	         }      } 5     ProgressMonitor(MinifyImageText,y,image->rows-1);    };=   minified_image->pixels=(RunlengthPacket *) realloc((char *)eL     minified_image->pixels,minified_image->packets*sizeof(RunlengthPacket));   free((char *) scanline);   return(minified_image);l }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M o d u l a t e I m a g e                                               % O %                                                                             %xO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%M %  Function ModulateImage modulates the hue, saturation, and brightness of an 	 %  image.  % . %  The format of the ModulateImage routine is: % $ %      ModulateImage(image,modulate) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % I %    o modulate: A character string indicating the percent change in hue, " %      saturation, and brightness. %  %  *// void ModulateImage(Image *image,char *modulate)  { 4 #define ModulateImageText  "  Modulating image...  "     double     percent_brightness,      percent_hue,     percent_saturation;      register int     i;     register RunlengthPacket     *p;%     /*     Initialize gamma table.I   */"   assert(image != (Image *) NULL);    if (modulate == (char *) NULL)     return;l   percent_hue=0.0;   percent_brightness=0.0;    percent_saturation=0.0;mO   (void) sscanf(modulate,"%lf,%lf,%lf",&percent_brightness,&percent_saturation,m     &percent_hue);O   (void) sscanf(modulate,"%lf/%lf/%lf",&percent_brightness,&percent_saturation,m     &percent_hue);   switch (image->class)    {      case DirectClass:!     default:     {        /*3         Modulate the color for a DirectClass image.u       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { C         Modulate(percent_hue,percent_saturation,percent_brightness, &           &p->red,&p->green,&p->blue);         p++;!         if (QuantumTick(i,image))l>           ProgressMonitor(ModulateImageText,i,image->packets);       }        break;     }F     case PseudoClass:g     {-       /*3         Modulate the color for a PseudoClass image.*       */'       for (i=0; i < image->colors; i++)%C         Modulate(percent_hue,percent_saturation,percent_brightness, <           &image->colormap[i].red,&image->colormap[i].green,$           &image->colormap[i].blue);       SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M o g r i f y I m a g e                                                 % O %                                                                             %%O %                                                                             %oO %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %rH %  Function MogrifyImage applies image processing options to an image as& %  prescribed by command line options. %i- %  The format of the MogrifyImage routine is:e %h/ %      MogrifyImage(image_info,argc,argv,image)  %x+ %  A description of each parameter follows:t %c@ %    o image_info: Specifies a pointer to a ImageInfo structure. %hG %    o argc: Specifies a pointer to an integer describing the number ofa' %      elements in the argument vector./ %xL %    o argv: Specifies a pointer to a text array containing the command line %      arguments.l % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.g %a %t */D Export void MogrifyImage(ImageInfo *image_info,int argc,char **argv,   Image **image) {e   AnnotateInfo     annotate_info;     char     *option;     Image      *region_image;     intU
     flags,     x,     y;     QuantizeInfo     quantize_info;     register int     i;     unsigned int     height,i
     width;     XColor     target_color;a     /*!     Initialize routine variables.o   */+   assert(image_info != (ImageInfo *) NULL); #   assert(image != (Image **) NULL);e"   GetAnnotateInfo(&annotate_info);"   GetQuantizeInfo(&quantize_info);    quantize_info.number_colors=0;   quantize_info.tree_depth=0;l   quantize_info.dither=True;   if (image_info->monochrome)n#     if (!IsMonochromeImage(*image))g       {t&         quantize_info.number_colors=2;#         quantize_info.tree_depth=8;-0         quantize_info.colorspace=GRAYColorspace;       }    region_image=(Image *) NULL;   /*     Transmogrify the image.    */   for (i=1; i < argc; i++)   {t     option=argv[i];oH     if ((Extent(option) <= 1) || ((*option != '-') && (*option != '+')))       continue;p'     if (strncmp("-blur",option,4) == 0)C       {(         double           factor;a  
         Imager           *blurred_image;-  
         /*           Blur an image.
         */         factor=atof(argv[++i]); /         blurred_image=BlurImage(*image,factor); ,         if (blurred_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=blurred_image;            }          continue;m       } &     if (strcmp("-border",option) == 0)       {i
         Image)           *bordered_image;           RectangleInfo            border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0;yE         flags=XParseGeometry(argv[++i],&border_info.x,&border_info.y,+2           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0) /           border_info.height=border_info.width; 8         bordered_image=BorderImage(*image,&border_info);-         if (bordered_image != (Image *) NULL)<           { !             DestroyImage(*image); .             bordered_image->class=DirectClass;"             *image=bordered_image;           }          continue;        } .     if (strncmp("-bordercolor",option,8) == 0)       { 
         /*3           Determine RGB values of the border color. 
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);@         (*image)->border_color.red=XDownScale(target_color.red);D         (*image)->border_color.green=XDownScale(target_color.green);B         (*image)->border_color.blue=XDownScale(target_color.blue);         continue;        } &     if (strncmp("-box",option,3) == 0)       {%$         annotate_info.box=argv[++i];         continue;        }t+     if (strncmp("-charcoal",option,3) == 0)        {.         char           *commands[8];t           QuantizeInfo           local_info;a  
         /*           Charcoal drawing. 
         */         i++;%         GetQuantizeInfo(&local_info);i/         local_info.dither=quantize_info.dither; -         local_info.colorspace=GRAYColorspace;r*         QuantizeImage(&local_info,*image);         SyncImage(*image);          commands[0]=client_name;         commands[1]="-edge";         commands[2]=argv[i];         commands[3]="-blur";         commands[4]=argv[i];!         commands[5]="-normalize";          commands[6]="-negate";!         commands[7]="-grayscale"; 2         MogrifyImage(image_info,8,commands,image);         continue;        }r+     if (strncmp("-colorize",option,8) == 0)        { :         ColorizeImage(*image,argv[++i],annotate_info.pen);         continue;m       }a&     if (strcmp("-colors",option) == 0)       {I4         quantize_info.number_colors=atoi(argv[++i]);         continue;X       }r-     if (strncmp("-colorspace",option,8) == 0)s       {)         i++;         option=argv[i];(.         if (Latin1Compare("gray",option) == 0)           {e4             quantize_info.colorspace=GRAYColorspace;1             if (quantize_info.number_colors == 0);.               quantize_info.number_colors=256;'             quantize_info.tree_depth=8;o           } .         if (Latin1Compare("ohta",option) == 0)2           quantize_info.colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)e1           quantize_info.colorspace=RGBColorspace;e5         if (Latin1Compare("transparent",option) == 0) 9           quantize_info.colorspace=TransparentColorspace; -         if (Latin1Compare("xyz",option) == 0) 1           quantize_info.colorspace=XYZColorspace;g/         if (Latin1Compare("ycbcr",option) == 0)(3           quantize_info.colorspace=YCbCrColorspace; -         if (Latin1Compare("yiq",option) == 0)d1           quantize_info.colorspace=YIQColorspace; /         if (Latin1Compare("ypbpr",option) == 0) 3           quantize_info.colorspace=YPbPrColorspace; -         if (Latin1Compare("yuv",option) == 0)g1           quantize_info.colorspace=YUVColorspace;          continue;x       } +     if (strncmp("comment",option+1,4) == 0)        {n         if (*option == '-') )           CommentImage(*image,argv[++i]);u         else-           CommentImage(*image,(char *) NULL);)         continue;(       }a,     if (strncmp("contrast",option+1,3) == 0)       { >         ContrastImage(*image,(unsigned int) (*option == '-'));         continue;a       }u'     if (strncmp("-crop",option,3) == 0)(       { 6         TransformImage(image,argv[++i],(char *) NULL);         continue;        }a(     if (strncmp("-cycle",option,3) == 0)       {*
         /*"           Cycle an image colormap.
         */3         CycleColormapImage(*image,atoi(argv[++i]));u         continue;        }o)     if (strncmp("delay",option+1,3) == 0)r       {y(         (*image)->delay=atoi(argv[++i]);         continue;a       }M,     if (strncmp("-despeckle",option,4) == 0)       { 
         Imager           *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL)            { !             DestroyImage(*image);a$             *image=despeckled_image;           }u         continue;        }l*     if (strncmp("-display",option,6) == 0)       {-,         annotate_info.server_name=argv[++i];(         image_info->server_name=argv[i];         continue;        }a+     if (strncmp("dispose",option+1,5) == 0)u       {B*         (*image)->dispose=atoi(argv[++i]);         continue;        }f*     if (strncmp("dither",option+1,3) == 0)       { .         quantize_info.dither=(*option == '-');         continue;;       } '     if (strncmp("-draw",option,3) == 0)        { *         annotate_info.primitive=argv[++i];)         DrawImage(*image,&annotate_info);%         continue;        } '     if (strncmp("-edge",option,3) == 0)        {          double           factor;   
         Image            *edged_image;   
         /*$           Detect edges in the image.
         */         factor=atof(argv[++i]); -         edged_image=EdgeImage(*image,factor); *         if (edged_image != (Image *) NULL)           { !             DestroyImage(*image);              *image=edged_image;            }          continue;        } )     if (strncmp("-emboss",option,3) == 0)        { 
         Image            *embossed_image;  
         /*           Emboss image.%
         */+         embossed_image=EmbossImage(*image);n-         if (embossed_image != (Image *) NULL).           {t!             DestroyImage(*image);e"             *image=embossed_image;           }e         continue;i       } *     if (strncmp("-enhance",option,3) == 0)       {k
         Image            *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)f           {i!             DestroyImage(*image);1"             *image=enhanced_image;           }m         continue;s       } +     if (strncmp("-equalize",option,3) == 0)d       {n         EqualizeImage(*image);         continue;        }f'     if (strncmp("-flip",option,4) == 0)c       {T
         Image            *flipped_image;   
         /*           Flip image scanlines.t
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           { !             DestroyImage(*image);e!             *image=flipped_image;(           }t         continue;        }e'     if (strncmp("-flop",option,4) == 0)m       {a
         Imagef           *flopped_image;)  
         /*           Flop image scanlines.e
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           { !             DestroyImage(*image);d!             *image=flopped_image;            }E         continue;1       } '     if (strncmp("-font",option,3) == 0)        { %         annotate_info.font=argv[++i];"         continue;        }u%     if (strcmp("-frame",option) == 0)x       { 
         Imageh           *framed_image;           FrameInfoc           frame_info;L  
         /*3           Surround image with an ornamental border. 
         */         frame_info.width=0;)         frame_info.height=0;?         flags=XParseGeometry(argv[++i],&frame_info.outer_bevel,sH           &frame_info.inner_bevel,&frame_info.width,&frame_info.height);'         if ((flags & HeightValue) == 0) -           frame_info.height=frame_info.width; "         if ((flags & XValue) == 0);           frame_info.outer_bevel=(frame_info.width >> 2)+1;c"         if ((flags & YValue) == 0)8           frame_info.inner_bevel=frame_info.outer_bevel;&         frame_info.x=frame_info.width;'         frame_info.y=frame_info.height;eC         frame_info.width=(*image)->columns+(frame_info.width << 1);nB         frame_info.height=(*image)->rows+(frame_info.height << 1);4         framed_image=FrameImage(*image,&frame_info);+         if (framed_image != (Image *) NULL)p           { !             DestroyImage(*image);n,             framed_image->class=DirectClass;              *image=framed_image;           })         continue;m       }e(     if (strncmp("-gamma",option,3) == 0)       {*%         GammaImage(*image,argv[++i]);m         continue;t       }o+     if (strncmp("-geometry",option,4) == 0)m       {a6         TransformImage(image,(char *) NULL,argv[++i]);'         annotate_info.geometry=argv[i];n         continue;        }t*     if (strncmp("-implode",option,4) == 0)       {          double           amount;   
         Image            *imploded_image;  
         /*           Implode image.
         */         amount=atof(argv[++i]); 3         imploded_image=ImplodeImage(*image,amount); -         if (imploded_image != (Image *) NULL)            {t!             DestroyImage(*image); "             *image=imploded_image;           }l         continue;        }f-     if (strncmp("interlace",option+1,3) == 0)        { ,         image_info->interlace=NoneInterlace;         if (*option == '-')            {m             option=argv[++i];)2             if (Latin1Compare("none",option) == 0)2               image_info->interlace=NoneInterlace;2             if (Latin1Compare("line",option) == 0)2               image_info->interlace=LineInterlace;3             if (Latin1Compare("plane",option) == 0) 3               image_info->interlace=PlaneInterlace;(7             if (Latin1Compare("partition",option) == 0) 7               image_info->interlace=PartitionInterlace;            }n         continue;e       } )     if (strncmp("label",option+1,2) == 0)s       {          if (*option == '-')e'           LabelImage(*image,argv[++i]);q         else+           LabelImage(*image,(char *) NULL);x         continue;s       } ,     if (strncmp("-linewidth",option,3) == 0)       {q0         annotate_info.linewidth=atoi(argv[++i]);         continue;        }g(     if (strncmp("loop",option+1,2) == 0)       {n-         (*image)->iterations=atoi(argv[++i]);f         continue;u       } #     if (strcmp("-map",option) == 0)        {h
         Image;           *map_image;%           ImageInfo%           local_info;%  
         /*=           Transform image colors to match this set of colors. 
         */!         local_info=(*image_info); 5         (void) strcpy(local_info.filename,argv[++i]); )         map_image=ReadImage(&local_info); (         if (map_image != (Image *) NULL)           { 9             MapImage(*image,map_image,local_info.dither); $             DestroyImage(map_image);           }          continue;        } &     if (strcmp("matte",option+1) == 0)       { )         (*image)->matte=(*option == '-');          continue;        } -     if (strncmp("-mattecolor",option,7) == 0)        {%
         /*3           Determine RGB values of the border color.%
         */<         (void) XQueryColorDatabase(argv[++i],&target_color);?         (*image)->matte_color.red=XDownScale(target_color.red);mC         (*image)->matte_color.green=XDownScale(target_color.green); A         (*image)->matte_color.blue=XDownScale(target_color.blue);d         continue;e       }I+     if (strncmp("-modulate",option,4) == 0)g       { (         ModulateImage(*image,argv[++i]);         continue;l       } *     if (strncmp("negate",option+1,3) == 0)       { +         NegateImage(*image,*option == '+');e         continue;e       }c)     if (strncmp("noise",option+1,4) == 0)i       {I
         Image            *noisy_image;u  
         /*            Reduce noise in image.
         */         if (*option == '-')+/           noisy_image=ReduceNoiseImage(*image);-         else           {l             NoiseTypeg               noise_type;                option=argv[++i];a$             noise_type=UniformNoise;6             if (Latin1Compare("gaussian",option) == 0)'               noise_type=GaussianNoise;c<             if (Latin1Compare("multiplicative",option) == 0)5               noise_type=MultiplicativeGaussianNoise;*5             if (Latin1Compare("impulse",option) == 0) &               noise_type=ImpulseNoise;7             if (Latin1Compare("laplacian",option) == 0) (               noise_type=LaplacianNoise;5             if (Latin1Compare("poisson",option) == 0)b&               noise_type=PoissonNoise;9             noisy_image=AddNoiseImage(*image,noise_type);]           } *         if (noisy_image != (Image *) NULL)           {o!             DestroyImage(*image);]             *image=noisy_image;r           }l         continue;        }o,     if (strncmp("-normalize",option,4) == 0)       {          NormalizeImage(*image);=         continue;o       } )     if (strncmp("-opaque",option,3) == 0)i       {o8         OpaqueImage(*image,argv[++i],annotate_info.pen);         continue;        }l(     if (strncmp("page",option+1,3) == 0)       {%,         if ((*image)->page != (char *) NULL)(           free((char *) (*image)->page);%         (*image)->page=(char *) NULL;          if (*option == '+')            continue; 5         (*image)->page=PostscriptGeometry(argv[++i]);          continue;        } (     if (strncmp("-paint",option,4) == 0)       { 
         Image            *painted_image;   
         /*           Oil paint image.
         */<         painted_image=OilPaintImage(*image,atoi(argv[++i]));,         if (painted_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=painted_image;            }          continue;%       }%#     if (strcmp("-pen",option) == 0)%       {%$         annotate_info.pen=argv[++i];         continue;        }t,     if (strncmp("-pointsize",option,3) == 0)       { 0         annotate_info.pointsize=atoi(argv[++i]);         continue;I       }e,     if (strncmp("-normalize",option,4) == 0)       {          NormalizeImage(*image);s         continue;a       } )     if (strncmp("raise",option+1,2) == 0)a       {          RectangleInfo            raise_info;a  
         /*5           Surround image with a raise of solid color.t
         */         raise_info.width=0;=         raise_info.height=0;C         flags=XParseGeometry(argv[++i],&raise_info.x,&raise_info.y,e0           &raise_info.width,&raise_info.height);'         if ((flags & HeightValue) == 0) -           raise_info.height=raise_info.width; 6         RaiseImage(*image,&raise_info,*option == '-');         continue;        } *     if (strncmp("region",option+1,2) == 0)       {h+         if (region_image != (Image *) NULL)&           {=             /*               Composite region.              */H             XParseGeometry(region_image->geometry,&x,&y,&width,&height);G             CompositeImage(region_image,ReplaceCompositeOp,*image,x,y); !             DestroyImage(*image);+              *image=region_image;           }          if (*option == '+')            continue;eM         region_image=CopyImage(*image,(*image)->columns,(*image)->rows,True); +         if (region_image == (Image *) NULL)            continue; )         region_image->geometry=argv[++i]; C         TransformImage(image,region_image->geometry,(char *) NULL);          continue;u       }n'     if (strncmp("-roll",option,4) == 0)-       {;
         Image            *rolled_image;  
         /*           Roll image. 
         */         x=0;         y=0;=         flags=XParseGeometry(argv[++i],&x,&y,&width,&height);p+         rolled_image=RollImage(*image,x,y); +         if (rolled_image != (Image *) NULL)g           { !             DestroyImage(*image);i              *image=rolled_image;           }/         continue;s       }t)     if (strncmp("-rotate",option,4) == 0)        {c         double           degrees;  
         Imagei           *rotated_image;e  
         /*/           Check for conditional image rotation.>
         */         i++;1         if (strchr(argv[i],'>') != (char *) NULL)%2           if ((*image)->columns <= (*image)->rows)             break;1         if (strchr(argv[i],'<') != (char *) NULL) 2           if ((*image)->columns >= (*image)->rows)             break;
         /*           Rotate image. 
         */         degrees=atof(argv[i]);=         rotated_image=RotateImage(*image,degrees,False,True); ,         if (rotated_image != (Image *) NULL)           { !             DestroyImage(*image); !             *image=rotated_image;            }          continue;        } )     if (strncmp("-sample",option,3) == 0)        { 
         Image            *sampled_image;   
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;B         (void) ParseImageGeometry(argv[++i],&x,&y,&width,&height);7         sampled_image=SampleImage(*image,width,height);o,         if (sampled_image != (Image *) NULL)           {t!             DestroyImage(*image);A!             *image=sampled_image;o           }          continue;s       }r(     if (strncmp("sans",option+1,2) == 0)       if (*option == '-')i         i++;%     if (strcmp("-scene",option) == 0)        {c(         (*image)->scene=atoi(argv[++i]);         continue;e       }e*     if (strncmp("-segment",option,4) == 0)       { 
         float:           cluster_threshold,           smoothing_threshold;  
         /*           Segment image.
         */         cluster_threshold=1.0;          smoothing_threshold=1.5;;         (void) sscanf(argv[++i],"%fx%f",&cluster_threshold,             &smoothing_threshold);I         SegmentImage(*image,quantize_info.colorspace,image_info->verbose,uC           (double) cluster_threshold,(double) smoothing_threshold);i         SyncImage(*image);         continue;*       }c)     if (strncmp("shade",option+1,5) == 0)e       {e
         floats           azimuth,           elevation;  
         Image(           *shaded_image;  
         /*           Shade image.
         */         azimuth=30.0;          elevation=30.0;s         if (*option == '-') ?           (void) sscanf(argv[++i],"%fx%f",&azimuth,&elevation);cG         shaded_image=ShadeImage(*image,*option == '-',(double) azimuth,e           (double) elevation);+         if (shaded_image != (Image *) NULL))           {a!             DestroyImage(*image);m              *image=shaded_image;           }e         continue;        }b*     if (strncmp("-sharpen",option,5) == 0)       {          double           factor;a  
         Imagem           *sharpened_image;o  
         /*           Sharpen an image. 
         */         factor=atof(argv[++i]); 4         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           {e!             DestroyImage(*image); #             *image=sharpened_image;t           }a         continue;        }*(     if (strncmp("-shear",option,4) == 0)       { 
         float_           x_shear,           y_shear;  
         Imagep           *sheared_image;-  
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;;         (void) sscanf(argv[++i],"%fx%f",&x_shear,&y_shear);          sheared_image=E           ShearImage(*image,(double) x_shear,(double) y_shear,False); ,         if (sheared_image != (Image *) NULL)           { !             DestroyImage(*image); -             sheared_image->class=DirectClass; !             *image=sheared_image;            }e         continue;t       }r+     if (strncmp("-solarize",option,3) == 0)        {n.         SolarizeImage(*image,atof(argv[++i]));         continue;n       },)     if (strncmp("-spread",option,3) == 0)1       {          unsigned int           amount;   
         Image*           *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]); 0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)            {g!             DestroyImage(*image);f              *image=spread_image;           }>         continue;o       } (     if (strncmp("-swirl",option,3) == 0)       {+         double           degrees;  
         Imagel           *swirled_image;   
         /*           Swirl image.
         */          degrees=atof(argv[++i]);1         swirled_image=SwirlImage(*image,degrees);+,         if (swirled_image != (Image *) NULL)           { !             DestroyImage(*image);s!             *image=swirled_image;e           }          continue;        } ,     if (strncmp("-threshold",option,3) == 0)       { )         ThresholdImage(*image,argv[++i]);e         continue;        }R.     if (strncmp("-transparent",option,4) == 0)       {d+         TransparentImage(*image,argv[++i]);e         continue;i       }e,     if (strncmp("-treedepth",option,4) == 0)       {B1         quantize_info.tree_depth=atoi(argv[++i]);o         continue;e       }p   }y'   if (quantize_info.number_colors != 0)t     {        /*1         Reduce the number of colors in the image.p       */-       if (((*image)->class == DirectClass) ||a=           ((*image)->colors > quantize_info.number_colors) || 7           (quantize_info.colorspace == GRAYColorspace))(-         QuantizeImage(&quantize_info,*image);o       /*#         Measure quantization error.        */       if (image_info->verbose)"         QuantizationError(*image);       SyncImage(*image);     } %   if (region_image != (Image *) NULL)s     {        /*         Composite region.o       */B       XParseGeometry(region_image->geometry,&x,&y,&width,&height);A       CompositeImage(region_image,ReplaceCompositeOp,*image,x,y);t       DestroyImage(*image);g       *image=region_image;     } >   if ((*image)->packets == ((*image)->columns*(*image)->rows))     CompressImage(*image); }p l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             % O %     M o g r i f y I m a g e s                                               % O %                                                                             % O %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function MogrifyImages applies image processing options to a sequence of 0 %  images as prescribed by command line options. %e- %  The format of the MogrifyImage routine is:  % 1 %      MogrifyImages(image_info,argc,argv,images)  % + %  A description of each parameter follows:. %e@ %    o image_info: Specifies a pointer to a ImageInfo structure. % G %    o argc: Specifies a pointer to an integer describing the number of ' %      elements in the argument vector.  % L %    o argv: Specifies a pointer to a text array containing the command line %      arguments.  %-G %    o images: The address of a structure of type Image;  returned from_ %      ReadImage.C %s %  */E Export void MogrifyImages(ImageInfo *image_info,int argc,char **argv,    Image **images)a {e6 #define MogrifyImageText  "  Transforming images...  "     Image_     *image,g     *mogrify_image;o     register int     i;     MonitorHandler     handler;     unsigned int     number_images;  +   assert(image_info != (ImageInfo *) NULL);l$   assert(images != (Image **) NULL);   image=(*images);G   for (number_images=1; image->next != (Image *) NULL; number_images++)e     image=image->next;4   ProgressMonitor(MogrifyImageText,0,number_images);3   handler=SetMonitorHandler((MonitorHandler) NULL);>,   MogrifyImage(image_info,argc,argv,images);$   (void) SetMonitorHandler(handler);   image=(*images);    mogrify_image=(*images)->next;   if (image_info->verbose)&     DescribeImage(image,stderr,False);1   for (i=1; mogrify_image != (Image *) NULL; i++)    {-5     handler=SetMonitorHandler((MonitorHandler) NULL);e6     MogrifyImage(image_info,argc,argv,&mogrify_image);     image->next=mogrify_image;      image->next->previous=image;     image=image->next;     if (image_info->verbose)0       DescribeImage(mogrify_image,stderr,False);&     mogrify_image=mogrify_image->next;&     (void) SetMonitorHandler(handler);6     ProgressMonitor(MogrifyImageText,i,number_images);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %dO %                                                                             %xO %     N e g a t e I m a g e                                                   %nO %                                                                             % O %                                                                             %aO %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function NegateImage negates the colors in the reference image.  The I %  Grayscale option means that only grayscale values within the image areg %  negated.q %n, %  The format of the NegateImage routine is: %p# %      NegateImage(image,grayscale)n %=+ %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.( %r %q */5 void NegateImage(Image *image,unsigned int grayscale)= {n; #define NegateImageText  "  Negating the image colors...  "      register int     i;     register RunlengthPacket     *p;O  "   assert(image != (Image *) NULL);   switch (image->class)q   {>     case DirectClass:      default:     {        /*#         Negate DirectClass packets.        */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          if (grayscale)<           if ((p->red != p->green) || (p->green != p->blue))             continue;(         p->red=(~p->red);e         p->green=(~p->green);q         p->blue=(~p->blue);          p++;!         if (QuantumTick(i,image))-<           ProgressMonitor(NegateImageText,i,image->packets);       }        break;     }C     case PseudoClass:      {        /*#         Negate PseudoClass packets.        */'       for (i=0; i < image->colors; i++)l       {          if (grayscale)E           if ((image->colormap[i].red != image->colormap[i].green) || D               (image->colormap[i].green != image->colormap[i].blue))             continue;e9         image->colormap[i].red=(~image->colormap[i].red); =         image->colormap[i].green=(~image->colormap[i].green);e;         image->colormap[i].blue=(~image->colormap[i].blue);:       }        SyncImage(image);p       break;     }    }  }  ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%qO %                                                                             % O %                                                                             % O %     N o r m a l i z e I m a g e                                             %fO %                                                                             % O %                                                                             %)O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%q %1G %  Function NormalizeImage normalizes the pixel values to span the full0D %  range of color values.  This is a contrast enhancement technique. %)/ %  The format of the NormalizeImage routine is:  %e %      NormalizeImage(image) % + %  A description of each parameter follows:p % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.o %e %u */! void NormalizeImage(Image *image)  { 6 #define NormalizeImageText  "  Normalizing image...  "     int      histogram[MaxRGB+1],     threshold_intensity;  	   Quantum      gray_value,      normalize_map[MaxRGB+1];     register int     i,     intensity;     register RunlengthPacket     *p;a     unsigned int	     high,=     low;     /*     Form histogram.    */"   assert(image != (Image *) NULL);   for (i=0; i <= MaxRGB; i++)x     histogram[i]=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)   {      gray_value=Intensity(*p); '     histogram[gray_value]+=p->length+1;e     p++;   }    /*C     Find the histogram boundaries by locating the 1 percent levels.l   */7   threshold_intensity=(image->columns*image->rows)/100;    intensity=0;"   for (low=0; low < MaxRGB; low++)   {e     intensity+=histogram[low];(     if (intensity > threshold_intensity)       break;   }    intensity=0;&   for (high=MaxRGB; high != 0; high--)   {e     intensity+=histogram[high];c(     if (intensity > threshold_intensity)       break;   }a   if (low == high)     {        /*K         Unreasonable contrast;  use zero threshold to determine boundaries.l       */       threshold_intensity=0;       intensity=0;&       for (low=0; low < MaxRGB; low++)       {/"         intensity+=histogram[low];,         if (intensity > threshold_intensity)           break;       }        intensity=0;*       for (high=MaxRGB; high != 0; high--)       {>#         intensity+=histogram[high]; ,         if (intensity > threshold_intensity)           break;       }-       if (low == high)&         return;  /* zero span bound */     }    /*A     Stretch the histogram to create the normalized image mapping.    */   for (i=0; i <= MaxRGB; i++)      if (i < (int) low)       normalize_map[i]=0;      else       if (i > (int) high))          normalize_map[i]=MaxRGB;
       else7         normalize_map[i]=(MaxRGB-1)*(i-low)/(high-low);    /*     Normalize the image.   */   switch (image->class)    {      case DirectClass:      default:     {u       /*$         Normalize DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { %         p->red=normalize_map[p->red]; )         p->green=normalize_map[p->green];e'         p->blue=normalize_map[p->blue];(         p++;!         if (QuantumTick(i,image))l?           ProgressMonitor(NormalizeImageText,i,image->packets);-       }l       break;     }a     case PseudoClass:      {        /*$         Normalize PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { E         image->colormap[i].red=normalize_map[image->colormap[i].red]; I         image->colormap[i].green=normalize_map[image->colormap[i].green]; G         image->colormap[i].blue=normalize_map[image->colormap[i].blue];        }        SyncImage(image);        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %     O p a g u e I m a g e                                                   %eO %                                                                             %nO %                                                                             %pO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %nN %  Function OpaqueImage changes the color of an opaque pixel to the pen color. %a, %  The format of the OpaqueImage routine is: % 0 %      OpaqueImage(image,opaque_color,pen_color) %a+ %  A description of each parameter follows:  %aF %    o image: The address of a structure of type Image;  returned from %      ReadImage.R %e %    o opaque_color,F %      pen_color: A character string that contain an X11 color string. %m %- */A void OpaqueImage(Image *image,char *opaque_color,char *pen_color)  { C #define OpaqueImageText  "  Setting opaque color in the image...  "x  
   ColorPacketi     target;-     register int     i;     unsigned int     status;p     XColor     target_color;;     /*-     Determine RGB values of the opaque color.r   */"   assert(image != (Image *) NULL);9   status=XQueryColorDatabase(opaque_color,&target_color);    if (status == False)     return;g*   target.red=XDownScale(target_color.red);.   target.green=XDownScale(target_color.green);,   target.blue=XDownScale(target_color.blue);6   status=XQueryColorDatabase(pen_color,&target_color);   if (status == False)     return;o   /*     Make image color opaque.   */   switch (image->class)i   {e     case DirectClass:g     default:     {        register RunlengthPacket         *p;%         /*&         Make DirectClass image opaque.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { )         if (ColorMatch(*p,target,DeltaX))            { 0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           }          p++;!         if (QuantumTick(i,image)) <           ProgressMonitor(OpaqueImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        register ColorPacket         *p;          /*&         Make PseudoClass image opaque.       */       p=image->colormap;'       for (i=0; i < image->colors; i++)        {F)         if (ColorMatch(*p,target,DeltaX))l           {u0             p->red=XDownScale(target_color.red);4             p->green=XDownScale(target_color.green);2             p->blue=XDownScale(target_color.blue);           },         p++;!         if (QuantumTick(i,image))o<           ProgressMonitor(OpaqueImageText,i,image->packets);       }e       break;     }e   }e }t   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %tO %                                                                             %wO %                                                                             % O %   O p e n I m a g e                                                         % O %                                                                             %sO %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %(L %  Function OpenImage open a file associated with the image.  A file name ofK %  '-' sets the file to stdin for type 'r' and stdout for type 'w'.  If the K %  filename suffix is '.gz' or '.Z', the image is decompressed for type 'r' K %  and compressed for type 'w'.  If the filename prefix is '|', it is piped> %  to or from a system command.a %>* %  The format of the OpenImage routine is: %g' %      OpenImage(image_info,image,type)a %>+ %  A description of each parameter follows:g %l@ %    o image_info: Specifies a pointer to a ImageInfo structure. %h7 %    o image: The address of a structure of type Image.) %l. %    o type: 'r' for reading; 'w' for writing. %  */I void OpenImage(const ImageInfo *image_info,Image *image,const char *type)  {v   char     filename[MaxTextExtent];  +   assert(image_info != (ImageInfo *) NULL); "   assert(image != (Image *) NULL);    assert(type != (char *) NULL);*   (void) strcpy(filename,image->filename);   if (*filename != '|')e!     if ((Extent(filename) > 3) && 9         (strcmp(filename+Extent(filename)-3,".gz") == 0))o       {>
         /*E           Uncompress/compress image file with GNU compress utilities. 
         */         if (*type == 'r')tA           (void) sprintf(filename,GunzipCommand,image->filename);m         else?           (void) sprintf(filename,GzipCommand,image->filename);        }m     else#       if ((Extent(filename) > 2) && :           (strcmp(filename+Extent(filename)-2,".Z") == 0))	         {y           /*H             Uncompress/compress image file with UNIX compress utilities.           */           if (*type == 'r') G             (void) sprintf(filename,UncompressCommand,image->filename);>           elseE             (void) sprintf(filename,CompressCommand,image->filename);(	         })   /*     Open image file.   */   image->pipe=False;    if (strcmp(filename,"-") == 0)0     image->file=(*type == 'r') ? stdin : stdout;   else; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)i     if (*filename == '|')e       {          char           mode[MaxTextExtent];  
         /*1           Pipe image to or from a system command.R
         */         if (*type == 'w')m)           (void) signal(SIGPIPE,SIG_IGN); $         (void) strncpy(mode,type,1);4         image->file=(FILE *) popen(filename+1,mode);         image->pipe=True;m       }l     else #endif       {e2         if ((*type == 'w') && !image_info->adjoin)4           if ((image->previous != (Image *) NULL) ||.               (image->next != (Image *) NULL))
             {U               /*4                 Form filename for multi-part images.               */D               (void) sprintf(filename,image->filename,image->scene);8               if (strcmp(filename,image->filename) == 0)N                 (void) sprintf(filename,"%s.%u",image->filename,image->scene);0               if (image->next != (Image *) NULL)A                 (void) strcpy(image->next->magick,image->magick);y6               (void) strcpy(image->filename,filename);
             }; #if defined(macintosh)         if (*type == 'w')a           {              OSType               filetype;o               Str255               name;>  2             (void) strcpy((char *) name,filename);#             CtoPstr((char *) name);a             filetype='    ';A             (void) strncpy((char *) &filetype,image_info->magick, 1               Min(Extent(image_info->magick),4));%+             Create(name,0,'8BIM',filetype);            }  #endif2         image->file=(FILE *) fopen(filename,type);)         if (image->file != (FILE *) NULL)            { +             (void) fseek(image->file,0L,2); /             image->filesize=ftell(image->file); +             (void) fseek(image->file,0L,0);            }        }    image->status=False;   if (*type == 'r')      { !       image->next=(Image *) NULL; %       image->previous=(Image *) NULL;      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %%O %                                                                             % O %                                                                             %rO %   P a r s e I m a g e G e o m e t r y                                       %eO %                                                                             %eO %                                                                             %oO %                                                                             %AO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I %eM %  Function ParseImageGeometry parse a geometry specification and returns thet %  width and height values.r % 3 %  The format of the ParseImageGeometry routine is:o %a@ %      flags=ParseImageGeometry(image_geometry,x,y,width,height) % + %  A description of each parameter follows:d %nK %    o flags:  Function ParseImageGeometry returns a bitmask that indicatesmJ %      which of the four values (width, height, xoffset, and yoffset) wereG %      actually found in the string, and whether the x and y values aree %      negative. % N %    o image_geometry:  Specifies a character string representing the geometry %      specification.n %iJ %    o x,y:  A pointer to an integer.  The x and y offset as determined by3 %      the geometry specification is returned here.R %aM %    o width,height:  A pointer to an unsigned integer.  The width and height D %      as determined by the geometry specification is returned here. %i %  */B Export int ParseImageGeometry(char *image_geometry,int *x, int *y,+   unsigned int *width,unsigned int *height)y {e   char     geometry[MaxTextExtent];     intN
     flags;     register charo     *p;      unsigned int     aspect_ratio,m     former_height,     former_width,t     greater,	     less,r     percentage;f     /*'     Ensure the image geometry is valid.i   */   assert(x != (int *) NULL);   assert(y != (int *) NULL);)   assert(width != (unsigned int *) NULL); *   assert(height != (unsigned int *) NULL);&   if (image_geometry == (char *) NULL)     return(NoValue);   /*J     Remove whitespaces and % and ! characters from geometry specification.   */)   (void) strcpy(geometry,image_geometry);n   aspect_ratio=True;   greater=False;
   less=False;    percentage=False; 
   p=geometry;    while (Extent(p) > 0)    {r     if (isspace(*p))       (void) strcpy(p,p+1);      else       switch (*p)        {p         case '%': 	         {f           percentage=True;           (void) strcpy(p,p+1);i           break;	         }=         case '!': 	         {n           aspect_ratio=False;n           (void) strcpy(p,p+1);=           break;	         };         case '<': 	         {m           less=True;           (void) strcpy(p,p+1);            break;	         }          case '>': 	         {-           greater=True;            (void) strcpy(p,p+1);e           break;	         }[         case '~':f	         {g           aspect_ratio=False;o           greater=False;           less=False;f           percentage=False;l           (void) strcpy(p,p+1);;           break;	         }x         default:           p++;       }    }    /*(     Parse geometry using XParseGeometry.   */   former_width=(*width);   former_height=(*height);2   flags=XParseGeometry(geometry,x,y,width,height);@   if (((flags & WidthValue) != 0) && (flags & HeightValue) == 0)     *height=(*width);e   if (percentage)      { 	       int          count;         float0         x_scale,         y_scale;         /*3         Geometry is a percentage of the image size.a       */       x_scale=(*width);        y_scale=(*height);7       count=sscanf(geometry,"%fx%f",&x_scale,&y_scale);C       if (count == 1),         y_scale=x_scale;B       *width=Max((unsigned int) ((x_scale*former_width)/100.0),1);D       *height=Max((unsigned int) ((y_scale*former_height)/100.0),1);       former_width=(*width);       former_height=(*height);     }f   if (aspect_ratio)=     {(       unsigned long0         scale_factor;          /**         Respect aspect ratio of the image.       */       scale_factor=UpShift(1);,       if ((former_width*former_height) != 0)F         if (((flags & WidthValue) != 0) && (flags & HeightValue) != 0)           { 6             scale_factor=UpShift(*width)/former_width;@             if (scale_factor > (UpShift(*height)/former_height)):               scale_factor=UpShift(*height)/former_height;           })         else(           if ((flags & WidthValue) != 0)6             scale_factor=UpShift(*width)/former_width;           else8             scale_factor=UpShift(*height)/former_height;9       *width=Max(DownShift(former_width*scale_factor),1);";       *height=Max(DownShift(former_height*scale_factor),1);      }    if (greater)=     if ((former_width < *width) && (former_height < *height))-       {          *width=former_width;         *height=former_height;       }L   if (less))=     if ((former_width > *width) && (former_height > *height))v       {n         *width=former_width;         *height=former_height;       }-   return(flags); }- g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/O %                                                                             %oO %                                                                             %gO %     R G B T r a n s f o r m I m a g e                                       %eO %                                                                             %sO %                                                                             %-O %                                                                             %yO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %-F %  Function RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standardgL %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..MaxRGB]. %-2 %  The format of the RGBTransformImage routine is: %q* %      RGBTransformImage(image,colorspace) %;+ %  A description of each parameter follows:e %mF %    o image: The address of a structure of type Image;  returned from %      ReadImage.p % L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %  %a */B void RGBTransformImage(Image *image,const unsigned int colorspace) {)A #define RGBTransformImageText  "  Transforming image colors...  "+ #define X 0  #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     long     tx,p     ty,,     tz,_     *x,w     *y,      *z;   	   Quantuml     *range_table;/     register int	     blue,g
     green,     i,     red;     register Quantum     *range_limit;n     register RunlengthPacket     *p;   "   assert(image != (Image *) NULL);M   if ((colorspace == RGBColorspace) || (colorspace == TransparentColorspace))      return; #   if (colorspace == GRAYColorspace)      {        /*2         Return if the image is already gray_scale.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {p:         if ((p->red != p->green) || (p->green != p->blue))           break;         p++;       }l       if (i == image->packets)         return;e     }-   /*     Allocate the tables.   *//   x=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); /   y=(long *) malloc(3*(MaxRGB+1)*sizeof(long));%/   z=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); ?   range_table=(Quantum *) malloc(4*(MaxRGB+1)*sizeof(Quantum)); 5   if ((x == (long *) NULL) || (y == (long *) NULL) || @       (z == (long *) NULL) || (range_table == (Quantum *) NULL))     { L       Warning("Unable to transform color space","Memory allocation failed");
       return;      }    /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_table[i]=0; *     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;%   }%   for (i=0; i <= MaxRGB; i++)%'     range_table[i+(MaxRGB+1)*3]=MaxRGB;n%   range_limit=range_table+(MaxRGB+1);g   tx=0;p   ty=0;c   tz=0;    switch (colorspace)r   {f     case GRAYColorspace:     {s       /*         Initialize GRAY tables:u  +           G = 0.29900*R+0.58600*G+0.11400*Bl       */!       for (i=0; i <= MaxRGB; i++)r       { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.29900)*i;$         y[i+Y]=UpShifted(0.58600)*i;$         z[i+Y]=UpShifted(0.11400)*i;$         x[i+Z]=UpShifted(0.29900)*i;$         y[i+Z]=UpShifted(0.58600)*i;$         z[i+Z]=UpShifted(0.11400)*i;       }        break;     }a     case OHTAColorspace:     {=       /*         Initialize OHTA tables:   ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0e         through MaxRGB.=       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.33333)*i;$         y[i+X]=UpShifted(0.33334)*i;$         z[i+X]=UpShifted(0.33333)*i;$         x[i+Y]=UpShifted(0.50000)*i;         y[i+Y]=0; '         z[i+Y]=(-UpShifted(0.50000))*i; '         x[i+Z]=(-UpShifted(0.25000))*i; $         y[i+Z]=UpShifted(0.50000)*i;'         z[i+Z]=(-UpShifted(0.25000))*i;        }        break;     }      case XYZColorspace:      {        /*"         Initialize CIE XYZ tables:  .           X = 0.412453*X+0.357580*Y+0.180423*Z.           Y = 0.212671*X+0.715160*Y+0.072169*Z.           Z = 0.019334*X+0.119193*Y+0.950227*Z       */!       for (i=0; i <= MaxRGB; i++)        { %         x[i+X]=UpShifted(0.412453)*i; %         y[i+X]=UpShifted(0.357580)*i;%%         z[i+X]=UpShifted(0.180423)*i;%%         x[i+Y]=UpShifted(0.212671)*i;e%         y[i+Y]=UpShifted(0.715160)*i;s%         z[i+Y]=UpShifted(0.072169)*i;f%         x[i+Z]=UpShifted(0.019334)*i; %         y[i+Z]=UpShifted(0.119193)*i;b%         z[i+Z]=UpShifted(0.950227)*i;m       }o       break;     }e     case YCbCrColorspace:e     {e       /*          Initialize YCbCr tables:  /           Y =  0.299000*R+0.586000*G+0.114000*Bg/           Cb= -0.172586*R-0.338828*G+0.511414*Bt/           Cr=  0.511414*R-0.428246*G-0.083168*Bt  K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)t       {(%         x[i+X]=UpShifted(0.299000)*i; %         y[i+X]=UpShifted(0.586000)*i;f%         z[i+X]=UpShifted(0.114000)*i;((         x[i+Y]=(-UpShifted(0.172586))*i;(         y[i+Y]=(-UpShifted(0.338828))*i;%         z[i+Y]=UpShifted(0.511414)*i;f%         x[i+Z]=UpShifted(0.511414)*i; (         y[i+Z]=(-UpShifted(0.428246))*i;(         z[i+Z]=(-UpShifted(0.083168))*i;       })       break;     }0     case YCCColorspace:f     {%       /*         Initialize YCC tables:  ,           Y =  0.29900*R+0.58600*G+0.11400*B,           C1= -0.29900*R-0.58600*G+0.88600*B,           C2=  0.70100*R-0.58600*G-0.11400*B  B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */0       ty=UpShifted((unsigned int) UpScale(156));0       tz=UpShifted((unsigned int) UpScale(137));/       for (i=0; i <= (int) (0.018*MaxRGB); i++)r       { A         x[i+X]=(long) (UpShifted(0.29900/1.3584)*0.018*MaxRGB*i); A         y[i+X]=(long) (UpShifted(0.58600/1.3584)*0.018*MaxRGB*i); A         z[i+X]=(long) (UpShifted(0.11400/1.3584)*0.018*MaxRGB*i);iD         x[i+Y]=(long) ((-UpShifted(0.29900/2.2179))*0.018*MaxRGB*i);D         y[i+Y]=(long) ((-UpShifted(0.58600/2.2179))*0.018*MaxRGB*i);A         z[i+Y]=(long) (UpShifted(0.88600/2.2179)*0.018*MaxRGB*i);vA         x[i+Z]=(long) (UpShifted(0.70100/1.8215)*0.018*MaxRGB*i);rD         y[i+Z]=(long) ((-UpShifted(0.58600/1.8215))*0.018*MaxRGB*i);D         z[i+Z]=(long) ((-UpShifted(0.11400/1.8215))*0.018*MaxRGB*i);       }        for ( ; i <= MaxRGB; i++)e       {%B         x[i+X]=(long) (UpShifted(0.29900/1.3584)*(1.099*i-0.099));B         y[i+X]=(long) (UpShifted(0.58600/1.3584)*(1.099*i-0.099));B         z[i+X]=(long) (UpShifted(0.11400/1.3584)*(1.099*i-0.099));E         x[i+Y]=(long) ((-UpShifted(0.29900/2.2179))*(1.099*i-0.099));nE         y[i+Y]=(long) ((-UpShifted(0.58600/2.2179))*(1.099*i-0.099));-B         z[i+Y]=(long) (UpShifted(0.88600/2.2179)*(1.099*i-0.099));B         x[i+Z]=(long) (UpShifted(0.70100/1.8215)*(1.099*i-0.099));E         y[i+Z]=(long) ((-UpShifted(0.58600/1.8215))*(1.099*i-0.099)); E         z[i+Z]=(long) ((-UpShifted(0.11400/1.8215))*(1.099*i-0.099));f       }e       break;     }m     case YIQColorspace:=     {t       /*         Initialize YIQ tables:  +           Y = 0.29900*R+0.58600*G+0.11400*Bl+           I = 0.50000*R-0.23000*G-0.27000*Ba+           Q = 0.20200*R-0.50000*G+0.29800*Bt  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0c         through MaxRGB.        */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        {f$         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;$         x[i+Y]=UpShifted(0.50000)*i;'         y[i+Y]=(-UpShifted(0.23000))*i;f'         z[i+Y]=(-UpShifted(0.27000))*i;r$         x[i+Z]=UpShifted(0.20200)*i;'         y[i+Z]=(-UpShifted(0.50000))*i;b$         z[i+Z]=UpShifted(0.29800)*i;       }t       break;     }      case YPbPrColorspace:      {r       /*          Initialize YPbPr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*B /           Pb= -0.168736*R-0.331264*G+0.500000*B /           Pr=  0.500000*R-0.418688*G-0.081312*B   K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.,       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)6       { %         x[i+X]=UpShifted(0.299000)*i;*%         y[i+X]=UpShifted(0.587000)*i;t%         z[i+X]=UpShifted(0.114000)*i;e(         x[i+Y]=(-UpShifted(0.168736))*i;(         y[i+Y]=(-UpShifted(0.331264))*i;%         z[i+Y]=UpShifted(0.500000)*i;r%         x[i+Z]=UpShifted(0.500000)*i;g(         y[i+Z]=(-UpShifted(0.418688))*i;(         z[i+Z]=(-UpShifted(0.081312))*i;       }        break;     }r     case YUVColorspace:n     default:     {        /*         Initialize YUV tables:  ,           Y =  0.29900*R+0.58600*G+0.11400*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 0 D         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */$       ty=UpShifted((MaxRGB+1) >> 1);$       tz=UpShifted((MaxRGB+1) >> 1);!       for (i=0; i <= MaxRGB; i++)        { $         x[i+X]=UpShifted(0.29900)*i;$         y[i+X]=UpShifted(0.58600)*i;$         z[i+X]=UpShifted(0.11400)*i;'         x[i+Y]=(-UpShifted(0.14740))*i; '         y[i+Y]=(-UpShifted(0.28950))*i;r$         z[i+Y]=UpShifted(0.43690)*i;$         x[i+Z]=UpShifted(0.61500)*i;'         y[i+Z]=(-UpShifted(0.51500))*i; '         z[i+Z]=(-UpShifted(0.10000))*i;e       }        break;     }l   }r   /*     Convert from RGB.,   */   switch (image->class)c   {s     case DirectClass:)     default:     {e       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          red=p->red;          green=p->green;          blue=p->blue;,H         p->red=range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];J         p->green=range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];I         p->blue=range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];l         p++;!         if (QuantumTick(i,image))cB           ProgressMonitor(RGBTransformImageText,i,image->packets);       }t       break;     }i     case PseudoClass:s     {e       /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)        {u#         red=image->colormap[i].red;s'         green=image->colormap[i].green;t%         blue=image->colormap[i].blue;g         image->colormap[i].red=fC           range_limit[DownShift(x[red+X]+y[green+X]+z[blue+X]+tx)];t!         image->colormap[i].green=pC           range_limit[DownShift(x[red+Y]+y[green+Y]+z[blue+Y]+ty)];n          image->colormap[i].blue=C           range_limit[DownShift(x[red+Z]+y[green+Z]+z[blue+Z]+tz)];s       }f       SyncImage(image);i       break;     }l   }d   /*     Free allocated memory.   */   free((char *) range_table);f   free((char *) z);\   free((char *) y);;   free((char *) x);l }  r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %xO %                                                                             %cO %                                                                             %uO %   R o l l I m a g e                                                         %,O %                                                                             % O %                                                                             %cO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%L %+E %  Function RollImage rolls an image vertically and horizontally.  It;K %  allocates the memory necessary for the new Image structure and returns ai %  pointer to the new image. %m* %  The format of the RollImage routine is: %n6 %      rolled_image=RollImage(image,x_offset,y_offset) %r+ %  A description of each parameter follows:  % L %    o rolled_image: Function RollImage returns a pointer to the image afterH %      rolling.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  %/H %    o x_offset: An integer that specifies the number of columns to roll# %      in the horizontal direction.  %iL %    o y_offset: An integer that specifies the number of rows to roll in the %      vertical direction. %  %  */8 Image *RollImage(Image *image,int x_offset,int y_offset) { - #define RollImageText  "  Rolling image...  "      Imagen     *rolled_image;     int      y;     register int     x;     register RunlengthPacket     *p,      *q;a     /*'     Initialize rolled image attributes.*   */"   assert(image != (Image *) NULL);A   rolled_image=CopyImage(image,image->columns,image->rows,False); %   if (rolled_image == (Image *) NULL)>     {cA       Warning("Unable to roll image","Memory allocation failed");i       return((Image *) NULL);      }    /*     Roll image.    */!   x_offset%=(int) image->columns;    if (x_offset < 0) #     x_offset+=(int) image->columns;;   y_offset%=(int) image->rows;   if (y_offset < 0)       y_offset+=(int) image->rows;   p=image->pixels;   image->runlength=p->length+1; !   for (y=0; y < image->rows; y++)n   {l     /*       Transfer scanline.     */&     for (x=0; x < image->columns; x++)     {         if (image->runlength != 0)         image->runlength--; 
       else	         {a           p++;%           image->runlength=p->length;%	         }%I       q=rolled_image->pixels+((y_offset+y) % image->rows)*image->columns+ (         ((x+x_offset) % image->columns);       *q=(*p);       q->length=0;     } 1     ProgressMonitor(RollImageText,y,image->rows);    }    return(rolled_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S a m p l e I m a g e                                                     %%O %                                                                             %tO %                                                                             %nO %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %oG %  Function SampleImage creates a new image that is a scaled size of ansH %  existing one using pixel sampling.  It allocates the memory necessaryF %  for the new Image structure and returns a pointer to the new image. %m, %  The format of the SampleImage routine is: %*4 %      sampled_image=SampleImage(image,columns,rows) %l+ %  A description of each parameter follows:) % O %    o sampled_image: Function SampleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. %a7 %    o image: The address of a structure of type Image.( %rN %    o columns: An integer that specifies the number of columns in the sampled
 %      image.= %oH %    o rows: An integer that specifies the number of rows in the sampled
 %      image.s %a %e */G Image *SampleImage(Image *image,unsigned int columns,unsigned int rows)s {a0 #define SampleImageText  "  Sampling image...  "     Imagem     *sampled_image;n     int      y;     register RunlengthPacket     *p,      *q,-     *s;i     register int     x;     RunlengthPacketr     *scanline;     unsigned int     *x_offset,     *y_offset;     unsigned longf     scale_factor;h  "   assert(image != (Image *) NULL);$   if ((columns == 0) || (rows == 0))     { D       Warning("Unable to sample image","image dimensions are zero");       return((Image *) NULL);      }m   /*(     Initialize sampled image attributes.   */4   sampled_image=CopyImage(image,columns,rows,False);&   if (sampled_image == (Image *) NULL)     {-C       Warning("Unable to sample image","Memory allocation failed");L       return((Image *) NULL);i     }g   /*8     Allocate scan line buffer and column offset buffers.   */N   scanline=(RunlengthPacket *) malloc(image->columns*sizeof(RunlengthPacket));P   x_offset=(unsigned int *) malloc(sampled_image->columns*sizeof(unsigned int));M   y_offset=(unsigned int *) malloc(sampled_image->rows*sizeof(unsigned int)); /   if ((scanline == (RunlengthPacket *) NULL) || ,       (x_offset == (unsigned int *) NULL) ||*       (y_offset == (unsigned int *) NULL))     { C       Warning("Unable to sample image","Memory allocation failed"); "       DestroyImage(sampled_image);       return((Image *) NULL);      }    /*$     Initialize column pixel offsets.   */@   scale_factor=UpShift(image->columns-1)/sampled_image->columns;   columns=0;,   for (x=0; x < sampled_image->columns; x++)   { <     x_offset[x]=DownShift((x+1)*scale_factor)-(int) columns;     columns+=x_offset[x];%   }%   /*!     Initialize row pixel offsets.%   */:   scale_factor=UpShift(image->rows-1)/sampled_image->rows;	   rows=0;a)   for (y=0; y < sampled_image->rows; y++)r   {f9     y_offset[y]=DownShift((y+1)*scale_factor)-(int) rows;a     rows+=y_offset[y];   } $   y_offset[sampled_image->rows-1]=0;   /*     Preload first scanline.    */   p=image->pixels;   image->runlength=p->length+1;i
   s=scanline;m$   for (x=0; x < image->columns; x++)   {      if (image->runlength != 0)       image->runlength--;a     else       {l         p++;#         image->runlength=p->length;m       }i     *s=(*p);     s->length=0;     s++;   }a   /*     Sample each row.   */   q=sampled_image->pixels;)   for (y=0; y < sampled_image->rows; y++)o   {m     /*       Sample each column.e     */     s=scanline; .     for (x=0; x < sampled_image->columns; x++)     {%       *q=(*s);
       q++;       s+=x_offset[x];%     }%     if (y_offset[y] != 0)        { 
         /*           Skip a scan line. 
         */         if (y_offset[y] > 1)>           for (x=0; x < (image->columns*(y_offset[y]-1)); x++)&             if (image->runlength != 0)!               image->runlength--;              else               {                  p++;+                 image->runlength=p->length;                } 
         /*           Read a scan line. 
         */         s=scanline; *         for (x=0; x < image->columns; x++)	         { $           if (image->runlength != 0)             image->runlength--;            else
             {%               p++;)               image->runlength=p->length;n
             }            *s=(*p);           s->length=0;           s++;	         }        }a;     ProgressMonitor(SampleImageText,y,sampled_image->rows);n   }_   free((char *) scanline);   free((char *) x_offset);   free((char *) y_offset);   return(sampled_image); }a   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %rO %                                                                             % O %                                                                             %;O %   S c a l e I m a g e                                                       %iO %                                                                             % O %                                                                             %tO %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % F %  Function ScaleImage creates a new image that is a scaled size of anE %  existing one.  It allocates the memory necessary for the new Image I %  structure and returns a pointer to the new image.  To scale a scanline K %  from x pixels to y pixels, each new pixel represents x/y old pixels.  ToIL %  read x/y pixels, read (x/y rounded up) pixels but only count the requiredH %  fraction of the last old pixel read in your new pixel.  The remainder: %  of the old pixel will be counted in the next new pixel. %hK %  The scaling algorithm was suggested by rjohnson@shell.com and is adapted 0 %  from pnmscale(1) of PBMPLUS by Jef Poskanzer. %t+ %  The format of the ScaleImage routine is:  % 2 %      scaled_image=ScaleImage(image,columns,rows) % + %  A description of each parameter follows:v %)M %    o scaled_image: Function ScaleImage returns a pointer to the image after H %      scaling.  A null image is returned if there is a memory shortage. %f7 %    o image: The address of a structure of type Image.i %iM %    o columns: An integer that specifies the number of columns in the scaledi
 %      image.a %iG %    o rows: An integer that specifies the number of rows in the scaled 
 %      image.f %s %i */: Image *ScaleImage(Image *image,const unsigned int columns,   const unsigned int rows) {l. #define ScaleImageText  "  Scaling image...  "     typedef struct ScaledPacket    {q     long
       red,       green,       blue,        index;   } ScaledPacket;t     Image      *scaled_image;     int 
     next_row,n     number_rows;     long     x_scale,     x_span;i     register RunlengthPacket     *p,t     *q;f     register ScaledPackett     *s,      *t;a     register unsigned intp     x;     ScaledPacket     *scaled_scanline,=     *scanline,     *y_vector,     *x_vector;     unsigned int     packets,     y;     unsigned longe	     blue, 
     green,
     index,     red,     scale_factor;r  "   assert(image != (Image *) NULL);$   if ((columns == 0) || (rows == 0))     {yC       Warning("Unable to scale image","image dimensions are zero");r       return((Image *) NULL);v     }u   /*'     Initialize scaled image attributes.;   */B   scale_factor=UpShift(columns*rows)/(image->columns*image->rows);8   packets=Max(DownShift(image->packets*scale_factor),1);0   scaled_image=CopyImage(image,packets,1,False);%   if (scaled_image == (Image *) NULL)x     {lB       Warning("Unable to scale image","Memory allocation failed");       return((Image *) NULL);e     } "   scaled_image->class=DirectClass;    scaled_image->columns=columns;   scaled_image->rows=rows;   scaled_image->packets=0;   /*     Allocate memory.   */H   x_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));   scanline=x_vector;(   if (scaled_image->rows != image->rows)J     scanline=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));"   scaled_scanline=(ScaledPacket *)7     malloc(scaled_image->columns*sizeof(ScaledPacket));=H   y_vector=(ScaledPacket *) malloc(image->columns*sizeof(ScaledPacket));,   if ((x_vector == (ScaledPacket *) NULL) ||,       (scanline == (ScaledPacket *) NULL) ||3       (scaled_scanline == (ScaledPacket *) NULL) || *       (y_vector == (ScaledPacket *) NULL))     { B       Warning("Unable to scale image","Memory allocation failed");!       DestroyImage(scaled_image);i       return((Image *) NULL);x     }o   /*     Scale image.   */
   index=0;   number_rows=0;   next_row=True;2   x_scale=UpShift(scaled_image->rows)/image->rows;   x_span=UpShift(1);$   for (x=0; x < image->columns; x++)   {o     y_vector[x].red=0;     y_vector[x].green=0;     y_vector[x].blue=0;/     y_vector[x].index=0;   }    p=image->pixels;   image->runlength=p->length+1;;   q=scaled_image->pixels;r   q->red=0;t
   q->green=0;m   q->blue=0;
   q->index=0;    q->length=MaxRunlength;%(   for (y=0; y < scaled_image->rows; y++)   {)*     if (scaled_image->rows == image->rows)(       for (x=0; x < image->columns; x++)       {)
         /*           Read a new scanline.
         */"         if (image->runlength != 0)           image->runlength--;&         else           {              p++;'             image->runlength=p->length;)           }o         x_vector[x].red=p->red;s#         x_vector[x].green=p->green;v!         x_vector[x].blue=p->blue;_#         x_vector[x].index=p->index;i       }      else       {v
         /*           Scale Y direction.
         */          while (x_scale < x_span)	         {*6           if (next_row && (number_rows < image->rows))
             {r               /*$                 Read a new scanline.               */0               for (x=0; x < image->columns; x++)               { *                 if (image->runlength != 0)%                   image->runlength--;                  else                   {(                     p++;/                     image->runlength=p->length;o                   } '                 x_vector[x].red=p->red; +                 x_vector[x].green=p->green; )                 x_vector[x].blue=p->blue;;+                 x_vector[x].index=p->index;t               }                number_rows++;
             }d,           for (x=0; x < image->columns; x++)           {w5             y_vector[x].red+=x_scale*x_vector[x].red;e9             y_vector[x].green+=x_scale*x_vector[x].green;o7             y_vector[x].blue+=x_scale*x_vector[x].blue;e9             y_vector[x].index+=x_scale*x_vector[x].index;(           }(           x_span-=x_scale;:           x_scale=UpShift(scaled_image->rows)/image->rows;           next_row=True;	         }=4         if (next_row && (number_rows < image->rows))           {              /*"               Read a new scanline.             */.             for (x=0; x < image->columns; x++)
             { (               if (image->runlength != 0)#                 image->runlength--;+               else                 {                    p++;-                   image->runlength=p->length;                  } %               x_vector[x].red=p->red;m)               x_vector[x].green=p->green; '               x_vector[x].blue=p->blue; )               x_vector[x].index=p->index;n
             }i             number_rows++;             next_row=False;            }o         s=scanline;r*         for (x=0; x < image->columns; x++)	         {o@           red=DownShift(y_vector[x].red+x_span*x_vector[x].red);F           green=DownShift(y_vector[x].green+x_span*x_vector[x].green);C           blue=DownShift(y_vector[x].blue+x_span*x_vector[x].blue); F           index=DownShift(y_vector[x].index+x_span*x_vector[x].index);9           s->red=(Quantum) (red > MaxRGB ? MaxRGB : red); ?           s->green=(Quantum) (green > MaxRGB ? MaxRGB : green);l<           s->blue=(Quantum) (blue > MaxRGB ? MaxRGB : blue);#           s->index=(unsigned short) @             (index > MaxColormapSize ? MaxColormapSize : index);           s++;           y_vector[x].red=0;           y_vector[x].green=0;           y_vector[x].blue=0;            y_vector[x].index=0;	         }          x_scale-=x_span;         if (x_scale == 0)%           {%<             x_scale=UpShift(scaled_image->rows)/image->rows;             next_row=True;           }          x_span=UpShift(1);       } 0     if (scaled_image->columns == image->columns)       { 
         /*,           Transfer scanline to scaled image.
         */         s=scanline; 1         for (x=0; x < scaled_image->columns; x++) 	         { =           if ((s->red == q->red) && (s->green == q->green) && ?               (s->blue == q->blue) && (s->index == q->index) && /               ((int) q->length < MaxRunlength))              q->length++;           else
             {%-               if (scaled_image->packets != 0)a                 q++;&               scaled_image->packets++;3               if (scaled_image->packets == packets)i                 {E                   packets<<=1;K                   scaled_image->pixels=(RunlengthPacket *) realloc((char *)rJ                     scaled_image->pixels,packets*sizeof(RunlengthPacket));G                   if (scaled_image->pixels == (RunlengthPacket *) NULL)i                     { 6                       Warning("Unable to scale image",4                         "Memory allocation failed");1                       DestroyImage(scaled_image);p-                       return((Image *) NULL);a                     }eA                   q=scaled_image->pixels+scaled_image->packets-1;M                 }i&               q->red=(Quantum) s->red;*               q->green=(Quantum) s->green;(               q->blue=(Quantum) s->blue;1               q->index=(unsigned short) s->index;                q->length=0;
             }|           s++;	         }(       })     else       {          intU           next_column;           long           y_scale,           y_span;   
         /*           Scale X direction.
         */         red=0;         green=0;         blue=0;          next_column=False;         y_span=UpShift(1);         s=scanline;>         t=scaled_scanline;*         for (x=0; x < image->columns; x++)	         {o@           y_scale=UpShift(scaled_image->columns)/image->columns;#           while (y_scale >= y_span)            {*             if (next_column)               {                  red=0;                 green=0;                 blue=0;u                 index=0;                 t++;               }m-             red=DownShift(red+y_span*s->red); 3             green=DownShift(green+y_span*s->green);i0             blue=DownShift(blue+y_span*s->blue);3             index=DownShift(index+y_span*s->index);w;             t->red=(Quantum) (red > MaxRGB ? MaxRGB : red);lA             t->green=(Quantum) (green > MaxRGB ? MaxRGB : green); >             t->blue=(Quantum) (blue > MaxRGB ? MaxRGB : blue);%             t->index=(unsigned short)_B               (index > MaxColormapSize ? MaxColormapSize : index);             y_scale-=y_span;             y_span=UpShift(1);             next_column=True;e           }a         if (y_scale > 0)           {              if (next_column)               {                  red=0;                 green=0;                 blue=0;                  index=0;"                 next_column=False;                 t++;               }r              red+=y_scale*s->red;$             green+=y_scale*s->green;"             blue+=y_scale*s->blue;$             index+=y_scale*s->index;             y_span-=y_scale;           }g         s++;       }        if (y_span > 0)*	         {m           s--;           red+=y_span*s->red;%!           green+=y_span*s->green;%           blue+=y_span*s->blue; !           index+=y_span*s->index; 	         }        if (!next_column) 	         {            red=DownShift(red); !           green=DownShift(green);            blue=DownShift(blue); !           index=DownShift(index); 9           t->red=(Quantum) (red > MaxRGB ? MaxRGB : red); ?           t->green=(Quantum) (green > MaxRGB ? MaxRGB : green); <           t->blue=(Quantum) (blue > MaxRGB ? MaxRGB : blue);F           t->index=(unsigned short) (index > MaxRGB ? MaxRGB : index);	         }        /**         Transfer scanline to scaled image.       */       t=scaled_scanline;/       for (x=0; x < scaled_image->columns; x++)        {F;         if ((t->red == q->red) && (t->green == q->green) &&l=             (t->blue == q->blue) && (t->index == q->index) &&s-             ((int) q->length < MaxRunlength))s           q->length++;         else           {t+             if (scaled_image->packets != 0)i               q++;$             scaled_image->packets++;1             if (scaled_image->packets == packets)F               {a                 packets<<=1;I                 scaled_image->pixels=(RunlengthPacket *) realloc((char *)sH                   scaled_image->pixels,packets*sizeof(RunlengthPacket));E                 if (scaled_image->pixels == (RunlengthPacket *) NULL)                    { P                     Warning("Unable to scale image","Memory allocation failed");/                     DestroyImage(scaled_image); +                     return((Image *) NULL);                    }f?                 q=scaled_image->pixels+scaled_image->packets-1;;               }=$             q->red=(Quantum) t->red;(             q->green=(Quantum) t->green;&             q->blue=(Quantum) t->blue;/             q->index=(unsigned short) t->index;              q->length=0;           }          t++;       }i     }e9     ProgressMonitor(ScaleImageText,y,scaled_image->rows);c   });   scaled_image->pixels=(RunlengthPacket *) realloc((char *)iH     scaled_image->pixels,scaled_image->packets*sizeof(RunlengthPacket));   /*     Free allocated memory.   */   free((char *) y_vector);!   free((char *) scaled_scanline);    if (scanline != x_vector)      free((char *) scanline);   free((char *) x_vector);   return(scaled_image);- }x + /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %mO %                                                                             % O %                                                                             % O %   S e t I m a g e I n f o                                                   % O %                                                                             %+O %                                                                             % O %                                                                             %cO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%H %  Function SetImageInfo initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix or I %  suffix of the filename.  For example, `ps:image' returns PS indicating H %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.M %  The filename prefix has precedance over the suffix.  Use an optional index L %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).  % - %  The format of the SetImageInfo routine is:  % & %      SetImageInfo(image_info,recify) %%+ %  A description of each parameter follows:% %%@ %    o image_info: Specifies a pointer to a ImageInfo structure. %tM %    o rectify: an unsigned value other than zero rectifies the attribute for N %      multi-frame support (user may want multi-frame but image format may not %      support it).  %t %F */D Export void SetImageInfo(ImageInfo *image_info,unsigned int rectify) {s   char     c,     magick[MaxTextExtent];     intp
     flags,     x,     y;     register chart     *p,g     *q;      register int     i;     unsigned int     height,a
     width;     /*(     Look for 'image.format' in filename.   */+   assert(image_info != (ImageInfo *) NULL);I   *magick='\0';)8   p=image_info->filename+Extent(image_info->filename)-1;   if (*p == ']').     for (q=p-1; q > image_info->filename; q--)     {        if (*q != '[')         continue; ;       image_info->tile=(char *) malloc((p-q)*sizeof(char));*,       if (image_info->tile == (char *) NULL)         break;1       (void) strncpy(image_info->tile,q+1,p-q-1);m#       image_info->tile[p-q-1]='\0';;(       if (!IsGeometry(image_info->tile))	         { !           free(image_info->tile);,)           image_info->tile=(char *) NULL;(           break;	         }*B       flags=XParseGeometry(image_info->tile,&x,&y,&width,&height);!       if (!(flags & HeightValue))(	         {m           /*6             Sub-image specified (e.g. img0001.pcd[4]).           */6           image_info->subimage=atoi(image_info->tile);6           image_info->subrange=atoi(image_info->tile);G           (void) sscanf(image_info->tile,"%u-%u",&image_info->subimage,g#             &image_info->subrange);g7           image_info->subrange-=image_info->subimage-1;e	         }w       *q='\0';
       p=q;       break;     } 3   while ((*p != '.') && (p > image_info->filename))l     p--;6   if ((strcmp(p,".gz") == 0) || (strcmp(p,".Z") == 0))     do     { 
       p--;8     } while ((*p != '.') && (p > image_info->filename));2   if ((*p == '.') && (Extent(p) < sizeof(magick)))     {        /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)        {          if (*q == '.')           {              *q='\0';             break;           }l         c=(*q);)         if (islower(c))            *q=toupper(c);       };9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)%3         if (strcmp(magick,ImageFormats[i][0]) == 0)            {              /*E               SGI and RGB are ambiguous;  TMP must be set explicitly.              */>             if (((strncmp(image_info->magick,"SGI",3) != 0) ||<                  (strcmp(ImageFormats[i][0],"RGB") != 0)) &&8                 (strcmp(ImageFormats[i][0],"TMP") != 0))7               (void) strcpy(image_info->magick,magick);              break;           }      }    /*1     Look for explicit 'format:image' in filename.    */   image_info->affirm=False;    p=image_info->filename; %   while ((*p != ':') && (*p != '\0'))%     p++;A   if ((*p == ':') && ((p-image_info->filename) < sizeof(magick)))      {t       /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename);m*       magick[p-image_info->filename]='\0';%       for (q=magick; *q != '\0'; q++)e       {g         c=(*q);          if (islower(c))m           *q=toupper(c);       }d9       for (i=0; ImageFormats[i][0] != (char *) NULL; i++)m3         if (strcmp(magick,ImageFormats[i][0]) == 0)m           {a             /*,               Strip off image format prefix.             */             p++;2             (void) strcpy(image_info->filename,p);5             (void) strcpy(image_info->magick,magick); *             if (strcmp(magick,"TMP") != 0)&               image_info->affirm=True;             break;           }m     }e   /*%     Rectify multi-image file support.    */   if (rectify)7     for (i=0; ImageFormats[i][0] != (char *) NULL; i++) =       if (strcmp(image_info->magick,ImageFormats[i][0]) == 0) 7         image_info->adjoin&=IsTrue(ImageFormats[i][1]);  }t   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %rO %                                                                             %eO %                                                                             %)O %   S o r t C o l o r m a p B y I n t e n t s i t y                           %+O %                                                                             %tO %                                                                             %iO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function SortColormapByIntensity sorts the colormap of a PseudoClass imagea! %  by decreasing color intensity.i %,8 %  The format of the SortColormapByIntensity routine is: % % %      SortColormapByIntensity(image)r %l+ %  A description of each parameter follows:L % - %    o image: A pointer to a Image structure.  %n %a */  8 static int IntensityCompare(const void *x,const void *y) { 
   ColorPacketm
     *color_1,r
     *color_2;t     color_1=(ColorPacket *) x;   color_2=(ColorPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }t  * void SortColormapByIntensity(Image *image) {B   register int     i;     register RunlengthPacket     *p;n     register unsigned shortc
     index;     unsigned short     *pixels;  "   assert(image != (Image *) NULL);"   if (image->class != PseudoClass)     return;*   /*&     Allocate memory for pixel indexes.   */I   pixels=(unsigned short *) malloc(image->colors*sizeof(unsigned short));t(   if (pixels == (unsigned short *) NULL)     {;D       Warning("Unable to sort colormap","Memory allocation failed");
       return;i     }l   /*,     Assign index values to colormap entries.   */#   for (i=0; i < image->colors; i++)G0     image->colormap[i].index=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.i   */I   qsort((void *) image->colormap,(int) image->colors,sizeof(ColorPacket),n<     (int (*)(const void *, const void *)) IntensityCompare);   /*;     Update image colormap indexes to sorted colormap order.t   */#   for (i=0; i < image->colors; i++)d8     pixels[image->colormap[i].index]=(unsigned short) i;   p=image->pixels;$   for (i=0; i < image->packets; i++)   {)     index=pixels[p->index];M&     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p->index=index;y     p++;   }n   free((char *) pixels); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %oO %                                                                             %lO %                                                                             %+O %   S t e r e o I m a g e                                                     %eO %                                                                             %xO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %xL %  Function StereoImage combines two images and produces a single image thatI %  is the composite of a left and right image of a stereo pair.  The left I %  image is converted to gray_scale and written to the red channel of thehO %  stereo image.  The right image is converted to gray_scale and written to the L %  blue channel of the stereo image.  View the composite image with red-blue% %  glasses to create a stereo effect.a %;, %  The format of the StereoImage routine is: %>7 %      stereo_image=StereoImage(left_image,right_image)  % + %  A description of each parameter follows:  % I %    o stereo_image: Function StereoImage returns a pointer to the stereo F %      image.  A null image is returned if there is a memory shortage. %t< %    o left_image: The address of a structure of type Image. %+= %    o right_image: The address of a structure of type Image.0 %  %m */? Export Image *StereoImage(Image *left_image,Image *right_image)  {g. #define StereoImageText  "  Stereo image...  "     Image      *stereo_image;     inte     y;     QuantizeInfo     quantize_info;     register int     x;     register RunlengthPacket     *p,_     *q,+     *r;   '   assert(left_image != (Image *) NULL);t(   assert(right_image != (Image *) NULL);6   if ((left_image->columns != right_image->columns) ||.       (left_image->rows != right_image->rows))     { .       Warning("Unable to create stereo image",-         "left and right image sizes differ");n       return((Image *) NULL);      }    /*'     Initialize stereo image attributes.    */P   stereo_image=CopyImage(left_image,left_image->columns,left_image->rows,False);%   if (stereo_image == (Image *) NULL)      {+J       Warning("Unable to create stereo image","Memory allocation failed");       return((Image *) NULL);l     }r"   stereo_image->class=DirectClass;   /*C     Copy left image to red channel and right image to blue channel.m   */"   GetQuantizeInfo(&quantize_info);*   quantize_info.colorspace=GRAYColorspace;+   QuantizeImage(&quantize_info,left_image);m   SyncImage(left_image);   p=left_image->pixels; $   left_image->runlength=p->length+1;,   QuantizeImage(&quantize_info,right_image);   SyncImage(right_image);o   q=right_image->pixels;%   right_image->runlength=q->length+1;    r=stereo_image->pixels;f(   for (y=0; y < stereo_image->rows; y++)   {<-     for (x=0; x < stereo_image->columns; x++)      {_%       if (left_image->runlength != 0)a          left_image->runlength--;
       else	         {-           p++;*           left_image->runlength=p->length;	         } &       if (right_image->runlength != 0)!         right_image->runlength--;)
       else	         {;           q++;+           right_image->runlength=q->length;g	         } -       r->red=(unsigned int) (p->red*12) >> 4;%       r->green=0;%       r->blue=q->blue;       r->index=0;        r->length=0;
       r++;     } :     ProgressMonitor(StereoImageText,y,stereo_image->rows);   }    return(stereo_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   S y n c I m a g e                                                         % O %                                                                             % O %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % N %  Function SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. % * %  The format of the SyncImage routine is: %. %      SyncImage(image)  %g+ %  A description of each parameter follows:  %e7 %    o image: The address of a structure of type Image.t %i %  */# Export void SyncImage(Image *image)  {    register int     i;     register RunlengthPacket     *p;      register unsigned shorta
     index;  "   assert(image != (Image *) NULL);"   if (image->class == DirectClass)     return;e#   for (i=0; i < image->colors; i++)f   {a     image->colormap[i].index=0;g     image->colormap[i].flags=0;=   }    p=image->pixels;$   for (i=0; i < image->packets; i++)   {r     index=p->index; &     p->red=image->colormap[index].red;*     p->green=image->colormap[index].green;(     p->blue=image->colormap[index].blue;     p++;   }e }C r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             % O %     T e x t u r e I m a g e                                                 % O %                                                                             %nO %                                                                             %_O %                                                                             %GO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%b %=J %  Function TextureImage layers a texture onto the background of an image. %u- %  The format of the TextureImage routine is:c %a# %      TextureImage(image,filename)  % + %  A description of each parameter follows:/ % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.m %mK %    o filename: This file contains the texture to layer on the background.u %a %_ */. void TextureImage(Image *image,char *filename) {c8 #define TextureImageText  "  Appling image texture...  "     Imaget     *texture_image;      ImageInfo      texture_info;s     int%     x,     y;  "   assert(image != (Image *) NULL);    if (filename == (char *) NULL)     return;+   /*     Read the texture image.a   */   GetImageInfo(&texture_info);0   (void) strcpy(texture_info.filename,filename);)   texture_image=ReadImage(&texture_info); &   if (texture_image == (Image *) NULL)     return;[   /*+     Tile texture onto the image background.    */4   for (y=0; y < image->rows; y+=texture_image->rows)   {-<     for (x=0; x < image->columns; x+=texture_image->columns)A       CompositeImage(image,ReplaceCompositeOp,texture_image,x,y);%4     ProgressMonitor(TextureImageText,y,image->rows);   }    DestroyImage(texture_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     T h r e s h o l d I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %r: %  Function ThresholdImage thresholds the reference image. % / %  The format of the ThresholdImage routine is:  %d& %      ThresholdImage(image,threshold) % + %  A description of each parameter follows:a %nF %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %eD %    o threshold: A character string indicating the threshold value. %e %h */1 void ThresholdImage(Image *image,char *threshold)n {a8 #define ThresholdImageText  "  Threshold the image...  "  
   ColorPacketU     *colormap;     intn     intensity_threshold;     register int     i;     register RunlengthPacket     *p;N  "   assert(image != (Image *) NULL);!   if (threshold == (char *) NULL)d     return;o   /*     Threshold image.   */&   intensity_threshold=atoi(threshold);9   colormap=(ColorPacket *) malloc(2*sizeof(ColorPacket)); '   if (colormap == (ColorPacket *) NULL)      { E       Warning("Unable to allocate image","Memory allocation failed"); 
       return;      } .   if (image->colormap != (ColorPacket *) NULL)#     free((char *) image->colormap);    image->class=PseudoClass;    image->colors=2;   image->colormap=colormap;x   image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    p=image->pixels;$   for (i=0; i < image->packets; i++)   {%9     p->index=Intensity(*p) < intensity_threshold ? 0 : 1;%     p++;     if (QuantumTick(i,image))i;       ProgressMonitor(ThresholdImageText,i,image->packets);t   }I   SyncImage(image);  }  G /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %iO %                                                                             %NO %                                                                             %eO %   T r a n s f o r m I m a g e                                               %tO %                                                                             %gO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %tL %  Function TransformImage creates a new image that is a transformed size ofE %  of existing one as specified by the crop and image geometries.  ItoK %  allocates the memory necessary for the new Image structure and returns an %  pointer to the new image. %=H %  If a crop geometry is specified a subregion of the image is obtained.M %  If the specified image size, as defined by the image and scale geometries,aK %  is smaller than the actual image size, the image is first minified to aniN %  integral of the specified image size with an antialias digital filter.  TheD %  image is then scaled to the exact specified image size with pixelM %  replication.  If the specified image size is greater than the actual image%J %  size, the image is first enlarged to an integral of the specified imageK %  size with bilinear interpolation.  The image is then scaled to the exact / %  specified image size with pixel replication.  % / %  The format of the TransformImage routine is:  % 9 %      TransformImage(image,crop_geometry,image_geometry)  % + %  A description of each parameter follows:  %gJ %    o image: The address of an address of a structure of type Image.  The7 %      transformed image is returned as this parameter.  % D %    o crop_geometry: Specifies a pointer to a crop geometry string.6 %      This geometry defines a subregion of the image. %eF %    o image_geometry: Specifies a pointer to a image geometry string.K %      The specified width and height of this geometry string are absolute.  %  %  */= Export void TransformImage(Image **image,char *crop_geometry,r   char *image_geometry)a {:   Image      *transformed_image;f     inte
     flags,     x,     y;     unsigned int     height,      sharpen,
     width;  #   assert(image != (Image **) NULL);    transformed_image=(*image);m%   if (crop_geometry != (char *) NULL)      {        Image          *cropped_image;i         RectangleInfog         crop_info;         /*,         Crop image to a user specified size.       */       crop_info.x=0;       crop_info.y=0;       flags=O         XParseGeometry(crop_geometry,&crop_info.x,&crop_info.y,&width,&height);%$       if ((flags & WidthValue) == 0)L         width=(unsigned int) ((int) transformed_image->columns-crop_info.x);%       if ((flags & HeightValue) == 0) J         height=(unsigned int) ((int) transformed_image->rows-crop_info.y);#       if ((flags & XNegative) != 0) 6         crop_info.x+=transformed_image->columns-width;#       if ((flags & YNegative) != 0) 4         crop_info.y+=transformed_image->rows-height;5       if (strchr(crop_geometry,'%') != (char *) NULL) 	         {            /*4             Crop geometry is relative to image size.           */H           (void) ParseImageGeometry(crop_geometry,&x,&y,&width,&height);1           if (width > transformed_image->columns)e-             width=transformed_image->columns;D/           if (height > transformed_image->rows)s+             height=transformed_image->rows;a!           crop_info.x=width >> 1;s"           crop_info.y=height >> 1;1           width=transformed_image->columns-width;F0           height=transformed_image->rows-height;!           flags|=XValue | YValue;i	         }_       crop_info.width=width;       crop_info.height=height;*       if ((width == 0) || (height == 0) ||=           ((flags & XValue) != 0) || ((flags & YValue) != 0)) >         cropped_image=CropImage(transformed_image,&crop_info);
       else	         {e           Imaget             *next_image;             /*8             Crop repeatedly to create uniform subimages.           */$           next_image=(Image *) NULL;'           cropped_image=(Image *) NULL;t;           for (y=0; y < transformed_image->rows; y+=height)o           {m?             for (x=0; x < transformed_image->columns; x+=width) 
             { $               crop_info.width=width;&               crop_info.height=height;               crop_info.x=x;               crop_info.y=y;A               next_image=CropImage(transformed_image,&crop_info);n/               if (next_image == (Image *) NULL)r                 break;2               if (cropped_image == (Image *) NULL))                 cropped_image=next_image;                else                 {o5                   next_image->previous=cropped_image;m1                   cropped_image->next=next_image;s4                   cropped_image=cropped_image->next;                 } 
             }_-             if (next_image == (Image *) NULL)%               break;           }%	         }%*       if (cropped_image != (Image *) NULL)	         { *           DestroyImage(transformed_image);;           while (cropped_image->previous != (Image *) NULL) 2             cropped_image=cropped_image->previous;*           transformed_image=cropped_image;	         }      }    /*)     Scale image to a user specified size.    */#   width=transformed_image->columns; !   height=transformed_image->rows; A   (void) ParseImageGeometry(image_geometry,&x,&y,&width,&height); P   sharpen=(width*height) < (transformed_image->rows*transformed_image->columns);.   if ((transformed_image->columns != width) ||*       (transformed_image->rows != height))     {%       ImageF         *zoomed_image;         /*         Zoom image.y       */L       zoomed_image=ZoomImage(transformed_image,width,height,MitchellFilter);)       if (zoomed_image == (Image *) NULL)b@         zoomed_image=ScaleImage(transformed_image,width,height);)       if (zoomed_image != (Image *) NULL)t	         { *           DestroyImage(transformed_image);)           transformed_image=zoomed_image;r	         }i     }r   if (sharpen)L     if ((transformed_image->columns >= 3) && (transformed_image->rows >= 3))       { 
         Imageg           *sharpened_image;r  
         /*           Sharpen image.
         */F         sharpened_image=SharpenImage(transformed_image,SharpenFactor);.         if (sharpened_image != (Image *) NULL)           { ,             DestroyImage(transformed_image);.             transformed_image=sharpened_image;           }t       }i   *image=transformed_image;s }t a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %uO %                                                                             %(O %     T r a n s f o r m R G B I m a g e                                       % O %                                                                             %+O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%h %*L %  Function TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  the'L %  weights are rescaled to normalized the range of the transformed values to %  be [0..MaxRGB]. % 2 %  The format of the TransformRGBImage routine is: % * %      TransformRGBImage(image,colorspace) % + %  A description of each parameter follows:  %vF %    o image: The address of a structure of type Image;  returned from %      ReadImage.l %oJ %    o colorspace: An unsigned integer value that indicates the colorspaceD %      the image is currently in.  On return the image is in the RGB %      color space.  %g %E */B void TransformRGBImage(Image *image,const unsigned int colorspace) {o #define B (MaxRGB+1)*2 #define G (MaxRGB+1) #define R 0*A #define TransformRGBImageText  "  Transforming image colors...  "e     static QuantumJ     PCDMap[348] =  /* Photo CD information beyond 100% white, Gamma 2.2 */     {oK         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  11,  12,  13,  14, K        15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28, K        29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,\K        43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  55,oK        56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  66,  67,  68, K        69,  70,  71,  72,  73,  74,  75,  76,  76,  77,  78,  79,  80,  81, K        82,  83,  84,  84,  85,  86,  87,  88,  89,  90,  91,  92,  92,  93,gK        94,  95,  96,  97,  98,  99,  99, 100, 101, 102, 103, 104, 105, 106, K       106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 115, 116, 117, 118, K       119, 120, 121, 122, 122, 123, 124, 125, 126, 127, 128, 129, 129, 130,aK       131, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140, 141, 142, 142,nK       143, 144, 145, 146, 147, 148, 148, 149, 150, 151, 152, 153, 153, 154,(K       155, 156, 157, 158, 158, 159, 160, 161, 162, 163, 164, 165, 165, 166,tK       167, 168, 169, 170, 171, 172, 173, 173, 174, 175, 176, 177, 178, 178,)K       179, 180, 181, 182, 182, 183, 184, 185, 186, 186, 187, 188, 189, 190,bK       191, 192, 193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203,rK       204, 205, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 215, K       216, 216, 217, 218, 219, 220, 221, 221, 222, 223, 224, 225, 225, 226,eK       227, 228, 228, 229, 230, 230, 231, 232, 233, 233, 234, 235, 235, 236, K       237, 237, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244,)K       245, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248, 249, 249, 249, K       250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252,;K       253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, K       254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, @       254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255     };     long
     *blue,     *green,%	     *red;%  	   Quantum%     *range_table;L     register int     i,     x,     y,     z;     register Quantum     *range_limit;      register RunlengthPacket     *p;   "   assert(image != (Image *) NULL);H   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace) ||,       (colorspace == TransparentColorspace))     return;    /*     Allocate the tables.   */1   red=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); 3   green=(long *) malloc(3*(MaxRGB+1)*sizeof(long)); 2   blue=(long *) malloc(3*(MaxRGB+1)*sizeof(long));?   range_table=(Quantum *) malloc(4*(MaxRGB+1)*sizeof(Quantum));%;   if ((red == (long *) NULL) || (green == (long *) NULL) ||lC       (blue == (long *) NULL) || (range_table == (Quantum *) NULL))L     {oL       Warning("Unable to transform color space","Memory allocation failed");
       return;r     }o   /*     Initialize tables.   */   for (i=0; i <= MaxRGB; i++)I   {c     range_table[i]=0;f*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;e   }e   for (i=0; i <= MaxRGB; i++);'     range_table[i+(MaxRGB+1)*3]=MaxRGB; %   range_limit=range_table+(MaxRGB+1);u   switch (colorspace)u   {o     case OHTAColorspace:     {a       /*         Initialize OHTA tables:a  &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.*       */!       for (i=0; i <= MaxRGB; i++)        {L&         red[i+R]=UpShifted(1.00000)*i;;         green[i+R]=UpShifted(1.0000*0.5)*((i << 1)-MaxRGB);->         blue[i+R]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);&         red[i+G]=UpShifted(1.00000)*i;         green[i+G]=0;e;         blue[i+G]=UpShifted(1.33333*0.5)*((i << 1)-MaxRGB);m&         red[i+B]=UpShifted(1.00000)*i;?         green[i+B]=(-UpShifted(1.00000*0.5))*((i << 1)-MaxRGB); >         blue[i+B]=(-UpShifted(0.66668*0.5))*((i << 1)-MaxRGB);       })       break;     }=     case XYZColorspace:a     {_       /*"         Initialize CIE XYZ tables:  /           R =  3.240479*R-1.537150*G-0.498535*B%/           G = -0.969256*R+1.875992*G+0.041556*B /           B =  0.055648*R-0.204043*G+1.057311*B        */!       for (i=0; i <= MaxRGB; i++)        { '         red[i+R]=UpShifted(3.240479)*i;t,         green[i+R]=(-UpShifted(1.537150))*i;+         blue[i+R]=(-UpShifted(0.498535))*i; *         red[i+G]=(-UpShifted(0.969256))*i;)         green[i+G]=UpShifted(1.875992)*i; (         blue[i+G]=UpShifted(0.041556)*i;'         red[i+B]=UpShifted(0.055648)*i; ,         green[i+B]=(-UpShifted(0.204043))*i;(         blue[i+B]=UpShifted(1.057311)*i;       }        break;     }      case YCbCrColorspace:      {%       /*          Initialize YCbCr tables:  '           R = Y            +1.370707*Cro'           G = Y-0.336453*Cb-0.698195*Crs           B = Y+1.732445*Cbt  O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0c         through MaxRGB.r       */!       for (i=0; i <= MaxRGB; i++)        {e'         red[i+R]=UpShifted(1.000000)*i;          green[i+R]=0;o<         blue[i+R]=UpShifted(1.370707*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i; @         green[i+G]=(-UpShifted(0.336453*0.5))*((i << 1)-MaxRGB);?         blue[i+G]=(-UpShifted(0.698195*0.5))*((i << 1)-MaxRGB);r'         red[i+B]=UpShifted(1.000000)*i;a=         green[i+B]=UpShifted(1.732445*0.5)*((i << 1)-MaxRGB);          blue[i+B]=0;       }m       break;     }e     case YCCColorspace:s     {.       /*         Initialize YCC tables:  '           R = Y            +1.340762*C2g'           G = Y-0.317038*C1-0.682243*C2n           B = Y+1.632639*C1h  B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++)g       { %         red[i+R]=UpShifted(1.3584)*i;          green[i+R]=0;i5         blue[i+R]=UpShifted(1.8215)*(i-UpScale(137));L%         red[i+G]=UpShifted(1.3584)*i;mA         green[i+G]=(-(UpShifted(0.194*2.2179)*(i-UpScale(156))));=@         blue[i+G]=(-(UpShifted(0.509*1.8215)*(i-UpScale(137))));%         red[i+B]=UpShifted(1.3584)*i;n6         green[i+B]=UpShifted(2.2179)*(i-UpScale(156));         blue[i+B]=0;J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       }h$       for ( ; i < UpScale(348); i++)J         range_table[i+(MaxRGB+1)]=(Quantum) UpScale(PCDMap[DownScale(i)]);       break;     }(     case YIQColorspace:      {m       /*         Initialize YIQ tables:  +           R = 0.97087*Y+1.17782*I+0.59800*Q>+           G = 0.97087*Y-0.28626*I-0.72851*Q-+           B = 0.97087*Y-1.27870*I+1.72801*Q>  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0y         through MaxRGB.e       */!       for (i=0; i <= MaxRGB; i++)m       {m&         red[i+R]=UpShifted(0.97087)*i;<         green[i+R]=UpShifted(1.17782*0.5)*((i << 1)-MaxRGB);;         blue[i+R]=UpShifted(0.59800*0.5)*((i << 1)-MaxRGB); &         red[i+G]=UpShifted(0.97087)*i;?         green[i+G]=(-UpShifted(0.28626*0.5))*((i << 1)-MaxRGB);p>         blue[i+G]=(-UpShifted(0.72851*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(0.97087)*i;?         green[i+B]=(-UpShifted(1.27870*0.5))*((i << 1)-MaxRGB);(;         blue[i+B]=UpShifted(1.72801*0.5)*((i << 1)-MaxRGB);n       }t       break;     }      case YPbPrColorspace:      {        /*          Initialize YPbPr tables:  '           R = Y            +1.402000*C2 '           G = Y-0.344136*C1+0.714136*C2n           B = Y+1.772000*C1=  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.)       */!       for (i=0; i <= MaxRGB; i++)n       {e'         red[i+R]=UpShifted(1.000000)*i;u         green[i+R]=0;t<         blue[i+R]=UpShifted(1.402000*0.5)*((i << 1)-MaxRGB);'         red[i+G]=UpShifted(1.000000)*i; @         green[i+G]=(-UpShifted(0.344136*0.5))*((i << 1)-MaxRGB);<         blue[i+G]=UpShifted(0.714136*0.5)*((i << 1)-MaxRGB);'         red[i+B]=UpShifted(1.000000)*i;)=         green[i+B]=UpShifted(1.772000*0.5)*((i << 1)-MaxRGB);1         blue[i+B]=0;       }        break;     }-     case YUVColorspace:(     default:     {        /*         Initialize YUV tables:  #           R = Y          +1.13980*V #           G = Y-0.39380*U-0.58050*V            B = Y+2.02790*U   M         U and V, normally -0.5 through 0.5, must be normalized to the range 0r         through MaxRGB.n       */!       for (i=0; i <= MaxRGB; i++)        {u&         red[i+R]=UpShifted(1.00000)*i;         green[i+R]=0;n;         blue[i+R]=UpShifted(1.13980*0.5)*((i << 1)-MaxRGB); &         red[i+G]=UpShifted(1.00000)*i;?         green[i+G]=(-UpShifted(0.39380*0.5))*((i << 1)-MaxRGB);e>         blue[i+G]=(-UpShifted(0.58050*0.5))*((i << 1)-MaxRGB);&         red[i+B]=UpShifted(1.00000)*i;<         green[i+B]=UpShifted(2.02790*0.5)*((i << 1)-MaxRGB);         blue[i+B]=0;       }r       break;     }I   }e   /*     Convert to RGB.    */   switch (image->class)a   {o     case DirectClass:c     default:     {e       /*"         Convert DirectClass image.       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {+         x=p->red;e         y=p->green;;         z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];%G         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])]; F         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;!         if (QuantumTick(i,image)) B           ProgressMonitor(TransformRGBImageText,i,image->packets);       }        break;     }      case PseudoClass:      {        /*"         Convert PseudoClass image.       */'       for (i=0; i < image->colors; i++)        { !         x=image->colormap[i].red; #         y=image->colormap[i].green; "         z=image->colormap[i].blue;         image->colormap[i].red=%@           range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];!         image->colormap[i].green=F@           range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];          image->colormap[i].blue=@           range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];       }r       p=image->pixels;(       for (i=0; i < image->packets; i++)       {t         x=p->red;a         y=p->green;          z=p->blue;E         p->red=range_limit[DownShift(red[x+R]+green[y+R]+blue[z+R])];uG         p->green=range_limit[DownShift(red[x+G]+green[y+G]+blue[z+G])];rF         p->blue=range_limit[DownShift(red[x+B]+green[y+B]+blue[z+B])];         p++;       }a       break;     }l   }h   /*     Free allocated memory.   */   free((char *) range_table);v   free((char *) blue);   free((char *) green);    free((char *) red);m }e n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %hO %     T r a n s p a r e n t I m a g e                                         % O %                                                                             % O %                                                                             %uO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_ %cF %  Function TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opaque.  Any pixel; %  that matches the specified color are set to transparent.  %h1 %  The format of the TransparentImage routine is:e %s$ %      TransparentImage(image,color) %f+ %  A description of each parameter follows:  %2F %    o image: The address of a structure of type Image;  returned from %      ReadImage.i %eB %    o color: A character string that contain an X11 color string. %  %e */6 Export void TransparentImage(Image *image,char *color) {p #define DeltaX  16M #define TransparentImageText  "  Setting transparent color in the image...  "x  
   ColorPacket(     target;      register int     i;     register RunlengthPacket     *p;y     unsigned int     status;      XColor     target_color;      /*2     Determine RGB values of the transparent color.   */"   assert(image != (Image *) NULL);2   status=XQueryColorDatabase(color,&target_color);   if (status == False)     return;e*   target.red=XDownScale(target_color.red);.   target.green=XDownScale(target_color.green);,   target.blue=XDownScale(target_color.blue);   /*!     Make image color transparent.x   */   if (!image->matte)     {        /*)         Initialize image matte to opaque.        */       image->class=DirectClass;o       image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=Opaque;         p++;       }m     }c   p=image->pixels;$   for (i=0; i < image->packets; i++)   {%%     if (ColorMatch(*p,target,DeltaX))        p->index=Transparent;      p++;     if (QuantumTick(i,image)) =       ProgressMonitor(TransparentImageText,i,image->packets);    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U n c o m p r e s s I m a g e                                             % O %                                                                             %%O %                                                                             %sO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %fL %  Function UncompressImage uncompresses runlength-encoded pixels packets to! %  a rectangular array of pixels.r %e0 %  The format of the UncompressImage routine is: %d$ %      status=UncompressImage(image) %e+ %  A description of each parameter follows:c %:D %    o status: Function UncompressImage returns True if the image is$ %      uncompressed otherwise False. %l7 %    o image: The address of a structure of type Image.s %c %r */1 Export unsigned int UncompressImage(Image *image)x {    intv     length;o     register int     i,     j;     register RunlengthPacket     *p,s     *q;m     RunlengthPacketo     *uncompressed_pixels;r  "   assert(image != (Image *) NULL);5   if (image->packets == (image->columns*image->rows))s     return(True);r   /*)     Uncompress runlength-encoded packets.t   */I   uncompressed_pixels=(RunlengthPacket *) realloc((char *) image->pixels,a8     image->columns*image->rows*sizeof(RunlengthPacket));6   if (uncompressed_pixels == (RunlengthPacket *) NULL)     { G       Warning("Unable to uncompress image","Memory allocation failed");e       return(False);     }i+   p=uncompressed_pixels+(image->packets-1);)7   q=uncompressed_pixels+(image->columns*image->rows-1);e$   for (i=0; i < image->packets; i++)   {e     length=p->length;      for (j=0; j <= length; j++)      {n       *q=(*p);       q->length=0;
       q--;     }e     p--;   }h,   image->packets=image->columns*image->rows;$   image->pixels=uncompressed_pixels;   return(True);n }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %nO %                                                                             %>O %   Z o o m I m a g e                                                         %dO %                                                                             %mO %                                                                             %CO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u %(E %  Function ZoomImage creates a new image that is a scaled size of aniE %  existing one.  It allocates the memory necessary for the new ImageoL %  structure and returns a pointer to the new image.  The Point filter givesM %  fast pixel replication, Triangle is equivalent to bi-linear interpolation, 7 %  and Mitchel giver slower, very high-quality results.  %f* %  The format of the ZoomImage routine is: % 8 %      zoomed_image=ZoomImage(image,columns,rows,filter) %a+ %  A description of each parameter follows:  % L %    o zoomed_image: Function ZoomImage returns a pointer to the image afterH %      scaling.  A null image is returned if there is a memory shortage. %x7 %    o image: The address of a structure of type Image.) % M %    o columns: An integer that specifies the number of columns in the zoomedg
 %      image.  % G %    o rows: An integer that specifies the number of rows in the scaledg
 %      image.> %gG %    o filter: This unsigned integer is the filter type to used to zoom  %      the image.x %; %  */  - #define ZoomImageText  "  Zooming image...  "i   static double Box(double x)n {    if ((x > -0.5) && (x <= 0.5))      return(1.0);   return(0.0); }     static double Mitchell(double x) {*   double     b,     c;     b=1.0/3.0;   c=1.0/3.0;   if (x < 0)     x=(-x);s   if (x < 1.0)     {sN       x=(((12.0-9.0*b-6.0*c)*(x*x*x))+((-18.0+12.0*b+6.0*c)*x*x)+(6.0-2.0*b))/         6.0;       return(x);     }3
  if (x < 2.0)*    {K      x=(((-1.0*b-6.0*c)*(x*x*x))+((6.0*b+30.0*c)*x*x)+((-12.0*b-48.0*c)*x)+m        (8.0*b+24.0*c))/6.0;m      return(x);     }   return(0.0); }g    static double Triangle(double x) {    if (x < 0.0)     x=(-x);e   if (x < 1.0)     return(1.0-x);   return(0.0); };  N static void HorizontalFilter(Image *source,Image *destination,double x_factor,G   double (*FilterFunction)(double),ContributionInfo *contribution_info, L   Quantum *range_limit,double width,unsigned int span,unsigned int *quantum) {-   double     center,      scale_factor;s     int      n,     x;     long     blue_weight,     green_weight,      index_weight,      red_weight,g     weight;o     register int     i,     j,     y;     register RunlengthPacket     *p,o     *q;e     /*A     Apply filter to zoom horizontally from source to destination.a   */   scale_factor=1.0;=   if (x_factor < 1.0)i     {        width/=x_factor;       scale_factor/=x_factor;)     }f*   for (x=0; x < destination->columns; x++)   {;     n=0;%     center=(double) (x+0.5)/x_factor; G     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)      {y
       j=i;       if (j < 0)         j=(-j); 
       else!         if (j >= source->columns);'           j=(source->columns << 1)-j-1;7       if (j >= source->columns)_         j=0;#       contribution_info[n].pixel=j;+"       contribution_info[n].weight=L         UpShifted(FilterFunction((i-center+0.5)/scale_factor)/scale_factor);
       n++;     }l     q=destination->pixels+x;)     for (y=0; y < destination->rows; y++))     {        blue_weight=0;       green_weight=0;        red_weight=0;e       index_weight=0;        for (i=0; i < n; i++)d       {a+         weight=contribution_info[i].weight;tH         p=source->pixels+(y*source->columns)+contribution_info[i].pixel;"         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       }i0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];)       if (index_weight > UpShift(Opaque))          q->index=Opaque;
       else0         if (index_weight < UpShift(Transparent))           q->index=Transparent;s         else+           q->index=DownShift(index_weight);g       q->length=0;       q+=destination->columns;     }i1     ProgressMonitor(ZoomImageText,*quantum,span);      (*quantum)++;(   }y }g  L static void VerticalFilter(Image *source,Image *destination,double y_factor,G   double (*FilterFunction)(double),ContributionInfo *contribution_info,(L   Quantum *range_limit,double width,unsigned int span,unsigned int *quantum) {    double     center,%     scale_factor;%     int%     n,     y;     long     blue_weight,     green_weight,      index_weight,      red_weight,      weight;      register int     i,     j,     x;     register RunlengthPacket     *p,      *q;      /*?     Apply filter to zoom vertically from source to destination.    */   scale_factor=1.0;    if (y_factor < 1.0)      {        width/=y_factor;       scale_factor/=y_factor;      }    q=destination->pixels;'   for (y=0; y < destination->rows; y++)    {      n=0;%     center=(double) (y+0.5)/y_factor;%G     for (i=(int) (center-width+0.5); i < (int) (center+width+0.5); i++)%     { 
       j=i;       if (j < 0)         j=(-j);t
       else         if (j >= source->rows)$           j=(source->rows << 1)-j-1;       if (j >= source->rows)         j=0;#       contribution_info[n].pixel=j;a"       contribution_info[n].weight=L         UpShifted(FilterFunction((i-center+0.5)/scale_factor)/scale_factor);
       n++;     }d,     for (x=0; x < destination->columns; x++)     {g       blue_weight=0;       green_weight=0;.       red_weight=0;d       index_weight=0;,       for (i=0; i < n; i++)        {m+         weight=contribution_info[i].weight;eH         p=source->pixels+(contribution_info[i].pixel*source->columns)+x;"         red_weight+=weight*p->red;&         green_weight+=weight*p->green;$         blue_weight+=weight*p->blue;&         index_weight+=weight*p->index;       }c0       q->red=range_limit[DownShift(red_weight)];4       q->green=range_limit[DownShift(green_weight)];2       q->blue=range_limit[DownShift(blue_weight)];)       if (index_weight > UpShift(Opaque))h         q->index=Opaque;
       else0         if (index_weight < UpShift(Transparent))           q->index=Transparent;g         else+           q->index=DownShift(index_weight);        q->length=0;
       q++;     }r1     ProgressMonitor(ZoomImageText,*quantum,span);-     (*quantum)++;    }  }   @ Export Image *ZoomImage(Image *image,const unsigned int columns,2   const unsigned int rows,const FilterType filter) {>   ContributionInfo     *contribution_info;u     double     (*FilterFunction)(double),     filter_width,x
     width,
     x_factor, 
     y_factor;;     Image      *source_image,     *zoomed_image;  	   Quantuma     *range_table;P     register int      i;/     register Quantum     *range_limit;%     unsigned int     quantum,	     span;r  "   assert(image != (Image *) NULL);$   if ((columns == 0) || (rows == 0))     {rB       Warning("Unable to zoom image","image dimensions are zero");       return((Image *) NULL);      }*   /*     Image must be uncompressed.%   */   if (!UncompressImage(image))     return((Image *) NULL);    /*'     Initialize zoomed image attributes.    */3   zoomed_image=CopyImage(image,columns,rows,False); %   if (zoomed_image == (Image *) NULL)      { A       Warning("Unable to zoom image","Memory allocation failed");        return((Image *) NULL);      } "   zoomed_image->class=DirectClass;   image->orphan=True; (   if (zoomed_image->rows >= image->rows)J     source_image=CopyImage(image,zoomed_image->columns,image->rows,False);   elseJ     source_image=CopyImage(image,image->columns,zoomed_image->rows,False);   image->orphan=False;%   if (source_image == (Image *) NULL)a     {eA       Warning("Unable to zoom image","Memory allocation failed");.!       DestroyImage(zoomed_image);m       return((Image *) NULL);g     }g   /*     Allocate the range table.    */?   range_table=(Quantum *) malloc(3*(MaxRGB+1)*sizeof(Quantum));i&   if (range_table == (Quantum *) NULL)     { A       Warning("Unable to zoom image","Memory allocation failed");o!       DestroyImage(source_image); !       DestroyImage(zoomed_image);s       return((Image *) NULL);a     }h   /*"     Pre-compute conversion tables.   */   for (i=0; i <= MaxRGB; i++)e   {y     range_table[i]=0;m*     range_table[i+(MaxRGB+1)]=(Quantum) i;'     range_table[i+(MaxRGB+1)*2]=MaxRGB;a   }h%   range_limit=range_table+(MaxRGB+1);o   /*     Allocate filter info list.   */   switch (filter)    {      case BoxFilter:n     {        FilterFunction=Box;        filter_width=0.5;e       break;     }i     case TriangleFilter:     {        FilterFunction=Triangle;       filter_width=1.0;        break;     }u     case MitchellFilter:     default:     {(       FilterFunction=Mitchell;       filter_width=2.0;e       break;     }a   }tB   x_factor=(double) zoomed_image->columns/(double) image->columns;<   y_factor=(double) zoomed_image->rows/(double) image->rows;9   width=Max(filter_width/x_factor,filter_width/y_factor);c   if (width < filter_width)t     width=filter_width;u(   contribution_info=(ContributionInfo *)7     malloc((int) (width*2+1)*sizeof(ContributionInfo));c5   if (contribution_info == (ContributionInfo *) NULL)      {gA       Warning("Unable to zoom image","Memory allocation failed");n!       free((char *) range_table); !       DestroyImage(source_image);i!       DestroyImage(zoomed_image);        return((Image *) NULL);=     }    /*     Zoom image.    */   quantum=0;(   if (zoomed_image->rows >= image->rows)     { 4       span=source_image->columns+zoomed_image->rows;B       HorizontalFilter(image,source_image,x_factor,FilterFunction,B         contribution_info,range_limit,filter_width,span,&quantum);G       VerticalFilter(source_image,zoomed_image,y_factor,FilterFunction, B         contribution_info,range_limit,filter_width,span,&quantum);     })   else     {i7       span=zoomed_image->columns+source_image->columns;e@       VerticalFilter(image,source_image,y_factor,FilterFunction,B         contribution_info,range_limit,filter_width,span,&quantum);I       HorizontalFilter(source_image,zoomed_image,x_factor,FilterFunction,yB         contribution_info,range_limit,filter_width,span,&quantum);     }o   /*     Free allocated memory.   */#   free((char *) contribution_info);r   free((char *) range_table);    DestroyImage(source_image);I   return(zoomed_image);; } 