 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %               M   M   OOO   N   N  IIIII  TTTTT   OOO   RRRR                % O %               MM MM  O   O  NN  N    I      T    O   O  R   R               % O %               M M M  O   O  N N N    I      T    O   O  RRRR                % O %               M   M  O   O  N  NN    I      T    O   O  R R                 % O %               M   M   OOO   N   N  IIIII    T     OOO   R  R                % O %                                                                             % O %                                                                             % O %                    ImageMagick Progress Monitor Routines                    % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                               December 1995                                 % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"      /*   Global declarations. */ static MonitorHandler *   monitor_handler = (MonitorHandler) NULL;   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   P r o g r e s s M o n i t o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ProgressMonitor calls the monitor handler routines with a text> %  string that describes the task and a measure of completion. % ( %  The format of the Monitor routine is: % ) %      ProgressMonitor(text,quantum,span)  % + %  A description of each parameter follows:  % O %    o quantum: Specifies the quantum position within the span which represents < %      how much progress has been made in completing a task. % > %    o span: Specifies the span relative to completing a task. %  %  */B Export void ProgressMonitor(char *text,const unsigned int quantum,   const unsigned int span) {  #if defined(macintosh)
   static char      *mark = (char *) NULL;  
   EventRecord 
     event;  1   while (WaitNextEvent(everyEvent,&event,0L,nil))       SIOUXHandleOneEvent(&event);-   if (isatty(STDIN_FILENO) && (text != mark))      {        puts(text);        mark=text;     }  #endif/   if (monitor_handler != (MonitorHandler) NULL) *     (*monitor_handler)(text,quantum,span); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   S e t M o n i t o r H a n d l e r                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function SetMonitorHandler sets the monitor handler to the specified routine , %  and returns the previous monitor handler. % 2 %  The format of the SetMonitorHandler routine is: % 2 %      previous_handler=SetMonitorHandler(handler) % + %  A description of each parameter follows:  % D %    o handler: Specifies a pointer to a routine to handle monitors. %  %  */? Export MonitorHandler SetMonitorHandler(MonitorHandler handler)  {    MonitorHandler     previous_handler;   #   previous_handler=monitor_handler;    monitor_handler=handler;   return(previous_handler);  } 