/* hash.c: TCL hash table routines
**
** Written and copyright (C) 1996 by Michael J. Gourlay
**
** PROVIDED AS IS.  NO WARRENTIES, EXPRESS OR IMPLIED.
*/

#include <stdio.h>
#include <stdlib.h>

#include <tcl.h>
#include <tk.h>

#include "hash.h"




#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif



/* createTag: create a unique "tag" (i.e. TCL name) for a piece of data
** This tag is a string which can be refered to within TCL scripts.
** The tag is associated with a pointer to the data.  The tag-pointer
** tuple is stored in a hash table which is searched using the tag.
**
** dataP: (in) pointer to the data sturcture instance
** tag: (out) tag of the data sturcture instance
** template: (in) base name of the data structure tag
** initP: (in/out) address of the flag indicating if hash table is initialized
**
*/
void
createTag(const void *dataP, char *tag, const char *template, int *initP, Tcl_HashTable* tableP)
{
  long int data_number = 1;  /* data structure identifier */
  int new_entryF;            /* flag returned by Tcl_CreateHashEntry */
  Tcl_HashEntry *entryP;     /* hash table entry */

  /* ---- First make sure the hash table is ready... */
  if(! *initP) {
    Tcl_InitHashTable(tableP, TCL_STRING_KEYS);
    *initP = TRUE;
  }

  /* Loop until we find an unused tag */
  do {
    /* ---- Create a new image tag for this data. */
    sprintf(tag, "%s%03lx", template, data_number);
    data_number ++;

    /* ---- Create a new hash table entry. */
    entryP = Tcl_CreateHashEntry(tableP, tag, &new_entryF);
  } while(!new_entryF);

  /* ---- Register the image in the hash table. */
  Tcl_SetHashValue(entryP, dataP);
}
