) A privileged user adds an entry in [1,3]JUMP.DAT in the	&
	!    following format:   proj,prog:proj2:pass			&
	!       where proj,prog is the account from which the process	&
	!       must be inititated (called the master account),		&
	!	proj2 is the project within which the user can JUMP	&
	!	freely (called the permission project) ,and		&
	!	pass is the password needed by the user.		&
	!(2) The user signs in to the master account 			&
	!(3) To jump to an account in the permission project, the user	&
	!    need only specify the programmer number.			&
	!(4) The first use of the program requires the password.  	&
	!    Thereafter, the user may continue to JUMP within the 	&
	!    permission account as long as he has the same job number.	&
	!								&
	!    This option works by creating a file [1,3]J2MPnn.TMP	&
	!(where nn is the job number).  The file contains the permission&
	!project.  It is created on the first use of the option (after	&
	!the correct password is given).  LOGIN should be modified to	&
	!delete this file, as with the privileged option.		&
	!								&
	!    Note that the master account need not be in the permission	&
	!project.  Note also that the password need not be the password	&
	!to the master account.						&
	!
27	!								&
	!***************************************************************&
	!***************************************************************&
	!								&
	!                      W A R N I N G				&
	!								&
	!    This program operates by creating files in [1,3] with      &
	!names of the form JUMPnn.TMP or J2MPnn.TMP, where nn is the    &
	!job number of the user.  It is the existence of these files    &
	!which allows the JUMPing to work.  If the files are not        &
	!deleted, the next user who gets that job number will have the  &
	!privilege of JUMPing.  The JUMP END option will delete these   &
	!files, but I recommend modifying LOGIN to delete them before   &
	!signing the user into an account.  (It is easier to modify     &
	!LOGOUT but people can be signed out by too many other means    &
	!(like UT KILL) to trust it.  To the best of my knowledge, a    &
	!modification to LOGIN is sufficient security, but I don't      &
	!guarantee anything.						&
	!								&
	!***************************************************************&
	!***************************************************************&
	!
28	!								&
	!some "global" variables:					&
	!								&
	!    JUMP$	the priveleged case permission file		&
	!    J2MP$	the single project permission file		&
	!    ARG$	although it starts out as the argument given by	&
	!		the user, for most of the program it is that	&
	!		argument converted to upper case with spaces	&
	!		removed (and the other conversions).  In the	&
	!		case of double arguments (like in JUMP 8,1 END)	&
	!		ARG$ will start as the whole argument but will	&
	!		later have the second argument chopped off	&
	!    ARG1$	the first character of ARG$			&
	!
80	Z$ = SYS(CHR$(6%)+CHR$(-7%))		!^C trap
90	ON ERROR GOTO 9000
100	!								&
	!Preliminaries							&
	!
110	GOSUB 1000
200	!								&
	!get argument from core common (if there)			&
	!
210	Z$ = SYS(CHR$(7%)) \ &
	Z$ = CVT$$(Z$,-1%)
220	ARG$ = RIGHT(Z$,5%) \ &
	ARG1$ = LEFT(ARG$,1%)
300	!								&
	!get some background data					&
	!
310	JDB% = PEEK(520%) \ &
	PPN% = PEEK( PEEK( JDB% + 8% ) + 24% ) \ &
	PROJ% = SWAP%(PPN%) AND 255% \ &
	PROG% = PPN% AND 255% &
	!see description of monitor tables, for example [1,21]MONITO.DOC
320	JOB% = (PEEK(518%) AND 255%) / 2% &
	!ditto
330	JOB$ = NUM1$(JOB%) \ &
	IF LEN(JOB$) = 1% THEN JOB$ = "0" + JOB$
340	JUMP$ = "[1,3]JUMP" + JOB$ + ".TMP" \ &
	J2MP$ = "[1,3]J2MP" + JOB$ + ".TMP" &
	!These files are used a lot.  They are the permission files for &
	!the privileged and single project cases (respectively)
400	!								&
	!get the argument.  (failure to specify argument is only	&
	!allowed for the original use)					&
	!
410	IF	PROJ% = 1%	&
	AND	ARG$ = ""	&
	THEN	PRINT "Account to jump to";JUMP  BAS[.050020]JUMP  .BAS[.050015]            	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~@g  g      h  < i  | o  < m  < 4p  < p  < k  | Zn  < l   fr   r    w    x  < x  < x  < x    ޺  <     w   @]   @   @    f    j    n    r          ]            Z                     e   @   @  | >     | 
    |     v  < H       | 	 	   | 	 	   | x z   | 
	 	   | z      t   f   r
  
  
 < 
  &    ^  @& @' */  V,   "? Lh   :h   m   Bm    z | z  {  x  `y ~ | f  N |@@ |@͂ |@
  ݃ ƃ < n s   <     | Ŏ 	   |  ️   | e p   | u    |  -    @ 率    |   < ﾲ 2      ֻ   r    |  |    Z      R M           |               n t     B | x  y  v  Zw | J= | R> | J?   
 n   n    a   a  | b    d    d  f  
	!see RSTS programming manual &
	!any error will cause a resume at 2800
2730	S0% = Z%(27%) + SWAP%(Z%(28%))
2740	IF	(S0% AND 1024%) = 0% &
	THEN	GOTO 2800 &
	ELSE	TOPROJ% = Z%(6%) \ &
		TOPROG% = Z%(5%) \ &
		PRINTFLAG% = TRUE% \ &
		GOSUB 3000
2800	!								&
	!must be a LOGIN logical (or garbage)				&
	!
2801	!PRINT "Looking for LOGIN logical" 
2810	GOSUB 12000
2820	IF	ARG$ = "?" &
	THEN	PRINT BELL$;"Illegal argument." \ &
		GOTO 32700 &
		!if there is no such logical, then argument must be in	&
		!error.
2830	PRINTFLAG% = TRUE% 
2840	GOSUB 3000
2990	RETURN
3000	!								&
	!								&
	!	SUBROUTINE: General privileged use			&
	!								&
	!
3010	!								&
	!By the time this subroutine is reached, TOPROJ% and TOPROG%	&
	!will have already been set.  BACK is handled elsewhere.  If	&
	!argument was a logical, it has been translated	to an account	&
	!number.  This option has END built in (so that the possibility &
	!of creating and deleting the same file is avoided.)		&
	!
3100	!								&
	!if this account is privileged then skip the part where we	&
	!look for the permission file.					&
	!
3110	IF PROJ% = 1% THEN 3300
3200	!								&
	!look for the permission file.  If not there, die.  If there	&
	!skip by the creation of permission file.			&
	!
3210	OPEN JUMP$ FOR INPUT AS FILE #1% &
	!if not there error routine resumes at 3700
3220	GOTO 3500
3300	!								&
	!create the permission file (this is bypassed if not in a	&
	!privileged account.  If there was an END in the argument, we	&
	!don't create it.
3310	IF ENDFLAG% = TRUE% THEN GOTO 3500
3320	OPEN JUMP$ FOR OUTPUT AS FILE #1%
3330	PRINT #1%, PROJ%;",";PROG%
3340	CLOSE #1%
3350	GOTO 3500	!don't kill the file just created
3400	!								&
	!if there was an END in the argument, delete the permission	&
	!file.								&
	!
3410	KILL JUMP$ &
	!if not there, resume at 3500
3500	!								&
	!delete any ????nn.TMP files					&
	!
3510	GOSUB 11000
3600	!								&
	!do the login							&
	!
3610	GOSUB 10000
3620	GOTO 32700
3700	!								&
	!invalid use							&
	!
3710	PRINT BELL$;"Invalid use."
3720	GOTO 32700
3990	RETURN
4000	!								&
	!								&
	!	SUBROUTINE: General project use				&
	!								&
	!
4010	!								&
	!If there was an END, the appropriate subroutine call is 	&
	!included here.							&
	!
4100	!								&
	!look for permission file					&
	!
4110	OPEN J2MP$ FOR INPUT AS FILE #1% &
	!If not there, error routine resumes at 4200
4120	INPUT #1%, PERMISSION%
4130	IF	PERMISSION% <> TOPROJ% &
	THEN	PRINT BELL$;"Wrong project." \ &
		GOTO 32700 &
		!file is there, but wrong project.
4140	GOTO 4400	!since file is there and has right project
4200	!								&
	!permission file not there.  Look in !JUMP.DAT to see if they	&
	!are allowed to use this.  If so, ask for password and create	&
	!the file.  If not, die.					&
	!
4210	GOSUB 13000 &
	!if they are allowed to use this option, the subroutine will 	&
	!set TOPROJ% (which could be different from current project)	&
	!If use is not legal, program will terminate.
4400	!								&
	!permission file was there (or just created)			&
	!if END was there, get rid of files				&
	!
4410	IF ENDFLAG% = TRUE% THEN GOSUB 5000
4500	!								&
	!delete the ????nn.TMP files					&
	!
4510	GOSUB 11000
4600	!								&
	!do the login and logout					&
	!
4610	PRINTFLAG% = TRUE%
4620	GOSUB 10000
4990	RETURN
5000	!								&
	!								&
	!	SUBROUTINE: END command					&
	!								&
	!
5010	!								&
	!This option may be used by itself or with another argument. 	&
	!If another argument was given, it will have already been 	&
	!processed by now.  This single argument is designed for ending	&
	!both types of operation:  privileged and single project.	&
	!
5100	!								&
	!Kill the privileged jump file if there				&
	!
5110	KILL JUMP$ &
	!If not there error routine resumes at 5200
5200	!								&
	!Kill the single project jump file if there			&
	!
5210	KILL J2MP$ &
	!If not there error routine resumes at 5300
5300	!	JUMP  BAS[.050020]JUMP  .BAS[.050015]            	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~@g  g      h  < i  | o  < m  < 4p  < p  < k  | Zn  < l   fr   r    w    x  < x  < x  < x    ޺  <     w   @]   @   @    f    j    n    r          ]            Z                     e   @   @  | >     | 
    |     v  < H       | 	 	   | 	 	   | x z   | 
	 	   | z      t   f   r
  
  
 < 
  &    ^  @& @' */  V,   "? Lh   :h   m   Bm    z | z  {  x  `y ~ | f  N |@@ |@͂ |@
  ݃ ƃ < n s   <     | Ŏ 	   |  ️   | e p   | u    |  -    @ 率    |   < ﾲ 2      ֻ   r    |  |    Z      R M           |               n t     B | x  y  v  Zw | J= | R> | J?   
 n   n    a   a  | b    d    d  f  11 THEN RESUME 32700 &
	!^Z 
9900	!								&
	!Unexpected errors						&
	!
9910	Z$ = SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR))
9920	ERROR$ = RIGHT(Z$,4%)
9930	PRINT "	I can't cope with a "; \ &
	PRINT ERROR$; " at line";ERL
9990	GOTO 32700
10000	!								&
	!								&
	!	SUBROUTINE: logout and login				&
	!								&
	!
10010	SENDER.PPN% = PEEK(PEEK(PEEK(520%) + 8%) + 24%) &
	\ SENDER.Z$ = SYS(CHR$(6%)! SYS call to FIP &
 	+ CHR$(22%) &
	+ CHR$(-1%) &
	+ CHR$(0%) &
	+ 'EMTLOG' &
	+ STRING$(10%,0%) &
	+ CHR$(21%) &
	+ CHR$(20%) &
	+ CHR$(SWAP%(SENDER.PPN%) AND 255%) &
	+ CHR$(SENDER.PPN% AND 255%) &
	+ CHR$(213%) &
	+ CHR$(65%) &
	+ CHR$(0%) &
	+ CHR$(100%) &
	+ CHR$(TOPROJ%) &
	+ CHR$(TOPROG%)) &

10020	SLEEP 2% &

10100	!								&
	!look up the password (see RSTS programming manual for an	&
	!explanation).							&
	!
10110	Z$ = CHR$(6%) + CHR$(14%) + STRING$(4%,0%) + CHR$(TOPROG%) 	&
	   + CHR$(TOPROJ%)
10120	CHANGE SYS(Z$) TO Z% \ &
	PASS$ = RAD$( Z%( 9%) + SWAP%( Z%(10%) ) ) &
	      + RAD$( Z%(11%) + SWAP%( Z%(12%) ) )
10130	IF	INSTR(1%,PASS$,"?") &
	THEN	PRINT "You can't JUMP to an account with no password." \ &
		GOTO 32767
10140	GOTO 10300	!skip error handling
10200	!								&
	!No such account						&
	!
10210	PRINT BELL$;"No such account." 
10220	GOTO 32700
10300	!								&
	!using results of SYS call above, set up for login call	(see	&
	!RSTS programming manual again.)				&
	!
10310	Z%(7%+I%) = Z%(9%+I%)	FOR I% = 0% TO 3%
10320	Z%(5%) = TOPROG% \ &
	Z%(6%) = TOPROJ%
10325	T$ = CVT%$(SWAP%(0%+2%)) \ &
	T1% = ASCII(LEFT(T$,1%)) \ &
	T2% = ASCII(RIGHT(T$,2%))
10330	Z%(1%) = 6% \ &
	Z%(2%) = 4% \ &
	Z%(3%) = 0% \ &
	Z%(4%) = 0%
10340	Z%(I%) = 0%	FOR I% = 11% TO 30%
10400	!								&
	!Logout								&
	!
10410	Z$ = SYS( CHR$(6%) + CHR$(5%) )					&
	!try logging out with a quota check first
10420	LOGOUT.STATUS% = SWAP%( ASCII(MID(Z$,3%,1%)) ) + ASCII(MID(Z$,4%,1%))
10430	IF LOGOUT.STATUS% = 0% THEN GOTO 10500				&
	!if successful, skip the rest
10440	IF	LOGOUT.STATUS% = -1%					&
	AND	ASCII(MID(Z$,13%,1%)) = 1%				&
	THEN	PRINT BELL$;"You are unable to JUMP because your detached job quota is exceeded." \ &
		PRINT "Program terminated." \ &
		GOTO 32767
10450	IF	LOGOUT.STATUS% = -1%					&
	AND	ASCII(MID(Z$,13%,1%)) = 0%				&
	THEN	PRINT BELL$;"Your quota is exceeded.  You have been signed out anyway."
10460	Z$ = SYS( CHR$(6%) + CHR$(5%) + CVT%$(SWAP%(0%+2%)))		&
	!do it without without quota checks
10500	!								&
	!Login								&
	!
10510	CHANGE Z% TO Z$
10520	Z$ = SYS(Z$) \ &
	GOTO 10600
	!if error, resume at 10530
10530	PRINT "You can't jump to an account which has no password."
10540	GOTO 32767
10600	!								&
	!print message if desired					&
	!
10610	IF	PRINTFLAG% = TRUE% &
	THEN	PRINT "Jumping to account ["; \ &
		PRINT NUM1$(TOPROJ%); \ &
		PRINT ","; \ &
		PRINT NUM1$(TOPROG%); \ &
		PRINT "]." 
10990	RETURN
11000	!								&
	!								&
	!	SUBROUTINE: delete temporary files			&
	!								&
	!
11100	!								&
	!If account is [1,3] we can't kill all temporary files or we	&
	!will kill the permission file.  In this case we will just	&
	!delete TEMPnn.TMP						&
	!
11110	IF	PROJ% = 1% &
	AND	PROG% = 3% &
	THEN	KILLFILE$ = "TEMP" + JOB$ + ".TMP" \ &
		KILL KILLFILE$ \ &
		RETURN &
		!if file not there, error routine will resume at the &
		!return statement anyway
11200	!								&
	!Use File Name String Scan to convert name to form needed later	&
	!(See RSTS Programming Manual).  This only needs to be done	&
	!once, even if several files get deleted.			&
	!
11210	KILLFILE$ = "????" + JOB$ + ".TMP"
11220	CHANGE SYS( CHR$(6%) + CHR$(-10%) + KILLFILE$ ) TO Z%
11300	!								&
	!Set up for directory sys call (See RSTS Programming Manual	&
	!again)								&
	!
11310	Z%(1%) =  6% \ &
	Z%(2%) = 17% \ &
	Z%(3%) =  0% \ &
	Z%(4%) =  0%
11320	CHANGE Z% TO Z$
11400	!								&
	!This loop keeps killing files till it runs out			&
	!
11410	CHANGE SYS(Z$) TO Z% &
	!if no more files, error routine resJUMP  BAS[.050020]JUMP  .BAS[.050015]            	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~@g  g      h  < i  | o  < m  < 4p  < p  < k  | Zn  < l   fr   r    w    x  < x  < x  < x    ޺  <     w   @]   @   @    f    j    n    r          ]            Z                     e   @   @  | >     | 
    |     v  < H       | 	 	   | 	 	   | x z   | 
	 	   | z      t   f   r
  
  
 < 
  &    ^  @& @' */  V,   "? Lh   :h   m   Bm    z | z  {  x  `y ~ | f  N |@@ |@͂ |@
  ݃ ƃ < n s   <     | Ŏ 	   |  ️   | e p   | u    |  -    @ 率    |   < ﾲ 2      ֻ   r    |  |    Z      R M           |               n t     B | x  y  v  Zw | J= | R> | J?   
 n   n    a   a  | b    d    d  f  umes at 11990
11420	FILE$ = RAD$( Z%( 7%) + SWAP%( Z%( 8%) ) ) 		&
	      + RAD$( Z%( 9%) + SWAP%( Z%(10%) ) ) + "." 	&
	      + RAD$( Z%(11%) + SWAP%( Z%(12%) ) )
11430	KILL FILE$
11440	GOTO 11300
11990	RETURN
12000	!								&
	!								&
	!	SUBROUTINE: look up account logicals			&
	!								&
	!
12100	!								&
	!open the file							&
	!
12110	OPEN "$LOGIN.DAT" AS FILE #1%
12200	!								&
	!look for logical equal to argument				&
	!
12210	INPUTLINE #1%, IN$ \ &
	IN$ = CVT$$(IN$,-1%) &
	!end of file will cause resume to 12300
12220	EQUAL% = INSTR(1%,IN$,"=")
12230	LOGICAL$ = LEFT(IN$,EQUAL%-1%)
12240	IF CVT$$(LOGICAL$,-1%) = CVT$$(ARG$,-1%) THEN GOTO 12400
12250	GOTO 12210
12300	!								&
	!didn't find it (end of file error resumes here)		&
	!
12310	ARG$ = "?"
12320	RETURN
12400	!								&
	!found it.  Part to right of = is PPN (and maybe some junk)	&
	!
12401	!PRINT "Found logical: " ARG$ 
12410	ARG$ = RIGHT(IN$,EQUAL% + 1%)
12500	!								&
	!look for ;.  If there get rid of it and all following		&
	!
12510	J% = INSTR(1%,ARG$,";")
12520	IF	J% <> 0% &
	THEN	ARG$ = LEFT(ARG$,J%-1%)
12521	!PRINT "after ; argument is ";ARG$ 
12600	!								&
	!may have / or ,.  Either way we want TOPROJ% to be the left	&
	!part and TOPROG% to be the right part.  We will assume that	&
	!the data in the file is correct (so that TOPROJ% and TOPROG%	&
	!must be legal numbers)						&
	!
12610	J% = INSTR(1%,ARG$,",")
12620	IF	J% = 0% &
	THEN	J% = INSTR(1%,ARG$,"/") &
		!we assume that one of them is there
12621	!PRINT "Position of , or / is"; J% \ &
	!PRINT "Argument is now "; ARG$
12630	TOPROJ% = VAL(  LEFT(ARG$,J%-1%) ) \ &
	TOPROG% = VAL( RIGHT(ARG$,J%+1%) ) \ &
	GOTO 12990
12640	PRINT "Can't interpret entry in $LOGIN.DAT" \ &
	PRINT "Program terminated." \ &
	GOTO 32767
12990	RETURN
13000	!								&
	!								&
	!	SUBROUTINE: First time project use			&
	!								&
	!
13100	!								&
	!Look in !JUMP.DAT for their account				&
	!(We assume that the data file is in the correct form)		&
	!
13101	!PRINT "first fime project use" 
13110	OPEN "[1,3]JUMP.DAT" AS FILE #1%
13120	INPUTLINE #1%, IN$ \ &
	IN$ = CVT$$(IN$,-1%) &
	!if end-of-file then error routine resumes at 13200
13130	J% = INSTR(1%,IN$,",") \ &
	MASTERPROJ% = VAL(LEFT(IN$,J%-1%)) \ &
	IN$ = RIGHT(IN$,J%+1%)
13140	J% = INSTR(1%,IN$,":") \ &
	MASTERPROG% = VAL(LEFT(IN$,J%-1%)) \ &
	IN$ = RIGHT(IN$,J%+1%)
13141	!PRINT MASTERPROJ%,MASTERPROG%	
13150	IF	MASTERPROJ% <> PROJ% &
	OR	MASTERPROG% <> PROG% &
	THEN	GOTO 13120 &
		!keep looking for this account
13160	CLOSE #1%
13170	GOTO 13300
13200	!								&
	!wasn't found							&
	!
13210	PRINT BELL$; "You are not in the correct account."  \ &
	GOTO 32700
13300	!								&
	!was found: find permision project and password			&
	!
13310	J% = INSTR(1%,IN$,":") \ &
	TOPROJ% = VAL( LEFT(IN$,J%-1%) ) \ &
	PASSWORD$ = CVT$$( RIGHT(IN$,J%+1%),32% )
13400	!								&
	!Check the password						&
	!
13410	Z$ = SYS(CHR$(3%))	!cancel echo, of course
13420	INPUT "Password";USERPASS$ \ &
	USERPASS$ = CVT$$(USERPASS$,-1%) \ &
	PRINT 
13430	Z$ = SYS(CHR$(2%))	!reinstate echo
13440	IF USERPASS$ = PASSWORD$ THEN 13600
13500	!								&
	!password was wrong						&
	!
13510	PRINT BELL$; "Incorrect password." 
13520	GOTO 32700
13600	!								&
	!password was right, set up file				&
	!
13610	OPEN J2MP$ FOR OUTPUT AS FILE #1%
13620	PRINT #1%, TOPROJ%
13630	CLOSE #1%
13990	RETURN
32700	!								&
	!end of program							&
	!
32710	Z$ = SYS(CHR$(9%))	!Exit and clear program
32767	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          