
	!								&

1010	SLEEP.TIME% = 600%						&
	!	Set the initial value of SLEEP.TIME% to 600.		&
	!	    	600 seconds is ten minutes.			&
	!	Later in the program this value will change if the	&
	!	next alarm time will occur in less than 600 seconds.	&

1020	OPEN "ALARM.VIR [1,2]" FOR INPUT AS FILE #1%		     \  &
	CLOSE #1%							&
	!	Open the file for input to see if it exists.		&

1030	IF NOT.FOUND%							&
	   THEN								&
		GOTO 1300						&
	!  Sleep 10 minutes if the file can not be found.		&
	!	When someone needs the alarm they will run		&
	!	ALARM and the file will then be created.		&

1040	FOR POINTER% = 1% TO NUM.OF.PLACES%				&

1050	    OPEN "[1,2] ALARM.VIR" AS FILE #1%			     \  &
	    G.TIME$ = ALARMTIM2$(POINTER%)			     \  &
	    CLOSE #1%							&
	    !	Get the given time from the array file.			&

1070	    IF G.TIME$ = ""						&
	       THEN							&
		    GOTO 1250						&
	    !	If G.TIME$ is blank then look at the next given time.	&

1080	    G.TIME% = FNCVT%(G.TIME$)					&
	    !	Convert the given time into minutes since midnight.	&

1100	    COMP.TIME% = TIME(0%) / 60%					&
	    !	Convert the computer time into minutes since midnight.	&

1120	  IF COMP.TIME% >= G.TIME% AND COMP.TIME%-10% <= G.TIME%	&
	     THEN							&
		  Z% = FNALARM%(POINTER%)  \  GOTO 1250			&
	    !  If it is time to alarm it extecutes the ALARM FUNCTION.	&
	    !  After executing the alarm look at the next given time.	&

1140	    GOSUB 3000							&
	    !	This subroutine looks ten minutes into the future,	&
	    !	checking to see if this setting should be executed	&
	    !	within the next ten minutes.				&

1200	    IF TEMP.SLEEP.TIME% > 0%					&
	         AND							&
	       TEMP.SLEEP.TIME% < SLEEP.TIME%				&
	         THEN							&
		    SLEEP.TIME% = TEMP.SLEEP.TIME%			&

1250	NEXT POINTER%							&

1270	IF SLEEP.TIME% = 0%						&
	   THEN								&
		SLEEP.TIME% = 600%					&
	!  If there is nothing to wake up for within the next ten	&
	!  minutes then the program will sleep ten minutes.		&

1300	SLEEP SLEEP.TIME%						&
	!     Sleep for some time before searching the array again.	&

1400	GOTO 1000							&
	!	Search the array again.					&

3000	!************************************************************** &
	!								&
	!	This SUBROUTINE looks ahead ten minutes for		&
	!	an alarm setting that may be set for a time		&
	!	within the next ten minutes.				&
	!								&

3080	FOR COMPARE% = 1% TO 10%					&
	    !	Set up a loop to make 10 comparisons of the given	&
	    !	and computer time.  These comparisons are to see if	&
	    !	this alarm time will take place within ten minutes.	&

3100	    ADD.TIME% = COMP.TIME% + COMPARE%				&
	    !	This gives ADD.TIME% the value of the COMP.TIME%	&
	    !	plus COMPARE%.						&

3110	    IF G.TIME% = ADD.TIME%					&
	       THEN							&
		    TEMP.SLEEP.TIME% = COMPARE% * 45%			&
	       ELSE							&
		    TEMP.SLEEP.TIME% = 0%				&
	    !   If the alarm time will take place within		&
	    !   (COMPARE%) minutes then TEMP.SLEEP.TIME%		&
	    !   is given the value of seconds less than that		&
	    !	of (COMPARE%) minutes.					&

3130	    IF TEMP.SLEEP.TIME% > 0%					&
	       THEN							&
		    GOTO 3200						&
	    !  If the time until the next alarm time is found then	&
	    !  exit this loop.  (why keep looking if you found it.)	&

3150	NEXT COMPARE%							&

3200	RETURN								&

10000	!								&
	!	This function coverts the time into the number of	&
	!	minutes	since midnight.  The value is returned in	&
	!	integer form.						&
	!								&

10020	DEF FNCVT%(ARG$)						&

10040	HOUR$ = LEFT(ARG$,2%)					     \  &
	HOUR% = VAL(HOUR$)					     \  &
	MIN$ = MID(ARG$,4%,2%)					     \  &
	MIN% = VAL(MIN$)						&
	!	Get the values for the given hours and minutes		&
	!	in string and numeric form.				&

10050	MIDNIGHT% = INSTR(1%,ARG$,"MIDNIGHT")				&
	!  Find the word MIDNIGHT in the given time.			&

10060	PM% = INSTR(1%,TIME$(0%),"PM")					&
	!  Find "PM" in the given timALARM0BAS[.050021]ALARM0.BAS[.050021]            	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~@g  g      h  < i  | o  < m  < 4p  < p  < k  | Zn  < l   fr   r    w    x  < x  < x  < x    ޺  <     w   @]   @   @    f    j    n    r          ]            Z                     e   @   @  | >     | 
    |     v  < H       | 	 	   | 	 	   | x z   | 
	 	   | z      t   f   r
  
  
 < 
  &    ^  @& @' */  V,   "? Lh   :h   m   Bm    z | z  {  x  `y ~ | f  N |@@ |@͂ |@
  ݃ ƃ < n s   <     | Ŏ 	   |  ️   | e p   | u    |  -    @ 率    |   < ﾲ 2      ֻ   r    |  |    Z      R M           |               n t     B | x  y  v  Zw | J= | R> | J?   
 n   n    a   a  | b    d    d  f  B%)						&

11620	STAR$ = STRING$(5%,7%) + STRING$(75%,42%) + STRING$(5%,32%)	&
	!	This is 5 beeps + 75 asteriks + 5 spaces.		&

11630	STAR$ = STAR$ + CHR$(13%) + CHR$(10%)				&
	!	Add a carriage return and a line feed to STAR$.		&

11640	BLANK.LINE$ = STRING$(80%,32%) + (CHR$(13%) + CHR$(10%))	&
	!  This is a blank line with a carriage return and line feed.	&

11650	FOR BEEP% = 1% TO 2%						&

11660	    Z$ = SYS(CHR$(6%) + CHR$(-5%) + CHR$(KB%) + BLANK.LINE$)	&
	    !    Send a blank line.					&

11670	    Z$ = SYS(CHR$(6%) + CHR$(-5%) + CHR$(KB%) + STAR$)		&
	    !    Send some beeps and a row of asteriks.			&

11675	    SLEEP 1%							&

11680	NEXT BEEP%							&

11690	Z$ = SYS(CHR$(6%) + CHR$(-5%) + CHR$(KB%) + BLANK.LINE$)	&
	!    Send a blank line.						&

11700	FNEND								&

12800	!								&
	!     This function converts the message into three parts.	&
	!								&

12810	DEF FNCVT.MESSAGE$(REASON$)					&

12815	REASON$ = REASON$ + " "						&
	! This adds a space to the end to define the end of the string.	&

12820	LONG% = LEN(REASON$)						&
	!	Find the length.  The length determines how many	&
	!	whole parts can be made out of the reason.		&

12830	IF LONG% <= 43% GOTO 12870					&

12840	IF LONG% <= 85% GOTO 12860					&

12850	POSIT1% = INSTR(43%,REASON$," ")			     \  &
	POSIT2% = INSTR(85%,REASON$," ")			     \  &
	PART1$ = LEFT(REASON$,POSIT1%)				     \  &
	PART2$ = MID(REASON$,POSIT1% + 1%,POSIT2% - POSIT1%)	     \  &
	PART3$ = RIGHT(REASON$,POSIT2% + 1%)			     \  &
	GOTO 12880							&
	!	This gives three parts.					&

12860	POSIT1% = INSTR(43%,REASON$," ")			     \  &
	PART1$ = LEFT(REASON$,POSIT1%)				     \  &
	PART2$ = RIGHT(REASON$,POSIT1% + 1%)			     \  &
	PART3$ = ""						     \  &
	GOTO 12880							&
	!	This gives two parts.					&

12870	PART1$ = REASON$					     \  &
	PART2$ = ""						     \  &
	PART3$ = ""							&
	!	This gives one part.					&

12880	FNEND								&

19000	!************************************************************** &
	!								&
	!			ERROR ROUTINE				&
	!								&

19010	!	*	*	*	*	*	*	*	&
	!	Expected Errors WITHOUT error line numbers		&
	!	*	*	*	*	*	*	*	&

19030	IF ERR = 10 AND PRO.VIO.COUNT% < 100%				&
	   THEN								&
		PRO.VIO.COUNT% = PRO.VIO.COUNT% + 1%		     \  &
		SLEEP 1%					     \  &
		RESUME							&
	!  Stall the program for a second when a protection violation	&
	!  error is generated.   A protection violation error will be   &
	!  generated when two jobs try to access the same block in	&
	!  the ALARM.VIR file.  To avoid an infinite loop this error	&
	!  trap only allows 100 of these errors.			&

19050	IF ERR = 10 AND PRO.VIO.COUNT% >= 100%				&
	   THEN								&
		OPEN "[1,2]ALARM.DIE" AS FILE 11%, MODE 2%	     \  &
		PRINT 11%, DATE$(0%);TIME$(0%)			     \  &
		CLOSE 11%					     \  &
		CHAIN "[1,2]ALARM0" LINE 100				&
	!  If a hundred or more protection violations are generated	&
	!  then the program starts over (really starts over).		&
	!	Keep track of the times this happens.			&

19100	!	*	*	*	*	*	*	*	&
	!	Expected Errors WITH error line numbers			&
	!	*	*	*	*	*	*	*	&

19120	!		?Can't find file or account		     \  &
	IF ERR = 5 AND ERL = 1020					&
	   THEN								&
		NOT.FOUND% = -1%				     \  &
		RESUME 1030						&
	!  Can't find the ALARM.VIR file when it is opened for input.	&

19980	!	*	*	*	*	*	*	*	&
	!		     Unexpected errors				&
	!	*	*	*	*	*	*	*	&

19985	Z$ = SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR))				&

19990	ERROR$ = RIGHT(Z$,3%)						&

19995	PRINT BELL$						     \  &
	PRINT " Oh no !! Not another "; ERROR$			     \  &
	PRINT " at line";ERL;"in program ALARM0 !!"			&

19999	GOTO 32767							&

32767	END

                                                                                                                                                                                                                                                                                                                                       ALARM0BAS[.050021]ALARM0.BAS[.050021]           	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~@g  g      h  < i  | o  < m  < 4p  < p  < k  | Zn  < l   fr   r    w    x  < x  < x  < x    ޺  <     w   @]   @   @    f    j    n    r          ]  