 "                     Number of words."		     \  &
	PRINT "                     Average # of words per sentence." \ &
	PRINT FOR CLR% = 1% TO 2%					&

560	Z$ = SYS(CHR$(11%))						&
	!    Cancel the type ahead on the file input.			&

580	PRINT "Enter the filename you want to process";		     \  &
	INPUT LINE FILE$					     \  &
	FILE$ = CVT$$(FILE$,4% + 16% + 32%)				&
	!   Use input line to allow commas in the name of the file.	&

600	IF FNFOUND%(FILE$) = NO%					&
	   THEN								&
		GOTO 500						&

620	OPEN FILE$ AS FILE #1% , RECORDSIZE 512%		     \  &
	FIELD #1% , 512% AS WHOLE.THING$				&

1000	!************************************************************** &
	!								&
	!	This part of the program does the searching		&
	!	counting of the words in the file.			&
	!								&

1010	IF INSTR(1%,WHOLE$,". ") = NO%					&
	   THEN								&
		WHOLE$ = CVT$$(WHOLE$ + FNGET$,8%)			&
	!  This conversion makes sure a record does not	begin with a	&
	!  sentence AND a space.  This may happen when, WHOLE$ is null	&
	!  (if WHOLE$ is null it means that a sentence follows), and a	&
	!  record begins with a space.					&

1030	IF END.OF.FILE% = YES%						&
	   THEN								&
		GOTO 7000						&
	!  Print the results when there is no more data.		&

1040	SENT.PLACE% = INSTR(1%,WHOLE$,". ")			     \  &
	WORD.PLACE% = 0%						&
	!  Find the first sentence in the string.			&
	!  Set the word pointer at the beginning of the sentence.	&

1060	WHILE SENT.PLACE% > WORD.PLACE%					&
	!   Keep looping while the sentence has uncounted words.	&

1070	   TMP.PLACE% = INSTR(WORD.PLACE%,WHOLE$," ")			&
	!	Find the next word using the last's words place		&
	!	as a starting point for the search.			&

1080	   IF TMP.PLACE%						&
	      THEN							&
		   WORDS = WORDS + 1%					&
	!  Count the words that are found.				&

1100	   WORD.PLACE% = TMP.PLACE% + 1%				&
	!	Make the present's word position the new		&
	!	starting point for the next search.			&

1120	NEXT								&
	!  Go back to the while statement.				&

1150	WHOLE$ = RIGHT(WHOLE$,SENT.PLACE% + 2%)				&
	!    Cut off the sentence in which the words were counted.	&

1170	SENT = SENT + 1%						&
	!   Count the sentences.					&

1500	GOTO 1000							&
	!    Get another sentence and process it.			&

7000	!************************************************************** &
	!								&
	!	Print the resulting report on the screen.		&
	!								&

7030	IF SENT = 0%							&
	   THEN								&
		GOTO 7060						&
	!  Prevent a division by zero in line 7040.   (next line)	&

7040	AVER = (WORDS * 1.) / SENT					&
	!	Calculate the average words per sentence.		&

7060	PRINT CLEAR$						     \  &
	PRINT CHR$(7%) FOR CLR% = 1% TO 5%				&

7080	PRINT "REPORT ON ";'"';FILE$;'"';"."			     \  &
	PRINT FOR CLR% = 1% TO 2%				     \  &
	PRINT "THIS FILE CONTAINS EXACTLY";SENT;"SENTENCES."	     \  &
	PRINT FOR CLR% = 1% TO 2%				     \  &
	PRINT "THIS FILE CONTAINS EXACTLY";WORDS;"WORDS."	     \  &
	PRINT FOR CLR% = 1% TO 2%				     \  &
	PRINT "THE AVERAGE NUMBER OF WORDS PER SENTENCE IS ";	     \  &
	PRINT USING "##.##" , AVER				     \  &
	PRINT FOR CLR% = 1% TO 3%					&

18999	GOTO 32767							&

19000	!************************************************************** &
	!								&
	!			ERROR ROUTINE				&
	!								&

19020	!	*	*	*	*	*	*	*	&
	!	Expected Errors WITHOUT error line numbers		&
	!	*	*	*	*	*	*	*	&

19040	!			    ^C error			     \  &
	IF ERR = 28							&
	   THEN								&
		CLOSE #1%					     \  &
		GOTO 32767						&

19060	!			    ^Z error			     \  &
	IF ERR = 11 AND ERL <> 600					&
	   THEN								&
		CLOSE #1%					     \  &
		GOTO 32767						&

19900	!	*	*	*	*	*	*	*	&
	!		     Unexpected errors				&
	!	*	*	*	*	*	*	*	&

19995	Z$ = SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR))			     \  &
	ERROR$ = RIGHT(Z$,3%)					     \  &
	PRINT BELL$						     \  &
	PRINT " Oh no !! Not another "; ERROR$			     \  &
	PRINT " at line";ERL;"in program WORDS !!"		     \  &
	GOTO 32767							&

20000	!							WORDS BAS[.050021]WORDS .BAS[.050021]            	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~@g  g      h  < i  | o  < m  < 4p  < p  < k  | Zn  < l   fr   r    w    x  < x  < x  < x    ޺  <     w   @]   @   @    f    j    n    r          ]            Z                     e   @   @  | >     | 
    |     v  < H       | 	 	   | 	 	   | x z   | 
	 	   | z      t   f   r
  
  
 < 
  &    ^  @& @' */  V,   "? Lh   :h   m   Bm    z | z  {  x  `y ~ | f  N |@@ |@͂ |@
  ݃ ƃ < n s   <     | Ŏ 	   |  ️   | e p   | u    |  -    @ 率    |   < ﾲ 2      ֻ   r    |  |    Z      R M           |               n t     B | x  y  v  Zw | J= | R> | J?   
 n   n    a   a  | b    d    d  f  	&
	!	FUNCTION:  TO GET A RECORD.				&
	!								&

20010	DEF FNGET$						     \  &
	ON ERROR GOTO 20250					     \  &
	Z$ = SYS(CHR$(6%) + CHR$(-7%))					&
	!	Set up the function's error routine.			&

20030	GET #1%								&

20050	IF END.OF.FILE%							&
	   THEN								&
		CLOSE #1%					     \  &
		GOTO 20190						&
	!  When the end of the file is reached close the file		&
	!  and end the function.					&

20060	WHOLE.E$ = XLATE(WHOLE.THING$,TABLE$)				&
	!  Translate the whole string according to the table.		&

20070	WHOLE.E$ = CVT$$(WHOLE.E$, 16%)					&
	!          Make spaces single.					&

20080	FNGET$ = WHOLE.E$						&
	!  Return the translated and converted string.			&

20190	FNEND							     \  &
	ON ERROR GOTO 19000						&
	!  Reset the error routine to 19000.				&

20250	!								&
	!	Error routine for the GET FUNCTION.			&
	!								&

20260	!  ?End of file on device.				     \  &
	IF ERR = 11 AND ERL = 20030					&
	   THEN								&
		END.OF.FILE% = -1%				     \  &
		RESUME 20050						&

20270	!   ?End of file on device.  OR  ?Programmable ^C trap.	     \  &
	IF ERR = 11 OR ERR = 28						&
	   THEN								&
		Z$ = SYS(CHR$(6%) + CHR$(-7%))			     \  &
		RESUME 20010						&
	!  Reset the ^C trap and resume the function's beginning.	&

20290	!	*	*	*	*	*	*	*	&
	!		     Unexpected errors				&
	!	*	*	*	*	*	*	*	&

20295	Z$ = SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR))			     \  &
	ERROR$ = RIGHT(Z$,3%)					     \  &
	PRINT BELL$						     \  &
	PRINT " Oh no !! Not another "; ERROR$			     \  &
	PRINT " at line";ERL;"in FNGET$ !!"			     \  &
	GOTO 32767							&

21000	!								&
	!	FUNCTION:  TO FIND A GIVEN FILE.			&
	!							     \  &
	DEF FNFOUND%(FILE.EDR$)						&

21010	YES% = -1%						     \  &
	NO%  =  0%						     \  &
	FOUND.EDR% = YES%						&
	!	Get ready to start the function.			&

21030	ON ERROR GOTO 21080						&
	!	Set the error routine for this function.		&

21040	IF FILE.EDR$ = ""						&
	   THEN								&
		FILE.EDR$ = "that file"					&
	!	If the FILE.EDR$ is null then look for a dummy file	&
	!	to cause a (Can't find file or account) error.		&

21050	OPEN FILE.EDR$ FOR INPUT AS FILE #9%			     \  &
	CLOSE #9%							&
	!	Open the file for input to see if it exists.		&

21060	IF FOUND.EDR% = NO%						&
	   THEN								&
		FNFOUND% = NO%						&
	   ELSE								&
		FNFOUND% = YES%						&
	! If the file does not exist then return the answer in FNFOUND%	&

21065	IF FOUND.EDR% = NO%						&
	   THEN								&
		PRINT BELL$					     \  &
		PRINT "?Can't find ";FILE.EDR$;" please check the name." \  &
		SLEEP 5%						&
	!  If the file does not exist then tell them so.		&

21070	ON ERROR GOTO 19000					     \  &
	FNEND								&
	!	Before ending the function reset the on error goto.	&

21080	!								&
	!	Error routine for FNFOUND%				&
	!								&

21090	FOUND.EDR% = NO%					     \  &
	RESUME 21060							&
	!  On any error set this flag and resume 21060			&

21100	GOTO 32767							&
	!  Just making sure the program doesn't run out through here.	&

32767	END

                                                                                                                                                                                                                                                                                                                                                                                                                                                                          