rn	struct	stats	tempstat ;



/*	PAGEINIT()							*/
/*									*/
/*	Called from INITTEMP() to setup the cacheing data structures	*/
/*	ALLBUFFER() is called with min and max arguements in 512 byte	*/
/*	units, and returns the buffer count in 512 byte units.		*/

pageinit()
{
	register int i ;
	extern char *allbuffer() ;

	base_address = allbuffer(&all_buf_count ,
				 _MIN_BUF_COUNT*_CLUSTER_SIZE ,
				 _MAX_BUF_COUNT*_CLUSTER_SIZE ) ;
	if ( (all_buf_count=all_buf_count/_CLUSTER_SIZE) == 0 ) then return(0) ;
	vir_pagecount = all_buf_count * _CLUSTER_SIZE ;
	dopageing = 1 ;
	for ( i=0; i<vir_pagecount; i++ )
		text_pointer[i] = base_address + (i*_TEXT_SIZE) ;
	for ( i=0; i<all_buf_count; i++ ) {
		buf_pointer[i] =  base_address + (i*_PAGE_SIZE) ;
		buf_res[i] = 0 ;
		buf_mod[i] = 0 ;
		access_count[i] = 0 ;
		}
	least_access = 0 ;
	last_page = 0 ;
	total_count = 0 ;
	page_size = _PAGE_SIZE ;
	cluster_size = _CLUSTER_SIZE ;
	buf_count = all_buf_count ;
	
	return(1) ;
}


/*	PAGEOFF()							*/
/*									*/
/*	Disable all cacheing of the work file buckets to effect a fast	*/
/*	IFL of the input file.  This can ONLY be used from IFL() since	*/
/*	it does not flush any cached pages to disk.			*/

pageoff(win)
int win ;
{
	if ( win != 0 ) then return(1) ;
	dopageing = 0 ;
	if ( (page_size = _PAGE_SIZE * all_buf_count) > _MAX_PAGE_SIZE )
	  then page_size = _MAX_PAGE_SIZE ;
	cluster_size = page_size / _TEXT_SIZE ;
	buf_count = 1 ;
	buf_res[0] = 0 ;
	buf_mod[0] = 0 ;
	access_count[0] = 0 ;
}



/*	PAEGON()							*/
/*									*/
/*	Called from IFL() to reset the cacher to work normally		*/

pageon(win)
int win ;
{
	if ( win != 0 ) then return(1) ;
	if ( dopageing == 0 )
	  then	{
		dopageing = 1 ;
		if ( buf_res[0] && buf_mod[0] )
		  then	{
			mapcache() ;
			puttblock(buf_pointer[0],page_size,buf_res[0],win) ;
			unmapcache() ;
			last_page = buf_res[0] + cluster_size - 1 ;
			}
		buf_mod[0] = 0 ;
		buf_res[0] = 0 ;
		access_count[0] = 0 ;
		page_size = _PAGE_SIZE ;
		cluster_size = _CLUSTER_SIZE ;
		buf_count = all_buf_count ;
		}
}		



gettemp(buf,vbn,win)
register char *buf ;
int vbn ,win ;
{
	register int i ;
	extern char *bufcontrol() ;

	if (win != 0) return(gettblock(buf,_TEXT_SIZE,vbn,win)) ;
	mapcache(win) ;
#if	RSX
	blkmov(buf,bufcontrol(vbn,0,win)) ;
#else
	scopy(buf,bufcontrol(vbn,0,win),_TEXT_SIZE) ;
#endif
	unmapcache(win) ;
	return(1) ;
}


puttemp(buf,vbn,win)
register char *buf ;
int vbn,win ;
{
	register int i ;
	extern char *bufcontrol() ;
	if (win != 0) return(puttblock(buf,_TEXT_SIZE,vbn,win)) ;
	mapcache(win) ;
#if	RSX
	blkmov(bufcontrol(vbn,1,win),buf) ;
#else
	scopy(bufcontrol(vbn,1,win),buf,_TEXT_SIZE) ;
#endif
	unmapcache(win) ;
	return(1) ;
}




char *bufcontrol(vbn,direction,win)

int vbn,direction,win ;

{
	register int buf,block,temp ;
	int offset,status ;

	status = sys_normal ;
	vbn-- ;
	offset = vbn % cluster_size ;
	block  = vbn - offset + 1 ;
	for ( buf=0; buf < buf_count && block != buf_res[buf]; buf++ ) ;
	if ( buf >= buf_count )
	  then	{			/* a page fault has occurred	*/
		least_access = 32767 ;
		temp = 0 ;
		for ( buf=0; buf < buf_count; buf++ ) {
			if ( access_count[buf] <= least_access )
			  then	{
				least_access = access_count[buf] ;
				temp = buf ;
				}
			}
		buf = temp ;
		if ( buf_mod[buf] && (temp=buf_res[buf]) )
		  then	{
			if (temp > last_page)
			  then last_page = temp+cluster_size-1 ;
			status=puttblock(buf_pointer[buf],page_size,temp,win) ;
			tempstat.w_faults++ ;
	    		}
		if ( block <= last_page)
		  then	{
			status=gettblock(buf_pointer[buf],page_size,block,win) ;
			tempstat.r_faults++ ;
			}
		buf_res[buf] = block ;
		buf_mod[buf] = 0 ;
		}
	  else	tempstat.hits++ ;

	access_count[buf] = ++total_count ;
	if ( direction ) then buf_mod[buf] = 1 ;
	if ( status != sys_normal )
	  then	tederror("I/O error on the workfile") ;
	return( text_pointer[buf*cluster_size+offset] ) ;
}

EDPAGRC  [.050036]EDPAGR.C  [.050036]   &       	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                          7-./%
<=2&?'@O{[lP}M]\Nk`Kaz^L~no|JZ_myjС??????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????? \	\\\\
\\\\\\\\\\
\\\\\\\\\\\\\\\\ \\\\\\\\\[.<(+!&\\\\\\\\\]$*);^-/\\\\\\\\|,%_>?\\\\\\\\\`:#@'="\abcdefghi\\\\\\\jklmnopqr\\\\\\\~stuvwxyz\\\\\\\\\\\\\\\\\\\\\\{ABCDEFGHI\\\\\\}JKLMNOPQR\\\\\\\\STUVWXYZ\\\\\\0123456789\\\\\