





























                                  23


                               [1mDIFF.COM[0m


           o  DIFF.COM is a "front-end" to the DCL DIFFERENCES
              command

           o  Applies "File 1" defaults to "File 2"

           o  If no "File 2" parameter, then DIFF uses .BAK file

           o  Outputs differences to terminal or optional .DIF
              file

           o  Used in conjunction with re-defined DIFFERENCES
              command:

        $ DIF-FERENCES = "@DIFF"

           o  Illustrates:

                    -  How to use F$PARSE function to build
                       file-specs

                    -  How you can "re-define" an existing DCL
                       command

                    -  Simple loop for processing P1 - P8
                       parameters







$! DIFF.COM - Execute DIFFERENCES command
$!
$! Arguments passed:
$!
$!      P1 = File 1 (prompt if null)
$!      P2 = File 2 (P1 + ".BAK" if null)
$!      P3 = Output file ("KB:.DIF" if null)
$!
$! DIFF.COM makes the standard DIFFERENCES command
$! easier to use, as it applies defaults from the
$! "File 1" parameter to the "File 2" parameter.
$! If no "File 2" parameter is passed, then DIFF
$! uses assumes a .BAK file.
$!
$! For writing the DIFFERENCES report to a file,
$! specify a file-spec as P3.
$
$! Build defaults for arguments
$ _If P1 .eqs. "" then -
                _Inquire P1 "File 1"
$ _If P2 .eqs. "" then -
                 P2 = ".BAK"
$ _If P3 .eqs. "" then -
                 P3 = "_KB:.DIF"
$
$! Ensure P1 - P3 files are valid
$ X = 1
$LOOP_1:
$  _If F$Parse(P'X',,"FLAGS") .eq. -1 then -
                 _Write 0 "?File name ",P'X'," is invalid"
$  X = X + 1
$  _If X .le. 3 then -
                 _Goto LOOP_1
$
$! Add "." to "File 1" if no file type given
$ P1 = F$Parse(P1,".")
$
$! Build "File 2" spec using "File 1" defaults
$ P2 = F$Parse(P2,P1)
$
$! Build "Output file" using "File 1" defaults
$ P3 = F$Parse(F$Parse(P3,".DIF"),P1)
$
$! Ensure P1, P2 files exist
$ X = 1
$LOOP_2:
$  _If F$Search(P'X') .eqs. "" then -
                 _Write 0 "?File ",P'X'," does not exist"
$  X = X + 1
$  _If X .le. 2 then -
                 _Goto LOOP_2
$
$! Execute real DIFFERENCES command
$ _Differences/output='P3' 'P1' 'P2'
$
$ _Exit

                                                                                                                                 