$ Verify = F$Verify(0)
$
$! SYSDO.COM - Perform daily, weekly and monthly tasks
$!
$! This command file runs under batch and performs
$! once-a-day, once-a-week, and once-a-month tasks on
$! behalf of system users.
$!
$! Each day at 2:00 am (or thereabouts), SYSDO submits
$! to batch (queue BA1:) the command file DAILY.COM
$! found in all users' accounts on the system disk.
$!
$! If the current day is Sunday, then SYSDO also
$! SUBMITs all users' WEEKLY.COM command files.
$!
$! On the first day of the month, SYSDO also SUBMITs
$! all users' MONTHLY.COM command files.
$!
$! SYSDO passes the following parameters to all daily,
$! weekly or monthly command files it submits:
$!
$!     P1     Year index (e.g. 85)
$!     P2     Month index (1-12)
$!     P3     Day index (1-31)
$!     P4     Day name (e.g., "FRIDAY")
$!
$! To have SYSDO submit itself, use the command:
$!
$!          $ @[0,1]SYSDO SUBMIT
$!
$! SYSDO always re-SUBMITs itself to run the next day
$! (TOMORROW) after 2:00 am.
$!
$
$ _On Error then _Goto END
$
$! Ensure running under batch for the rest
$ _If F$Access() .nes. "BATCH" then -
                _If P1 .eqs. "" then -
                     _Write 0 "?SYSDO must run under BATCH"
$
$! Ensure job has WACNT and WREAD privileges
$ _If .not. F$Privilege("WACNT") then -
                _Write 0 "?WACNT privilege required"
$ _If .not. F$Privilege("WREAD") then -
                _Write 0 "?WREAD privilege required"
$
$! Resubmit batch job for next day at 2:00 am
$ _Set NoOn
$ _Set Entry BA1:[1,2]SYSDO -
                     /Release
                     /After=Tomorrow:2:00am
$ Severity = $Severity
$ _Set On
$ _If .not. Severity then - 
                _Submit _SY:[0,1]SYSDO.COM -
                     /Queue=BA1: -
                     /Owner=[1,2] -
                     /After=Tomorrow:2:00am -
           !         /Log_Queue -
           !         /Log_Delete
$
$! Exit now if that's all were supposed to do
$ _If P1 .eqs. "SUBMIT" then -
                _Goto END
$
$! Get current year/month/day values
$ Date_Time = F$Cvtime()
$ Yr = +F$Left(Date_Time,2)
$ Mon = +F$Mid(Date_Time,4,2)
$ Day = +F$Mid(Date_Time,7,2)
$
$! Call DATE.COM to get day of week name
$! (Name returned in global symbol "Today")
$ @[0,1]DATE.COM "''Date_Time'" "Today"
$
$! Perform daily processing
$ Com_File = F$Search("_SY:[*,*]DAILY.COM")
$ Return = "WEEKLY"
$ _Goto SUBMIT
$
$! Perform weekly processing on Sunday
$WEEKLY:
$ _If Today .nes. "SUNDAY" then -
                _Goto MONTHLY
$ Com_File = F$Search("_SY:[*,*]WEEKLY.COM")
$ Return = "MONTHLY"
$ _Goto SUBMIT
$
$! Perform monthly processing on first day of month
$MONTHLY:
$ _If Day .ne. 1 then -
                _Goto END
$ Com_File = F$Search("_SY:[*,*]MONTHLY.COM")
$ Return = "END"
$ _Goto SUBMIT
$
$END:
$ Verify = F$Verify(Verify)
$ _Exit
$
$! Subroutine to SUBMIT users' COM files
$SUBMIT:
$ _If Com_File .eqs. "" then -
                _Goto 'Return'
$ Ppn = F$Parse(Com_file,,"PPN")
$ _Set NoOn
$ _Submit 'Com_File' -
                /Param=("''Yr'","''Mon'","''Day'","''Today'") -
                /Queue=BA1: -
                /Owner='Ppn' -
                /Time_Limit=120
$ _Set On
$ Com_File = F$Search()
$ _Goto SUBMIT

                                                                                                                                                                                                                                                                  