$! TIMER.COM - Execute P2 command every P1 secs
$!
$! Arguments passed:
$!
$!      P1 = No. seconds delay between commands
$!      P2 = Command to execute repeatedly
$!
$! TIMER.COM allows you to repeat a specified
$! command (P2) every P1 seconds.  If P1 is
$! zero, then no delay is inserted between
$! iterations of the command. If P1 is negative
$! or an invalid number, then an error is
$! displayed and the COM file exits.
$!
$! Errors returned by the command are ignored.
$! Type CTRL/C to terminate the loop.
$
$! Prompt if no delay specified
$ _If P1 .eqs. "" then -
     _Inquire P1 "Delay <0>"
$ _If P1 .eqs. "" then -
     P1 = "0"
$
$! Ensure delay (P1) is valid
$ Delay = +P1
$ If P1 .nes. "''Delay'" then -
    _Write 0 "?Delay is not a valid number"
$ _If Delay .lt. 0 then -
    _Write 0 "?Delay cannot be negative"
$
$! Prompt if no command (P2) specified
$ _If P2 .eqs. "" then -
     _Inquire P2 "Command <Exit>"
$ _If P2 .eqs. "" then -
     _Exit
$
$! Ignore errors
$ _Set NoOn
$
$! Loop on the command
$LOOP:
$  _Write 0 ""
$  _Write 0 "------------------------- ", -
            F$Time(), -
            " -------------------------"
$  _Write 0 ""
$  'P2'
$  _If Delay .gt. 0 then -
     _Inquire/nopunc/time='Delay' Junk ""
$  _Goto LOOP

                                                                                                                                                                                                                              