$! TRMTYP.COM - Determine user's terminal (KB) type
$!
$! Parameters:  None
$!
$!    Returns:  TTY_Type == "terminal type keyword"
$!
$! This COM file runs the TRMTYP program,which returns
$! (in local symbol TRMTYP_Val) the user's terminal
$! type code as an integer.
$!
$! TRMTYP then uses the terminal type code to fetch
$! the user's terminal type keyword from an array, and
$! save it in the global symbol TTY_Type.
$
$! Define cooperating TRMTYP task file-spec
$ TRMTYP_Task = "_SY:[]TRMTYP.BAC"
$
$! Make sure TRMTYP program exists
$ _If f$search(TRMTYP_Task) .eqs. "" then -
                _Write 0 "?Program ''TRMTYP_Task' does not exist"
$
$! Define terminal type keywords array
$! (older terminal types not included)
$ Type_1  = "UNKNOWN"
$ Type_2  = "LA36"
$ Type_3  = "VT52"
$ Type_4  = "VT55"
$ Type_5  = "LA180S"
$ Type_6  = "VT100"
$ Type_7  = "LA120"
$ Type_8  = "LA12"
$ Type_9  = "LA100"
$ Type_10 = "LA34"
$ Type_11 = "LA38"
$ Type_12 = "LA50"
$ Type_13 = "VT101"
$ Type_14 = "VT102"
$ Type_15 = "VT125"
$ Type_16 = "VT131"
$ Type_17 = "VT132"
$ Type_18 = "VT220"
$ Type_19 = "VT240"
$ Type_20 = "VT241"
$ Type_21 = "VT105"
$
$! Run TRMTYP program to get type code
$! (returned in symbol TRMTYP_Val)
$ _Run 'TRMTYP_Task'
$
$! See if symbol TRMTYP_Val defined
$ _If F$Type(TRMTYP_Val) .eqs. "" then -
                 TRMTYP_Val = 1
$
$! Use "UNKNOWN" for values not defined in array
$ _If F$Type(Type_'TRMTYP_Val') .eqs. "" then -
                 TRMTYP_Val = 1
$
$! Save type keyword in global symbol TTY_Type
$ TTY_Type == Type_'TRMTYP_Val'
$
$! Display what terminal type we're on
$ _Write 0 "Your terminal's type is ",TTY_Type
$
$ _exit

                                                                                                                                                                                                                                                                                                                               