1000 !	ANSI.BAS - puts an ANSI file on the end of a DOS tape. &
! &
!	This allows one to make a DOS tape (ending with a special file &
!	such as $DOS.EOT) and to add an ANSI BACKUP container file. &
!	Additional BACKUP container sets can then be added via BACKUP. &
! &
!	Required file:	ANSI.DAT &

1010 !	8-Feb-88	F. Mitchell	Erskine College &
! &
!	8-Feb-88	last edit	*M &
! &
!	 Author:	W. Franklin Mitchell, Jr. &
!			Director of Computer Services &
!			Erskine College, Due West, South Carolina &
! &
!			Copyright (c) 1988 &
!			Erskine College, Due West, South Carolina &
! &
!   *********************************************************************** &
!   * This software is furnished without charge by  Erskine  College  and * &
!   * may  be  copied  only  with  the inclusion of the author's name and * &
!   * copyright notice.  No title to or ownership  of  this  software  is * &
!   * hereby transmitted.  Neither Erskine College nor the author assumes * &
!   * any responsibility for the use or reliability of this software. The * &
!   * author welcomes comments and/or  bug  reports  mailed  to  Franklin * &
!   * Mitchell, Erskine College, Box 86L, Due West, South Carolina 29639. * &
!   *********************************************************************** &

1020 !	The following example creates a DOS/ANSI mixed tape of the data &
!	on DL0: in account [1,8]: &
! &
!		PIP &
!		MS:/ZE &
!		Y &
!		MS:[*,*]=DL0:[1,8]*.*/W &
!		MS:$DOS.EOT=NL: &
!		^Z &
!		RUN ANSI &
!		BACKUP/NOREWIND/NOVERIFY DL0:[1,8]*.* MS:INFO &
!		DISMOUNT MS: &
! &
!	This example shows how to restore the file [1,8]TEST.DAT from the &
!	INFO.BCK BACKUP container set. &
! &
!		PIP NL:=MS:$DOS.EOT &
!		RESTORE/NOREWIND/NOVERIFY/SELECT=[1,8]TEST.DAT - &
!		DL0:[1,8]TEST.DAT MS:INFO &

1030	DIM R%(255), I$(255) &

1040	PRINT &
\	PRINT "ANSI.BAS V1.0  -  "; DATE$(0%); "  "; TIME$(0%) &
\	ON ERROR GOTO 19000 &
\	V$ = SYS(CHR$(6%) + CHR$(-7%)) &
\	TAPE.CH% = 1% &
\	DISK.CH% = 2% &
\	TAPE.MARK% = 2% &
\	BACKSPACE% = 5% &

1050	PRINT &
\	PRINT "Tape drive <MS0:>"; &
\	INPUT LINE TAPE.DRIVE$ &
\	TAPE.DRIVE$ = CVT$$(TAPE.DRIVE$, -1%) &
\	TAPE.DRIVE$ = "MS0:" IF LEN(TAPE.DRIVE$) = 0% &
\	OPEN TAPE.DRIVE$ AS FILE TAPE.CH%, RECORDSIZE 4096% &

1060	OPEN "[1,0]ANSI.DAT" FOR INPUT AS FILE DISK.CH% &
\	FIELD #DISK.CH%, X%*2% AS D$, 2% AS I$(X%) FOR X% = 0% TO 255% &

1070	GET #DISK.CH% &
\	X% = CVT$%(I$(0%)) &
\	R%(Y%) = CVT$%(I$(Y%)) FOR Y% = 0% TO X% &

2000 FOR Y% = 1% TO X% &
\	IF R%(Y%) = -1% &
	   THEN &
		Z% = MAGTAPE(TAPE.MARK%, 0%, TAPE.CH%) &
	   ELSE &
		GET #DISK.CH% + SWAP%(TAPE.CH%), &
				COUNT (R%(Y%) + 511%)/512%*512% &
	\	PUT #TAPE.CH%, COUNT R%(Y%)
2010 NEXT Y% &

3000	Z% = MAGTAPE(TAPE.MARK%, 0%, TAPE.CH%) &
\	Z% = MAGTAPE(BACKSPACE%, 1%, TAPE.CH%) FOR Y% = 1% TO X% + 1% &
\	CLOSE TAPE.CH%, DISK.CH% &
\	PRINT &
\	PRINT "ANSI file has been appended to DOS tape..." &
\	PRINT &
\	PRINT "Now BACKUP/NOREWIND/NOVERIFY... additional BACKUP sets." &
\	PRINT &
\	GOTO 32767 &

19000	PRINT &
\	PRINT "?Unexpected ANSI error: "; ERR &
\	PRINT &
\	ON ERROR GOTO 0 &

32767	END
                                                                                                                                                                                                                                                                                                                                                                                                     