1	EXTEND
2	! FSTOPN == Open Specified Files to Allow Fast Reopens			&
	!									&
	! Opens a list of files and then detaches.  This allows later opens	&
	! of these files to be made without disk overhead.			&
	!									&
	! All commonly opened files and UFDs should be opened using this 	&
	! program.  The list of files and UFDs to be opened is contained in 	&
	! a DATA statement at line 10.  Each line specifies a file in the 	&
	! format "Dev:[PPn]Filname.Filetype" or "Dev:[PPn]".  Any number of 	&
	! files and UFDs may be specified.  One job slot is used for each 	&
	! group of up to twelve files/UFDs.					&
	!									&
	! This program must be compiled before use.  It should be compiled	&
	! using BASIC-PLUS and not BASIC-PLUS-II since the BASIC-PLUS version	&
	! uses less than half the memory and executes faster than the		&
	! BASIC-PLUS-II version.						&
	!									&
	!									&
	! COPYRIGHT (C) 1984, Northwest Digital Software Inc.			&
	!									&
	! This program may be copied without restriction with the inclusion	&
	! of this copyright notice.  This program is provided "AS-IS" as a	&
	! service to the RSTS community and is without warranty, expressed or	&
	! implied.								&
	!									&
	! AUTHOR: Michael Mayfield, Northwest Digital Software Inc.		&
	!									&
	! EDIT HISTORY:								&
	!  00 18-SEP-84 MEM	Original version.				&
	!  01  3-JUL-85 MEM	Changed list of files for V9.0			&
	!  02 21-SEP-85 MEM	Corrected problem with core common handling in	&
	!			V7.0-07 found by Jack Dolby 804-826-8210	&
	!  03 25-FEB-87 MAF	Changed list of files for RSTS/E V9.3		&
	!									&
	! VARIABLE USAGE:							&
	!  FILENAME$		Current filename for file open			&
	!  PRGM.DEV$		Device name for spawn, in FIP format		&
	!  PRGM.NAME.TYP$	Program name for spawn, in RAD50		&
	!  PRGM.PPN$		Program PPN for spawn, in FIP format		&
	!  SKIP%		Number of file specifications to skip		&

10	! List of files and UFDs to open:  &
	DATA	"[0,1]LOGIN.COM",	&
		"[0,1]PKG001.MSG",	&
		"[0,1]PKG002.MSG",	&
		"$PIP.SAV",		&
		"EDT$:EDT.TSK",		&
		"$SYSTAT.TSK",		&
		"$TERMGR.TSK",		&
		"$UTLMGR.TSK",		&
		"$LOGIN.TSK",		&
		"PBS$:PBSMGR.TSK",	&
		"*END*"		! *END* must be the last entry in the table.	&

100	SKIP%=0%  &
	! We don't need to skip any entries the first time FSTOPN is run.	&

1000	ON ERROR GOTO 32000  &
\	Z$=SYS(CHR$(12%))  &
\	PRGM.DEV$=MID(Z$,23%,4%)  &
\	PRGM.PPN$=MID(Z$,5%,2%)  &
\	PRGM.NAME.TYP$=MID(Z$,7%,6%)  &
\	Z$=SYS(CHR$(6%)+CHR$(-13%)+CHR$(255%)+CHR$(255%)+CHR$(-16%))  &
\	IF SKIP%=0% THEN  &
	  PRINT "Detaching..."  &
\	  Z$=SYS(CHR$(6%)+CHR$(7%)+CHR$(128%))  &
	! Get our program name specification to use in spawning a new copy	&
	! of ourselves.  Change our priority to -16 in case of error.  If 	&
	! this is the first run, tell them we are detaching and detach.		&

1010	READ Z$  FOR Z%=1% TO SKIP%  &
\	FOR Z%=1% TO 12%
1020	  READ FILENAME$  &
\	  GOTO 1030  IF FILENAME$="*END*"  &
\	  OPEN FILENAME$ FOR INPUT AS FILE Z%,  &
		RECORDSIZE 32767%+3%, MODE 4096%  &
\	  SKIP%=SKIP%+1%  &
\	NEXT Z%  &
\	READ Z$  &
\	GOTO 1030  IF Z$="*END*"  &
\	Z$=SYS(CHR$(6%)+CHR$(24%)+CHR$(192%)+CHR$(0%)+PRGM.PPN$+  &
		PRGM.NAME.TYP$+CVT%$(SKIP%)+STRING$(8%,0%)+PRGM.DEV$+  &
		CVT%$(SWAP%(30001%+32767%)))  &
	! Skip the files already opened by a previous run of FSTOPN.  Read up	&
	! to 12 filenames and open them in read-regardless mode (Note that	&
	! read-regardless mode is ignored for UFD opens).  If there are more	&
	! files to open, spawn a new copy of FSTOPN and tell it where to start	&
	! in the list of files to open.						&

1030	SLEEP 32767%  UNTIL 0%  &
	! Sleep forever.							&
	!									&
	! ** FEATURE PATCH:  If you want all files opened by FSTOPN to be	&
	! closed immediately if SHUTUP is run or logins turned off, replace	&
	! line 1030 with the following:						&
	!									&
	! 1030	SLEEP 32767%  &
	! \	GOTO 1030  IF  &
	!	   (SWAP%(PEEK(SWAP%(CVT$%(MID(SYS(CHR$(6%)+CHR$(-12%)),  &
	!	   13%,2%))))) AND 255%)>1%  &
	! \	CLOSE #Z%  FOR Z%=1% TO 12%  &
	! \	Z$=SYS(CHR$(6%)+CHR$(8%)+STRING$(25%,0%)+CHR$(255%))  &
	! \	SLEEP 32767  UNTIL 0%  &
	!	Sleep for 32767 seconds (9 hours) or until logins are 		&
	!	disabled.  See if logins were disabled.  If not, go back to 	&
	!	sleep.  Else, close all of our files and kill our job.  If 	&
	!	the kill failed, go to sleep until SHUTUP kills us.		&

30000	! **  SPAWN ENTRY POINT  **  &
&
	SKIP%=CVT$%(LEFT(SYS(CHR$(7%)),2%))  &
\	GOTO 1000  &
	! Get the skip count passed in core common. Start the program using	&
	! the specified skip count.						&

32000	! **  ERROR TRAP ENTRY POINT  **  &
&
	IF ERR=5% AND ERL=1020% THEN  &
	  Z$=SYS(CHR$(6%)+CHR$(-5%)+CHR$(0%)+  &
		"%% FSTOPN: Unable to open file: "+FILENAME$+  &
		CHR$(7%)+CHR$(13%)+CHR$(10%))  &
\	  RESUME 1020  &
	! "?Can't find file or account": Broadcast a message to KB0: telling	&
	! them about the error, then ignore the file.				&

32766	Z$=SYS(CHR$(6%)+CHR$(-5%)+CHR$(0%)+"%% FSTOPN: Fatal error"+  &
		NUM$(ERR)+"at line "+NUM1$(ERL)+".  Aborting..."+  &
		CHR$(7%)+CHR$(13%)+CHR$(10%))  &
\	ON ERROR GOTO 0  &
	! All other errors are fatal.  Broadcast a message to KB0: telling	&
	! them we are aborting, then abort and hybernate.			&

32767	END	
                                                                                                                                                                                                                                                                     