1	EXTEND
2	! STRETCH == Compute CPU and Wall-Clock Stretch Times			&
	!									&
	! Calculates the percentage on one second that programs are delayed	&
	! due to excess CPU usage.  Wall Stretch is the percentage slow down	&
	! in elapsed time due to sharing the CPU with other programs plus	&
	! interrupt processing in the monitor.  CPU stretch is the percentage	&
	! slow down due to interrupt processing in the monitor.  Multiplier is	&
	! the value to multiply RPTCNT% by to get the proper value for RPTCNT.	&
	! Negative value for stretch times indicate an improper value for	&
	! RPTCNT.								&
	!									&
	!									&
	! COPYRIGHT (C) 1987, Mayfield International				&
	!									&
	! This program may be copied without restriction with the inclusion	&
	! of this copyright notice.  This program is provided "AS-IS" as a	&
	! service to the RSTS community and is without warranty, expressed or	&
	! implied.								&
	!									&
	! AUTHOR: Michael Mayfield, Mayfield International			&
	!									&
	! EDIT HISTORY:								&
	!  00 29-Apr-87 MEM	Original version.				&
	!									&
	! PRIVILEGES REQUIRED:							&
	!  HWCTL, RDMEM								&
	!									&
	! VARIABLE USAGE:							&
	!  CPU.STRETCH		Percent CPU stretch				&
	!  LOOP%		Loop counter					&
	!  RPTCNT		Number of times to loop for one second		&
	!  START.WALL		Time test started (ticks since midnight)	&
	!  START.CPU%		CPU usage when test started (1/10th seconds)	&
	!  STOP.WALL		Time test stopped (ticks since midnight)	&
	!  STOP.CPU%		CPU usage when test stoped (1/10th seconds)	&
	!  TEMP			Temporary floating point variable		&
	!  TEMP$		Temporary string variable			&
	!  TIMMIN%		Minutes until midnight				&
	!  TIMSEC%		<0:7> Seconds until next minute.		&
	!			<8:15> Ticks to next second			&
	!  WALL.STRETCH		Percent elapsed time stretch			&

1000	PRINT "STRETCH == Display CPU and Wall-Clock Stretch Times"  &
\	PRINT  &
\	RPTCNT=500.0  &
\	TEMP$=SYS(CHR$(6%)+CHR$(29%)+CHR$(1%))  &
\	GOSUB 10000  &
\	TEMP$=SYS(CHR$(6%)+CHR$(29%)+CHR$(0%))  &
\	RPTCNT=RPTCNT/((STOP.WALL-START.WALL)/60.0)  &
&
\	UNTIL 0%  &
\	  GOSUB 10000  &
\	  WALL.STRETCH=ABS((STOP.WALL-START.WALL-60.0)*100.0/60.0)  &
\	  WALL.STRETCH=0.0  IF WALL.STRETCH<3.0  &
\	  CPU.STRETCH=ABS((STOP.CPU%-START.CPU%-10)*10.0)  &
\	  CPU.STRETCH=0.0  IF CPU.STRETCH<3.0  &
\	  PRINT USING "\                 \ ###.#%",  &
		"Wall Stretch Time:", WALL.STRETCH  &
\	  PRINT USING "\                 \ ###.#%",  &
		"CPU Stretch Time:", CPU.STRETCH  &
\	  PRINT  &
\	  SLEEP 60%  &
\	NEXT  &
	! Start with an arbitrary loop count.  Stall system for a few seconds.  &
	! Compute wall time used to run loop stand-alone.  Adjust loop count  &
	! to that required to last exactly one second.  Unstall the system.  &
	! Repeat each second:  &
	! Compute wall time and CPU time.  Ignore stretch times below accuracy  &
	! of one tick.  Display percentage stretched.  &

10000	! Perform operation that takes exactly one second on an idle system  &
	! and determine the additional time, if any, required do perform this  &
	! operation during the current system load.  &
&
	TIMMIN%=PEEK(514%)  &
\	TIMSEC%=PEEK(516%)  &
\	START.WALL=((1440%-TIMMIN%)*60.0+ (60%-(TIMSEC% AND 255%)))*60.0+  &
		(60%-(SWAP%(TIMSEC%) AND 255%))  &
\	START.CPU%=TIME(1%)  &
\	TEMP=SQR(1000.0)  FOR LOOP=0.0 TO RPTCNT  &
\	TIMMIN%=PEEK(514%)  &
\	TIMSEC%=PEEK(516%)  &
\	STOP.WALL=((1440%-TIMMIN%)*60.0+ (60%-(TIMSEC% AND 255%)))*60.0+  &
		(60%-(SWAP%(TIMSEC%) AND 255%))  &
\	STOP.CPU%=TIME(1%)  &
\	RETURN  &
	! Compute initial wall time in ticks and CPU time in 1/10th seconds.  &
	! Do a CPU bound operation for exactly one second (based on RPTCNT%).  &
	! Compute ending wall time in ticks and CPU time in 1/10th seconds.  &

32767	END
                                                                                                                                                                                                                                                        