{ Routines to work with detached jobs.  Contents:			    }
{	attach(jobnum) - attach to a detached job			    }
{	detach - detach the current job					    }
{	create(prgrm,line,jobnum) - create a detached job running the       }
{	   specified program.  Start execution at the specified line (for   }
{	   BASIC) or pass it line as a parameter (other languages - see     }
{	   PLIB:ENTRY.PAS).  The line number usually is passed as a zero.   }
{	   Returns the job number of the created job.  The specified	    }
{	   program must be executable (compiled) and you must specify a     }
{	   file type (e.g. .SAV or .BAC) as part of the filename.	    }
{	swapconsole(jobnum) - attached and detached jobs swap places	    }
{ In all cases, the jobs must have the same user number as the calling job  }
{ Requires that the PLIB:FSS routine be included BEFORE this one.	    }
{						    - 3/15/84 - EFM	    }

procedure attach(jobnum:integer);
{ Attach to specified detached job, which must be running under the same    }
{   user number as this job.		- 2/7/84 - EFM			    }
var
  fqfun origin 405b : char;
  fqsizm origin 407b : char;
  fqfil origin 406b : char;
  fqppn origin 410b : integer;
  fqnam1 origin 412b : integer;
  fqnam2 origin 414b : integer;
begin
  fqfun := chr(6);
  fqsizm := chr(0);
  fqfil := chr(jobnum);
  fqppn := 0;
  fqnam1 := 0;
  fqnam2 := 0;
  emt(377b);
  emt(66b);
  writeln('Error - unable to attach.')
end;  { attach }

procedure detach;
{ Detach the current job - 11/19/85 - EFM }
var
  fqfun origin 405b : char;
  fqfil origin 406b : char;
  error origin 402b : integer;
begin
  fqfun := chr(7);
  fqfil := chr(128);
  emt(377b);
  emt(66b);
  if error > 0 then
    writeln('Error - detached job quota exceeded or job already detached')
end;  { detach }  

procedure create(prgrm:packed array[slow..shigh:integer] of char; 
			line:integer; var jobnum:integer);
{ Create a job running a specified compiled program at a specified line   }
{    number.   Returns the job number of the newly created job.  Requires }
{    that PLIB:FSS be included BEFORE this routine.     - 2/7/84 - EFM    }
var
  fqfun origin 405b : char;
  fqfil origin 406b : char;
  fqclus origin 436b : integer;
  i : integer;
  error : boolean;
begin
  fss(prgrm,error);
  fqfun := chr(24);
  fqfil := chr(100b);
  fqclus := line;
  emt(377b);
  emt(66b);
  jobnum := ord(fqfil) div 2
end;  { createrun }

procedure swapconsole(jobnum:integer);
{ An attached job and a detached job will switch places.  Either job may     }
{   issue this call.  Both jobs must be running under the same user number,  }
{   and one must be attached and the other detached.    - 2/7/84 - EFM       }
var
  fqfun origin 405b : char;
  fqsizm origin 407b : char;
  fqfil origin 406b : char;
begin
  fqfun := chr(6);
  fqsizm := chr(1);
  fqfil := chr(jobnum);
  emt(377b);
  emt(66b)
end;  { swapconsole }
                                                                                                   