procedure sayerr(n:integer); external;
procedure errmsg(errnum:integer);
{ Print the error message corresponding to the given error number. }
{ Errnum is expected to be in the form returned by iostatus - that }
{ is, negative for a RSTS error, positive for Pascal.  For Pascal, }
{ only I/O errors are covered.  Note that the inclusion of an I/O  }
{ error number in the list below is no guarentee that that error   }
{ is trappable.                      - 2/13/84 - EFM               }
begin { errmsg }
  if errnum < 0
    then
      sayerr(errnum)
    else
      case errnum of
	11 : writeln('Can''t open file');
	12 : writeln('Bad default file name');
	13 : writeln('Bad default switch values');
	14 : writeln('File name syntax error');
	15 : writeln('Not enough memory for file buffer');
	16 : writeln('Too many files open');
	17 : writeln('Attempt to read past end of file');
	18 : writeln('Error reading file');
	19 : writeln('Error writing file');
	26 : writeln('SEEK() to record zero');
	28 : writeln('File is not a random access file. Use /SEEK');
	30 : writeln('File not open');
	33 : writeln('I/O transfer error');
	41 : writeln('RENAME/DELETE of non-disk file');
      { 42 ??? : writeln('Can''t delete file'); }
      { 43 ??? : writeln('Can''t rename file'); }
	otherwise
	  writeln('Unexpected Pascal error #',errnum:1)
      end
end; { errmsg }
                                                                                                                                             