procedure logical(var logname : packed array [slow..shigh : integer] of char;
                   var error:boolean);
{ translate a System-wide logical name into an actual device name or account  }
{ number.  Requires that PLIB:FSS.PAS be included in front of this procedure. }
{ If it is passed just a file name, it returns "nulls:" - no error }
{ 10/10/85 - EFM }

var
  firqb origin 402B : packed array [0..37B] of -128..127;
  num1, num2, digit, numchr, len, i : integer;

begin { logical }
  if slow=0
    then len := ord(logname[0])
    else len := shigh;
  fss(logname,error);
  if not error then
    begin
      for i := 1 to len do
        logname[i] := chr(0);
      logname[1] := chr(firqb[30b]); { device }
      logname[2] := chr(firqb[31b]); { device }
      numchr := 2;
      if firqb[33b]<>0 then  { there is a unit number }
	begin
	  num1 := firqb[32b];
	  num2 := num1;
	  digit := num1 div 100;
	  if digit > 0 then
	    begin
	      numchr := numchr + 1;
	      logname[numchr] := chr(digit+48);
	      num1 := num1 - (digit*100)
	    end;
	  digit := num1 div 10;
	  if (digit > 0) or (num2 > 99) then
	    begin
	      numchr := numchr + 1;
	      logname[numchr] := chr(digit+48);
	      num1 := num1 - (digit*10)
	    end;
	  digit := num1;
	  numchr := numchr + 1;
	  logname[numchr] := chr(digit+48)
	end;
      numchr := numchr + 1;
      logname[numchr] := ':';
      if (firqb[6b]<>0) and (firqb[7b]<>0) then   { there is a PPN }
	begin
	  numchr := numchr + 1;
	  logname[numchr] := '[';

	  num1 := firqb[7];  { project number }
	  num2 := num1;
	  digit := num1 div 100;
	  if digit > 0 then
	    begin
	      numchr := numchr + 1;
	      logname[numchr] := chr(digit+48);
	      num1 := num1 - (digit*100)
	    end;
	  digit := num1 div 10;
	  if (digit > 0) or (num2 > 99) then
	    begin
	      numchr := numchr + 1;
	      logname[numchr] := chr(digit+48);
	      num1 := num1 - (digit*10)
	    end;
	  digit := num1;
	  numchr := numchr + 1;
	  logname[numchr] := chr(digit+48);
	  numchr := numchr + 1;
	  logname[numchr] := ',';

	  num1 := firqb[6];  { programmer number }
	  num2 := num1;
	  digit := num1 div 100;
	  if digit > 0 then
	    begin
	      numchr := numchr + 1;
	      logname[numchr] := chr(digit+48);
	      num1 := num1 - (digit*100)
	    end;
	  digit := num1 div 10;
	  if (digit > 0) or (num2 > 99) then
	    begin
	      numchr := numchr + 1;
	      logname[numchr] := chr(digit+48);
	      num1 := num1 - (digit*10)
	    end;
	  digit := num1;
	  numchr := numchr + 1;
	  logname[numchr] := chr(digit+48);

	  numchr := numchr + 1;
	  logname[numchr] := ']'
	end;
      if slow = 0 then logname[0] := chr(i);
    end { if not error }
end; { logical }
                                                                                                                                                                                                                                                                  