procedure rad50(r50:integer; 
	var asc:packed array[slow..shigh:integer] of char);
{ Convert integer to 3 rad50 characters.  The resulting     }
{ characters are returned as the first 3 characters of asc. }
{ This converts from rad50 to ASCII.  Use FSS to convert    }
{ from ASCII to rad50.                                      }
{        1/17/84, 11/12/85 - Paul Haahr/Edward F. Moran     }

  const
    r50tbl = ' ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789: ';
  var
    r50x : 0..65535;

  function trim(x: integer): integer;
    begin { trim }
      if x <= 0 then
	x := x + 42
      else
	x := succ(x);
      trim := x
    end; { trim }

  begin { rad50 }
    r50x := r50;
    asc[1] := r50tbl[trim(r50x div 1600)];
    asc[2] := r50tbl[trim((r50x div 40) mod 40)];
    asc[3] := r50tbl[trim(r50x mod 40)];
    if slow = 0 then
      asc[0] := chr(3)
  end; { rad50 }
                                                                                                                           