procedure showattributes(project, programmer : integer);
{ Modified from SHPRV.PAS (11/8/85 - EFM) to SHWATR.PAS - 1/28/86 - EFM }
{ Modified from SHWATR.PAS to SHWACT.PAS - 2/24/86 - EFM - only difference }
{   being the formatting of the output }
{ New attribute block 205 for first name added 3/4/86 - EFM }
{ New attribute block 206 for class added 3/5/86 - EFM }
{ Grade display added 3/5/86 - EFM - note that this requires that the two   }
{   global variables maxstuprj and minstuprj must be defined as the 7th and }
{   12th grade project numbers, respectively.                               }
  type
    string = packed array [1..13] of char;
    StandardDateStringType = packed array [1..9] of char;
    StandardTimeStringType = packed array [1..8] of char;
  var
    index, error, KBLastLogin, TimeLastLogin, TimeLastPWChg, 
      DateLastLogin, DateLastPWChg, DateAcctCreated, DateAcctExp, DetJobQ,
      TotJobQ, Class, Grade : integer;
    RIBQ, MsgQ, LogOutQ, LogInQ, CurDskUse : real;
    LastLoginNone, LastPWChgNone, KBLastLoginDet, DetJobQUnlim, 
      LogOutQUnlim, LogInQUnlim, TotJobQUnlim, RIBQUnlim, MsgQUnlim, 
      GotStuff : boolean;
    FirstName, LastName : string;
    firqb origin 402b : packed array [0..37b] of -128..127;
    firqb2 origin 402b : packed array [0..37b] of 0..255;
    firqb3 origin 402b : array [0..17b] of 0..65535;
    str origin 413b : string;  { for string data returned in the FIRQB }

  procedure initstuff;
    var
      null : char;
      i : integer;
    begin
      null := chr(0);
      GotStuff := false;
      for i := 1 to 13 do
	FirstName[i] := null;
      for i := 1 to 13 do
	LastName[i] := null;

      LastLoginNone := false;  { initialize some stuff - values may }
      LastPWChgNone := false;  {   be changed later }
      KBLastLoginDet := false;
      DetJobQUnlim := false;
      LogOutQUnlim := false;
      LogInQUnlim := false;
      TotJobQUnlim := false;
      RIBQUnlim := false;
      MsgQUnlim := false;
      KBLastLogin := 0;
      TimeLastLogin := 0;
      TimeLastPWChg := 0;
      DateLastLogin := 0;
      DateLastPWChg := 0;
      DateAcctCreated := 0;
      DateAcctExp := 0;
      DetJobQ := 0;
      TotJobQ := 0;
      RIBQ := 0;
      MsgQ := 0;
      LogOutQ := 0;
      LogInQ := 0;
      CurDskUse := 0;
      Class := 0
    end;  { initstuff }

  function dateconvert(internaldate:integer):StandardDateStringType;
  { Convert internal format date to standard character string of }
  { the form "dd-mmm-yy". }
    var
      datestr origin 412b : StandardDateStringType;
      i : integer;
    begin
      for i := 0 to 37b do
	firqb[i] := 0;    { zero the FIRQB }
      firqb[3b] := 24b;  { uu.cnv }
      firqb3[3b] := -1;  { use alphabetic date format }
      firqb3[2b] := internaldate;
      emt(377b);  { emt }
      emt(66b);  { uuo }
      dateconvert := datestr
    end; { dateconvert }

  function timeconvert(internaltime:integer):StandardTimeStringType;
  { Convert internal format time to standard character string of }
  { the form "hh:mm xM" }
    var
      timestr origin 430b : StandardTimeStringType;
      i : integer;
    begin
      for i := 0 to 37b do
	firqb[i] := 0;    { zero the FIRQB }
      firqb[3b] := 24b;  { uu.cnv }
      firqb3[12b] := -1;  { use AM/PM time format }
      firqb3[11b] := internaltime;
      emt(377b);  { emt }
      emt(66b);  { uuo }
      timeconvert := timestr
    end; { timeconvert }

  procedure getattributes;
    var
      i : integer;
    begin
      writeln;
      writeln('  _SY0:[',project:1,',',programmer:1,']');

      index := 0;
      repeat
	index := index + 1;
	for i := 0 to 37b do
	  firqb[i] := 0;     { zero the FIRQB }
	firqb[3b] := -31b;   { uu.atr }
	firqb[4b] := -1b;    { read acct attributes }
	firqb2[5b] := 0;      { attributetypecode = 0 for look-up by index }
	firqb2[6b] := programmer;
	firqb2[7b] := project;
	firqb2[10b] := index;  

	emt(377b); { emt }
	emt(66b);  { .uuo }

	error := firqb[0];
	case error of
	   0 : ; { no error occurred }
	   5 : writeln('*** Account does not exist ***');
	  10 : writeln('*** Protection violation - insufficient privilege ***');
	  11 : ; { Attribute does not exist (or index too high) }
	  otherwise writeln('*** Error # ',error:1,' in showaccount ***')
	end; { case }

	if error = 0 then
	  begin
	    GotStuff := true;
	    case firqb2[10b] of  { firqb2[10b] is attribute type just read }
	      0 : ;
	      1 : begin
		    if firqb2[11b] = 255
		      then DetJobQUnlim := true
		      else DetJobQ := firqb2[11b];
		    if firqb2[17b] = 255
		      then LogOutQUnlim := true
		      else LogOutQ := 65536.0*firqb2[17b]+firqb3[5b];
		    if firqb2[16b] = 255
		      then LogInQUnlim := true
		      else LogInQ := 65536.0*firqb2[16b]+firqb3[6b];
		    CurDskUse := 65536.0*firqb2[21b]+firqb3[12b]
		  end;
	      2 : begin
		    writeln;
		    write('  Privileges:');
		    if (firqb2[12b] and 1) = 1
		      then write('  Gacnt');
		    if (firqb2[12b] and 2) = 2
		      then write('  Wacnt');
		    if (firqb2[12b] and 4) = 4
		      then write('  Gread');
		    if (firqb2[12b] and 8) = 8
		      then write('  Gwrite');
		    if (firqb2[12b] and 16) = 16
		      then write('  Wread');
		    if (firqb2[12b] and 32) = 32
		      then write('  Wwrite');
		    if (firqb2[12b] and 64) = 64
		      then write('  Dates');
		    if (firqb2[12b] and 128) = 128
		      then write('  Device');
		    if (firqb2[13b] and 1) = 1
		      then write('  Exqta');
		    if (firqb2[13b] and 2) = 2
		      then write('  Hwcfg');
		    if (firqb2[13b] and 4) = 4
		      then write('  Hwctl');
		    if (firqb2[13b] and 8) = 8
		      then write('  Instal');
		    if (firqb2[13b] and 16) = 16
		      then write('  Jobctl');
		    if (firqb2[13b] and 32) = 32
		      then write('  Mount');
		    if (firqb2[13b] and 64) = 64
		      then write('  Pbsctl');
		    if (firqb2[13b] and 128) = 128
		      then write('  Rdmem');
		    if (firqb2[14b] and 1) = 1
		      then write('  User1');
		    if (firqb2[14b] and 2) = 2
		      then write('  User2');
		    if (firqb2[14b] and 4) = 4
		      then write('  User3');
		    if (firqb2[14b] and 8) = 8
		      then write('  User4');
		    if (firqb2[14b] and 16) = 16
		      then write('  User5');
		    if (firqb2[14b] and 32) = 32
		      then write('  User6');
		    if (firqb2[14b] and 64) = 64
		      then write('  User7');
		    if (firqb2[14b] and 128) = 128
		      then write('  User8');
		    if (firqb2[15b] and 1) = 1
		      then write('  Rdnfs');
		    if (firqb2[15b] and 2) = 2
		      then write('  Send');
		    if (firqb2[15b] and 4) = 4
		      then write('  Setpas');
		    if (firqb2[15b] and 8) = 8
		      then write('  Shutup');
		    if (firqb2[15b] and 16) = 16
		      then write('  Swcfg');
		    if (firqb2[15b] and 32) = 32
		      then write('  Swctl');
		    if (firqb2[15b] and 64) = 64
		      then write('  Sysio');
		    if (firqb2[15b] and 128) = 128
		      then write('  Sysmod');
		    if (firqb2[16b] and 1) = 1
		      then write('  Tune');
		    if (firqb2[16b] and 2) = 2
		      then write('  Wrtnfs');
		    if (firqb2[16b] and 4) = 4
		      then write('  Tmpprv');
		    writeln
		  end;
	      3 : ; { password }
	      4 : begin
		    writeln;
		    write('  Attributes:');
		    if (firqb3[6b] and 2048) = 2048
		      then write('  Nopassword_prompt')
		      else write('  Password_prompt  ');
		    if (firqb3[10b] and 2048) = 2048
		      then write('  Nolookup     ')
		      else write('  Lookup       ');
		    if (firqb3[10b] and 4096) = 4096
		      then writeln('  Nodialup')
		      else writeln('  Dialup  ');
		    if (firqb3[10b] and 8192) = 8192
		      then write('               Nonetwork        ')
		      else write('               Network          ');
		    if (firqb3[10b] and 16384) = 16384
		      then write('  Nointeractive')
		      else write('  Interactive  ');
		    if (firqb3[10b] and 32768) = 32768
		      then writeln('  Captive  ')
		      else writeln('  Nocaptive');
		    DateLastLogin := firqb3[5b];
		    TimeLastLogin := firqb3[6b] and 2047;
		    DateLastPWChg := firqb3[7b];
		    TimeLastPWChg := firqb3[10b] and 2047;
		    DateAcctCreated := firqb3[11b];
		    DateAcctExp := firqb3[12b];
		    KBLastLogin := firqb[11b];
		    if DateLastLogin = 0 then LastLoginNone := true;
		    if KBLastLogin = -1 then KBLastLoginDet := true;
		    if DateLastPWChg = 0
		      then LastPWChgNone := true
		  end;
	      5 : LastName := str;
	      6 : begin
		    if firqb[11b] = -1
		      then TotJobQUnlim := true
		      else TotJobQ := firqb[11b];
		    if firqb3[5b] = 65535
		      then RIBQUnlim := true
		      else RIBQ := firqb3[5b];
		    if firqb3[6b] = 65535
		      then MsgQUnlim := true
		      else MsgQ := firqb3[6b]
		  end;
	      201 : ; { in [project,0] holds max prog # }
	      205 : FirstName := str;
	      206 : Class := ord(str[1]);
	      otherwise begin
			  writeln;
			  writeln('Unexpected attribute block type ',
				firqb2[10b]:1,
				' found in GETATTRIBUTES/SHOWATTRIBUTES');
			  writeln('Contents = "',str,'"');
			  writeln
			end
	    end { case }
	  end { if error = 0 }
      until (error<>0)
    end;  { getattributes }

  begin { show attributes }
    initstuff;
    getattributes;
    if gotstuff then
      begin
	writeln;
	write('  Name = "',FirstName,' ',LastName,'"');
	if (project >= minstuprj) and (project <= maxstuprj) 
	  then
	    begin
	      Grade := 7 + (maxstuprj - project);
	      write('        Grade = ',Grade:1)
	    end
	  else
	    write('                 ');
	writeln('         Class = ',Class:1);
	writeln;
	writeln('  Account Created:   ',dateconvert(DateAcctCreated),
	    '             Expires:  ',dateconvert(DateAcctExp));
	writeln;
	write('  Quotas:  Disk usage   - Logged out:');
	if LogOutQUnlim
	  then write(' Unlimited')
	  else write(LogOutQ:10:0);
	write('   Logged in:');
	if LogInQUnlim
	  then writeln(' Unlimited')
	  else writeln(LogInQ:10:0);
	write('           Job limits   -   Detached:');
	if DetJobQUnlim
	  then write(' Unlimited')
	  else write(DetJobQ:10);
	write('       Total:');
	if TotJobQUnlim
	  then writeln(' Unlimited')
	  else writeln(TotJobQ:10);
	write('           Send/Receive -        RIB:');
	if RIBQUnlim
	  then write(' Unlimited')
	  else write(RIBQ:10:0);
	write('     Message:');
	if MsgQUnlim
	  then writeln(' Unlimited')
	  else writeln(MsgQ:10:0);
	writeln;
	writeln('  Current disk blocks allocated:  ',CurDskUse:5:0);
	writeln;
	write('           Last password change');
	if LastPWChgNone
	  then writeln(':  None')
	  else writeln(' on ',dateconvert(DateLastPWChg),' at ',
			    timeconvert(TimeLastPWChg));
	write('           Last login');
	if LastLoginNone
	  then writeln(':  None')
	  else
	    begin
	      if KBLastLoginDet
		then write(' (detached)')
		else write(' on _KB',KBLastLogin:1,':');
	      writeln(' on ',dateconvert(DateLastLogin),' at ',
			    timeconvert(TimeLastLogin))
	    end
      end { if gotstuff }
  end;  { show attributes }
                                                                                                                                                                                                                                                                                                                                                                                                  