procedure showattributes(project, programmer : integer);
{ Modified from SHPRV.PAS (11/8/85 - EFM) - 1/28/86 - EFM }
  type
    string = packed array [1..13] of char;
    StandardDateStringType = packed array [1..9] of char;
    StandardTimeStringType = packed array [1..8] of char;
  var
    i, index, error, kbnum, time1, time2, date1, date2, date3, date4 : integer;
    firqb origin 402b : packed array [0..37b] of -128..127;
    firqb2 origin 402b : packed array [0..37b] of 0..255;
    firqb3 origin 402b : array [0..17b] of 0..65535;
    str origin 413b : string;  { for string data returned in the FIRQB }

  function dateconvert(internaldate:integer):StandardDateStringType;
  { Convert internal format date to standard character string of }
  { the form "dd-mmm-yy". }
    var
      datestr origin 412b : StandardDateStringType;
      i : integer;
    begin
      for i := 0 to 37b do
	firqb[i] := 0;    { zero the FIRQB }
      firqb[3b] := 24b;  { uu.cnv }
      firqb3[3b] := -1;  { use alphabetic date format }
      firqb3[2b] := internaldate;
      emt(377b);  { emt }
      emt(66b);  { uuo }
      dateconvert := datestr
    end; { dateconvert }

  function timeconvert(internaltime:integer):StandardTimeStringType;
  { Convert internal format time to standard character string of }
  { the form "hh:mm xM" }
    var
      timestr origin 430b : StandardTimeStringType;
      i : integer;
    begin
      for i := 0 to 37b do
	firqb[i] := 0;    { zero the FIRQB }
      firqb[3b] := 24b;  { uu.cnv }
      firqb3[12b] := -1;  { use AM/PM time format }
      firqb3[11b] := internaltime;
      emt(377b);  { emt }
      emt(66b);  { uuo }
      timeconvert := timestr
    end; { timeconvert }

begin
    index := 0;
    repeat
      index := index + 1;
      for i := 0 to 37b do
	firqb[i] := 0;     { zero the FIRQB }
      firqb[3b] := -31b;   { uu.atr }
      firqb[4b] := -1b;    { read acct attributes }
      firqb[5b] := 0;      { attributetypecode = 0 for look-up by index }
      firqb2[6b] := programmer;
      firqb2[7b] := project;
      firqb2[10b] := index;  

      emt(377b); { emt }
      emt(66b);  { .uuo }

      error := firqb[0];
      case error of
	 0 : ; { no error occurred }
	 5 : writeln('*** Account does not exist ***');
	10 : writeln('*** Protection violation - insufficient privilege ***');
	11 : ; { Attribute does not exist (or index too high) }
	otherwise writeln('*** Error # ',error:1,' in showaccount ***')
      end; { case }

      if error = 0 then
	begin
	  case firqb[10b] of  { firqb[10b] is attribute type just read }
	    0 : ;
	    1 : begin
		  if firqb2[11b] = 255
		    then writeln('  Detached job quota = UNLIMITED')
		    else writeln('  Detached job quota = ',firqb2[11b]:1);
		  if firqb2[17b] = 255
		    then writeln('  Logged out quota = UNLIMITED')
		    else writeln('  Logged out quota = ',
			  65536.0*firqb2[17b]+firqb3[5b]:1:0);
		  if firqb2[16b] = 255
		    then writeln('  Logged in quota = UNLIMITED')
		    else writeln('  Logged in quota = ',
			  65536.0*firqb2[16b]+firqb3[6b]:1:0);
		  writeln('  Current disk usage = ',
			  65536.0*firqb2[21b]+firqb3[12b]:1:0)
		end;
	    2 : begin
		  write('  Privileges:');
		  if (firqb2[12b] and 1) = 1
		    then write('  Gacnt');
		  if (firqb2[12b] and 2) = 2
		    then write('  Wacnt');
		  if (firqb2[12b] and 4) = 4
		    then write('  Gread');
		  if (firqb2[12b] and 8) = 8
		    then write('  Gwrite');
		  if (firqb2[12b] and 16) = 16
		    then write('  Wread');
		  if (firqb2[12b] and 32) = 32
		    then write('  Wwrite');
		  if (firqb2[12b] and 64) = 64
		    then write('  Dates');
		  if (firqb2[12b] and 128) = 128
		    then write('  Device');
		  if (firqb2[13b] and 1) = 1
		    then write('  Exqta');
		  if (firqb2[13b] and 2) = 2
		    then write('  Hwcfg');
		  if (firqb2[13b] and 4) = 4
		    then write('  Hwctl');
		  if (firqb2[13b] and 8) = 8
		    then write('  Instal');
		  if (firqb2[13b] and 16) = 16
		    then write('  Jobctl');
		  if (firqb2[13b] and 32) = 32
		    then write('  Mount');
		  if (firqb2[13b] and 64) = 64
		    then write('  Pbsctl');
		  if (firqb2[13b] and 128) = 128
		    then write('  Rdmem');
		  if (firqb2[14b] and 1) = 1
		    then write('  User1');
		  if (firqb2[14b] and 2) = 2
		    then write('  User2');
		  if (firqb2[14b] and 4) = 4
		    then write('  User3');
		  if (firqb2[14b] and 8) = 8
		    then write('  User4');
		  if (firqb2[14b] and 16) = 16
		    then write('  User5');
		  if (firqb2[14b] and 32) = 32
		    then write('  User6');
		  if (firqb2[14b] and 64) = 64
		    then write('  User7');
		  if (firqb2[14b] and 128) = 128
		    then write('  User8');
		  if (firqb2[15b] and 1) = 1
		    then write('  Rdnfs');
		  if (firqb2[15b] and 2) = 2
		    then write('  Send');
		  if (firqb2[15b] and 4) = 4
		    then write('  Setpass');
		  if (firqb2[15b] and 8) = 8
		    then write('  Shutup');
		  if (firqb2[15b] and 16) = 16
		    then write('  Swcfg');
		  if (firqb2[15b] and 32) = 32
		    then write('  Swctl');
		  if (firqb2[15b] and 64) = 64
		    then write('  Sysio');
		  if (firqb2[15b] and 128) = 128
		    then write('  Sysmod');
		  if (firqb2[16b] and 1) = 1
		    then write('  Tune');
		  if (firqb2[16b] and 2) = 2
		    then write('  Wrtnfs');
		  if (firqb2[16b] and 4) = 4
		    then write('  Tmpprv');
		  writeln
		end;
	    3 : ; { password }
	    4 : begin
		  if (firqb3[6b] and 2048) = 2048
		    then write('  Nopassword_prompt')
		    else write('  Password_prompt');
		  if (firqb3[10b] and 2048) = 2048
		    then write('  Nolookup')
		    else write('  Lookup');
		  if (firqb3[10b] and 4096) = 4096
		    then write('  Nodialup')
		    else write('  Dialup');
		  if (firqb3[10b] and 8192) = 8192
		    then write('  Nonetwork')
		    else write('  Network');
		  if (firqb3[10b] and 16384) = 16384
		    then write('  Nointeractive')
		    else write('  Interactive');
		  if (firqb3[10b] and 32768) = 32768
		    then writeln('  Captive')
		    else writeln('  Nocaptive');
		  date1 := firqb3[5b];           { we have to save all this  }
		  time1 := firqb3[6b] and 2047;  { because the dateconvert   }
		  date2 := firqb3[7b];           { and timeconvert functions }
		  time2 := firqb3[10b] and 2047; { used below would destroy  }
		  date3 := firqb3[11b];          { the info in the FIRQB     }
		  date4 := firqb3[12b];
		  kbnum := firqb[11b];
		  write('  Last login:');
		  if date1 = 0
		    then writeln('  NONE')
		    else
		      begin
			write('  ',dateconvert(date1),', ',timeconvert(time1));
			if kbnum = -1
			  then writeln(', KB = DETACHED')
			  else writeln(', on KB',kbnum:1,':');
		      end;
		  if date2 = 0
		    then writeln('  Last password change = NONE')
		    else writeln('  Last password change = ',
			      dateconvert(date2),' ',timeconvert(time2));
		  write('  Account created:  ',dateconvert(date3));
		  writeln('     Account expires:  ',dateconvert(date4))
		end;
	    5 : writeln('  Name = "',str,'"');
	    6 : begin
		  if firqb[11b] = -1
		    then write('  Total job quota = UNLIMITED')
		    else write('  Total job quota = ',firqb[11b]:1);
		  if firqb3[5b] = 65535
		    then write('   RIB quota = UNLIMITED')
		    else write('   RIB quota = ',firqb3[5b]:1);
		  if firqb3[6b] = 65535
		    then writeln('   Message quota = UNLIMITED')
		    else writeln('   Message quota = ',firqb3[6b]:1)
		end;
	    otherwise
	  end { case }
	end { if error = 0 }
    until (error<>0)
  end;  { showattributes }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                     