{ PLIB:STR.PAS }

{ String routines - ?/86 - 2/87 - EFM }
{ Contents:
    procedure fillinstring(outstring,startpos,instring);
    procedure initstring(string);
    function integerto6charstring(integer):sixcharstring;
    function stringtointeger(string):integer;             }

type
  sixcharstring = packed array [1..6] of char;

procedure fillinstring(var outstring : packed array [lowo..higho:integer] 
                         of char; var startpos : integer;
                         instring : packed array [lowi..highi:integer] of char);
{ copy instring into outstring, starting at startpos, and set startpos to }
{   next available position }
{ only works for [1..n] strings? }
  var
    i : integer;
  begin
    for i := lowi to highi do
      outstring[startpos + (i-1)] := instring[i];
    startpos := startpos + highi
  end;  { fillinstring }


procedure initstring(var str : packed array [low..high:integer] of char);
  var
    i : integer;
    null : char;
  begin
    null := chr(0);
    for i := low to high do
      str[i] := null
  end;  { initstring }


function integerto6charstring(numb : integer):sixcharstring;
  var
    i, j, power, digit, pos : integer;
    zerovalid : boolean;
    temp : sixcharstring;
    null : char;
  begin
    null := chr(0);
    for i := 1 to 6 do
      temp[i] := null;
    zerovalid := false; { so we can ignore leading zeros }
    pos := 0; { character position within string }
    if numb < 0 then
      begin
	pos := pos + 1;
	temp[pos] := '-';
	numb := abs(numb)
      end;
    for i := 1 to 5 do
      begin
	power := 1;
	for j := 5 downto i+1 do
	  power := power * 10;
	digit := (numb div power) mod 10;
	if (digit <> 0) or (i = 5) then zerovalid := true;  { any further zeros
								are needed }
	if (digit <> 0) or (zerovalid) then
	  begin
	    pos := pos + 1;
	    temp[pos] := chr(digit + 48)
	  end
       end;
    integerto6charstring := temp
  end;  { integerto6charstring }


function stringtointeger(str:packed array[low..high:integer] of char):integer;
  var
    i, temp : integer;
  begin
    temp := 0;
    for i := low to high do
      if str[i] in ['0'..'9'] then
	temp := temp * 10 + ord(str[i]) - 48;
    stringtointeger := temp
  end;  { stringtointeger }
                                                                                                                                                                                                                                                