{ Contents:                                                                 }
{ terminaltype - a function to return the terminal type code number for the }
{    current terminal - type := terminaltype(0) - or (if privileged) for    }
{    KBn: - type := terminaltype(n)                                         }
{ terminalclass - a function to return the terminal class code number for   }
{    the current terminal - class := terminalclass(0) - or (if privileged)  }
{    for KBn: - class := terminalclass(n)              - 11/25/85 - EFM     }

{ Last modified 7/28/87 to include VT330 & VT340 terminals - EFM }

{ Possible terminal classes include:	}
{	  1  unknown			}
{	  2  VT52 type			}
{	  3  VT100/VT200/VT300 type	}
{	  4  printer			}
{	  5  EMULATOR			}

{ Possible terminal types include:	}
{	  1  unknown			}
{	  2  LA36			}
{	  3  VT52			}
{	  6  VT100			}
{	  7  LA120			}
{	 12  LA50			}
{	 18  VT220			}
{	 19  VT240			}
{	 20  VT241			}
{	 48  VT330			}
{	 49  VT340			}
{	129  PK				}
{	130  Z19			}
{	131  Z29			}
{	132  EMULATOR			}
{	133  DIABLO			}
{	134  PAPER TIGER		}
{	135  HOUSE DIALUP		}
{	136  DIALUP			}
{	137  LIBRARY EMULATOR		}
{	138  AD				}
{	139  PLOT			}
{	140  PAD			}
{	141  SOUND			}
{	142  SAM			}

{$nodebug}
function terminaltype(kbnum:integer):integer;
var
  firqb origin 402b : packed array [0..37b] of 0..255;
  i : integer;
begin
  for i := 0 to 37b do
    firqb[i] := 0;      { clear firqb }
  firqb[3] := 20b;      { uu.trm }
  firqb[4] := 1;        { subfunction }
  if kbnum = 0
    then firqb[5] := 377b
    else firqb[5] := kbnum;
  emt(377b);
  emt(66b);
  terminaltype := firqb[6]
end;
{$debug}

function terminalclass(kbnum:integer):integer;
var
  i : integer;
begin
  i := terminaltype(kbnum);
  case i of
      1 : terminalclass := 1;
      2 : terminalclass := 4;
      3 : terminalclass := 2;
      6 : terminalclass := 3;
      7 : terminalclass := 4;
     12 : terminalclass := 4;
     18 : terminalclass := 3;
     19 : terminalclass := 3;
     20 : terminalclass := 3;
     48 : terminalclass := 3;
     49 : terminalclass := 3;
    129 : terminalclass := 1;
    130 : terminalclass := 2;
    131 : terminalclass := 3;
    132 : terminalclass := 5;
    133 : terminalclass := 4;
    134 : terminalclass := 4;
    135 : terminalclass := 1;
    136 : terminalclass := 1;
    137 : terminalclass := 5;
    138 : terminalclass := 1;
    139 : terminalclass := 1;
    140 : terminalclass := 1;
    141 : terminalclass := 1;
    142 : terminalclass := 1;
    otherwise terminalclass := 1
  end { case }
end;
                                                                                                                                                                                                                                                                                                                                                                                                                        