
{ ttyset - set terminal characteristics                                   }
{   4/26/85 - 4/30/85 - EFM                                               }
{ Use:  ttyset(kb,cmnd,param)                                             }
{   where kb is the kb number or zero for current kb                      }
{         cmnd may be any of the commands listed in the type statement    }
{            below - don't use quotes                                     }
{         param is zero unless required by some commands (e.g. width n)   }
{  For the baud rates, either the code or the actual speed may be used.   }
{    ttyset(0,speed,12) and ttyset(0,speed,2400) both set the current     }
{    kb to 2400 baud.  Speed 134.5 must be entered as 134 (an integer).   }

{$nodebug}
type
  terminal_setting = (width, tab, notab, noform, form, lcout, nolcout, 
      noxon, xon, fullduplex, localecho, nolcin, lcin, noscope, scope, 
      nofill, fill, baud, speed, noparity, evenparity, parityeven, 
      oddparity, parityodd, nostall, stall, uparrow, nouparrow, dh11, 
      ring, noescseq, escseq, nodelimiter, delimiter, noesc, esc, ctrlr, 
      ctrlt, noctrlr, noctrlc, resumeany, resumectrlc, nobreak, 
      break, nogag, broadcast, gag, nobroadcast);

procedure ttyset(kbnum : integer; command : terminal_setting; 
                    parameter : integer);
{ 4/85 - EFM - set terminals from Pascal }
var
  firqb origin 402B: packed array [0..37B] of 0..255;
  i : integer;
begin
  for i := 0 to 37B do
    firqb[i] := 0;    { zero the firqb }
  firqb[3] := 16;     { UU.TRM }
  if kbnum = 0
    then firqb[5] := 377B
    else firqb[5] := kbnum;
  case command of
    width : firqb[6] := parameter + 1;
    tab : firqb[7] := 200B;
    notab : firqb[7] := 377B;
    noform : firqb[10B] := 200B;
    form : firqb[10B] := 377B;
    lcout : firqb[11B] := 200B;
    nolcout : firqb[11B] := 377B;
    noxon : firqb[12B] := 200B;
    xon : firqb[12B] := 377B;
    fullduplex : firqb[13B] := 200B;
    localecho : firqb[13B] := 377B;
    noscope : firqb[14B] := 200B;
    scope : firqb[14B] := 377B;
    nolcin : firqb[15B] := 200B;
    lcin : firqb[15B] := 377B;
    nofill : firqb[16B] := 1;
    fill : firqb[16B] := parameter + 1;
    speed, baud : 
        begin
          if parameter = 0 
            then firqb[17B] := 1
            else
              if parameter < 20 
                then firqb[17B] := parameter
                else
                  case parameter of
                    50 : firqb[17B] := 2;
                    75 : firqb[17B] := 3;
                    110 : firqb[17B] := 4;
                    134 : firqb[17B] := 5;
                    150 : firqb[17B] := 6;
                    otherwise
                      begin
                        emt(377B); { rsts }
                        emt(66B); { .UUO to get current settings }
                        if firqb[24B] = 12 then { a DH line }
                          if parameter = 200 then firqb[17B] := 7
                          else if parameter = 300 then firqb[17B] := 8
                          else if parameter = 600 then firqb[17B] := 9
                          else if parameter = 1200 then firqb[17B] := 10
                          else if parameter = 1800 then firqb[17B] := 11
                          else if parameter = 2400 then firqb[17B] := 12
                          else if parameter = 4800 then firqb[17B] := 13
                          else if parameter = 9600 then firqb[17B] := 14;
                        if firqb[24B] = 14 then { a DZ line }
                          if parameter = 300 then firqb[17B] := 7
                          else if parameter = 600 then firqb[17B] := 8
                          else if parameter = 1200 then firqb[17B] := 9
                          else if parameter = 1800 then firqb[17B] := 10
                          else if parameter = 2000 then firqb[17B] := 11
                          else if parameter = 2400 then firqb[17B] := 12
                          else if parameter = 3600 then firqb[17B] := 13
                          else if parameter = 4800 then firqb[17B] := 14
                          else if parameter = 7200 then firqb[17B] := 15
                          else if parameter = 9600 then firqb[17B] := 16;
                        for i := 0 to 16B do firqb[i] := 0; { rezero firqb }
                        for i := 20B to 37B do firqb[i] := 0;
                        firqb[3] := 16;  { UU.TRM }
                        if kbnum = 0
                          then firqb[5] := 377B
                          else firqb[5] := kbnum
                      end
                  end { case }
        end;
    noparity : firqb[20B] := 1;
    evenparity : firqb[20B] := 2;
    oddparity : firqb[20B] := 3;
    nostall : firqb[22B] := 200B;
    stall : firqb[22B] := 377B;
    uparrow : firqb[23B] := 200B;
    nouparrow : firqb[23B] := 377B;
    dh11 : firqb[25B] := 0;  { ??? }
    ring : firqb[26B] := 377B;
    noescseq : firqb[27B] := 200B;
    escseq : firqb[27B] := 377B;
    nodelimiter : firqb[30B] := 200B;
    delimiter : firqb[30B] := 200B + parameter;
    noesc : firqb[31B] := 200B;
    esc : firqb[31B] := 377B;
    noctrlr, noctrlc : firqb[32B] := 200B;
    ctrlr, ctrlt : firqb[32B] := 377B;
    resumectrlc : firqb[33B] := 200B;
    resumeany : firqb[33B] := 377B;
    nobreak : firqb[34B] := 200B;
    break : firqb[34B] := 377B;
    broadcast, nogag : firqb[35B] := 200B;
    nobroadcast, gag: firqb[35B] := 377B
  end; { case }
  emt(377B); { rsts }
  emt(66B) { .UUO }
end;  { ttyset }
{$debug}
                                                                                                                                                                                                                                                                                                                                                                                                                                                         