; File MSSDEF.H
        .xlist                  ; suppress listing in program
        .sall                   ; don't list macro expansions
verdef  macro
        db      ' Kermit-MS: V2.30  8 Jan 1988'
        endm

BELL    EQU     07H
TAB     EQU     09H
LF      EQU     0AH
FF      EQU     0CH
CR      EQU     0DH
XON     EQU     11H
XOFF    EQU     13H
ESCAPE  EQU     1BH
DEL     EQU     7FH
BS      EQU     08H
CTLZ    EQU     1AH
SOH     EQU     01H     ; Start of header char.
SPC     EQU     20H

DOS     EQU     21H

CONIN   EQU     01H
CONOUT  EQU     02H
RDRIN   EQU     03H
PUNOUT  EQU     04H
LSTOUT  EQU     05H
DCONIO  EQU     06H
CONINQ  EQU     07H     ; quiet console input
PRSTR   EQU     09H
CONSTAT EQU     0BH
SELDSK  EQU     0EH     ; Select disk.
GCURDSK EQU     19H     ; Current disk.
SETDMA  EQU     1AH
GETTIM  EQU     2CH     ; Get the time of day.
DOSVER  EQU     30H     ; dos version #
GSWITCH EQU     37H     ; undocumented get/set switch character
CHDIR   EQU     3BH     ; change directory
CREAT2  EQU     3CH     ; 2.0 create [jrd]
OPEN2   EQU     3DH     ; 2.0 open
CLOSE2  EQU     3EH     ; 2.0 close
READF2  EQU     3FH     ; 2.0 read.
WRITE2  EQU     40H     ; 2.0 write
DEL2    EQU     41H     ; 2.0 delete
LSEEK   EQU     42H     ; 2.0 lseek
CHMOD2  EQU     43H     ; 2.0 chmod
IOCTL   EQU     44H
GCD     EQU     47H     ; 2.0 get current directory.
ALLOC   EQU     48H     ; allocate memory
FREEMEM EQU     49H     ; free memory
SETBLK  EQU     4AH     ; modify allocated memory map
EXEC    EQU     4BH     ; 2.0 execute task
FIRST2  EQU     4EH     ; 2.0 search for first
NEXT2   EQU     4FH     ; 2.0 search for next


PAREVN  EQU     00      ; Even parity.
PARMRK  EQU     01      ; Mark parity.
PARNON  EQU     02      ; No parity.
PARODD  EQU     03      ; Odd parity.
PARSPC  EQU     04      ; Space parity.

CMKEY   EQU     01      ; Parse a keyword.
CMCFM   EQU     04      ; Parse a confirm.
CMTXT   EQU     05      ; Parse arbitrary text up to CR.
CMFILE  EQU     06      ; parse string surrounded by whitespace. [jrd]

FLOXON  EQU     1113H   ; Use XON/XOFF for flow control.
FLONON  EQU     0       ; Don't do flow control.
DEFHAND EQU     XON     ; Use XON as default handshake.

                        ; flags.remflg byte definitions.
DQUIET  EQU     1       ; Display mode, suppress file xfer statistics
DREGULAR EQU    2       ; Regular formatted screen display of statistics
DSERIAL EQU     4       ; Serial mode (non-formatted screen)
D8BIT   EQU     8       ; Display chars as 8-bit vs 7-bit quantities
DSERVER EQU     10H     ; Server mode active, if this bit is set

MAXTAK  EQU     5       ; Max number of TAKE's allowed.
DEFMXTRY EQU    5       ; default number of retries on a data packet (63 max).
                        ; Init packet gets three times this number of tries.

DEFESC  EQU     1DH     ; The default escape character (Control rt sq bracket)
DRPSIZ  EQU     94      ; Default receive packet size, regular pkts.
DSPSIZ  EQU     94      ; Default send packet size, regular pkts.
DSTIME  EQU     08      ; Default send time out interval.
DRTIME  EQU     13      ; Default receive time out interval.
DSRVTM  EQU     30      ; Default server timeout.
DSPAD   EQU     0       ; Default send padding.
DRPAD   EQU     0       ; Default receive padding.
DSPADC  EQU     0       ; Default send padding char.
DRPADC  EQU     0       ; Default receive padding char.
DSEOL   EQU     CR      ; Default send EOL char.
DREOL   EQU     CR      ; Default receive EOL char.
DSSOH   EQU     SOH     ; Default send start-of-packet char.
DRSOH   EQU     SOH     ; Default receive start-of-packet char.
DSQUOT  EQU     23H     ; Default send quote char.
DRQUOT  EQU     23H     ; Default receive quote char.
DQBIN   EQU     26H     ; Default 8-bit prefix.
DRPT    EQU     7EH     ; Default repeat prefix.
DCHKLEN EQU     1       ; Default checksum length.
DEFPAR  EQU     PARNON  ; Default parity (none.)
IBMPAR  EQU     PARMRK  ; IBM's parity (mark.)

maxpack equ     1000    ; max packet length. Sets buffer sizes, capabilities.
bufsiz  equ     1536    ; size of serial port input buffer
buffsz  equ     512     ; size of disk file i/o buffer (buff). [jrd]
cptsiz  equ     256     ; size of session capture buffer. [jrd]
DMASIZ  EQU     80H     ; Size of DMA.

portmax equ     4       ; # of serial ports

; baud rate definitions
B00455  EQU     0       ; 45.5 baud
B0050   EQU     1       ; 50 baud
B0075   EQU     2       ; 75 baud
B0110   EQU     3       ; 110 baud
B01345  EQU     4       ; 134.5 baud
B0150   EQU     5       ; 150 baud
B0300   EQU     6       ; 300 baud
B0600   EQU     7       ; 600 baud
B1200   EQU     8       ; 1200 baud
B1800   EQU     9       ; 1800 baud
B2000   EQU     10      ; 2000 baud
B2400   EQU     11      ; 2400 baud
B4800   EQU     12      ; 4800 baud
B9600   EQU     13      ; 9600 baud
B19200  EQU     14      ; 19200 baud
B38400  EQU     15      ; 38400 baud
B57600  EQU     16      ; 57600 baud
B115200 EQU     17      ; 115200 baud
BAUDSIZ EQU     18      ; Number of options for baud rate.

                        ; bit defs for flags.capflg (LOG command).
logoff  equ     0       ; Off = no or suspended logging
logdeb  equ     1       ; log debugging (not yet imp)
logpkt  equ     2       ; log packets sent/received
logses  equ     4       ; log connect mode session
logtrn  equ     8       ; log (file) transaction (n.y.i.)

; Terminal emulator section

; Kinds of terminals available; VT52 and VT100 for IBM & clones only.
ttgenrc equ     0               ; Type 0: no emulation done by Kermit
ttheath equ     1               ; Type 1: Heath-19
ttvt52  equ     2               ; Type 2: VT52
ttvt100 equ     3               ; Type 3: ANSI (VT102 subset)
tttek   equ     4               ; Type 4: Tektronix 4010
TTTYPES equ     5               ; Number of terminal types defined

; VT100 status flags
anslnm  equ     01H                     ; ANSI line feed/new line mode
decckm  equ     02H                     ; VT100 cursor keys mode
deckpam equ     04H                     ; VT100 keypad application mode
decscnm equ     08H                     ; VT100 screen mode (n.y.i.)
decom   equ     10H                     ; VT100 origin mode
decawm  equ     20H                     ; VT100 autowrap mode
decanm  equ     40H                     ; ANSI(VT100)/VT52 mode
decmode equ     80H                     ; "?" seen in lead-in

; VT100 SETUP mode flags (bit field in a byte)
vsscreen        equ     40H             ; Screen (0 = normal, 1 = rev. video)
vscursor        equ     20H             ; Cursor (0 = block, 1 = underline)
vsmarginbell    equ     10H             ; Margin bell (0 = off)
vskeyclick      equ     08H             ; Keyclick (0 = off)
vsshift3        equ     04H             ; Shift-3 (0 = American pound sign #)
vswrap          equ     02H             ; Line wrap around (0 = no wrap)
vsnewline       equ     01H             ; ANSI new line (0 = off)

; VT100 defaults for SETUP
; Note: Tab stops default to columns 9, 17, 25, 33, 41, 49, 57, 65, & 73.
; Adjust them via Set Term Tabs.
;
; VSDEFAULTS holds Kermit startup time settings for the VT100 emulator.
; Configure it by adding together names from the setup mode flags above
; to turn on features (they default to being off if not mentioned).
; Set the kind of terminal by placing a ttxxxx name in VTFLGS in the
; FLGINFO structure well below.

vsdefaults      equ     0+vscursor      ; + your favorite conditions.

emulst  struc                   ; structure for terminal emulator global data
vtflgst db      0               ; VT100 setup flags
vtflgop db      0               ; VT100 runtime flags, like setup flags
vttbs   dw      0               ; pointer to default tab stops
vttbst  dw      0               ; pointer to tab stops (both in mszibm)
att_ptr dw      0               ; pointer to video attributes: nor, rev
emulst  ends
; end of terminal emulator section

; Structure definitions.

; Modem information.
mdminfo struc
mddat   dw 0            ; Default to port 1.
mdstat  dw 0            ; Ditto.
mdcom   dw 0            ; Here too.
mden    db 0
mddis   db 0
mdmeoi  db 0
mdintv  dw 0
mdminfo ends

; Command information.
cmdinfo struc
cmstat  db 0            ; What is presently being parsed.
cmaflg  db 0            ; Non-zero when an action char has been found.
cmccnt  db 0            ; Non-zero if a significant char is found.
cmsflg  db 0            ; Non-zero when the last char was a space.
cmostp  dw 0            ; Old stack pointer for reparse.
cmrprs  dw 0            ; Address to go to on reparse.
cmprmp  dw 0            ; Address of prompt.
cmptab  dw 0            ; Address of present keyword table.
cmhlp   dw 0            ; Address of present help.
cmdbuf  db 80H DUP(0)   ; Buffer for command parsing.
cmcptr  dw 0            ; Pointer for next char input.
cmdptr  dw 0            ; Pointer into the command buffer.
cmsiz   dw 0            ; Size info of user input.
cmkptr  dw 0            ; Pointer to keyword.
cmsptr  dw 0            ; Place to save a pointer.
cmchr   db 0            ; Save char when checking ambiguity.
cmrflg  db 0            ; Assume parsing filename for send.
cmcr    db 0            ; Say whether bare CR is allowed.
cmquiet db 0            ; non-zero for no echoing...
cmdinfo ends

; Flags information.
flginfo struc
belflg  db 1            ; Use bell
comflg  db 1            ; Use COM1 by default.
abfflg  db 1            ; Discard incoming file if abort.
debug   db 0            ; Debugging mode (default off).
flwflg  db 1            ; File warning flag (default on).
ibmflg  db 0            ; IBM flag (default off).
extflg  db 0            ; Exit flag (default off).
vtflg   db ttvt100      ; term emulation (0=none, 1=Heath19, 2=VT52, 3=VT100)
nmoflg  db 0            ; Override name from the F packet.
cxzflg  db 0            ; ^X/^Z to interrupt file x-fer.
xflg    db 0            ; Seen "X" packet.
filflg  db 0            ; Non-zero when nothing in DMA buffer.
eoflag  db 0            ; EOF flag; non-zero on EOF.
getflg  db 0            ; Assume normal RECEIVE (not GET).
capflg  db 0            ; On if capturing data.
takflg  db 0            ; On if echoing commands of TAKE file.
timflg  db 1            ; Say if are timing out or not. [jrd]
destflg db 1            ; Incoming files destination: disk or printer.
eofcz   db 0            ; ^Z signals eof if non-zero.
remflg  db DREGULAR     ; server (remote) mode plus display flag bits
modflg  db 1            ; non-zero if mode line on.
wrpflg  db 0            ; non-zero if line wrap is to be done
flginfo ends

; Transmission parameters
trinfo  struc
maxdat  dw 0            ; Max packet size for send, word for long packets
chklen  db 1            ; Number of characters in checksum.
seol    db dseol        ; Send EOL char.
reol    db dreol        ; Receive EOL char.
ssoh    db dssoh        ; Send start-of-packet character.
rsoh    db drsoh        ; Receive start-of-packet character.
squote  db dsquot       ; Send quote character.
rquote  db drquot       ; Receive quote character.
spsiz   db dspsiz       ; Send packet size.
rpsiz   db drpsiz       ; Receive packet size.
stime   db dstime       ; Send timeout. (Don't timeout).
rtime   db drtime       ; Receive timeout.
sdelay  db 0            ; Send delay time (sec) for just SEND command.
spad    db dspad        ; Send padding.
rpad    db drpad        ; Receive padding.
spadch  db dspadc       ; Send padding char.
rpadch  db drpadc       ; Receive padding char.
ebquot  db 'Y'          ; Send 8-bit quote character.
escchr  db defesc       ; Escape character.
                        ; new fields for long packets
capas   db 2            ; Capas byte, just long packets, needs a name.
windo   db 0            ; window size (not used, yet)
lentyp  dw 3            ; packet length type (3=regular, 0=long, 1=extra long)
rlongp  dw drpsiz       ; long pkt size we want to receive
slongp  dw maxpack      ; long pkt size we could send (negotiated with host)
slong   dw maxpack      ; longest pkt size we will send, from Set Send Pkt
trinfo  ends

pktinfo struc
pktnum  dw 0            ; Packet number.
numpkt  dw 0            ; Total number of packets sent.
numrtr  dw 0            ; Total number of retries.
numtry  db 0            ; Number of tries on this packet.
state   db 0            ; Present state of the automaton.
argblk  dw 0            ; For subroutine arguments. packet SEQ number
argbk1  dw 0            ; length of data field in a packet
argbk2  dw 0
argbk3  dw 0            ; packet length type (3=regular, 0=long, 1=extra long)
pktinfo ends

filest  struc           ; [jrd]
handle  dw 0            ; DOS 2.0 file handle
string  db 64 dup(0)    ; complete filename string, including drive and path
dta     db 26 dup(0)    ; 21 resev'd bytes, file attr, 2 each date & time
sizelo  dw 0            ; file size, 4 bytes, part of dta
sizehi  dw 0
fname   db 13 dup(0)    ; filename, asciiz, with dot, part of dta
fstat   db 0            ; status of Find First DOS call
filest  ends

takinfo struc
taktyp  db 0            ; type: 0feH=valid file handle, 0ffH=a macro [jrd]
takhnd  dw 0            ; file handle [jrd]
takbuf  db dmasiz dup(0)
takptr  dw 0
takchl  db 0
takcnt  dw 0,0
takinfo ends

; Port Information.
prtinfo struc
baud    dw 0            ; Default baud rate.
ecoflg  db 0            ; Local echo flag (default off).
parflg  db 0            ; Parity flag (default none.)
floflg  db 0            ; If need flow control during file x-fer.
hndflg  db 0            ; If need handshake during file x-fer.
hands   db 0            ; Default handshake.
flowc   dw 0            ; Do flow control with XON/XOFF.
prtinfo ends


statinfo struc                  ; statistics, basic information layout
prbyte  dw      2 dup (0)       ; number of bytes received by port
psbyte  dw      2 dup (0)       ; number of bytes sent to port
frbyte  dw      2 dup (0)       ; bytes received
fsbyte  dw      2 dup (0)       ; bytes sent
prpkt   dw      2 dup (0)       ; number of packets received
pspkt   dw      2 dup (0)       ; number of packets sent
nakrcnt dw      0               ; count of naks received
nakscnt dw      0               ; count of naks sent
btime   dw      2 dup (0)       ; start time (seconds) of transfer
etime   dw      2 dup (0)       ; elapsed time (seconds) of transfer
statinfo ends


mkeyw   macro   key,val
        local   junk,oldval
oldval  equ     $
        db      junk,key,'$'
junk    equ     $-oldval-2
        dw      val
        endm


; definitions for terminal handler:

termarg struc
flgs    db 0            ; flags
prt     db 0            ; port to use (0,1)
cols    db 0            ; # columns on screen
rows    db 0            ; # rows on screen
captr   dw 0            ; routine to call with captured data
belld   dw 0            ; bell divisor
klen    dw 0            ; length of key redefinition table
ktab    dw 0            ; address of key redefinition table
krpl    dw 0            ; address of key replacement table
escc    db 0            ; escape character
baudb   db 0            ; baud rate bits.
parity  db 0            ; parity
termarg ends

; bits for flag byte
scrsam  equ 80h         ; on if shouldn't redraw screen
capt    equ 40h         ; capture output
emheath equ 20h         ; emulate heath
havtt   equ 10h         ; have translate table
trnctl  equ 08h         ; translate control chars
modoff  equ 04h         ; mode line off
lnwrap  equ 02h         ; auto-wrap long lines
lclecho equ 01h         ; local echo

;
; Note well. The following segment references are in THIS file to provide
; the desired ordering of them in memory. To wit: lowest addresses for
; 'code', followed by 'cstack', and only then by 'datas'. The code below
; causes the assembler to encounter the segments in this desired order. It
; may output them in either order-of-encounter or alphabetically (since they
; are forced to be synonymous); and it allows the linker to place them in
; either its order-of-encounter or alphabetically.  If you are in doubt as to
; what your utilities do then ask the linker for a memory map and ensure the
; order is as stated above. Joe R. Doupnik 26 Dec 1985. [jrd]

code    segment public 'code'
code    ends
cstack  segment para stack 'stack'
cstack  ends
datas   segment public 'datas'
datas   ends
        .list
                                                                                                                           