10	EXTEND
20	! PROGRAM TO PERFORM A SHORT-FORM SHOW ACCOUNT FOR GENERAL USERS &
	&
	INDEX%=0% &
	\ CURDAT%=PEEK(512%) &
	! SET UP INITIAL CONDITIONS &

30	GOSUB 10000 &
	\ GOTO 40 IF PROJ%+PROG%=0% &
	\ PRINT "[";MID(NUM1$(PROJ%+1000%),2%,3%);","; &
	    MID(NUM1$(PROG%+1000%),2%,3%);"]  ";ACTNAM$; &
	    SPACE$(16%-LEN(ACTNAM$));EXPDAT$; &
	\ PRINT SPACE$(11%-LEN(EXPDAT$));"(";MID(NUM1$(EXPDAY%+10000%),2%,4%); &
	    ")"; IF EXPDAY%>0% &
	\ PRINT &
	\ INDEX%=INDEX%+1% &
	\ GOTO 30 &
	! LOOK UP NEXT ACCOUNT &
	! IF NONE, EXIT &
	! ELSE PRINT THE PARTICULARS &
	! AND LOOP &

40	PRINT "End of listing." &
	\ GOTO 32767 &
	! THAT'S ALL, FOLKS... &

10000	! Function to return next account on disk, account name, &
	! expiration date, and number of days since expiration. &
	! Data passed: &
	! INDEX%	Index of account to retrieve - start at 0% &
	!		and increment on each successive call &
	! CURDAT%	Current date (from PEEK(512%)) - passed to &
	!		remain static at midnight &
	! Data returned: &
	! PROJ%, PROG%	Project and programmer number for account - set &
	!		to 0,0 if no more accounts &
	! ACTNAM$	Account name (or <no name> if none &
	! EXPDAT$	Expiration date, or NOEXPIRE, or EXPIRED, &
	!		or NOUSER if not a user account &
	! EXPDAY%	Number of days since account has expired &

10010	ON ERROR GOTO 10990 &
	! Set up local error trap &

10020	A$=SYS(CHR$(6%)+CHR$(25%)+CHR$(INDEX%)+CHR$(SWAP%(INDEX%))+ &
	    CHR$(255%)+CHR$(255%)+STRING$(16%,0%)+"SY"+STRING$(2%,0%)) &
	\ PROG%=ASCII(MID(A$,5%,1%)) &
	\ PROJ%=ASCII(MID(A$,6%,1%)) &
	! DO LOOKUP BY INDEX ON ALL ACCOUNTS ON SYSTEM DISK &

10030	ACTNAM$="<no name>" &
	\ ACTNAM$=CVT$$(MID(SYS(CHR$(6%)+CHR$(-25%)+CHR$(-1%)+CHR$(5%)+ &
	    CHR$(PROG%)+CHR$(PROJ%)+STRING$(16%,0%)+"SY"+STRING$(2%,0%)) &
	    ,8%,13%),5%) &
	! LOOK UP ACCOUNT NAME (IF PRESENT) &

10040	EXPDAT$="NOUSER" &
	\ A$=SYS(CHR$(6%)+CHR$(-25%)+CHR$(-1%)+CHR$(2%)+CHR$(PROG%)+ &
	    CHR$(PROJ%)+STRING$(16%,0%)+"SY"+STRING$(2%,0%)) &
	\ EXPDAT$="" &
	! MAKE A PASS AT PRIVS TO DETERMINE IF WE ARE A /NOUSER ACCT &

10050	EXPDAT%=SWAP%(CVT$%(MID(SYS(CHR$(6%)+CHR$(-25%)+CHR$(-1%)+CHR$(4%)+ &
	    CHR$(PROG%)+CHR$(PROJ%)+STRING$(16%,0%)+"SY"+STRING$(2%,0%)) &
	    ,19%,2%))) &
	! LOOK UP EXPIRATION DATE (IF PRESENT) &

10060	GOTO 10070 IF EXPDAT$="NOUSER" &
	\ EXPDAT$=DATE$(EXPDAT%) &
	\ EXPDAT$="NOEXPIRE" IF EXPDAT%=-1% &
	\ EXPDAT$="EXPIRED" IF EXPDAT%=1000% &
	! CONVERT DATE TO READABLE FORMAT &

10070	EXPDAY%=0% &
	\ RETURN IF EXPDAT$="NOUSER" &
	\ RETURN IF EXPDAT%=-1% &
	\ RETURN IF EXPDAT%=1000% &
	\ CYEAR%=CURDAT%/1000% &
	\ CDAY%=CURDAT%-(CYEAR%*1000%) &
	\ EYEAR%=EXPDAT%/1000% &
	\ EDAY%=EXPDAT%-(EYEAR%*1000%) &
	\ CVAL%=(CYEAR%*365%)+CDAY% &
	\ EVAL%=(EYEAR%*365%)+EDAY% &
	\ EXPDAY%=CVAL%-EVAL% &
	\ RETURN &
	! DEFAULT TO NOT EXPIRED &
	! BAIL OUT IF NOUSER, NOEXPIRE, OR EXPIRED &
	! COMPUTE NUMBER OF DAYS TO EXPIRE &

10080	PROJ%=0% &
	\ PROG%=0% &
	\ RETURN &
	! SIGNAL NO MORE ACCOUNTS &

10990	RESUME 10080 IF ERL=10020 	! NO MORE ACCOUNTS &
	\ RESUME 10040 IF ERL=10030	! NO NAME ASSOCIATED &
	\ RESUME 10060 IF ERL=10040	! NOUSER ACCOUNT &
	\ RESUME 10060 IF ERL=10050	! NOUSER ACCOUNT (BUGGY CREATE) &
	\ PRINT "ERR=";NUM1$(ERR);" ERL=";NUM1$(ERL) &
	! ERROR TRAPS &

32767	END
                                                                                                                                                                                                                                      