1	! LOAD.BAS							&
	!								&
	! AUTHOR:	Paul F. Flaherty, Jr.				&
	!		DP Manager					&
	!		DANIELS AND CRONIN				&
	!		Attorneys at Law				&
	!		Three Center Plaza				&
	!		Boston, Massachusetts  02108-2003		&
	!		(617) 227-5570					&
	!								&
	! DATE:		October 1, 1988					&
	!								&
	! DESCRIPTION:	This is a program which allows a user to load	&
	!		strings into the VT200 class terminal's 	&
	!		SHIFT-FUNCTION keys.  It has been tested under	&
	!		RSTS/E V.9.6 under Basic-Plus and CSPCOM on	&
	!		VT220's only.  It will accept all parameters	&
	!		from a CCL command, or will prompt for them.	&
	!		It does not prompt for MISSING parameters; it's	&
	!		all or nothing.					&
	!								&
	! INSTALLATION:							&
	!								&
	! Copy executable into a system account (using $ in example)	&
	! with protection code = 104					&
	!								&
	! $ _DEFINE/COMMAND/SYSTEM KEY*LOAD $LOAD.*/LINE=CCL		&
	!                          --------       ^			&
	!                             |           |			&
	! - Use anything for command--|      	  |                     &
	! - Use .* for .BAC or .TSK---------------|			&
	!								&
	! COMMAND SYNTAX:						&
	!								&
	! $ KEYLOAD key_number "quoted_string"/optional_terminator...	&
	!								&
	! Example 1: $ KEYLOAD 6 "SHOW USERS"/T				&
	! This example would make the terminal generate the string	&
	! SHOW USERS followed by a carriage return any time SHIFT-F6	&
	! is pressed.							&
	!								&
	! Example 2: $ KEYLOAD 20 "FUBAR"/T/T/T				&
	! This example would make the terminal generate the string	&
	! FUBAR followed by 3 carriage returns any time SHIFT-F20	&
	! is pressed.							&
	!								&
	! NOTES ON USE:	There are only 256 bytes of storage available	&
	! 		in a VT220 for UDK's, therefore abbreviation	&
	!		of commands is recommended.  The key definitions&
	!		will remain in effect until either they are re-	&
	!		defined, the terminal is powered off, or a hard	&
	!		terminal reset (<ESC>c) occurs.			&
	!								&
	! REFER TO THE "VT220 PROGRAMMER REFERENCE MANUAL"		&
	! (EK-VT220-RM-001) SECTION 4.15 FOR FURTHER INFORMATION	&
	! ON UDKS.							&

100	PRINT "LOAD - VT200 Function Key Definition Program Version 1.0"&
	\GOSUB 30300							&
	\ON ERROR GOTO 32000						&
	! Print banner; check to see if terminal supports UDK's; set	&
	! general error trap. This section of code does not execute on	&
	! CCL entry unless no command qualifiers are entered.		&

110	INPUT "Key (6-20) "; KEY.NUMBER.				&
		UNTIL KEY.NUMBER. >= 6. AND KEY.NUMBER. <= 20.		&
	\KEY.NUMBER. = INT(KEY.NUMBER.)					&
	!Get the key number the user wants to define.			&

200	PRINT "Definition string ";					&
	\INPUT LINE IN.STRING$						&
	\GOTO 200 IF IN.STRING$ = ""					&
	\IN.STRING$ = CVT$$(IN.STRING$,4%)				&
	! Get the string to be associated with the key.			&

300	INPUT "Terminating carriage returns (0) "; TERMINATE.COUNT%	&
	\IN.STRING$ = 'LOADKEY ' + NUM1$(KEY.NUMBER.) +			&
			' "' + IN.STRING$ + '"'				&
	\WHILE TERMINATE.COUNT%						&
	\	IN.STRING$ = IN.STRING$ + "/T"				&
	\	TERMINATE.COUNT% = TERMINATE.COUNT% - 1%		&
	\NEXT								&
	! Get the number of <CR>'s to append to the string, then	&
	! build a string that looks like a CCL command.			&

30000	REM CCL Entry Point
30010	IN.STRING$ = SYS(CHR$(7%)) IF IN.STRING$ = ""			&
	\IN.STRING$ = CVT$$(IN.STRING$,(4%+8%+16%+128%+256%))		&
	\TEMP% = INSTR(1%,IN.STRING$," ")				&
	\GOTO 100 IF TEMP% = 0%						&
	\GOSUB 30300							&
	\IN.STRING$ = RIGHT(IN.STRING$,TEMP%+1%)			&
	\QUOTE% = INSTR(1%,IN.STRING$,'"')				&
	\GOTO 30200 IF QUOTE% = 0%					&
	\QUOTE.1% = LEN(IN.STRING$) + 1%				&
	\ON ERROR GOTO 30200						&
	\QUOTE.1% = QUOTE.1%-1% UNTIL MID(IN.STRING$,QUOTE.1%,1%) = '"'	&
	\IN.STRING$ = 	CVT$$(LEFT(IN.STRING$,QUOTE%),2%+32%) +		&
			MID(IN.STRING$,QUOTE%+1%,QUOTE.1%-(QUOTE%+1%)) +&
			CVT$$(RIGHT(IN.STRING$,QUOTE.1%),2%+32%)	&
	\QUOTE% = INSTR(1%,IN.STRING$,'"')				&
	\TERMINATE% = INSTR(1%,IN.STRING$,"/T")				&
	\WHILE TERMINATE% <> 0%						&
	\	TERMINATE.COUNT% = TERMINATE.COUNT% + 1%		&
	\	TERMINATE% = INSTR(TERMINATE%+2%,IN.STRING$,"/T")	&
	\NEXT								&
	\DIM HEX$(95)							&
	\DIM KEY.VALUE$(15)						&
	\READ HEX$(X) FOR X = 1 TO 95					&
	\READ KEY.VALUE$(X) FOR X = 1 TO 15				&
	\ESC$ = CHR$(155%)						&
	\DCS$ = ESC$ + "P1;1|"						&
	\ST$ = ESC$ + "\"						&
	\CR$ = "0D"							&
	\TEMP% = ASCII(IN.STRING$)	 				&
	\GOTO 30100 IF TEMP% < 48% OR TEMP% > 57% 			&
	\TEMP% = ASCII(MID(IN.STRING$,2%,1%)) 				&
	\IF TEMP% < 48% OR TEMP% > 57%			 		&
		THEN KEY.NUMBER. = VAL(LEFT(IN.STRING$,1%))		&
		ELSE KEY.NUMBER. = VAL(MID(IN.STRING$,1%,2%))		&
	! Get core common if a CCL entry; if no parameters goto the	&
	! question and answer routine; check for a valid terminal type;	&
	! parse the command string for the key number to load, the	&
	! string to load (in quotes), and the number of /T's for a	&
	! count of the number of terminating <CR>'s to append; set up	&
	! arrays for conversion of the command string.			&

30020	IF KEY.NUMBER. < 6. OR KEY.NUMBER. > 20.			&
		THEN GOTO 30100						&
		ELSE KEY.NUMBER$ = KEY.VALUE$(KEY.NUMBER.-5.)		&
	! Verify key number between 6 and 20; convert it to the string	&
	! expected by the terminal corresponding to that function key.	&

30030	IN.STRING$ = RIGHT(IN.STRING$,QUOTE%+1%)			&
	\QUOTE% = LEN(IN.STRING$) + 1%					&
	\ON ERROR GOTO 30200						&
	\QUOTE% = QUOTE% - 1% UNTIL MID(IN.STRING$,QUOTE%,1%) = '"'	&
	\IN.STRING$ = LEFT(IN.STRING$,QUOTE%-1%)			&
	\LOAD$ = DCS$ + KEY.NUMBER$ + "/"				&
	\LOAD$ = LOAD$ + HEX$(ASCII(MID(IN.STRING$,TEMP%,1%))-31%)	&
		FOR TEMP% = 1% TO LEN(IN.STRING$)			&
	\LOAD$ = LOAD$ + CR$						&
		FOR TEMP% = 1% TO TERMINATE.COUNT%			&
	\LOAD$ = LOAD$ + ST$						&
	\PRINT LOAD$;							&
	\GOTO 32767							&
	! Get rid of the quotes surrounding the command string; convert	&
	! the ascii command string to "HEX" string (see the VT220 pro-	&
	! gramming documentation); do the actual load.			&

30100	PRINT "?Invalid key, must be 6 - 20"				&
	\GOTO 32767							&

30200	PRINT "?Quoted string expected"					&
	\GOTO 32767							&

30300	A$ = SYS(CHR$(6%)+CHR$(16%)+CHR$(1%)+CHR$(255%))		&
	\UDK% = SWAP%(CVT$%(MID(A$,25%,2%)))				&
	\RETURN IF UDK% AND 512%					&
	\PRINT "%Terminal does not support UDK's"			&
	\GOTO 32767							&
	! Verify that terminal supports UDK's				&

31000	REM Data to convert an ASCII string to a "HEX" string
31001	DATA	"20","21","22","23","24","25","26","27"
31002	DATA	"28","29","2A","2B","2C","2D","2E","2F"
31003	DATA	"30","31","32","33","34","35","36","37"
31004	DATA	"38","39","3A","3B","3C","3D","3E","3F"
31005	DATA	"40","41","42","43","44","45","46","47"
31006	DATA	"48","49","4A","4B","4C","4D","4E","4F"
31007	DATA	"50","51","52","53","54","55","56","57"
31008	DATA	"58","59","5A","5B","5C","5D","5E","5F"
31009	DATA	"60","61","62","63","64","65","66","67"
31010	DATA	"68","69","6A","6B","6C","6D","6E","6F"
31011	DATA	"70","71","72","73","74","75","76","77"
31012	DATA	"78","79","7A","7B","7C","7D","7E"
31100	REM Key associations
31101	DATA	"17","18","19","20","21","23","24","25"
31102	DATA	"26","28","29","31","32","33","34"
32000	GOTO 32767 IF ERR = 11						&
	\GOTO 32100 IF ERR <> 50					&
	\RESUME 110 IF ERL = 110					&
	\RESUME 200 IF ERL = 200					&
	\RESUME 300 IF ERL = 300					&
	! End of file and data format errors are handled; others	&
	! are just reported with line number				&

32100	PRINT "?Unexpected error "; ERR; " at line ";ERL		&

32767	END
                                          