1000    EXTEND &
! &
!       VTUDFK.BAS                                              8-May-85 &
! &
!       Program to load the VT220's user defined function keys &
! &
! &
!        Author:        W. Franklin Mitchell, Jr. &
!                       Director of Computer Services &
!                       Erskine College, Due West, South Carolina &
! &
!                       Copyright (c) 1985 &
!                       Erskine College, Due West, South Carolina &
! &
!     *********************************************************************** &
!     * This software is furnished without charge by  Erskine  College  and * &
!     * may  be  copied  only  with  the inclusion of the author's name and * &
!     * copyright notice.  No title to or ownership  of  this  software  is * &
!     * hereby transmitted.  Neither Erskine College nor the author assumes * &
!     * any responsibility for the use or reliability of this software. The * &
!     * author welcomes comments and/or  bug  reports  mailed  to  Franklin * &
!     * Mitchell,  Erskine College, Box 86, Due West, South Carolina 29639. * &
!     *********************************************************************** &
! &

1010 !  UDFK data file format.                  (<CR> = CTRL/M = ^M = RETURN) &
! &
!       Ignore the "!<tab>" on the left and the comments on the right of each &
!       of the following lines: &
! &
!       ~F20    This example  UDFK.DAT  defines  F20 as  "PRINT",  F16 &
!       PRINT   (the "Do" key)  as "RUN<CR>",  F11 as ESCape (CTRL/[), &
!       ~FDo    F12 as back space (CTRL/H), F13 as line feed (CTRL/J), &
!       RUN^M   and F6 as uparrow C <CR>. &
!       ~F11    &
!       ^[      "~Fn<CR>",  where n is a number from 6 to 20 or either &
!       ~F12    "Help" or "Do", identifies which function key is being &
!       ^H      defined.  The  next  line  contains the function key's &
!       ~F13    definition followed by <CR>.  This  <CR>  is  not part &
!       ^J      of the function key's definition.   Control characters &
!       ~F6     can  be  entered  as ^c where c is a UPPER CASE letter &
!       _^C^M   A-Z, "[", "\", "^", or "_".  The underscore is used to &
!       ~FEND   quote  the  uparrow character (see F6).  The last line &
!               in the UDFK file must be "~FEND<CR>". &

1020    DIM HEX.CHR$(15) &

1040    ON ERROR GOTO 2000 &
\       ESC$ = CHR$(155%) &
\       PRINT ESC$; "[H"; ESC$; "[J" &
\       PRINT "VT220 function key defining program  V1.0"; &
\       PRINT TAB(54%); TIME$(0%); TAB(68%); DATE$(0%) &
\       PRINT &
\       PRINT "Your terminal must be in VT220 mode (7 "; &
\       PRINT "or 8 bit) in order for this program to" &
\       PRINT "work properly." &
\       HEX.CHR$(X%) = NUM1$(X%) FOR X% = 0% TO 9% &
\       HEX.CHR$(X%) = CHR$(55% + X%) FOR X% = 10% TO 15% &
\       UDFK.TOTAL% = 0% &
\       IN%  = 1% &
\       OUT% = 2% &
\       DCS$ = ESC$ + "P" &
\       ST$  = ESC$ + "\" &

1100    PRINT &
\       PRINT "VT220 User Defined Function Key definition file <UDFK.DAT>"; &
\       INPUT LINE UDFK.FILE$ &
\       UDFK.FILE$ = CVT$$(UDFK.FILE$, 38%) &
\       UDFK.FILE$ = "UDFK.DAT" IF LEN(UDFK.FILE$) = 0% &
\       OPEN UDFK.FILE$ FOR INPUT AS FILE IN%, MODE 8192% &

1120    OPEN "KB:" FOR OUTPUT AS FILE OUT%, MODE 4% &

1140    PRINT &
\       PRINT "Do you want to clear all previously defined UDFKs <N>"; &
\       INPUT LINE CLEAR$ &
\       CLEAR$ = LEFT( CVT$$(CLEAR$, 38%), 1%) &
\       CLEAR$ = "N" IF LEN(CLEAR$) = 0% &
\       IF CLEAR$ = "Y" &
           THEN &
                PRINT #OUT%, DCS$; "0;1|"; ST$; &
           ELSE &
                GOTO 1140 IF CLEAR$ <> "N" &

1160    INPUT LINE #IN%, L$ &
\       GOTO 5000 IF LEFT(L$, 2%) <> "~F" &
\       PRINT &

1200    X$ = "" &
\       F$ = CVT$$( RIGHT(L$, 3%), 38%) &
\       F$ = "15" IF ASCII(F$) = ASCII("Help") &
\       F$ = "16" IF ASCII(F$) = ASCII("Do") &
\       F% = VAL(F$) &
\       PRINT #OUT%, USING "Key f##", F%; &
\       IF F% >= 6% AND F% <= 10% &
           THEN &
                FKEY$ = NUM1$(F% + 11%) &
           ELSE &
        IF F% >= 11% AND F% <= 14% &
           THEN &
                FKEY$ = NUM1$(F% + 12%) &
           ELSE &
        IF F% >= 15% AND F% <= 16% &
           THEN &
                FKEY$ = NUM1$(F% + 13%) &
           ELSE &
        IF F% >= 17% AND F% <= 20% &
           THEN &
                FKEY$ = NUM1$(F% + 14%) &
           ELSE &
                5000 &

1300    INPUT LINE #IN%, L$ &
\       GOTO 1400 IF LEFT(L$, 2%) = "~F" &
\       X% = 0% &

1320    X% = INSTR(X% + 1%, L$, "^") &
\       GOTO 1360 IF X% = 0% &
\       IF MID(L$, X% - 1%, 1%) = "_" &
           THEN &
                L$ = LEFT(L$, X% - 2%) + RIGHT(L$, X%) &
           ELSE &
                L$ = LEFT(L$, X% - 1%) &
                        + CHR$( ASCII(MID(L$, X% + 1%, 1%)) AND 31% ) &
                        + RIGHT(L$, X% + 2%)
1340 GOTO 1320 &

1360    X$ = X$ + L$ &
\       GOTO 1300 &

1400    UDFK.TOTAL% = UDFK.TOTAL% + LEN(X$) &
\       IF UDFK.TOTAL% > 256% &
           THEN &
                PRINT &
        \       PRINT "?UDFKs exceed maximum of 256 bytes." &
        \       GOTO 8000 &

1420    PRINT #OUT%, DCS$; "1;1|"; FKEY$; "/"; &
\       TXT% = LEN(X$) - 2% &
! &
!       TXT% is the length of the UDFK text (minus the CR LF) &

1440 FOR X% = 1% TO TXT% &
\       CHR% = ASCII(RIGHT(X$, X%)) &
\       HI%  = CHR%/16% &
\       LOW% = CHR% AND 15% &
\       PRINT #OUT%, HEX.CHR$(HI%); HEX.CHR$(LOW%);
1460 NEXT X% &
\       PRINT #OUT%, ST$; &
\       PRINT #OUT%, " defined." &
\       GOTO 1200 IF LEFT(L$, 5%) <> "~FEND" &

1500    PRINT &
\       PRINT "Do you want to lock all UDFKs <N>"; &
\       INPUT LINE LOCK$ &
\       LOCK$ = LEFT( CVT$$(LOCK$, 38%), 1%) &
\       LOCK$ = "N" IF LEN(LOCK$) = 0% &
\       IF LOCK$ = "N" &
           THEN &
                8000 &
           ELSE &
                GOTO 1500 IF LOCK$ <> "Y" &
        \       PRINT #OUT%, DCS$; "1;0|"; ST$; &
        \       GOTO 8000 &

2000    PRINT IF CCPOS(0%) &
\       PRINT &
\       RESUME 3000 IF (ERR = 5% OR ERR = 2% OR ERR = 6%) AND ERL = 1100% &
\       RESUME 4000 IF ERL = 1200% &
\       RESUME 5000 IF ERR = 11% AND (ERL = 1160% OR ERL = 1300%) &
\       RESUME 8000 IF ERR = 11% &
\       GOTO 8000 &

3000    PRINT "%Can't find UDFK file "; '"'; UDFK.FILE$; '".  Try again:' &
\       GOTO 1100 &

4000    PRINT '?Missing "~FEND" at end of UDFK file.' &
\       GOTO 8000 &

5000    PRINT &
\       PRINT "?UDFK file does not have proper syntax." &

8000    CLOSE IN%, OUT% &
\       ON ERROR GOTO 0 &

32767   END
                                                                                                                                                                                                                                                                                                                                                             