1	EXTEND
10	! S W A P C A &
	! &
	! This is one of two programs that demonstrates the use of the RSTS/E &
	! swap console SYS call.  This program spawns SWAPCD detached under &
	! the same account.  Both programs open some files, including the &
	! console terminal.  They simply loop when attached, asking for a &
	! command.  When the word SWAP is entered, they do a swap console &
	! SYS call and switch with the other job.  SWAPCA puts its job number &
	! in core common as the first two bytes before spawning SWAPCD. &
	! &
	! Note that there is no error checking. &

100	DIM SYS.DATA%(30) &

1000	OPEN "KB:" AS FILE 1% &
\	OPEN "SWAPCA.IN" FOR INPUT AS FILE 2% &
\	OPEN "SWAPCA.OUT" FOR OUTPUT AS FILE 3% &
\	CHR.6$ = CHR$ (6%) &
	! Open some files and the console terminal &

1010	SYS.INFO$ = SYS (CHR.6$ + CHR$(26%)) &
\	CHANGE SYS.INFO$ TO SYS.DATA% &
\	CURRENT.JOB% = SYS.DATA%(1%) / 2% &
\	WORK$ = SYS (CHR$(8%) + CHR$(CURRENT.JOB%)) &
\	SYS.INFO$ = SYS(CHR.6$ + CHR$(-10%) + "SWAPCD.BAC") &
\	FILE.NAME$ = MID (SYS.INFO$,7%,12%) &
\	DEVICE.SPEC$ = MID (SYS.INFO$,23%,26%) &
\	SYS.INFO$ = SYS(CHR.6$ + CHR$(24%) + CHR$(64%) + STRING$(3%,0%) + &
		FILE.NAME$ + STRING$(8%,0%) + DEVICE.SPEC$) &
\	CHANGE SYS.INFO$ TO SYS.DATA% &
\	OTHER.JOB.NUMBER% = SYS.DATA%(3%) / 2% &
	! Get the current job number, put in core common for the spawned job &
	! along with the keyboard number, spawn logged in and detached. &

1020	WHILE 1 = 1 &
\		SLEEP 5% &
\		SYS.INFO$ = SYS(CHR.6$ + CHR$(26%)) &
\		CHANGE SYS.INFO$ TO SYS.DATA% &
\		KEYBOARD.NUMBER% = SYS.DATA%(4%) &
\		GOSUB 2000 IF (KEYBOARD.NUMBER% AND 128%) = 0% &
\		NEXT &
	! Check to see whether we are attached each time through the loop. &
	! If attached, get a command. &

2000	PRINT #1%, "Enter command: "; &
\	INPUT LINE #1%, COMMAND$ &
\	IF LEFT(COMMAND$,4%) = "SWAP" &
	  THEN &
		PRINT "Swapping with job"; OTHER.JOB.NUMBER% &
\		WORK$ = SYS (CHR.6$ + CHR.6$ + CHR$(OTHER.JOB.NUMBER%) + &
			CHR$(1%)) &
\		GOTO 2020 &
	! Get a command and swap console if requested. &

2010	IF LEFT(COMMAND$,4%) = "EXIT" &
	  THEN &
		CLOSE #1%, #2%, #3% &
\		WORK$ = SYS (CHR.6$ + CHR$(8%) + CHR$(OTHER.JOB.NUMBER%) + &
			STRING$ (24%,0%) + CHR$(255%)) &
\		GOTO 32766 &
	! If command is EXIT, close files and kill the other job. &

2020	RETURN &

32766	NO EXTEND
32767	END
                                                                                                                                                                       