$! TMPPRV.COM - Display programs with temporary privilege <124+64+...>
$!
$!	P1 = filespec (wildcards allowed)
$!
$
$! define the defaults
$	dflt = "_SY:''f$user'*.*"
$
$! prompt if p1 not specified
$	_if p1 .eqs. "" then -
		_inquire p1 "Files <''dflt'>"
$
$ 	junk = f$parse(p1,,"FLAGS")		! Check to see if file is valid
$ 	_if junk .eq. -1 then -
		_write 0 "?File ''p1' is invalid"
$						! if not, exit
$
$	p3 = "                              "	! define some blanks
$	p4 = f$len(p3)				! count 'em
$	p1 = f$parse(p1,dflt)			! Fill in the defaults
$	files = 0				! init file counter
$	p2 = f$search(p1)			! find first match
$
$LOOP:
$
$	_if p2 .eqs. "" then -
		_goto exit			! exit if no more files
$
$
$	_ccl DCLSYS 6 -10 "''p2'"			!FSS the filespec
$	_ccl DCLSYS 6 17 2*255 'f$mid(SYS,17,32)' 10*0 'f$mid(SYS,89,16)'
$						!lookup file by name
$	prot = +f$mid(SYS,57,3)			!get prot code
$	if (prot .and. 128) .eq. 0 then _goto NEXT_FILE
$						! skip if not priv'd file
$
$	if files .eq. 0 then _gosub HEADING	! display heading if 1st file
$
$	_write 0 f$left("''p2'''p3'",p4),"<''prot'>"
						! display filespec & prot code
$	files = files + 1			! increment file counter
$
$NEXT_FILE:
$	p2 = f$search("")			! get next file
$	_goto LOOP				! and do again
$
$EXIT:
$	_if files .eq. 0 then -
		_goto NOFILES			! skip if no files found
$	_write 0 ""				! skip a line
$	_write 0 "Total files: ''files'"	! display file count
$	_exit					! all done
$
$NOFILES:
$	_write 0 "%No files ''p1' found"	! display warning
$	_exit					! all done
$
$HEADING:
$	_write 0 f$left("File''p3'",p4), "Prot"
$	_write 0 f$left("----''p3'",p4), "----"
$	_return
                                                                                                                                                                                                                                                                                                                                                       