/* File msdlat.c */
 
/*
  stdin/stdout filter for displaying 8-bit Latin Alphabet 1 files from UNIX
  in the 7-bit environment on a DEC VT320 or compatible terminal, or with
  PC software (such as MS-DOS Kermit 3.0) that emulates one, by (a) sending
  the escape sequence that assigns the Latin-1 character set to G1, and
  (b) sends Shift-In/Shift-Out codes around sequences of GR (8-bit) characters.
 
  Usage:  msdlat < file
     Or:  command | msdlat
 
  Author: F. da Cruz, Columbia University, 1990
*/
#include <stdio.h>
 
main() {
    int i = 0;                          /* Working variable */
    int state = 0;                      /* Current state: 7- or 8-bit output */
    unsigned char c;                    /* Character holder */
    char *latin1 = "\033-A";            /* ISO Latin-1 designating sequence */
 
    printf("%s", latin1);               /* Assign Latin-1 to G1 */
 
    while (1) {                         /* Loop per character. */
        i = getchar();                  /* Get a character. */
        if (i == EOF) exit(0);          /* If no more, done. */
        c = i;                          /* Convert to character form. */
        if (c > 127) {                  /* If it's an 8-bit character */
            if (state == 0) {           /* and we were doing 7-bit chars, */
                state = 1;              /* Change state, */
                putchar('\16');         /* and send a Shift-Out code. */
            }
        } else {                        /* Otherwise it's 7-bit character */
            if (state == 1) {           /* If we were in 8-bit state */
                putchar('\17');         /* Send a Shift-In */
                state = 0;              /* and change to 7-bit state. */
            }
        }
        putchar(c & 127);               /* Send the character's low 7 bits */
    }
}
                                                                                                                                                          