# File MSVIBM.MKB.
#
# Makefile for MS-DOS Kermit on IBM PC and PS2 families.
# For use with Borland's TAsm 1.0, TLink 1.0 and Make 1.0.
# Adapted from the version for Microsoft's Make version 4.00.
# Usage: "make -fmsvibm.mkb" with all source files in current directory.
# Or rename MSVIBM.MKB to MAKEFILE and simply call as "make".
#
# If the additional parameter MSVIBM.BOO is specified, then the boo
# encoding of the exe file is produced, too, using MSBMKB from the
# Kermit distribution.
#
# Written by Joe R. Doupnik.
# Adapted for Borland's Make by Gisbert W.Selke <RECK@DBNUAMA1.BITNET>.
# Most of the blank lines are mandatory.
 
msvibm.exe:     msscmd.obj msscom.obj mssfil.obj mssker.obj mssrcv.obj\
                mssscp.obj msssen.obj mssser.obj mssset.obj msssho.obj\
                msster.obj msgibm.obj msuibm.obj msxibm.obj msyibm.obj\
                mszibm.obj
        TLINK  @msvibm.lnk
 
# This rule must be the first one.
# Do the items above when Kermit is rebuilt.  Notice the use of a command
# file for TLink because the list of object files is too long for one line.
# A sample command file MSVIBM.LNK
#
# msscmd+msscom+mssfil+mssker+mssrcv+mssscp+msssen+mssser+
# mssset+msssho+msster+msgibm+msuibm+msxibm+msyibm+mszibm
# msvibm;
 
# The inference macro below calls TASM to create .obj modules.
.asm.obj:
        TASM  $*.asm;
 
# These are the dependency relations (.obj depends on .asm and .h):
# First, the system independent files for Kermit-MS.
 
# Make this     using TASM on these two files if either has changed
 
msscmd.obj:     msscmd.asm mssdef.h
 
msscom.obj:     msscom.asm mssdef.h
 
mssfil.obj:     mssfil.asm mssdef.h
 
mssker.obj:     mssker.asm mssdef.h
 
mssrcv.obj:     mssrcv.asm mssdef.h
 
mssscp.obj:     mssscp.asm mssdef.h
 
msssen.obj:     msssen.asm mssdef.h
 
mssser.obj:     mssser.asm mssdef.h
 
mssset.obj:     mssset.asm mssdef.h
 
msssho.obj:     msssho.asm mssdef.h
 
msster.obj:     msster.asm mssdef.h
 
# These are the system dependent modules for the IBM PC. Use with the
# appropriate TLink command file msvibm.lnk.
 
msgibm.obj:     msgibm.asm mssdef.h
 
msuibm.obj:     msuibm.asm mssdef.h
 
msxibm.obj:     msxibm.asm mssdef.h
 
msyibm.obj:     msyibm.asm mssdef.h
 
mszibm.obj:     mszibm.asm mssdef.h
 
# The following is executed only if MSVIBM.BOO was specified
# on the command line:
 
msvibm.boo:     msvibm.exe
        msbmkb msvibm.exe msvibm.boo
 
# End of Kermit Make file for IBM PC family.
   