19999	!--------------------------------------------------------------&
	!	The following software is provided to any interested   &
	!	party for non-profit use by:                           &
	!                                                              &
	!		Ken Harris                                     &
	!		UNICO, Inc.                                    &
	!		3725 Nicholson Road                            &
	!		Franksville, WI  53126                         &
	!		(414) 886-5678                                 &
	!                                                              &
	!	Neither Ken Harris, UNICO, or anyone else accept any   &
	!	responsibility for damages resulting from the use or   &
	!	abuse of this software. Nor is there any committment   &
	!	to support this software.                              &
	!                                                              &
	!	However, any  comments or suggestions regarding this   &
	!	software would be more than welcome.                   &
	!                                                              &
	!--------------------------------------------------------------&

20000	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! &
	!!								!! &
	!!								!! &
	!!		PROGRAM LIBRARY FUNCTIONS			!! &
	!!								!! &
	!!								!! &
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! &
	&
	&
	&
	!!  FUNC NAME    LINE #    VER DATE    DESCRIPTION &
	&

20016	!!  FNCRT$       20180     03-06-81    INITIALIZE FOR CRT FUNCTIONS
20017	!!  FNGET$       20190     07-30-80    GET BLOCK MODE FIELD FROM KB:
20018	!!  FNCLR$       20200     10-08-80    CLEAR CRT SCREEN
20020	!!  FNMSG$       20220     04-16-80    PRINT MESSAGE ON CRT
20024	!!  FNPSN$       20260     10-08-80    POSITION CRT CURSOR
20041	!!  FNYN$        20420     04-01-81    ASK YES OR NO QUESTION
20042	!!  FNQUES       30420     04-09-81    ASK QUESTION
20099	!! &

20180	!!- - -F N C R T $- - - &
	!! &
	!! &

20182	DEF* FNCRT$(X%) &
	\	FNCRT$='' &
	\	DIM XCRT%(30%) &
	\	CHANGE SYS(CHR$(6%)+CHR$(16%)+CHR$(0%)+CHR$(255%)) TO XCRT% &

20184		ALARM$=CHR$(7%) &
	\	ESC$  =CHR$(27%) &
	\	XESC$ =CHR$(155%) &
	\	IF XCRT%(11%) <> 255% THEN &
			CRT%=0% &
		ELSE &
		IF XCRT%(6%)=128% THEN &
			CRT%=1% &
		ELSE &
			CRT%=2% &

20186		KB%=X% &
	\	OPEN 'KB:' AS FILE KB%, MODE 8% &
\	FNEND &

20190	&
	!!- - -F N G E T $ - - - &
	!! &
	!!     GET BLOCK MODE FIELD FROM KB: &
	!! &
	!!     XVT% = VERTICAL POSITION &
	!!     XHT% = HORIZONTAL POSITION &
	!!     XSIZ%= SIZE OF FIELD &
	!! &

20192	DEF* FNGET$(XVT%,XHT%,XSIZ%) &
	\	X$ = SYS(CHR$(11%)) &
	\	X$ = FNPSN$(XVT%,XHT%) &
	\	PRINT #KB%, SPACE$(XSIZ%); &
	\	X$ = FNPSN$(XVT%,XHT%) &
	\	PRINT #KB%,RECORD 256%,CHR$(0%+XSIZ%); &
	\	GET #KB% &
	\	IF RECOUNT < 2% THEN &
			FIELD #KB%,0% AS XMSG$,1% AS XDLM$ &
		ELSE &
			FIELD #KB%, RECOUNT-2% AS FILLER$,1% AS XDLM$ &
		\	IF ASCII(XDLM$) > 27% THEN &
				FIELD #KB%, RECOUNT-1% AS XMSG$,1% AS XDLM$ &
			ELSE &
				FIELD #KB%, RECOUNT-2% AS XMSG$,1% AS XDLM$ &

20194		XDELIM$=XDLM$+'' &
	\	FNGET$=CVT$$(XMSG$,32%)
20195	FNEND &

20200	&
	!!- - -F N C L R $- - - &
	!! &
	!!     CLEAR CRT SCREEN &
	!! &

20202	DEF* FNCLR$ &
	\	FNCLR$='' &
	\	IF CRT%=1% THEN &
			PRINT #KB%,XESC$+'<'+XESC$+'[2J'+XESC$+'[H'; &
		ELSE &
		IF CRT%=2% THEN &
			PRINT #KB%,CHR$(140%);
20204	FNEND &

20220	&
	!!- - -F N M S G $- - - &
	!! &
	!!     PRINT MESSAGE ON CRT &
	!! &

20222	DEF* FNMSG$(XVT%, XHT%, XMSG$) &
	\	PRINT #KB% IF CRT%=0% &
	\	XX$ = FNPSN$(XVT%, XHT%) &
	\	PRINT #KB%,XMSG$; &
\	FNEND &

20260	&
	!!- - -F N P S N $- - - &
	!! &
	!!     CRT CURSOR ADDRESS FUNCTION &
	!! &
	!!     XVT% = VERTICAL POSITION &
	!!     XHT% = HORIZONTAL POSITION &
	!! &

20262	DEF* FNPSN$(XVT%,XHT%) &
	\	FNPSN$='' &
	\	GOTO 20265 IF (XVT% < 1%) OR (XVT% > 24%) &
	\	GOTO 20265 IF (XHT% < 1%) OR (XHT% > 80%) &
	\	IF CRT%=0% THEN &
			PRINT #KB%,TAB(XHT%); &
		ELSE &
		IF CRT%=1% THEN &
			PRINT #KB%,XESC$+'['+CVT$$(NUM$(XVT%)+';'+NUM$(XHT%),2%)'H';
20264		IF CRT%=2% THEN &
			XVT% =XVT% - 1% &
		\	XHT% =XHT% - 1% &
		\	XHT2%=XHT% - FIX(XHT% / 10%) * 10% &
		\	XHT% =FIX(XHT% / 10%) * 16 + XHT2% &
		\	PRINT #KB%,CHR$(11%)+CHR$(XVT%+160%)+CHR$(16%)+CHR$(XHT%+128%);
20265	FNEND
20420

	!!- - -F N Y N $  (ASK YES OR NO QUESTION)- - -

20422	DEF* FNYN$(XQUES$)

	\	M$ = FNMSG$(23%,20%,XQUES$+' (Y/N) ?')

	\	X$ = ''

	\	X$ = FNGET$(23%,30%+LEN(XQUES$),1%) UNTIL X$='Y' OR X$='N'

	\	M$ = FNMSG$(23%,20%,SPACE$(15%+LEN(XQUES$)))

	\	FNYN$=X$

\	FNEND

20430

	!!- - -F N Q U E S $ (ASK A QUESTION)- - -

20432	DEF* FNQUES$(XQUES$,XSIZE%)

	\	M$      = FNMSG$(23%,20%,XQUES$+' ? ')

	\	FNQUES$ = FNGET$(23%,25%+LEN(XQUES$),XSIZE%)

	\	M$      = FNMSG$(23%,20%,SPACE$(5%+LEN(XQUES$)+XSIZE%))

\	FNEND

32767	END
